//================================================================================
#include "bl08p122.h"
#include "main.h"
#include "hs6220.h"
#include "user.h"
//#include <intrins.h>
//================================================================================

//================================================================================
//	
//--------------------------------------------------------------------------------
#define	rf_csn_pin_att(x)		p_spi_csn_att = x
#define	rf_sck_pin_att(x)		p_spi_clk_att = x
#define	rf_mosi_pin_att(x)		p_spi_mosi_att = x
#define	rf_irq_pin_att(x)		p_spi_irq_att = x

#define	rf_csn_pin_status(x)	p_spi_csn = x
#define	rf_sck_pin_status(x)	p_spi_clk = x
#define	rf_mosi_pin_status(x)	p_spi_mosi = x

#define	rf_mosi_pin_puph(x)		p_spi_mosi_puph = x
#define	rf_irq_pin_puph(x)		p_spi_irq_puph = x
//================================================================================
//	
//--------------------------------------------------------------------------------
void rf_spi_init(void)
{
// SPI_CSN  -- PB0		output high
// SPI_SCK  -- PB1		output low
// SPI_MOSI -- PB2		input pull high
// RF_IRQ   -- PB3		input pull high
	
	rf_csn_pin_att(0);
	rf_sck_pin_att(0);
	rf_mosi_pin_att(1);
	rf_irq_pin_att(1);
	
	rf_csn_pin_status(1);
	rf_sck_pin_status(0);
	
	rf_mosi_pin_puph(0);
	rf_irq_pin_puph(0);
}
//================================================================================
void spi_delay(void)
{
#asm
	nop
	nop
	nop
#endasm
}
//--------------------------------------------------------------------------------
// 3SPIд
void spi_wire_byte(unsigned char wdata)
{	//SPI дһBYTE
	unsigned char i;
	unsigned char bit_data;
	
//	RF_MOSIΪ
	rf_mosi_pin_puph(1);
	rf_mosi_pin_att(0);
	spi_delay();	
	for(i=0; i<8; i++) 
	{
		bit_data = wdata & 0x80;
		rf_sck_pin_status(0);
		if(bit_data)
		{
			rf_mosi_pin_status(1);
		}
		else
		{
			rf_mosi_pin_status(0);
		}
		wdata <<= 1;
		rf_sck_pin_status(1);
	}
	rf_mosi_pin_status(0);
	rf_sck_pin_status(0);
	spi_delay();
//	RF_MOSIΪ
	rf_mosi_pin_att(1);
	rf_mosi_pin_puph(0);
}
//--------------------------------------------------------------------------------
// 3SPI
unsigned char spi_read_byte(void)
{	//SPI һBYTE
	unsigned char i;
	unsigned char tmp = 0;
	
	for(i=0; i<8; i++)
	{
		tmp <<= 1;
		rf_sck_pin_status(1); 
		if(p_spi_mosi)
		{
			tmp |= 0x01;
		} 
		else
		{
			tmp &= ~0x01;
		}       
		rf_sck_pin_status(0);              
	}

	return tmp;
}
//================================================================================
//	
//--------------------------------------------------------------------------------
void rf_write_reg(unsigned char addr, unsigned char wdata)
{	//Ĵַдһֵ
	rf_csn_pin_status(0);
	spi_wire_byte(HS6220_W_REGISTER | addr);
	spi_wire_byte(wdata);
	rf_csn_pin_status(1);
}
//--------------------------------------------------------------------------------
void rf_wr_buffer(unsigned char addr,const unsigned char* buf,unsigned char len)
{	//Ĵַдֵ
	rf_csn_pin_status(0);
	spi_wire_byte(HS6220_W_REGISTER | addr);
	while(len--)
	{
		spi_wire_byte(*buf++);
	}
	rf_csn_pin_status(1);
}
//--------------------------------------------------------------------------------
unsigned char rf_read_reg(unsigned char addr)
{	//Ĵֵ(һ)
	unsigned char rxdata;
	
	rf_csn_pin_status(0);
	spi_wire_byte(HS6220_R_REGISTER | addr);
	rxdata = spi_read_byte();
	rf_csn_pin_status(1);
	
	return(rxdata);
}
//--------------------------------------------------------------------------------
void rf_read_buffer(unsigned char addr, unsigned char* buf, unsigned char len)
{	//Ĵֵ()
	rf_csn_pin_status(0);
	spi_wire_byte(HS6220_R_REGISTER | addr);
	
	while(len--)
	{
		*buf ++ = spi_read_byte();
	}
	rf_csn_pin_status(1);
}
//--------------------------------------------------------------------------------
void rf_write_opt(unsigned char opt)
{	//ֱд
	rf_csn_pin_status(0);
	spi_wire_byte(opt);
	rf_csn_pin_status(1);
}
//--------------------------------------------------------------------------------
void rf_write_cmd(unsigned char cmd, unsigned char wdata)
{	//дĴ
	rf_csn_pin_status(0);
	spi_wire_byte(cmd);
	spi_wire_byte(wdata);
	rf_csn_pin_status(1);
}
//================================================================================
//	
//--------------------------------------------------------------------------------
void rf_clear_irq(void)
{	//жϱ־
	rf_write_reg(HS6220_BANK0_STATUS, 0x70);
}
//--------------------------------------------------------------------------------
void rf_flush_tx(void)
{	//TX FIFO
	rf_write_opt(HS6220_FLUSH_TX);
}
//--------------------------------------------------------------------------------
void rf_flush_rx(void)
{	//RX FIFO
	rf_write_opt(HS6220_FLUSH_RX);
}
//--------------------------------------------------------------------------------
void rf_ce_high(void)
{	//CE
	rf_write_opt(HS6220_CMD_CE_HIGH);;
}
//--------------------------------------------------------------------------------
void rf_ce_low(void)
{	//CE
	rf_write_opt(HS6220_CMD_CE_LOW);
}
//--------------------------------------------------------------------------------
unsigned char rf_read_payload_length(void)
{	//ȡյݰ
	return rf_read_reg(HS6220_R_RX_PL_WID);
}
//================================================================================
//	
//--------------------------------------------------------------------------------
void rf_bank_switch(RF_BANK_TYPEDEF bank)
{	//лBANK
	unsigned char sta;
	
	sta = rf_read_reg(HS6220_BANK0_STATUS);
	sta &= RF_BANK1;
	
	if(((bank == RF_BANK0) && (sta == RF_BANK1)) ||((bank == RF_BANK1) && (sta == RF_BANK0)))
	{
		rf_write_cmd(HS6220_ACTIVATE, HS6220_ACTIVATE_DATA);
	}
}
//--------------------------------------------------------------------------------
void rf_change_rate(RF_RATE_TYPEDEF rate)
{	//л
	unsigned char tmp;
	
	tmp = rf_read_reg(HS6220_BANK0_RF_SETUP);

	if(rate == RATE_1M)
	{
		tmp &= 0xf7;
		rf_write_reg(HS6220_BANK0_RF_SETUP, tmp);
	}
	else if(rate == RATE_2M)
	{
		tmp |= 0x08;
		rf_write_reg(HS6220_BANK0_RF_SETUP, tmp);
	}
}
//--------------------------------------------------------------------------------
void rf_change_ch(unsigned char chn)
{	//лŵ
	rf_write_reg(HS6220_BANK0_RF_CH, chn);
}
//--------------------------------------------------------------------------------
void rf_change_pwr(RF_PWR_TYPEDEF pwr)
{	//л
	unsigned char tmp;

	tmp = rf_read_reg(HS6220_BANK0_RF_SETUP);
	tmp &= ~0x47;

	switch(pwr)
	{
		case PWR_8DB:
			tmp |= 0x47;
			rf_write_reg(HS6220_BANK0_RF_SETUP, tmp);
		break;

		case PWR_5DB:
			tmp |= 0x40;
			rf_write_reg(HS6220_BANK0_RF_SETUP, tmp);
		break;

		case PWR_4DB:
			tmp |= 0x07;
			rf_write_reg(HS6220_BANK0_RF_SETUP, tmp);
		break;

		case PWR_0DB:
			tmp |= 0x03;
			rf_write_reg(HS6220_BANK0_RF_SETUP, tmp);
		break;

		case PWR_N6DB:
			tmp |= 0x01;
			rf_write_reg(HS6220_BANK0_RF_SETUP, tmp);
		break;
	
		default: // ĬϾó0db
			tmp |= 0x03;
			rf_write_reg(HS6220_BANK0_RF_SETUP, tmp);
		break;
	}
}
//--------------------------------------------------------------------------------
void rf_change_addr(unsigned char *buf, unsigned char len)
{	//лַ
	rf_wr_buffer(HS6220_BANK0_RX_ADDR_P0, buf, len);
}
//--------------------------------------------------------------------------------
void rf_mode_switch(RF_MODE_TYPEDEF mod)
{
	unsigned char tmp;
	
	if(mod == RF_PRX_MODE)
	{
		tmp = rf_read_reg(HS6220_BANK0_CONFIG);
		tmp |= 0x01;
		rf_write_reg(HS6220_BANK0_CONFIG, tmp);
	}
	
	if(mod == RF_PTX_MODE)
	{
		tmp = rf_read_reg(HS6220_BANK0_CONFIG);
		tmp &= 0xFE;
		rf_write_reg(HS6220_BANK0_CONFIG, tmp);
	}
	
	if(mod == RF_CARRIER_MODE)
	{	//ز,8DB
		tmp = 0xC7;
		rf_write_reg(HS6220_BANK0_RF_SETUP, tmp);
		/* ע⣺λΪزʹλزģʽ֮CEҪߣزŻ
		   ҪлƵ㣬ʵȣͲҪȥڲRFῴزźŵ*/
		rf_ce_high();
	}
}
//================================================================================
//	
//--------------------------------------------------------------------------------
void rf_init(void)
{
	unsigned char temp[5];
	rf_spi_init();

reset_rf_init:
//RFλ	
	rf_write_reg(HS6220_BANK0_FEATURE, SOFT_RST);	 // soft_reset
//SPI3ͨѶ
	rf_write_reg(HS6220_BANK0_DYNPD, 0x00);
//RFоƬϵ磬Ϊģʽ
	rf_ce_low();	
	rf_write_reg(HS6220_BANK0_CONFIG, 0x8b); 		//ϵ
	delay_ms(3); // wait 3 ms
	rf_write_reg(HS6220_BANK0_PMU_CTL, 0xa8);		//ģʽ
	delay_ms(2);
//迪˹˲    
	rf_write_reg(HS6220_BANK0_FEATURE, 0x10);

//лBANK1
	rf_bank_switch(RF_BANK1);
//BANK1TEST_PKDET(üĴ24λ)ĵ5λΪ1
	rf_write_reg(HS6220_BANK1_TEST_PKDET, 0x20);
	
//BANK1FAGC_CTRL_1(üĴ32λ) 
//6220Ϊ߿,VCO.,ǿ˱й¶,ֲ֤ù. 
//еĽ취:СתʱVCO,תʱָԭֵ
//ʱ:CE,лBANK1,üĴ(ն300MSղݻḴλRF,ͻָԭֵ)
//	temp[2] = 0x05;
//	temp[1] = 0xa1;
//	temp[0] = 0xc1;	
//	rf_wr_buffer(HS6220_BANK1_FAGC_CTRL_1, temp, 3);
	temp[0] = 0x01;
	rf_wr_buffer(HS6220_BANK1_FAGC_CTRL_1, temp, 1);

//BANK1AGC_CTRL(üĴ24λ)
	temp[0] = 0xcf;
	temp[1] = 0xb2;
	rf_wr_buffer(HS6220_BANK1_AGC_CTRL, temp, 2);

//лBANK0
	rf_bank_switch(RF_BANK0);	
//CE40US壬RFУ׼(ĬʹУ׼(CAL_EN(bit4)1)
	rf_ce_high();
	delay_us(40);
	rf_ce_low(); //У׼ʱCEǵ͵
//ȴУ׼
	temp[0] = 35;
	while(1)
	{	//
		if(rf_read_reg(HS6220_BANK0_RF_SETUP) & 0x20)
		{	//У׼(CAL_DONE1)
			break;
		}
		delay_ms(1);
		temp[0]--;
		if(0 == temp[0])
		{
			goto reset_rf_init;
		}
	}
//رУ׼(CAL_EN(bit4)0)
	rf_write_reg(HS6220_BANK0_RF_SETUP, 0x40);

//лBANK1
	rf_bank_switch(RF_BANK1);	
//BANK1CAL_CTL(üĴ32λ)
	temp[0] = 0x20;
	temp[1] = 0x98;
	temp[2] = 0x75;
	rf_wr_buffer(HS6220_BANK1_CAL_CTL, temp, 3);

//лBANK0
	rf_bank_switch(RF_BANK0);
	
	temp[0] = D_RF_ADDR0;
	temp[1] = D_RF_ADDR1;
	temp[2] = D_RF_ADDR2;
	temp[3] = D_RF_ADDR3;
	temp[4] = D_RF_ADDR4;
//RXַ
	rf_wr_buffer(HS6220_BANK0_RX_ADDR_P0, temp, 5);
//TXַ
	rf_wr_buffer(HS6220_BANK0_TX_ADDR, temp, 5);
	
//迪˹˲,ʹ̬ܶݰ
	rf_write_reg(HS6220_BANK0_FEATURE, 0x10);
//ʹRXԶӦ
	rf_write_reg(HS6220_BANK0_EN_AA, 0x00);		//ֹRXԶӦ
//	rf_write_reg(HS6220_BANK0_EN_AA, 0x01);		//ʹRXԶӦ
//CONFIG(RX MODE : 0xFB;TX MODE : 0xFA) 	
	rf_write_reg(HS6220_BANK0_CONFIG, 0xfA);
//շݳ
	rf_write_reg(HS6220_BANK0_RX_PW_P0, D_RF_DATA_LENTH);
//շƵ
	rf_write_reg(HS6220_BANK0_RF_CH, D_RF_CHANNEL_L);
//ʹRX PIPE
	rf_write_reg(HS6220_BANK0_EN_RXADDR, 0x01);
//ʹԶش
	rf_write_reg(HS6220_BANK0_SETUP_RETR, 0);		//ֹԶش
//	rf_write_reg(HS6220_BANK0_SETUP_RETR, 0x43);	//1MSԶش4
//ù
	rf_write_reg(HS6220_BANK0_RF_SETUP, 0x47);		//(8DB)
//ʹ̬ܶݰ PIPE
	rf_write_reg(HS6220_BANK0_DYNPD, 0x07);
	
	rf_flush_tx();
	rf_flush_rx();
	rf_clear_irq();
//	rf_ce_high();	
}
//================================================================================
//	
//--------------------------------------------------------------------------------
void rf_power_down(void)
{
	unsigned char sta;
	
	//RF ˯ģʽ
	rf_write_reg(HS6220_BANK0_PMU_CTL, 0xAD);
	//ʱ1ms
	delay_ms(1);
	//rf µ
	sta = rf_read_reg(HS6220_BANK0_CONFIG);
	sta &= ~0x02;
	rf_write_reg(HS6220_BANK0_CONFIG, sta);
	delay_ms(1);
}
//--------------------------------------------------------------------------------
void rf_power_on(void)
{	// rf ϵ
	unsigned char sta;
	
	sta = rf_read_reg(HS6220_BANK0_CONFIG);
	sta |= 0x02;
	rf_write_reg(HS6220_BANK0_CONFIG, sta);
	//ʱ1ms
	delay_ms(1);
	//RF ģʽ
	rf_write_reg(HS6220_BANK0_PMU_CTL, 0xAC);
}
//================================================================================
//	
//--------------------------------------------------------------------------------
#if	D_HOP_ON
void rf_hop_channal(void)
{
	if(D_RF_CHANNEL_L == rf.chn)
	{
		rf.chn = D_RF_CHANNEL_M;
	}
	else if(D_RF_CHANNEL_M == rf.chn)
	{
		rf.chn = D_RF_CHANNEL_H;
	}
	else// if(D_RF_CHANNEL_H == rf.chn)
	{
		rf.chn = D_RF_CHANNEL_L;
	}
	
//	rf_ce_low();
	rf_change_ch(rf.chn);
//	rf_ce_high();
}
#endif
//================================================================================
//	
//--------------------------------------------------------------------------------
#if D_RF_TX
/* OM6220ݰ
  buf:Ҫ͵ݰָ 
  len:ݰĳȣ132ֽ 
  cmd: ݰHS6220_W_TX_PAYLOADHS6220_W_TX_PAYLOAD_NOACK
*/
void rf_tx_send_data(unsigned char cmd, unsigned char* buf, unsigned char len)
{	//
	//buf:	Ҫ͵ݰָ 
  	//len:	ݰĳȣ132ֽ 
  	//cmd:	ݰHS6220_W_TX_PAYLOADHS6220_W_TX_PAYLOAD_NOACK

	rf_flush_tx();
	rf_flush_rx();
	rf_clear_irq();
	rf_wr_buffer(cmd, buf, len);
	rf_ce_high();
	
	//ȴͽ
	delay_ms(1);
	rf_ce_low();
	
	//жϷǷ
//	while(0 == (rf_read_reg(HS6220_BANK0_STATUS) & HS6220_STATUS_TX_DS));
//	rf_ce_low();
}
#endif
//================================================================================
//	
//--------------------------------------------------------------------------------
#if D_RF_RX
unsigned char rf_rx_receive(unsigned char *buf)
{	//ݰ
	//buf:	ȡݴŵĵط
	//ret:	ȡ֮󣬷صǶȡݰ
	unsigned char sta;
	unsigned char len;

	sta = rf_read_reg(HS6220_BANK0_STATUS);
	if(HS6220_STATUS_RX_DR & sta)
	{
		rf.rst_int = 0;
		rf.slp_int = 0;
		
		rf_ce_low();
		
		len = rf_read_reg(HS6220_R_RX_PL_WID);
		if(len == D_RF_DATA_LENTH)
		{
			rf_read_buffer(HS6220_R_RX_PAYLOAD, buf, len);
		}
		else
		{
			len = 0;
		}
		
		//յݺ RX ״̬ FIFO, CE ȴһݵ
		rf_flush_tx();
		rf_flush_rx();
		rf_clear_irq();
		rf_ce_high();
		
		return len;
	}
	
//µĸλRFRF˯߻ѵĶǱģȱ
	if(rf.rst_int >= D_RF_RESET_CNT) // 400msûյ1ݣλRF³ʼ
	{	//RESETʱ䷶Χ300~500MS
		rf_init();
		rf_mode_switch(RF_PRX_MODE);
		rf_ce_high();
		
		rf.slp_int = 0;
		rf.rst_int = 0;
	}

	if(rf.slp_int >= D_RF_SLEEP_CNT)// 40msûյ1ݣRF˯߻һ
	{	//SLEEPʱ䷶Χ20~50MS
		rf_ce_low();
		rf_flush_rx();
		rf_clear_irq();
		
		rf_write_reg(HS6220_BANK0_PMU_CTL, 0xae);		
		delay_ms(1);// 1msʱȱ٣ҲС 
		rf_write_reg(HS6220_BANK0_PMU_CTL, 0xac);
		delay_ms(1);// 1msʱȱ٣ҲС
		rf_ce_high();
		
		rf.slp_int = 0;		
	}
//ϵĸλRFRF˯߻ѵĶǱģȱ
	
	return 0;
}
#endif
//================================================================================
//	
//--------------------------------------------------------------------------------