
#ifndef	_HTC_H_
#endif

/* header file for the MICROCHIP PIC microcontroller
 *  16C54A
 */


#ifndef __PIC18P13xl_H
#define __PIC18P13xl_H


// Special function register definitions
//
//----- BANK0 Register -----------------------------------------------------
volatile   unsigned char           INDF0               @ 0x000;
volatile   unsigned char           INDF1               @ 0x001;
volatile   unsigned char           PCL                 @ 0x002;
volatile   unsigned char           STATUS              @ 0x003;
volatile   unsigned char           FSR0L               @ 0x004; 
volatile   unsigned char           FSR0H               @ 0x005;
volatile   unsigned char           FSR1L               @ 0x006;
volatile  unsigned char            FSR1H               @ 0x007;
volatile  unsigned char            PCLATH              @ 0x008;
volatile  unsigned char            INTCON              @ 0x009;

volatile  unsigned char           TRISA               @ 0x010;
volatile  unsigned char           TRISB               @ 0x011;
volatile  unsigned char           TRISC               @ 0x012;
volatile  unsigned char           TRISF               @ 0x015;
volatile  unsigned char           PORTA               @ 0x01C;
volatile  unsigned char           PORTB               @ 0x01D;
volatile  unsigned char           PORTC               @ 0x01E;
volatile  unsigned char           PORTF               @ 0x021;
volatile  unsigned char           WPUA                @ 0x028;
volatile  unsigned char           WPUB                @ 0x029;
volatile  unsigned char           WPUC                @ 0x02A;
volatile  unsigned char           WPUF                @ 0x02D;
volatile  unsigned char           WPDA                @ 0x034;
volatile  unsigned char           WPDB                @ 0x035;
volatile  unsigned char           WPDC                @ 0x036;
volatile  unsigned char           WPDF                @ 0x039;
volatile  unsigned char           IOCA                @ 0x040;
volatile  unsigned char           IOCB                @ 0x041;
volatile  unsigned char           IOCC                @ 0x042;
volatile  unsigned char           IOCF                @ 0x045;
volatile  unsigned char           PORCTR              @ 0x04C;
volatile  unsigned char           DRENAL                @ 0x04D;
volatile  unsigned char           DRENBL                @ 0x04E;
volatile  unsigned char           DRENCL                @ 0x04F;
volatile  unsigned char           DRENFL                @ 0x052;
volatile  unsigned char           PIR1                @ 0x054;
volatile  unsigned char           PIR2                @ 0x055;
volatile  unsigned char           PIR3                @ 0x056;
volatile  unsigned char           T1L                 @ 0x058;
volatile  unsigned char           T1H                 @ 0x059;
volatile  unsigned char           T1CON               @ 0x05A;
volatile  unsigned char           T0                  @ 0x05B;
volatile  unsigned char           T2                  @ 0x05C;
volatile  unsigned char           PR2                 @ 0x05D;
volatile  unsigned char           T2CON               @ 0x05E;
volatile  unsigned char           PR1L                @ 0x05F;
volatile  unsigned char           PR1CON              @ 0x060;
volatile  unsigned char           PIE1                @ 0x070;
volatile  unsigned char           PIE2                @ 0x071;
volatile  unsigned char           PIE3                @ 0x072;
volatile  unsigned char           OPTION              @ 0x078;
volatile  unsigned char           PCON                @ 0x079;
volatile  unsigned char           OSCCON              @ 0x07A;
volatile  unsigned char           CCPR2L              @ 0x080;
volatile  unsigned char           CCPR2H              @ 0x081;
volatile  unsigned char           CCP2CON             @ 0x082;
volatile  unsigned char           CCPR1L              @ 0x083;
volatile  unsigned char           CCPR1H              @ 0x084;
volatile  unsigned char           CCP1CON             @ 0x085;
volatile  unsigned char           ANSELL              @ 0x08C;
volatile  unsigned char           ANSELH              @ 0x08D;
volatile  unsigned char           ADRESL              @ 0x092;
volatile  unsigned char           ADRESH              @ 0x093;
volatile  unsigned char           ADCON0              @ 0x094;
volatile  unsigned char           ADCON1              @ 0x095;
volatile  unsigned char           ADCLK               @ 0x096;
volatile  unsigned char           PMDATL              @ 0x09A;
volatile  unsigned char           PMDATH              @ 0x09B;
volatile  unsigned char           PMADRL              @ 0x09C;
volatile  unsigned char           PMADRH              @ 0x09D;
volatile  unsigned char           PMCON               @ 0x09E;
volatile  unsigned char           DRENAH               @ 0x0A0;
volatile  unsigned char           DRENBH               @ 0x0A1;
volatile  unsigned char           DRENCH               @ 0x0A2;
volatile  unsigned char           DRENFH               @ 0x0A5;
volatile  unsigned char           OCCUPY18A           @ 0x18A;
//----- BANK1 Register -----------------------------------------------------
volatile  unsigned char           BRT                 @ 0x23A;
volatile  unsigned char           AUXR                @ 0x23B;
volatile  unsigned char           SCON                @ 0x023C;
volatile  unsigned char           SBUF                @ 0x23D;
volatile  unsigned char           SADEN               @ 0x23E;
volatile  unsigned char           SADDR               @ 0x23F;
volatile  unsigned char           PWM0DT             @ 0x258;
volatile  unsigned char           PWM0DL              @ 0x259;
volatile  unsigned char           PWM0DH              @ 0x25A;
volatile  unsigned char           PWM0PL              @ 0x25B;
volatile  unsigned char           PWM0PH              @ 0x25C;
volatile  unsigned char           PWM0C               @ 0x25D;
volatile  unsigned char           PWMEN               @ 0x25E;
volatile  unsigned char           FLTM                @ 0x25F;
volatile  unsigned char           LCDCON              @ 0x2B0;
volatile  unsigned char           COMAEN              @ 0x2B1;
volatile  unsigned char           COMBEN              @ 0x2B2;
volatile  unsigned char           COMCEN              @ 0x2B3;  
volatile  unsigned char           COMFEN              @ 0x2B6; 
//----- BANK1 Register -----------------------------------------------------
//----- BANK1 Register -----------------------------------------------------
// bit and bitfield definitions
volatile bit RBIF                     @ ((unsigned)&INTCON*8)+0;
volatile bit INTF                     @ ((unsigned)&INTCON*8)+1;
volatile bit T0IF                     @ ((unsigned)&INTCON*8)+2;
volatile bit RBIE                     @ ((unsigned)&INTCON*8)+3;
volatile bit INTE                     @ ((unsigned)&INTCON*8)+4;
volatile bit T0IE                     @ ((unsigned)&INTCON*8)+5;
volatile bit PEIE                     @ ((unsigned)&INTCON*8)+6;
volatile bit GIE                     @ ((unsigned)&INTCON*8)+7;
// bit and bitfield definitions
volatile bit C                     @ ((unsigned)&STATUS*8)+0;
volatile bit DC                     @ ((unsigned)&STATUS*8)+1;
volatile bit Z                     @ ((unsigned)&STATUS*8)+2;
volatile bit PD                     @ ((unsigned)&STATUS*8)+3;
volatile bit TO                     @ ((unsigned)&STATUS*8)+4;
volatile bit RP0                     @ ((unsigned)&STATUS*8)+5;

// bit and bitfield definitions
volatile bit TRISA0                     @ ((unsigned)&TRISA*8)+0;
volatile bit TRISA1                     @ ((unsigned)&TRISA*8)+1;
volatile bit TRISA2                     @ ((unsigned)&TRISA*8)+2;
volatile bit TRISA3                     @ ((unsigned)&TRISA*8)+3;
volatile bit TRISA4                     @ ((unsigned)&TRISA*8)+4;
volatile bit TRISA5                     @ ((unsigned)&TRISA*8)+5;
volatile bit TRISA6                     @ ((unsigned)&TRISA*8)+6;
volatile bit TRISA7                     @ ((unsigned)&TRISA*8)+7;
// bit and bitfield definitions
volatile bit TRISB0                     @ ((unsigned)&TRISB*8)+0;
volatile bit TRISB1                     @ ((unsigned)&TRISB*8)+1;
volatile bit TRISB2                     @ ((unsigned)&TRISB*8)+2;
volatile bit TRISB3                     @ ((unsigned)&TRISB*8)+3;
volatile bit TRISB4                     @ ((unsigned)&TRISB*8)+4;
volatile bit TRISB5                     @ ((unsigned)&TRISB*8)+5;
volatile bit TRISB6                     @ ((unsigned)&TRISB*8)+6;
volatile bit TRISB7                     @ ((unsigned)&TRISB*8)+7;
// bit and bitfield definitions
volatile bit TRISC0                     @ ((unsigned)&TRISC*8)+0;
volatile bit TRISC1                     @ ((unsigned)&TRISC*8)+1;
volatile bit TRISC2                     @ ((unsigned)&TRISC*8)+2;
volatile bit TRISC3                     @ ((unsigned)&TRISC*8)+3;
volatile bit TRISC4                     @ ((unsigned)&TRISC*8)+4;
volatile bit TRISC5                     @ ((unsigned)&TRISC*8)+5;
volatile bit TRISC6                     @ ((unsigned)&TRISC*8)+6;
volatile bit TRISC7                     @ ((unsigned)&TRISC*8)+7;

// bit and bitfield definitions
volatile bit TRISF0                     @ ((unsigned)&TRISF*8)+0;
volatile bit TRISF1                     @ ((unsigned)&TRISF*8)+1;
volatile bit TRISF2                     @ ((unsigned)&TRISF*8)+2;
volatile bit TRISF3                     @ ((unsigned)&TRISF*8)+3;
volatile bit TRISF4                     @ ((unsigned)&TRISF*8)+4;
volatile bit TRISF5                     @ ((unsigned)&TRISF*8)+5;
volatile bit TRISF6                     @ ((unsigned)&TRISF*8)+6;
volatile bit TRISF7                     @ ((unsigned)&TRISF*8)+7;
// bit and bitfield definitions
volatile bit PORTA0                     @ ((unsigned)&PORTA*8)+0;
volatile bit PORTA1                     @ ((unsigned)&PORTA*8)+1;
volatile bit PORTA2                     @ ((unsigned)&PORTA*8)+2;
volatile bit PORTA3                     @ ((unsigned)&PORTA*8)+3;
volatile bit PORTA4                     @ ((unsigned)&PORTA*8)+4;
volatile bit PORTA5                     @ ((unsigned)&PORTA*8)+5;
volatile bit PORTA6                     @ ((unsigned)&PORTA*8)+6;
volatile bit PORTA7                     @ ((unsigned)&PORTA*8)+7;
// bit and bitfield definitions
volatile bit PORTB0                     @ ((unsigned)&PORTB*8)+0;
volatile bit PORTB1                     @ ((unsigned)&PORTB*8)+1;
volatile bit PORTB2                     @ ((unsigned)&PORTB*8)+2;
volatile bit PORTB3                     @ ((unsigned)&PORTB*8)+3;
volatile bit PORTB4                     @ ((unsigned)&PORTB*8)+4;
volatile bit PORTB5                     @ ((unsigned)&PORTB*8)+5;
volatile bit PORTB6                     @ ((unsigned)&PORTB*8)+6;
volatile bit PORTB7                     @ ((unsigned)&PORTB*8)+7;
// bit and bitfield definitions
volatile bit PORTC0                     @ ((unsigned)&PORTC*8)+0;
volatile bit PORTC1                     @ ((unsigned)&PORTC*8)+1;
volatile bit PORTC2                     @ ((unsigned)&PORTC*8)+2;
volatile bit PORTC3                     @ ((unsigned)&PORTC*8)+3;
volatile bit PORTC4                     @ ((unsigned)&PORTC*8)+4;
volatile bit PORTC5                     @ ((unsigned)&PORTC*8)+5;
volatile bit PORTC6                     @ ((unsigned)&PORTC*8)+6;
volatile bit PORTC7                     @ ((unsigned)&PORTC*8)+7;

// bit and bitfield definitions
volatile bit PORTF0                     @ ((unsigned)&PORTF*8)+0;
volatile bit PORTF1                     @ ((unsigned)&PORTF*8)+1;
volatile bit PORTF2                     @ ((unsigned)&PORTF*8)+2;
volatile bit PORTF3                     @ ((unsigned)&PORTF*8)+3;
volatile bit PORTF4                     @ ((unsigned)&PORTF*8)+4;
volatile bit PORTF5                     @ ((unsigned)&PORTF*8)+5;
volatile bit PORTF6                     @ ((unsigned)&PORTF*8)+6;
volatile bit PORTF7                     @ ((unsigned)&PORTF*8)+7;
// bit and bitfield definitions
volatile bit WPUA0                     @ ((unsigned)&WPUA*8)+0;
volatile bit WPUA1                     @ ((unsigned)&WPUA*8)+1;
volatile bit WPUA2                     @ ((unsigned)&WPUA*8)+2;
volatile bit WPUA3                     @ ((unsigned)&WPUA*8)+3;
volatile bit WPUA4                     @ ((unsigned)&WPUA*8)+4;
volatile bit WPUA5                     @ ((unsigned)&WPUA*8)+5;
volatile bit WPUA6                     @ ((unsigned)&WPUA*8)+6;
volatile bit WPUA7                     @ ((unsigned)&WPUA*8)+7;
// bit and bitfield definitions
volatile bit WPUB0                     @ ((unsigned)&WPUB*8)+0;
volatile bit WPUB1                     @ ((unsigned)&WPUB*8)+1;
volatile bit WPUB2                     @ ((unsigned)&WPUB*8)+2;
volatile bit WPUB3                     @ ((unsigned)&WPUB*8)+3;
volatile bit WPUB4                     @ ((unsigned)&WPUB*8)+4;
volatile bit WPUB5                     @ ((unsigned)&WPUB*8)+5;
volatile bit WPUB6                     @ ((unsigned)&WPUB*8)+6;
volatile bit WPUB7                     @ ((unsigned)&WPUB*8)+7;
// bit and bitfield definitions
volatile bit WPUC0                     @ ((unsigned)&WPUC*8)+0;
volatile bit WPUC1                     @ ((unsigned)&WPUC*8)+1;
volatile bit WPUC2                     @ ((unsigned)&WPUC*8)+2;
volatile bit WPUC3                     @ ((unsigned)&WPUC*8)+3;
volatile bit WPUC4                     @ ((unsigned)&WPUC*8)+4;
volatile bit WPUC5                     @ ((unsigned)&WPUC*8)+5;
volatile bit WPUC6                     @ ((unsigned)&WPUC*8)+6;
volatile bit WPUC7                     @ ((unsigned)&WPUC*8)+7;

// bit and bitfield definitions
volatile bit WPUF0                     @ ((unsigned)&WPUF*8)+0;
volatile bit WPUF1                     @ ((unsigned)&WPUF*8)+1;
volatile bit WPUF2                     @ ((unsigned)&WPUF*8)+2;
volatile bit WPUF3                     @ ((unsigned)&WPUF*8)+3;
volatile bit WPUF4                     @ ((unsigned)&WPUF*8)+4;
volatile bit WPUF5                     @ ((unsigned)&WPUF*8)+5;
volatile bit WPUF6                     @ ((unsigned)&WPUF*8)+6;
volatile bit WPUF7                     @ ((unsigned)&WPUF*8)+7;
// bit and bitfield definitions
volatile bit WPDA0                     @ ((unsigned)&WPDA*8)+0;
volatile bit WPDA1                     @ ((unsigned)&WPDA*8)+1;
volatile bit WPDA2                     @ ((unsigned)&WPDA*8)+2;
volatile bit WPDA3                     @ ((unsigned)&WPDA*8)+3;
volatile bit WPDA4                     @ ((unsigned)&WPDA*8)+4;
volatile bit WPDA5                     @ ((unsigned)&WPDA*8)+5;
volatile bit WPDA6                     @ ((unsigned)&WPDA*8)+6;
volatile bit WPDA7                     @ ((unsigned)&WPDA*8)+7;
// bit and bitfield definitions
volatile bit WPDB0                     @ ((unsigned)&WPDB*8)+0;
volatile bit WPDB1                     @ ((unsigned)&WPDB*8)+1;
volatile bit WPDB2                     @ ((unsigned)&WPDB*8)+2;
volatile bit WPDB3                     @ ((unsigned)&WPDB*8)+3;
volatile bit WPDB4                     @ ((unsigned)&WPDB*8)+4;
volatile bit WPDB5                     @ ((unsigned)&WPDB*8)+5;
volatile bit WPDB6                     @ ((unsigned)&WPDB*8)+6;
volatile bit WPDB7                     @ ((unsigned)&WPDB*8)+7;
// bit and bitfield definitions
volatile bit WPDC0                     @ ((unsigned)&WPDC*8)+0;
volatile bit WPDC1                     @ ((unsigned)&WPDC*8)+1;
volatile bit WPDC2                     @ ((unsigned)&WPDC*8)+2;
volatile bit WPDC3                     @ ((unsigned)&WPDC*8)+3;
volatile bit WPDC4                     @ ((unsigned)&WPDC*8)+4;
volatile bit WPDC5                     @ ((unsigned)&WPDC*8)+5;
volatile bit WPDC6                     @ ((unsigned)&WPDC*8)+6;
volatile bit WPDC7                     @ ((unsigned)&WPDC*8)+7;

// bit and bitfield definitions
volatile bit WPDF0                     @ ((unsigned)&WPDF*8)+0;
volatile bit WPDF1                     @ ((unsigned)&WPDF*8)+1;
volatile bit WPDF2                     @ ((unsigned)&WPDF*8)+2;
volatile bit WPDF3                     @ ((unsigned)&WPDF*8)+3;
volatile bit WPDF4                     @ ((unsigned)&WPDF*8)+4;
volatile bit WPDF5                     @ ((unsigned)&WPDF*8)+5;
volatile bit WPDF6                     @ ((unsigned)&WPDF*8)+6;
volatile bit WPDF7                     @ ((unsigned)&WPDF*8)+7;
// bit and bitfield definitions
volatile bit IOCA0                     @ ((unsigned)&IOCA*8)+0;
volatile bit IOCA1                     @ ((unsigned)&IOCA*8)+1;
volatile bit IOCA2                     @ ((unsigned)&IOCA*8)+2;
volatile bit IOCA3                     @ ((unsigned)&IOCA*8)+3;
volatile bit IOCA4                     @ ((unsigned)&IOCA*8)+4;
volatile bit IOCA5                     @ ((unsigned)&IOCA*8)+5;
volatile bit IOCA6                     @ ((unsigned)&IOCA*8)+6;
volatile bit IOCA7                     @ ((unsigned)&IOCA*8)+7;
// bit and bitfield definitions
volatile bit IOCB0                     @ ((unsigned)&IOCB*8)+0;
volatile bit IOCB1                     @ ((unsigned)&IOCB*8)+1;
volatile bit IOCB2                     @ ((unsigned)&IOCB*8)+2;
volatile bit IOCB3                     @ ((unsigned)&IOCB*8)+3;
volatile bit IOCB4                     @ ((unsigned)&IOCB*8)+4;
volatile bit IOCB5                     @ ((unsigned)&IOCB*8)+5;
volatile bit IOCB6                     @ ((unsigned)&IOCB*8)+6;
volatile bit IOCB7                     @ ((unsigned)&IOCB*8)+7;
// bit and bitfield definitions
volatile bit IOCC0                     @ ((unsigned)&IOCC*8)+0;
volatile bit IOCC1                     @ ((unsigned)&IOCC*8)+1;
volatile bit IOCC2                     @ ((unsigned)&IOCC*8)+2;
volatile bit IOCC3                     @ ((unsigned)&IOCC*8)+3;
volatile bit IOCC4                     @ ((unsigned)&IOCC*8)+4;
volatile bit IOCC5                     @ ((unsigned)&IOCC*8)+5;
volatile bit IOCC6                     @ ((unsigned)&IOCC*8)+6;
volatile bit IOCC7                     @ ((unsigned)&IOCC*8)+7;

// bit and bitfield definitions
volatile bit IOCF0                     @ ((unsigned)&IOCF*8)+0;
volatile bit IOCF1                     @ ((unsigned)&IOCF*8)+1;
volatile bit IOCF2                     @ ((unsigned)&IOCF*8)+2;
volatile bit IOCF3                     @ ((unsigned)&IOCF*8)+3;
volatile bit IOCF4                     @ ((unsigned)&IOCF*8)+4;
volatile bit IOCF5                     @ ((unsigned)&IOCF*8)+5;
volatile bit IOCF6                     @ ((unsigned)&IOCF*8)+6;
volatile bit IOCF7                     @ ((unsigned)&IOCF*8)+7;
// bit and bitfield definitions
volatile bit UAPCT0                     @ ((unsigned)&PORCTR*8)+0;
volatile bit UAPCT1                     @ ((unsigned)&PORCTR*8)+1;
volatile bit CCPCT                     @ ((unsigned)&PORCTR*8)+3;

// bit and bitfield definitions
volatile bit DRENA0L                     @ ((unsigned)&DRENAL*8)+0;
volatile bit DRENA1L                     @ ((unsigned)&DRENAL*8)+1;
volatile bit DRENA2L                     @ ((unsigned)&DRENAL*8)+2;
volatile bit DRENA3L                     @ ((unsigned)&DRENAL*8)+3;
volatile bit DRENA4L                     @ ((unsigned)&DRENAL*8)+4;
volatile bit DRENA5L                     @ ((unsigned)&DRENAL*8)+5;
volatile bit DRENA6L                     @ ((unsigned)&DRENAL*8)+6;
volatile bit DRENA7L                     @ ((unsigned)&DRENAL*8)+7;
// bit and bitfield definitions
volatile bit DRENB0L                     @ ((unsigned)&DRENBL*8)+0;
volatile bit DRENB2L                     @ ((unsigned)&DRENBL*8)+2;
volatile bit DRENB3L                     @ ((unsigned)&DRENBL*8)+3;
volatile bit DRENB4L                     @ ((unsigned)&DRENBL*8)+4;
volatile bit DRENB5L                     @ ((unsigned)&DRENBL*8)+5;

// bit and bitfield definitions
volatile bit DRENC0L                     @ ((unsigned)&DRENBL*8)+0;

// bit and bitfield definitions
volatile bit DRENF0L                     @ ((unsigned)&DRENFL*8)+0;
volatile bit DRENF1L                     @ ((unsigned)&DRENFL*8)+1;
volatile bit DRENF2L                     @ ((unsigned)&DRENFL*8)+2;
volatile bit DRENF3L                     @ ((unsigned)&DRENFL*8)+3;
volatile bit DRENF4L                     @ ((unsigned)&DRENFL*8)+4;
volatile bit DRENF5L                     @ ((unsigned)&DRENFL*8)+5;
volatile bit DRENF6L                     @ ((unsigned)&DRENFL*8)+6;
volatile bit DRENF7L                     @ ((unsigned)&DRENFL*8)+7;

// bit and bitfield definitions
volatile bit T1IF                     @ ((unsigned)&PIR1*8)+0;
volatile bit T2IF                     @ ((unsigned)&PIR1*8)+1;
volatile bit CCP1IF                   @ ((unsigned)&PIR1*8)+2;
volatile bit ADIF                     @ ((unsigned)&PIR1*8)+6;
// bit and bitfield definitions
volatile bit CCP2IF                     @ ((unsigned)&PIR2*8)+0;
volatile bit TXIF                       @ ((unsigned)&PIR2*8)+2;
volatile bit RXIF                       @ ((unsigned)&PIR2*8)+3;
volatile bit PWM0IF                     @ ((unsigned)&PIR2*8)+5;
// bit and bitfield definitions
volatile bit RAIF                     @ ((unsigned)&PIR3*8)+0;
volatile bit RCIF                     @ ((unsigned)&PIR3*8)+1;
volatile bit RFIF                     @ ((unsigned)&PIR3*8)+4;
// bit and bitfield definitions
volatile bit T1ON                     @ ((unsigned)&T1CON*8)+0;
volatile bit T1SYNC                     @ ((unsigned)&T1CON*8)+2;
volatile bit T1OSCEN                     @ ((unsigned)&T1CON*8)+3;
volatile bit T1CKPS0                     @ ((unsigned)&T1CON*8)+4;
volatile bit T1CKPS1                     @ ((unsigned)&T1CON*8)+5;
volatile bit T1CS0                     @ ((unsigned)&T1CON*8)+6;
volatile bit T1CS1                     @ ((unsigned)&T1CON*8)+7;
// bit and bitfield definitions
volatile bit T2ON                     @ ((unsigned)&T2CON*8)+2;
volatile bit T2CKPS0                     @ ((unsigned)&T2CON*8)+3;
volatile bit T2CKPS1                     @ ((unsigned)&T2CON*8)+4;
volatile bit T2CKPS2                     @ ((unsigned)&T2CON*8)+5;
volatile bit T2CKPS3                     @ ((unsigned)&T2CON*8)+6;
// bit and bitfield definitions
volatile bit PR1EN                     @ ((unsigned)&PR1CON*8)+0;
volatile bit PWMPR1                     @ ((unsigned)&PR1CON*8)+1;
volatile bit T1CKPS2                     @ ((unsigned)&PR1CON*8)+2;
volatile bit T1CKPS3                     @ ((unsigned)&PR1CON*8)+3;
volatile bit PWM2T0                     @ ((unsigned)&PR1CON*8)+4;
volatile bit PWM2T1                     @ ((unsigned)&PR1CON*8)+5;
volatile bit PWM1T0                     @ ((unsigned)&PR1CON*8)+6;
volatile bit PWM1T1                     @ ((unsigned)&PR1CON*8)+7;
// bit and bitfield definitions
volatile bit T1IE                     @ ((unsigned)&PIE1*8)+0;
volatile bit T2IE                     @ ((unsigned)&PIE1*8)+1;
volatile bit CCP1IE                     @ ((unsigned)&PIE1*8)+2;
volatile bit ADIE                     @ ((unsigned)&PIE1*8)+6;
// bit and bitfield definitions
volatile bit CCP2IE                     @ ((unsigned)&PIE2*8)+0;
volatile bit UARTIE                     @ ((unsigned)&PIE2*8)+2;
volatile bit PWM1IE                     @ ((unsigned)&PIE2*8)+6;
// bit and bitfield definitions
volatile bit RAIE                     @ ((unsigned)&PIE3*8)+0;
volatile bit RCIE                     @ ((unsigned)&PIE3*8)+1;
volatile bit RDIE                     @ ((unsigned)&PIE3*8)+2;
volatile bit REIE                     @ ((unsigned)&PIE3*8)+3;
volatile bit RFIE                     @ ((unsigned)&PIE3*8)+4;
// bit and bitfield definitions
volatile bit PS0                     @ ((unsigned)&OPTION*8)+0;
volatile bit PS1                     @ ((unsigned)&OPTION*8)+1;
volatile bit PS2                     @ ((unsigned)&OPTION*8)+2;
volatile bit PSA                     @ ((unsigned)&OPTION*8)+3;
volatile bit T0SE                    @ ((unsigned)&OPTION*8)+4;
volatile bit T0CS                    @ ((unsigned)&OPTION*8)+5;
volatile bit INTEDG                  @ ((unsigned)&OPTION*8)+6;
volatile bit RBPUB                   @ ((unsigned)&OPTION*8)+7;
// bit and bitfield definitions
volatile bit BOR                     @ ((unsigned)&PCON*8)+0;
volatile bit POR                     @ ((unsigned)&PCON*8)+1;
volatile bit LVD1F                   @ ((unsigned)&PCON*8)+2;
volatile bit LVD2F                   @ ((unsigned)&PCON*8)+3;
volatile bit WDTENS                  @ ((unsigned)&PCON*8)+4;
volatile bit LVD1EN                  @ ((unsigned)&PCON*8)+6;
volatile bit LVD2EN                  @ ((unsigned)&PCON*8)+7;
// bit and bitfield definitions
volatile bit SCS                     @ ((unsigned)&OSCCON*8)+0;
volatile bit HXEN                     @ ((unsigned)&OSCCON*8)+1;
volatile bit T0OSCEN                     @ ((unsigned)&OSCCON*8)+7;

// bit and bitfield definitions
volatile bit CCP2M0                     @ ((unsigned)&CCP2CON*8)+0;
volatile bit CCP2M1                     @ ((unsigned)&CCP2CON*8)+1;
volatile bit CCP2M2                     @ ((unsigned)&CCP2CON*8)+2;
volatile bit CCP2M3                     @ ((unsigned)&CCP2CON*8)+3;
volatile bit DC2B0                     @ ((unsigned)&CCP2CON*8)+4;
volatile bit DC2B1                      @ ((unsigned)&CCP2CON*8)+5;
// bit and bitfield definitions
volatile bit CCP1M0                     @ ((unsigned)&CCP1CON*8)+0;
volatile bit CCP1M1                     @ ((unsigned)&CCP1CON*8)+1;
volatile bit CCP1M2                     @ ((unsigned)&CCP1CON*8)+2;
volatile bit CCP1M3                     @ ((unsigned)&CCP1CON*8)+3;
volatile bit DC1B0                     @ ((unsigned)&CCP1CON*8)+4;
volatile bit DC1B1                      @ ((unsigned)&CCP1CON*8)+5;
// bit and bitfield definitions
volatile bit ANSEL0                     @ ((unsigned)&ANSELL*8)+0;
volatile bit ANSEL1                     @ ((unsigned)&ANSELL*8)+1;
volatile bit ANSEL2                     @ ((unsigned)&ANSELL*8)+2;
volatile bit ANSEL3                     @ ((unsigned)&ANSELL*8)+3;
volatile bit ANSEL4                     @ ((unsigned)&ANSELL*8)+4;
volatile bit ANSEL6                      @ ((unsigned)&ANSELL*8)+6;
volatile bit ANSEL7                      @ ((unsigned)&ANSELL*8)+7;
// bit and bitfield definitions
volatile bit ANSEL8                     @ ((unsigned)&ANSELH*8)+0;
volatile bit ANSEL9                     @ ((unsigned)&ANSELH*8)+1;
volatile bit ANSEL10                     @ ((unsigned)&ANSELH*8)+2;
volatile bit ANSEL11                     @ ((unsigned)&ANSELH*8)+3;
volatile bit ANSEL12                     @ ((unsigned)&ANSELH*8)+4;
volatile bit ANSEL13                     @ ((unsigned)&ANSELH*8)+5;
volatile bit ANSEL14                      @ ((unsigned)&ANSELH*8)+6;
volatile bit ANSEL15                      @ ((unsigned)&ANSELH*8)+7;
// bit and bitfield definitions
volatile bit ADEN                     @ ((unsigned)&ADCON0*8)+0;
volatile bit ADON                     @ ((unsigned)&ADCON0*8)+1;
volatile bit CHS0                     @ ((unsigned)&ADCON0*8)+2;
volatile bit CHS1                     @ ((unsigned)&ADCON0*8)+3;
volatile bit CHS2                      @ ((unsigned)&ADCON0*8)+4;
volatile bit CHS3                      @ ((unsigned)&ADCON0*8)+5;
volatile bit VHS0                      @ ((unsigned)&ADCON0*8)+6;
volatile bit VHS1                      @ ((unsigned)&ADCON0*8)+7;
// bit and bitfield definitions
volatile bit ADREF                     @ ((unsigned)&ADCON1*8)+0;
volatile bit ADCS0                      @ ((unsigned)&ADCON1*8)+4;
volatile bit ADCS1                      @ ((unsigned)&ADCON1*8)+5;
volatile bit ADCS2                      @ ((unsigned)&ADCON1*8)+6;
volatile bit ADFM                      @ ((unsigned)&ADCON1*8)+7;
// bit and bitfield definitions
volatile bit ADCLK0                     @ ((unsigned)&ADCLK*8)+0;
volatile bit ADCLK1                      @ ((unsigned)&ADCLK*8)+1;
volatile bit ADCLK2                      @ ((unsigned)&ADCLK*8)+2;
// bit and bitfield definitions
volatile bit RDON                     @ ((unsigned)&PMCON*8)+0;
// bit and bitfield definitions
volatile bit DRENA0H                     @ ((unsigned)&DRENAH*8)+0;
volatile bit DRENA1H                     @ ((unsigned)&DRENAH*8)+1;
volatile bit DRENA2H                     @ ((unsigned)&DRENAH*8)+2;
volatile bit DRENA3H                     @ ((unsigned)&DRENAH*8)+3;
volatile bit DRENA4H                     @ ((unsigned)&DRENAH*8)+4;
volatile bit DRENA5H                     @ ((unsigned)&DRENAH*8)+5;
volatile bit DRENA6H                     @ ((unsigned)&DRENAH*8)+6;
volatile bit DRENA7H                     @ ((unsigned)&DRENAH*8)+7;
// bit and bitfield definitions
volatile bit DRENB0H                     @ ((unsigned)&DRENBH*8)+0;
volatile bit DRENB1H                     @ ((unsigned)&DRENBH*8)+1;
volatile bit DRENB2H                     @ ((unsigned)&DRENBH*8)+2;
volatile bit DRENB3H                     @ ((unsigned)&DRENBH*8)+3;
volatile bit DRENB4H                     @ ((unsigned)&DRENBH*8)+4;
volatile bit DRENB5H                     @ ((unsigned)&DRENBH*8)+5;
volatile bit DRENB6H                     @ ((unsigned)&DRENBH*8)+6;
volatile bit DRENB7H                     @ ((unsigned)&DRENBH*8)+7;
// bit and bitfield definitions
volatile bit DRENC0H                     @ ((unsigned)&DRENCH*8)+0;
volatile bit DRENC1H                     @ ((unsigned)&DRENCH*8)+1;
// bit and bitfield definitions
volatile bit DRENF0H                     @ ((unsigned)&DRENFH*8)+0;
volatile bit DRENF1H                     @ ((unsigned)&DRENFH*8)+1;
volatile bit DRENF2H                     @ ((unsigned)&DRENFH*8)+2;
volatile bit DRENF3H                     @ ((unsigned)&DRENFH*8)+3;
volatile bit DRENF4H                     @ ((unsigned)&DRENFH*8)+4;
volatile bit DRENF5H                     @ ((unsigned)&DRENFH*8)+5;
volatile bit DRENF6H                     @ ((unsigned)&DRENFH*8)+6;
volatile bit DRENF7H                     @ ((unsigned)&DRENFH*8)+7;
// bit and bitfield definitions
volatile bit SMOD0                     @ ((unsigned)&AUXR*8)+0;
volatile bit SMOD                     @ ((unsigned)&AUXR*8)+1;
volatile bit S1BRS                     @ ((unsigned)&AUXR*8)+2;
volatile bit BRTX12                     @ ((unsigned)&AUXR*8)+3;
volatile bit BRTR                      @ ((unsigned)&AUXR*8)+4;
volatile bit UARTM0                      @ ((unsigned)&AUXR*8)+5;
volatile bit UARTEN                      @ ((unsigned)&AUXR*8)+6;
// bit and bitfield definitions
volatile bit RXWK                     @ ((unsigned)&SCON*8)+1;
volatile bit RB8                     @ ((unsigned)&SCON*8)+2;
volatile bit TR8                     @ ((unsigned)&SCON*8)+3;
volatile bit REN                      @ ((unsigned)&SCON*8)+4;
volatile bit SM2                      @ ((unsigned)&SCON*8)+5;
volatile bit SM1                      @ ((unsigned)&SCON*8)+6;
volatile bit SM0                      @ ((unsigned)&SCON*8)+7;

// bit and bitfield definitions
volatile bit DT00                     @ ((unsigned)&PWM0DT*8)+0;
volatile bit DT01                     @ ((unsigned)&PWM0DT*8)+1;
volatile bit DT02                     @ ((unsigned)&PWM0DT*8)+2;
volatile bit DT03                     @ ((unsigned)&PWM0DT*8)+3;
volatile bit DT04                     @ ((unsigned)&PWM0DT*8)+4;
volatile bit DT05                     @ ((unsigned)&PWM0DT*8)+5;
volatile bit DT06                      @ ((unsigned)&PWM0DT*8)+6;
volatile bit DT07                      @ ((unsigned)&PWM0DT*8)+7;
// bit and bitfield definitions
volatile bit PD00                     @ ((unsigned)&PWM0DL*8)+0;
volatile bit PD01                     @ ((unsigned)&PWM0DL*8)+1;
volatile bit PD02                     @ ((unsigned)&PWM0DL*8)+2;
volatile bit PD03                     @ ((unsigned)&PWM0DL*8)+3;
volatile bit PD04                     @ ((unsigned)&PWM0DL*8)+4;
volatile bit PD05                     @ ((unsigned)&PWM0DL*8)+5;
volatile bit PD06                      @ ((unsigned)&PWM0DL*8)+6;
volatile bit PD07                      @ ((unsigned)&PWM0DL*8)+7;
// bit and bitfield definitions
volatile bit PD08                     @ ((unsigned)&PWM0DH*8)+0;
volatile bit PD09                     @ ((unsigned)&PWM0DH*8)+1;
volatile bit PD10                     @ ((unsigned)&PWM0DH*8)+2;
// bit and bitfield definitions
volatile bit PP00                     @ ((unsigned)&PWM0PL*8)+0;
volatile bit PP01                     @ ((unsigned)&PWM0PL*8)+1;
volatile bit PP02                     @ ((unsigned)&PWM0PL*8)+2;
volatile bit PP03                     @ ((unsigned)&PWM0PL*8)+3;
volatile bit PP04                     @ ((unsigned)&PWM0PL*8)+4;
volatile bit PP05                     @ ((unsigned)&PWM0PL*8)+5;
volatile bit PP06                      @ ((unsigned)&PWM0PL*8)+6;
volatile bit PP07                      @ ((unsigned)&PWM0PL*8)+7;
// bit and bitfield definitions
volatile bit PP08                     @ ((unsigned)&PWM0PH*8)+0;
volatile bit PP09                     @ ((unsigned)&PWM0PH*8)+1;
volatile bit PP10                     @ ((unsigned)&PWM0PH*8)+2;
volatile bit PP11                     @ ((unsigned)&PWM0PH*8)+3;
// bit and bitfield definitions
volatile bit CK00                     @ ((unsigned)&PWM0C*8)+0;
volatile bit CK01                     @ ((unsigned)&PWM0C*8)+1;
volatile bit PWM0S0                     @ ((unsigned)&PWM0C*8)+2;
volatile bit PWM0S1                     @ ((unsigned)&PWM0C*8)+3;
volatile bit FLTC                      @ ((unsigned)&PWM0C*8)+4;
volatile bit FLTS                      @ ((unsigned)&PWM0C*8)+5;
// bit and bitfield definitions
volatile bit EPWM0                     @ ((unsigned)&PWMEN*8)+0;
volatile bit EPWM1                     @ ((unsigned)&PWMEN*8)+1;
volatile bit EPWM2                     @ ((unsigned)&PWMEN*8)+2;
volatile bit EPWM01                     @ ((unsigned)&PWMEN*8)+3;
volatile bit EPWM11                     @ ((unsigned)&PWMEN*8)+4;
volatile bit EPWM21                     @ ((unsigned)&PWMEN*8)+5;
volatile bit EFLT                      @ ((unsigned)&PWMEN*8)+6;
// bit and bitfield definitions
volatile bit FLT0M0                     @ ((unsigned)&FLTM*8)+0;
volatile bit FLT0M1                     @ ((unsigned)&FLTM*8)+1;
volatile bit FLT1M0                     @ ((unsigned)&FLTM*8)+2;
volatile bit FLT1M1                     @ ((unsigned)&FLTM*8)+3;
volatile bit FLT2M0                     @ ((unsigned)&FLTM*8)+4;
volatile bit FLT2M1                     @ ((unsigned)&FLTM*8)+5;
// bit and bitfield definitions
volatile bit FRAME                     @ ((unsigned)&LCDCON*8)+4;
volatile bit RLCD0                       @ ((unsigned)&LCDCON*8)+5;
volatile bit RLCD1                     @ ((unsigned)&LCDCON*8)+6;
volatile bit LCDEN                     @ ((unsigned)&LCDCON*8)+7;
// bit and bitfield definitions
volatile bit COMAEN0                     @ ((unsigned)&COMAEN*8)+0;
volatile bit COMAEN1                     @ ((unsigned)&COMAEN*8)+1;
volatile bit COMAEN2                     @ ((unsigned)&COMAEN*8)+2;
volatile bit COMAEN3                     @ ((unsigned)&COMAEN*8)+3;
volatile bit COMAEN4                     @ ((unsigned)&COMAEN*8)+4;
volatile bit COMAEN5                     @ ((unsigned)&COMAEN*8)+5;
volatile bit COMAEN6                      @ ((unsigned)&COMAEN*8)+6;
volatile bit COMAEN7                      @ ((unsigned)&COMAEN*8)+7;
// bit and bitfield definitions
volatile bit COMBEN0                     @ ((unsigned)&COMBEN*8)+0;
volatile bit COMBEN2                     @ ((unsigned)&COMBEN*8)+2;
volatile bit COMBEN3                     @ ((unsigned)&COMBEN*8)+3;
volatile bit COMBEN4                     @ ((unsigned)&COMBEN*8)+4;
// bit and bitfield definitions
volatile bit COMBEN1                     @ ((unsigned)&COMCEN*8)+0;
// bit and bitfield definitions
volatile bit COMFEN0                     @ ((unsigned)&COMFEN*8)+0;
volatile bit COMFEN1                     @ ((unsigned)&COMFEN*8)+1;
volatile bit COMFEN2                     @ ((unsigned)&COMFEN*8)+2;
volatile bit COMFEN3                     @ ((unsigned)&COMFEN*8)+3;
volatile bit COMFEN4                     @ ((unsigned)&COMFEN*8)+4;
volatile bit COMFEN5                     @ ((unsigned)&COMFEN*8)+5;
volatile bit COMFEN6                      @ ((unsigned)&COMFEN*8)+6;
volatile bit COMFEN7                      @ ((unsigned)&COMFEN*8)+7;
#endif
