
#ifndef	_HTC_H_
#endif

/* header file for the MICROCHIP PIC microcontroller
 *  16C54A
 */


#ifndef __HC18P020L_H
#define __HC18P020L_H


// Special function register definitions
//
//----- BANK0 Register -----------------------------------------------------
volatile   unsigned char           INDF                @ 0x000;
volatile   unsigned char           T0                  @ 0x001;
volatile   unsigned char           PCL                 @ 0x002;
volatile   unsigned char           STATUS              @ 0x003;
volatile   unsigned char           FSR                 @ 0x004;
volatile   unsigned char           PORTA              @ 0x005;
volatile   unsigned char           PORTB              @ 0x006;
//volatile  unsigned char           GPR                 @ 0x007;
volatile  unsigned char           PCON                @ 0x008;
volatile  unsigned char           IOCB                @ 0x009;
volatile  unsigned char           PCLATH              @ 0x00A;
volatile  unsigned char           PDCON               @ 0x00B;
volatile  unsigned char           ODCON               @ 0x00C;
volatile  unsigned char           PHCON               @ 0x00D;
volatile  unsigned char           INTECON             @ 0x00E;
volatile  unsigned char           INTFLAG             @ 0x00F;
volatile  unsigned char           itemp               @ 0x010;
//volatile  unsigned char           occupy5             @ 0x040;
volatile  unsigned char           OPTION              @ 0x041;
volatile  unsigned char           occupy0             @ 0x042;
volatile  unsigned char           occupy1              @ 0x043;
volatile  unsigned char           occupy2              @ 0x044;
volatile  unsigned char           TRISA               @ 0x045;
volatile  unsigned char           TRISB               @ 0x046;
volatile  unsigned char           PHCON1              @ 0x047;
volatile  unsigned char           PWMCON              @ 0x048;
volatile  unsigned char           PWM1P               @ 0x049;
volatile  unsigned char           PWM2P               @ 0x04A;
volatile  unsigned char           T0CR                @ 0x04B;
volatile  unsigned char           T1CON               @ 0x04C;
volatile  unsigned char           T1                  @ 0x04D;
volatile  unsigned char           T1LOAD              @ 0x04E;
volatile  unsigned char           PWM0P               @ 0x04F;
volatile  unsigned char           OSCCON              @ 0x050;
volatile  unsigned char           LVDCON              @ 0x051;
volatile  unsigned char           PDCON1              @ 0x052;
volatile  unsigned char           ODCON1              @ 0x053;
volatile  unsigned char           PWM3EN              @ 0x054;
volatile  unsigned char           PWM3C               @ 0x055;
volatile  unsigned char           PWM3P               @ 0x056;
volatile  unsigned char           PWM3D               @ 0x057;
volatile  unsigned char           PWM3DT              @ 0x058;
volatile  unsigned char           AUXR                @ 0x059;
volatile  unsigned char           IOCA                @ 0x05A;
volatile  unsigned char           HIRCTRM             @ 0x05B;
//----- BANK1 Register -----------------------------------------------------
// bit and bitfield definitions
volatile bit C                   @ ((unsigned)&STATUS*8)+0;
volatile bit DC                  @ ((unsigned)&STATUS*8)+1;
volatile bit Z                   @ ((unsigned)&STATUS*8)+2;
volatile bit PD                  @ ((unsigned)&STATUS*8)+3;
volatile bit TO                  @ ((unsigned)&STATUS*8)+4;
volatile bit RP0                 @ ((unsigned)&STATUS*8)+5;
volatile bit GP1                 @ ((unsigned)&STATUS*8)+6;
volatile bit RST                 @ ((unsigned)&STATUS*8)+7;

// bit and bitfield definitions
volatile bit PORTA0               @ ((unsigned)&PORTA*8)+0;
volatile bit PORTA1               @ ((unsigned)&PORTA*8)+1;
volatile bit PORTA2               @ ((unsigned)&PORTA*8)+2;
volatile bit PORTA3               @ ((unsigned)&PORTA*8)+3;
volatile bit PORTA4               @ ((unsigned)&PORTA*8)+4;
volatile bit PORTA5               @ ((unsigned)&PORTA*8)+5;

// bit and bitfield definitions
volatile bit PORTB0                 @ ((unsigned)&PORTB*8)+0;
volatile bit PORTB1                 @ ((unsigned)&PORTB*8)+1;
volatile bit PORTB2                 @ ((unsigned)&PORTB*8)+2;
volatile bit PORTB3                 @ ((unsigned)&PORTB*8)+3;
volatile bit PORTB4                 @ ((unsigned)&PORTB*8)+4;
volatile bit PORTB5                 @ ((unsigned)&PORTB*8)+5;
volatile bit PORTB6                 @ ((unsigned)&PORTB*8)+6;
volatile bit PORTB7                 @ ((unsigned)&PORTB*8)+7;
// bit and bitfield definitions
volatile bit LVDEN                  @ ((unsigned)&PCON*8)+0;
volatile bit LVDSEL0                @ ((unsigned)&PCON*8)+1;
volatile bit LVDSEL1                @ ((unsigned)&PCON*8)+2;
volatile bit LVDSEL2                @ ((unsigned)&PCON*8)+3;
volatile bit LVDSEL3                @ ((unsigned)&PCON*8)+4;
volatile bit LVDF                   @ ((unsigned)&PCON*8)+5;
volatile bit EIS                    @ ((unsigned)&PCON*8)+6;
volatile bit WDTEN                  @ ((unsigned)&PCON*8)+7;

/* Definitions for IOCB register */
volatile bit IOCB0                 @ ((unsigned)&IOCB*8)+0;
volatile bit IOCB1                 @ ((unsigned)&IOCB*8)+1;
volatile bit IOCB2                 @ ((unsigned)&IOCB*8)+2;
volatile bit IOCB3                 @ ((unsigned)&IOCB*8)+3;
volatile bit IOCB4                 @ ((unsigned)&IOCB*8)+4;
volatile bit IOCB5                 @ ((unsigned)&IOCB*8)+5;
volatile bit IOCB6                 @ ((unsigned)&IOCB*8)+6;
volatile bit IOCB7                 @ ((unsigned)&IOCB*8)+7;
// bit and bitfield definitions
volatile bit PDA0                 @ ((unsigned)&PDCON*8)+0;
volatile bit PDA1                 @ ((unsigned)&PDCON*8)+1;
volatile bit PDA2                 @ ((unsigned)&PDCON*8)+2;
volatile bit PDA3                 @ ((unsigned)&PDCON*8)+3;
volatile bit PDB0                 @ ((unsigned)&PDCON*8)+4;
volatile bit PDB1                 @ ((unsigned)&PDCON*8)+5;
volatile bit PDB2                 @ ((unsigned)&PDCON*8)+6;

// bit and bitfield definitions
volatile bit ODB0                 @ ((unsigned)&ODCON*8)+0;
volatile bit ODB1                 @ ((unsigned)&ODCON*8)+1;
volatile bit ODB2                 @ ((unsigned)&ODCON*8)+2;
volatile bit ODB3                 @ ((unsigned)&ODCON*8)+3;
volatile bit ODB4                 @ ((unsigned)&ODCON*8)+4;
volatile bit ODB5                 @ ((unsigned)&ODCON*8)+5;
volatile bit ODB6                 @ ((unsigned)&ODCON*8)+6;
volatile bit ODB7                 @ ((unsigned)&ODCON*8)+7;
// bit and bitfield definitions
volatile bit PHB0                 @ ((unsigned)&PHCON*8)+0;
volatile bit PHB1                 @ ((unsigned)&PHCON*8)+1;
volatile bit PHB2                 @ ((unsigned)&PHCON*8)+2;
volatile bit PHB3                 @ ((unsigned)&PHCON*8)+3;
volatile bit PHB4                 @ ((unsigned)&PHCON*8)+4;
volatile bit PHB5                 @ ((unsigned)&PHCON*8)+5;
volatile bit PHB6                 @ ((unsigned)&PHCON*8)+6;
volatile bit PHB7                 @ ((unsigned)&PHCON*8)+7;
// bit and bitfield definitions
volatile bit T0IE                 @ ((unsigned)&INTECON*8)+0;
volatile bit PBIE                 @ ((unsigned)&INTECON*8)+1;
volatile bit INTE                 @ ((unsigned)&INTECON*8)+2;
volatile bit GIE                  @ ((unsigned)&INTECON*8)+7;

// bit and bitfield definitions
volatile bit T0IF                 @ ((unsigned)&INTFLAG*8)+0;
volatile bit PBIF                 @ ((unsigned)&INTFLAG*8)+1;
volatile bit INTF                 @ ((unsigned)&INTFLAG*8)+2;

/* Definitions for OPTION register */
volatile bit PS0                 @ ((unsigned)&OPTION*8)+0;
volatile bit PS1                 @ ((unsigned)&OPTION*8)+1;
volatile bit PS2                 @ ((unsigned)&OPTION*8)+2;
volatile bit PSA                 @ ((unsigned)&OPTION*8)+3;
volatile bit T0SE                @ ((unsigned)&OPTION*8)+4;
volatile bit T0CS                @ ((unsigned)&OPTION*8)+5;
volatile bit INTEDG              @ ((unsigned)&OPTION*8)+6;

// bit and bitfield definitions
volatile bit TRISA0               @ ((unsigned)&TRISA*8)+0;
volatile bit TRISA1               @ ((unsigned)&TRISA*8)+1;
volatile bit TRISA2               @ ((unsigned)&TRISA*8)+2;
volatile bit TRISA3               @ ((unsigned)&TRISA*8)+3;
volatile bit TRISA4               @ ((unsigned)&TRISA*8)+4;
volatile bit TRISA5               @ ((unsigned)&TRISA*8)+5;

// bit and bitfield definitions
volatile bit TRISB0               @ ((unsigned)&TRISB*8)+0;
volatile bit TRISB1               @ ((unsigned)&TRISB*8)+1;
volatile bit TRISB2               @ ((unsigned)&TRISB*8)+2;
volatile bit TRISB3               @ ((unsigned)&TRISB*8)+3;
volatile bit TRISB4               @ ((unsigned)&TRISB*8)+4;
volatile bit TRISB5               @ ((unsigned)&TRISB*8)+5;
volatile bit TRISB6               @ ((unsigned)&TRISB*8)+6;
volatile bit TRISB7               @ ((unsigned)&TRISB*8)+7;

// bit and bitfield definitions
volatile bit PHA0               @ ((unsigned)&PHCON1*8)+0;
volatile bit PHA1               @ ((unsigned)&PHCON1*8)+1;
volatile bit PHA2               @ ((unsigned)&PHCON1*8)+2;
volatile bit PHA3               @ ((unsigned)&PHCON1*8)+3;
volatile bit PHA4               @ ((unsigned)&PHCON1*8)+4;
volatile bit PHA5               @ ((unsigned)&PHCON1*8)+5;


// bit and bitfield definitions
volatile bit PWM2E                 @ ((unsigned)&PWMCON*8)+0;
volatile bit PWM1E                 @ ((unsigned)&PWMCON*8)+1;
volatile bit PWMINV                 @ ((unsigned)&PWMCON*8)+2;
volatile bit PWMMD                 @ ((unsigned)&PWMCON*8)+3;
volatile bit PWMCK                 @ ((unsigned)&PWMCON*8)+4;
volatile bit PWM2OE                 @ ((unsigned)&PWMCON*8)+5;
volatile bit PWM1OE                 @ ((unsigned)&PWMCON*8)+6;
volatile bit PWM0OE                 @ ((unsigned)&PWMCON*8)+7;

// bit and bitfield definitions
volatile bit T1IF                   @ ((unsigned)&T0CR*8)+0;
volatile bit T1IE                   @ ((unsigned)&T0CR*8)+1;
volatile bit T0CK                   @ ((unsigned)&T0CR*8)+7;

// bit and bitfield definitions
volatile bit T1PR0                   @ ((unsigned)&T1CON*8)+0;
volatile bit T1PR1                   @ ((unsigned)&T1CON*8)+1;
volatile bit T1PR2                   @ ((unsigned)&T1CON*8)+2;
volatile bit T1CK0                   @ ((unsigned)&T1CON*8)+3;
volatile bit T1CK1                   @ ((unsigned)&T1CON*8)+4;
volatile bit BUZ                     @ ((unsigned)&T1CON*8)+5;
volatile bit PWM0E                   @ ((unsigned)&T1CON*8)+6;
volatile bit T1EN                    @ ((unsigned)&T1CON*8)+7;

// bit and bitfield definitions
volatile bit SCS                   @ ((unsigned)&OSCCON*8)+0;
volatile bit HXEN                   @ ((unsigned)&OSCCON*8)+1;
volatile bit T0OSCEN                   @ ((unsigned)&OSCCON*8)+7;
// bit and bitfield definitions
volatile bit LVDIE                   @ ((unsigned)&LVDCON*8)+0;
volatile bit LVDWP                   @ ((unsigned)&LVDCON*8)+1;
volatile bit LVDM                   @ ((unsigned)&LVDCON*8)+2;
// bit and bitfield definitions
volatile bit PDA4                   @ ((unsigned)&PDCON1*8)+0;
volatile bit PDA5                   @ ((unsigned)&PDCON1*8)+1;
volatile bit PDB3                   @ ((unsigned)&PDCON1*8)+3;
volatile bit PDB4                   @ ((unsigned)&PDCON1*8)+4;
volatile bit PDB5                     @ ((unsigned)&PDCON1*8)+5;
volatile bit PDB6                   @ ((unsigned)&PDCON1*8)+6;
volatile bit PDB7                    @ ((unsigned)&PDCON1*8)+7;

// bit and bitfield definitions
volatile bit ODA0                   @ ((unsigned)&ODCON1*8)+0;
volatile bit ODA1                   @ ((unsigned)&ODCON1*8)+1;
volatile bit ODA2                   @ ((unsigned)&ODCON1*8)+2;
volatile bit ODA3                   @ ((unsigned)&ODCON1*8)+3;
volatile bit ODA4                   @ ((unsigned)&ODCON1*8)+4;
volatile bit ODA5                   @ ((unsigned)&ODCON1*8)+5;
volatile bit ANSEL4                 @ ((unsigned)&ODCON1*8)+6;
volatile bit ANSEL5                 @ ((unsigned)&ODCON1*8)+7;

// bit and bitfield definitions
volatile bit PWM3_EN                   @ ((unsigned)&PWM3EN*8)+0;
volatile bit PWM3_OEN                  @ ((unsigned)&PWM3EN*8)+1;
volatile bit PWM31_OEN                 @ ((unsigned)&PWM3EN*8)+2;
volatile bit PWM3M                     @ ((unsigned)&PWM3EN*8)+3;
volatile bit EFLT                      @ ((unsigned)&PWM3EN*8)+4;
volatile bit FLT_MODE0                 @ ((unsigned)&PWM3EN*8)+5;
volatile bit FLT_MODE1                 @ ((unsigned)&PWM3EN*8)+6;

// bit and bitfield definitions
volatile bit PWM3CK0                @ ((unsigned)&PWM3C*8)+0;
volatile bit PWM3CK1                @ ((unsigned)&PWM3C*8)+1;
volatile bit PWM3S0                 @ ((unsigned)&PWM3C*8)+2;
volatile bit PWM3S1                 @ ((unsigned)&PWM3C*8)+3;
volatile bit FLTC                   @ ((unsigned)&PWM3C*8)+4;
volatile bit FLTS                   @ ((unsigned)&PWM3C*8)+5;
volatile bit PWM3IF                 @ ((unsigned)&PWM3C*8)+6;
volatile bit PWM3IE                 @ ((unsigned)&PWM3C*8)+7;

// bit and bitfield definitions
volatile bit PWMCT                   @ ((unsigned)&AUXR*8)+0;
volatile bit PWM3CT                  @ ((unsigned)&AUXR*8)+1;
volatile bit RCTRMEN                 @ ((unsigned)&AUXR*8)+2;
volatile bit BOR                     @ ((unsigned)&AUXR*8)+6;
volatile bit POR                     @ ((unsigned)&AUXR*8)+7;

// bit and bitfield definitions
volatile bit IOCA0                     @ ((unsigned)&IOCA*8)+0;
volatile bit IOCA1                     @ ((unsigned)&IOCA*8)+1;
volatile bit IOCA2                     @ ((unsigned)&IOCA*8)+2;
volatile bit IOCA3                     @ ((unsigned)&IOCA*8)+3;
volatile bit IOCA4                     @ ((unsigned)&IOCA*8)+4;
volatile bit IOCA5                     @ ((unsigned)&IOCA*8)+5;
volatile bit PAIF                      @ ((unsigned)&IOCA*8)+7;


#endif
