
#ifndef	_HTC_H_
#endif

/* header file for the MICROCHIP PIC microcontroller
 *  16C54A
 */


#ifndef __PIC18P015A0_H
#define __PIC18P015A0_H


// Special function register definitions
//
//----- BANK0 Register -----------------------------------------------------
volatile   unsigned char           INDF                @ 0x000;
volatile   unsigned char           T0                  @ 0x001;
volatile   unsigned char           PCL                 @ 0x002;
volatile   unsigned char           STATUS              @ 0x003;
volatile   unsigned char           FSR                 @ 0x004;
volatile  unsigned char            occupy9             @ 0x005;
volatile   unsigned char           PORTB               @ 0x006;
//volatile  unsigned char            GPR                 @ 0x007;
volatile  unsigned char            PCON                @ 0x008;
volatile  unsigned char            IOCB                @ 0x009;
volatile  unsigned char            PCLATH              @ 0x00A;
volatile  unsigned char            PDCON               @ 0x00B;
volatile  unsigned char            ODCON               @ 0x00C;
volatile  unsigned char            PHCON               @ 0x00D;
volatile  unsigned char            INTECON             @ 0x00E;
volatile  unsigned char            INTFLAG             @ 0x00F;

volatile  unsigned char           RFC_CTRL            @ 0x040;
volatile  unsigned char           OPTION              @ 0x041;

volatile  unsigned char           occupy0             @ 0x042;
volatile  unsigned char           occupy1             @ 0x043;
volatile  unsigned char           occupy2             @ 0x044;
volatile  unsigned char           occupy3             @ 0x045;

volatile  unsigned char           TRISB               @ 0x046;
volatile  unsigned char           occupy4             @ 0x047;
volatile  unsigned char           PWMCON              @ 0x048;
volatile  unsigned char           PWM1P               @ 0x049;
volatile  unsigned char           PWM2P               @ 0x04A;
volatile  unsigned char           T0CR                @ 0x04B;
volatile  unsigned char           T1CON               @ 0x04C;
volatile  unsigned char           T1                  @ 0x04D;
volatile  unsigned char           T1LOAD              @ 0x04E;
volatile  unsigned char           PWM0P               @ 0x04F;
volatile  unsigned char           OSCCON              @ 0x050;
volatile  unsigned char           CMPCR               @ 0x051;
volatile  unsigned char           occupy5             @ 0x052;
volatile  unsigned char           occupy6             @ 0x053;
volatile  unsigned char           PWM3EN              @ 0x054;
volatile  unsigned char           PWM3C               @ 0x055;
volatile  unsigned char           PWM3P               @ 0x056;
volatile  unsigned char           PWM3D               @ 0x057;
volatile  unsigned char           PWM3DT              @ 0x058;
volatile  unsigned char           AUXR                @ 0x059;
volatile  unsigned char           occupy7             @ 0x05A;
volatile  unsigned char           HIRCTRM             @ 0x05B;
volatile  unsigned char           itemp               @ 0x010;
//volatile  unsigned char           occupy8             @ 0x070;
//----- BANK1 Register -----------------------------------------------------
// bit and bitfield definitions
volatile bit C                   @ ((unsigned)&STATUS*8)+0;
volatile bit DC                  @ ((unsigned)&STATUS*8)+1;
volatile bit Z                   @ ((unsigned)&STATUS*8)+2;
volatile bit PD                  @ ((unsigned)&STATUS*8)+3;
volatile bit TO                  @ ((unsigned)&STATUS*8)+4;
volatile bit RP0                 @ ((unsigned)&STATUS*8)+5;
volatile bit GP1                 @ ((unsigned)&STATUS*8)+6;
volatile bit RST                 @ ((unsigned)&STATUS*8)+7;

// bit and bitfield definitions
volatile bit PORTB0                 @ ((unsigned)&PORTB*8)+0;
volatile bit PORTB1                 @ ((unsigned)&PORTB*8)+1;
volatile bit PORTB2                 @ ((unsigned)&PORTB*8)+2;
volatile bit PORTB3                 @ ((unsigned)&PORTB*8)+3;
volatile bit PORTB4                 @ ((unsigned)&PORTB*8)+4;
volatile bit PORTB5                 @ ((unsigned)&PORTB*8)+5;

// bit and bitfield definitions
volatile bit CMPEN                  @ ((unsigned)&PCON*8)+0;
volatile bit LVDSEL0                @ ((unsigned)&PCON*8)+1;
volatile bit LVDSEL1                @ ((unsigned)&PCON*8)+2;
volatile bit LVDSEL2                @ ((unsigned)&PCON*8)+3;
volatile bit LVDSEL3                @ ((unsigned)&PCON*8)+4;
volatile bit LVDSEL4                @ ((unsigned)&PCON*8)+5;
volatile bit LVDSEL5                @ ((unsigned)&PCON*8)+6;
volatile bit CMPOF                  @ ((unsigned)&PCON*8)+7;

/* Definitions for IOCB register */
volatile bit IOCB0                 @ ((unsigned)&IOCB*8)+0;
volatile bit IOCB1                 @ ((unsigned)&IOCB*8)+1;
volatile bit IOCB2                 @ ((unsigned)&IOCB*8)+2;
volatile bit IOCB3                 @ ((unsigned)&IOCB*8)+3;
volatile bit IOCB4                 @ ((unsigned)&IOCB*8)+4;
volatile bit IOCB5                 @ ((unsigned)&IOCB*8)+5;

// bit and bitfield definitions
volatile bit PDB0                 @ ((unsigned)&PDCON*8)+0;
volatile bit PDB1                 @ ((unsigned)&PDCON*8)+1;
volatile bit PDB2                 @ ((unsigned)&PDCON*8)+2;
volatile bit PDB3                 @ ((unsigned)&PDCON*8)+3;
volatile bit PDB4                 @ ((unsigned)&PDCON*8)+4;
volatile bit PDB5                 @ ((unsigned)&PDCON*8)+5;

// bit and bitfield definitions
volatile bit ODB0                 @ ((unsigned)&ODCON*8)+0;
volatile bit ODB1                 @ ((unsigned)&ODCON*8)+1;
volatile bit ODB2                 @ ((unsigned)&ODCON*8)+2;
volatile bit ODB3                 @ ((unsigned)&ODCON*8)+3;
volatile bit ODB4                 @ ((unsigned)&ODCON*8)+4;
volatile bit ODB5                 @ ((unsigned)&ODCON*8)+5;

// bit and bitfield definitions
volatile bit PHB0                 @ ((unsigned)&PHCON*8)+0;
volatile bit PHB1                 @ ((unsigned)&PHCON*8)+1;
volatile bit PHB2                 @ ((unsigned)&PHCON*8)+2;
volatile bit PHB3                 @ ((unsigned)&PHCON*8)+3;
volatile bit PHB4                 @ ((unsigned)&PHCON*8)+4;
volatile bit PHB5                 @ ((unsigned)&PHCON*8)+5;

// bit and bitfield definitions
volatile bit T0IE                 @ ((unsigned)&INTECON*8)+0;
volatile bit PBIE                 @ ((unsigned)&INTECON*8)+1;
volatile bit INTE                 @ ((unsigned)&INTECON*8)+2;
volatile bit GIE                  @ ((unsigned)&INTECON*8)+7;

// bit and bitfield definitions
volatile bit T0IF                 @ ((unsigned)&INTFLAG*8)+0;
volatile bit PBIF                 @ ((unsigned)&INTFLAG*8)+1;
volatile bit INTF                 @ ((unsigned)&INTFLAG*8)+2;
volatile bit CMPF                 @ ((unsigned)&INTFLAG*8)+3;

// bit and bitfield definitions
volatile bit RFC0                 @ ((unsigned)&RFC_CTRL*8)+0;
volatile bit RFC1                 @ ((unsigned)&RFC_CTRL*8)+1;
volatile bit RFC2                 @ ((unsigned)&RFC_CTRL*8)+2;
volatile bit RFCEN                @ ((unsigned)&RFC_CTRL*8)+3;
volatile bit TM1CLKIO             @ ((unsigned)&RFC_CTRL*8)+4;


// bit and bitfield definitions
volatile bit PS0                 @ ((unsigned)&OPTION*8)+0;
volatile bit PS1                 @ ((unsigned)&OPTION*8)+1;
volatile bit PS2                 @ ((unsigned)&OPTION*8)+2;
volatile bit PSA                 @ ((unsigned)&OPTION*8)+3;
volatile bit T0SE                @ ((unsigned)&OPTION*8)+4;
volatile bit T0CS                @ ((unsigned)&OPTION*8)+5;
volatile bit INTEDG              @ ((unsigned)&OPTION*8)+6;
volatile bit WDTEN               @ ((unsigned)&OPTION*8)+7;

// bit and bitfield definitions
volatile bit TRISB0               @ ((unsigned)&TRISB*8)+0;
volatile bit TRISB1               @ ((unsigned)&TRISB*8)+1;
volatile bit TRISB2               @ ((unsigned)&TRISB*8)+2;
volatile bit TRISB3               @ ((unsigned)&TRISB*8)+3;
volatile bit TRISB4               @ ((unsigned)&TRISB*8)+4;
volatile bit TRISB5               @ ((unsigned)&TRISB*8)+5;

// bit and bitfield definitions
volatile bit PWM2E                 @ ((unsigned)&PWMCON*8)+0;
volatile bit PWM1E                 @ ((unsigned)&PWMCON*8)+1;
volatile bit PWMINV                 @ ((unsigned)&PWMCON*8)+2;
volatile bit PWMMD                 @ ((unsigned)&PWMCON*8)+3;
volatile bit PWMCK                 @ ((unsigned)&PWMCON*8)+4;
volatile bit PWM2OE                 @ ((unsigned)&PWMCON*8)+5;
volatile bit PWM1OE                 @ ((unsigned)&PWMCON*8)+6;
volatile bit PWM0OE                 @ ((unsigned)&PWMCON*8)+7;

// bit and bitfield definitions
volatile bit T1IF                   @ ((unsigned)&T0CR*8)+0;
volatile bit T1IE                   @ ((unsigned)&T0CR*8)+1;
volatile bit T0CK                   @ ((unsigned)&T0CR*8)+7;

// bit and bitfield definitions
volatile bit T1PR0                   @ ((unsigned)&T1CON*8)+0;
volatile bit T1PR1                   @ ((unsigned)&T1CON*8)+1;
volatile bit T1PR2                   @ ((unsigned)&T1CON*8)+2;
volatile bit T1CK0                   @ ((unsigned)&T1CON*8)+3;
volatile bit T1CK1                   @ ((unsigned)&T1CON*8)+4;
volatile bit BUZ                     @ ((unsigned)&T1CON*8)+5;
volatile bit PWM0E                   @ ((unsigned)&T1CON*8)+6;
volatile bit T1EN                    @ ((unsigned)&T1CON*8)+7;

// bit and bitfield definitions
volatile bit SCS                     @ ((unsigned)&OSCCON*8)+0;
volatile bit HXEN                    @ ((unsigned)&OSCCON*8)+1;
volatile bit T0OSCEN                 @ ((unsigned)&OSCCON*8)+7;
// bit and bitfield definitions
volatile bit CPPIS                    @ ((unsigned)&CMPCR*8)+0;
volatile bit CMPIES                   @ ((unsigned)&CMPCR*8)+1;
volatile bit CMPIE                    @ ((unsigned)&CMPCR*8)+2;
volatile bit CMPWK                    @ ((unsigned)&CMPCR*8)+3;
volatile bit COEN                     @ ((unsigned)&CMPCR*8)+4;
volatile bit CPNIS0                   @ ((unsigned)&CMPCR*8)+5;
volatile bit CPNIS1                   @ ((unsigned)&CMPCR*8)+6;
volatile bit CPNIS2                   @ ((unsigned)&CMPCR*8)+7;

// bit and bitfield definitions
volatile bit PWM3_EN                   @ ((unsigned)&PWM3EN*8)+0;
volatile bit PWM3_OEN                  @ ((unsigned)&PWM3EN*8)+1;
volatile bit PWM31_OEN                 @ ((unsigned)&PWM3EN*8)+2;
volatile bit PWM3M                     @ ((unsigned)&PWM3EN*8)+3;
volatile bit EFLT                      @ ((unsigned)&PWM3EN*8)+4;
volatile bit FLT_MODE0                 @ ((unsigned)&PWM3EN*8)+5;
volatile bit FLT_MODE1                 @ ((unsigned)&PWM3EN*8)+6;

// bit and bitfield definitions
volatile bit PWM3CK0                @ ((unsigned)&PWM3C*8)+0;
volatile bit PWM3CK1                @ ((unsigned)&PWM3C*8)+1;
volatile bit PWM3S0                 @ ((unsigned)&PWM3C*8)+2;
volatile bit PWM3S1                 @ ((unsigned)&PWM3C*8)+3;
volatile bit FLTC                   @ ((unsigned)&PWM3C*8)+4;
volatile bit FLTS                   @ ((unsigned)&PWM3C*8)+5;
volatile bit PWM3IF                 @ ((unsigned)&PWM3C*8)+6;
volatile bit PWM3IE                 @ ((unsigned)&PWM3C*8)+7;

// bit and bitfield definitions
volatile bit RCTRMEN                 @ ((unsigned)&AUXR*8)+2;
volatile bit BOREN                     @ ((unsigned)&AUXR*8)+5;
volatile bit BOR                     @ ((unsigned)&AUXR*8)+6;
volatile bit POR                     @ ((unsigned)&AUXR*8)+7;

#endif
