/**
*   ************************************************************************************



*   ************************************************************************************
**/

#ifndef __REGISTER_H__
#define	__REGISTER_H__
/**************************************************************************************/


/*R,ʾֻ;W,ʾֻд;RW,ʾɶд*/
/**************************************************************************************/
/*ʱӿƼĴ CLKCON */
#define	CLK_R_HXTALRDY				BIT7		//ⲿƵ״̬λ
#define	CLK_R_LXTALRDY				BIT6		//ⲿƵ״̬λ
#define	CLK_R_HSRCRDY				BIT5		//ڲƵRC״̬λ
#define	CLK_R_LSCRDY				BIT4		//ڲƵRC״̬λ
#define	CLK_XTALEN					BIT2		//ⲿʹλ
#define	CLK_HSRCEN					BIT1		//ڲƵRCʹλ
/**************************************************************************************/
/*ʱѡĴ CLKSWR */
/*ϵͳʱ״̬λ:BIT7,BIT6;ϵͳʱѡλ:BIT5,BIT4;ڲƵRCƵϵ*/
#define	CLK_R_CLKSTA_LRC			B0000_0000	//ǰϵͳʱΪڲƵRC
#define	CLK_R_CLKSTA_HRC			B0100_0000	//              ڲƵRC
#define	CLK_R_CLKSTA_ELCRYSTAL		B1000_0000	//              ⲿƵ
#define	CLK_R_CLKSTA_EHCRYSATL		B1100_0000	//				ⲿƵ
#define	CLK_CLKSEL_LRC				B0000_0000	//ѡϵͳʱΪڲƵRC
#define	CLK_CLKSEL_HRC				B0001_0000	//              ڲƵRC
#define	CLK_CLKSEL_ELCRYSTAL		B0010_0000	//              ⲿƵ
#define	CLK_CKLSEL_EHCRYSTAL		B0011_0000	//				ⲿƵ
#define	CLK_RC32MDIV_1				B0000_0000	//ڲƵRCƵϵ1Ƶ
#define	CLK_RC32MDIV_2				B0000_0001	//					2Ƶ
#define	CLK_RC32MDIV_4				B0000_0010	//					4Ƶ				
#define	CLK_RC32MDIV_8				B0000_0011	//					8Ƶ(Ĭ)
/**************************************************************************************/
/*ʱӷƵĴ CLKDIV : CPUʱӷƵϵ*/
/*ۿ(1~255)ƵFoscõCPUƵ,оٳ÷Ƶϵ*/
#define	CLK_CLKDIV_1				B0000_0001	//CPUƵΪFosc/1
#define	CLK_CLKDIV_2				B0000_0010	//CPUƵΪFosc/2(Ĭ)
#define	CLK_CLKDIV_4				B0000_0100	//CPUƵΪFosc/4
#define	CLK_CLKDIV_8				B0000_1000	//CPUƵΪFosc/8
#define	CLK_CLKDIV_16				B0001_0000	//CPUƵΪFosc/16
#define	CLK_CLKDIV_32				B0010_0000	//CPUƵΪFosc/32
#define	CLK_CLKDIV_64				B0100_0000	//CPUƵΪFosc/64
#define	CLK_CLKDIV_128				B1000_0000	//CPUƵΪFosc/128
/**************************************************************************************/
/*ʱĴ CLKOUT */
/*ʱʹλ:BIT4;ʱѡλBIT2~BIT0 */
#define	CLK_CLKOUTEN				BIT4		//ʱʹλ
#define	CLK_CLKOUTSEL_CPU			B0000_0000	//ѡCPUʱ
#define	CLK_CLKOUTSEL_OSC			B0000_0001	//ѡϵͳʱ
#define	CLK_CLKOUTSEL_WDT			B0000_0010	//ѡŹʱ
#define	CLK_CLKOUTSEL_XTAL			B0000_0011	//ѡⲿʱ
//#define	CLK_CLKOUTSEL_HRC_1			B0000_0100	//ѡڲƵ32Mʱ(,ʵʲ)
#define	CLK_CLKOUTSEL_HRC_2			B0000_0101	//ѡڲƵ32M/2ʱ
#define	CLK_CLKOUTSEL_HRC_4			B0000_0110	//ѡڲƵ32M/4ʱ
#define	CLK_CLKOUTSEL_HRC_8			B0000_0111	//ѡڲƵ32M/8ʱ
/**************************************************************************************/
/*ⲿüĴ XTALCFG */
#define	CLK_HXTALCFG_2048			B0000_0000	//ⲿƵwarmupֵѡ(Ĭ)
#define	CLK_HXTALCFG_256			B0100_0000
#define	CLK_HXTALCFG_16384			B1000_0000
#define	CLK_HXTALCFG_65536			B1100_0000
#define	CLK_LXTALCFG_16384			B0000_0000	//ⲿƵwarmupֵѡ(Ĭ)
#define	CLK_LXTALCFG_4096			B0001_0000
#define	CLK_LXTALCFG_1024			B0010_0000
#define	CLK_LXTALCFG_65536			B0011_0000
#define	CLK_HXTAL_MODE_1			B0000_0000	//ⲿƵѡ:4M/8M(Ĭ)
#define	CLK_HXTAL_MODE_2			B0000_0100	//                4M/8Mģʽ,ѹʱ,ʱҹ
#define	CLK_HXTAL_MODE_3			B0000_1100	//				  16M/20M
#define	CLK_RCENPD					BIT1		//ϵͳBORλʱ,ڲƵRCرź
#define	CLK_XTALSEL					BIT0		//ⲿƵ
/**************************************************************************************/
/*ʱƵʼĴ FREQ_CLK(Ĭֵ0x02) */
#define	FREQ_CLK_16MHZ				0x10
#define	FREQ_CLK_8MHZ				0x08
#define	FREQ_CLK_4MHZ				0x04
#define	FREQ_CLK_2MHZ				0x02
#define	FREQ_CLK_1MHZ				0x01
/*ڽFLASHIAPдϵͳģʽ֮ǰ,ҪչSFRFREQ_CLKĴ,
ָĿǰCPUʱӵƵ,FREQ_CLKĴõֵCPUʱӵƵֵ,СΪ 1MHz*/

/*ڲƵRCʹܼĴ TRMEN(Ĭֵ0)*/
#define	TRMEN_RCEN					0x01		//ʹڲƵRC

/*ڲƵRCüĴ TRMV(ĬֵB0xxx_xxxx)*/
/*λֵΪУ׼ֵ*/
/**************************************************************************************/
/*WDT ƼĴ WDTC ,WDTʱԴΪڲƵ44K (Ĭֵ0B_0100_1111)*/
#define	WDT_WDTRST				BIT6		//0/1:ֹ/WDTλ(Ĭ)
#define	WDT_WDTF				BIT5		//WDTж־λ
#define	WDT_WDTCLR				BIT4		//WDT
#define	WDT_WDTPD				BIT3		//0/1:/ֹ,/ģʽ/ֹWDT(ĬϽֹ)
#define	WDT_WDTPS_8				B0000_0000	//ŹʱʱԴƵ/8
#define	WDT_WDTPS_16			B0000_0001	//						/16
#define	WDT_WDTPS_32			B0000_0010	//						/32
#define	WDT_WDTPS_64			B0000_0011	//						/64
#define	WDT_WDTPS_128			B0000_0100	//						/128
#define	WDT_WDTPS_256			B0000_0101	//						/256
#define	WDT_WDTPS_512			B0000_0110	//						/512
#define	WDT_WDTPS_1024			B0000_0111	//						/1024

/*WDT ȽϼĴ WDTCCR(Ĭֵ0xFF) */
/* 44KHz Ϊм:ʱ =( WDTƵϵ * (WDTCCR[7:0]+1))/ʵڲƵRCƵ */
// PS2  PS1  PS0  WDTƵϵ  ֵ  WDTʱ@44K
//	0  	 0    0     8           0.182ms        46.55ms
//	0  	 0    1     16          0.364ms        93.09ms
//	0  	 1    0     32          0.728ms        186.18ms
//	0  	 1    1     64          1.456ms        372.36ms
//	1  	 0    0     128         2.912ms        744.73ms
//	1  	 0    1     256         5.824ms        1489.45ms
//	1  	 1    0     512         11.648ms       2978.91ms
//	1  	 1    1     1024        23.296ms       5957.82ms
/**************************************************************************************/
/* LVD ƼĴ LVDC (Ĭֵ0)*/
#define	LVD_LVDEN				BIT7		//0/1:ֹ /  LVD/Ƚ
#define	LVD_LVDS				BIT6		//0/1:VDDѹ / P26˿ڵѹ
#define	LVD_LVDIE				BIT5		//0/1:ֹ /  LVDж
#define	LVD_LVDF				BIT3		//0/1: / VDDѹڼѹʱ1
#define	LVD_LVDV_19V			B0000_0000	//LVDѹѡ:1.9V (LVDѹøBORõѹ)
#define	LVD_LVDV_20V			B0000_0001	//			 :2.0V
#define	LVD_LVDV_24V			B0000_0010	//           :2.4V
#define	LVD_LVDV_26V			B0000_0011	//           :2.6V
#define	LVD_LVDV_30V			B0000_0100	//           :3.0V
#define	LVD_LVDV_36V			B0000_0101	//           :3.6V
#define	LVD_LVDV_39V			B0000_0110	//           :3.9V
#define	LVD_LVDV_42V			B0000_0111	//           :4.2V

/* ȽϹܿƼĴ LVDCMP (Ĭֵ0x20)*/
#define	LVD_DEEN				BIT5		//0/1: /   (LVD/CMP)
#define	LVD_CMPSTA				BIT4		//0/1:Ƚ˵ѹ С /  ˵ѹ
#define	LVD_CMPIM_0				B0000_0000	//λLVDF
#define	LVD_CMPIM_1				B0000_0100	//CMP+С CMP- CMP-λ LVDF
#define	LVD_CMPIM_2				B0000_1000	//CMP+Ӵ CMP-С CMP-λ LVDF
#define	LVD_CMPIM_3				B0000_1100	//CMP+С CMP- CMP- CMP+Ӵ CMP-С CMP-λ LVDF
#define	LVD_CMPPS_12			B0000_0000	//Ƚѡ:1.2V
#define	LVD_CMPPS_CMP1			B0000_0001	//				:CMP1ܽ
#define	LVD_CMPPS_CMP2			B0000_0001	//				:CMP2ܽ
#define	LVD_CMPPS_CMP3			B0000_0001	//				:CMP3ܽ

/* LVD ȥƼĴ LVDDBC (Ĭֵ0)*/
/* ʱ = LVDDBC[7:0]*8Tcpu+2Tcpu */
/**************************************************************************************/
/* ԴƼĴ PCON */
#define	POWER_GF1				BIT3		//ûͨñ־λ1
#define	POWER_GF0				BIT2		//ûͨñ־λ0
#define	POWER_PD				BIT1		//0/1:ģʽ/ģʽ
#define	POWER_IDL				BIT0		//0/1:ģʽ/ģʽ
/**************************************************************************************/
/* λ־Ĵ RSTFR */
#define	RST_PORF				BIT7		//ϵ縴λ
#define	RST_EXRSTF				BIT6		//ⲿRSTλ
#define	RST_BORF				BIT5		//Ƿѹλ
#define	RST_WDTRF				BIT4		//WDTλ
#define	RST_SWRF				BIT3		//λ
#define	RST_SPOVF				BIT1		//ջ
#define	RST_PLVRSTF				BIT0		//ⲿ˿ڵѹ
/**************************************************************************************/
/*BOR ѹƼĴ BORC */
#define	BORC_BOREN				BIT7		//0/1:ֹ/ʹܵ͵ѹλ(Ĭʹ)
#define	BORC_BORDBCEN			BIT6		//0/1:ʹ/ʹ(Ĭϲʹ)
#define	BORC_BORPDEN			BIT5		//0/1: ʹ/ʹBORԴ(Ĭϲʹ)
#define	BORC_BORVS_18V			B0000_0000	//Ƿѹλѹ1.8V
#define	BORC_BORVS_20V			B0000_0001	//Ƿѹλѹ2.0V
#define	BORC_BORVS_24V			B0000_0010	//Ƿѹλѹ2.4V
#define	BORC_BORVS_26V			B0000_0011	//Ƿѹλѹ2.6V
#define	BORC_BORVS_30V			B0000_0100	//Ƿѹλѹ3.0V
#define	BORC_BORVS_36V			B0000_0101	//Ƿѹλѹ3.6V
#define	BORC_BORVS_39V			B0000_0110	//Ƿѹλѹ3.9V
#define	BORC_BORVS_42V			B0000_0111	//Ƿѹλѹ4.2V

/*BOR ѹȥƼĴBORDBC */
/*ʱ = BORDBC[7:0] * 8Tcpu +2Tcpu */

/*ⲿ RST ȥƼĴRSTDBC */
/*ʱ = RSTDBC[7:0] * 8Tcpu +2 Tcpu */ 
	
/*ջλʹܼĴ ջλʹܼĴSPOV_RSTEN */
#define	SPOV_SPOVRSTEN				BIT0		//0/1:ʹ/ʹܶջλ
/**************************************************************************************/
/*жĴIE,IE1(ʼֵΪ0) */
#define	INT_EA_EN				BIT7		//CPUж
#define	INT_ES2_EN				BIT6		//UART2ж
#define	INT_EWDT_EN				BIT5		//WDTж
#define	INT_ES1_EN				BIT4		//UART1ж
#define	INT_ET1_EN				BIT3		//TIM1ж
#define	INT_EX1_EN				BIT2		//INT1ж
#define	INT_ET0_EN				BIT1		//TIM0ж
#define	INT_EX0_EN				BIT0		//INT0ж

#define	INT_EX8_15_EN			BIT7		//ⲿж8~15
#define	INT_EX2_7_EN			BIT6		//ⲿж2~7
#define	INT_EADC_EN 			BIT5		//ADCж
#define	INT_T5_EN 				BIT4		//TIM5ж
#define	INT_IIC_EN 				BIT0		//IICж
#define	INT_T4_EN				BIT2		//TIM4ж
#define	INT_T3_EN 				BIT1		//TIM3ж
#define	INT_ESPI_EN 			BIT0		//SPIж

/*жȼѡĴIP0,IP1,IP2,IP3,IP4(ʼֵΪ0) */
#define	INT_PT1_0				B0000_0000	//T1 жȼ0()
#define	INT_PT1_1				B0100_0000	//				 1
#define	INT_PT1_2				B1000_0000	//				 2
#define	INT_PT1_3				B1100_0000	//				 3()
#define	INT_PX1_0				B0000_0000	//INT1 жȼ0()
#define	INT_PX1_1				B0001_0000	//				 1
#define	INT_PX1_2				B0010_0000	//				 2
#define	INT_PX1_3				B0011_0000	//				 3()
#define	INT_PT0_0				B0000_0000	//T0 жȼ0()
#define	INT_PT0_1				B0000_0100	//				 1
#define	INT_PT0_2				B0000_1000	//				 2
#define	INT_PT0_3				B0000_1100	//				 3()
#define	INT_PX0_0				B0000_0000	//INT0 жȼ0()
#define	INT_PX0_1				B0000_0001	//				 1
#define	INT_PX0_2				B0000_0010	//				 2
#define	INT_PX0_3				B0000_0011	//				 3()

#define	INT_PS2_0				B0000_0000	//UART2 жȼ0()
#define	INT_PS2_1				B0100_0000	//				 1
#define	INT_PS2_2				B1000_0000	//				 2
#define	INT_PS2_3				B1100_0000	//				 3()
#define	INT_LVD_0				B0000_0000	//LVD жȼ0()
#define	INT_LVD_1				B0001_0000	//				 1
#define	INT_LVD_2				B0010_0000	//				 2
#define	INT_LVD_3				B0011_0000	//				 3()
#define	INT_WDT_0				B0000_0000	//WDT жȼ0()
#define	INT_WDT_1				B0000_0100	//				 1
#define	INT_WDT_2				B0000_1000	//				 2
#define	INT_WDT_3				B0000_1100	//				 3()
#define	INT_UART1_0				B0000_0000	//UART1 жȼ0()
#define	INT_UART1_1				B0000_0001	//				 1
#define	INT_UART1_2				B0000_0010	//				 2
#define	INT_UART1_3				B0000_0011	//				 3()

#define	INT_PPWM_0				B0000_0000	//PWM жȼ0()
#define	INT_PPWM_1				B0100_0000	//				 1
#define	INT_PPWM_2				B1000_0000	//				 2
#define	INT_PPWM_3				B1100_0000	//				 3()
#define	INT_PT4_0				B0000_0000	//TIM4 жȼ0()
#define	INT_PT4_1				B0001_0000	//				 1
#define	INT_PT4_2				B0010_0000	//				 2
#define	INT_PT4_3				B0011_0000	//				 3()
#define	INT_PT3_0				B0000_0000	//TIM3 жȼ0()
#define	INT_PT3_1				B0000_0100	//				 1
#define	INT_PT3_2				B0000_1000	//				 2
#define	INT_PT3_3				B0000_1100	//				 3()
#define	INT_PSPI_0				B0000_0000	//SPI жȼ0()
#define	INT_PSPI_1				B0000_0001	//				 1
#define	INT_PSPI_2				B0000_0010	//				 2
#define	INT_PSPI_3				B0000_0011	//				 3()

#define	INT_PX815_0				B0000_0000	//INT8_15 жȼ0()
#define	INT_PX815_1				B0100_0000	//				 1
#define	INT_PX815_2				B1000_0000	//				 2
#define	INT_PX815_3				B1100_0000	//				 3()
#define	INT_PX27_0				B0000_0000	//INT2_7 жȼ0()
#define	INT_PX27_1				B0001_0000	//				 1
#define	INT_PX27_2				B0010_0000	//				 2
#define	INT_PX27_3				B0011_0000	//				 3()
#define	INT_PADC_0				B0000_0000	//ADC жȼ0()
#define	INT_PADC_1				B0000_0100	//				 1
#define	INT_PADC_2				B0000_1000	//				 2
#define	INT_PADC_3				B0000_1100	//				 3()
#define	INT_PT5_0				B0000_0000	//TIM5 жȼ0()
#define	INT_PT5_1				B0000_0001	//				 1
#define	INT_PT5_2				B0000_0010	//				 2
#define	INT_PT5_3				B0000_0011	//				 3()

#define	INT_PIIC_0				B0000_0000	//IIC жȼ0()
#define	INT_PIIC_1				B0000_0001	//				 1      
#define	INT_PIIC_2				B0000_0010	//				 2      
#define	INT_PIIC_3				B0000_0011	//				 3()

/*ⲿжϵƽѡĴPITS0,PITS1,PITS2,PITS3 (ʼֵΪ0) */
#define	INT_IT3_L				B0000_0000	//IT3 ⲿжϴ ͵ƽ
#define	INT_IT3_LE				B0100_0000	//				     ½ж
#define	INT_IT3_HE				B1000_0000	//				     ж
#define	INT_IT3_LHE				B1100_0000	//				     ½ж
#define	INT_IT2_L				B0000_0000	//IT2 ⲿжϴ ͵ƽ        
#define	INT_IT2_LE				B0001_0000	//				     ½ж    
#define	INT_IT2_HE				B0010_0000	//				     ж    
#define	INT_IT2_LHE				B0011_0000	//				     ½ж
#define	INT_IT1_L				B0000_0000	//IT1 ⲿжϴ ͵ƽ        
#define	INT_IT1_LE				B0000_0100	//				     ½ж    
#define	INT_IT1_H				B0000_1000	//				     ж    
#define	INT_IT1_LHE				B0000_1100	//				     ½ж
#define	INT_IT0_L				B0000_0000	//IT0 ⲿжϴ ͵ƽ        
#define	INT_IT0_LE				B0000_0001	//				     ½ж    
#define	INT_IT0_HE				B0000_0010	//				     ж    
#define	INT_IT0_LHE				B0000_0011	//				     ½ж

#define	INT_IT7_L				B0000_0000	//IT7 ⲿжϴ ͵ƽ
#define	INT_IT7_LE				B0100_0000	//				     ½ж
#define	INT_IT7_HE				B1000_0000	//				     ж
#define	INT_IT7_LHE				B1100_0000	//				     ½ж
#define	INT_IT6_L				B0000_0000	//IT6 ⲿжϴ ͵ƽ        
#define	INT_IT6_LE				B0001_0000	//				     ½ж    
#define	INT_IT6_HE				B0010_0000	//				     ж    
#define	INT_IT6_LHE				B0011_0000	//				     ½ж
#define	INT_IT5_L				B0000_0000	//IT5 ⲿжϴ ͵ƽ        
#define	INT_IT5_LE				B0000_0100	//				     ½ж    
#define	INT_IT5_HE				B0000_1000	//				     ж    
#define	INT_IT5_LHE				B0000_1100	//				     ½ж
#define	INT_IT4_L				B0000_0000	//IT4 ⲿжϴ ͵ƽ        
#define	INT_IT4_LE				B0000_0001	//				     ½ж    
#define	INT_IT4_HE				B0000_0010	//				     ж    
#define	INT_IT4_LHE				B0000_0011	//				     ½ж

#define	INT_IT11_L				B0000_0000	//IT11 ⲿжϴ ͵ƽ
#define	INT_IT11_LE				B0100_0000	//				     ½ж
#define	INT_IT11_HE				B1000_0000	//				     ж
#define	INT_IT11_LHE			B1100_0000	//				     ½ж
#define	INT_IT10_L				B0000_0000	//IT10 ⲿжϴ ͵ƽ        
#define	INT_IT10_LE				B0001_0000	//				     ½ж    
#define	INT_IT10_HE				B0010_0000	//				     ж    
#define	INT_IT10_LHE			B0011_0000	//				     ½ж
#define	INT_IT9_L				B0000_0000	//IT9 ⲿжϴ ͵ƽ        
#define	INT_IT9_LE				B0000_0100	//				     ½ж    
#define	INT_IT9_HE				B0000_1000	//				     ж    
#define	INT_IT9_LHE				B0000_1100	//				     ½ж
#define	INT_IT8_L				B0000_0000	//IT8 ⲿжϴ ͵ƽ        
#define	INT_IT8_LE				B0000_0001	//				     ½ж    
#define	INT_IT8_HE				B0000_0010	//				     ж    
#define	INT_IT8_LHE				B0000_0011	//				     ½ж

#define	INT_IT15_L				B0000_0000	//IT15 ⲿжϴ ͵ƽ
#define	INT_IT15_LE				B0100_0000	//				     ½ж
#define	INT_IT15_HE				B1000_0000	//				     ж
#define	INT_IT15_LHE			B1100_0000	//				     ½ж
#define	INT_IT14_L				B0000_0000	//IT14 ⲿжϴ ͵ƽ        
#define	INT_IT14_LE				B0001_0000	//				     ½ж    
#define	INT_IT14_HE				B0010_0000	//				     ж    
#define	INT_IT14_LHE			B0011_0000	//				     ½ж
#define	INT_IT13_L				B0000_0000	//IT13 ⲿжϴ ͵ƽ        
#define	INT_IT13_LE				B0000_0100	//				     ½ж    
#define	INT_IT13_HE				B0000_1000	//				     ж    
#define	INT_IT13_LHE			B0000_1100	//				     ½ж
#define	INT_IT12_L				B0000_0000	//IT12 ⲿжϴ ͵ƽ        
#define	INT_IT12_LE				B0000_0001	//				     ½ж    
#define	INT_IT12_HE				B0000_0010	//				     ж    
#define	INT_IT12_LHE			B0000_0011	//				     ½ж

/* ⲿж2-15 ʹܿƼĴPINTE0,PINTE1(ʼֵΪ0) */
#define	INT_EINT7				BIT7		//0/1:ֹ /  INT7˿ж
#define	INT_EINT6				BIT6		//0/1:ֹ /  INT6˿ж
#define	INT_EINT5				BIT5		//0/1:ֹ /  INT5˿ж
#define	INT_EINT4				BIT4		//0/1:ֹ /  INT4˿ж
#define	INT_EINT3				BIT3		//0/1:ֹ /  INT3˿ж
#define	INT_EINT2				BIT2		//0/1:ֹ /  INT2˿ж

#define	INT_EINT15				BIT7		//0/1:ֹ /  INT15˿ж
#define	INT_EINT14				BIT6		//0/1:ֹ /  INT14˿ж
#define	INT_EINT13				BIT5		//0/1:ֹ /  INT13˿ж
#define	INT_EINT12				BIT4		//0/1:ֹ /  INT12˿ж
#define	INT_EINT11				BIT3		//0/1:ֹ /  INT11˿ж
#define	INT_EINT10				BIT2		//0/1:ֹ /  INT10˿ж
#define	INT_EINT9				BIT1		//0/1:ֹ /  INT9˿ж
#define	INT_EINT8				BIT0		//0/1:ֹ /  INT8˿ж

/* ⲿжϱ־ĴPINTF0,PINTF1(ʼֵΪ0) */
#define	INT_INT7F				BIT7		//0/1: INT7ж־λ,0 / Ӳ1
#define	INT_INT6F				BIT6		//0/1: INT6ж־λ,0 / Ӳ1
#define	INT_INT5F				BIT5		//0/1: INT5ж־λ,0 / Ӳ1
#define	INT_INT4F				BIT5		//0/1: INT4ж־λ,0 / Ӳ1
#define	INT_INT3F				BIT3		//0/1: INT3ж־λ,0 / Ӳ1
#define	INT_INT2F				BIT2		//0/1: INT2ж־λ,0 / Ӳ1
#define	INT_INT1F				BIT1		//0/1: INT1ж־λ,0 / Ӳ1
#define	INT_INT0F				BIT0		//0/1: INT0ж־λ,0 / Ӳ1

#define	INT_INT15F				BIT7		//0/1: INT15ж־λ,0 / Ӳ1
#define	INT_INT14F				BIT6		//0/1: INT14ж־λ,0 / Ӳ1
#define	INT_INT13F				BIT5		//0/1: INT13ж־λ,0 / Ӳ1
#define	INT_INT12F				BIT4		//0/1: INT12ж־λ,0 / Ӳ1
#define	INT_INT11F				BIT3		//0/1: INT11ж־λ,0 / Ӳ1
#define	INT_INT10F				BIT2		//0/1: INT10ж־λ,0 / Ӳ1
#define	INT_INT9F				BIT1		//0/1: INT9ж־λ,0 / Ӳ1
#define	INT_INT8F				BIT0		//0/1: INT8ж־λ,0 / Ӳ1

/* ⲿж01 ܽѡĴINT01_PINS (ʼֵΪ0) */
#define	INT_INT1_P01			B0000_0000	//INT1ܽѡ P01
#define	INT_INT1_P11			B0000_0010	//INT1ܽѡ P11
#define	INT_INT0_P00			B0000_0000	//INT0ܽѡ P00
#define	INT_INT0_P10			B0000_0001	//INT0ܽѡ P10
/**************************************************************************************/
/* CRC ƼĴ CRCC (Ĭ0) */
#define	CRC_CRCBIT				BIT2		//0/1:CRC BIT תλ->MSB / LSB first 
#define	CRC_CRCRSV				BIT1		//0/1:λֵΪ 0x0000 / 0xFFFF
#define	CRC_W_CRCRST			BIT0		//1λ CRC ,ӲԶ0

/* CRC ݼĴCRCL,CRCH (Ĭ0) */
/* CRCL дʱΪ CRC ;ʱΪ CRC ĵֽ	*/
/*      дʱԶ CRC ,Զر */
/* CRCH ԸüĴдЧ,ʱΪ CRC ĸֽ */
/* ÿһдݣǰһμͬ */
/* 16λCRC;CRCУCRC-CCITTʽ(0x1021);ֵΪ0x00000xFFFF */
/* ͬһĴ */
/**************************************************************************************/



/**************************************************************************************/
void config_sysclk_ihrc_module(void);
void config_sysclk_crystal_module(void);
void config_sysclk_output(void);
void enable_watchdog(void);
void enable_watchdog_for_stop(void);
void disable_watchdog(void);
void feed_watchdog(void);
void reset_check(void);
u16 hd_crc_calculate(u8 u8_length,u8 *u8_data_addr);
/**************************************************************************************/
#endif
