/**
*   ************************************************************************************


*   ************************************************************************************
**/

/***************************************************************************************
*									 ģܽ
*	1UART14ֹʽַʽУκνSBUFΪĿĴд
*	   ʽ 0ͬ˫ͨѶ
*	   ʽ 18λUARTɱ䲨ʣ첽ȫ˫
*	   ʽ 29λUART̶ʣ첽ȫ˫
*	   ʽ 39λUARTɱ䲨ʣ첽ȫ˫
*	2UART22ֹʽκνSBUFΪĿĴд
*	   ʽ 08λUARTɱ䲨ʣ첽ȫ˫
*	   ʽ 19λUARTɱ䲨ʣ첽ȫ˫
*	************************************************************************************
*									 Ӧע
*	1ʹôʱҪFoscFcpuʱһ£ʱӲһ£ͳͻ־λTXCOL
*	   ɴڹ쳣
*   2UART2 ʹȫ˫ʱҪ CPU ƵΪ 16MHz ϣ 9600 £
*       UART2 жϷﾡ TI  RI
***************************************************************************************/

/**************************************************************************************/
#include ".\port\port_mcu.h"	
/***************************************************************************************/
//
#define	UART1_TX_NUM				5
#define	UART1_RX_NUM				5
u8	u8_uart1_rx_ok = 0;
u8	u8_uart1_rx_data[UART1_RX_NUM];
u8	u8_uart1_rx_data_index = 0;
/***************************************************************************************
* @    ʼUART1
* @˵    
* @    
* @ֵ 
* @ע 	   
***************************************************************************************/
void config_uart1_module(u8 u8_type)
{
//				  Fosc=4M	  Fosc=8M	  Fosc=16M	  Fosc=32M
//  	1200			FF30		FE5F		FCBF		F97D
//		2400			FF98		FF30		FE5F		FCBF
//		4800			FFCC		FF98        FF30		FE5F
//		9600			FFE6		FFCC        FF98		FF30
//		19200			FFF3		FFE6        FFCC		FF98
//		38400			 \			FFF3		FFE6		FFCC
//		57600			 \           \          FFEF		FFDD
//		115200			 \			 \			 \			FFEF

	// => 9600 = T4ʱԴƵ/(16*(65536-[TH4:TL4]))
	//32000000/(16*(65536-65328)) ~= 9615 Լ0.16%
	//FF30->9600;FF98->19200;FFCC->38400;FFDD->57600;FFEF->115200
	//Fosc=32M,19200
	TH4 = 0xFF;
	TL4 = 0x98;
	//T4ģʽ:ΪUART1ʷ,ʱFoscƵ,ʹT4
	T4CON = TIM_T4PS_1 | TIM_T4M_1 | TIM_TR4_EN | TIM_T4CLKS_FOSC;
	BRTSEL = UART_UART1SEL_T4;
	//UART1ʽ1,
	SCON2 = UART1_SM1SM0_MODE1;
	
	switch(u8_type)
	{
		case D_UART_TX:
			//TX PIN ;
			uart1_tx_pin_att();
			uart1_tx_pin_status(1);
			uart1_tx_pin_map();
		break;
		case D_UART_RX:
			//RX PIN 	
			uart1_rx_pin_att();
			uart1_rx_pin_map();
			//н
			SCON = UART1_REN_EN;
			//UART1ж,жн
			IE |= INT_ES1_EN;
		break;
		case D_UART_TX_RX:
			uart1_tx_pin_att();
			uart1_tx_pin_status(1);
			uart1_tx_pin_map();
			uart1_rx_pin_att();
			uart1_rx_pin_map();
			//н
			SCON = UART1_REN_EN;
			//UART1ж,жн
			IE |= INT_ES1_EN;
		break;
	}
}
/**************************************************************************************/


/***************************************************************************************
* @    UART1һBYTE
* @˵  	
* @	    
* @ֵ   
* @ע			   
***************************************************************************************/
void uart1_tx_byte(u8 u8_data)
{
//	IE &= ~INT_ES1_EN;			//ֹж
	SBUF = u8_data;
	while(!(SCON & UART1_INT_TI));
	SCON &= ~UART1_INT_TI;
//	IE |= INT_ES1_EN;
}
/***************************************************************************************
* @    UART1 Ͷ
* @˵  	
* @	    u8_length  ݳ(ȡֵΧ0x00-0xFF)
* @	    *u8_data_addr ȡݴŵ׵ַ
* @ֵ   
* @ע			   
***************************************************************************************/
void uart1_tx_data(u8 u8_length, u8 *u8_data_buf)
{
	//
	u8 i;

	for(i=0; i<u8_length; i++)
	{
		SBUF = u8_data_buf[i];
		while(!(SCON & UART1_INT_TI));
		SCON &= ~UART1_INT_TI;
	}
}
/**************************************************************************************/
void uart1_tx_data_start(u8 *u8_index, u8 *u8_data_buf)
{
	//͵һֽ,ֽжз
	*u8_index = 0;
	SBUF = u8_data_buf[0];
}
/**************************************************************************************/	
static void uart1_tx_data_int(u8 *u8_index, u8 *u8_data_buf)
{	//UART1же
	//UART͵һBYTEݺ,жз	
	if(SCON & UART1_INT_TI)
	{
		SCON &= ~UART1_INT_TI;
		*u8_index += 1;
		if(*u8_index < UART1_TX_NUM)
		{
			SBUF = u8_data_buf[*u8_index];
		}
	}
}
/**************************************************************************************/


/***************************************************************************************
* @    UART1жлȡ UART_RX_NUM (0x55ʼ),ݱ־
* @˵    UART1же
* @    
* @ֵ 
* @ע 	   
***************************************************************************************/
static void uart1_rx_data_int(u8 *u8_index,u8 *u8_buf,u8 *u8_flag)
{	//
	u8 buf;
	
	if(SCON & UART1_INT_RI)
	{	//Эʽ
		SCON &= ~UART1_INT_RI;
		buf = SBUF;
		
		if(*u8_index >= UART1_RX_NUM)
		{	//ݴ洢ָ쳣
			*u8_index = 0;
		}
		if(1 != *u8_flag)
		{	//λʱٽ,ݱ
			if((0 == *u8_index) && (0x55 == buf))
			{	//ݿʼ
				u8_buf[0] = 0x55;
			}
			else
			{
				*u8_index += 1;
				u8_buf[*u8_index] = buf;
				if(*u8_index >= (UART1_RX_NUM - 1))
				{//ݽ
					*u8_flag = 1;
					*u8_index = 0;
				}
			}
		}	
	}
}
/**************************************************************************************/




/***************************************************************************************
* @ 	UART1жϷ 
* @˵    
* @    
* @ֵ 
* @ע 
***************************************************************************************/
void uart1_rpt(void) interrupt UART1_VECTOR
{
	uart1_rx_data_int(&u8_uart1_rx_data_index,u8_uart1_rx_data,&u8_uart1_rx_ok);
//	uart1_tx_data_int(&u8_uart1_tx_data_index,u8_uart1_tx_data);

/*	
	u8 buf;
	
	if(SCON & UART1_INT_RI)
	{	//Эʽ
		SCON &= ~UART1_INT_RI;
		buf = SBUF;
		
		
		if(u8_uart1_rx_data_index >= UART1_RX_NUM)
		{	//ݴ洢ָ쳣
			u8_uart1_rx_data_index = 0;
		}
		if(1 != u8_uart1_rx_ok)
		{
			if((0 == u8_uart1_rx_data_index) && (0x55 == buf))
			{	//ݿʼ
				u8_uart1_rx_data[0] = 0x55;
			}
			else
			{
				u8_uart1_rx_data_index++;
				u8_uart1_rx_data[u8_uart1_rx_data_index] = buf;
				if(u8_uart1_rx_data_index >= (UART1_RX_NUM - 1))
				{//ݽ
					u8_uart1_rx_ok = 1;
					u8_uart1_rx_data_index = 0;	
				}
			}
		}	
	}
*/
}
/*************************************************************************************/




/***************************************************************************************
* @     ޷תΪַ
* @˵  	
* @	    
* @	   
* @ֵ   ַ,ַ
* @ע  
***************************************************************************************/
u8 number_to_string(u32 u32_num, u8 *u8_buf)
{
	u8 i,j;
	u8 buf[20];
	u32 k;
	
	k = u32_num;
	for(i=0;  ; i++)
	{
		j = k % 10;
		k /= 10;
		buf[i] = j + '0';
		if(0 == k)
		{
			break;
		}
	}
	for(j=0,k=i+1; j<k; j++,i--)
	{
		u8_buf[j] = buf[i];
	}
	return j;
}
/**************************************************************************************/

