/**
*   ************************************************************************************


*   ************************************************************************************
**/

#ifndef __GPIO_H__
#define	__GPIO_H__
/**************************************************************************************/


/**************************************************************************************/
/*˿ݼĴ P0,P1,P2 */
/*˿ڹѡĴ P0M0,P0M1,P0M2,P0M3,P1M0,P2M0,P2M1,P2M2,P2M3*/
#define	IO_IN						0	//,ʩ
#define	IO_IN_PULL_DOWN				1	//,ʩ[P23,P24,P25,P27ִ֧˹]
#define	IO_IN_PULL_UP				2	//,ʩ[P23,P24,P25,P27ִ֧˹]
#define	IO_IN_ANALOG				3	//ģ,
#define	IO_SMTIN					4	//,ʩ
#define	IO_SMTIN_PULL_DOWN			5	//,ʩ
#define	IO_SMTIN_PULL_UP			6	//,ʩ
#define	IO_IN_PULL_UP_DOWN			7	//ģ[P2.3/P2.4/P2.5/P2.7ִ֧˹]
#define	IO_OUT_PUSH_PULL			12	//
#define	IO_OUT_OPEN_DRAIN			13	//©
#define	IO_OUT_OPENDRAIN_PULLUP		14	//©
#define	IO_OUT_REMAIN				15	//()
/**************************************************************************************/
/*˿ѡĴ P0LPU */
/*λ BIT5,BIT4*/
#define	IO_PULL_RESISTANCE_50K		B0000_0000
#define	IO_PULL_RESISTANCE_100K		B0001_0000
#define	IO_PULL_RESISTANCE_150K		B0010_0000
#define	IO_PULL_RESISTANCE_300K		B0011_0000
/**************************************************************************************/
/*˿ƼĴ P00DBC,P01DBC,P02DBC */
/*ʱѡBIT7,BIT6;ʱBIT5~BIT0*/
#define	IO_DEBOUNCING_CLOCK_FOSE_1	B0000_0000
#define	IO_DEBOUNCING_CLOCK_FOSE_4	B0100_0000
#define	IO_DEBOUNCING_CLOCK_FOSE_16	B1000_0000
#define	IO_DEBOUNCING_CLOCK_FOSE_64	B1100_0000
/**************************************************************************************/
/* 蹦ӳſƼĴ,ʹ蹦֮ܽǰ蹦ӳĴ,蹦ܽ޷ʹ */
/* T0_MAP,T1_MAP,T3_MAP,T4_MAP,T5_MAP */
/* PWM0_MAP,PWM01_MAP,PWM1_MAP,PWM11_MAP,PWM2_MAP,PWM21_MAP,PWM3_MAP */              
/* TXD_MAP,RXD_MAP,TXD2_MAP,RXD2_MAP */
/* SCL_MAP,SDA_MAP */
/* CLKO_MAP */
/* SS_MAP,SCK_MAP,MOSI_MAP,MISO_MAP */
/**************************************************************************************/
//IO:att = (0....11)
#define	att_p00(att)				P0M0 = (P0M0 & 0xF0) | (att)
#define	att_p01(att)				P0M0 = (P0M0 & 0x0F) | (att << 4)
#define	att_p02(att)				P0M1 = (P0M1 & 0xF0) | (att)
#define	att_p03(att)				P0M1 = (P0M1 & 0x0F) | (att << 4)
#define	att_p04(att)				P0M2 = (P0M2 & 0xF0) | (att)
#define	att_p05(att)				P0M2 = (P0M2 & 0x0F) | (att << 4)
#define	att_p06(att)				P0M3 = (P0M3 & 0xF0) | (att)
#define	att_p07(att)				P0M3 = (P0M3 & 0x0F) | (att << 4)
#define	att_p10(att)				P1M0 = (P1M0 & 0xF0) | (att)
#define	att_p11(att)				P1M0 = (P1M0 & 0x0F) | (att << 4)
#define	att_p20(att)				P2M0 = (P2M0 & 0xF0) | (att)
#define	att_p21(att)				P2M0 = (P2M0 & 0x0F) | (att << 4)
#define	att_p22(att)				P2M1 = (P2M1 & 0xF0) | (att)
#define	att_p23(att)				P2M1 = (P2M1 & 0x0F) | (att << 4)
#define	att_p24(att)				P2M2 = (P2M2 & 0xF0) | (att)
#define	att_p25(att)				P2M2 = (P2M2 & 0x0F) | (att << 4)
#define	att_p26(att)				P2M3 = (P2M3 & 0xF0) | (att)
#define	att_p27(att)				P2M3 = (P2M3 & 0x0F) | (att << 4)

//IO״̬:pin = (P0_1,...,P2_7);status = (0,1)
#define	pin_out(pin,status)			pin = status;
//IO״̬ת:port = (P0,P1,P2);pin = (0~7)
#define	pin_tog_p(port,pin)			port ^= (0x01 << pin)
//IO״̬ת:pin = (P0_1,...,P2_7)
#define	pin_tog(pin)				pin = ~pin

//MAPĴӳ:X = (0~7)
#define	map_p0(x)					(0x0 + x)
#define	map_p1(x)					(0x10 + x)
#define	map_p2(x)					(0x20 + x)
#define	map_io()					0x37				//ָΪͨIO
//TXD_MAP = map_p0(0);									//UART1 TX ӳ䵽p00
//TXD_MAP = map_io();									//p00ӳ,ָΪͨIO
//RXD_MAP = map_p0(1);									//UART1 RX ӳ䵽p01
/**************************************************************************************/
void config_gpio_power_on(void);
void config_gpio_ext_int(void);
/**************************************************************************************/
#endif

