/**
*   ************************************************************************************



*   ************************************************************************************
**/

#ifndef __ADC_H__
#define	__ADC_H__
/**************************************************************************************/

/**************************************************************************************/
/* ADC ƼĴ ADCC0 (ĬֵB0000_0011) */
#define	AD_ADCEN				BIT7		//0/1:ر /  ADCתԴ
#define	AD_ADCST				BIT6		//0/1:תӲԶ / ת
#define	AD_ADCIF				BIT5		//0/1: /  ADж()
#define	AD_VREFO				BIT3		//0/1:VREF / P04VREF
#define	AD_VREFS				BIT2		//0/1:ѡڲ /ⲿ(P04) VREF
#define	AD_INREF_VDD			B0000_0000	//ڲοѹVDD
#define	AD_INREF_4V				B0000_0001	//			  4V
#define	AD_INREF_3V				B0000_0010	//			  3V
#define	AD_INREF_2V				B0000_0011	//			  2V

/* ADC ƼĴ ADCC1 (Ĭֵ0)*/
#define	AD_ICHS_DIS				B0000_0000	//ֹADCڲͨ
#define	AD_ICHS_VDD_4			B0100_0000	//1/4VDDΪADCͨ
#define	AD_ICHS_GND				B1100_0000	//GND
#define	AD_XCHS_AIN0			0			//ⲿͨAIN0
#define	AD_XCHS_AIN1			1			//ⲿͨAIN1
#define	AD_XCHS_AIN2			2			//ⲿͨAIN2
#define	AD_XCHS_AIN3			3			//ⲿͨAIN3
#define	AD_XCHS_AIN4			4			//ⲿͨAIN4
#define	AD_XCHS_AIN5			5			//ⲿͨAIN5
#define	AD_XCHS_AIN6			6			//ⲿͨAIN6
#define	AD_XCHS_AIN7			7			//ⲿͨAIN7
#define	AD_XCHS_AIN8			8			//ⲿͨAIN8
#define	AD_XCHS_AIN9			9			//ⲿͨAIN9
#define	AD_XCHS_AIN10			10			//ⲿͨAIN10
#define	AD_XCHS_AIN11			11			//ⲿͨAIN11
#define	AD_XCHS_AIN12			12			//ⲿͨAIN12
#define	AD_XCHS_AIN13			13			//ⲿͨAIN13
#define	AD_XCHS_AIN14			14			//ⲿͨAIN14
#define	AD_XCHS_AIN15			15			//ⲿͨAIN15

/* ADC ƼĴ ADCC2 (Ĭֵ0)*/
#define	AD_12B_H8L4				B0000_0000	//ADCRH 8λ+ADCRL4λ
#define	AD_12B_H4L8				B0100_0000	//ADCRH4λ+ADCRL 8λ
#define	AD_10B_H8L2				B1000_0000	//ADCRH 8λ+ADCRL2λ
#define	AD_10B_H2L8				B1100_0000	//ADCRH2λ+ADCRL 8λ
#define	AD_ADCTS_CLK4M			B0000_0000	//ADCʱ4M,һת22ADC_CLK
#define	AD_ADCTS_CLK21M			B0001_0000	//ADCʱ2M1M,һת19ADC_CLK
#define	AD_ADCTS_CLKLOW			B0010_0000	//ADCʱС1M,һת15ADC_CLK
#define	AD_CLK_FOSC2			B0000_0000	//ADCʱѡFosc/2
#define	AD_CLK_FOSC4			B0000_0001	//ADCʱѡFosc/4
#define	AD_CLK_FOSC6			B0000_0010	//ADCʱѡFosc/6
#define	AD_CLK_FOSC8			B0000_0011	//ADCʱѡFosc/8
#define	AD_CLK_FOSC12			B0000_0100	//ADCʱѡFosc/12
#define	AD_CLK_FOSC16			B0000_0101	//ADCʱѡFosc/16
#define	AD_CLK_FOSC24			B0000_0110	//ADCʱѡFosc/24
#define	AD_CLK_FOSC32			B0000_0111	//ADCʱѡFosc/32

/* ADC ƼĴ ADCC3 (Ĭֵ0)*/
#define	AD_IVREFS_1V			BIT7		//0/1: ڲοѹ ADCC0λ / ڲ1V
#define	AD_FCLK_2M				0			//ʹڲοѹADCɹ2MHZƵ
#define	AD_FCLK_4M				BIT6		//ʹڲοѹADCɹ4MHZƵ
#define	AD_ADCTS_OEN			BIT5		//ADCSTźŴP20 ֹ / ʹ
#define	AD_TRIG_ADCST			B0000_0000	//ADCźѡλ(ת): ADCST
#define	AD_TRIG_PWM0_R			B0000_0001	//                             PWM0
#define	AD_TRIG_PWM0_F			B0000_0010	//                             PWM0½
#define	AD_TRIG_PWM0_M			B0000_0011	//                             PWM0е
#define	AD_TRIG_PWM0_E			B0000_0100	//                             PWM0յ
#define	AD_TRIG_PWM1_R			B0000_0101	//                             PWM1
#define	AD_TRIG_PWM1_F			B0000_0110	//                             PWM1½
#define	AD_TRIG_PWM1_M			B0000_0111	//                             PWM1е
#define	AD_TRIG_PWM1_E			B0000_1000	//                             PWM1յ
#define	AD_TRIG_PWM2_R			B0000_1001	//                             PWM2
#define	AD_TRIG_PWM2_F			B0000_1010	//                             PWM2½
#define	AD_TRIG_PWM2_M			B0000_1011	//                             PWM2е
#define	AD_TRIG_PWM2_E			B0000_1100	//                             PWM2յ
#define	AD_TRIG_PWM0_INT		B0000_1101	//                             PWM0ƥж
#define	AD_TRIG_ADCST_R			B0000_1110	//                             ADC_STܽ
#define	AD_TRIG_ADCST_F			B0000_1111	//                             ADC_STܽ½ 
#define	AD_TRIG_ADCST_RF		B0001_0000	//                             ADC_STܽ˫
#define	AD_TRIG_T5				B0001_0001	//                             ʱ5T5ͨһ벶¼
#define	AD_TRIG_T5_CH0			B0001_0010	//                             ʱ5벶ͨ0һ벶¼
#define	AD_TRIG_T5_CH1			B0001_0011	//                             ʱ5벶ͨ1һ벶¼
#define	AD_TRIG_T5_CMP			B0001_0100	//                             ʱ5һαȽƥ¼

/* ADC ʱʱ ADCDLYH,ADCDLYL(Ĭֵ0) */

/* ADC ģ⿴ŹƼĴ AWDCON (Ĭֵ0) */
#define	AD_CONT					BIT4		//0/1:ADCת ر / 
#define	AD_AWDIF				BIT3		//0/1:ûзģ⿴Ź¼ / ģ⿴Ź¼
#define	AD_AWDIE				BIT2		//0/1:ģ⿴Źж ֹ / ʹ
#define	AD_AWDMOD_L				0			//ADCתģѹڵͷֵڸ߷ֵAWDIFλ
#define	AD_AWDMOD_H				BIT1		//ADCתģѹڵͷֵڸ߷ֵAWDIFλ
#define	AD_AWDEN				BIT0		//0/1:ģ⿴Ź  / ʹ

/* ADC ֵȽϼĴ ADC_HTRH,ADC_HTRL(Ĭֵ0) */

/* ADC ֵȽϼĴ ADC_LTRH,ADC_LTRL(Ĭֵ0) */

/* ADC תĴ ADCCONTV(Ĭֵ0) */

/* ADC תĴ ADCGAPV(Ĭֵ0) */

/* ADC תĴ SCRHx,SCRLx(x=0...7)(Ĭֵ0) */
/* ɴ8תֵ */

/* ADC תĴ ADCRL,ADCRH (Ĭֵ0)*/

/* ADC ѿƼĴ ADCWC (Ĭֵ0)*/
#define	AD_AMWEN				BIT7		//0/1:ֹ /  ADCģ
#define	AD_AMWIF				BIT6		//0/1:ADCģж,0 / ADCģж,Ӳ 1
/**************************************************************************************/
#define	select_adc_reference(x) 	(ADCC0 |= x)			//οѹѡVDD,ڲ2V,3V,4V
#define	select_adc_reference_1V()	(ADCC3 |= AD_IVREFS_1V)	//οѹѡڲ1V
#define	select_adc_channel(x)		(ADCC1 |= x)			//x = 0 ... 15
#define	select_adc_channel_vdd4()	(ADCC1 = AD_ICHS_VDD_4)	//VDD/4Ϊͨ
/**************************************************************************************/
#define	D_TEST_VREF					0						//ڲ2V

/**************************************************************************************/
void config_adc_module(void);
u16 adc_sampling_single(void);
u16 adc_sampling_period(void);
u16 adc_sampling_continuous(u8 u8_times);

u16 test_vref(void);
/*************************************************************************************/
#endif
