/**
*   ************************************************************************************

*   ************************************************************************************
**/
/**************************************************************************************/
#include ".\port\port_mcu.h"

extern u8	u8_delay_int;
/**************************************************************************************/


/**************************************************************************************/
#if D_DEBUG							//ʹUART2дڵ
/**************************************************************************************/
#define	debug_tx_pin_att()			att_p25(IO_OUT_PUSH_PULL)
#define	debug_tx_pin_status(x)		pin_out(P2_5,x)
#define	debug_tx_pin_map()			TXD2_MAP = map_p2(5)

#if D_DEBUG_RX
#define	debug_rx_pin_att()			att_p24(IO_SMTIN_PULL_UP)
#define	debug_rx_pin_map()			RXD2_MAP = map_p2(4)

#define	DEBUG_RX_NUM		2
bit b_debug_rx_end;
u8	u8_debug_rx_index;
u8	u8_debug_rx_data[DEBUG_RX_NUM];
#endif
/**************************************************************************************/
// дpuchar()
char putchar(char c)
{
    S2BUF = c;
	while(!(S2CON & UART2_INT_TI));
	S2CON &= ~UART2_INT_TI;
	
	return c;
}
/**************************************************************************************/
void debug_putchar(u8 u8_data)
{
    S2BUF = u8_data;
	while(!(S2CON & UART2_INT_TI));
	S2CON &= ~UART2_INT_TI;
}
/**************************************************************************************/
void debug_init(void)
{
	debug_tx_pin_att();
	debug_tx_pin_status(1);
	debug_tx_pin_map();

#if D_DEBUG_RX	
	debug_rx_pin_att();
	debug_rx_pin_map();
#endif

	RCAP5H = D_BAND_RATE >> 8;
	RCAP5L = D_BAND_RATE;
	//T5ģʽ:ΪUART2ʷ,ʱFoscƵ,ʹT5
	T5CON = TIM_T5PS_1 | TIM_T5M_1 | TIM_TR5_EN;
	BRTSEL |= UART_UART2SEL_T5;
    
	//UART2ʽ0
	S2CON2 = UART2_SM1_8BIT;
#if D_DEBUG_RX
	S2CON |= UART2_REN_EN;
	IE |= INT_ES2_EN;			//ʹܴж
#endif
}
/**************************************************************************************/
void user_printf(char *p_data)
{	//ַ
    while(*p_data != '\0')
    {
        debug_putchar(*p_data++);
    }
}
/***************************************************************************************
* @ 	UART2жϷ 
* @˵    
* @    
* @ֵ 
* @ע 
***************************************************************************************/
#if D_DEBUG_RX
void debug_rpt(void) interrupt UART2_VECTOR
{
	u8 buf;
	
	if(S2CON & UART2_INT_RI)
	{	//Эʽ
		S2CON &= ~UART2_INT_RI;
		buf = S2BUF;
		
		if(0 == b_debug_rx_end)		//ݴϲܿ
		{
			if(u8_debug_rx_index >= DEBUG_RX_NUM)
			{	//ݴ洢ָ쳣
				u8_debug_rx_index = 0;
			}
			else if((0 == u8_debug_rx_index) && (0x55 == buf))
			{	//ݿʼ
				u8_debug_rx_data[0] = 0x55;
			}
			else
			{
				u8_debug_rx_index++;
				u8_debug_rx_data[u8_debug_rx_index] = buf;
				if(u8_debug_rx_index >= (DEBUG_RX_NUM - 1))
				{//ݽ
					b_debug_rx_end = 1;
					u8_debug_rx_index = 0;	
				}
			}
		}	
	}
}
#endif
/*************************************************************************************/
#endif
/*************************************************************************************/



/***************************************************************************************
* @		ָʱʱ
* @˵		ʱ
* @		ms : ʱʱ
* @ֵ	
* @ע		Fcpu = 4MHz      		Fcpu = 8MHz      		Fcpu = 16MHz
*			us = 390 -> Լ1ms  		us = 790 -> Լ1ms  		us = 1580 -> Լ1ms
***************************************************************************************/
void delay_ms(u16 ms)
{
	u16 i;
	
	for(;ms > 0;ms--)
    {
        for(i = 790;i > 0;i--);
		{
		//	feed_watchdog();
		}
    }
}
/***************************************************************************************
* @		ָʱʱ
* @˵		ʱ
* @		us : ʱʱ
* @ֵ	
* @ע		Fcpu = 4MHz      		Fcpu = 8MHz      		Fcpu = 16MHz
*			us = 1  -> Լ8us  		us = 1  -> Լ4us  		us = 1  -> Լ2us
*           us = 2  -> Լ11.6us		us = 2  -> Լ5.8us		us = 2  -> Լ2.9us
*			us = 5  -> Լ22us		us = 5  -> Լ11us		us = 5  -> Լ5.5us
*			us = 10 -> Լ40us 		us = 10 -> Լ20us 		us = 10 -> Լ10us
*			us = 1  -> Լ3.5us()us = 1  -> Լ1.8us() us = 1  -> Լ0.9us()
***************************************************************************************/
void delay_us(u8 us)
{
	for(; us>0; us--)
	{
		_nop_();
		_nop_();
		_nop_();
	}        
}
/**************************************************************************************
* @		TIM0жʱ(TIM0ʱ1MS)
* @˵		ʱ
* @		ms : ʱʱ
* @ֵ	
* @ע 	   	u8_delay_int 
***************************************************************************************/
void delay_ms_int(u8 ms)
{
	//16λֵжֻж,޸ֵ,жӰ
	u8_delay_int = 0;
	while(u8_delay_int < ms)
	{
		feed_watchdog();
	}
}
/**************************************************************************************/



/***************************************************************************************
* @  ϵͳ绽
* @˵    
* @    
* @ֵ
* @ע 	   
***************************************************************************************/
/* עǰע
   1,IOܸ,޸,رģ,رBOR,ADCοѹѡVDD
   2,ǰûԴ,IOжϻѻûѵƽ
   3,ѺҪжϱ־
***************************************************************************************/
void system_power_down(void)
{
	//P26 & P27 Ϊ͵ƽж
	att_p26(IO_SMTIN_PULL_UP);					//P26
	att_p27(IO_SMTIN_PULL_UP);					//P27
	PINTE1 |= (INT_EINT14 + INT_EINT15);		//P26&P27˿ж
	PITS3 |= (INT_IT14_L + INT_IT15_L);			//͵ƽж
	IP3 = INT_PX815_3;							//ȼ
	IE1 |= INT_EX8_15_EN;						//ʹⲿжINT8_15
	
	ADCC0 = 0x03;								//رADģ
	ADCC1 = 0;
	
	disable_watchdog();
	//ָǰCPUʱƵ
	FREQ_CLK = FREQ_CLK_16MHZ;
	//ֹѹλ(ʡ)
	BORC &= ~ POWER_BOREN;
	//ʡ
	PCON |= 0x02;
	
	EA = 0;
	//IOж
	PINTF1 = 0;
	PINTE1 = 0;
	IE1 &= ~INT_EX8_15_EN;
	
	config_sysclk_ihrc_module();
	config_adc_module();					//ʹADģ
	//ʹܵѹλ
	BORC |= POWER_BOREN;
	feed_watchdog();
	enable_watchdog();
	EA = 1;
}
/**************************************************************************************/



/***************************************************************************************
* @		ӲĴʼ
* @˵		
* @    
* @ֵ 
* @ע 
***************************************************************************************/
void hardware_init(void)
{
	reset_check();
	config_sysclk_ihrc_module();
#if D_TEST_CLK
	config_sysclk_output();
#endif
	config_tick_module();
	config_adc_module();
	config_pwm0_module(D_PWM_CH0_CH1);
	enable_watchdog();
	
//	 BOR = 1.8V, BOR ȥ
//	BORC = 0xC0;		
//	BORDBC = 0xFF;
}
/**************************************************************************************/
