/**
*   ************************************************************************************

*   ************************************************************************************
**/

/**************************************************************************************/
#include ".\port\port_mcu.h"

u16 u16_pwm0_ch0_duty;
u16 u16_pwm0_ch1_duty;

u16 u16_pwm1_ch0_duty;
u16 u16_pwm1_ch1_duty;

u16 u16_pwm2_ch0_duty;
u16 u16_pwm2_ch1_duty;

u8	u8_pwm3_duty;				
/**************************************************************************************/
/*ӦҪPWM0,PWM1,PWM2ͬʱ,PWMCTRLPWMENAĴ.*/
/*PENCTRLBIT0λΪ1,ʹPWMENABIT6,5,4,2,1,0λ.*/

/*رע*/
/*PWMĬ12λ(PWMCTRLBIT1),PWMֵ4095,Χ趨ֵ趨Ч*/
/***************************************************************************************
* @		Ӳ PWM0 ʼ
* @˵		
* @		PWM0 ͨѡ
* @ֵ 
* @ע 	   
***************************************************************************************/
void config_pwm0_module(u8 u8_ch)
{	
	switch(u8_ch)
	{
		case D_PWM_CH0:
			pwm0_ch0_pin_att();
			pwm0_ch0_pin_status(0);
		break;
		case D_PWM_CH1:
			pwm0_ch1_pin_att();
			pwm0_ch1_pin_status(0);
		break;
		case D_PWM_CH0_CH1:
			pwm0_ch0_pin_att();
			pwm0_ch0_pin_status(0);
			pwm0_ch1_pin_att();
			pwm0_ch1_pin_status(0);
		break;
	}	
	
	//PWMCTRL:ϵʼֵ0x1C[Ĭϱض,ʹԶ,12λ,PWM0EN,PWM1EN,PWM2EN]
	PWMCON0 |= PWM_PWMLEN_16B;								//16λ
	
	//PWM0 Ƶ = (Fosc/PWMƵ)/[PWM0PH:PWM0PL]
	PWM0PH = (PMW0_PERIOD >> 8);
	PWM0PL = PMW0_PERIOD;
	
	//PWM0ΪЧʱFosc
	PWM0C = PWM_OUT_0H1H | PWM_CLK_FOSC;					//PWM0ʱFosc,Ч,ֹPWM0ж
//	PWM0C = PWM_INT_EN | PWM_OUT_0H1H | PWM_CLK_FOSC;		//PWM0ʱFosc,Ч,ʹPWM0ж	
	PWM0EN = PWM_EN;										//PWM0ʹ

/*
	//PWM0 ռձ = (PWM0PH:PWM0PL) * 50%
	PWM0DH = (PWM0_DUTY >> 8);
	PWM0DL = PWM0_DUTY;
	//ڵPWM01PWM0Ҹʱ(ʵʾռձʱ)
	//ʱԶԶСռձʱ,Ӱռձ
	//ģʽʱ,ʱ䱻ΪPWM01ռձȼĴ
	PWM0DTH = (PWM0_DEAD >> 8);
	PWM0DTL = PWM0_DEAD;
*/
}
/***************************************************************************************
* @		PWM0 ģʽ,ռձȵ
* @˵    
* @		ռձ    
* @ֵ 
* @ע 	   
***************************************************************************************/
void turn_on_pwm0_cpm(u16 u16_duty)
{
	u16_pwm0_ch0_duty = u16_duty;
	//duty 
	PWM0DH = u16_duty >> 8;
	PWM0DL = u16_duty;
	//dead time = duty * 5%
	PWM0DTH = (u16_duty * 5 / 100) >> 8;
	PWM0DTL = (u16_duty * 5 / 100);

	pwm0_ch0_pin_map();
	pwm0_ch1_pin_map();
	PWM0C &= ~PWM_INT_F;
	PWM0EN |= PWM_CPM + PWM_CH1_EN + PWM_CH0_EN;
}
/**************************************************************************************/
void change_duty_pwm0_cpm(u16 u16_duty)
{
	//duty 
	PWM0DH = u16_duty >> 8;
	PWM0DL = u16_duty;
	//dead time = duty * 5%
	PWM0DTH = (u16_duty * 5 / 100) >> 8;
	PWM0DTL = (u16_duty * 5 / 100); 
}
/***************************************************************************************
* @		PWM0 ģʽ,ռձȵ
* @˵    
* @		    
* @ֵ 
* @ע 	   
***************************************************************************************/
void turn_on_pwm0_idp(u8 u8_ch, u16 u16_duty0, u16 u16_duty1)
{
	PWM0C &= ~PWM_INT_F;
	switch(u8_ch)
	{
		case D_PWM_CH0:
			u16_pwm0_ch0_duty = u16_duty0;
			PWM0DH = u16_duty0 >> 8;
			PWM0DL = u16_duty0;
			
			pwm0_ch0_pin_map();
			PWM0EN |= PWM_IDP + PWM_CH0_EN;
		break;
		case D_PWM_CH1:
			u16_pwm0_ch1_duty = u16_duty1;
			PWM0DTH = u16_duty1 >> 8;
			PWM0DTL = u16_duty1;
			
			pwm0_ch1_pin_map();
			PWM0EN |= PWM_IDP + PWM_CH1_EN;
		break;
		case D_PWM_CH0_CH1:
			u16_pwm0_ch0_duty = u16_duty0;
			PWM0DH = u16_duty0 >> 8;
			PWM0DL = u16_duty0;
			u16_pwm0_ch1_duty = u16_duty1;
			PWM0DTH = u16_duty1 >> 8;
			PWM0DTL = u16_duty1;
			
			pwm0_ch0_pin_map();
			pwm0_ch1_pin_map();	
			PWM0EN |= PWM_IDP + PWM_CH1_EN + PWM_CH0_EN;
		break;
	}
}
/**************************************************************************************/
void change_duty_pwm0_idp(u8_ch, u16 u16_duty0, u16 u16_duty1)
{
	switch(u8_ch)
	{
		case D_PWM_CH0:
			u16_pwm0_ch0_duty = u16_duty0;
			PWM0DH = u16_duty0 >> 8;
			PWM0DL = u16_duty0;
		break;
		case D_PWM_CH1:
			u16_pwm0_ch1_duty = u16_duty1;
			PWM0DTH = u16_duty1 >> 8;
			PWM0DTL = u16_duty1;
		break;
		case D_PWM_CH0_CH1:
			u16_pwm0_ch0_duty = u16_duty0;
			PWM0DH = u16_duty0 >> 8;
			PWM0DL = u16_duty0;
			u16_pwm0_ch1_duty = u16_duty1;
			PWM0DTH = u16_duty1 >> 8;
			PWM0DTL = u16_duty1;
		break;
	}
}
/***************************************************************************************
* @		PWM0 ر
* @˵    
* @    
* @ֵ 
* @ע 	   
***************************************************************************************/
void turn_off_pwm0(u8 u8_ch)
{
	switch(u8_ch)
	{
		case D_PWM_CH0:
			PWM0EN &= ~PWM_CH0_EN;
			pwm0_ch0_pin_io();
			pwm0_ch0_pin_status(0);
		break;
		case D_PWM_CH1:
			PWM0EN &= ~PWM_CH1_EN;
			pwm0_ch1_pin_io();
			pwm0_ch1_pin_status(0);
		break;
		case D_PWM_CH0_CH1:
			PWM0EN &= ~(PWM_CH1_EN + PWM_CH0_EN);
			pwm0_ch0_pin_io();
			pwm0_ch0_pin_status(0);
			pwm0_ch1_pin_io();
			pwm0_ch1_pin_status(0);
		break;
	}
}
/**************************************************************************************/




/***************************************************************************************
* @		Ӳ PWM1 ʼ
* @˵		
* @		PWM1 ͨѡ
* @ֵ 
* @ע 	   
***************************************************************************************/
void config_pwm1_module(u8 u8_ch)
{	
	switch(u8_ch)
	{
		case D_PWM_CH0:
			pwm1_ch0_pin_att();
			pwm1_ch0_pin_status(0);
		break;
		case D_PWM_CH1:
			pwm1_ch1_pin_att();
			pwm1_ch1_pin_status(0);
		break;
		case D_PWM_CH0_CH1:
			pwm1_ch0_pin_att();
			pwm1_ch0_pin_status(0);
			pwm1_ch1_pin_att();
			pwm1_ch1_pin_status(0);
		break;
	}	
	
	//PWMCTRL:ϵʼֵ0x1C[Ĭϱض,ʹԶ,12λ,PWM0EN,PWM1EN,PWM2EN]
	PWMCON0 |= PWM_PWMLEN_16B;								//16λ
	
	//PWM1 Ƶ = (Fosc/PWMƵ)/[PWM1PH:PWM1PL]
	PWM1PH = (PMW1_PERIOD >> 8);
	PWM1PL = PMW1_PERIOD;
	
	//PWM1ΪЧʱFosc
	PWM1C = PWM_OUT_0H1H | PWM_CLK_FOSC;					//PWM1ʱFosc,Ч,ֹPWM1ж
//	PWM1C = PWM_INT_EN | PWM_OUT_0H1H | PWM_CLK_FOSC;		//PWM1ʱFosc,Ч,ʹPWM1ж	
	PWM1EN = PWM_EN;
}
/***************************************************************************************
* @		PWM1 ģʽ,ռձȵ
* @˵    
* @		ռձ    
* @ֵ 
* @ע 	   
***************************************************************************************/
void turn_on_pwm1_cpm(u16 u16_duty)
{
	u16_pwm1_ch0_duty = u16_duty;
	//duty 
	PWM1DH = u16_duty >> 8;
	PWM1DL = u16_duty;
	//dead time = duty * 5%
	PWM1DTH = (u16_duty * 5 / 100) >> 8;
	PWM1DTL = (u16_duty * 5 / 100);

	pwm1_ch0_pin_map();
	pwm1_ch1_pin_map();
	PWM1C &= ~PWM_INT_F;
	PWM1EN |= PWM_CPM + PWM_CH1_EN + PWM_CH0_EN;
}
/**************************************************************************************/
void change_duty_pwm1_cpm(u16 u16_duty)
{
	//duty 
	PWM1DH = u16_duty >> 8;
	PWM1DL = u16_duty;
	//dead time = duty * 5%
	PWM1DTH = (u16_duty * 5 / 100) >> 8;
	PWM1DTL = (u16_duty * 5 / 100); 
}
/***************************************************************************************
* @		PWM1 ģʽ,ռձȵ
* @˵    
* @		    
* @ֵ 
* @ע 	   
***************************************************************************************/
void turn_on_pwm1_idp(u8 u8_ch, u16 u16_duty0, u16 u16_duty1)
{
	PWM1C &= ~PWM_INT_F;
	switch(u8_ch)
	{
		case D_PWM_CH0:
			u16_pwm1_ch0_duty = u16_duty0;
			PWM1DH = u16_duty0 >> 8;
			PWM1DL = u16_duty0;
			
			pwm1_ch0_pin_map();
			PWM1EN |= PWM_IDP + PWM_CH0_EN;
		break;
		case D_PWM_CH1:
			u16_pwm1_ch1_duty = u16_duty1;
			PWM1DTH = u16_duty1 >> 8;
			PWM1DTL = u16_duty1;
			
			pwm1_ch1_pin_map();
			PWM1EN |= PWM_IDP + PWM_CH1_EN;
		break;
		case D_PWM_CH0_CH1:
			u16_pwm1_ch0_duty = u16_duty0;
			PWM1DH = u16_duty0 >> 8;
			PWM1DL = u16_duty0;
			u16_pwm1_ch1_duty = u16_duty1;
			PWM1DTH = u16_duty1 >> 8;
			PWM1DTL = u16_duty1;
			
			pwm1_ch0_pin_map();
			pwm1_ch1_pin_map();	
			PWM1EN |= PWM_IDP + PWM_CH1_EN + PWM_CH0_EN;
		break;
	}
}
/**************************************************************************************/
void change_duty_pwm1_idp(u8_ch, u16 u16_duty0, u16 u16_duty1)
{
	switch(u8_ch)
	{
		case D_PWM_CH0:
			u16_pwm1_ch0_duty = u16_duty0;
			PWM1DH = u16_duty0 >> 8;
			PWM1DL = u16_duty0;
		break;
		case D_PWM_CH1:
			u16_pwm1_ch1_duty = u16_duty1;
			PWM1DTH = u16_duty1 >> 8;
			PWM1DTL = u16_duty1;
		break;
		case D_PWM_CH0_CH1:
			u16_pwm1_ch0_duty = u16_duty0;
			PWM1DH = u16_duty0 >> 8;
			PWM1DL = u16_duty0;
			u16_pwm1_ch1_duty = u16_duty1;
			PWM1DTH = u16_duty1 >> 8;
			PWM1DTL = u16_duty1;
		break;
	}
}
/***************************************************************************************
* @		PWM1 ر
* @˵    
* @    
* @ֵ 
* @ע 	   
***************************************************************************************/
void turn_off_pwm1(u8 u8_ch)
{
	switch(u8_ch)
	{
		case D_PWM_CH0:
			PWM1EN &= ~PWM_CH0_EN;
			pwm1_ch0_pin_io();
			pwm1_ch0_pin_status(0);
		break;
		case D_PWM_CH1:
			PWM1EN &= ~PWM_CH1_EN;
			pwm1_ch1_pin_io();
			pwm1_ch1_pin_status(0);
		break;
		case D_PWM_CH0_CH1:
			PWM1EN &= ~(PWM_CH1_EN + PWM_CH0_EN);
			pwm1_ch0_pin_io();
			pwm1_ch0_pin_status(0);
			pwm1_ch1_pin_io();
			pwm1_ch1_pin_status(0);
		break;
	}
}
/**************************************************************************************/




/***************************************************************************************
* @		Ӳ PWM2 ʼ
* @˵		
* @		PWM2 ͨѡ
* @ֵ 
* @ע 	   
***************************************************************************************/
void config_pwm2_module(u8 u8_ch)
{	
	switch(u8_ch)
	{
		case D_PWM_CH0:
			pwm2_ch0_pin_att();
			pwm2_ch0_pin_status(0);
		break;
		case D_PWM_CH1:
			pwm2_ch1_pin_att();
			pwm2_ch1_pin_status(0);
		break;
		case D_PWM_CH0_CH1:
			pwm2_ch0_pin_att();
			pwm2_ch0_pin_status(0);
			pwm2_ch1_pin_att();
			pwm2_ch1_pin_status(0);
		break;
	}	
	
	//PWMCTRL:ϵʼֵ0x1C[Ĭϱض,ʹԶ,12λ,PWM0EN,PWM1EN,PWM2EN]
	PWMCON0 |= PWM_PWMLEN_16B;								//16λ
	
	//PWM2 Ƶ = (Fosc/PWMƵ)/[PWM1PH:PWM1PL]
	PWM2PH = (PMW2_PERIOD >> 8);
	PWM2PL = PMW2_PERIOD;
	
	//PWM2ΪЧʱFosc
	PWM2C = PWM_OUT_0H1H | PWM_CLK_FOSC;					//PWM2ʱFosc,Ч,ֹPWM1ж
//	PWM2C = PWM_INT_EN | PWM_OUT_0H1H | PWM_CLK_FOSC;		//PWM2ʱFosc,Ч,ʹPWM1ж	
	PWM2EN = PWM_EN;
}
/***************************************************************************************
* @		PWM2 ģʽ,ռձȵ
* @˵    
* @		ռձ    
* @ֵ 
* @ע 	   
***************************************************************************************/
void turn_on_pwm2_cpm(u16 u16_duty)
{
	u16_pwm2_ch0_duty = u16_duty;
	//duty 
	PWM2DH = u16_duty >> 8;
	PWM2DL = u16_duty;
	//dead time = duty * 3%
	PWM2DTH = (u16_duty * 3 / 100) >> 8;
	PWM2DTL = (u16_duty * 3 / 100);

	pwm2_ch0_pin_map();
	pwm2_ch1_pin_map();
	PWM2C &= ~PWM_INT_F;
	PWM2EN |= PWM_CPM + PWM_CH1_EN + PWM_CH0_EN;
}
/**************************************************************************************/
void change_duty_pwm2_cpm(u16 u16_duty)
{
	//duty 
	PWM2DH = u16_duty >> 8;
	PWM2DL = u16_duty;
	//dead time = duty * 5%
	PWM2DTH = (u16_duty * 5 / 100) >> 8;
	PWM2DTL = (u16_duty * 5 / 100); 
}
/***************************************************************************************
* @		PWM1 ģʽ,ռձȵ
* @˵    
* @		    
* @ֵ 
* @ע 	   
***************************************************************************************/
void turn_on_pwm2_idp(u8 u8_ch, u16 u16_duty0, u16 u16_duty1)
{
	PWM2C &= ~PWM_INT_F;
	switch(u8_ch)
	{
		case D_PWM_CH0:
			u16_pwm2_ch0_duty = u16_duty0;
			PWM2DH = u16_duty0 >> 8;
			PWM2DL = u16_duty0;
			
			pwm2_ch0_pin_map();
			PWM2EN |= PWM_IDP + PWM_CH0_EN;
		break;
		case D_PWM_CH1:
			u16_pwm2_ch1_duty = u16_duty1;
			PWM2DTH = u16_duty1 >> 8;
			PWM2DTL = u16_duty1;
			
			pwm2_ch1_pin_map();
			PWM2EN |= PWM_IDP + PWM_CH1_EN;
		break;
		case D_PWM_CH0_CH1:
			u16_pwm2_ch0_duty = u16_duty0;
			PWM2DH = u16_duty0 >> 8;
			PWM2DL = u16_duty0;
			u16_pwm2_ch1_duty = u16_duty1;
			PWM2DTH = u16_duty1 >> 8;
			PWM2DTL = u16_duty1;
			
			pwm2_ch0_pin_map();
			pwm2_ch1_pin_map();	
			PWM2EN |= PWM_IDP + PWM_CH1_EN + PWM_CH0_EN;
		break;
	}
}
/**************************************************************************************/
void change_duty_pwm2_idp(u8_ch, u16 u16_duty0, u16 u16_duty1)
{
	switch(u8_ch)
	{
		case D_PWM_CH0:
			u16_pwm2_ch0_duty = u16_duty0;
			PWM2DH = u16_duty0 >> 8;
			PWM2DL = u16_duty0;
		break;
		case D_PWM_CH1:
			u16_pwm2_ch1_duty = u16_duty1;
			PWM2DTH = u16_duty1 >> 8;
			PWM2DTL = u16_duty1;
		break;
		case D_PWM_CH0_CH1:
			u16_pwm2_ch0_duty = u16_duty0;
			PWM2DH = u16_duty0 >> 8;
			PWM2DL = u16_duty0;
			u16_pwm2_ch1_duty = u16_duty1;
			PWM2DTH = u16_duty1 >> 8;
			PWM2DTL = u16_duty1;
		break;
	}
}
/***************************************************************************************
* @		PWM2 ر
* @˵    
* @    
* @ֵ 
* @ע 	   
***************************************************************************************/
void turn_off_pwm2(u8 u8_ch)
{
	switch(u8_ch)
	{
		case D_PWM_CH0:
			PWM2EN &= ~PWM_CH0_EN;
			pwm2_ch0_pin_io();
			pwm2_ch0_pin_status(0);
		break;
		case D_PWM_CH1:
			PWM2EN &= ~PWM_CH1_EN;
			pwm2_ch1_pin_io();
			pwm2_ch1_pin_status(0);
		break;
		case D_PWM_CH0_CH1:
			PWM2EN &= ~(PWM_CH1_EN + PWM_CH0_EN);
			pwm2_ch0_pin_io();
			pwm2_ch0_pin_status(0);
			pwm2_ch1_pin_io();
			pwm2_ch1_pin_status(0);
		break;
	}
}
/**************************************************************************************/




/***************************************************************************************
* @		Ӳ PWM3 ʼ
* @˵		
* @
* @ֵ 
* @ע 	   
***************************************************************************************/
void config_pwm3_module(void)
{	
	pwm3_ch_pin_att();
	pwm3_ch_pin_status(0);
	pwm3_ch_pin_map();
	
	//
	PWM3P = PWM3_PERIOD;	
	//PWM3ΪЧʱFosc
	PWM3C = PWM3_EN | PWM3_CLK_FOSC_128;
}
/***************************************************************************************
* @		PWM3 
* @˵    
* @		ռձ    
* @ֵ 
* @ע 	   
***************************************************************************************/
void turn_on_pwm3(u8 u8_duty)
{
	u8_pwm3_duty = u8_duty;
	PWM3D = u8_duty;
	PWM3C |= PWM3_OEN;
}
/***************************************************************************************
* @		PWM3 ر
* @˵    
* @		ռձ    
* @ֵ 
* @ע 	   
***************************************************************************************/
void turn_off_pwm3(void)
{
	PWM3C &= ~PWM3_OEN;
	pwm3_ch_pin_io();
	pwm3_ch_pin_status(0);
}
/**************************************************************************************/



/**************************************************************************************
* @  	PWMжϷ
* @˵    
* @    
* @ֵ 
* @ע 	   
***************************************************************************************/
void pwm_rpt(void) interrupt PWM_VECTOR
{
	if(PWM0C & PWM_INT_F)
	{
		//PWM0ж
		PWM0C &= ~PWM_INT_F;
		
	}
	
	if(PWM1C & PWM_INT_F)
	{
		//PWM1ж
		PWM1C &= ~PWM_INT_F;
		
	}
	
	if(PWM2C & PWM_INT_F)
	{
		//PWM2ж
		PWM2C &= ~PWM_INT_F;
		
	}
	
	if(PWM3C & PWM3_INT_F)
	{
		//PWM2ж
		PWM3C &= ~PWM3_INT_F;
		
	}
}
/*************************************************************************************/
