**************************************************************/
#ifndef __BL08F182_H
#define __BL08F182_H


//$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$
// BANK0 Special function register definitions
//$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$

// Register: INDF :BANK0
volatile unsigned char           INDF                @ 0x000;
// bit and bitfield definitions


// Register: TMR0
volatile unsigned char           TMR0                @ 0x001;
// bit and bitfield definitions


// Register: PCL
volatile unsigned char           PCL                 @ 0x002;
// bit and bitfield definitions


// Register: STATUS
volatile unsigned char           STATUS              @ 0x003;
// bit and bitfield definitions
volatile bit CARRY               @ ((unsigned)&STATUS*8)+0;
volatile bit C	                 @ ((unsigned)&STATUS*8)+0;
volatile bit DC                  @ ((unsigned)&STATUS*8)+1;
volatile bit Z                   @ ((unsigned)&STATUS*8)+2;
volatile bit ZERO                @ ((unsigned)&STATUS*8)+2;
volatile bit NPD                 @ ((unsigned)&STATUS*8)+3;
volatile bit nPD                 @ ((unsigned)&STATUS*8)+3;
volatile bit NTO                 @ ((unsigned)&STATUS*8)+4;
volatile bit nTO                 @ ((unsigned)&STATUS*8)+4;
volatile bit RP0                 @ ((unsigned)&STATUS*8)+5;
volatile bit RP1                 @ ((unsigned)&STATUS*8)+6;
volatile bit RST                 @ ((unsigned)&STATUS*8)+7;
volatile bit IRP                 @ ((unsigned)&STATUS*8)+7;

// Register: FSR
volatile unsigned char           FSR                 @ 0x004;
volatile bit FSR_7                 @ ((unsigned)&FSR*8)+7;
// bit and bitfield definitions

// Register: PORTA
volatile unsigned char           PORTA            @ 0x005;
volatile unsigned char           RA               @ 0x005;
volatile unsigned char           PA               @ 0x005;
// bit and bitfield definitions
volatile bit FIOA0                @ ((unsigned)&PORTA*8)+0;
volatile bit FIOA1                @ ((unsigned)&PORTA*8)+1;
volatile bit FIOA2                @ ((unsigned)&PORTA*8)+2;
volatile bit FIOA3                @ ((unsigned)&PORTA*8)+3;
volatile bit FIOA4                @ ((unsigned)&PORTA*8)+4;
volatile bit FIOA5                @ ((unsigned)&PORTA*8)+5;
volatile bit FIOA6                @ ((unsigned)&PORTA*8)+6;
volatile bit FIOA7                @ ((unsigned)&PORTA*8)+7;

volatile bit IOA0                @ ((unsigned)&PORTA*8)+0;
volatile bit IOA1                @ ((unsigned)&PORTA*8)+1;
volatile bit IOA2                @ ((unsigned)&PORTA*8)+2;
volatile bit IOA3                @ ((unsigned)&PORTA*8)+3;
volatile bit IOA4                @ ((unsigned)&PORTA*8)+4;
volatile bit IOA5                @ ((unsigned)&PORTA*8)+5;
volatile bit IOA6                @ ((unsigned)&PORTA*8)+6;
volatile bit IOA7                @ ((unsigned)&PORTA*8)+7;

volatile bit FRA0                 @ ((unsigned)&PORTA*8)+0;
volatile bit FRA1                 @ ((unsigned)&PORTA*8)+1;
volatile bit FRA2                 @ ((unsigned)&PORTA*8)+2;
volatile bit FRA3                 @ ((unsigned)&PORTA*8)+3;
volatile bit FRA4                 @ ((unsigned)&PORTA*8)+4;
volatile bit FRA5                 @ ((unsigned)&PORTA*8)+5;
volatile bit FRA6                 @ ((unsigned)&PORTA*8)+6;
volatile bit FRA7                 @ ((unsigned)&PORTA*8)+7;

volatile bit RA0                 @ ((unsigned)&PORTA*8)+0;
volatile bit RA1                 @ ((unsigned)&PORTA*8)+1;
volatile bit RA2                 @ ((unsigned)&PORTA*8)+2;
volatile bit RA3                 @ ((unsigned)&PORTA*8)+3;
volatile bit RA4                 @ ((unsigned)&PORTA*8)+4;
volatile bit RA5                 @ ((unsigned)&PORTA*8)+5;
volatile bit RA6                 @ ((unsigned)&PORTA*8)+6;
volatile bit RA7                 @ ((unsigned)&PORTA*8)+7;

volatile bit FPA0                 @ ((unsigned)&PORTA*8)+0;
volatile bit FPA1                 @ ((unsigned)&PORTA*8)+1;
volatile bit FPA2                 @ ((unsigned)&PORTA*8)+2;
volatile bit FPA3                 @ ((unsigned)&PORTA*8)+3;
volatile bit FPA4                 @ ((unsigned)&PORTA*8)+4;
volatile bit FPA5                 @ ((unsigned)&PORTA*8)+5;
volatile bit FPA6                 @ ((unsigned)&PORTA*8)+6;
volatile bit FPA7                 @ ((unsigned)&PORTA*8)+7;

volatile bit PA0                 @ ((unsigned)&PORTA*8)+0;
volatile bit PA1                 @ ((unsigned)&PORTA*8)+1;
volatile bit PA2                 @ ((unsigned)&PORTA*8)+2;
volatile bit PA3                 @ ((unsigned)&PORTA*8)+3;
volatile bit PA4                 @ ((unsigned)&PORTA*8)+4;
volatile bit PA5                 @ ((unsigned)&PORTA*8)+5;
volatile bit PA6                 @ ((unsigned)&PORTA*8)+6;
volatile bit PA7                 @ ((unsigned)&PORTA*8)+7;


// Register: PORTB
volatile unsigned char           PORTB            @ 0x006;
volatile unsigned char           RB               @ 0x006;
volatile unsigned char           PB               @ 0x006;
// bit and bitfield definitions
volatile bit FIOB0                @ ((unsigned)&PORTB*8)+0;
volatile bit FIOB1                @ ((unsigned)&PORTB*8)+1;
volatile bit FIOB2                @ ((unsigned)&PORTB*8)+2;
volatile bit FIOB3                @ ((unsigned)&PORTB*8)+3;
volatile bit FIOB4                @ ((unsigned)&PORTB*8)+4;
volatile bit FIOB5                @ ((unsigned)&PORTB*8)+5;
volatile bit FIOB6                @ ((unsigned)&PORTB*8)+6;
volatile bit FIOB7                @ ((unsigned)&PORTB*8)+7;

volatile bit IOB0                @ ((unsigned)&PORTB*8)+0;
volatile bit IOB1                @ ((unsigned)&PORTB*8)+1;
volatile bit IOB2                @ ((unsigned)&PORTB*8)+2;
volatile bit IOB3                @ ((unsigned)&PORTB*8)+3;
volatile bit IOB4                @ ((unsigned)&PORTB*8)+4;
volatile bit IOB5                @ ((unsigned)&PORTB*8)+5;
volatile bit IOB6                @ ((unsigned)&PORTB*8)+6;
volatile bit IOB7                @ ((unsigned)&PORTB*8)+7;

volatile bit FRB0                 @ ((unsigned)&PORTB*8)+0;
volatile bit FRB1                 @ ((unsigned)&PORTB*8)+1;
volatile bit FRB2                 @ ((unsigned)&PORTB*8)+2;
volatile bit FRB3                 @ ((unsigned)&PORTB*8)+3;
volatile bit FRB4                 @ ((unsigned)&PORTB*8)+4;
volatile bit FRB5                 @ ((unsigned)&PORTB*8)+5;
volatile bit FRB6                 @ ((unsigned)&PORTB*8)+6;
volatile bit FRB7                 @ ((unsigned)&PORTB*8)+7;

volatile bit RB0                 @ ((unsigned)&PORTB*8)+0;
volatile bit RB1                 @ ((unsigned)&PORTB*8)+1;
volatile bit RB2                 @ ((unsigned)&PORTB*8)+2;
volatile bit RB3                 @ ((unsigned)&PORTB*8)+3;
volatile bit RB4                 @ ((unsigned)&PORTB*8)+4;
volatile bit RB5                 @ ((unsigned)&PORTB*8)+5;
volatile bit RB6                 @ ((unsigned)&PORTB*8)+6;
volatile bit RB7                 @ ((unsigned)&PORTB*8)+7;

volatile bit FPB0                 @ ((unsigned)&PORTB*8)+0;
volatile bit FPB1                 @ ((unsigned)&PORTB*8)+1;
volatile bit FPB2                 @ ((unsigned)&PORTB*8)+2;
volatile bit FPB3                 @ ((unsigned)&PORTB*8)+3;
volatile bit FPB4                 @ ((unsigned)&PORTB*8)+4;
volatile bit FPB5                 @ ((unsigned)&PORTB*8)+5;
volatile bit FPB6                 @ ((unsigned)&PORTB*8)+6;
volatile bit FPB7                 @ ((unsigned)&PORTB*8)+7;

volatile bit PB0                 @ ((unsigned)&PORTB*8)+0;
volatile bit PB1                 @ ((unsigned)&PORTB*8)+1;
volatile bit PB2                 @ ((unsigned)&PORTB*8)+2;
volatile bit PB3                 @ ((unsigned)&PORTB*8)+3;
volatile bit PB4                 @ ((unsigned)&PORTB*8)+4;
volatile bit PB5                 @ ((unsigned)&PORTB*8)+5;
volatile bit PB6                 @ ((unsigned)&PORTB*8)+6;
volatile bit PB7                 @ ((unsigned)&PORTB*8)+7;

// Register: PORTB
volatile unsigned char           PORTC            @ 0x007;
volatile unsigned char           RC            @ 0x007;
volatile unsigned char           PC            @ 0x007;
// bit and bitfield definitions
volatile bit FIOC0                @ ((unsigned)&PORTC*8)+0;
volatile bit FIOC1                @ ((unsigned)&PORTC*8)+1;
volatile bit FIOC2                @ ((unsigned)&PORTC*8)+2;
volatile bit FIOC3                @ ((unsigned)&PORTC*8)+3;
volatile bit FIOC4                @ ((unsigned)&PORTC*8)+4;
volatile bit FIOC5                @ ((unsigned)&PORTC*8)+5;
volatile bit FIOC6                @ ((unsigned)&PORTC*8)+6;
volatile bit FIOC7                @ ((unsigned)&PORTC*8)+7;

volatile bit IOC0                @ ((unsigned)&PORTC*8)+0;
volatile bit IOC1                @ ((unsigned)&PORTC*8)+1;
volatile bit IOC2                @ ((unsigned)&PORTC*8)+2;
volatile bit IOC3                @ ((unsigned)&PORTC*8)+3;
volatile bit IOC4                @ ((unsigned)&PORTC*8)+4;
volatile bit IOC5                @ ((unsigned)&PORTC*8)+5;
volatile bit IOC6                @ ((unsigned)&PORTC*8)+6;
volatile bit IOC7                @ ((unsigned)&PORTC*8)+7;

volatile bit FRC0                 @ ((unsigned)&PORTC*8)+0;
volatile bit FRC1                 @ ((unsigned)&PORTC*8)+1;
volatile bit FRC2                 @ ((unsigned)&PORTC*8)+2;
volatile bit FRC4                 @ ((unsigned)&PORTC*8)+4;
volatile bit FRC5                 @ ((unsigned)&PORTC*8)+5;
volatile bit FRC6                 @ ((unsigned)&PORTC*8)+6;
volatile bit FRC7                 @ ((unsigned)&PORTC*8)+7;

volatile bit RC0                 @ ((unsigned)&PORTC*8)+0;
volatile bit RC1                 @ ((unsigned)&PORTC*8)+1;
volatile bit RC2                 @ ((unsigned)&PORTC*8)+2;
volatile bit RC3                 @ ((unsigned)&PORTC*8)+3;
volatile bit RC4                 @ ((unsigned)&PORTC*8)+4;
volatile bit RC5                 @ ((unsigned)&PORTC*8)+5;
volatile bit RC6                 @ ((unsigned)&PORTC*8)+6;
volatile bit RC7                 @ ((unsigned)&PORTC*8)+7;

volatile bit FPC0                 @ ((unsigned)&PORTC*8)+0;
volatile bit FPC1                 @ ((unsigned)&PORTC*8)+1;
volatile bit FPC2                 @ ((unsigned)&PORTC*8)+2;
volatile bit FPC3                 @ ((unsigned)&PORTC*8)+3;
volatile bit FPC4                 @ ((unsigned)&PORTC*8)+4;
volatile bit FPC5                 @ ((unsigned)&PORTC*8)+5;
volatile bit FPC6                 @ ((unsigned)&PORTC*8)+6;
volatile bit FPC7                 @ ((unsigned)&PORTC*8)+7;

volatile bit PC0                 @ ((unsigned)&PORTC*8)+0;
volatile bit PC1                 @ ((unsigned)&PORTC*8)+1;
volatile bit PC2                 @ ((unsigned)&PORTC*8)+2;
volatile bit PC3                 @ ((unsigned)&PORTC*8)+3;
volatile bit PC4                 @ ((unsigned)&PORTC*8)+4;
volatile bit PC5                 @ ((unsigned)&PORTC*8)+5;
volatile bit PC6                 @ ((unsigned)&PORTC*8)+6;
volatile bit PC7                 @ ((unsigned)&PORTC*8)+7;

// Register: BSREG
volatile unsigned char           BSREG            @ 0x009;
volatile bit FBSREG0                 @ ((unsigned)&BSREG*8)+0;
volatile bit FBSREG1                 @ ((unsigned)&BSREG*8)+1;

volatile bit BSREG0                 @ ((unsigned)&BSREG*8)+0;
volatile bit BSREG1                 @ ((unsigned)&BSREG*8)+1;

// Register: PCHBUF
volatile unsigned char           PCHBUF              @ 0x00A;
#define 	PCLATH 	PCHBUF 

// Register: INTEN
volatile unsigned char           INTEN               @ 0x00B;
// bit and bitfield definitions
volatile bit FT0IE                 @ ((unsigned)&INTEN*8)+0;
volatile bit FPBIE                 @ ((unsigned)&INTEN*8)+1;
volatile bit FINTIE                @ ((unsigned)&INTEN*8)+2;
volatile bit FTC1IE                @ ((unsigned)&INTEN*8)+3;
volatile bit FT2IE                 @ ((unsigned)&INTEN*8)+4;
volatile bit FINT1IE               @ ((unsigned)&INTEN*8)+5;
volatile bit FT3IE                 @ ((unsigned)&INTEN*8)+6;
volatile bit FGIE                  @ ((unsigned)&INTEN*8)+7;

volatile bit T0IE                 @ ((unsigned)&INTEN*8)+0;
volatile bit PBIE                 @ ((unsigned)&INTEN*8)+1;
volatile bit INTIE                @ ((unsigned)&INTEN*8)+2;
volatile bit TC1IE                @ ((unsigned)&INTEN*8)+3;
volatile bit T2IE                @ ((unsigned)&INTEN*8)+4;
volatile bit INT1IE               @ ((unsigned)&INTEN*8)+5;
volatile bit T3IE                 @ ((unsigned)&INTEN*8)+6;
volatile bit GIE                  @ ((unsigned)&INTEN*8)+7;

// Register: INTFLAG1
volatile unsigned char           INTFLAG               @ 0x00C;
// bit and bitfield definitions
volatile bit FT0IF                 @ ((unsigned)&INTFLAG*8)+0;
volatile bit FPBIF                 @ ((unsigned)&INTFLAG*8)+1;
volatile bit FINTIF                @ ((unsigned)&INTFLAG*8)+2;
volatile bit FTC1IF                @ ((unsigned)&INTFLAG*8)+3;
volatile bit FT2IF                 @ ((unsigned)&INTFLAG*8)+4;
volatile bit FINT1IF               @ ((unsigned)&INTFLAG*8)+5;
volatile bit FT3IF                 @ ((unsigned)&INTFLAG*8)+6;

volatile bit T0IF                 @ ((unsigned)&INTFLAG*8)+0;
volatile bit PBIF                 @ ((unsigned)&INTFLAG*8)+1;
volatile bit INTIF                @ ((unsigned)&INTFLAG*8)+2;
volatile bit TC1IF                @ ((unsigned)&INTFLAG*8)+3;
volatile bit T2IF                 @ ((unsigned)&INTFLAG*8)+4;
volatile bit INT1IF               @ ((unsigned)&INTFLAG*8)+5;
volatile bit T3IF                 @ ((unsigned)&INTFLAG*8)+6;

// Register: INTFLAG1
volatile unsigned char           INTFLAG1               @ 0x0D; 
// bit and bitfield definitions
volatile bit FTKINTF                @ ((unsigned)&INTFLAG1*8)+0;
volatile bit FTKIF                @ ((unsigned)&INTFLAG1*8)+0;
//volatile bit FCOMINTF               @ ((unsigned)&INTFLAG1*8)+1;
volatile bit FADCIF               @ ((unsigned)&INTFLAG1*8)+2;

volatile bit TKINTF                @ ((unsigned)&INTFLAG1*8)+0;
volatile bit TKIF                @ ((unsigned)&INTFLAG1*8)+0;
//volatile bit COMINTF               @ ((unsigned)&INTFLAG1*8)+1;
volatile bit ADCIF               @ ((unsigned)&INTFLAG1*8)+2;


// Register: PDCON
//volatile unsigned char           PDCON               @ 0x00E;
volatile unsigned char           PBDCON               @ 0x00E;
// bit and bitfield definitions


// Register: ODCON
//volatile unsigned char           ODCON               @ 0x00F;
volatile unsigned char           PBODCON               @ 0x00F;
// bit and bitfield definitions

//**************************************************************

// Register: PHCON
volatile unsigned char           PBHCON               @ 0x010;
// bit and bitfield definitions

// Register: TC0L
//volatile unsigned char           TC0L               @ 0x011;//3311
volatile unsigned char           TC1M               @ 0x011;//3612
// bit and bitfield definitions
volatile bit FTCCKS               @ ((unsigned)&TC1M*8)+0;
volatile bit FRLOAD                @ ((unsigned)&TC1M*8)+1;
volatile bit FTC1S0              @ ((unsigned)&TC1M*8)+3;
volatile bit FTC1S1              @ ((unsigned)&TC1M*8)+4;
volatile bit FTC1S2              @ ((unsigned)&TC1M*8)+5;
volatile bit FTC1TR              @ ((unsigned)&TC1M*8)+7;

volatile bit TCCKS               @ ((unsigned)&TC1M*8)+0;
volatile bit RLOAD                @ ((unsigned)&TC1M*8)+1;
volatile bit TC1S0              @ ((unsigned)&TC1M*8)+3;
volatile bit TC1S1              @ ((unsigned)&TC1M*8)+4;
volatile bit TC1S2              @ ((unsigned)&TC1M*8)+5;
volatile bit TC1TR              @ ((unsigned)&TC1M*8)+7;

// Register: TC0M
//volatile unsigned char           TC0M               @ 0x012;//3311
volatile unsigned char           TC1C               @ 0x012;//3612
// bit and bitfield definitions
//volatile bit FPWM0               @ ((unsigned)&TC0M*8)+0;
//volatile bit FBUZ                @ ((unsigned)&TC0M*8)+1;
//volatile bit FT16SEL             @ ((unsigned)&TC0M*8)+2;
//volatile bit FTCCKS              @ ((unsigned)&TC0M*8)+3;
//volatile bit FTC0S0              @ ((unsigned)&TC0M*8)+4;
//volatile bit FTC0S1              @ ((unsigned)&TC0M*8)+5;
//volatile bit FTC0S2              @ ((unsigned)&TC0M*8)+6;
//volatile bit FTC0TR              @ ((unsigned)&TC0M*8)+7;

//volatile bit PWM0               @ ((unsigned)&TC0M*8)+0;
//volatile bit BUZ                @ ((unsigned)&TC0M*8)+1;
//volatile bit T16SEL             @ ((unsigned)&TC0M*8)+2;
//volatile bit TCCKS              @ ((unsigned)&TC0M*8)+3;
//volatile bit TC0S0              @ ((unsigned)&TC0M*8)+4;
//volatile bit TC0S1              @ ((unsigned)&TC0M*8)+5;
//volatile bit TC0S2              @ ((unsigned)&TC0M*8)+6;
//volatile bit TC0TR              @ ((unsigned)&TC0M*8)+7;

// Register: TC0R
//volatile unsigned char           TC0R               @ 0x013;//3311
volatile unsigned char           PBIC0                @ 0x013;//3612
// bit and bitfield definitions

// Register: TC0H
//volatile unsigned char           TC0H               @ 0x014;//3311
volatile unsigned char           TC1R                @ 0x014;//3612
// bit and bitfield definitions

//TC0D1
// Register: TC0D1
//volatile unsigned char           TC0D1               @ 0x015;//3612
// bit and bitfield definitions

//TC0D2
// Register: TC0D2
//volatile unsigned char           TC0D2               @ 0x016;//3311
volatile unsigned char           ADBREG                @ 0x016;//3612
volatile unsigned char           ADB1                @ 0x016;//3612
// bit and bitfield definitions

//PWMCON
// Register: PWMCON
//volatile unsigned char           PWMCON               @ 0x017;//3311
volatile unsigned char           ADF1               @ 0x017;//3612
// bit and bitfield definitions
//volatile bit FPWM1EN               @ ((unsigned)&PWMCON*8)+0;
//volatile bit FPWM2EN               @ ((unsigned)&PWMCON*8)+1;
//volatile bit FPWM1S                @ ((unsigned)&PWMCON*8)+2;
//volatile bit FPWM2S                @ ((unsigned)&PWMCON*8)+3;
//volatile bit FPWM1XR0              @ ((unsigned)&PWMCON*8)+4;
//volatile bit FPWM1XR1              @ ((unsigned)&PWMCON*8)+5;
//volatile bit FPWM2XR0              @ ((unsigned)&PWMCON*8)+6;
//volatile bit FPWM2XR1              @ ((unsigned)&PWMCON*8)+7;

//volatile bit PWM1EN               @ ((unsigned)&PWMCON*8)+0;
//volatile bit PWM2EN               @ ((unsigned)&PWMCON*8)+1;
//volatile bit PWM1S                @ ((unsigned)&PWMCON*8)+2;
//volatile bit PWM2S                @ ((unsigned)&PWMCON*8)+3;
//volatile bit PWM1XR0              @ ((unsigned)&PWMCON*8)+4;
//volatile bit PWM1XR1              @ ((unsigned)&PWMCON*8)+5;
//volatile bit PWM2XR0              @ ((unsigned)&PWMCON*8)+6;
//volatile bit PWM2XR1              @ ((unsigned)&PWMCON*8)+7;

volatile unsigned char           ADF0               @ 0x018;//3612
volatile unsigned char           ADPC1               @ 0x019;//3612
volatile unsigned char           ADPC               @ 0x01A;//3612

volatile unsigned char           ADM               @ 0x01B;//3612
volatile bit FCHS0                @ ((unsigned)&ADM*8)+0;
volatile bit FCHS1                @ ((unsigned)&ADM*8)+1;
volatile bit FCHS2                @ ((unsigned)&ADM*8)+2;
volatile bit FCHS3                @ ((unsigned)&ADM*8)+3;
volatile bit FGCHS                @ ((unsigned)&ADM*8)+4;
volatile bit FEOC                 @ ((unsigned)&ADM*8)+5;
volatile bit FADS                 @ ((unsigned)&ADM*8)+6;
volatile bit FADENB               @ ((unsigned)&ADM*8)+7;

volatile bit CHS0                @ ((unsigned)&ADM*8)+0;
volatile bit CHS1                @ ((unsigned)&ADM*8)+1;
volatile bit CHS2                @ ((unsigned)&ADM*8)+2;
volatile bit CHS3                @ ((unsigned)&ADM*8)+3;
volatile bit GCHS                @ ((unsigned)&ADM*8)+4;
volatile bit EOC                 @ ((unsigned)&ADM*8)+5;
volatile bit ADS                 @ ((unsigned)&ADM*8)+6;
volatile bit ADENB               @ ((unsigned)&ADM*8)+7;


volatile unsigned char           ADB               @ 0x01C;//3612
volatile unsigned char           ADR               @ 0x01D;//3612
volatile unsigned char           ADT               @ 0x01E;//3612

volatile unsigned char           VREFH               @ 0x01F;//3612
volatile unsigned char           VREF               @ 0x01F;//3612
volatile bit FVHS0                @ ((unsigned)&VREFH*8)+0;
volatile bit FVHS1                @ ((unsigned)&VREFH*8)+1;
volatile bit FEVHENB              @ ((unsigned)&VREFH*8)+7;

volatile bit VHS0                @ ((unsigned)&VREFH*8)+0;
volatile bit VHS1                @ ((unsigned)&VREFH*8)+1;
volatile bit EVHENB              @ ((unsigned)&VREFH*8)+7;




//General USER RAM 
//20H~6FH

//70H~7FH
//General USER RAM 

//$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$
//BANK1
//$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$

//OPTION_REG
volatile unsigned char           OPTION_REG          @ 0x081; 
#define 	OPTION 		OPTION_REG
#define 	OPTIONR 	OPTION_REG
// bit and bitfield definitions
volatile bit FPS0               @ ((unsigned)&OPTION_REG*8)+0;
volatile bit FPS1               @ ((unsigned)&OPTION_REG*8)+1;
volatile bit FPS2                @ ((unsigned)&OPTION_REG*8)+2;
volatile bit FPSA                @ ((unsigned)&OPTION_REG*8)+3;
volatile bit FT0SE              @ ((unsigned)&OPTION_REG*8)+4;
volatile bit FT0CS              @ ((unsigned)&OPTION_REG*8)+5;
volatile bit FINTEDG            @ ((unsigned)&OPTION_REG*8)+6;
volatile bit FINTEDG1           @ ((unsigned)&OPTION_REG*8)+7;
volatile bit FINT1EDG           @ ((unsigned)&OPTION_REG*8)+7;

volatile bit PS0               @ ((unsigned)&OPTION_REG*8)+0;
volatile bit PS1               @ ((unsigned)&OPTION_REG*8)+1;
volatile bit PS2                @ ((unsigned)&OPTION_REG*8)+2;
volatile bit PSA                @ ((unsigned)&OPTION_REG*8)+3;
volatile bit T0SE              @ ((unsigned)&OPTION_REG*8)+4;
volatile bit T0CS              @ ((unsigned)&OPTION_REG*8)+5;
volatile bit INTEDG            @ ((unsigned)&OPTION_REG*8)+6;
volatile bit INTEDG1           @ ((unsigned)&OPTION_REG*8)+7;
volatile bit INT1EDG           @ ((unsigned)&OPTION_REG*8)+7;

//TRISA 85H
volatile unsigned char           TRISA               @ 0x085; 
#define 	IOSTA	TRISA
// bit and bitfield definitions
volatile bit TRISA0               @ ((unsigned)&TRISA*8)+0;
volatile bit TRISA1               @ ((unsigned)&TRISA*8)+1;
volatile bit TRISA2               @ ((unsigned)&TRISA*8)+2;
volatile bit TRISA3               @ ((unsigned)&TRISA*8)+3;
volatile bit TRISA4               @ ((unsigned)&TRISA*8)+4;
volatile bit TRISA5               @ ((unsigned)&TRISA*8)+5;
volatile bit TRISA6               @ ((unsigned)&TRISA*8)+6;
volatile bit TRISA7               @ ((unsigned)&TRISA*8)+7;

//TRISB	86H
volatile unsigned char           TRISB               @ 0x086; 
#define 	IOSTB	TRISB
// bit and bitfield definitions
volatile bit TRISB0               @ ((unsigned)&TRISB*8)+0;
volatile bit TRISB1               @ ((unsigned)&TRISB*8)+1;
volatile bit TRISB2               @ ((unsigned)&TRISB*8)+2;
volatile bit TRISB3               @ ((unsigned)&TRISB*8)+3;
volatile bit TRISB4               @ ((unsigned)&TRISB*8)+4;
volatile bit TRISB5               @ ((unsigned)&TRISB*8)+5;
volatile bit TRISB6               @ ((unsigned)&TRISB*8)+6;
volatile bit TRISB7               @ ((unsigned)&TRISB*8)+7;


//TRISB	87H
volatile unsigned char           TRISC               @ 0x087; 
#define 	IOSTC	TRISC
// bit and bitfield definitions
volatile bit TRISC0               @ ((unsigned)&TRISC*8)+0;
volatile bit TRISC1               @ ((unsigned)&TRISC*8)+1;
volatile bit TRISC2               @ ((unsigned)&TRISC*8)+2;
volatile bit TRISC3               @ ((unsigned)&TRISC*8)+3;
volatile bit TRISC4               @ ((unsigned)&TRISC*8)+4;
volatile bit TRISC5               @ ((unsigned)&TRISC*8)+5;
volatile bit TRISC6               @ ((unsigned)&TRISC*8)+6;
volatile bit TRISC7               @ ((unsigned)&TRISC*8)+7;


//INTEN1 8DH
volatile unsigned char           INTEN1               @ 0x08D; 
// bit and bitfield definitions
volatile bit FTKINTEN                @ ((unsigned)&INTEN1*8)+0;
volatile bit FTKIE                @ ((unsigned)&INTEN1*8)+0;
//volatile bit FCOMINTEN               @ ((unsigned)&INTEN1*8)+1;
volatile bit FADCIE               @ ((unsigned)&INTEN1*8)+2;

volatile bit TKINTEN                @ ((unsigned)&INTEN1*8)+0;
volatile bit TKIE                @ ((unsigned)&INTEN1*8)+0;
//volatile bit COMINTEN               @ ((unsigned)&INTEN1*8)+1;
volatile bit ADCIE               @ ((unsigned)&INTEN1*8)+2;


//PCON 8EH
volatile unsigned char           CHIPCON            @ 0x08E;
volatile unsigned char           PCON               @ 0x08E;
// bit and bitfield definitions
volatile bit FSMTS                 @ ((unsigned)&PCON*8)+4;
volatile bit FLVDTE                 @ ((unsigned)&PCON*8)+5;
volatile bit FEIS                   @ ((unsigned)&PCON*8)+6;
volatile bit FWDTE                  @ ((unsigned)&PCON*8)+7;

volatile bit SMTS                 @ ((unsigned)&PCON*8)+4;
volatile bit LVDTE                 @ ((unsigned)&PCON*8)+5;
volatile bit EIS                   @ ((unsigned)&PCON*8)+6;
volatile bit WDTE                  @ ((unsigned)&PCON*8)+7;


//WUCON 8FH
volatile unsigned char           WUCON               @ 0x08F;//3311
volatile unsigned char           WUBCON               @ 0x08F;//3612
// bit and bitfield definitions

//**************************************************************

//PAIC0 90H
volatile unsigned char           PAIC0               @ 0x090;
// bit and bitfield definitions

//PBIC0 91H
//volatile unsigned char           PBIC0               @ 0x091;//3311
volatile unsigned char           PCIC0               @ 0x091;//3612
// bit and bitfield definitions

//PAHCON 92H
volatile unsigned char           PAHCON               @ 0x092;
// bit and bitfield definitions

//PADCON 93H
volatile unsigned char           PADCON               @ 0x093;
// bit and bitfield definitions
//volatile bit FPADC4              @ ((unsigned)&PADCON*8)+4;
//volatile bit FPADC5              @ ((unsigned)&PADCON*8)+5;

//volatile bit PADC4              @ ((unsigned)&PADCON*8)+4;
//volatile bit PADC5              @ ((unsigned)&PADCON*8)+5;
//volatile bit PHB4               @ ((unsigned)&PADCON*8)+4;
//volatile bit PHB5               @ ((unsigned)&PADCON*8)+5;


//OSCM 94H
volatile unsigned char           OSCM               @ 0x094;
// bit and bitfield definitions
volatile bit FCLKMD               @ ((unsigned)&OSCM*8)+0;
volatile bit FSTPHX               @ ((unsigned)&OSCM*8)+1;
volatile bit FXTSEL               @ ((unsigned)&OSCM*8)+2;
volatile bit FSLCON               @ ((unsigned)&OSCM*8)+3;
volatile bit FRTCEN               @ ((unsigned)&OSCM*8)+4;
volatile bit FGREENEN             @ ((unsigned)&OSCM*8)+5;
volatile bit FGREEN               @ ((unsigned)&OSCM*8)+5;
volatile bit FWAKEMODE            @ ((unsigned)&OSCM*8)+6;

volatile bit CLKMD               @ ((unsigned)&OSCM*8)+0;
volatile bit STPHX               @ ((unsigned)&OSCM*8)+1;
volatile bit XTSEL               @ ((unsigned)&OSCM*8)+2;
volatile bit SLCON               @ ((unsigned)&OSCM*8)+3;
volatile bit RTCEN               @ ((unsigned)&OSCM*8)+4;
volatile bit GREENEN             @ ((unsigned)&OSCM*8)+5;
volatile bit GREEN               @ ((unsigned)&OSCM*8)+5;
volatile bit WAKEMODE            @ ((unsigned)&OSCM*8)+6;



volatile unsigned char           PAODCON               @ 0x095;
volatile unsigned char           WUACON               @ 0x096;
volatile unsigned char           PCHCON               @ 0x097;

volatile unsigned char           PCDCON               @ 0x098;

volatile unsigned char           RCSTA               @ 0x099;
volatile bit FRX9D               @ ((unsigned)&RCSTA*8)+0;
volatile bit FOERR               @ ((unsigned)&RCSTA*8)+1;
volatile bit FFERR               @ ((unsigned)&RCSTA*8)+2;
volatile bit FADDEN              @ ((unsigned)&RCSTA*8)+3;
volatile bit FCREN               @ ((unsigned)&RCSTA*8)+4;
volatile bit FSREN               @ ((unsigned)&RCSTA*8)+5;
volatile bit FRX9                @ ((unsigned)&RCSTA*8)+6;
volatile bit FSPEN               @ ((unsigned)&RCSTA*8)+7;

volatile bit RX9D               @ ((unsigned)&RCSTA*8)+0;
volatile bit OERR               @ ((unsigned)&RCSTA*8)+1;
volatile bit FERR               @ ((unsigned)&RCSTA*8)+2;
volatile bit ADDEN              @ ((unsigned)&RCSTA*8)+3;
volatile bit CREN               @ ((unsigned)&RCSTA*8)+4;
volatile bit SREN               @ ((unsigned)&RCSTA*8)+5;
volatile bit RX9                @ ((unsigned)&RCSTA*8)+6;
volatile bit SPEN               @ ((unsigned)&RCSTA*8)+7;

volatile unsigned char           TXREG               @ 0x09A;
volatile unsigned char           RXREG               @ 0x09B;

volatile unsigned char           TXSTA               @ 0x09C;
volatile bit FTX9D               @ ((unsigned)&TXSTA*8)+0;
volatile bit FTRMT               @ ((unsigned)&TXSTA*8)+1;
volatile bit FBRGH               @ ((unsigned)&TXSTA*8)+2;
volatile bit FSYNC               @ ((unsigned)&TXSTA*8)+4;
volatile bit FTXEN               @ ((unsigned)&TXSTA*8)+5;
volatile bit FTX9                @ ((unsigned)&TXSTA*8)+6;
volatile bit FCSRC               @ ((unsigned)&TXSTA*8)+7;

volatile bit TX9D               @ ((unsigned)&TXSTA*8)+0;
volatile bit TRMT               @ ((unsigned)&TXSTA*8)+1;
volatile bit BRGH               @ ((unsigned)&TXSTA*8)+2;
volatile bit SYNC               @ ((unsigned)&TXSTA*8)+4;
volatile bit TXEN               @ ((unsigned)&TXSTA*8)+5;
volatile bit TX9                @ ((unsigned)&TXSTA*8)+6;
volatile bit CSRC               @ ((unsigned)&TXSTA*8)+7;

volatile unsigned char           SPBRG               @ 0x09D;
volatile unsigned char           SPBRGH               @ 0x09E;

volatile unsigned char           BAUDCTL               @ 0x09F;
volatile bit FIFTX               @ ((unsigned)&BAUDCTL*8)+0;
volatile bit FIFRX               @ ((unsigned)&BAUDCTL*8)+1;
volatile bit FBRG16              @ ((unsigned)&BAUDCTL*8)+3;
volatile bit FTXIE               @ ((unsigned)&BAUDCTL*8)+4;
volatile bit FRXIE               @ ((unsigned)&BAUDCTL*8)+5;
volatile bit FCSKP               @ ((unsigned)&BAUDCTL*8)+6;
volatile bit FSCKP               @ ((unsigned)&BAUDCTL*8)+6;

volatile bit IFTX               @ ((unsigned)&BAUDCTL*8)+0;
volatile bit IFRX               @ ((unsigned)&BAUDCTL*8)+1;
volatile bit BRG16              @ ((unsigned)&BAUDCTL*8)+3;
volatile bit TXIE               @ ((unsigned)&BAUDCTL*8)+4;
volatile bit RXIE               @ ((unsigned)&BAUDCTL*8)+5;
volatile bit CSKP               @ ((unsigned)&BAUDCTL*8)+6;
volatile bit SCKP               @ ((unsigned)&BAUDCTL*8)+6;


//$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$
//BANK2
//$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$
//EEADR 10DH
volatile unsigned char           EEADR               @ 0x10D;
///volatile unsigned char           EEADRL              @ 0x10D;
#define	EEADRL	EEADR
// bit and bitfield definitions

//EEDATL 10EH
volatile unsigned char           EEDATL               @ 0x10E;
// bit and bitfield definitions

//EEADRH 10FH 
//volatile unsigned char           EEADRH               @ 0x10F;
// bit and bitfield definitions

//EECON 110H EECON
volatile unsigned char           EECON               @ 0x10F;
//volatile unsigned char           EECON1               @ 0x110;
#define	EECON1	EECON
// bit and bitfield definitions
volatile bit FREADEE               @ ((unsigned)&EECON*8)+0;
volatile bit FPROGEE               @ ((unsigned)&EECON*8)+1;
volatile bit FERASEEE              @ ((unsigned)&EECON*8)+2;
volatile bit FERSALLEE             @ ((unsigned)&EECON*8)+3;
volatile bit FTIMEE0               @ ((unsigned)&EECON*8)+5;
volatile bit FTIMEE1               @ ((unsigned)&EECON*8)+6;

volatile bit READEE               @ ((unsigned)&EECON*8)+0;
volatile bit PROGEE               @ ((unsigned)&EECON*8)+1;
volatile bit ERASEEE              @ ((unsigned)&EECON*8)+2;
volatile bit ERSALLEE             @ ((unsigned)&EECON*8)+3;
volatile bit TIMEE0               @ ((unsigned)&EECON*8)+5;
volatile bit TIMEE1               @ ((unsigned)&EECON*8)+6;

volatile unsigned char           T2PWM0C1               @ 0x110;
/*
volatile bit FT2PWM0S               @ ((unsigned)&T2PWM0C1*8)+0;
volatile bit FT2PWM1S               @ ((unsigned)&T2PWM0C1*8)+1;
volatile bit FT2PWM2S               @ ((unsigned)&T2PWM0C1*8)+2;
volatile bit FT2PWM3S               @ ((unsigned)&T2PWM0C1*8)+3;
volatile bit FT2PWM4S               @ ((unsigned)&T2PWM0C1*8)+4;
volatile bit FT2PWM5S               @ ((unsigned)&T2PWM0C1*8)+5;

volatile bit T2PWM0S               @ ((unsigned)&T2PWM0C1*8)+0;
volatile bit T2PWM1S               @ ((unsigned)&T2PWM0C1*8)+1;
volatile bit T2PWM2S               @ ((unsigned)&T2PWM0C1*8)+2;
volatile bit T2PWM3S               @ ((unsigned)&T2PWM0C1*8)+3;
volatile bit T2PWM4S               @ ((unsigned)&T2PWM0C1*8)+4;
volatile bit T2PWM5S               @ ((unsigned)&T2PWM0C1*8)+5;
*/
//PWM0EN 111H
// Register: PWM0EN
//volatile unsigned char           PWM0EN               @ 0x111;
/*/ bit and bitfield definitions
volatile bit FPWM0_EN                @ ((unsigned)&PWM0EN*8)+0;
volatile bit FPWM0_OEN               @ ((unsigned)&PWM0EN*8)+1;
volatile bit FPWM01_OEN              @ ((unsigned)&PWM0EN*8)+2;
volatile bit FPWM0M                  @ ((unsigned)&PWM0EN*8)+3;
volatile bit FPWM1_OEN               @ ((unsigned)&PWM0EN*8)+4;
volatile bit FTP0SEL8                @ ((unsigned)&PWM0EN*8)+5;
volatile bit FTP0EN                  @ ((unsigned)&PWM0EN*8)+7;

volatile bit PWM0_EN                @ ((unsigned)&PWM0EN*8)+0;
volatile bit PWM0_OEN               @ ((unsigned)&PWM0EN*8)+1;
volatile bit PWM01_OEN              @ ((unsigned)&PWM0EN*8)+2;
volatile bit PWM0M                  @ ((unsigned)&PWM0EN*8)+3;
volatile bit PWM1_OEN               @ ((unsigned)&PWM0EN*8)+4;
volatile bit TP0SEL8                @ ((unsigned)&PWM0EN*8)+5;
volatile bit TP0EN                  @ ((unsigned)&PWM0EN*8)+7;
*/
// Register: PWM0C
//volatile unsigned char           PWM0C               @ 0x112;
// bit and bitfield definitions

// Register: PWM0TL
//volatile unsigned char           PWM0TL               @ 0x113;
volatile unsigned char           T2PWM0EN1               @ 0x113;
// bit and bitfield definitions
volatile bit FT2PWM0E               @ ((unsigned)&T2PWM0EN1*8)+0;
volatile bit FT2PWM1E               @ ((unsigned)&T2PWM0EN1*8)+1;
volatile bit FT2PWM2E               @ ((unsigned)&T2PWM0EN1*8)+2;
volatile bit FT2PWM3E               @ ((unsigned)&T2PWM0EN1*8)+3;
volatile bit FT2PWM4E               @ ((unsigned)&T2PWM0EN1*8)+4;
volatile bit FT2PWM5E               @ ((unsigned)&T2PWM0EN1*8)+5;

volatile bit T2PWM0E               @ ((unsigned)&T2PWM0EN1*8)+0;
volatile bit T2PWM1E               @ ((unsigned)&T2PWM0EN1*8)+1;
volatile bit T2PWM2E               @ ((unsigned)&T2PWM0EN1*8)+2;
volatile bit T2PWM3E               @ ((unsigned)&T2PWM0EN1*8)+3;
volatile bit T2PWM4E               @ ((unsigned)&T2PWM0EN1*8)+4;
volatile bit T2PWM5E               @ ((unsigned)&T2PWM0EN1*8)+5;

// Register: PWM0TH
//volatile unsigned char           PWM0TH               @ 0x114;
// bit and bitfield definitions


// Register: PWM0PL
//volatile unsigned char           PWM0PL               @ 0x115;
// bit and bitfield definitions

// Register: TKC0
volatile unsigned char           TKC0               @ 0x116;
// bit and bitfield definitions
volatile bit FTKPS_0               @ ((unsigned)&TKC0*8)+0;
volatile bit FTKPS_1               @ ((unsigned)&TKC0*8)+1;
volatile bit FTKPS_2               @ ((unsigned)&TKC0*8)+2;
volatile bit FTKPS_3               @ ((unsigned)&TKC0*8)+3;
volatile bit FCVS                  @ ((unsigned)&TKC0*8)+4;
volatile bit FTKST                 @ ((unsigned)&TKC0*8)+6;
volatile bit FTKEN                 @ ((unsigned)&TKC0*8)+7;

volatile bit TKPS_0               @ ((unsigned)&TKC0*8)+0;
volatile bit TKPS_1               @ ((unsigned)&TKC0*8)+1;
volatile bit TKPS_2               @ ((unsigned)&TKC0*8)+2;
volatile bit TKPS_3               @ ((unsigned)&TKC0*8)+3;
volatile bit CVS                  @ ((unsigned)&TKC0*8)+4;
volatile bit TKST                 @ ((unsigned)&TKC0*8)+6;
volatile bit TKEN                 @ ((unsigned)&TKC0*8)+7;


// Register: TK16DH
volatile unsigned char           TK16DH               @ 0x117;
// bit and bitfield definitions

// Register: TK16DL
volatile unsigned char           TK16DL               @ 0x118;
// bit and bitfield definitions

// Register: TKC1
volatile unsigned char           TKC1                 @ 0x119; 
// bit and bitfield definitions
volatile bit FDCTS_0               @ ((unsigned)&TKC1*8)+0;
volatile bit FDCTS_1               @ ((unsigned)&TKC1*8)+1;
volatile bit FCCFLT_0              @ ((unsigned)&TKC1*8)+4;
volatile bit FCCFLT_1              @ ((unsigned)&TKC1*8)+5;
volatile bit FCCFLT_2              @ ((unsigned)&TKC1*8)+6;

volatile bit DCTS_0               @ ((unsigned)&TKC1*8)+0;
volatile bit DCTS_1               @ ((unsigned)&TKC1*8)+1;
volatile bit CCFLT_0              @ ((unsigned)&TKC1*8)+4;
volatile bit CCFLT_1              @ ((unsigned)&TKC1*8)+5;
volatile bit CCFLT_2              @ ((unsigned)&TKC1*8)+6;

// Register: TKC2
volatile unsigned char           TKC2                 @ 0x11A;
// bit and bitfield definitions
volatile bit FTKWKEN              @ ((unsigned)&TKC2*8)+6;
volatile bit TKWKEN              @ ((unsigned)&TKC2*8)+6;

// Register: TKC3
volatile unsigned char           TKC3                 @ 0x11B;
// bit and bitfield definitions
volatile bit FCVREFS_0            @ ((unsigned)&TKC3*8)+0;
volatile bit FCVREFS_1            @ ((unsigned)&TKC3*8)+1;
volatile bit FCPVS_0              @ ((unsigned)&TKC3*8)+3;
volatile bit FCPVS_1              @ ((unsigned)&TKC3*8)+4;

volatile bit CVREFS_0            @ ((unsigned)&TKC3*8)+0;
volatile bit CVREFS_1            @ ((unsigned)&TKC3*8)+1;
volatile bit CPVS_0              @ ((unsigned)&TKC3*8)+3;
volatile bit CPVS_1              @ ((unsigned)&TKC3*8)+4;

// Register: TKSTA
volatile unsigned char           TKSTA                 @ 0x11C; 
// bit and bitfield definitions
volatile bit FSACMPO             @ ((unsigned)&TKSTA*8)+1;
volatile bit FACMPO              @ ((unsigned)&TKSTA*8)+2;
volatile bit FDCMPO              @ ((unsigned)&TKSTA*8)+3;
volatile bit FTMOUT              @ ((unsigned)&TKSTA*8)+7;

volatile bit SACMPO             @ ((unsigned)&TKSTA*8)+1;
volatile bit ACMPO              @ ((unsigned)&TKSTA*8)+2;
volatile bit DCMPO              @ ((unsigned)&TKSTA*8)+3;
volatile bit TMOUT              @ ((unsigned)&TKSTA*8)+7;


// Register: TKPDH
volatile unsigned char           TKPDH               @ 0x11D;
// bit and bitfield definitions

// Register: TKPDL
volatile unsigned char           TKPDL               @ 0x11E;
// bit and bitfield definitions

volatile unsigned char           PFACES               @ 0x11F;
volatile bit FPFS0               @ ((unsigned)&PFACES*8)+0;
volatile bit FPFS1               @ ((unsigned)&PFACES*8)+1;
volatile bit FPFS2               @ ((unsigned)&PFACES*8)+2;
volatile bit FPFS3               @ ((unsigned)&PFACES*8)+3;
volatile bit FPFS4                 @ ((unsigned)&PFACES*8)+4;
volatile bit FPFS5                 @ ((unsigned)&PFACES*8)+5;

volatile bit PFS0               @ ((unsigned)&PFACES*8)+0;
volatile bit PFS1               @ ((unsigned)&PFACES*8)+1;
volatile bit PFS2               @ ((unsigned)&PFACES*8)+2;
volatile bit PFS3               @ ((unsigned)&PFACES*8)+3;
volatile bit PFS4                 @ ((unsigned)&PFACES*8)+4;
volatile bit PFS5                 @ ((unsigned)&PFACES*8)+5;
//$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$
//BANK3
//$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$

volatile unsigned char           IRCREG               @ 0x188; 

volatile unsigned char           T2PWM4DL               @ 0x18D; 
volatile unsigned char           T2PWM4DH               @ 0x18E; 
volatile unsigned char           T2PWM5DL               @ 0x18F; 
volatile unsigned char           T2PWM5DH               @ 0x190;

volatile unsigned char           T2PWM0EN               @ 0x191; 
volatile bit FT2PWMEN               @ ((unsigned)&T2PWM0EN*8)+0;
volatile bit FPWM1M               @ ((unsigned)&T2PWM0EN*8)+1;
volatile bit FPWM2M               @ ((unsigned)&T2PWM0EN*8)+2;
volatile bit FPWM3M               @ ((unsigned)&T2PWM0EN*8)+3;
volatile bit FT2SEL8               @ ((unsigned)&T2PWM0EN*8)+5;
volatile bit FT2REN               @ ((unsigned)&T2PWM0EN*8)+7;

volatile bit T2PWMEN               @ ((unsigned)&T2PWM0EN*8)+0;
volatile bit PWM1M               @ ((unsigned)&T2PWM0EN*8)+1;
volatile bit PWM2M               @ ((unsigned)&T2PWM0EN*8)+2;
volatile bit PWM3M               @ ((unsigned)&T2PWM0EN*8)+3;
volatile bit T2SEL8               @ ((unsigned)&T2PWM0EN*8)+5;
volatile bit T2REN               @ ((unsigned)&T2PWM0EN*8)+7;

volatile unsigned char           T2PWM0C               @ 0x192;
volatile unsigned char           T2PWM0TL              @ 0x193;

volatile unsigned char           T2PWM0TH               @ 0x194;
volatile unsigned char           T2PWM0PL               @ 0x195;
volatile unsigned char           T2PWM0PH               @ 0x196;
volatile unsigned char           T2PWM0DL               @ 0x197;

volatile unsigned char           T2PWM0DH               @ 0x198;
volatile unsigned char           T2PWM1DL               @ 0x199;
volatile unsigned char           T2PWM1DH               @ 0x19A;

volatile unsigned char           T2PWMPSC               @ 0x19B;
/*
volatile bit FT2PWM0S               @ ((unsigned)&T2PWMPSC*8)+0;
volatile bit FT2PWM1S               @ ((unsigned)&T2PWMPSC*8)+1;
volatile bit FT2PWM2S               @ ((unsigned)&T2PWMPSC*8)+2;
volatile bit FT2PWM3S               @ ((unsigned)&T2PWMPSC*8)+3;
volatile bit FT2PWM4S               @ ((unsigned)&T2PWMPSC*8)+4;
volatile bit FT2PWM5S               @ ((unsigned)&T2PWMPSC*8)+5;

volatile bit T2PWM0S               @ ((unsigned)&T2PWMPSC*8)+0;
volatile bit T2PWM1S               @ ((unsigned)&T2PWMPSC*8)+1;
volatile bit T2PWM2S               @ ((unsigned)&T2PWMPSC*8)+2;
volatile bit T2PWM3S               @ ((unsigned)&T2PWMPSC*8)+3;
volatile bit T2PWM4S               @ ((unsigned)&T2PWMPSC*8)+4;
volatile bit T2PWM5S               @ ((unsigned)&T2PWMPSC*8)+5;
*/
volatile unsigned char           T2PWM2DL               @ 0x19C;
volatile unsigned char           T2PWM2DH               @ 0x19D;
volatile unsigned char           T2PWM3DL               @ 0x19E;
volatile unsigned char           T2PWM3DH               @ 0x19F;




//$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$
//BANK4
//$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$

volatile unsigned char           LOADREG               @ 0x0D;

//FLCON1 0EH
volatile unsigned char           FLCON1               @ 0x0E; 
// bit and bitfield definitions
volatile bit FREADL                @ ((unsigned)&FLCON1*8)+0;
volatile bit FPROGL                @ ((unsigned)&FLCON1*8)+1;
volatile bit FERASEL               @ ((unsigned)&FLCON1*8)+2;
volatile bit FTIMEL0               @ ((unsigned)&FLCON1*8)+5;
volatile bit FTIMEL1               @ ((unsigned)&FLCON1*8)+6;
volatile bit FCEFL                 @ ((unsigned)&FLCON1*8)+7;

volatile bit READL                @ ((unsigned)&FLCON1*8)+0;
volatile bit PROGL                @ ((unsigned)&FLCON1*8)+1;
volatile bit ERASEL               @ ((unsigned)&FLCON1*8)+2;
volatile bit TIMEL0               @ ((unsigned)&FLCON1*8)+5;
volatile bit TIMEL1               @ ((unsigned)&FLCON1*8)+6;
volatile bit CEFL                 @ ((unsigned)&FLCON1*8)+7;

//FLCON2 18FH
volatile unsigned char           FLCON2               @ 0x0F;
// bit and bitfield definitions

//**************************************************************
// Register: FLADRH
volatile unsigned char           FLADRH               @ 0x10;
// bit and bitfield definitions


// Register: FLADRL
volatile unsigned char           FLADRL               @ 0x11;
// bit and bitfield definitions

// Register: FLDATH
volatile unsigned char           FLDATH               @ 0x12;
// bit and bitfield definitions


// Register: FLDATL
volatile unsigned char           FLDATL               @ 0x13;
// bit and bitfield definitions

// Register: FLerrf
volatile unsigned char           FLEF               @ 0x14;
volatile unsigned char           FLerrf             @ 0x14;
// bit and bitfield definitions

volatile unsigned char           RCSTA1               @ 0x19;
volatile bit FRX9D1               @ ((unsigned)&RCSTA1*8)+0;
volatile bit FOERR1               @ ((unsigned)&RCSTA1*8)+1;
volatile bit FFERR1               @ ((unsigned)&RCSTA1*8)+2;
volatile bit FADDEN1              @ ((unsigned)&RCSTA1*8)+3;
volatile bit FCREN1               @ ((unsigned)&RCSTA1*8)+4;
volatile bit FSREN1               @ ((unsigned)&RCSTA1*8)+5;
volatile bit FR1X9                @ ((unsigned)&RCSTA1*8)+6;
volatile bit FSPEN1               @ ((unsigned)&RCSTA1*8)+7;

volatile bit RX9D1               @ ((unsigned)&RCSTA1*8)+0;
volatile bit OERR1               @ ((unsigned)&RCSTA1*8)+1;
volatile bit FERR1               @ ((unsigned)&RCSTA1*8)+2;
volatile bit ADDEN1              @ ((unsigned)&RCSTA1*8)+3;
volatile bit CREN1               @ ((unsigned)&RCSTA1*8)+4;
volatile bit SREN1               @ ((unsigned)&RCSTA1*8)+5;
volatile bit R1X9                @ ((unsigned)&RCSTA1*8)+6;
volatile bit SPEN1               @ ((unsigned)&RCSTA1*8)+7;

volatile unsigned char           TXREG1               @ 0x1A;
volatile unsigned char           RXREG1               @ 0x1B;

volatile unsigned char           TXSTA1               @ 0x1C;
volatile bit FTX9D1               @ ((unsigned)&TXSTA1*8)+0;
volatile bit FTRMT1               @ ((unsigned)&TXSTA1*8)+1;
volatile bit FBR1GH               @ ((unsigned)&TXSTA1*8)+2;
volatile bit FSYNC1               @ ((unsigned)&TXSTA1*8)+4;
volatile bit FTXEN1               @ ((unsigned)&TXSTA1*8)+5;
volatile bit FT1X9                @ ((unsigned)&TXSTA1*8)+6;
volatile bit FCSRC1               @ ((unsigned)&TXSTA1*8)+7;

volatile bit TX9D1               @ ((unsigned)&TXSTA1*8)+0;
volatile bit TRMT1               @ ((unsigned)&TXSTA1*8)+1;
volatile bit BR1GH               @ ((unsigned)&TXSTA1*8)+2;
volatile bit SYNC1               @ ((unsigned)&TXSTA1*8)+4;
volatile bit TXEN1               @ ((unsigned)&TXSTA1*8)+5;
volatile bit T1X9                @ ((unsigned)&TXSTA1*8)+6;
volatile bit CSRC1               @ ((unsigned)&TXSTA1*8)+7;

volatile unsigned char           SPBR1G               @ 0x1D;
volatile unsigned char           SPBR1GH               @ 0x1E;

volatile unsigned char           BAUDCTL1               @ 0x1F;
volatile bit FIFTX1                @ ((unsigned)&BAUDCTL1*8)+0;
volatile bit FIFRX1                @ ((unsigned)&BAUDCTL1*8)+1;
volatile bit FBR1G16               @ ((unsigned)&BAUDCTL1*8)+3;
volatile bit FTXIE1                @ ((unsigned)&BAUDCTL1*8)+4;
volatile bit FRXIE1                @ ((unsigned)&BAUDCTL1*8)+5;
volatile bit FCSKP1                @ ((unsigned)&BAUDCTL1*8)+6;
volatile bit FSCKP1                @ ((unsigned)&BAUDCTL1*8)+6;

volatile bit IFTX1                @ ((unsigned)&BAUDCTL1*8)+0;
volatile bit IFRX1                @ ((unsigned)&BAUDCTL1*8)+1;
volatile bit BR1G16               @ ((unsigned)&BAUDCTL1*8)+3;
volatile bit TXIE1                @ ((unsigned)&BAUDCTL1*8)+4;
volatile bit RXIE1                @ ((unsigned)&BAUDCTL1*8)+5;
volatile bit CSKP1                @ ((unsigned)&BAUDCTL1*8)+6;
volatile bit SCKP1                @ ((unsigned)&BAUDCTL1*8)+6;


//$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$
//BANK4//$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$

volatile unsigned char           T3PWM0EN               @ 0x11; 
// bit and bitfield definitions
volatile bit FT3PWMEN               @ ((unsigned)&T3PWM0EN*8)+0;
volatile bit FT3PWM0E               @ ((unsigned)&T3PWM0EN*8)+1;
volatile bit FT3PWM1E               @ ((unsigned)&T3PWM0EN*8)+2;
volatile bit FT3SEL8                @ ((unsigned)&T3PWM0EN*8)+5;
volatile bit FT3REN                 @ ((unsigned)&T3PWM0EN*8)+7;

volatile bit T3PWMEN               @ ((unsigned)&T3PWM0EN*8)+0;
volatile bit T3PWM0E               @ ((unsigned)&T3PWM0EN*8)+1;
volatile bit T3PWM1E               @ ((unsigned)&T3PWM0EN*8)+2;
volatile bit T3SEL8                @ ((unsigned)&T3PWM0EN*8)+5;
volatile bit T3REN                 @ ((unsigned)&T3PWM0EN*8)+7;

volatile unsigned char           T3PWM0C               @ 0x12;
volatile unsigned char           T3PWM0TL              @ 0x13;

volatile unsigned char           T3PWM0TH               @ 0x14;
volatile unsigned char           T3PWM0PL               @ 0x15;
volatile unsigned char           T3PWM0PH               @ 0x16;
volatile unsigned char           T3PWM0DL               @ 0x17;

volatile unsigned char           T3PWM0DH               @ 0x18;
volatile unsigned char           T3PWM1DL               @ 0x19;
volatile unsigned char           T3PWM1DH               @ 0x1A;

volatile unsigned char           T3PWMPSC               @ 0x1B;
volatile bit T3PWM0S               @ ((unsigned)&T3PWMPSC*8)+0;
volatile bit T3PWM1S               @ ((unsigned)&T3PWMPSC*8)+1;

volatile unsigned char           T3PWM2DL               @ 0x1C;
volatile unsigned char           T3PWM2DH               @ 0x1D;


//$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$
//BANK END
//$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$
#endif



/*
// Register: PBIC1
volatile unsigned char           PBIC1               @ 0x06C;
// bit and bitfield definitions

// Register: PAIC1
volatile unsigned char           PAIC1               @ 0x06F;
// bit and bitfield definitions

// Register: EECON
volatile unsigned char           EECON1               @ 0x07A;
// bit and bitfield definitions

// Register: OPAM
volatile unsigned char           OPAM               @ 0x0DB; //0X5B
// bit and bitfield definitions
volatile bit MULTS0                @ ((unsigned)&OPAM*8)+0;
volatile bit MULTS1                @ ((unsigned)&OPAM*8)+1;
volatile bit OPAMEN                @ ((unsigned)&OPAM*8)+2;
volatile bit COMMS                 @ ((unsigned)&OPAM*8)+3;

#ifndef _LIB_BUILD
volatile union {
    struct {
        unsigned	MULTS0              : 1;
        unsigned	MULTS1              : 1;
        unsigned	OPAMEN              : 1;
        unsigned	COMMS               : 1; 
        unsigned	                    : 4;
    };
} OPAMbits @ 0x0DB;
#endif
*/
//$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$
//$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$

/*
*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*
 
bit				1	==λ01ȡֵ
char			8	==зŻ޷ַ
unsigned char	8	==޷ַ
short			16	==з
unsigned short	16	==޷
int				16	==з
unsigned int	16	==޷
long			32	==зų
unsigned long	32	==޷ų
float			24	==
*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*


*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*
BANKݼĴĹ
ûر˵ıBank0;Bank0ڵıҪ⴦⣬
BankڵıǰӦbankţ
	bank1 unsigned char buffer[2]	;λbank0
	bank2 bit flag1,flag2	;λbank2(Ӳbank2)
	bank3 int U16_tmp0,U16_tmp1	;λbank3(Ӳbank3)
*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*


*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*
ιؼ:
extern - ⲿһCļҪʹһЩԭͶдļУ
	ôڱļб뽫Щɡextern ⲿ͡

volatile ױͱ
const    ͱ
persistent   ǳʼ
*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*



*/


