 
INDF	EQU		000H   
TMR0	EQU		001H   
PCL		EQU		002H   
STATUS	EQU		003H   
	#define		CARRY               STATUS,0
	#define		C	                STATUS,0
	#define		DC                  STATUS,1
	#define		Z                   STATUS,2
	#define		ZERO                STATUS,2
	#define		NPD                 STATUS,3
	#define		NTO                 STATUS,4
	#define		RP0                 STATUS,5
	#define		RP1                 STATUS,6
	#define		RST                 STATUS,7
	#define		IRP                 STATUS,7
	
FSR		EQU		004H   
	#define		FSR_7               FSR,7
	
PORTA	EQU		005H   
PA		EQU		005H   
RA		EQU		005H   
	#define		FPA0                PORTA,0
	#define		FPA1                PORTA,1
	#define		FPA2                PORTA,2
	#define		FPA3                PORTA,3
	#define		FPA4                PORTA,4
	#define		FPA5                PORTA,5
	#define		FPA6                PORTA,6
	#define		FPA7                PORTA,7
	

PORTB	EQU		006H   
PB		EQU		006H     
RB		EQU		006H 
	#define		FPB0                PORTB,0
	#define		FPB1                PORTB,1
	#define		FPB2                PORTB,2
	#define		FPB3                PORTB,3
	#define		FPB4                PORTB,4
	#define		FPB5                PORTB,5
	#define		FPB6                PORTB,6
	#define		FPB7                PORTB,7
	  

SRAM	EQU		007H   
      
;*****************************************************  
PCHBUF	EQU		0AH   
#define 	PCLATH 	PCHBUF
 
INTEN	EQU		0BH    
	#define		FT0IE		INTEN,0   
	#define		FPBIE		INTEN,1   
	#define		FINTIE		INTEN,2   
	#define		FTC0IE		INTEN,3   
	   
	#define		FTP0IE		INTEN,4   
	#define		FINT1IE		INTEN,5     
	#define		FGIE		INTEN,7   
	   
INTFLAG	EQU		0CH 
	#define		FT0IF		INTFLAG,0   
	#define		FPBIF		INTFLAG,1   
	#define		FINTIF		INTFLAG,2   
	#define		FTC0IF		INTFLAG,3   
	   
	#define		FTP0IF		INTFLAG,4   
	#define		FINT1IF		INTFLAG,5 


INTFLAG1	EQU		0DH
	#define		FTKINTF		INTFLAG1,0
	#define		FCOMINTF	INTFLAG1,1

PDCON	EQU		0EH

ODCON	EQU		0FH
;***************************************************** 
PHCON	EQU		010H      
TC0L	EQU		011H
TC0M	EQU		012H
	#define		FPWM0		TC0M,0   
	#define		FBUZ		TC0M,1   
	#define		FT16SEL		TC0M,2   
	#define		FTCCKS		TC0M,3  

	#define		FTC0S0		TC0M,4   
	#define		FTC0S1		TC0M,5   
	#define		FTC0S2		TC0M,6   
	#define		FTC0TR		TC0M,7 

TC0R	EQU		013H
TC0H	EQU		014H
TC0D1	EQU		015H
TC0D2	EQU		016H
PWMCON	EQU		017H
	#define		FPWM1EN               PWMCON,0
	#define		FPWM2EN               PWMCON,1
	#define		FPWM1S                PWMCON,2
	#define		FPWM2S                PWMCON,3

	#define		FPWM1XR0              PWMCON,4
	#define		FPWM1XR1              PWMCON,5
	#define		FPWM2XR0              PWMCON,6
	#define		FPWM2XR1              PWMCON,7

  
;*****************************************************  
;BANK1-   
;*****************************************************  
OPTION_REG	EQU		081H	
//#define 	OPTION 	OPTION_REG
	#define 	FPS0               OPTION_REG,0
	#define 	FPS1               OPTION_REG,1
	#define 	FPS2               OPTION_REG,2
	#define 	FSA                OPTION_REG,3

	#define 	FT0SE              OPTION_REG,4
	#define 	FT0CS              OPTION_REG,5
	#define 	FINTEDG            OPTION_REG,6
	#define 	FINTEDG1           OPTION_REG,7

TRISA	EQU		085H 
#define 	IOSTA	TRISA

TRISB	EQU		086H  
#define 	IOSTB	TRISB

INTEN1	EQU		08DH
	#define 	FTKINTEN		INTEN1,0
	#define 	FCOMINTEN		INTEN1,1
	
PCON	EQU		08EH   
	#define 	FLVDTE		PCON,5
	#define 	FEIS		PCON,6
	#define 	FWDTE		PCON,7

WUCON	EQU		08FH  

;***************************************************** 
PAIC0		EQU		090H
PBIC0		EQU		091H
PAHCON		EQU		092H
PADCON		EQU		093H
	#define		FPADC4		PADCON,4
	#define		FPADC5		PADCON,5
	
OSCM		EQU		094H
	#define		FCLKMD		OSCM,0   
	#define		FSTPHX		OSCM,1   
	#define		FXTSEL		OSCM,2   
	#define		FSLCON		OSCM,3   
	   
	#define		FSLT0CON	OSCM,4   
	#define		FGREENEN	OSCM,5   
	#define		FWAKEMODE	OSCM,6   




;*****************************************************  
;BANK2-   
;*****************************************************
EEADRL		EQU		010DH
#define		EEADR	EEADRL

EEDATL		EQU		010EH
EEADRH		EQU		010FH

EECON1		EQU		0110H
#define		EECON	EECON1
	#define		FREADEE		EECON1,0
	#define		FPROGEE		EECON1,1
	#define		FERASEEE	EECON1,2
	#define		FERSALLEE	EECON1,3
	#define		FTIMEEE		EECON1,6

PWM0EN		EQU		0111H  
	#define		FPWM0EN		PWM0EN,0   
	#define		FPWM0OEN	PWM0EN,1   
	#define		FPWM01OEN	PWM0EN,2   
	#define		FPWM0M		PWM0EN,3   
	   
	#define		FPWM1OEN	PWM0EN,4   
	#define		FTPSEL8		PWM0EN,5   	   
	#define		FTPEN		PWM0EN,7  

PWM0C		EQU		0112H  
  
PWM0TL		EQU		0113H   
PWM0TH		EQU		0114H   

PWM0PL		EQU		0115H   
PWM0PH		EQU		0116H

PWM0DL		EQU		0117H   
PWM0DH		EQU		0118H  

PWM0DTL		EQU		0119H   
PWM0DTH		EQU		011AH   
PWMPSCON	EQU		011BH   

PWM1DL		EQU		011CH   
PWM1DH		EQU		011DH

;*****************************************************  
;BANK3-   
;*****************************************************   

FLCON1		EQU		018EH   
FLCON2		EQU		018FH   
FLADRH		EQU		0190H   
FLADRL		EQU		0191H   
FLDATH		EQU		0192H   
FLDATL		EQU		0193H   
FLerrf		EQU		0194H   
#define		FLEF	FLerrf
       
TKC0		EQU		0195H   
	#define		FTKPS0		TKC0,0   
	#define		FTKPS1		TKC0,1   
	#define		FTKPS2		TKC0,2   
	#define		FTKPS3		TKC0,3   
	   
	#define		FCVS		TKC0,4   
	;#define	FTKPS1		TKC0,5   
	#define		FTKST		TKC0,6	   
	#define		FTKEN		TKC0,7 
	
TK16DH		EQU		0196H   
TK16DL		EQU		0197H   
TKC1		EQU		0198H   
TKC2		EQU		0199H   
TKC3		EQU		019AH   
TKSTA		EQU		019BH   
	#define		FSACMPO		TKSTA,1   
	#define		FACMPO		TKSTA,2   
	#define		FDCMPO		TKSTA,3   
  
	#define		FTMOUT		TKSTA,7   
	
TKPDH		EQU		019CH      
TKPDL		EQU		019DH   
CMPCON		EQU		019EH   
#define		CMPC	CMPCON
	#define		FCOPOL               CMPCON,1;
	#define		FCVEN                CMPCON,2;
	#define		FCPEN                CMPCON,3;
	#define		FCODEB               CMPCON,4;
	#define		FFTCKS               CMPCON,5;
	#define		FCMPIF               CMPCON,6;
	#define		FCMPEN               CMPCON,7;
	
CMPM		EQU		019FH   
	#define		FVRS0                CMPM,0;
	#define		FVRS1                CMPM,1;
	#define		FVRS2                CMPM,2;
	#define		FVRS3                CMPM,3;
	#define		FXRVSEL              CMPM,4;
	#define		FCPINS0              CMPM,5;
	#define		FCPINS1              CMPM,6;
             
	
     
;*****************************************************   
;PIN-DEFINE   
;****************************************************   
;	    PA0	-1	14- PA1	                    *   
;	    PB7	-2	13- PA2	                    *   
;	    PB6	-3	12- PA3	                    *   
;	    VDD -4	11- VSS	                    *   
;	    PB5	-5	10- PB0	                    *   
;	    PB4	-6	9 - PB1	                    *   
;	    PB3	-7	8 - PB2	                    *   
;****************************************************      

	
