
;******************************************************************
;  ISP ROM-Write with Internal VPP 6.5V Generation macro 
;  Occupied Register: A,Y,Z,R  
;  execution time: 40ms(ISP_OK), 30ms(ISP_Fail)
;  Output status: R_Register (ISP_OK: R=0x5AH;   ISP_Fail: R=0xA5H)
;******************************************************************

RomwrtVpp 	macro
local		ISPP_End,ISP_Delay10ms	

	;==== [ VPP Set 6.9V ] ===================
	MOV	A,#00010101b	; ChargePump start-up setting (CP_Clock=62.2K, 1/2_Bias, C-Type, CP_Enale)
	XCH	a,LCDM1
	B0mov	Y,a		; Original setting of LCDM1 save in "Y" register
	Mov	a,#11111111b	; Set VCP=1111 and VPPINTL=1. (VPP set 6.9V and VPP-VLCD short)
	XCH	a,LCDM2
	B0mov	z,a		; Original setting of LCDM2 save in "Z" register
	Call	ISP_Delay10ms	; for VPP 6.9V stable 

	;==== [ ISP ROM Write Command ] ===========
	B0BTS1 	FVPPCHK		; VPP High Voltage check
	jmp	$+5
	Call	ISP_Delay10ms	; for VPP 6.9V stable
	ROMWRT			; ISP ROM Write Instruction
	nop			; must nop
	jmp	$+2
	b0bset	FLCDREF0	; if VPP voltage Fail, set "LCDREF0" for indication.

	;==== [VLCD drop to 2.7V ] ================
	b0bclr	FLCDBIAS		; Set 1/3 Bias
	mov	a,#11110000b		; VLCD=2.7V
	and	LCDM2,a	

	;-- Delay 20ms ---------- 
	Call	ISP_Delay10ms
	Call	ISP_Delay10ms

	;--- Set ISP status ---
	b0mov	r,#5AH		; ISP OK:   R=5AH
	b0bts0	FLCDREF0
	SWAPM	R		; ISP Fail: R=A5H

	;===== [ Original LCD seting ] ============
	B0mov	a,z
	b0mov	LCDM2,a		
	B0mov	a,y
	b0mov	LCDM1,a
	jmp	ISPP_End
ISP_Delay10ms:
	;-- Delay 10ms -- 
	clr	R	
	b0mov	a,R	
	incms	R
	jmp	$-1	
	add	a,#1
	cmprs	a,#13
	jmp	$-4
ret
ISPP_End:
	endm


;******************************************************************
;		Macro "LcdPumpStart"
; 	Occupied Register:  A,R,Y,Z
; 	Instruction cycle:  ~6170
; 	Code Size:          25-Words
;******************************************************************
LcdPumpStart	macro
	B0MOV	A,LCDM1		; LCDM1 Data Push in Y
	B0MOV	Y,A
	B0MOV	A,LCDM2		; LCDM2 Data Push in Z
	B0MOV	Z,A
	
	;---- LCD Pump Start up setting -----------
	MOV	A,#00010111b	; C-Type, 1/2 bias
	B0MOV	LCDM1,A		; PumpClock=ILRC
	MOV	A,#01100111b	; Pump Enable, BGM=1, C-Type,
	B0MOV	LCDM2,A		; 1/2 bias, PumpClock=ILRC

	;----- Delay 1ms --
	CLR	R
	nop
	INCMS	R
	jmp	$-2
		
	;----- Original Setting --------------------
	B0MOV	A,Y
	B0MOV	LCDM1,A		; LCDM1 Data Pop 
	B0MOV	A,Z
	B0MOV	LCDM2,A		; LCDM2 Data Pop
	B0BSET	FBGM		; BGM Must Set "1"
	
	;-- Delay 5ms -- 
	CLR	R	
	B0MOV	A,R	
	nop
	INCMS	R
	JMP	$-2	
	ADD	A,#1
	CMPRS	A,#5
	JMP	$-4
		
	endm
;******************************************************************
;		Macro LcdDisable"
; 	Occupied Register:  Non
; 	Instruction cycle:  2
; 	Code Size:          16-Words
;******************************************************************
LcdDisable	macro
		B0BCLR	FLCDPENB	; Pump Disable
		B0BCLR	FLCDENB		; LCD Function Disable
		endm

