;------------------------------------------------------------------------------
;  CHIP: SN8PC21
;  Revision History
;  
;  V01   06/25/2009  1. First issue and only for SN8ICE 2K. 
;  V02   02/10/2010  1. delete green mode text
;------------------------------------------------------------------------------
.ASSEMBLY	RedWrt_FORMAT	1
.Assembly	INC_VER		2
.Assembly	ASM_FORMAT	1
.Assembly	RAM_Size	32

.Assembly	INSTRUMENT	SN8PC21
.Assembly	BIT_FILE	SN8PC21

.Assembly	OTP_BODY_SIZE	0x0400 
.Assembly	USER_ROM_SIZE	0x03FC

.Assembly	OTP_TEST_SIZE	0x00E0
;.Assembly	MASK_TEST_FILE
.Assembly	MASK_TEST_CODE	0x0000, 0x0000, 0x0000, 0x0000
;.Assembly	OTP_TEST_FILE	
.Assembly	PGM_TYPE	13
.Assembly	CHIP_ID		0x3360		
.Assembly	COMMAND		
.Assembly	Port_Pins	7,6,0,0,0,0

; Code Option 0x03FF
.Assembly	OPTION		0		Fix_High
.Assembly	OPTION		1		Security	Enable	Disable
.Assembly	OPTION		2 : 4		Fix_High
.Assembly	OPTION		5		High_Clk	 Ext_RC 4M_X'tal x IHRC_8M 
.Help
{	
	IHRC_8M		:	"Internal 8M RC Oscillator"
	Ext_RC		:	"Connect R to VDD and Xin\nConnect C to GND and Xin"
	4M_X'tal	:	"Crystal/Resonator: 2Mhz~8Mhz"
}
.Assembly	OPTION		7		Fix_High
.Assembly	OPTION		8		Watch_Dog 	x x x x x Enable x x x x Disable x x x x Always_On 
.Help
{
	Always_ON	:	"Watchdog still enable even in\nSleep mode"
	Enable		:	"Normal mode: Enable Watchdog\nSleep mode: Stop Watchdog"
	Disable         :       "Disable Watchdog"
} 
.Assembly	OPTION		12		Reset_Pin 	P02	Reset
.Assembly	OPTION		13		Fix_High
.Assembly	OPTION   	14 : 15		Fix_High

; Code Option 0x03FE
.Assembly	OPTION		16		Fix_Low
.Assembly	OPTION		17		Fix_High
.Assembly	OPTION		18		Fix_Low
.Assembly	OPTION		19		Fix_High
.Assembly	OPTION		20		Fix_High
.Assembly	OPTION		21		Fix_Low
.Assembly	OPTION		22		Fix_High
.Assembly	OPTION		23		Fix_Low
.Assembly	OPTION		24		Fix_Low
.Assembly	OPTION		25		Fix_High
.Assembly	OPTION		26		Fix_Low
.Assembly	OPTION		27		Fix_High
.Assembly	OPTION		28 : 31		Fix_High

; Code Option 0x03FD
.Assembly	OPTION		32 : 47		Fix_High

; Code Option 0x17FC
.Assembly	OPTION		48 : 63		Fix_High

.Assembly	OPTION		2ffh

	R		EQU		0x82
	Z		EQU		0x83
	Y		EQU		0x84
	PFLAG		EQU		0x86
		FZ		EQU		PFLAG.0
		FDC		EQU		PFLAG.1
		FC		EQU		PFLAG.2
		FNPD		EQU		PFLAG.6
		FNT0		EQU		PFLAG.7

	P0M		EQU		0B8H
		FP06M		EQU		P0M.6
		FP05M		EQU		P0M.5
		FP04M		EQU		P0M.4
		FP03M		EQU		P0M.3
		FP01M		EQU		P0M.1
		FP00M		EQU		P0M.0

	P1M		EQU		0C1H
		FP15M		EQU		P1M.5
		FP14M		EQU		P1M.4
		FP13M		EQU		P1M.3
		FP12M		EQU		P1M.2
		FP11M		EQU		P1M.1
		FP10M		EQU		P1M.0

	INTRQ		EQU		0C8H
  		FT0IRQ  	EQU	  	INTRQ.4

	OSCM		EQU		0CAH
		FCPUM0		EQU		OSCM.3

	WDTR		EQU_W		0CCH

	IRR		EQU_W	  	0CDH

	PCL		EQU		0CEH
	PCH		EQU		0CFH

	P0		EQU  		0D0H
		FP06		EQU   		P0.6
		FP05		EQU   		P0.5
		FP04		EQU  	 	P0.4
		FP03		EQU 		P0.3
		FP02		EQU  	 	P0.2
		FP01		EQU  	 	P0.1
		FP00		EQU  	 	P0.0

	P1		EQU		0D1H
		FP15		EQU		P1.5
		FP14		EQU		P1.4
		FP13		EQU		P1.3
		FP12		EQU		P1.2
		FP11		EQU		P1.1
		FP10		EQU		P1.0

	T0M		EQU		0D8H
		FT0ENB	 	EQU  	 	T0M.7
		FT0RATE2 	EQU  	  	T0M.6
		FT0RATE1 	EQU  	  	T0M.5
		FT0RATE0 	EQU  	  	T0M.4

   	T0C		EQU		0D9H

	IRM  		EQU		0DAH
    		FCREN   	EQU		IRM.0 

	IRC		EQU		0DBH

	STKP		EQU		0DFH
		FSTKPB1		EQU		STKP.1
		FSTKPB0		EQU		STKP.0

	@YZ		EQU		0E7H
	IRD		EQU		0E8H

	STK3L		EQU		0F8h
	STK3H		EQU		0F9h
	STK2L		EQU		0FAh
	STK2H		EQU		0FBh
	STK1L		EQU		0FCh
	STK1H		EQU		0FDh
	STK0L		EQU		0FEh
	STK0H		EQU		0FFh

; -----------------------------------------------------
; Clear watchdog macro for compatibility in S8KD-2 ICE
;  
; Total Cycle: 2 

	@RST_WDT	macro		
 		   MOV  A, #0x5A
		   B0MOV  WDTR, A
	endm
; -----------------------------------------------------
; Sleep Mode control macro for compatibility in S8KD-2 ICE
;  
; Total Cycle: 1

	SleepMode	macro	
		B0BSET	FCPUM0
	endm
; -----------------------------------------------------	

.TEXT
{
	//{{SONIX_OPTION_RULE
	ENDP
	//}}SONIX_OPTION_RULE
}
