
;------------------------------------------------------------------------------
;  CHIP: SN8PC20 
;  Revision History
;  
;  V01   08/14/2007  1. First issue and only for SN8ICE 2K.
;  V02   12/17/2007  1. "GreenMode","SleepMode","SlowMode","Slow2Normal" macro programs. 
;  V03   04/03/2008  1. Add "RedWrt_FORMAT    1"  	
;  V04   06/19/2009  1. Delet "FT0TB equ T0M.0"
;  V05   06/29/2010  1. modify MACRO text "SLowMode" to "SlowMode"
;------------------------------------------------------------------------------
.ASSEMBLY    RedWrt_FORMAT    1

.Assembly	INC_VER		5
.Assembly	ASM_FORMAT	1
.Assembly	RAM_Size	56

.Assembly	INSTRUMENT	SN8PC20
.Assembly	BIT_FILE	SN8PC20

.Assembly	OTP_BODY_SIZE	0x0800
.Assembly	USER_ROM_SIZE	0x07FC

;.Assembly	OTP_TEST_SIZE	0x00A0
;.Assembly	MASK_TEST_FILE	SN8A1602A
.Assembly	MASK_TEST_CODE	0x0000, 0x0000, 0x0000, 0x0000
;.Assembly	OTP_TEST_FILE	SN86P
.Assembly	PGM_TYPE	12
.Assembly	CHIP_ID		0x3330
.Assembly	command		Enable_ORG4_7, RBANK_LIMIT, STACK_LIMIT, GREEN_B0BSET_LIMIT
.Assembly	Port_Pins	8, 8, 0, 0, 0, 2

; Code Option 0x07FF
.Assembly	OPTION		0		Fix_High
.Assembly	OPTION		1		Security	Enable	Disable
.Assembly	OPTION		2		Fcpu		Fosc/1 Fosc/2 Fosc/4 Fosc/8
.Help
{
	Fcpu		: 	"Only Effective for HIGH Clock"
}
.Assembly	OPTION		4		Fix_High
.Assembly	OPTION		5		High_Clk	IHRC_8M x x x Ext_RC  455K_X'tal  8M_X'tal  4M_X'tal
.Help
{ 
	IHRC_8M		:	"Internal 8M RC Oscillator"
	Ext_RC		:	"Connect R to VDD and Xin\nConnect C to GND and Xin"
	455K_X'tal	:	"455K Crystal"
	8M_X'tal	:	"Crystal/Resonator: 8Mhz~16Mhz"
	4M_X'tal	:	"Crystal/Resonator: 2Mhz~8Mhz"
}
.Assembly	OPTION		8		Watch_Dog	Always_On x x x x Enable x x x x Disable x x x x x
.Assembly	OPTION		12		Reset_Pin   P02 	Reset
.Assembly	OPTION		13		Fix_High
.Assembly	OPTION		14		Fix_High
.Assembly	OPTION		15		Fix_High

; Code Option 0x07FE
.Assembly	OPTION		16		Fix_Low
.Assembly	OPTION		17		Fix_High
.Assembly	OPTION		18		Fix_Low
.Assembly	OPTION		19		Fix_High
.Assembly	OPTION		20		Fix_High
.Assembly	OPTION		21		Fix_Low
.Assembly	OPTION		22		Fix_High
.Assembly	OPTION		23		Fix_Low
.Assembly	OPTION		24		Fix_Low
.Assembly	OPTION		25		Fix_High
.Assembly	OPTION		26		Fix_Low
.Assembly	OPTION		27		Fix_High
.Assembly	OPTION		28 : 31		Fix_Low

; Code Option 0x07FD
.Assembly	OPTION		32 : 63		Fix_High

.Assembly	OPTION		2ffh

	L			EQU		80H
	H			EQU		81H
	R			EQU		82H
	Z			EQU		83H
	Y			EQU		84H
	
	PFLAG			EQU		86H
		FZ		EQU		PFLAG.0
		FDC		EQU		PFLAG.1
		FC		EQU		PFLAG.2
		FGG		EQU		PFLAG.3
		FNPD	EQU		PFLAG.6
		FNT0	EQU		PFLAG.7

	P0M			EQU		0B8H
		FP00M	EQU		P0M.0
		FP01M	EQU		P0M.1
		FP03M	EQU		P0M.3
		FP04M	EQU		P0M.4
		FP05M	EQU		P0M.5
		FP06M	EQU		P0M.6
		FP07M	EQU		P0M.7

	PEDGE		EQU		0BFH		
		FP00G1	EQU		PEDGE.4
		FP00G0	EQU		PEDGE.3

	P1W			EQU	0C0H

	P1M			EQU		0C1H
		FP10M	EQU		P1M.0
		FP11M	EQU		P1M.1
		FP12M	EQU		P1M.2
		FP13M	EQU		P1M.3
		FP14M	EQU		P1M.4
		FP15M	EQU		P1M.5
		FP16M	EQU		P1M.6
		FP17M	EQU		P1M.7

	P5M			EQU		0C5H
  		FP50M	EQU		P5M.0
  		FP54M	EQU		P5M.4

	INTRQ		EQU		0C8H
		FP00IRQ	EQU		INTRQ.0
		FT0IRQ	EQU		INTRQ.4

	INTEN		EQU		0C9H
		FP00IEN	EQU		INTEN.0
		FT0IEN	EQU		INTEN.4

	OSCM		EQU		0CAH
		FCPUM1	EQU		OSCM.4
		FCPUM0	EQU		OSCM.3
		FCLKMD	EQU		OSCM.2
		FSTPHX	EQU		OSCM.1

	WDTR		EQU_W	0CCH

    	IRR        	EQU	0CDH       

	PCL			EQU		0CEH
	PCH			EQU		0CFH

	P0			EQU 	0D0H
		FP00	EQU 	P0.0
		FP01	EQU 	P0.1
		FP02	EQU 	P0.2
		FP03	EQU 	P0.3
		FP04	EQU 	P0.4
		FP05	EQU 	P0.5
		FP06	EQU 	P0.6
		FP07	EQU 	P0.7

	P1			EQU 	0D1H
		FP10	EQU 	P1.0
		FP11	EQU 	P1.1
		FP12	EQU 	P1.2
		FP13	EQU 	P1.3
		FP14	EQU 	P1.4
		FP15	EQU 	P1.5
		FP16	EQU 	P1.6
		FP17	EQU 	P1.7

	P5			EQU		0D5H
		FP50	EQU		P5.0
		FP54	EQU		P5.4
		
	T0M			EQU		0D8H
		FT0RATE0   EQU	T0M.4
		FT0RATE1   EQU	T0M.5
		FT0RATE2   EQU	T0M.6
		FT0ENB     EQU	T0M.7

	T0C			EQU		0D9H

	IRM		EQU		0DAH
		FCREN		EQU	IRM.0
		FIREN		EQU	IRM.1

	IRC		EQU		0DBH

	STKP		EQU		0DFH
		FGIE	EQU		STKP.7
		FSTKPB1	EQU		STKP.1
		FSTKPB0	EQU		STKP.0

    P0UR        EQU     0E0H
    P1UR        EQU     0E1H
    P5UR        EQU     0E5H

	@HL			EQU		0E6H
	@YZ			EQU		0E7H

	IRD		EQU		0E8H


	STK3L		EQU		0F8h
	STK3H		EQU		0F9h
	STK2L		EQU		0FAh
	STK2H		EQU		0FBh
	STK1L		EQU		0FCh
	STK1H		EQU		0FDh
	STK0L		EQU		0FEh
	STK0H		EQU		0FFh

; -----------------------------------------------------
; Clear watchdog macro for compatibility in S8KD-2 ICE
;  
; Total Cycle: 2 

	@RST_WDT	macro		
 		   MOV  A, #0x5A
		   B0MOV  WDTR, A
	endm
; -----------------------------------------------------
; Sleep Mode control macro for compatibility in S8KD-2 ICE
;  
; Total Cycle: 1

	SleepMode	macro	
		B0BSET	FCPUM0
	endm
; -----------------------------------------------------
; Green Mode control macro for compatibility in S8KD-2 ICE
;  
; Total Cycle: 3

	GreenMode	macro	
		B0BSET	FCPUM1
		B0BSET	0XFF.7
		NOP
	endm
; -----------------------------------------------------
; Slow Mode control macro for compatibility in S8KD-2 ICE
;  
; Total Cycle: 2

	SlowMode	macro	
		B0BSET	FCLKMD
		B0BSET	FSTPHX
	endm
; -----------------------------------------------------
;  Slow mode to Normal Mode control macro for compatibility in S8KD-2 ICE
;  
; Total Cycle: 5

	Slow2Normal	macro	
		B0BCLR	FSTPHX
		NOP
		NOP
		NOP
		B0BCLR	FCLKMD
	endm
; -----------------------------------------------------	
	
.TEXT
{
	//{{SONIX_OPTION_RULE
        
	ENDP
	//}}SONIX_OPTION_RULE
}
