;*******************************
;HS23P2710
;RAM:96
;ROM:1K
;*******************************************************************************
;  CHIP: SN8P2712
;  Revision History
;  
;  V01   05/03/2010  1. First issue and only for SN8ICE 2K Plus. 
;  V02   06/29/2010  1. modify MACRO text "SLowMode" to "SlowMode"
;  V03   05/11/2011  1. modify Low_Power CodeOption limit : Low_Power enable, Fcpu <= 2MIPS
;  V04   08/28/2013  1. Modify P4CON/P0CON/WDTR register property
;*******************************************************************************
.ASSEMBLY	RedWrt_FORMAT	1
.Assembly	INC_VER		3

.Assembly	ASM_FORMAT	1
.Assembly	RAM_Size	96

.Assembly	INSTRUMENT	SN8P2712
.Assembly	BIT_FILE	SN8P2712

.Assembly	OTP_BODY_SIZE	0x400;0x0800 
.Assembly	USER_ROM_SIZE	0x3FC;0x07FC

.Assembly	OTP_TEST_SIZE	0x00E0
;.Assembly	MASK_TEST_FILE
.Assembly	MASK_TEST_CODE	0x0000, 0x0000, 0x0000, 0x0000
;.Assembly	OTP_TEST_FILE	
.Assembly	PGM_TYPE	6
.Assembly	CHIP_ID		0x6230		
;.Assembly	COMMAND		Enable_ORG4_7
.Assembly	COMMAND		Enable_ORG4_7, GREEN_NOP_LIMIT
.Assembly	Port_Pins	8,0,0,0,8,0
;*******************************************************************************
; Code Option 0x07FF
.Assembly	OPTION		0		Noise_Filter	Disable Enable
.Assembly	OPTION		1		Security	Enable	Disable
.Assembly	OPTION		2		Fcpu		Fosc/1 Fosc/2 Fosc/4 Fosc/8 Fosc/16 Fosc/32 Fosc/64 Fosc/128
.Help
{
	Fcpu		: 	"Only Effective for HIGH Clock"
	Fosc/1		: 	"If Low_Power enable, Fcpu should be\nless than or equal to 2MIPS."
	Fosc/2		: 	"If Low_Power enable, Fcpu should be\nless than or equal to 2MIPS."
	Fosc/4		: 	"If Low_Power enable, Fcpu should be\nless than or equal to 2MIPS."
	Fosc/8		: 	"If Low_Power enable, Fcpu should be\nless than or equal to 2MIPS."
	Fosc/16		: 	"If Low_Power enable, Fcpu should be\nless than or equal to 2MIPS."
	Fosc/32		: 	"If Low_Power enable, Fcpu should be\nless than or equal to 2MIPS."
	Fosc/64		: 	"If Low_Power enable, Fcpu should be\nless than or equal to 2MIPS."
	Fosc/128	: 	"If Low_Power enable, Fcpu should be\nless than or equal to 2MIPS."
}
.Assembly	OPTION		5		High_Clk	IHRC_16M IHRC_RTC x x Ext_RC  32K_X'tal  12M_X'tal  4M_X'tal
.Help
{	
	IHRC_16M	:	"Internal 16M RC Oscillator"
	IHRC_RTC	:	"Internal 16M RC Oscillator with RTC.\n"
	32K_X'tal	:	"32.768K Crystal"
	Ext_RC		:	"Connect R to VDD and Xin\nConnect C to GND and Xin"
	12M_X'tal	:	"Crystal/Resonator: 10Mhz~16Mhz"
	4M_X'tal	:	"Crystal/Resonator: 2Mhz~10Mhz"
}
;.Assembly	OPTION		8		Watch_Dog 	Always_On Always_On Always_On Always_On Always_On Enable Always_On Always_On Always_On Always_On Disable Always_On Always_On Always_On Always_On Always_On 
.Assembly	OPTION		8		Watch_Dog	Always_On x x x x Enable x x x x Disable x x x x x
.Help
{
	Always_ON	:	"Watchdog still enable even in\nGreen and Sleep mode"
	Enable		:	"Normal mode: Enable Watchdog\nGreen and Sleep mode: Stop Watchdog"
	Disable         :       "Disable Watchdog"
} 
.Assembly	OPTION		12		Reset_Pin 	P01	Reset
;.Assembly	OPTION   	13		Rst_Len		No	128_ILRC
.Assembly	OPTION		13		Fix_High
;.Assembly	OPTION   	14		LowPower_Optin	Enable	Disable
.Assembly	OPTION		14		Low_Power	Enable Disable
.Help
{
	Enable	:	"If Low_Power enable, Fcpu should be\nless than or equal to 2MIPS."
}
;.Assembly	OPTION   	15		LowPower_Selet	120ns	80ns
.Assembly	OPTION		15		Fix_High
;*******************************************************************************
; Code Option 0x07FE
.Assembly	OPTION		16		Fix_Low
.Assembly	OPTION		17		Fix_High
.Assembly	OPTION		18		Fix_Low
.Assembly	OPTION		19		Fix_High
.Assembly	OPTION		20		Fix_High
.Assembly	OPTION		21		Fix_Low
.Assembly	OPTION		22		Fix_High
.Assembly	OPTION		23		Fix_Low
.Assembly	OPTION		24		Fix_Low
.Assembly	OPTION		25		Fix_High
.Assembly	OPTION		26		Fix_Low
.Assembly	OPTION		27		Fix_High
.Assembly	OPTION		28 : 31		Fix_High
;*******************************************************************************
; Code Option 0x07FD
.Assembly	OPTION		32 : 40		Fix_High
.Assembly	OPTION		41		LVDM     	LVD_Max	LVD_H	LVD_M	LVD_L
.Help
{
	LVD_L		:	"2.0V Reset"
	LVD_M		:	"2.0V Reset\nEnable LVD24 bit of PFLAG for\n2.4V Low Voltage Indicator"
	LVD_H		:	"2.4V Reset\nEnable LVD36 bit of PFLAG for\n3.6V Low Voltage Indicator"	
	LVD_Max		:	"3.6V Reset"	
}
;.Assembly	OPTION		43		LVDB		No 2_ILRC
.Assembly	OPTION		43		Fix_Low
.Assembly	OPTION		44 : 63		Fix_High
;*******************************************************************************
.Assembly	OPTION		2ffh

;*******************************************************************************
;*******************************************************************************
;*******************************************************************************
;*******************************************************************************
;	L		EQU		0x80
;	H		EQU		0x81
;	R		EQU		0x82
;	Z		EQU		0x83
;	Y		EQU		0x84

	L		EQU		080H
	H		EQU		081H
	R		EQU		082H
	Z		EQU		083H
	Y		EQU		084H
;*******************************************************************************
	REG_085H	EQU		085H
;	PFLAG		EQU		0x86
	PFLAG		EQU		086H
		FZ		EQU		PFLAG.0
		FDC		EQU		PFLAG.1
		FC		EQU		PFLAG.2
		FLVD24		EQU_R		PFLAG.4
		FLVD36		EQU_R		PFLAG.5
		FNPD		EQU		PFLAG.6
		FNT0		EQU		PFLAG.7

	REG_087H	EQU		087H	
	
	REG_088H	EQU		088H
	REG_089H	EQU		089H
	REG_08AH	EQU		08AH
	REG_08BH	EQU		08BH
	
	REG_08CH	EQU		08CH
	REG_08DH	EQU		08DH
	REG_08EH	EQU		08EH
	REG_08FH	EQU		08FH
;*******************************************************************************
;*******************************************************************************
;*******************************************************************************
;*******************************************************************************
;	TC2M		EQU		0xA0
	TC2M		EQU		0A0H
		FTC2ENB		EQU		TC2M.7
		FTC2RATE2	EQU		TC2M.6
		FTC2RATE1	EQU		TC2M.5
		FTC2RATE0	EQU		TC2M.4
		FTC2CKS		EQU		TC2M.3
       		FALOAD2    	EQU		TC2M.2
       		FTC2OUT   	EQU		TC2M.1
       		FPWM2OUT   	EQU		TC2M.0

;	TC2C		EQU		0xA1
	TC2C		EQU		0A1H
;	TC2R		EQU_W		0xA2
	TC2R		EQU		0A2H
;*******************************************************************************
;	TC3M		EQU		0xA3
	TC3M		EQU		0A3H
		FTC3ENB		EQU		TC3M.7
		FTC3RATE2	EQU		TC3M.6
		FTC3RATE1	EQU		TC3M.5
		FTC3RATE0	EQU		TC3M.4
		FTC3CKS		EQU		TC3M.3
       		FALOAD3    	EQU		TC3M.2
       		FTC3OUT   	EQU		TC3M.1
       		FPWM3OUT   	EQU		TC3M.0

;	TC3C		EQU		0xA4
	TC3C		EQU		0A4H
;	TC3R		EQU_W		0xA5
	TC3R		EQU		0A5H
	
	REG_0A6H	EQU		0A6H
	REG_0A7H	EQU		0A7H
	
	REG_0A8H	EQU		0A8H
	REG_0A9H	EQU		0A9H
	REG_0AAH	EQU		0AAH
	REG_0ABH	EQU		0ABH
	
	REG_0ACH	EQU		0ACH
	REG_0ADH	EQU		0ADH
	
;	P4CON		EQU_W		0xAE
	P4CON		EQU		0AEH
;	P0CON		EQU_W		0xAF
	P0CON		EQU		0AFH

;*******************************************************************************V
;*******************************************************************************
;*******************************************************************************
;*******************************************************************************
;	VREFH 		EQU		0xB0
	VREFH 		EQU		0B0H
		FVHS0		EQU		VREFH.0
		FVHS1		EQU		VREFH.1
		FEVHENB		EQU		VREFH.7

;	ADM 		EQU		0xB1
	ADM 		EQU		0B1H
		FCHS0		EQU		ADM.0
		FCHS1		EQU		ADM.1
		FCHS2		EQU		ADM.2
		FCHS3		EQU		ADM.3
		FGCHS		EQU		ADM.4
		FEOC		EQU		ADM.5
		FADS		EQU		ADM.6
		FADENB		EQU		ADM.7

;	ADB 		EQU_R		0xB2
	ADB 		EQU		0B2H

;	ADR 		EQU		0xB3
	ADR 		EQU		0B3H
		FADB0		EQU_R		ADR.0
		FADB1		EQU_R		ADR.1
		FADB2		EQU_R		ADR.2
		FADB3		EQU_R		ADR.3
		FADCKS0		EQU		ADR.4
		FADLEN		EQU		ADR.5
		FADCKS1		EQU		ADR.6
;	ADT 		EQU		0xB4
	ADT 		EQU		0B4H
		FADT0		EQU		ADT.0
		FADT1		EQU		ADT.1
		FADT2		EQU		ADT.2
		FADT3		EQU		ADT.3
		FADT4		EQU		ADT.4
		FADTS0		EQU		ADT.6
		FADTS1		EQU		ADT.7
;*******************************************************************************
	REG_0B5h 		EQU		0B5H
	REG_0B6h 		EQU		0B6H
	REG_0B7h 		EQU		0B7H
;*******************************************************************************
	
;	P0M		EQU		0xB8
	P0M		EQU		0B8H
		FP00M		EQU		P0M.0
		FP02M		EQU		P0M.2
		FP03M		EQU		P0M.3
		FP04M		EQU		P0M.4
		FP05M		EQU		P0M.5
		FP06M		EQU		P0M.6
		FP07M		EQU		P0M.7
		
;*******************************************************************************
	REG_0B9h 		EQU		0B9H
	REG_0BAh 		EQU		0BAH
	REG_0BBh 		EQU		0BBH
	
	REG_0BCh 		EQU		0BCH
	REG_0BDh 		EQU		0BDH
	REG_0BEh 		EQU		0BEH
;*******************************************************************************
;	PEDGE		EQU		0xBF
	PEDGE		EQU		0BFH
		FP00G0		EQU		PEDGE.3
		FP00G1		EQU		PEDGE.4
;*******************************************************************************
;*******************************************************************************
;*******************************************************************************
;*******************************************************************************
	REG_0C0h		EQU		0C0H
	REG_0C1h		EQU		0C1H
	REG_0C2h		EQU		0C2H
	REG_0C3h		EQU		0C3H
;	P4M		EQU		0xC4
	P4M		EQU		0C4H
		FP47M		EQU		P4M.7
		FP46M		EQU		P4M.6
		FP45M		EQU		P4M.5
		FP44M		EQU		P4M.4
		FP43M		EQU		P4M.3
		FP42M		EQU		P4M.2
		FP41M		EQU		P4M.1
		FP40M		EQU		P4M.0
;*******************************************************************************
	REG_0C5h		EQU		0C5H
	REG_0C6h		EQU		0C6H
	REG_0C7h		EQU		0C7H

;	INTRQ		EQU		0xC8
	INTRQ		EQU		0C8H
		FADCIRQ		EQU		INTRQ.7
		FTC0IRQ		EQU		INTRQ.5
    		FT0IRQ  	EQU 		INTRQ.4
		FP00IRQ		EQU		INTRQ.0
;*******************************************************************************
;	INTEN		EQU		0xC9
	INTEN		EQU		0C9H
		FADCIEN		EQU		INTEN.7
		FTC0IEN		EQU		INTEN.5
		FT0IEN		EQU 		INTEN.4
		FP00IEN		EQU		INTEN.0
;*******************************************************************************
;	OSCM		EQU		0xCA
	OSCM		EQU		0CAH
		FCPUM1		EQU		OSCM.4
		FCPUM0		EQU		OSCM.3
		FCLKMD		EQU		OSCM.2
		FSTPHX		EQU		OSCM.1
;*******************************************************************************
;	WDTR		EQU_W		0xCC
;	TC0R		EQU_W		0xCD
;	PCL		EQU		0xCE
;	PCH		EQU		0xCF
	REG_0CBh	EQU		0CBH

	WDTR		EQU		0CCH
	TC0R		EQU		0CDH
	PCL		EQU		0CEH
	PCH		EQU		0CFH
;*******************************************************************************
;*******************************************************************************
;*******************************************************************************
;*******************************************************************************
;	P0		EQU 		0xD0
	P0		EQU 		0D0H
		FP00		EQU 		P0.0
		FP01		EQU 		P0.1
		FP02		EQU 		P0.2
		FP03		EQU 		P0.3
		FP04		EQU 		P0.4
		FP05		EQU 		P0.5
		FP06		EQU 		P0.6
		FP07		EQU 		P0.7
;*******************************************************************************

	REG_0D1h		EQU 		0D1H
	REG_0D2h		EQU 		0D2H
	REG_0D3h		EQU 		0D3H

;	P4		EQU		0xD4
	P4		EQU		0D4H
		FP47		EQU		P4.7
		FP46		EQU		P4.6
		FP45		EQU		P4.5
		FP44		EQU		P4.4
		FP43		EQU		P4.3
		FP42		EQU		P4.2
		FP41		EQU		P4.1
		FP40		EQU		P4.0
;*******************************************************************************
	REG_0D5h		EQU 		0D5H
	REG_0D6h		EQU 		0D6H
	REG_0D7h		EQU 		0D7H
	
;	T0M		EQU		0xD8
	T0M		EQU		0D8H
		FT0ENB	 	EQU   		T0M.7
		FT0RATE2 	EQU  	 	T0M.6
		FT0RATE1 	EQU  	 	T0M.5
		FT0RATE0 	EQU  	 	T0M.4
		FTC0CKS1 	EQU  	 	T0M.1
		FT0TB	 	EQU  	 	T0M.0
;*******************************************************************************
;   	T0C		EQU		0xD9
   	T0C		EQU		0D9H
;*******************************************************************************
;	TC0M		EQU		0xDA
	TC0M		EQU		0DAH
		FTC0ENB		EQU		TC0M.7
		FTC0RATE2	EQU		TC0M.6
		FTC0RATE1	EQU		TC0M.5
		FTC0RATE0	EQU		TC0M.4
		FTC0CKS		EQU		TC0M.3
       		FALOAD0    	EQU		TC0M.2
       		FTC0OUT   	EQU		TC0M.1
       		FPWM0OUT   	EQU		TC0M.0
;*******************************************************************************
;	TC0C		EQU		0xDB
	TC0C		EQU		0DBH
;*******************************************************************************
;	TC1M		EQU		0xDC
	TC1M		EQU		0DCH
		FTC1ENB		EQU		TC1M.7
		FTC1RATE2	EQU		TC1M.6
		FTC1RATE1	EQU		TC1M.5
		FTC1RATE0	EQU		TC1M.4
		FTC1CKS		EQU		TC1M.3
		FALOAD1    	EQU		TC1M.2
       		FTC1OUT   	EQU		TC1M.1
       		FPWM1OUT   	EQU		TC1M.0
;*******************************************************************************
;	TC1C		EQU		0xDD
;	TC1R		EQU_W		0xDE

	TC1C		EQU		0DDH
	TC1R		EQU		0DEH
;*******************************************************************************
;	STKP		EQU		0xDF
	STKP		EQU		0DFH
		FGIE		EQU		STKP.7
		FSTKPB2		EQU		STKP.2
		FSTKPB1		EQU		STKP.1
		FSTKPB0		EQU		STKP.0
;*******************************************************************************

    	REG_0E0h		EQU  		0E0H
    	REG_0E1h		EQU  		0E1H
    	REG_0E2h		EQU  		0E2H
    	REG_0E3h		EQU  		0E3H
    	
    	P4UR		EQU  		0E4H	;
    	REG_0E5h		EQU  		0E5H
	@HL		EQU		0E6H	;
	@YZ		EQU		0E7H	;
    	
    	REG_0E8h		EQU  		0E8H
    	REG_0E9h		EQU  		0E9H
    	REG_0EAh		EQU  		0EAH
    	REG_0EBh		EQU  		0EBH
    	
    	REG_0ECh		EQU  		0ECH
    	REG_0EDh		EQU  		0EDH
    	REG_0EEh		EQU  		0EEH
    	REG_0EFh		EQU  		0EFH
    	

;*******************************************************************************
	STK7L		EQU		0F0H
	STK7H		EQU		0F1H
	STK6L		EQU		0F2H
	STK6H		EQU		0F3H
	
	STK5L		EQU		0F4H
	STK5H		EQU		0F5H
	STK4L		EQU		0F6H
	STK4H		EQU		0F7H
	
	STK3L		EQU		0F8H
	STK3H		EQU		0F9H
	STK2L		EQU		0FAH
	STK2H		EQU		0FBH
	
	STK1L		EQU		0FCH
	STK1H		EQU		0FDH
	STK0L		EQU		0FEH	
	STK0H		EQU		0FFH

;	STK7L		EQU		0xF0
;	STK7H		EQU		0xF1
;	STK6L		EQU		0xF2
;	STK6H		EQU		0xF3
;	STK5L		EQU		0xF4
;	STK5H		EQU		0xF5
;	STK4L		EQU		0xF6
;	STK4H		EQU		0xF7
;	STK3L		EQU		0xF8
;	STK3H		EQU		0xF9
;	STK2L		EQU		0xFA
;	STK2H		EQU		0xFB
;	STK1L		EQU		0xFC
;	STK1H		EQU		0xFD
;	STK0L		EQU		0xFE
;	STK0H		EQU		0xFF
;*******************************************************************************
; Clear watchdog macro for compatibility in S8KD-2 ICE
;  
; Total Cycle: 2 

	@RST_WDT	macro		
		MOV	A, #0x5A
		B0MOV	WDTR, A
	endm
;*******************************************************************************
; Sleep Mode control macro for compatibility in S8KD-2 ICE
;  
; Total Cycle: 1

	SleepMode	macro	
		B0BSET	FCPUM0
	endm
;*******************************************************************************
; Green Mode control macro for compatibility in S8KD-2 ICE
;  
; Total Cycle: 3

	GreenMode	macro	
		B0BSET	FCPUM1
		NOP
		NOP
	endm
;*******************************************************************************
; Slow Mode control macro for compatibility in S8KD-2 ICE
;  
; Total Cycle: 2

	SlowMode	macro	
		B0BSET	FCLKMD
		B0BSET	FSTPHX
	endm
;*******************************************************************************
;  Slow mode to Normal Mode control macro for compatibility in S8KD-2 ICE
;  
; Total Cycle: 5

	Slow2Normal	macro	
		B0BCLR	FSTPHX
		NOP
		NOP
		NOP
		B0BCLR	FCLKMD
	endm
;*******************************************************************************
.TEXT
{
	//{{SONIX_OPTION_RULE
	IF Low_Power == Enable
	{
		IF High_Clk == IHRC_16M
		{
		OPTION		2		Fcpu		x x x Fosc/8 Fosc/16 Fosc/32 Fosc/64 Fosc/128  
		}
		ELSEIF High_Clk == IHRC_RTC
		{
		OPTION		2		Fcpu		x x x Fosc/8 Fosc/16 Fosc/32 Fosc/64 Fosc/128
		}
		ELSE
		{
			IF Noise_Filter == Enable
			{
				OPTION		2		Fcpu		x x Fosc/4 Fosc/8 Fosc/16 Fosc/32 Fosc/64 Fosc/128
  			}
			ELSE	
			{
				OPTION		2		Fcpu		Fosc/1 Fosc/2 Fosc/4 Fosc/8 Fosc/16 Fosc/32 Fosc/64 Fosc/128
  			}      
		}
  	}
	ELSE	
	{
		IF Noise_Filter == Enable
		{
			OPTION		2		Fcpu		x x Fosc/4 Fosc/8 Fosc/16 Fosc/32 Fosc/64 Fosc/128
  		}
		ELSE	
		{
			OPTION		2		Fcpu		Fosc/1 Fosc/2 Fosc/4 Fosc/8 Fosc/16 Fosc/32 Fosc/64 Fosc/128
  		}      
  	}
	ENDP
	//}}SONIX_OPTION_RULE
}