;------------------------------------------------------------------------------
;  CHIP: SN8P2623
;  Revision History
;  
;  V01   09/06/2013  1. First issue and only for SN8ICE 2K Plus 2.
;
;------------------------------------------------------------------------------
.Assembly	INC_VER		1
.ASSEMBLY	RedWrt_FORMAT	1
.Assembly	ASM_FORMAT	1
.Assembly	RAM_Size	64

.Assembly	INSTRUMENT	SN8P2623
.Assembly	BIT_FILE	SN8P2623

.Assembly	OTP_BODY_SIZE	0x0810
.Assembly	USER_ROM_SIZE	0x0800

;.Assembly	OTP_TEST_SIZE	0x00A0
;.Assembly	MASK_TEST_FILE	SN8A1602A
.Assembly	MASK_TEST_CODE	0x0000, 0x0000, 0x0000, 0x0000
;.Assembly	OTP_TEST_FILE	SN86P
.Assembly	PGM_TYPE	15
.Assembly	CHIP_ID		0x3270
.Assembly	command		Enable_ORG4_7, NEW_CODEOPTION
.Assembly	Port_Pins	3, 7, 0, 0, 0, 8

; Code Option 0x080F
.Assembly	OPTION		0		Noise_Filter	Disable Enable
.Help
{
	Enable		:	"IHRC_16M or IHRC_RTC, Noise filter\ncode option must be disable."
}
.Assembly	OPTION		1		Security	Enable	Disable
.Assembly	OPTION		2		Fcpu		Fosc/1 Fosc/2 Fosc/4 Fosc/8 Fosc/16 Fosc/32 Fosc/64 Fosc/128
.Help
{
	Fcpu		: 	"Only Effective for HIGH Clock"
	Fosc/1		: 	"If Low_Power enable, Fcpu should be\nless than or equal to 1MIPS."
	Fosc/2		: 	"If Low_Power enable, Fcpu should be\nless than or equal to 1MIPS."
	Fosc/4		: 	"If Low_Power enable, Fcpu should be\nless than or equal to 1MIPS."
	Fosc/8		: 	"If Low_Power enable, Fcpu should be\nless than or equal to 1MIPS."
	Fosc/16		: 	"If Low_Power enable, Fcpu should be\nless than or equal to 1MIPS."
	Fosc/32		: 	"If Low_Power enable, Fcpu should be\nless than or equal to 1MIPS."
	Fosc/64		: 	"If Low_Power enable, Fcpu should be\nless than or equal to 1MIPS."
	Fosc/128	: 	"If Low_Power enable, Fcpu should be\nless than or equal to 1MIPS."
}
;.Assembly	OPTION		5		High_Clk	Ext_RC 32K_X'tal 16M_X'tal 4M_X'tal IHRC_16M IHRC_RTC IHRC_16M IHRC_16M
.Assembly	OPTION		5		High_Clk	Ext_RC 32K_X'tal 16M_X'tal 4M_X'tal x IHRC_RTC x IHRC_16M
.Help
{	
	IHRC_16M	:	"Internal 16M RC Oscillator.\nIn high noisy environment, Fcpu should be\nless than or equal to 4MIPS."
	IHRC_RTC	:	"Internal 16M RC Oscillator with RTC.\nConnect 32.768K crystal to Xin/Xout.\nIn high noisy environment, Fcpu should be\nless than or equal to 4MIPS."
	Ext_RC		:	"Connect R to VDD and Xin\nConnect C to GND and Xin"
	32K_X'tal	:	"32.768K Crystal"
	16M_X'tal	:	"Crystal/Resonator: 10Mhz~16Mhz"
	4M_X'tal	:	"Crystal/Resonator: 2Mhz~10Mhz"
}
;.Assembly	OPTION		8		Watch_Dog 	Always_On Always_On Always_On Always_On Always_On Enable Always_On Always_On Always_On Always_On Disable Always_On Always_On Always_On Always_On Always_On 
.Assembly	OPTION		8		Watch_Dog 	Always_On x x x x Enable x x x x Disable x x x x x 
.Help
{
	Always_ON	:	"Watchdog still enable even in\nGreen and Sleep mode"
	Enable		:	"Normal mode: Enable Watchdog\nGreen and Sleep mode: Stop Watchdog"
	Disable         :       "Disable Watchdog"
} 
.Assembly	OPTION		12		Reset_Pin 	P15	Reset
;.Assembly	OPTION   	13		Rst_Len		No	128_ILRC
.Assembly	OPTION   	13		Fix_High
;.Assembly	OPTION   	14		Fix_High
;.Assembly	OPTION   	15		Fix_High

.Assembly	OPTION   	14		Low_Power	Enable	Disable
.Help
{
	Enable	:	"If Low_Power enable, Fcpu should be\nless than or equal to 1MIPS."
}
;.Assembly	OPTION   	15		LowPower_EnableTime	160ns	120ns
.Assembly	OPTION		15		Fix_Low
; Code Option 0x080E
.Assembly	OPTION		16		Fix_Low
.Assembly	OPTION		17		Fix_High
.Assembly	OPTION		18		Fix_Low
.Assembly	OPTION		19		Fix_High
.Assembly	OPTION		20		Fix_High
.Assembly	OPTION		21		Fix_Low
.Assembly	OPTION		22		Fix_High
.Assembly	OPTION		23		Fix_Low
.Assembly	OPTION		24		Fix_Low
.Assembly	OPTION		25		Fix_High
.Assembly	OPTION		26		Fix_Low
.Assembly	OPTION		27		Fix_High
.Assembly	OPTION		28 : 31		Fix_High

; Code Option 0x080D
.Assembly	OPTION		32 : 40		Fix_High
;.Assembly	OPTION		41		LVD     	LVD_Max LVD_H LVD_M LVD_L
.Assembly	OPTION		41		LVD     	x LVD_H LVD_M LVD_L
.Help
{
	LVD_L		:	"2.0V Reset"
	LVD_M		:	"2.0V Reset\nEnable LVD24 bit of PFLAG for\n2.4V Low Voltage Indicator"
	LVD_H		:	"2.4V Reset\nEnable LVD36 bit of PFLAG for\n3.6V Low Voltage Indicator"	
;	LVD_Max		:	"3.6V Reset"
}
;.Assembly	OPTION		43	LVDB		No 2_ILRC 4_ILRC 8_ILRC

.Assembly	OPTION		43 : 47		Fix_High

; Code Option 0x080C~0x800
.Assembly	OPTION		48 : 255	Fix_High


.Assembly	OPTION		2ffh

	R		EQU		82H
	Z		EQU		83H
	Y		EQU		84H
	
	PFLAG		EQU		86H
		FZ		EQU		PFLAG.0
		FDC		EQU		PFLAG.1
		FC		EQU		PFLAG.2
		FLVD24		EQU_R		PFLAG.4
		FLVD36		EQU_R		PFLAG.5
		FNPD		EQU		PFLAG.6
		FNT0		EQU		PFLAG.7

	P0M		EQU		0B8H
		FP00M		EQU		P0M.0
		FP01M		EQU		P0M.1
		FP02M		EQU		P0M.2

	PEDGE		EQU		0BFH		
		FP00G0		EQU		PEDGE.0
		FP00G1		EQU		PEDGE.1
		FP01G0		EQU		PEDGE.2
		FP01G1		EQU		PEDGE.3
		FP02G0		EQU		PEDGE.4
		FP02G1		EQU		PEDGE.5

	P1W		EQU_W		0C0H

	P1M		EQU		0C1H
  		FP10M		EQU		P1M.0
  		FP11M		EQU		P1M.1
  		FP12M		EQU		P1M.2
  		FP13M		EQU		P1M.3
  		FP14M		EQU		P1M.4
  		FP15M		EQU		P1M.5
  		FP16M		EQU		P1M.6

	P5M		EQU		0C5H
		FP50M		EQU		P5M.0
		FP51M		EQU		P5M.1
		FP52M		EQU		P5M.2
		FP53M		EQU		P5M.3
		FP54M		EQU		P5M.4
		FP55M		EQU		P5M.5
		FP56M		EQU		P5M.6
		FP57M		EQU		P5M.7

	INTRQ		EQU		0C8H
		FP00IRQ		EQU		INTRQ.0
		FP01IRQ		EQU		INTRQ.1
		FP02IRQ		EQU		INTRQ.2
		FT0IRQ		EQU		INTRQ.4
		FTC0IRQ		EQU		INTRQ.5
		FTC1IRQ		EQU		INTRQ.6

	INTEN		EQU		0C9H
		FP00IEN		EQU		INTEN.0
		FP01IEN		EQU		INTEN.1
		FP02IEN		EQU		INTEN.2
		FT0IEN		EQU		INTEN.4
		FTC0IEN		EQU		INTEN.5
		FTC1IEN		EQU		INTEN.6

	OSCM		EQU		0CAH
		FCPUM1		EQU		OSCM.4
		FCPUM0		EQU		OSCM.3
		FCLKMD		EQU		OSCM.2
		FSTPHX		EQU		OSCM.1

	WDTR		EQU_W		0CCH

	TC0R		EQU_W		0CDH

	PCL			EQU		0CEH
	PCH			EQU		0CFH

	P0		EQU	 	0D0H
		FP00		EQU 		P0.0
		FP01		EQU 		P0.1
		FP02		EQU 		P0.2

	P1		EQU		0D1H
		FP10		EQU		P1.0
		FP11		EQU		P1.1
		FP12		EQU		P1.2
		FP13		EQU		P1.3
		FP14		EQU		P1.4
		FP15		EQU		P1.5
		FP16		EQU		P1.6
		
	P5		EQU		0D5H
		FP50		EQU		P5.0
		FP51		EQU		P5.1
		FP52		EQU		P5.2
		FP53		EQU		P5.3
		FP54		EQU		P5.4
		FP55		EQU		P5.5
		FP56		EQU		P5.6		
		FP57		EQU		P5.7

	P5DR		EQU_W		0D6H

	T0M		EQU		0D8H
		FT0TB		EQU  	  	T0M.0
		FT0RATE0 	EQU  	  	T0M.4
		FT0RATE1 	EQU  	  	T0M.5
		FT0RATE2 	EQU  	  	T0M.6
		FT0ENB	 	EQU  	 	T0M.7

	T0C		EQU		0D9H

	TC0M		EQU		0DAH
	       	FPWM0OUT   	EQU		TC0M.0 
       		FTC0PO    	EQU		TC0M.1
		FTC0CKS		EQU		TC0M.3
		FTC0RATE0	EQU		TC0M.4
		FTC0RATE1	EQU		TC0M.5
		FTC0RATE2	EQU		TC0M.6
		FTC0ENB		EQU		TC0M.7

	TC0C		EQU		0DBH

	TC1M		EQU		0DCH
	       	FPWM1OUT   	EQU		TC1M.0
     		FTC1RATE0	EQU		TC1M.4
		FTC1RATE1	EQU		TC1M.5
		FTC1RATE2	EQU		TC1M.6
		FTC1ENB		EQU		TC1M.7

	TC1C		EQU		0DDH

	TC1R		EQU_W		0DEH

	STKP		EQU		0DFH
		FSTKPB0		EQU		STKP.0
		FSTKPB1		EQU		STKP.1
		FGIE		EQU		STKP.7

	P0UR		EQU_W		0E0H
	P1UR		EQU_W		0E1H
	P5UR		EQU_W		0E5H

	PWMM		EQU		0E6H
		FPWES0		EQU		PWMM.0
		FPWES1		EQU		PWMM.1
		FPWCH0		EQU		PWMM.2
		FPWCH1		EQU		PWMM.3
		FPWCH2		EQU		PWMM.4

	@YZ		EQU		0E7H

	TC0D		EQU		0E8H

	TC1D		EQU		0E9H

	STK3L		EQU		0F8h
	STK3H		EQU		0F9h
	STK2L		EQU		0FAh
	STK2H		EQU		0FBh
	STK1L		EQU		0FCh
	STK1H		EQU		0FDh
	STK0L		EQU		0FEh
	STK0H		EQU		0FFh
; -----------------------------------------------------
; Clear watchdog macro for compatibility in S8KD-2 ICE
;  
; Total Cycle: 2 

	@RST_WDT	macro		
 		   MOV  A, #0x5A
		   B0MOV  WDTR, A
	endm
; -----------------------------------------------------
; Sleep Mode control macro for compatibility in S8KD-2 ICE
;  
; Total Cycle: 1
;
;	SleepMode	macro	
;		B0BSET	FCPUM0
;	endm
; -----------------------------------------------------
; Green Mode control macro for compatibility in S8KD-2 ICE
;  
; Total Cycle: 3
;
;	GreenMode	macro	
;		B0BSET	FCPUM1
;		NOP
;		NOP
;	endm
; -----------------------------------------------------
; Slow Mode control macro for compatibility in S8KD-2 ICE
;  
; Total Cycle: 2
;
;	SLowMode	macro	
;		B0BSET	FCLKMD
;		B0BSET	FSTPHX
;	endm
; -----------------------------------------------------
;  Slow mode to Normal Mode control macro for compatibility in S8KD-2 ICE
;  
; Total Cycle: 5
;
;	Slow2Normal	macro	
;		B0BCLR	FSTPHX
;		NOP
;		NOP
;		NOP
;		B0BCLR	FCLKMD
;	endm
; -----------------------------------------------------	
.TEXT
{
	//{{SONIX_OPTION_RULE
	IF High_Clk == IHRC_16M
	{
		OPTION		0		Noise_Filter	Disable x	
		OPTION		2		Fcpu		Fosc/1 Fosc/2 Fosc/4 Fosc/8 Fosc/16 Fosc/32 Fosc/64 Fosc/128  
	}
	ELSEIF High_Clk == IHRC_RTC
	{
		OPTION		0		Noise_Filter	Disable x
		OPTION		2		Fcpu		Fosc/1 Fosc/2 Fosc/4 Fosc/8 Fosc/16 Fosc/32 Fosc/64 Fosc/128
	}
	ELSE
	{
		IF Noise_Filter == Enable
			{
				OPTION		0		Noise_Filter	Disable Enable
				OPTION		2		Fcpu		x x Fosc/4 Fosc/8 Fosc/16 Fosc/32 Fosc/64 Fosc/128
 			}
		ELSE	
			{
				OPTION		0		Noise_Filter	Disable Enable
				OPTION		2		Fcpu		Fosc/1 Fosc/2 Fosc/4 Fosc/8 Fosc/16 Fosc/32 Fosc/64 Fosc/128
			}      
	}
	ENDP
	//}}SONIX_OPTION_RULE
}
; -----------------------------------------------------	
