
;------------------------------------------------------------------------------
;  CHIP: SN8P2604
;  Revision History:
;  V1.0  02/16/2004  First issue
;
;  V2.0  03/11/2004  1. Align the timing of built-in macro between ICE and real chip
;                    2. Force users to define ICE_MODE before compiler, in ICE_MODE = 1
;                       the user's ROM size is 4K+512 words
;                    3. Disable B0XCH A, M and B0MOV M, I (use 1.99K assembler)
;                    4. Add low power code option
;                    5. SMOV Table:
;                       In "87 FF FF 00 00 1F 00 00", change 87 to 88
;                       To Set P0.0 interrupt and wakeup as falling edge trigger after reset
;                       Add "CB 03" to set P6 as I/O pin for P0 output mode emulation;
;                    6. If High_Clk = 32K_X'tal then disable Low power automatically
;
;  V3.0  03/18/2004  1. SMOV table:
;                       a. Disable P0.2 on initial stage
;                          "87 FF FF 00 00 1F 00 00", change 87 to 83
;                       b. Enable P0.2 if Reset_Pin = P02
;                          Add "1000 D0 04 00"
;
;  V4.0  03/23/2004  1. Remove B0MOV M, I and DAA instructions
;                    2. B0XCH A, M, the M can't be 0x80~0xFF
;
;  V20   06/04/2004  1. For S8KE ICE, INC version start from V20
;                       S8KE can emulate all function of SN8P2604
;                       So SMOV table isn't necessary.
;                    2. It's no necessary to define ICE_MODE = 0 or 1
;                    3. Keep following Macro definition for backword compatibility.
;                       @RST_WDT, @P00_MODE, @P01_MODE,
;                       @P00_OUT, @P01_OUT, @P00_EDGE, @PWM1_MAX_DUTY
;                    4. Remove following S8KD-2 emulation register definition:
;                       S8KDP6M(0C6H), FS8KDWTCKS(OSCM.7), FS8KDWDRST(OSCM.6,
;                       FWDRATE(OSCM.5), S8KDP6(0D6H)
;                    5. Define instructions by SN8P2604.BOL, the following commands
;                       PUSH, B0MOV_MI_LIMIT, B0XCH_LIMIT are no more necessary.
;                       But ORG8_Limit can't be defined by BOL table, so keep it.
;                    6. Add EQU_RMW register access attribute
;                       EQU_RMW: this register is R/W, but can't be accessed by
;                       Read then modify write instruction, e.g. ADD M, A
;                    7. Change T0C from EQU to EQU_RMW
;                    8. Add ID code: 0x3401(Version B)
;
;  V21   09/09/2004  1. Remove no necessary NOP in following macro:
;                       @RST_WDT, @PWM1_MAX_DUTY.
;                    2. Use Enable_ORG4_7 command to release ROM address 4~7
;
;  V22   02/23/2005  1. Remove Low_Power code option.
;  V23   12/17/2007  1. "GreenMode","SleepMode","SlowMode","Slow2Normal" macro programs. 
;  V24   04/03/2008  1. Add "RedWrt_FORMAT    1"  	
;  V25   06/29/2010  1. modify MACRO text "SLowMode" to "SlowMode"
;  V26   02/01/2012  1. Delete CHIP_ID Value 0x3400
;------------------------------------------------------------------------------
.ASSEMBLY    RedWrt_FORMAT    1

.Assembly	INC_VER		25
.Assembly	ASM_FORMAT	1
.Assembly	RAM_Size	128

.Assembly	INSTRUMENT	SN8P2604
.Assembly	BIT_FILE	SN8P2604

.Assembly	OTP_BODY_SIZE	0x1000
.Assembly	USER_ROM_SIZE	0x0FFC

;.Assembly	OTP_TEST_SIZE	0x00E0
;.Assembly	MASK_TEST_FILE
.Assembly	MASK_TEST_CODE	0x0000, 0x0000, 0x0000, 0x0000
;.Assembly	OTP_TEST_FILE	
.Assembly	PGM_TYPE	6
;.Assembly	CHIP_ID		0x3400, 0x3401		;0x8300:5-layer change, 0x8301:all-layer change
.Assembly	CHIP_ID		0x3401		;0x8300:5-layer change, 0x8301:all-layer change
.Assembly	COMMAND		ORG8_LIMIT, Enable_ORG4_7, PCL_LIMIT, GREEN_NOP_LIMIT
.Assembly	Port_Pins	3,8,8,0,0,5

; Code Option 0x3FF
.Assembly	OPTION_Hide	0		Noise_Filter0	Disable Enable	
.Assembly	OPTION		1		Security	Enable	Disable
.Assembly	OPTION		2		Fcpu		Fosc/1 Fosc/2 Fosc/4 Fosc/8
.Help
{
	Fcpu		: 	"Only Effective for HIGH Clock"
}
.Assembly	OPTION		4		Fix_High
.Assembly	OPTION		5		High_Clk	RC	32K_X'tal	12M_X'tal	4M_X'tal
.Help
{	
	RC		:	"Connect R to VDD and Xin\nConnect C to GND and Xin"
	32K_X'tal	:	"32.768K Crystal"
	12M_X'tal	:	"Crystal/Resonator: 10Mhz~16Mhz"
	4M_X'tal	:	"Crystal/Resonator: 2Mhz~10Mhz"
}

.Assembly	OPTION		7		Fix_High
.Assembly	OPTION		8		Watch_Dog 	Always_On x x x x Enable x x x x Disable x x x x x 
.Help
{
	Always_ON	:	"Watchdog still enable even in\nGreen and Sleep mode"
	Enable		:	"Normal mode: Enable Watchdog\nGreen and Sleep mode: Stop Watchdog"
	Disable         :       "Disable Watchdog"
} 
.Assembly	OPTION		12		Reset_Pin 	P02	Reset
;.Assembly	OPTION		13		RST_DeBnc	No 128_ILOSC
.Assembly	OPTION		13		Fix_High
;.Assembly	OPTION		14		Low_Power	Enable Disable
.Assembly	OPTION		14		Fix_High   
.Assembly	OPTION_Hide	15		ROM_Chk0		Disable Enable 

; Code Option 0x3FE
.Assembly	OPTION		16		Fix_Low
.Assembly	OPTION		17		Fix_High
.Assembly	OPTION		18		Fix_Low
.Assembly	OPTION		19		Fix_High
.Assembly	OPTION		20		Fix_High
.Assembly	OPTION		21		Fix_Low
.Assembly	OPTION		22		Fix_High
.Assembly	OPTION		23		Fix_Low
.Assembly	OPTION		24		Fix_Low
.Assembly	OPTION		25		Fix_High
.Assembly	OPTION		26		Fix_Low
.Assembly	OPTION		27		Fix_High
.Assembly	OPTION		28 : 31		Fix_High

; Code Option 0x3FD
.Assembly	OPTION		32 : 63	Fix_High

.Assembly	OPTION_VIRTUAL			Noise_Filter	Enable		Disable

.Assembly	OPTION		2ffh

	L			EQU		0x80
	H			EQU		0x81
	R			EQU		0x82
	Z			EQU		0x83
	Y			EQU		0x84
	PFLAG		EQU		0x86
		FZ	EQU		PFLAG.0
		FDC	EQU		PFLAG.1
		FC	EQU		PFLAG.2
		FNPD	EQU		PFLAG.6
		FNT0	EQU		PFLAG.7

	P0M			EQU		0B8H
		FP01M	EQU		P0M.1
		FP00M	EQU		P0M.0


	PEDGE		EQU		0BFH
;		.W_LIMIT        0x80,0x00	;Force bit 7 = high 	
		FP00G1	EQU		PEDGE.4
		FP00G0	EQU		PEDGE.3

	P1W			EQU_W	0C0H
		FP17W	EQU_W	P1W.7
		FP16W	EQU_W	P1W.6
		FP15W	EQU_W	P1W.5
		FP14W	EQU_W	P1W.4
		FP13W	EQU_W	P1W.3
		FP12W	EQU_W	P1W.2
		FP11W	EQU_W	P1W.1
		FP10W	EQU_W	P1W.0

	P1M			EQU		0C1H
		FP17M	EQU		P1M.7
		FP16M	EQU		P1M.6
		FP15M	EQU		P1M.5
		FP14M	EQU		P1M.4
		FP13M	EQU		P1M.3
		FP12M	EQU		P1M.2
		FP11M	EQU		P1M.1
		FP10M	EQU		P1M.0

	P2M			EQU		0C2H
		FP27M	EQU		P2M.7
		FP26M	EQU		P2M.6
		FP25M	EQU		P2M.5
		FP24M	EQU		P2M.4
		FP23M	EQU		P2M.3
		FP22M	EQU		P2M.2
		FP21M	EQU		P2M.1
		FP20M	EQU		P2M.0

	P5M			EQU		0C5H
     	FP54M	EQU		P5M.4
     	FP53M	EQU		P5M.3
     	FP52M	EQU		P5M.2
     	FP51M	EQU		P5M.1
     	FP50M	EQU		P5M.0	

	INTRQ		EQU		0C8H
		FTC1IRQ	EQU		INTRQ.6
        FT0IRQ  EQU 	INTRQ.4
		FP01IRQ	EQU		INTRQ.1
		FP00IRQ	EQU		INTRQ.0

	INTEN		EQU		0C9H
		FTC1IEN	EQU		INTEN.6
        FT0IEN  EQU 	INTEN.4
		FP01IEN	EQU		INTEN.1
		FP00IEN	EQU		INTEN.0

	OSCM		EQU		0CAH
		FCPUM1	EQU		OSCM.4
		FCPUM0	EQU		OSCM.3
		FCLKMD	EQU		OSCM.2
		FSTPHX	EQU		OSCM.1

	WDTR		EQU_W	0CCH

	PCL			EQU		0CEH
	PCH			EQU		0CFH

	P0			EQU 	0D0H
		FP02	EQU 	P0.2
		FP01	EQU 	P0.1
		FP00	EQU 	P0.0

	P1			EQU		0D1H
		FP17	EQU		P1.7
		FP16	EQU		P1.6
		FP15	EQU		P1.5
		FP14	EQU		P1.4
		FP13	EQU		P1.3
		FP12	EQU		P1.2
		FP11	EQU		P1.1
		FP10	EQU		P1.0

	P2			EQU		0D2H
		FP27	EQU		P2.7
		FP26	EQU		P2.6
		FP25	EQU		P2.5
		FP24	EQU		P2.4
		FP23	EQU		P2.3
		FP22	EQU		P2.2
		FP21	EQU		P2.1
		FP20	EQU		P2.0

	P5			EQU		0D5H
		FP54	EQU		P5.4
		FP53	EQU		P5.3
		FP52	EQU		P5.2
		FP51	EQU		P5.1
		FP50	EQU		P5.0

	T0M			EQU		0D8H
		FT0ENB	 EQU		T0M.7
		FT0RATE2 EQU		T0M.6
		FT0RATE1 EQU		T0M.5
		FT0RATE0 EQU		T0M.4

    	T0C         	 EQU_RMW     0D9H
               

	TC1M		EQU		0DCH
		FTC1ENB		EQU	TC1M.7
		FTC1RATE2	EQU	TC1M.6
		FTC1RATE1	EQU	TC1M.5
		FTC1RATE0	EQU	TC1M.4
		FTC1CKS		EQU	TC1M.3
        	FALOAD1     	EQU 	TC1M.2
        	FTC1OUT     	EQU 	TC1M.1
        	FPWM1OUT    	EQU 	TC1M.0 

	TC1C		EQU		0DDH

	TC1R		EQU_W		0DEH

	STKP		EQU		0DFH
		FGIE	EQU		STKP.7
		FSTKPB2	EQU		STKP.2
		FSTKPB1	EQU		STKP.1
		FSTKPB0	EQU		STKP.0

    P0UR        EQU_W   0E0H
	    FP01R   EQU_W   P0UR.1
	    FP00R   EQU_W   P0UR.0

    P1UR        EQU_W   0E1H
	    FP17R   EQU_W   P1UR.7
	    FP16R   EQU_W   P1UR.6
	    FP15R   EQU_W   P1UR.5
	    FP14R   EQU_W   P1UR.4
	    FP13R   EQU_W   P1UR.3
	    FP12R   EQU_W   P1UR.2
	    FP11R   EQU_W   P1UR.1
	    FP10R   EQU_W   P1UR.0

    P2UR        EQU_W   0E2H
	    FP27R   EQU_W   P2UR.7
	    FP26R   EQU_W   P2UR.6
	    FP25R   EQU_W   P2UR.5
	    FP24R   EQU_W   P2UR.4
	    FP23R   EQU_W   P2UR.3
	    FP22R   EQU_W   P2UR.2
	    FP21R   EQU_W   P2UR.1
	    FP20R   EQU_W   P2UR.0

    P5UR        EQU_W   0E5H
	    FP54R   EQU_W   P5UR.4
	    FP53R   EQU_W   P5UR.3
	    FP52R   EQU_W   P5UR.2
	    FP51R   EQU_W   P5UR.1
	    FP50R   EQU_W   P5UR.0

	@HL			EQU		0E6H
	@YZ			EQU		0E7H

    P1OC        EQU_W   0E9H
	    FP11OC  EQU_W   P1OC.1
	    FP10OC  EQU_W   P1OC.0


	STK7L		EQU		0F0h
	STK7H		EQU		0F1h
	STK6L		EQU		0F2h
	STK6H		EQU		0F3h
	STK5L		EQU		0F4h
	STK5H		EQU		0F5h
	STK4L		EQU		0F6h
	STK4H		EQU		0F7h
	STK3L		EQU		0F8h
	STK3H		EQU		0F9h
	STK2L		EQU		0FAh
	STK2H		EQU		0FBh
	STK1L		EQU		0FCh
	STK1H		EQU		0FDh
	STK0L		EQU		0FEh
	STK0H		EQU		0FFh


; -----------------------------------------------------
; Clear watchdog macro for compatibility in S8KD-2 ICE
;  
; Total Cycle: 2 

	@RST_WDT	macro		
 		   MOV  A, #0x5A
		   B0MOV  WDTR, A
	endm
; -----------------------------------------------------
; Sleep Mode control macro for compatibility in S8KD-2 ICE
;  
; Total Cycle: 1

	SleepMode	macro	
		B0BSET	FCPUM0
	endm
; -----------------------------------------------------
; Green Mode control macro for compatibility in S8KD-2 ICE
;  
; Total Cycle: 3

	GreenMode	macro	
		B0BSET	FCPUM1
		NOP
		NOP
	endm
; -----------------------------------------------------
; Slow Mode control macro for compatibility in S8KD-2 ICE
;  
; Total Cycle: 2

	SlowMode	macro	
		B0BSET	FCLKMD
		B0BSET	FSTPHX
	endm
; -----------------------------------------------------
;  Slow mode to Normal Mode control macro for compatibility in S8KD-2 ICE
;  
; Total Cycle: 5

	Slow2Normal	macro	
		B0BCLR	FSTPHX
		NOP
		NOP
		NOP
		B0BCLR	FCLKMD
	endm
; -----------------------------------------------------	
; In S8KD-2 ICE P0 is input only, but SN8P2604 P0.0, P0.1 are I/O pins
; Connect the P6.0 and P0.0 to emulate P0.0 output pin
; Connect the P6.1 and P0.1 to emulate P0.1 output pin
; Use @P00_Mode macro to set P0.0 output mode
;     @P00_Mode 0, Set P0.0 as input pin
;     @P00_Mode 1, Set P0.0 as output pin
;
; Use @P00_Out to set P0.0 output high or low
;     @P00_Out 0, Set P0.0 output low
;     @P00_Out 1, Set P0.0 output high

; Use @P01_Mode macro to set P0.1 output mode
;     @P01_Mode 0, Set P0.1 as input pin
;     @P01_Mode 1, Set P0.1 as output pin
;
; Use @P01_Out to set P0.1 output high or low
;     @P01_Out 0, Set P0.1 output low
;     @P01_Out 1, Set P0.1 output high
;
; P0X_Mode and P0X_Out Total Cycle: 1
; -----------------------------------------------------

	@P00_MODE	macro	val	; val = 0 input mode
					; val = 1 output mode
			
		IFNDEF  val
			ECHO	Error: @P00_MODE macro need one parameter
			ECHO	Syntax: @P00_MODE  Mode
			ECHO	Example:
			ECHO	@P00_MODE 0  Configure P0.0 as input mode
			ECHO	@P00_MODE 1  Configure P0.0 as output mode			
			ERROR
			ECHO
		ENDIF

		IF val == 0		; val = 0 input mode	
		
			   B0BCLR FP00M
			
		ELSEIF val == 1		; val = 1 output mode
			
			    B0BSET FP00M
			
		ELSE
			ECHO	Error: val is invalid parameter of @P00_MODE macro
			ECHO	Syntax: @P00_MODE  Mode
			ECHO	Example:
			ECHO	@P00_MODE 0  Configure P0.0 as input mode
			ECHO	@P00_MODE 1  Configure P0.0 as output mode			
			ERROR
			ECHO				
		ENDIF		
	endm

;------------------------------------------------------------------------------	
	@P00_OUT	macro	val	; val = 0 output low
					; val = 1 output high
		IFNDEF  val
			ECHO	Error: @P00_OUT macro need one parameter
			ECHO	Syntax: @P00_OUT  Level			
			ECHO	Example:
			ECHO	@P00_OUT 0  P0.0 output high
			ECHO	@P00_OUT 1  P0.0 output low
			ERROR
			ECHO
		ENDIF
					
		IF val == 0		; val = 0 P0.0 output low
			
			   B0BCLR FP00
			
		ELSEIF val == 1		; val = 1 P0.0 output high
			
			   B0BSET FP00
			
		ELSE
			ECHO	Error: val is invalid parameter of @P00_OUT macro
			ECHO	Syntax: @P00_OUT    Level
			ECHO	Example:
			ECHO	@P00_OUT 0  P0.0 output high
			ECHO	@P00_OUT 1  P0.0 output low
			ERROR
			ECHO			
		ENDIF
	endm			

; -----------------------------------------------------------------------------	
	@P01_MODE	macro	val	; val = 0 input mode
					; val = 1 output mode		
		IFNDEF  val
			ECHO	Error: @P01_MODE macro need one parameter
			ECHO	Syntax: @P01_MODE  Mode
			ECHO	Example:
			ECHO	@P01_MODE 0  Configure P0.1 as input mode
			ECHO	@P01_MODE 1  Configure P0.1 as output mode			
			ERROR
			ECHO
		ENDIF

		IF val == 0		; val = 0 input mode	
		
			   B0BCLR FP01M
						
		ELSEIF val == 1		; val = 1 output mode
			
			    B0BSET FP01M
			
		ELSE
			ECHO	Error: val is invalid parameter of @P01_MODE macro
			ECHO	Syntax: @P01_MODE  Mode
			ECHO	Example:
			ECHO	@P01_MODE 0  Configure P0.1 as input mode
			ECHO	@P01_MODE 1  Configure P0.1 as output mode			
			ERROR
			ECHO				
		ENDIF
	endm
;------------------------------------------------------------------------------
	@P01_OUT	macro	val	; val = 0 output low
					; val = 1 output high
		IFNDEF  val
			ECHO	Error: @P01_OUT macro need one parameter
			ECHO	Syntax: @P01_OUT    Level
			ECHO	Example:
			ECHO	@P01_OUT 0  P0.1 output high
			ECHO	@P01_OUT 1  P0.1 output low
			ERROR
			ECHO
		ENDIF
					
		IF val == 0		; val = 0 output low
			
			   B0BCLR FP01
			
		ELSEIF val == 1		; val = 1 output high
			
			   B0BSET FP01
			
		ELSE
			ECHO	Error: val is invalid parameter of @P01_OUT macro
			ECHO	Syntax: @P01_OUT    Level
			ECHO	Example:
			ECHO	@P01_OUT 0  P0.1 output high
			ECHO	@P01_OUT 1  P0.1 output low
			ERROR
			ECHO			
		ENDIF
	endm			
	
; -----------------------------------------------------------------------------
; @PWM1_MAX_DUTY Macro to emulate 2708 Fast PWM1 in S8KD-2 ICE
; Total Cycle = 6

	@PWM1_MAX_DUTY	macro	Max_Duty
				
		;Max_Duty	TC1 Overflow Boundary	PWM Duty Range
		;	256	FFh to 00h		0/256 ~ 255/256
		;	64	3Fh to 40h		0/64 ~ 63/64
		;	32	1Fh to 20h		0/32 ~ 31/32
		;	16	0Fh to 10h		0/16 ~ 15/16
		
		IFNDEF  Max_Duty
			ECHO	Error: @PWM1_MAX_DUTY MACRO need Max-Duty parameter
			ECHO	Syntax: @PWM1_MAX_DUTY  Max-Duty
			ECHO	<Max-Duty = 256 Duty from 0/256 to 255/256>
			ECHO	<Max-Duty =  64  Duty from 0/64  to  63/64>
			ECHO	<Max-Duty =  32  Duty from 0/32  to  31/32>			
			ECHO	<Max-Duty =  16  Duty from 0/16  to  15/16>
			ECHO    Example:
			ECHO	@PWM1_MAX_DUTY 256   Configure maximum duty cycle as 256
			ERROR
			ECHO
		ENDIF		
		
		Duty_Temp = Max_Duty
		IF	Duty_Temp == 256			
			
				;Set real chip PWM0 output
				B0BCLR	FALOAD1
				B0BCLR	FTC1OUT
				B0BSET	FPWM1OUT	
				
			
		ELSEIF	Duty_Temp == 64
			
				;Set real chip PWM0 output
				B0BCLR	FALOAD1
				B0BSET	FTC1OUT
				B0BSET	FPWM1OUT
				
			
		ELSEIF	Duty_Temp == 32
			
				;Set real chip PWM0 output
				B0BSET	FALOAD1
				B0BCLR	FTC1OUT
				B0BSET	FPWM1OUT
				
		ELSEIF	Duty_Temp == 16
			
				;Set real chip PWM0 output
				B0BSET	FALOAD1
				B0BSET	FTC1OUT
				B0BSET	FPWM1OUT
				
						
		ELSE
			ECHO	Error: Max_Duty is invalid Max-Duty parameter of @PWM1_MAX_DUTY MACRO
			ECHO	Syntax: @PWM1_MAX_DUTY  Max-Duty
			ECHO	<Max-Duty = 256 Duty from 0/256 to 255/256>
			ECHO	<Max-Duty =  64  Duty from 0/64  to  63/64>
			ECHO	<Max-Duty =  32  Duty from 0/32  to  31/32>			
			ECHO	<Max-Duty =  16  Duty from 0/16  to  15/16>
			ECHO    Example:
			ECHO	@PWM1_MAX_DUTY 256   Configure maximum duty cycle as 256
			ERROR
			ECHO		
		ENDIF
				
	ENDM
; -----------------------------------------------------	
; Set P0.0 interrupt edge MACRO
; The Falling and rising edge definition of SN8P2XXX are different to S8KD-2 ICE
; @P00_EDGE VAL
;           VAL = 1,  Rising edge  
;           VAL = 2,  Falling edge
;           VAL = 3,  Level Change (Bi-direction)
;
; Total Cycle = 2

	@P00_EDGE	MACRO       VAL
				
		
		IFNDEF  VAL
			ECHO	Error: @P00_EDGE macro need one parameter
			ECHO	Syntax: @P00_EDGE  EDGE
			ECHO	<EDGE = 1, Rising edge trigger for P0.0 interrupt>
			ECHO 	<EDGE = 2, Falling edge trigger for P0.0 interrupt>
			ECHO 	<EDGE = 3, Level change(Bi-direction) trigger for P0.0 interrupt>
			ECHO    Example:
			ECHO	@P00_EDGE 2   Configure P0.0 interrupt as falling edge trigger
			ERROR
			ECHO
		ENDIF		
	
			IF VAL == 1
			   MOV		A,#00001000B
			   B0MOV	PEDGE,A
			ELSEIF VAL == 2
			   MOV		A,#00010000B
			   B0MOV	PEDGE,A
			ELSEIF VAL == 3
			   MOV		A,#00011000B
			   B0MOV	PEDGE,A
		        ELSE
		           ECHO	Error: VAL is invalid parameter of @P00_EDGE macro
			   ECHO	Syntax: @P00_EDGE  EDGE
			   ECHO	<EDGE = 1, Rising edge trigger for P0.0 interrupt>
			   ECHO	<EDGE = 2, Falling edge trigger for P0.0 interrupt>
			   ECHO	<EDGE = 3, Level change(Bi-direction) trigger for P0.0 interrupt>
			   ECHO	Example:
			   ECHO	@P00_EDGE 2   Configure P0.0 interrupt as falling edge trigger
			   ERROR
			   ECHO		        
		        ENDIF			

				
	ENDM
; -----------------------------------------------------	

.TEXT
{
	//{{SONIX_OPTION_RULE

	IF Noise_Filter == Enable
	{
			Noise_Filter0 = Enable		
			ROM_Chk0 = Enable		
			OPTION    2 	Fcpu		X X Fosc/4 Fosc/8
	}
	
	IF Noise_Filter == Disable
	{
		Noise_Filter0 = Disable
		ROM_Chk0 = Disable
			OPTION    2 	Fcpu		Fosc/1 Fosc/2 Fosc/4 Fosc/8
  	}
  	   
	ENDP
	//}}SONIX_OPTION_RULE
}
