
;------------------------------------------------------------------------------
;  CHIP: SN8P2501A
;  Revision History
;  
;  V6.0  01/29/2004
;                    1. Change chip name from SN8P2501 to SN8P2501A
;                    2. Use virtual option to control watchdog code option
;                    3. Add code option on-line help
;
;  V2.0  02/03/2004  1. Change P1OC and PnUR register as write only
;
;  V3.0  02/05/2004  1. SMOV Table:
;                       In "87 00 DF 7F BF 80 CB 03 -1", change 80 to 88
;                       To Set P0.0 interrupt and wakeup as falling edge trigger after reset
;                    2. If High_Clk = 32K_X'tal then disable Low power automatically
;
;  V4.0  03/11/2004  1. Align the timing of built-in macro between ICE and real chip
;                    2. Force users to define ICE_MODE before compiler, in ICE_MODE = 1
;                       the user's ROM size is 1K+ 256 words
;                    3. Disable B0XCH A, M and B0MOV M, I (use 1.99K assembler)
;                    4. SMOV table:
;                       In "87 00...", add CA 80 to set WDT clock as internal RC
;
;  V5.0  03/18/2004  1. SMOV table:
;                       a. Disable P1.1, P1.2  and P1.3 on initial stage
;                          "81 0F 3f 00 00 10 01 00", change 0F to 01
;                       b. Enable P1.2, P1.3 if High_Clk = IHRC_16M or IHRC_RTC
;                          Enable P1.2 if High_Clk = Ext_RC
;                          Add "00E0 D1 0C 0C 00 00 08 00 00 00"
;                       c. Enable P1.1 if Reset_Pin = P11
;                          Add "1000 D1 02 00"
;
;  V6.0  03/23/2004  1. Remove B0MOV M, I and DAA instructions
;                    2. B0XCH A, M, the M can't be 0x80~0xFF
;
;  V7.0  04/09/2004  1. Replace NO_B0MOV_MI bt B0MOV_MI_LIMIT
;                       to limint the instance value of I can't be 0xE6, 0xE7
;                    2. Change P1W, WDTR, TC0R to Write Only register
;                    3. SMOV table:
;                       In "0F -1 -1...", change 0F to 00: Change P1W to write only
;
;  V20   06/04/2004  1. For S8KE ICE, INC version start from V20
;                       S8KE can emulate all function of SN8P2501A
;                       So SMOV table isn't necessary.
;                    2. It's no necessary to define ICE_MODE = 0 or 1
;                    3. Keep following Macro definition for backword compatibility.
;                       @RST_WDT, @P00_MODE, @P00_OUT, @P00_EDGE, @PWM0_MAX_DUTY
;                    4. Remove following S8KD-2 emulation register definition:
;                       S8KDP6M(0C6H), FS8KDWTCKS(OSCM.7), FS8KDWDRST(OSCM.6,
;                       FWDRATE(OSCM.5), S8KDP6(0D6H)
;                    5. Define instructions by SN8P2501A.BOL, the following commands
;                       RETLW, B0MOV_MI_LIMIT, B0XCH_LIMIT are no more necessary.
;                       But ORG8_Limit can't be defined by BOL table, so keep it.
;
;  V21   01/06/2005  1. Add Enable_ORG4_7 assembly command
;
;  V22   04/01/2005  1. Remove Low_Power code option.
;
;  V23   04/01/2005  1. Modify FRTC0, FRTC1 bits of OPTION register from Bit 3,4 to Bit 2,3.
;  V24  12/17/2007  1. "GreenMode","SleepMode","SlowMode","Slow2Normal" macro programs. 
;  V25   04/03/2008  1. Add "RedWrt_FORMAT    1"  	
;  V26   06/29/2010  1. modify MACRO text "SLowMode" to "SlowMode"
;  V27   02/01/2012  1. Delete CHIP_ID Value 0x0500
;------------------------------------------------------------------------------
.ASSEMBLY    RedWrt_FORMAT    1
.Assembly	INC_VER		27
.Assembly	ASM_FORMAT	1
.Assembly	RAM_Size	48

.Assembly	INSTRUMENT	SN8P2501A
.Assembly	BIT_FILE	SN8P2501A

.Assembly	OTP_BODY_SIZE	0x0400
.Assembly	USER_ROM_SIZE	0x03FC

;.Assembly	OTP_TEST_SIZE	0x00A0
;.Assembly	MASK_TEST_FILE	SN8A1602A
.Assembly	MASK_TEST_CODE	0x0000, 0x0000, 0x0000, 0x0000
;.Assembly	OTP_TEST_FILE	SN83P
.Assembly	PGM_TYPE	6
;.Assembly	CHIP_ID		0x0500, 0x3102
.Assembly	CHIP_ID		 0x3102
.Assembly	command		ORG8_LIMIT, PCL_LIMIT, Enable_ORG4_7, STACK_LIMIT, GREEN_NOP_LIMIT
.Assembly	Port_Pins	1, 4, 6,0,0,1
; Code Option 0x3FF
.Assembly	OPTION_Hide	0		Watch_Dog0	Enable	Disable
.Assembly	OPTION		1		Security	Enable	Disable
.Assembly	OPTION		2		Fcpu		Fosc/1 Fosc/2 Fosc/4 Fosc/8 Fosc/16 Fosc/32 Fosc/64 Fosc/128
.Help
{
	Fcpu		: 	"Only Effective for HIGH Clock"
}
.Assembly	OPTION		5		High_Clk	IHRC_16M IHRC_RTC  X  X  Ext_RC  32K_X'tal  12M_X'tal  4M_X'tal
.Help
{
	IHRC_16M	:	"Internal 16M RC Oscillator"
	IHRC_RTC	:	"Internal 16M RC Oscillator with RTC.\n" \
	                        "Connect 32.768K crystal to Xin/Xout"
	Ext_RC		:	"Connect R to VDD and Xin\nConnect C to GND and Xin"
	32K_X'tal	:	"32.768K Crystal"
	12M_X'tal	:	"Crystal/Resonator: 10Mhz~16Mhz"
	4M_X'tal	:	"Crystal/Resonator: 2Mhz~10Mhz"
}
.Assembly	OPTION_Hide	8		Int_16K_RC	Always_ON	By_CPUM
;.Assembly	OPTION		9		Xin/2		Enable	Disable
.Assembly	OPTION		9		Fix_High
;.Assembly	OPTION		10		RST_DeBnc	No	4_ILOSC		16_ILOSC	128_ILOSC
.Assembly	OPTION		10		Fix_High
.Assembly	OPTION		11		Fix_High
.Assembly	OPTION		12		Reset_Pin   P11 	Reset
;.Assembly	OPTION		13		Low_Power   Lowest Lower Middle Disable
;.Assembly	OPTION		13		Low_Power   x Enable x Disable
.Assembly	OPTION		13 : 14	Fix_High
.Assembly	OPTION		15		Fix_High

; Code Option 0x3FE
.Assembly	OPTION		16		Fix_Low
.Assembly	OPTION		17		Fix_High
.Assembly	OPTION		18		Fix_Low
.Assembly	OPTION		19		Fix_High
.Assembly	OPTION		20		Fix_High
.Assembly	OPTION		21		Fix_Low
.Assembly	OPTION		22		Fix_High
.Assembly	OPTION		23		Fix_Low
.Assembly	OPTION		24		Fix_Low
.Assembly	OPTION		25		Fix_High
.Assembly	OPTION		26		Fix_Low
.Assembly	OPTION		27		Fix_High
.Assembly	OPTION		28 : 31		Fix_High

; Code Option 0x3FD
;.Assembly	OPTION		32	IHOSC_CAL	0000 0001 0010 0011	0100 0101 0110 0111	1000 1001 1010 1011	1100 1101 1110 1111
.Assembly	OPTION		32	16M_IHRC	X X X X	-2MHz -1MHz Normal +1MHz +2MHz X X X X X X X
.Assembly	OPTION		36 : 63	Fix_High

.Assembly	OPTION_VIRTUAL			Watch_Dog	Always_ON	Enable	Disable
.Help
{
	Always_ON	:	"Watchdog still enable even in\nGreen and Sleep mode"
	Enable		:	"Normal mode: Enable Watchdog\nGreen and Sleep mode: Stop Watchdog"
	Disable         :       "Disable Watchdog"
}
.Assembly	OPTION_VIRTUAL			Noise_Filter	Enable		Disable

.Assembly	OPTION		2ffh

	R			EQU		0x82
	Z			EQU		0x83
	Y			EQU		0x84
	
	PFLAG			EQU		0x86
		FZ	EQU		PFLAG.0
		FDC	EQU		PFLAG.1
		FC	EQU		PFLAG.2
		FNPD	EQU		PFLAG.6
		FNT0	EQU		PFLAG.7

	OPTION		EQU			0x88
		FRTC0	EQU		0x88.2
		FRTC1	EQU		0x88.3

	P0M			EQU		0B8H
		FP00M	EQU		P0M.0


	PEDGE		EQU		0BFH		
;		.W_LIMIT        0x80,0x00	;Force bit 7 = high (for 2501 real chip)		
		FP00G1	EQU		PEDGE.4
		FP00G0	EQU		PEDGE.3

	P1W			EQU_W		0C0H
		FP13W	EQU_W		P1W.3
		FP12W	EQU_W		P1W.2
		FP11W	EQU_W		P1W.1
		FP10W	EQU_W		P1W.0

	P1M			EQU		0C1H
		FP13M	EQU		P1M.3
		FP12M	EQU		P1M.2
		FP10M	EQU		P1M.0

	P2M			EQU		0C2H
		FP25M	EQU		P2M.5
		FP24M	EQU		P2M.4
		FP23M	EQU		P2M.3
		FP22M	EQU		P2M.2
		FP21M	EQU		P2M.1
		FP20M	EQU		P2M.0
	
	P5M			EQU		0C5H
  		FP54M	EQU		P5M.4
	
	INTRQ		EQU		0C8H
		FTC0IRQ	EQU	INTRQ.5
        FT0IRQ  EQU INTRQ.4
		FP00IRQ	EQU	INTRQ.0

	INTEN		EQU		0C9H
		FTC0IEN	EQU	INTEN.5
        FT0IEN  EQU INTEN.4
		FP00IEN	EQU	INTEN.0

	OSCM		EQU		0CAH
		FCPUM1	EQU	OSCM.4
		FCPUM0	EQU	OSCM.3
		FCLKMD	EQU	OSCM.2
		FSTPHX	EQU	OSCM.1

	WDTR		EQU_W		0CCH
		FWDTR7	EQU_W	WDTR.7
		FWDTR6	EQU_W	WDTR.6
		FWDTR5	EQU_W	WDTR.5
		FWDTR4	EQU_W	WDTR.4
		FWDTR3	EQU_W	WDTR.3
		FWDTR2	EQU_W	WDTR.2
		FWDTR1	EQU_W	WDTR.1
		FWDTR0	EQU_W	WDTR.0

    TC0R        EQU_W     0CDH       

	PCL			EQU		0CEH
	PCH			EQU		0CFH

	P0			EQU 	0D0H
		FP00	EQU 	P0.0

	P1			EQU		0D1H
		FP13	EQU		P1.3
		FP12	EQU		P1.2
		FP11	EQU		P1.1
		FP10	EQU		P1.0

	P2			EQU		0D2H
		FP25	EQU		P2.5
		FP24	EQU		P2.4
		FP23	EQU		P2.3
		FP22	EQU		P2.2
		FP21	EQU		P2.1
		FP20	EQU		P2.0
		
	
	P5			EQU		0D5H
		FP54	EQU		P5.4
		

	T0M			EQU		0D8H
		FT0ENB	 EQU		T0M.7
		FT0RATE2 EQU		T0M.6
		FT0RATE1 EQU		T0M.5
		FT0RATE0 EQU		T0M.4
		FT0TB 	 EQU		T0M.0

    	T0C                     EQU             0D9H
                

	TC0M		EQU		0DAH
		FTC0ENB		EQU	TC0M.7
		FTC0RATE2	EQU	TC0M.6
		FTC0RATE1	EQU	TC0M.5
		FTC0RATE0	EQU	TC0M.4
		FTC0CKS		EQU	TC0M.3
        FALOAD0     EQU TC0M.2
        FTC0OUT     EQU TC0M.1
        FPWM0OUT    EQU TC0M.0 

	TC0C		EQU_RMW		0DBH

	STKP		EQU		0DFH
		FGIE	EQU		STKP.7
		FSTKPB2	EQU		STKP.2
		FSTKPB1	EQU		STKP.1
		FSTKPB0	EQU		STKP.0

    P0UR        EQU_W     0E0H
	    FP00R   EQU_W     P0UR.0

    P1UR        EQU_W     0E1H
	    FP10R   EQU_W     P1UR.0
	    FP12R   EQU_W     P1UR.2
	    FP13R   EQU_W     P1UR.3

    P2UR        EQU_W     0E2H
	    FP25R   EQU_W     P2UR.5
	    FP24R   EQU_W     P2UR.4
	    FP23R   EQU_W     P2UR.3
	    FP22R   EQU_W     P2UR.2
	    FP21R   EQU_W     P2UR.1
	    FP20R   EQU_W     P2UR.0

    P5UR        EQU_W     0E5H
	    FP54R   EQU_W     P5UR.4

    P1OC        EQU_W     0E9H
	    FP10OC  EQU_W   P1OC.0

	@YZ		EQU		0E7H

	STK3L		EQU		0F8h
	STK3H		EQU		0F9h
	STK2L		EQU		0FAh
	STK2H		EQU		0FBh
	STK1L		EQU		0FCh
	STK1H		EQU		0FDh
	STK0L		EQU		0FEh
	STK0H		EQU		0FFh
;; -----------------------------------------------------
; Clear watchdog macro for compatibility in S8KD-2 ICE
;  
; Total Cycle: 2 

	@RST_WDT	macro		
 		   MOV  A, #0x5A
		   B0MOV  WDTR, A
	endm
; -----------------------------------------------------
; Sleep Mode control macro for compatibility in S8KD-2 ICE
;  
; Total Cycle: 1

	SleepMode	macro	
		B0BSET	FCPUM0
	endm
; -----------------------------------------------------
; Green Mode control macro for compatibility in S8KD-2 ICE
;  
; Total Cycle: 3

	GreenMode	macro	
		B0BSET	FCPUM1
		NOP
		NOP
	endm
; -----------------------------------------------------
; Slow Mode control macro for compatibility in S8KD-2 ICE
;  
; Total Cycle: 2

	SlowMode	macro	
		B0BSET	FCLKMD
		B0BSET	FSTPHX
	endm
; -----------------------------------------------------
;  Slow mode to Normal Mode control macro for compatibility in S8KD-2 ICE
;  
; Total Cycle: 5

	Slow2Normal	macro	
		B0BCLR	FSTPHX
		NOP
		NOP
		NOP
		B0BCLR	FCLKMD
	endm
; -----------------------------------------------------	
; In S8KD-2 ICE P0.0 is input only, but SN8P2051 P0.0 is I/O pin
; Connect the P6.0 and P0.0 to emulate P0.0 output pin
; Use @P00_Mode macro to set P0.0 output mode
;     @P00_Mode 0, Set P0.0 as input pin
;     @P00_Mode 1, Set P0.0 as output pin
;
; Use @P00_Out to set P0.0 output high or low
;     @P00_Out 0, Set P0.0 output low
;     @P00_Out 1, Set P0.0 output high
;
; Total Cycle: 1
; -----------------------------------------------------

@P00_MODE	macro	val	; val = 0 input mode
					; val = 1 output mode
		IFNDEF  val
			ECHO	Error: @P00_MODE macro need one parameter
			ECHO	Syntax: @P00_MODE  Mode
			ECHO	Example:
			ECHO	@P00_MODE 0  Configure P0.0 as input mode
			ECHO	@P00_MODE 1  Configure P0.0 as output mode			
			ERROR
			ECHO
		ENDIF

		IF val == 0		; val = 0 input mode	
		
			   B0BCLR FP00M
			
		ELSEIF val == 1		; val = 1 output mode
			
			    B0BSET FP00M
			
		ELSE
			ECHO	Error: val is invalid parameter of @P00_MODE macro
			ECHO	Syntax: @P00_MODE  Mode
			ECHO	Example:
			ECHO	@P00_MODE 0  Configure P0.0 as input mode
			ECHO	@P00_MODE 1  Configure P0.0 as output mode			
			ERROR
			ECHO				
		ENDIF		
	endm
;------------------------------------------------------------------------------	
	@P00_OUT	macro	val	; val = 0 output low
					; val = 1 output high
		IFNDEF  val
			ECHO	Error: @P00_OUT macro need one parameter
			ECHO	Syntax: @P00_OUT  Level			
			ECHO	Example:
			ECHO	@P00_OUT 0  P0.0 output high
			ECHO	@P00_OUT 1  P0.0 output low
			ERROR
			ECHO
		ENDIF
					
		IF val == 0		; val = 0 P0.0 output low
			
			   B0BCLR FP00
			
		ELSEIF val == 1		; val = 1 P0.0 output high
			
			   B0BSET FP00
			
		ELSE
			ECHO	Error: val is invalid parameter of @P00_OUT macro
			ECHO	Syntax: @P00_OUT    Level
			ECHO	Example:
			ECHO	@P00_OUT 0  P0.0 output high
			ECHO	@P00_OUT 1  P0.0 output low
			ERROR
			ECHO			
		ENDIF
	endm

; -----------------------------------------------------------------------------
; @PWM0_MAX_DUTY Macro to emulate 2501 Fast PWM0 in S8KD-2 ICE
; Total Cycle = 6

	@PWM0_MAX_DUTY	macro	Max_Duty
			
	
		;Max_Duty	TC0 Overflow Boundary	PWM Duty Range
		;	256	FFh to 00h		0/256 ~ 255/256
		;	64	3Fh to 40h		0/64 ~ 63/64
		;	32	1Fh to 20h		0/32 ~ 31/32
		;	16	0Fh to 10h		0/16 ~ 15/16
		
		IFNDEF  Max_Duty
			ECHO	Error: @PWM0_MAX_DUTY MACRO need Max-Duty parameter
			ECHO	Syntax: @PWM0_MAX_DUTY  Max-Duty
			ECHO	<Max-Duty = 256 Duty from 0/256 to 255/256>
			ECHO	<Max-Duty =  64  Duty from 0/64  to  63/64>
			ECHO	<Max-Duty =  32  Duty from 0/32  to  31/32>			
			ECHO	<Max-Duty =  16  Duty from 0/16  to  15/16>
			ECHO    Example:
			ECHO	@PWM0_MAX_DUTY 256   Configure maximum duty cycle as 256
			ERROR
			ECHO
		ENDIF		

		Duty_Temp = Max_Duty		
		IF	Duty_Temp == 256			
			
				;Set real chip PWM0 output
				B0BCLR	FALOAD0
				B0BCLR	FTC0OUT
				B0BSET	FPWM0OUT
				; Add 3 NOP to align timing in ICE mode
				NOP
				NOP
				NOP
							
			
		ELSEIF	Duty_Temp == 64
			
				;Set real chip PWM0 output
				B0BCLR	FALOAD0
				B0BSET	FTC0OUT
				B0BSET	FPWM0OUT
				; Add 3 NOP to align timing in ICE mode
				NOP
				NOP
				NOP
			
			
		ELSEIF	Duty_Temp == 32
			
				;Set real chip PWM0 output
				B0BSET	FALOAD0
				B0BCLR	FTC0OUT
				B0BSET	FPWM0OUT
				; Add 3 NOP to align timing in ICE mode
				NOP
				NOP
				NOP
			
			
		ELSEIF	Duty_Temp == 16
			
				;Set real chip PWM0 output
				B0BSET	FALOAD0
				B0BSET	FTC0OUT
				B0BSET	FPWM0OUT
				; Add 3 NOP to align timing in ICE mode
				NOP
				NOP
				NOP
									
		ELSE
			ECHO	Error: Max_Duty is invalid Max-Duty parameter of @PWM0_MAX_DUTY MACRO
			ECHO	Syntax: @PWM0_MAX_DUTY  Max-Duty
			ECHO	<Max-Duty = 256 Duty from 0/256 to 255/256>
			ECHO	<Max-Duty =  64  Duty from 0/64  to  63/64>
			ECHO	<Max-Duty =  32  Duty from 0/32  to  31/32>			
			ECHO	<Max-Duty =  16  Duty from 0/16  to  15/16>
			ECHO    Example:
			ECHO	@PWM0_MAX_DUTY 256   Configure maximum duty cycle as 256
			ERROR
			ECHO			
		ENDIF
			
	ENDM
	
; -----------------------------------------------------------------------------
; Set P0.0 interrupt edge MACRO
; The Falling and rising edge definition of SN8P2XXX are different to S8KD-2 ICE
; @P00_EDGE VAL
;           VAL = 1,  Rising edge  
;           VAL = 2,  Falling edge
;           VAL = 3,  Level Change (Bi-direction)
; Total Cycle = 2

	@P00_EDGE	MACRO       VAL
					
		IFNDEF  VAL
			ECHO	Error: @P00_EDGE macro need one parameter
			ECHO	Syntax: @P00_EDGE  EDGE
			ECHO	<EDGE = 1, Rising edge trigger for P0.0 interrupt>
			ECHO 	<EDGE = 2, Falling edge trigger for P0.0 interrupt>
			ECHO 	<EDGE = 3, Level change(Bi-direction) trigger for P0.0 interrupt>
			ECHO    Example:
			ECHO	@P00_EDGE 2   Configure P0.0 interrupt as falling edge trigger
			ERROR
			ECHO
		ENDIF		
	
			IF VAL == 1
			   MOV		A,#00001000B
			   B0MOV	PEDGE,A
			ELSEIF VAL == 2
			   MOV		A,#00010000B
			   B0MOV	PEDGE,A
			ELSEIF VAL == 3
			   MOV		A,#00011000B
			   B0MOV	PEDGE,A
		        ELSE
		           ECHO	Error: VAL is invalid parameter of @P00_EDGE macro
			   ECHO	Syntax: @P00_EDGE  EDGE
			   ECHO	<EDGE = 1, Rising edge trigger for P0.0 interrupt>
			   ECHO	<EDGE = 2, Falling edge trigger for P0.0 interrupt>
			   ECHO	<EDGE = 3, Level change(Bi-direction) trigger for P0.0 interrupt>
			   ECHO	Example:
			   ECHO	@P00_EDGE 2   Configure P0.0 interrupt as falling edge trigger
			   ERROR
			   ECHO		        
		        ENDIF			

				
	ENDM

; -----------------------------------------------------	


.TEXT
{
	//{{SONIX_OPTION_RULE
		
		
	IF Noise_Filter == Enable
	{
		IF	High_Clk == IHRC_16M
		{	
			OPTION    2 	Fcpu		X X X Fosc/4 Fosc/8 Fosc/16 Fosc/32 Fosc/64
			OPTION	  32	16M_IHRC	X X X X	-2MHz -1MHz Normal +1MHz +2MHz X X X X X X X
        	}
        
	        IF	High_Clk == IHRC_RTC
		{		
			OPTION    2 	Fcpu		X X X Fosc/4 Fosc/8 Fosc/16 Fosc/32 Fosc/64
			
			.Help
			{
				Fosc/4 : "Machine Cycle = System High clock/4"
			}

			
			OPTION	  32	16M_IHRC	X X X X	-2MHz -1MHz Normal +1MHz +2MHz X X X X X X X
        	}	 
	        
		IF	High_Clk == Ext_RC
		{		
			OPTION    2 	Fcpu		X X Fosc/4 Fosc/8 Fosc/16 Fosc/32 Fosc/64 X
			OPTION	  32	16M_IHRC	X X X X	X X Normal X X X X X X X X X
        	}
        
        	IF	High_Clk == 32K_X'tal
		{		
			OPTION    2 	Fcpu		X X Fosc/4 Fosc/8 Fosc/16 Fosc/32 Fosc/64 X
			OPTION	  32	16M_IHRC	X X X X	X X Normal X X X X X X X X X			
        	}
        
	        IF	High_Clk == 12M_X'tal
		{		
			OPTION    2 	Fcpu		X X Fosc/4 Fosc/8 Fosc/16 Fosc/32 Fosc/64 X
			OPTION	  32	16M_IHRC	X X X X	X X Normal X X X X X X X X X
        	}
        
        	IF	High_Clk == 4M_X'tal
		{
			OPTION    2 	Fcpu		X X Fosc/4 Fosc/8 Fosc/16 Fosc/32 Fosc/64 X
			OPTION	  32	16M_IHRC	X X X X	X X Normal X X X X X X X X X
        	}	   
	}
	
	IF Noise_Filter == Disable
	{
  	      	IF	High_Clk == IHRC_16M
		{	
			OPTION    2 	Fcpu		X Fosc/1 Fosc/2 Fosc/4 Fosc/8 Fosc/16 Fosc/32 Fosc/64			
			OPTION	  32	16M_IHRC	X X X X	-2MHz -1MHz Normal +1MHz +2MHz X X X X X X X
        	}
        
	        IF	High_Clk == IHRC_RTC
		{		
			OPTION    2 	Fcpu		X Fosc/1 Fosc/2 Fosc/4 Fosc/8 Fosc/16 Fosc/32 Fosc/64
			OPTION	  32	16M_IHRC	X X X X	-2MHz -1MHz Normal +1MHz +2MHz X X X X X X X
        	}	 
	        
		IF	High_Clk == Ext_RC
		{		
			OPTION    2 	Fcpu		Fosc/1 Fosc/2 Fosc/4 Fosc/8 Fosc/16 Fosc/32 Fosc/64 X
			OPTION	  32	16M_IHRC	X X X X	X X Normal X X X X X X X X X			
        	}
        
        	IF	High_Clk == 32K_X'tal
		{		
			OPTION    2 	Fcpu		Fosc/1 Fosc/2 Fosc/4 Fosc/8 Fosc/16 Fosc/32 Fosc/64 X			
			OPTION	  32	16M_IHRC	X X X X	X X Normal X X X X X X X X X
        	}
        
	        IF	High_Clk == 12M_X'tal
		{		
			OPTION    2 	Fcpu		Fosc/1 Fosc/2 Fosc/4 Fosc/8 Fosc/16 Fosc/32 Fosc/64 X
			OPTION	  32	16M_IHRC	X X X X	X X Normal X X X X X X X X X			
        	}
        
        	IF	High_Clk == 4M_X'tal
		{
			OPTION    2 	Fcpu		Fosc/1 Fosc/2 Fosc/4 Fosc/8 Fosc/16 Fosc/32 Fosc/64 X			
			OPTION	  32	16M_IHRC	X X X X	X X Normal X X X X X X X X X
        	}
  	}   
  	   
  	IF	Watch_Dog  == Always_ON
	{
		Int_16K_RC	= Always_ON
		Watch_Dog0	= Enable
	}
	ELSEIF	Watch_Dog  == Enable
	{
		Int_16K_RC	= By_CPUM
		Watch_Dog0	= Enable
	}
	ELSE
	{
		Int_16K_RC	= By_CPUM
		Watch_Dog0	= Disable
	}  	   
 		
        
	ENDP
	//}}SONIX_OPTION_RULE
}