;*******************************************************************************
;  CHIP: SN8P2318
;  Revision History
;  
;  V01   03/25/2010  1. First issue and only for SN8ICE 2K. 
;  V02   06/29/2010  1. modify MACRO text "SLowMode" to "SlowMode"
;  V03   05/20/2011  1. add Code Option : NOISE_FILTER enable/disable selection(.TEXT).
;*******************************************************************************
.ASSEMBLY	RedWrt_FORMAT	1
.Assembly	INC_VER		3
.Assembly	ASM_FORMAT	1
.Assembly	RAM_Size	128

.Assembly	INSTRUMENT	SN8P2318
.Assembly	BIT_FILE	SN8P2318

.Assembly	OTP_BODY_SIZE	0x1000 
.Assembly	USER_ROM_SIZE	0x0FFC

;.Assembly	OTP_TEST_SIZE	0x00E0
;.Assembly	MASK_TEST_FILE
.Assembly	MASK_TEST_CODE	0x0000, 0x0000, 0x0000, 0x0000
;.Assembly	OTP_TEST_FILE	
.Assembly	PGM_TYPE	6
.Assembly	CHIP_ID		0x5820		
;.Assembly	COMMAND		Enable_ORG4_7, RBANK_LIMIT
.Assembly	COMMAND		Enable_ORG4_7, GREEN_NOP_LIMIT, RBANK_LIMIT
.Assembly	Port_Pins	5,7,8,8,0,1
.Assembly	LCD_Size	32, 4
;*******************************************************************************
; Code Option 0x0FFF
.Assembly	OPTION		0		Noise_Filter	Disable Enable	
.Assembly	OPTION		1		Security	Enable	Disable
.Assembly	OPTION		2		Fcpu		Fosc/1 Fosc/2 Fosc/4 Fosc/8 x x x Fosc/16
.Help
{
	Fcpu		: 	"Only Effective for HIGH Clock"
}
.Assembly	OPTION		5		High_Clk	PLL_16M Ext_RC 12M_X'tal 4M_X'tal
.Help
{	
	PLL_16M		:	"Connect C to VDD and Xin"
	Ext_RC		:	"Connect R to VDD and Xin\nConnect C to GND and Xin"
	12M_X'tal	:	"Crystal/Resonator: 10Mhz~16Mhz"
	4M_X'tal	:	"Crystal/Resonator: 2Mhz~10Mhz"
}
.Assembly	OPTION		7		Low_Clk 	32K_X'tal RC
.Help
{	
	RC		:	"Connect C to GND and LXin"
}
.Assembly	OPTION		8		Watch_Dog 	Always_On x x x x Enable x x x x Disable x x x x x 
.Help
{
	Always_ON	:	"Watchdog still enable even in\nGreen and Sleep mode"
	Enable		:	"Normal mode: Enable Watchdog\nGreen and Sleep mode: Stop Watchdog"
	Disable         :       "Disable Watchdog"
} 
.Assembly	OPTION		12		Reset_Pin 	P03	Reset
;.Assembly	OPTION   	13		Rst_Len		No	128_ILRC
.Assembly	OPTION   	13		Fix_High
;.Assembly	OPTION   	14		IHRC_Det	Disable	Enable
.Assembly	OPTION   	14		Fix_High
;.Assembly	OPTION   	15		X'tal_Det	Disable Enable
.Assembly	OPTION		15		Fix_Low
;*******************************************************************************
; Code Option 0x0FFE
.Assembly	OPTION		16		Fix_Low
.Assembly	OPTION		17		Fix_High
.Assembly	OPTION		18		Fix_Low
.Assembly	OPTION		19		Fix_High
.Assembly	OPTION		20		Fix_High
.Assembly	OPTION		21		Fix_Low
.Assembly	OPTION		22		Fix_High
.Assembly	OPTION		23		Fix_Low
.Assembly	OPTION		24		Fix_Low
.Assembly	OPTION		25		Fix_High
.Assembly	OPTION		26		Fix_Low
.Assembly	OPTION		27		Fix_High
.Assembly	OPTION		28 : 31		Fix_High
;*******************************************************************************
; Code Option 0x0FFD
.Assembly	OPTION		32 : 40		Fix_High
.Assembly	OPTION		41		LVDM     	LVD_Max	LVD_H	LVD_M	LVD_L
.Help
{
	LVD_L		:	"2.0V Reset"
	LVD_M		:	"2.0V Reset\nEnable LVD24 bit of PFLAG for\n2.4V Low Voltage Indicator"
	LVD_H		:	"2.4V Reset\nEnable LVD36 bit of PFLAG for\n3.6V Low Voltage Indicator"	
	LVD_Max		:	"3.6V Reset"	
}
;.Assembly	OPTION		43		LVDB		No 2_ILRC
.Assembly	OPTION		43		Fix_Low
.Assembly	OPTION		44 : 63		Fix_High
;*******************************************************************************
.Assembly	OPTION		2ffh

	L		EQU		0x80
	H		EQU		0x81
	R		EQU		0x82
	Z		EQU		0x83
	Y		EQU		0x84
;*******************************************************************************
	PFLAG		EQU		0x86
		FZ		EQU		PFLAG.0
		FDC		EQU		PFLAG.1
		FC		EQU		PFLAG.2
		FLVD24		EQU		PFLAG.4
		FLVD36		EQU		PFLAG.5
		FNPD		EQU		PFLAG.6
		FNT0		EQU		PFLAG.7
;*******************************************************************************
	RBANK		EQU		087H
		FRBNKS0		EQU		RBANK.0
;*******************************************************************************
	T1M		EQU		0A0H
		FT1ENB	 	EQU   		T1M.7
		FT1RATE2 	EQU  	 	T1M.6
		FT1RATE1 	EQU  	 	T1M.5
		FT1RATE0 	EQU  	 	T1M.4
		FT1CKS	 	EQU  	 	T1M.3
;*******************************************************************************
	T1CL		EQU		0A1H
	T1CH		EQU		0A2H
	T1VCL		EQU		0A3H
	T1VCH		EQU		0A4H
;*******************************************************************************
	T1CKSM		EQU		0A5H
		FCPTVC	 	EQU   		T1CKSM.7
		FCPTCKS 	EQU  	 	T1CKSM.3
		FCPTStart 	EQU  	 	T1CKSM.2
		FCPTG1	 	EQU  	 	T1CKSM.1
		FCPTG0	 	EQU  	 	T1CKSM.0
;*******************************************************************************
	RFCM		EQU		0A6H
		FRFCENB	 	EQU		RFCM.7
		FRFCDEBT 	EQU_W		RFCM.5
		FRFCDEB	 	EQU_W		RFCM.4
		FRFCOUT 	EQU		RFCM.3
		FRFCH2	 	EQU		RFCM.2
		FRFCH1	 	EQU		RFCM.1
		FRFCH0	 	EQU		RFCM.0
;*******************************************************************************
	P0M		EQU		0B8H
		FP04M		EQU		P0M.4
		FP02M		EQU		P0M.2
		FP01M		EQU		P0M.1
		FP00M		EQU		P0M.0
;*******************************************************************************
	PEDGE		EQU		0BFH
		FP00G1		EQU		PEDGE.4
		FP00G0		EQU		PEDGE.3
;*******************************************************************************
	P1W		EQU		0C0H
		FP16W		EQU_W		P1W.6
		FP15W		EQU_W		P1W.5
		FP14W		EQU_W		P1W.4
		FP13W		EQU_W		P1W.3
		FP12W		EQU_W		P1W.2
		FP11W		EQU_W		P1W.1
		FP10W		EQU_W		P1W.0
;*******************************************************************************
	P1M		EQU		0C1H
		FP16M		EQU		P1M.6
		FP15M		EQU		P1M.5
		FP14M		EQU		P1M.4
		FP13M		EQU		P1M.3
		FP12M		EQU		P1M.2
		FP11M		EQU		P1M.1
		FP10M		EQU		P1M.0
;*******************************************************************************
	P2M		EQU		0C2H
		FP27M		EQU		P2M.7
		FP26M		EQU		P2M.6
		FP25M		EQU		P2M.5
		FP24M		EQU		P2M.4
		FP23M		EQU		P2M.3
		FP22M		EQU		P2M.2
		FP21M		EQU		P2M.1
		FP20M		EQU		P2M.0
;*******************************************************************************
	P3M		EQU		0C3H
		FP37M		EQU		P3M.7
		FP36M		EQU		P3M.6
		FP35M		EQU		P3M.5
		FP34M		EQU		P3M.4
		FP33M		EQU		P3M.3
		FP32M		EQU		P3M.2
		FP31M		EQU		P3M.1
		FP30M		EQU		P3M.0
;*******************************************************************************
	P5M		EQU		0C5H
	     	FP54M		EQU		P5M.4
;*******************************************************************************
	INTRQ		EQU		0C8H
		FT1IRQ		EQU		INTRQ.6
		FTC0IRQ		EQU		INTRQ.5
    		FT0IRQ  	EQU 		INTRQ.4
		FP01IRQ		EQU		INTRQ.1
		FP00IRQ		EQU		INTRQ.0
;*******************************************************************************
	INTEN		EQU		0C9H
		FT1IEN		EQU		INTEN.6
		FTC0IEN		EQU		INTEN.5
		FT0IEN		EQU 		INTEN.4
		FP01IEN		EQU		INTEN.1
		FP00IEN		EQU		INTEN.0
;*******************************************************************************
	OSCM		EQU		0CAH
		FCPUM1		EQU		OSCM.4
		FCPUM0		EQU		OSCM.3
		FCLKMD		EQU		OSCM.2
		FSTPHX		EQU		OSCM.1
;*******************************************************************************
	LCDM		EQU		0CBH
		FCPCK1		EQU		LCDM.7
		FCPCK0		EQU		LCDM.6
		FVLCDCP		EQU		LCDM.5
		FPSEG2		EQU		LCDM.4
		FPSEG1		EQU		LCDM.3
		FPSEG0		EQU		LCDM.2
		FBIAS		EQU		LCDM.1
		FLCDENB		EQU		LCDM.0
;*******************************************************************************
	WDTR		EQU		0CCH
	TC0R		EQU		0CDH
	PCL		EQU		0CEH
	PCH		EQU		0CFH
;*******************************************************************************
	P0		EQU 		0D0H
		FP04		EQU 		P0.4
		FP03		EQU_R 		P0.3
		FP02		EQU 		P0.2
		FP01		EQU 		P0.1
		FP00		EQU 		P0.0
;*******************************************************************************
	P1		EQU		0D1H
		FP16		EQU		P1.6
		FP15		EQU		P1.5
		FP14		EQU		P1.4
		FP13		EQU		P1.3
		FP12		EQU		P1.2
		FP11		EQU		P1.1
		FP10		EQU		P1.0
;*******************************************************************************
	P2		EQU		0D2H
		FP27		EQU		P2.7
		FP26		EQU		P2.6
		FP25		EQU		P2.5
		FP24		EQU		P2.4
		FP23		EQU		P2.3
		FP22		EQU		P2.2
		FP21		EQU		P2.1
		FP20		EQU		P2.0
;*******************************************************************************
	P3		EQU		0D3H
		FP37		EQU		P3.7
		FP36		EQU		P3.6
		FP35		EQU		P3.5
		FP34		EQU		P3.4
		FP33		EQU		P3.3
		FP32		EQU		P3.2
		FP31		EQU		P3.1
		FP30		EQU		P3.0
;*******************************************************************************
	P5		EQU		0D5H
		FP54		EQU		P5.4
;*******************************************************************************
	T0M		EQU		0D8H
		FT0ENB	 	EQU   		T0M.7
		FT0RATE2 	EQU  	 	T0M.6
		FT0RATE1 	EQU  	 	T0M.5
		FT0RATE0 	EQU  	 	T0M.4
		FT0TB	 	EQU  	 	T0M.0
;*******************************************************************************
   	T0C		EQU		0D9H
;*******************************************************************************
	TC0M		EQU		0DAH
		FTC0ENB		EQU		TC0M.7
		FTC0RATE2	EQU		TC0M.6
		FTC0RATE1	EQU		TC0M.5
		FTC0RATE0	EQU		TC0M.4
		FTC0CKS1	EQU		TC0M.3
       		FTC0CKS0    	EQU		TC0M.2
       		FPWM0OUT   	EQU		TC0M.0
;*******************************************************************************
	TC0C		EQU		0DBH
;*******************************************************************************
	STKP		EQU		0DFH
		FGIE		EQU		STKP.7
		FSTKPB2		EQU		STKP.2
		FSTKPB1		EQU		STKP.1
		FSTKPB0		EQU		STKP.0
;*******************************************************************************
    	P0UR		EQU   		0E0H
		FP04R		EQU_W		P0UR.4
		FP02R		EQU_W		P0UR.2
		FP01R		EQU_W		P0UR.1
		FP00R		EQU_W		P0UR.0
;*******************************************************************************	
    	P1UR		EQU   		0E1H
		FP16R		EQU_W		P1UR.6
		FP15R		EQU_W		P1UR.5
		FP14R		EQU_W		P1UR.4
		FP13R		EQU_W		P1UR.3
		FP12R		EQU_W		P1UR.2
		FP11R		EQU_W		P1UR.1
		FP10R		EQU_W		P1UR.0
;*******************************************************************************
    	P2UR		EQU  	 	0E2H
		FP27R		EQU_W		P2UR.7
		FP26R		EQU_W		P2UR.6
		FP25R		EQU_W		P2UR.5
		FP24R		EQU_W		P2UR.4
		FP23R		EQU_W		P2UR.3
		FP22R		EQU_W		P2UR.2
		FP21R		EQU_W		P2UR.1
		FP20R		EQU_W		P2UR.0
;*******************************************************************************
    	P3UR		EQU   		0E3H
		FP37R		EQU_W		P3UR.7
		FP36R		EQU_W		P3UR.6
		FP35R		EQU_W		P3UR.5
		FP34R		EQU_W		P3UR.4
		FP33R		EQU_W		P3UR.3
		FP32R		EQU_W		P3UR.2
		FP31R		EQU_W		P3UR.1
		FP30R		EQU_W		P3UR.0
;*******************************************************************************		
    	P5UR		EQU   		0E5H
		FP54R		EQU_W		P5UR.4
;*******************************************************************************		
	@HL		EQU		0E6H
	@YZ		EQU		0E7H
	TC0D		EQU		0E8H
;*******************************************************************************
	STK7L		EQU		0F0h
	STK7H		EQU		0F1h
	STK6L		EQU		0F2h
	STK6H		EQU		0F3h
	STK5L		EQU		0F4h
	STK5H		EQU		0F5h
	STK4L		EQU		0F6h
	STK4H		EQU		0F7h
	STK3L		EQU		0F8h
	STK3H		EQU		0F9h
	STK2L		EQU		0FAh
	STK2H		EQU		0FBh
	STK1L		EQU		0FCh
	STK1H		EQU		0FDh
	STK0L		EQU		0FEh
	STK0H		EQU		0FFh
;*******************************************************************************
; Clear watchdog macro. 
;  
; Total Cycle: 2

	@RST_WDT	macro
		   MOV  A, #0x5A
		   B0MOV  WDTR, A
	endm
;*******************************************************************************
; Sleep Mode control macro for compatibility in S8KD-2 ICE
;  
; Total Cycle: 1

	SleepMode	macro	
		B0BSET	FCPUM0
	endm
;*******************************************************************************
; Green Mode control macro for compatibility in S8KD-2 ICE
;  
; Total Cycle: 3

	GreenMode	macro	
		B0BSET	FCPUM1
		NOP
		NOP
	endm
;*******************************************************************************
; Slow Mode control macro for compatibility in S8KD-2 ICE
;  
; Total Cycle: 2

	SlowMode	macro	
		B0BSET	FCLKMD
		B0BSET	FSTPHX
	endm
;*******************************************************************************
;  Slow mode to Normal Mode control macro for compatibility in S8KD-2 ICE
;  
; Total Cycle: 5

	Slow2Normal	macro	
		B0BCLR	FSTPHX
		NOP
		NOP
		NOP
		B0BCLR	FCLKMD
	endm
;*******************************************************************************
.TEXT
{
	//{{SONIX_OPTION_RULE
	IF Noise_Filter == Enable
	{
		OPTION		2		Fcpu		x x Fosc/4 Fosc/8 x x x Fosc/16
  	}
	ELSE	
	{
		OPTION		2		Fcpu		Fosc/1 Fosc/2 Fosc/4 Fosc/8 x x x Fosc/16
  	}      
	ENDP
	//}}SONIX_OPTION_RULE
}
;*******************************************************************************