
;------------------------------------------------------------------------------
;  CHIP: SN8P1989, OTP Only
;  Revision History:
;  V1.0  04/10/2006  First issue
;  V2.0  04/26/2006  1: Update INC file for March spec. meeting
;  V3.0  11/15/2006  1: Add OPTION register from JP reply.
;  V4.0  02/13/2007  1: Update by real chip wafer out
;		     2: Add 0x9D register for Laser trim verify.
;		     3: Change AMPCHS register for ADC channel selection	
;		     4: Change ADC16M register for ADC reference voltage selection	
;		     5: Change REGM register for add AVE+ voltage selection bit.
;		     6: Remove ICE=1 option of BCZ and BZM register because of using real chip register.
;		     7: Change ADC12M register for ADC channel selection.
;		     8: Change EV comunication port from P4.4~7 to P3.4~7.
;		     9: Change SMOV table 0x73 address data from 0x80 to 0x8F for TCx overflow fixed on per 256.
;		     10: Change SMOV table 0x86 address data from 0xC0 to 0x00 for NT0/NPD not exist..
;		     11: Change SMOV table 0xD3 address data from 0x00 to 0xFF for using Port3 as EV port
;		     12: Change SMOV table 0xD4 address data from 0xFF to 0x00 for NOT using Port4 as EV port
;		     13: Change ADC12M's bit 7 AD12ENB to ADC12ENB
;  V5.0  02/26/2007  1: Add ADC16CH3 bit in AMPCHS register.
;		     2: Add 0x9D for Laser Trim Register : LASERM
;		     3: Change Low Power code option form bit 7 to bit 1
;  V6.0  05/26/2009  1: Remove ADC12IEN,ADC12IRQ.
;		     2: Change SMOV table 0xC9 address data from 0x7F to 0x77 for disable ADC12IEN.
;  V7.0  06/29/2010  1: Add Macro "@RST_WDT", "SleepMode", "GreenMode", "SlowMode", "Slow2Normal" 
;------------------------------------------------------------------------------
.ASSEMBLY    RedWrt_FORMAT    1

.Assembly	INC_VER		7
.Assembly	ASM_FORMAT	1
.Assembly	RAM_Size	200h
.Assembly	INSTRUMENT	SN8P1989
;.Assembly	MASK_BODY_SIZE
IF 	ICE_Mode == 0
  .Assembly	OTP_BODY_SIZE	0x03000
  .Assembly	USER_ROM_SIZE	0x02FFF
ELSE
  .Assembly	OTP_BODY_SIZE	0x03400
  .Assembly	USER_ROM_SIZE	0x033FF
ENDIF

;.Assembly	OTP_TEST_SIZE	0x00180

;.Assembly	MASK_TEST_FILE
;.Assembly	OTP_TEST_FILE	SN8PTA01
.Assembly	PGM_TYPE	9
.Assembly	MASK_TEST_CODE	0x0000, 0x000, 0x0000, 0x0000
.Assembly	Port_Pins	2, 8, 8, 0, 8, 8, 0
.Assembly	LCD_Size	28, 4
.Assembly	COMMAND		PUSH, MUL
.Assembly	CHIP_ID		0x9920



.Assembly	OPTION		0		Watch_Dog	Enable	Disable
.Assembly	OPTION		1		Low_Power	Enable	Disable
.Assembly	OPTION		2		Int_16K_RC	Always_ON	By_CPUM
.Assembly	OPTION		3		Security	Enable	Disable
.Assembly	OPTION		4		Fix_High						
;;.Assembly	OPTION		5		High_Clk	RC	32K_X'tal	12M_X'tal	4M_X'tal
.Assembly	OPTION		5		Fix_High						;4-26  Fix as 4M
.Assembly	OPTION		6		Fix_High						;4-26  Fix as 4M
.Assembly	OPTION		7		Fix_High
.Assembly	OPTION		8		Noise_Filter	Enable	Disable
.Assembly	OPTION		9 		Fix_High
.Assembly	OPTION		10 		Fix_High
.Assembly	OPTION		11 		Fix_High
.Assembly	OPTION		12 		Fix_High
.Assembly	OPTION		13 		Fix_High
.Assembly	OPTION		14 		Fix_High
.Assembly	OPTION		15 		Fix_High
;;.Assembly	OPTION		13 		Fix_High
;;.Assembly	OPTION		14		Low_Power	X	Enable	X	Disable	;Phase_Select	8_Phase	1_Phase	4_Phase	6_Phase
.Assembly	OPTION		2ffh
;.Assembly	OTP2MSK		0xFFFF, 0x000C, 0x0000

	L			EQU		0x80
	H			EQU		0x81
	R			EQU		0x82
	Z			EQU		0x83
	Y			EQU		0x84
	X			EQU		0x85	
	
	PFLAG			EQU		0x86


		FC		EQU		PFLAG.2
		FDC		EQU		PFLAG.1
		FZ		EQU		PFLAG.0



	RBANK			EQU		0x87
			FRBNKS0	EQU		0x87.0
			FRBNKS1	EQU		0x87.1
			FRBNKS2	EQU		0x87.2
			FRBNKS3	EQU		0x87.3

	OPTION			EQU		0x88
		FRCLK	EQU		0x88.0

IF	ICE_Mode==1

	LCDM1		EQU		0XCB	;S8KD-2 address
		FLCDBNK		EQU		LCDM1.5
		FLCDENB		EQU		LCDM1.3
		FLCDBIAS	EQU		LCDM1.2						;4-26 1/3 bias only
		
		Dummy		EQU		0X8F	;FOR by pass
		FP2HSEG		EQU		Dummy.1				
		FP2LSEG		EQU		Dummy.0				
ELSE	
	LCDM1			EQU		0x89	;SN8P1919 real chip address
		FLCDBNK		EQU		LCDM1.5
		FLCDENB		EQU		LCDM1.3
		FLCDBIAS	EQU		LCDM1.2						;4-26 1/3 bias only
		FP2HSEG		EQU		LCDM1.1		
		FP2LSEG		EQU		LCDM1.0
						
ENDIF

	AMPM			EQU		0x90
		FBGRENB	EQU		AMPM.6
		FFDS1	EQU		AMPM.5
		FFDS0	EQU		AMPM.4
		FGS2	EQU		AMPM.3
		FGS1	EQU		AMPM.2
		FGS0	EQU		AMPM.1
		FAMPENB	EQU		AMPM.0

	AMPCHS			EQU		0x91
		FADC16CHS3	EQU		AMPCHS.3					;2-26	
		FADC16CHS2	EQU		AMPCHS.2					;4-26,2-13
		FADC16CHS1	EQU		AMPCHS.1					;4-26,2-13 
		FADC16CHS0	EQU		AMPCHS.0

	AMPCKS			EQU_W		0x92

	ADC16M			EQU		0x93
		FIRVS		EQU		ADC16M.3						;6-15 
		FRVS1		EQU		ADC16M.2						;4-26 
		FRVS0		EQU		ADC16M.1						;2-13, 2-14
		FADC16ENB	EQU		ADC16M.0
				
	ADCKS			EQU_W		0X94

	REGM			EQU		0x95
		FACMENB		EQU		REGM.7	
		FAVDDRENB	EQU		REGM.6	
		FAVENB		EQU		REGM.5
		FAVESEL1	EQU		REGM.4						;2-16
		FAVESEL0	EQU		REGM.3						;2-16
		FREGENB		EQU		REGM.0
	
	;CPCKS			EQU_W		0x96						;4-26 
	
	DFM			EQU		0x97
		FWRS0		EQU		DFM.2
		FDRDY		EQU		DFM.0

	ADCDL			EQU_R		0x98
	ADCDH			EQU_R		0x99

	LBTM			EQU		0x9A
		FLBTO		EQU_R		LBTM.2
		FLBTENB		EQU		LBTM.0

	BZC		EQU		0X9B							;2-16

	BZM			EQU	0X9C							;2-16
		FBZOENB		EQU	BZM.7
		FBZORATE2	EQU	BZM.6		;6-15
		FBZORATE1	EQU	BZM.5		;6-15
		FBZORATE0	EQU	BZM.4		;6-15
		FBZOX8		EQU	BZM.2		;6-15		

	LASERM		EQU		0X9D		

	ADC12M			EQU		0xB1
		FADC12ENB	EQU		ADC12M.7
		FADS		EQU		ADC12M.6
		FEOC		EQU		ADC12M.5
		FGCHS		EQU		ADC12M.4
		;FCHS2		EQU		ADC12M.2					;4-26 ,2-16
		FADC12CHS1	EQU		ADC12M.1				;4-26 ,2-16
		FADC12CHS0	EQU		ADC12M.0
		
	ADB			EQU_R	0B2H

	ADR			EQU		0B3H
		FAD12CKS1	EQU		ADR.6
		FAD12CKS	EQU		ADR.6
		;FADLEN		EQU		ADR.5
		FAD12CKS0	EQU		ADR.4
		FADB3		EQU_R	ADR.3
		FADB2		EQU_R	ADR.2
		FADB1		EQU_R	ADR.1
		FADB0		EQU_R	ADR.0	
		
;	SIOM		EQU			0xB4
;		FSENB	EQU		SIOM.7
;		FSTART	EQU		SIOM.6
;		FSRATE1	EQU		SIOM.5
;		FSRATE0	EQU		SIOM.4
;		FSIG	EQU		SIOM.3
;		FSCKMD	EQU		SIOM.2
;		FSEDGE	EQU		SIOM.1
;		FTXRX	EQU		SIOM.0

;	SIOR		EQU_W			0xB5
;	SIOB		EQU			0xB6

	PEDGE		EQU			0xBF

		FPEDGEN EQU		PEDGE.7
		FP00G0	EQU		PEDGE.3
		FP00G1	EQU		PEDGE.4
	P1W			EQU_W		0C0H

		FP17W	EQU_W		P1W.7
		FP16W	EQU_W		P1W.6
		FP15W	EQU_W		P1W.5
		FP14W	EQU_W		P1W.4
		FP13W	EQU_W		P1W.3
		FP12W	EQU_W		P1W.2
		FP11W	EQU_W		P1W.1
		FP10W	EQU_W		P1W.0

	P1M			EQU		0xC1

		FP17M	EQU		P1M.7
		FP16M	EQU		P1M.6
		FP15M	EQU		P1M.5
		FP14M	EQU		P1M.4
		FP13M	EQU		P1M.3
		FP12M	EQU		P1M.2
		FP11M	EQU		P1M.1
		FP10M	EQU		P1M.0

	P2M			EQU		0xC2	;change to input only
		FP27M	EQU		P2M.7
		FP26M	EQU		P2M.6
		FP25M	EQU		P2M.5
		FP24M	EQU		P2M.4
		FP23M	EQU		P2M.3
		FP22M	EQU		P2M.2
		FP21M	EQU		P2M.1
		FP20M	EQU		P2M.0

	;P4M			EQU		0C4H
		;FP41M	EQU		P4M.1
		;FP40M	EQU		P4M.0

	P5M			EQU		0C5H
		FP57M	EQU		P5M.7
		FP56M	EQU		P5M.6
		FP55M	EQU		P5M.5
		FP54M	EQU		P5M.4
		FP53M	EQU		P5M.3
		FP52M	EQU		P5M.2
		FP51M	EQU		P5M.1
		FP50M	EQU		P5M.0
	
	INTRQ			EQU		0C8H
		FTC1IRQ		EQU	INTRQ.6
		FTC0IRQ		EQU	INTRQ.5
		FT0IRQ		EQU	INTRQ.4
		FADC16IRQ	EQU	INTRQ.2
		FP01IRQ		EQU	INTRQ.1
		FP00IRQ		EQU	INTRQ.0

	INTEN			EQU		0C9H
		FTC1IEN		EQU	INTEN.6
		FTC0IEN		EQU	INTEN.5
		FT0IEN		EQU	INTEN.4
		FADC16IEN	EQU	INTEN.2
		FP01IEN		EQU	INTEN.1
		FP00IEN		EQU	INTEN.0

	OSCM		EQU			0xCA
		FWTCKS	EQU	OSCM.7
		FWDRST	EQU	OSCM.6
		FWDRATE	EQU	OSCM.5
		FCPUM1	EQU	OSCM.4
		FCPUM0	EQU	OSCM.3
		FCLKMD	EQU	OSCM.2
		FSTPHX	EQU	OSCM.1
	;	FHXUP	EQU	OSCM.0

	TC0R		EQU_W			0xCD

	PCL			EQU		0xCE
	PCH			EQU		0xCF

	P0			EQU_R	0D0H
		FP02	EQU_R	P0.2
		FP01	EQU_R	P0.1
		FP00	EQU_R	P0.0

	P1			EQU		0xD1
		FP17	EQU		P1.7
		FP16	EQU		P1.6
		FP15	EQU		P1.5					
		FP14	EQU		P1.4
		FP13	EQU		P1.3
		FP12	EQU		P1.2
		FP11	EQU		P1.1
		FP10	EQU		P1.0

	P2			EQU		0xD2
		FP27	EQU		P2.7
		FP26	EQU		P2.6
		FP25	EQU		P2.5
		FP24	EQU		P2.4
		FP23	EQU		P2.3
		FP22	EQU		P2.2
		FP21	EQU		P2.1
		FP20	EQU		P2.0


		
	P5			EQU		0xD5
		FP57	EQU		P5.7
		FP56	EQU		P5.6
		FP55	EQU		P5.5
		FP54	EQU		P5.4
		FP53	EQU		P5.3
		FP52	EQU		P5.2
		FP51	EQU		P5.1
		FP50	EQU		P5.0



	T0M			EQU		0xD8
		FT0ENB		EQU	T0M.7
		FT0RATE2	EQU	T0M.6
		FT0RATE1	EQU	T0M.5
		FT0RATE0	EQU	T0M.4
		FTC1X8		EQU	T0M.3					;4-26 
		FTC0X8		EQU	T0M.2					;4-26 	
		FTC0GN		EQU	T0M.1
		FT0TB		EQU	T0M.0

	T0C			EQU		0xD9

	TC0M		EQU			0DAH
		FTC0ENB		EQU	TC0M.7
		FTC0RATE2	EQU	TC0M.6
		FTC0RATE1	EQU	TC0M.5
		FTC0RATE0	EQU	TC0M.4
		;FTC0CKS		EQU	TC0M.3					;4-26 
		FALOAD0		EQU	TC0M.2
		FTC0OUT		EQU	TC0M.1
		FPWM0OUT	EQU	TC0M.0

	TC0C		EQU			0xDB

	TC1M		EQU			0xDC
		FTC1ENB		EQU	TC1M.7
		FTC1RATE2	EQU	TC1M.6
		FTC1RATE1	EQU	TC1M.5
		FTC1RATE0	EQU	TC1M.4
		;FTC1CKS		EQU	TC1M.3					;4-26 
		FALOAD1		EQU	TC1M.2
		FTC1OUT		EQU	TC1M.1
		FPWM1OUT	EQU	TC1M.0

	TC1C		EQU			0xDD
	TC1R		EQU_W			0xDE

	STKP		EQU			0xDF
		FGIE	EQU		STKP.7
		FSTKPB3	EQU		STKP.3
		FSTKPB2	EQU		STKP.2
		FSTKPB1	EQU		STKP.1
		FSTKPB0	EQU		STKP.0

	P0UR		EQU_W			0xE0
		FP01R	EQU_W	P0UR.1
		FP00R	EQU_W	P0UR.0

	P1UR		EQU_W			0xE1
		FP17R	EQU_W	P1UR.7
		FP16R	EQU_W	P1UR.6
		FP15R	EQU_W	P1UR.5
		FP14R	EQU_W	P1UR.4
		FP13R	EQU_W	P1UR.3
		FP12R	EQU_W	P1UR.2
		FP11R	EQU_W	P1UR.1
		FP10R	EQU_W	P1UR.0

	P2UR		EQU_W			0xE2
		FP27R	EQU_W	P2UR.7
		FP26R	EQU_W	P2UR.6
		FP25R	EQU_W	P2UR.5
		FP24R	EQU_W	P2UR.4
		FP23R	EQU_W	P2UR.3
		FP22R	EQU_W	P2UR.2
		FP21R	EQU_W	P2UR.1
		FP20R	EQU_W	P2UR.0


	P5UR		EQU_W			0xE5
		FP57R	EQU_W	P5UR.7
		FP56R	EQU_W	P5UR.6
		FP55R	EQU_W	P5UR.5
		FP54R	EQU_W	P5UR.4
		FP53R	EQU_W	P5UR.3
		FP52R	EQU_W	P5UR.2
		FP51R	EQU_W	P5UR.1
		FP50R	EQU_W	P5UR.0

	@HL			EQU		0xE6
	DP0X			EQU		0xE6

	@YZ			EQU		0xE7
	DP1X			EQU		0xE7

	STK7L		EQU		0F0h
	STK7H		EQU		0F1h
	STK6L		EQU		0F2h
	STK6H		EQU		0F3h
	STK5L		EQU		0F4h
	STK5H		EQU		0F5h
	STK4L		EQU		0F6h
	STK4H		EQU		0F7h
	STK3L		EQU		0F8h
	STK3H		EQU		0F9h
	STK2L		EQU		0FAh
	STK2H		EQU		0FBh
	STK1L		EQU		0FCh
	STK1H		EQU		0FDh
	STK0L		EQU		0FEh
	STK0H		EQU		0FFh




; -----------------------------------------------------
; Clear watchdog macro for compatibility in S8KD-1 ICE
;  
; Total Cycle: 1 

	@RST_WDT	macro		
 		B0BSET	FWDRST
	endm
	
; -----------------------------------------------------
; Sleep Mode control macro for compatibility in S8KD-1 ICE
;  
; Total Cycle: 1

	SleepMode	macro	 
		B0BSET	FCPUM0
	endm
; -----------------------------------------------------
; Green Mode control macro for compatibility in S8KD-1 ICE
;  
; Total Cycle: 3

	GreenMode	macro	
		B0BSET	FCPUM1
		NOP
		NOP
	endm
; -----------------------------------------------------
; Slow Mode control macro for compatibility in S8KD-1 ICE
;  
; Total Cycle: 2

	SlowMode	macro	
		B0BSET	FCLKMD
		B0BSET	FSTPHX
	endm
; -----------------------------------------------------
;  Slow mode to Normal Mode control macro for compatibility in S8KD-1 ICE
;  
; Total Cycle: 5

	Slow2Normal	macro	
		B0BCLR	FSTPHX
		NOP
		NOP
		NOP
		B0BCLR	FCLKMD
	endm


;;*************************************************************
; For simulation use 
; ICE connect to EV Board
;;*************************************************************
	
IF ICE_Mode==1


	P3M			EQU		0C3H
		FP37M	EQU		P3M.7
		FP36M	EQU		P3M.6
		FP35M	EQU		P3M.5
		FP34M	EQU		P3M.4
	

	P3			EQU		0xD3
		FP37	EQU		P3.7
		FP36	EQU		P3.6
		FP35	EQU		P3.5
		FP34	EQU		P3.4

	P3UR		EQU_W			0xE3
		FP37R	EQU_W	P3UR.7		
		FP36R	EQU_W	P3UR.6		
		FP35R	EQU_W	P3UR.5
		FP34R	EQU_W	P3UR.4


ENDIF


.TEXT
{

	//{{SONIX_SMOV_S8KD
	-1 -1 -1 -1 -1 -1 -1 -1   -1 -1 -1 -1 -1 -1 -1 -1
	-1 -1 -1 -1 -1 -1 -1 -1   -1 -1 -1 -1 -1 -1 -1 -1
	-1 -1 -1 -1 -1 -1 -1 -1   -1 -1 -1 -1 -1 -1 -1 -1
	-1 -1 -1 -1 -1 -1 -1 -1   -1 -1 -1 -1 -1 -1 -1 -1
	-1 -1 -1 -1 -1 -1 -1 -1   -1 -1 -1 -1 -1 -1 -1 -1
	-1 -1 -1 -1 -1 -1 -1 -1   -1 -1 -1 -1 -1 -1 -1 -1
	-1 -1 -1 -1 -1 -1 -1 -1   -1 -1 -1 -1 -1 -1 -1 -1
	27 58 01 8F -1 -1 -1 -1   -1 -1 -1 -1 -1 -1 -1 11
	-1 -1 -1 -1 -1 -1 00 0F   -1 -1 -1 -1 -1 -1 -1 -1
	-1 -1 -1 -1 -1 -1 -1 -1   -1 -1 -1 -1 -1 -1 -1 -1
	-1 -1 -1 -1 -1 -1 -1 -1   -1 -1 -1 -1 -1 -1 -1 -1
	-1 -1 -1 10 00 -1 -1 -1   -1 -1 -1 -1 -1 -1 00 -1
	00 -1 -1 -1 -1 -1 -1 -1   -1 77 BD -1 -1 -1 -1 -1
	87 FF FF FF 00 FF 00 00   FF -1 07 -1 -1 -1 -1 08
	-1 -1 -1 -1 -1 -1 -1 -1   -1 -1 -1 -1 -1 -1 -1 -1
	-1 -1 -1 -1 -1 -1 -1 -1   -1 -1 -1 -1 -1 -1 -1 -1
	87 00 DF 7F D0 04-1 
	-1	
	0004 72 10 00
	0001 71 00 01 -1
	


	//}}SONIX_SMOV_S8KD

	//{{SONIX_OPTION_RULE
	
	ENDP

	//}}SONIX_OPTION_RULE
}

