
;------------------------------------------------------------------------------
;  CHIP: SN8P1819A, OTP Only
;  Revision History:
;  V1.0  04/13/2005  First issue	:Bryant
;  V2.0	 07/22/2005  Invert code option High/Low byte for PGM_type 6 --> will invert code option
;  V3.0	 08/11/2005  Mark 1)FP2SEG, FBIAS, 2) FADCLENB bits
;  V4.0  08/12/2005  1: Set CPCKS, PGIACKS as Write only register.
;  V5.0  09/16/2005  1: Add three LCD code optioin
;  V6.0  11/14/2005  1: Release TC1 Interrupt function.
;             			      2: change SMOV table C9 from 30 to 70-- Enable TC1 Interrupt
;  V7.0   04/03/2008  1. Add "RedWrt_FORMAT    1"  	
;------------------------------------------------------------------------------
.ASSEMBLY    RedWrt_FORMAT    1

.Assembly	INC_VER		7
.Assembly	ASM_FORMAT	1
.Assembly	RAM_Size	200h

.Assembly	INSTRUMENT	SN8P1819A

;.Assembly	MASK_BODY_SIZE
IF 	ICE_Mode == 0
  .Assembly	OTP_BODY_SIZE	0x3000
  .Assembly	USER_ROM_SIZE	0x2FFF
ELSE
  .Assembly	OTP_BODY_SIZE	0x3400
  .Assembly	USER_ROM_SIZE	0x33FF
ENDIF
;;;.Assembly	OTP_BODY_SIZE	0x3000
;;;.Assembly	USER_ROM_SIZE	0x2FFF
;.Assembly	OTP_TEST_SIZE	0x0180

;.Assembly	MASK_TEST_FILE
;.Assembly	OTP_TEST_FILE	SN8P1819A
.Assembly	PGM_TYPE	11
.Assembly	MASK_TEST_CODE	0x0000, 0x000, 0x0000, 0x0000
.Assembly	Port_Pins	0, 6, 0, 0, 4, 7, 0
.Assembly	LCD_Size	32, 4
.Assembly	COMMAND		PUSH, MUL
.Assembly	CHIP_ID		0x8910 

.Assembly	OPTION		0		Noise_Filter	Enable	Disable
.Assembly	OPTION		1 		LVDM		x	LVD_H	LVD_M	LVD_L	
.Help
{
	LVD_L		:	"2.0V Reset"
	LVD_M		:	"2.0V Reset\nEnable LVD22 bit of PFLAG for\n2.2V Low Voltage Indicator"
	LVD_H		:	"2.2V Reset\nEnable LVD33 bit of PFLAG for\n3.3V Low Voltage Indicator"	
}
.Assembly	OPTION		3 		LCD_CLK_CNG	Enable	Disable
.Assembly	OPTION		4		LCD_Delay	MUS20NS	Normal
.Assembly	OPTION		5 		LCD_Speedup	1us	16us
.Assembly	OPTION		6 		Fix_High
.Assembly	OPTION		7		Low_Power	Enable	Disable	;Phase_Select	1_Phase	6_Phase	4_Phase	6_Phase

.Assembly	OPTION		8		Watch_Dog	Enable	Disable
.Assembly	OPTION		9		Ext_32768_Speed_up	Always_ON	Normal
.Assembly	OPTION		10		Int_16K_RC	Always_ON	By_CPUM
.Assembly	OPTION		11		Security	Enable	Disable
.Assembly	OPTION		12		Fix_High	;High_Clk/2	Enable	Disable
.Assembly	OPTION		13		High_Clk	4M_X'tal 12M_X'tal 32K_X'tal Ext_RC x x x IHRC_4M
.Help
{
	IHRC_4M		:	"Internal 4M RC Oscillator"
	Ext_RC		:	"Connect R to VDD and Xin\nConnect C to GND and Xin"
	32K_X'tal	:	"32.768K Crystal"
	12M_X'tal	:	"Crystal/Resonator: 10Mhz~16Mhz"
	4M_X'tal	:	"Crystal/Resonator: 2Mhz~10Mhz"
}			


.Assembly	OPTION		2ffh
;.Assembly	OTP2MSK		0xFFFF, 0x000C, 0x0000

	L			EQU		0x80
	H			EQU		0x81
	R			EQU		0x82
	Z			EQU		0x83
	Y			EQU		0x84
	X			EQU		0x85	
	
	PFLAG			EQU		0x86

		FNT0		EQU		PFLAG.7
		FNPD		EQU		PFLAG.6
		FC		EQU		PFLAG.2
		FDC		EQU		PFLAG.1
		FZ		EQU		PFLAG.0



	RBANK			EQU		0x87

	OPTION			EQU		0x88
		;FRTCM1	EQU		OPTION.3		;Only 0.5 sec RTC in 1819A
		;FRTCM0	EQU		OPTION.2
		FRCLK	EQU		OPTION.0

IF	ICE_Mode==1

		LCDM1		EQU		0XCB	;S8KD-2 address
		FLCDBNK	EQU		LCDM1.5
		FLCDENB	EQU		LCDM1.3


		Dummy		EQU		0X8F	;FOR by pass
		FP2SEG	EQU		Dummy.0
		FBIAS	EQU		Dummy.2		
ELSE	
	LCDM1			EQU		0x89	;SN8P1909 real chip address
		FLCDBNK	EQU		LCDM1.5
		FLCDENB	EQU		LCDM1.3
		;FBIAS	EQU		LCDM1.2
		;FP2SEG	EQU		LCDM1.0
ENDIF




	PGIACKS			EQU_W		0x92

	CPM			EQU		0x95
		FVCREG1		EQU		CPM.7	;Default = 1
		FVCREG0		EQU		CPM.6
		;FCPSTS		EQU_R		CPM.3
		;FCPAUTO	EQU		CPM.2
		FAREGENB	EQU		CPM.0
		;FCPENB		EQU		CPM.0
	
	CPCKS			EQU_W		0x96
		
	PGIAM			EQU		0x9A
		FP2GS3	EQU		PGIAM.7
		FP2GS2	EQU		PGIAM.6
		FP2GS1  EQU		PGIAM.5
		FP2GS0	EQU		PGIAM.4

		FP1GS1	EQU		PGIAM.2
		FP1GS0  EQU		PGIAM.1
		FPGIAENB	EQU		PGIAM.0

	OPM			EQU		0x9B
		FOP2UGB	 EQU		OPM.3
		FOP1UGB	 EQU		OPM.2
		FOP2ENB  EQU		OPM.1
		FOP1ENB	 EQU		OPM.0
	
	P4CON		EQU		0AEH

	ADM			EQU		0xB1
		FADENB	EQU		ADM.7
		FADS	EQU		ADM.6
		FEOC	EQU		ADM.5
		FGCHS	EQU		ADM.4
		FCHS2	EQU		ADM.2		
		FCHS1	EQU		ADM.1
		FCHS0	EQU		ADM.0
		
	ADB			EQU_R	0B2H

	ADR			EQU		0B3H
		FADCKS1	EQU		ADR.6
		;FADLEN	EQU		ADR.5
		FADCKS0	EQU		ADR.4
		FADB3	EQU_R		ADR.3
		FADB2	EQU_R		ADR.2
		FADB1	EQU_R		ADR.1
		FADB0	EQU_R		ADR.0
		

		
;	IHRCNT	EQU		0BBH
;		FIHRCNT7	EQU		IHRCNT.7
;		FIHRCNT6	EQU		IHRCNT.6
;		FIHRCNT5	EQU		IHRCNT.5
;		FIHRCNT4	EQU		IHRCNT.4
;		FIHRCNT3	EQU		IHRCNT.3
;		FIHRCNT2	EQU		IHRCNT.2
;		FIHRCNT1	EQU		IHRCNT.1
;		FIHRCNT0	EQU		IHRCNT.0				

	CALIHRCH		EQU			0xBC		;Internal High clock frequency setting register 1
		FCALSTART	EQU		CALIHRCH.7	;Start IHRC calibration
		FTC1CALCKS	EQU		CALIHRCH.6
		FCALIHRCH2 	EQU		CALIHRCH.2
		FCALIHRCH1	EQU		CALIHRCH.1
		FCALIHRCH0	EQU		CALIHRCH.0

	CALIHRCL		EQU			0xBD		;Internal High clock frequency setting register 2
		FCALIHRCL5 	EQU		CALIHRCL.5
		FCALIHRCL4	EQU		CALIHRCL.4
		FCALIHRCL3	EQU		CALIHRCL.3
		FCALIHRCL2 	EQU		CALIHRCL.2
		FCALIHRCL1	EQU		CALIHRCL.1
		FCALIHRCL0	EQU		CALIHRCL.0


	PEDGE		EQU			0xBF

		FPEDGEN EQU		PEDGE.7
		FP00G0	EQU		PEDGE.3
		FP00G1	EQU		PEDGE.4
	P1W			EQU_W		0C0H

		FP15W	EQU_W		P1W.5
		FP14W	EQU_W		P1W.4
		FP13W	EQU_W		P1W.3
		FP12W	EQU_W		P1W.2
		FP11W	EQU_W		P1W.1
		FP10W	EQU_W		P1W.0

	P1M			EQU		0xC1

		FP15M	EQU		P1M.5
		FP14M	EQU		P1M.4
		FP13M	EQU		P1M.3
		FP12M	EQU		P1M.2
		FP11M	EQU		P1M.1
		FP10M	EQU		P1M.0


	P4M			EQU		0C4H
		FP43M	EQU		P4M.3
		FP42M	EQU		P4M.2
		FP41M	EQU		P4M.1
		FP40M	EQU		P4M.0


	P5M			EQU		0C5H

		FP56M	EQU		P5M.6
		FP55M	EQU		P5M.5
		FP54M	EQU		P5M.4
		FP53M	EQU		P5M.3
		FP52M	EQU		P5M.2
		FP51M	EQU		P5M.1
		FP50M	EQU		P5M.0
	
	INTRQ		EQU		0C8H
		FTC1IRQ	EQU	INTRQ.6
		FTC0IRQ	EQU	INTRQ.5
		FT0IRQ	EQU	INTRQ.4
	;;	FSIOIRQ	EQU	INTRQ.3
	;;	FP02IRQ	EQU	INTRQ.2
	;;	FP01IRQ	EQU	INTRQ.1
	;;	FP00IRQ	EQU	INTRQ.0

	INTEN		EQU		0C9H
		FTC1IEN	EQU	INTEN.6
		FTC0IEN	EQU	INTEN.5
		FT0IEN	EQU	INTEN.4
	;;	FSIOIEN	EQU	INTEN.3
	;;	FP02IEN	EQU	INTEN.2
	;;	FP01IEN	EQU	INTEN.1
	;;	FP00IEN	EQU	INTEN.0

	OSCM		EQU			0xCA
		FWTCKS	EQU	OSCM.7
		FWDRST	EQU	OSCM.6
		FWDRATE	EQU	OSCM.5
		FCPUM1	EQU	OSCM.4
		FCPUM0	EQU	OSCM.3
		FCLKMD	EQU	OSCM.2
		FSTPHX	EQU	OSCM.1
	;	FHXUP	EQU	OSCM.0

	TC0R		EQU_W			0xCD

	PCL			EQU		0xCE
	PCH			EQU		0xCF


	P1			EQU		0xD1
		
		FP15	EQU		P1.5
		FP14	EQU		P1.4
		FP13	EQU		P1.3
		FP12	EQU		P1.2
		FP11	EQU		P1.1
		FP10	EQU		P1.0

	P4			EQU		0xD4

		FP43	EQU		P4.3
		FP42	EQU		P4.2
		FP41	EQU		P4.1
		FP40	EQU		P4.0

	P5			EQU		0xD5

		FP56	EQU		P5.6
		FP55	EQU		P5.5
		FP54	EQU		P5.4
		FP53	EQU		P5.3
		FP52	EQU		P5.2
		FP51	EQU		P5.1
		FP50	EQU		P5.0



	T0M			EQU		0xD8
		FT0ENB		EQU	T0M.7
		FT0RATE2	EQU	T0M.6
		FT0RATE1	EQU	T0M.5
		FT0RATE0	EQU	T0M.4
		FTC1X8		EQU	T0M.3
		FTC0X8		EQU	T0M.2
		FTC0GN		EQU	T0M.1
		FT0TB		EQU	T0M.0

	T0C			EQU		0xD9

	TC0M		EQU			0DAH
		FTC0ENB		EQU	TC0M.7
		FTC0RATE2	EQU	TC0M.6
		FTC0RATE1	EQU	TC0M.5
		FTC0RATE0	EQU	TC0M.4
		FTC0CKS		EQU	TC0M.3
		FALOAD0		EQU	TC0M.2
		FTC0OUT		EQU	TC0M.1
		FPWM0OUT	EQU	TC0M.0

	TC0C		EQU			0xDB

	TC1M		EQU			0xDC
		FTC1ENB		EQU	TC1M.7
		FTC1RATE2	EQU	TC1M.6
		FTC1RATE1	EQU	TC1M.5
		FTC1RATE0	EQU	TC1M.4
		FTC1CKS		EQU	TC1M.3
		FALOAD1		EQU	TC1M.2
		FTC1OUT		EQU	TC1M.1
		FPWM1OUT	EQU	TC1M.0

	TC1C		EQU			0xDD
	TC1R		EQU_W			0xDE

	STKP		EQU			0xDF
		FGIE	EQU		STKP.7
		FSTKPB3	EQU		STKP.3
		FSTKPB2	EQU		STKP.2
		FSTKPB1	EQU		STKP.1
		FSTKPB0	EQU		STKP.0



	P1UR		EQU_W			0xE1
		FP15R	EQU_W	P1UR.5
		FP14R	EQU_W	P1UR.4
		FP13R	EQU_W	P1UR.3
		FP12R	EQU_W	P1UR.2
		FP11R	EQU_W	P1UR.1
		FP10R	EQU_W	P1UR.0

	P4UR		EQU_W			0xE4
		FP43R	EQU_W	P4UR.3
		FP42R	EQU_W	P4UR.2
		FP41R	EQU_W	P4UR.1
		FP40R	EQU_W	P4UR.0

	P5UR		EQU_W			0xE5
		FP56R	EQU_W	P5UR.6
		FP55R	EQU_W	P5UR.5
		FP54R	EQU_W	P5UR.4
		FP53R	EQU_W	P5UR.3
		FP52R	EQU_W	P5UR.2
		FP51R	EQU_W	P5UR.1
		FP50R	EQU_W	P5UR.0

	@HL			EQU		0xE6
	DP0X			EQU		0xE6

	@YZ			EQU		0xE7
	DP1X			EQU		0xE7

	P1OC        	EQU_W     	0E9H
	    	FP10OC  EQU_W     	P1OC.0
            	FP11OC  EQU_W     	P1OC.1

	STK7L		EQU		0F0h
	STK7H		EQU		0F1h
	STK6L		EQU		0F2h
	STK6H		EQU		0F3h
	STK5L		EQU		0F4h
	STK5H		EQU		0F5h
	STK4L		EQU		0F6h
	STK4H		EQU		0F7h
	STK3L		EQU		0F8h
	STK3H		EQU		0F9h
	STK2L		EQU		0FAh
	STK2H		EQU		0FBh
	STK1L		EQU		0FCh
	STK1H		EQU		0FDh
	STK0L		EQU		0FEh
	STK0H		EQU		0FFh


  

;;*************************************************************
; For simulation use 
; ICE connect to EV Board
;;*************************************************************
	
IF ICE_Mode==1


		P3M			EQU		0xC3
			FP37M	EQU		P3M.7
			FP36M	EQU		P3M.6
			FP35M	EQU		P3M.5
			FP34M	EQU		P3M.4
			FP33M	EQU		P3M.3
			FP32M	EQU		P3M.2
			FP31M	EQU		P3M.1
			FP30M	EQU		P3M.0
		P3			EQU		0xD3
			FP37	EQU		P3.7
			FP36	EQU		P3.6
			FP35	EQU		P3.5
			FP34	EQU		P3.4
			FP33	EQU		P3.3
			FP32	EQU		P3.2
			FP31	EQU		P3.1
			FP30	EQU		P3.0

		P3UR		EQU_W			0xE3
			FP37R	EQU_W	P3UR.7
			FP36R	EQU_W	P3UR.6
			FP35R	EQU_W	P3UR.5
			FP34R	EQU_W	P3UR.4
			FP33R	EQU_W	P3UR.3
			FP32R	EQU_W	P3UR.2
			FP31R	EQU_W	P3UR.1
			FP30R	EQU_W	P3UR.0

ENDIF


.TEXT
{

	//{{SONIX_SMOV_S8KD
	-1 -1 -1 -1 -1 -1 -1 -1   -1 -1 -1 -1 -1 -1 -1 -1
	-1 -1 -1 -1 -1 -1 -1 -1   -1 -1 -1 -1 -1 -1 -1 -1
	-1 -1 -1 -1 -1 -1 -1 -1   -1 -1 -1 -1 -1 -1 -1 -1
	-1 -1 -1 -1 -1 -1 -1 -1   -1 -1 -1 -1 -1 -1 -1 -1
	-1 -1 -1 -1 -1 -1 -1 -1   -1 -1 -1 -1 -1 -1 -1 -1
	-1 -1 -1 -1 -1 -1 -1 -1   -1 -1 -1 -1 -1 -1 -1 -1
	-1 -1 -1 -1 -1 -1 -1 -1   -1 -1 -1 -1 -1 -1 -1 -1
	27 5A 00 8F -1 -1 -1 -1   -1 -1 -1 -1 -1 -1 -1 00
	-1 -1 -1 -1 -1 -1 C0 0F   -1 -1 -1 -1 -1 -1 -1 -1
	-1 -1 -1 -1 -1 -1 -1 -1   -1 -1 -1 -1 -1 -1 -1 -1
	-1 -1 -1 -1 -1 -1 -1 -1   -1 -1 -1 -1 -1 -1 -1 -1
	-1 -1 -1 10 00 -1 -1 -1   -1 -1 -1 -1 -1 -1 00 -1
	3F -1 -1 -1 -1 -1 -1 -1   -1 70 BD -1 -1 -1 -1 -1
	80 3F 00 FF 0F 7F 00 00   FF -1 07 -1 -1 -1 -1 08
	-1 -1 -1 -1 -1 -1 -1 -1   -1 -1 -1 -1 -1 -1 -1 -1
	-1 -1 -1 -1 -1 -1 -1 -1   -1 -1 -1 -1 -1 -1 -1 -1
	87 00 DF 7F -1 
	-1	

	0400 72 10 00
	0100 71 00 01 -1

	//}}SONIX_SMOV_S8KD

	//{{SONIX_OPTION_RULE
	

//	IF	High_Clk == RC
//	{
//		High_Clk/2		=	Enable
//	}


//	IF	High_Clk == 32K_X'tal
//	{
//		OSG			=	Enable
//	}

	ENDP
	//}}SONIX_OPTION_RULE
}

