;------------------------------------------------------------------------------
;  CHIP: SN8P1604A
;  Revision History:
;  V1.0  01/07/2002  First issue
;
;  Note: 
;       1.If no assigment means OTP_TYPE 1
;	  OTP_TYPE   1	;Security: scramble type
;	  OTP_TYPE   2	;Security: output high byte(code option),low byte = 0 
;
;	2. Assembly          OTP           MASK
;          CHIP SN8P1604A    SN8P1604A     SN8A1604A
;
; V2.0  05/21/2003  a. Delete SMOV table 02 D0 0F 07
;                   b. mark P0.2,P0.3
;  V3.0   04/03/2008  1. Add "RedWrt_FORMAT    1"  	
;------------------------------------------------------------------------------
.ASSEMBLY    RedWrt_FORMAT    1

.Assembly	INC_VER		3			;INC file version
.Assembly	ASM_FORMAT	1
.Assembly	RAM_Size	80h			;chip RAM size

.Assembly	INSTRUMENT	SN8P1604A

.Assembly	MASK_BODY_SIZE	0x1200			;ROM size of MASK type
.Assembly	OTP_BODY_SIZE	0x1000			;ROM size of OTP  type 
.Assembly	USER_ROM_SIZE	0x0FFF			;ROM size that user can program
.Assembly	OTP_TEST_SIZE	0x00A0			;OTP test code size
.Assembly	MASK_TEST_FILE	SN8A1604A		;Test code of MASK type
.Assembly	OTP_TEST_FILE	S87PB			;Test code of OTP  type
.Assembly	PGM_TYPE	2			;OTP Program Type 
.Assembly	MASK_TEST_CODE	0x3600, 0x9003, 0x0000, 0x908B
.Assembly	Port_Pins	2, 8, 8, 0, 0, 4	;I/O ports pins count
.Assembly	CHIP_ID		0x33
;;;/// Code Option Area
; Note: SN8P1604A OSG always enable, no code option is necessary

.Assembly	OPTION		0		Watch_Dog	Enable	Disable
.Assembly	OPTION		1		Low_Power	Enable	Disable
.Assembly	OPTION		2		Int_16K_RC	Always_ON  By_CPUM	
.Assembly	OPTION		3		Security	Enable	Disable
.Assembly	OPTION		4		High_Clk/2	Enable	Disable
.Assembly	OPTION		5		High_Clk	RC	32K_X'tal	12M_X'tal	4M_X'tal
.Assembly	OPTION		7		OSG		Enable	Disable  ;Body test only
.Assembly	OPTION		8 : 15	Fix_High
.Assembly	OPTION		2ffh			;Code option select window type
;Code option conver from OTP to MASK ;for SN8P1604A
;Note Rst_P0.3 OPTION of SN8A1604A is bit 8
.Assembly	OTP2MSK		0xFFFF, 0x000A, 0x0000	
				;AND    OR      XOR     Bit1 to 8

;;;/// System RAM Area
	R			EQU		0x82
	Z			EQU		0x83
	Y			EQU		0x84
	PFLAG		EQU		0x86
		FZ		EQU		0x86.0
		FDC		EQU		0x86.1
		FC		EQU		0x86.2
;		FNPD	EQU_R	0x86.6			;Body test only
;		FNT0	EQU_R	0x86.7			;Body test only

	PUR			EQU_W	0BEH
		FPUR5	EQU_W	PUR.5
		FPUR2	EQU_W	PUR.2
		FPUR1	EQU_W	PUR.1
		FPUR0	EQU_W	PUR.0

	PEDGE		EQU		0BFH
		FPEDGEN	EQU		PEDGE.7
		FP00G1	EQU		PEDGE.4
		FP00G0	EQU		PEDGE.3


	P1W			EQU_W	0C0H
		FP17W	EQU_W	P1W.7
		FP16W	EQU_W	P1W.6
		FP15W	EQU_W	P1W.5
		FP14W	EQU_W	P1W.4
		FP13W	EQU_W	P1W.3
		FP12W	EQU_W	P1W.2
		FP11W	EQU_W	P1W.1
		FP10W	EQU_W	P1W.0

	P1M			EQU		0C1H
		FP17M	EQU		P1M.7
		FP16M	EQU		P1M.6
		FP15M	EQU		P1M.5
		FP14M	EQU		P1M.4
		FP13M	EQU		P1M.3
		FP12M	EQU		P1M.2
		FP11M	EQU		P1M.1
		FP10M	EQU		P1M.0

	P2M			EQU		0C2H
		FP27M	EQU		P2M.7
		FP26M	EQU		P2M.6
		FP25M	EQU		P2M.5
		FP24M	EQU		P2M.4
		FP23M	EQU		P2M.3
		FP22M	EQU		P2M.2
		FP21M	EQU		P2M.1
		FP20M	EQU		P2M.0

	P5M			EQU		0C5H
		FP53M	EQU		P5M.3
		FP52M	EQU		P5M.2
		FP51M	EQU		P5M.1
		FP50M	EQU		P5M.0

	INTRQ		EQU		0C8H
		FTC1IRQ	EQU	INTRQ.6
		FP00IRQ	EQU	INTRQ.0

	INTEN		EQU		0C9H
		FTC1IEN	EQU	INTEN.6
		FP00IEN	EQU	INTEN.0

	OSCM		EQU		0CAH
	.W_LIMIT        0x00,0x80	;bit 7= low
;		FWTCKS	EQU	OSCM.7	;match to SN8A1604A
		FWDRST	EQU	OSCM.6
		FCPUM0	EQU	OSCM.3
		FCLKMD	EQU	OSCM.2
		FSTPHX	EQU	OSCM.1

	PCL			EQU		0CEH
	PCH			EQU		0CFH

	P0			EQU_R	0D0H
;	    FP03	EQU_R   P0.3
;		FP02	EQU_R	P0.2	
		FP01	EQU_R	P0.1
		FP00	EQU_R	P0.0

	P1			EQU		0D1H
		FP17	EQU		P1.7
		FP16	EQU		P1.6
		FP15	EQU		P1.5
		FP14	EQU		P1.4
		FP13	EQU		P1.3
		FP12	EQU		P1.2
		FP11	EQU		P1.1
		FP10	EQU		P1.0

	P2			EQU		0D2H
		FP27	EQU		P2.7
		FP26	EQU		P2.6
		FP25	EQU		P2.5
		FP24	EQU		P2.4
		FP23	EQU		P2.3
		FP22	EQU		P2.2
		FP21	EQU		P2.1
		FP20	EQU		P2.0

	P5			EQU		0D5H
		FP53	EQU		P5.3
		FP52	EQU		P5.2
		FP51	EQU		P5.1
		FP50	EQU		P5.0

	TC1M		EQU		0DCH
	.W_LIMIT        0x00,0x08	;bit 3=low	
		FTC1ENB		EQU	TC1M.7
		FTC1RATE2	EQU	TC1M.6
		FTC1RATE1	EQU	TC1M.5
		FTC1RATE0	EQU	TC1M.4
;		FTC1CKS		EQU	TC1M.3 ;match to SN8A1604A
		FALOAD1		EQU	TC1M.2
		FTC1OUT		EQU	TC1M.1
		FPWM1OUT	EQU	TC1M.0

	TC1C		EQU		0DDH

	TC1R		EQU_W	0DEH

	STKP		EQU		0DFH
		FGIE	EQU		STKP.7
		FSTKPB3	EQU		STKP.3		
		FSTKPB2	EQU		STKP.2
		FSTKPB1	EQU		STKP.1
		FSTKPB0	EQU		STKP.0

	@YZ			EQU		0E7H
	DP1X		EQU		0E7H

; Both SN8P1604A and SN8A1604A have 8 level stack buffer
; But only show 4 level stack in datasheet.
; Note: SN8P1604 only has 4 level stack

	STK7L		EQU		0F0h
	STK7H		EQU		0F1h
	STK6L		EQU		0F2h
	STK6H		EQU		0F3h
	STK5L		EQU		0F4h
	STK5H		EQU		0F5h
	STK4L		EQU		0F6h
	STK4H		EQU		0F7h
	STK3L		EQU		0F8h
	STK3H		EQU		0F9h
	STK2L		EQU		0FAh
	STK2H		EQU		0FBh
	STK1L		EQU		0FCh
	STK1H		EQU		0FDh
	STK0L		EQU		0FEh
	STK0H		EQU		0FFh

; @SET_PUR macro will maintain the compatibility of PUR (MASK) and PnUR (OTP).
; If you want to set pull-up register in MASK, use @SET_PUR macro to replace 
; setting PUR register.

	@SET_PUR	macro	val

		IF	val !& 0D8h
			ERROR	@SET_PUR value error, valid value is 00X0-0XXX
			exitm
		ENDIF

		mov		a, #val
		DC		0x2FBE		; B0MOV	PUR, A

		endm

;;;///SMOV Table Area
.TEXT
{
	//{{SONIX_SMOV_S8KD
	-1 -1 -1 -1 -1 -1 -1 -1   -1 -1 -1 -1 -1 -1 -1 -1
	-1 -1 -1 -1 -1 -1 -1 -1   -1 -1 -1 -1 -1 -1 -1 -1
	-1 -1 -1 -1 -1 -1 -1 -1   -1 -1 -1 -1 -1 -1 -1 -1
	-1 -1 -1 -1 -1 -1 -1 -1   -1 -1 -1 -1 -1 -1 -1 -1
	-1 -1 -1 -1 -1 -1 -1 -1   -1 -1 -1 -1 -1 -1 -1 -1
	-1 -1 -1 -1 -1 -1 -1 -1   -1 -1 -1 -1 -1 -1 -1 -1
	-1 -1 -1 -1 -1 -1 -1 -1   -1 -1 -1 -1 -1 -1 -1 -1
	0F 08 01 8F -1 -1 -1 -1   -1 -1 -1 -1 -1 -1 -1 00
	-1 -1 -1 -1 -1 -1 C0 00   -1 -1 -1 -1 -1 -1 -1 -1
	-1 -1 -1 -1 -1 -1 -1 -1   -1 -1 -1 -1 -1 -1 -1 -1
	-1 -1 -1 -1 -1 -1 -1 -1   -1 -1 -1 -1 -1 -1 -1 -1
	-1 -1 -1 00 00 -1 -1 -1   -1 -1 -1 -1 -1 -1 27 -1
	00 -1 -1 -1 -1 -1 -1 -1   -1 41 8C -1 -1 -1 -1 -1
	83 FF FF 00 00 0F 00 00   00 -1 00 -1 -1 -1 -1 08
	-1 -1 -1 -1 -1 -1 -1 -1   -1 -1 -1 -1 -1 -1 -1 -1
	-1 -1 -1 -1 -1 -1 -1 -1   -1 -1 -1 -1 -1 -1 -1 -1
	87 00 DF 7F -1	
	-1	
	0001 71 00 01 
	0004 72 10 00
	-1	
	//}}SONIX_SMOV_S8KD	

	//{{SONIX_OPTION_RULE
	IF	High_Clk == RC
	{
		High_Clk/2	=	Enable
	}

	IF	High_Clk == 32K_X'tal
	{
		OSG			=	Enable
	}

	ENDP
	//}}SONIX_OPTION_RULE
}
