
;------------------------------------------------------------------------------
;  CHIP: SN8P1602B
;  Revision History:
;  V1.0  20/05/2003  First issue
;  V3.0  07/28/2003  Force Digital_Filter Disable in RC mode, enable in others
;  V4.0  08/20/2003  Change OTP_TEST_FILE to S83PC (odl one is "SN83P" will cause the DW complier error)
;  V5.0  11/13/2003  a. SMOV table: Change 0x7F from 00 to 01
;                       Enable TC0 event counter function 
;  V6.0   04/03/2008  1. Add "RedWrt_FORMAT    1"  	
;------------------------------------------------------------------------------
.ASSEMBLY    RedWrt_FORMAT    1

.Assembly	INC_VER		6
.Assembly	ASM_FORMAT	1
.Assembly	RAM_Size	48

.Assembly	INSTRUMENT	SN8P1602B

.Assembly	MASK_BODY_SIZE	0x600
.Assembly	OTP_BODY_SIZE	0x400
.Assembly	USER_ROM_SIZE	0x3FF
.Assembly	OTP_TEST_SIZE	0x0A0
.Assembly	PGM_TYPE	4

.Assembly	MASK_TEST_FILE	SN8A1602A

;Note: If OTP_TEST_FILE = SN83P or SN87P will have following DW limitation:
;      If high byte = 0 then the bit 0 and bit 1 of low byte must be zero
;
.Assembly	OTP_TEST_FILE	S83PC
.Assembly	MASK_TEST_CODE	0x3600, 0x8403, 0x0000, 0x8476
.Assembly	Port_Pins	1, 5, 8
.Assembly	COMMAND		SJMP, RETLW, SCALL
.Assembly	CHIP_ID		0x34

.Assembly	OPTION		0		Watch_Dog	Enable		Disable
.Assembly	OPTION		1		Fix_High	;Rd_POR_LVD	Enable	Disable
.Assembly	OPTION		2		Int_16K_RC	Always_ON	By_CPUM
.Assembly	OPTION		3		Security	Enable		Disable
.Assembly	OPTION		4		High_Clk/2	Enable		Disable
.Assembly	OPTION		5		High_Clk	RC	32K_X'tal	12M_X'tal	4M_X'tal
.Assembly	OPTION		7		OSG		Enable	Disable
.Assembly	OPTION		8		Noise_Filter	Enable	Disable
.Assembly	OPTION		9		Fix_High	;WDRST_Addr	0xCC.6	OSCM.6
.Assembly	OPTION		10		Fix_High
.Assembly	OPTION		11		Fix_High	;Fhosc/2	Enable	Disable
.Assembly	OPTION		12		Fix_Low		;WDRST_Type	Enable(pulse)	Disable(register)
.Assembly	OPTION		13		Fix_High	;Stop1_Type	Enable	Disable
.Assembly	OPTION		14		Low_Power	X	Enable	X	Disable	;Phase_Select	8_Phase	1_Phase	4_Phase	6_Phase
.Assembly	OPTION		2ffh
				    
	R			EQU		0x82
	Z			EQU		0x83
	Y			EQU		0x84
	PFLAG		EQU		0x86
		FZ		EQU		0x86.0
		FDC		EQU		0x86.1
		FC		EQU		0x86.2
		FNPD	EQU		0x86.6
		FNT0	EQU		0x86.7

;	RESETWT		EQU		88H

	PUR			EQU_W	0BEH
		FPUR2	EQU_W	PUR.2
		FPUR1	EQU_W	PUR.1
		FPUR0	EQU_W	PUR.0

	PEDGE		EQU		0BFH
		FPEDGEN	EQU		PEDGE.7
		FP00G1	EQU		PEDGE.4
		FP00G0	EQU		PEDGE.3

	P1W			EQU_W		0C0H
		FP14W	EQU_W		P1W.4
		FP13W	EQU_W		P1W.3
		FP12W	EQU_W		P1W.2
		FP11W	EQU_W		P1W.1
		FP10W	EQU_W		P1W.0

	P1M			EQU		0C1H
		FP14M	EQU		P1M.4
		FP13M	EQU		P1M.3
		FP12M	EQU		P1M.2
		FP11M	EQU		P1M.1
		FP10M	EQU		P1M.0

	P2M			EQU		0C2H
		FP27M	EQU		P2M.7
		FP26M	EQU		P2M.6
		FP25M	EQU		P2M.5
		FP24M	EQU		P2M.4
		FP23M	EQU		P2M.3
		FP22M	EQU		P2M.2
		FP21M	EQU		P2M.1
		FP20M	EQU		P2M.0

	INTRQ		EQU		0C8H
		FTC0IRQ	EQU	INTRQ.5
		FP00IRQ	EQU	INTRQ.0

	INTEN		EQU		0C9H
		FTC0IEN	EQU	INTEN.5
		FP00IEN	EQU	INTEN.0

	OSCM		EQU		0CAH
		FWTCKS	EQU	OSCM.7
		FWDRST	EQU	OSCM.6
		FCPUM1	EQU	OSCM.4
		FCPUM0	EQU	OSCM.3
		FCLKMD	EQU	OSCM.2
		FSTPHX	EQU	OSCM.1

	PCL			EQU		0CEH
	PCH			EQU		0CFH

	P0			EQU_R	0D0H
		FP00	EQU_R	P0.0

	P1			EQU		0D1H
		FP14	EQU		P1.4
		FP13	EQU		P1.3
		FP12	EQU		P1.2
		FP11	EQU		P1.1
		FP10	EQU		P1.0

	P2			EQU		0D2H
		FP27	EQU		P2.7
		FP26	EQU		P2.6
		FP25	EQU		P2.5
		FP24	EQU		P2.4
		FP23	EQU		P2.3
		FP22	EQU		P2.2
		FP21	EQU		P2.1
		FP20	EQU		P2.0

	T0M			EQU		0D8H
		FTC0GN	EQU		T0M.1

	TC0M		EQU		0DAH
		FTC0ENB		EQU	TC0M.7
		FTC0RATE2	EQU	TC0M.6
		FTC0RATE1	EQU	TC0M.5
		FTC0RATE0	EQU	TC0M.4
		FTC0CKS		EQU	TC0M.3

	TC0C		EQU		0DBH

	STKP		EQU		0DFH
		FGIE	EQU		STKP.7
		FSTKPB2	EQU		STKP.2
		FSTKPB1	EQU		STKP.1
		FSTKPB0	EQU		STKP.0

	@YZ			EQU		0E7H
	DP1X		EQU		0E7H

	STK3L		EQU		0F8h
	STK3H		EQU		0F9h
	STK2L		EQU		0FAh
	STK2H		EQU		0FBh
	STK1L		EQU		0FCh
	STK1H		EQU		0FDh
	STK0L		EQU		0FEh
	STK0H		EQU		0FFh


; @SET_PUR macro will maintain the compatibility of PUR (MASK) and PnUR (OTP).
; If you want to set pull-up register in MASK, use @SET_PUR macro to replace 
; setting PUR register.

	@SET_PUR	macro	val

		IFB	<val>
			mov	a, #0x7
			DC		0x2FBE		; B0MOV	PUR, A
			exitm
		ENDIF

		IF	val > 7
			ERROR	@SET_PUR value error, valid value is 0 ~ 7
			exitm
		ENDIF

		mov		a, #val
		DC		0x2FBE		; B0MOV	PUR, A

		endm

.TEXT
{
	//{{SONIX_SMOV_S8KD
	-1 -1 -1 -1 -1 -1 -1 -1   -1 -1 -1 -1 -1 -1 -1 -1
	-1 -1 -1 -1 -1 -1 -1 -1   -1 -1 -1 -1 -1 -1 -1 -1
	-1 -1 -1 -1 -1 -1 -1 -1   -1 -1 -1 -1 -1 -1 -1 -1
	-1 -1 -1 -1 -1 -1 -1 -1   -1 -1 -1 -1 -1 -1 -1 -1
	-1 -1 -1 -1 -1 -1 -1 -1   -1 -1 -1 -1 -1 -1 -1 -1
	-1 -1 -1 -1 -1 -1 -1 -1   -1 -1 -1 -1 -1 -1 -1 -1
	-1 -1 -1 -1 -1 -1 -1 -1   -1 -1 -1 -1 -1 -1 -1 -1
	02 08 01 8F -1 -1 -1 -1   -1 -1 -1 -1 -1 -1 -1 01
	-1 -1 -1 -1 -1 -1 C0 20   -1 -1 -1 -1 -1 -1 -1 -1
	-1 -1 -1 -1 -1 -1 -1 -1   -1 -1 -1 -1 -1 -1 -1 -1
	-1 -1 -1 -1 -1 -1 -1 -1   -1 -1 -1 -1 -1 -1 -1 -1
	-1 -1 -1 00 00 -1 -1 -1   -1 -1 -1 -1 -1 -1 07 -1
	1F -1 -1 -1 -1 -1 -1 -1   -1 21 9C -1 -1 -1 -1 -1
	81 0F FF 00 00 00 00 00   02 -1 00 -1 -1 -1 -1 00
	-1 -1 -1 -1 -1 -1 -1 -1   -1 -1 -1 -1 -1 -1 -1 -1
	-1 -1 -1 -1 -1 -1 -1 -1   -1 -1 -1 -1 -1 -1 -1 -1
	87 00 DF 7F -1 -1
	0001 71 00 01 
	0004 72 10 00
	0060 D1 10 00 00 00 -1
	//}}SONIX_SMOV_S8KD
	
		//{{SONIX_OPTION_RULE
	IF	High_Clk == RC
	{
		High_Clk/2		=	Enable
		Noise_Filter 	=	Disable
	}


	IF	High_Clk == 32K_X'tal
	{
		OSG				=	Enable
	}

	ENDP
	//}}SONIX_OPTION_RULE
}
