
;------------------------------------------------------------------------------
;  CHIP: SN8F29E39
;  Revision History
;  
;  V01   2014/02/12______First issue
;  V02   2014/03/12______Register Modify.;
;  V03   2014/03/19______Modify Code Option
;  V04	 2014/03/25______Modify 1. ADCM2; 2. Code Option format
;  V05   2014/04/17______Update Chip_ID	
;  V06   2014/04/21______Update FCPCKEN in ADCM3
;  V07   2014/04/23______Add PERAMH; Modify ISP Register Address
;  V08   2014/05/08______Modify Stack definition
;  V09   2014/05/22______Modify	USER_ROM_SIZE	
;  V10   2014/05/30______Update for new spec. Add Register
;  V11   2014/06/06______Add LCD_RAM Address definition
;  V12   2014/07/31______Modify PxUR setting, SEC/MIN setting
;  V13   2014/10/01______Update USER_ROM_SIZE to 0x7FF8
;  V14   2014/10/17______ADD information block to code option
;------------------------------------------------------------------------------
.Assembly	INC_VER		1
.ASSEMBLY	RedWrt_FORMAT   1
.Assembly	ASM_FORMAT	1
.Assembly	L_ROM_Size 	1
.Assembly	RAM_Size	6144

.Assembly	INSTRUMENT	SN8F29E39
.Assembly	BIT_FILE	SN8F29E39

.Assembly	OTP_BODY_SIZE	0x8000
.Assembly	USER_ROM_SIZE	0x7FF8
.Assembly	COMMAND		Enable_ORG4_7, EB_ICE, INFOR_PAGE_256WORD
.Assembly	PGM_TYPE	6
.Assembly	MASK_TEST_CODE	0x0000, 0x0000, 0x0000, 0x0000
.Assembly	Port_Pins	8, 8, 0, 6, 0, 8
.Assembly	LCD_Size 	32,4
.Assembly	CHIP_ID		0x9970

.Assembly	LCD_Start_Address	0x1F00

//Trim1AΩCP_trimmed code and FT_trimmed code]w
.Assembly	Infor_Trim1_CP_Adr	0x0100
.Assembly	Infor_Trim1_FT_Adr	0x0100
.Assembly	Infor_Trim1_TEMPVal 	0xFFC8
.Assembly	Infor_Trim1_Bit 	0x007C
.Assembly	CO_Trim1_Adr		0x7FFC
.Assembly	CO_Trim1_Bit		0, 6


;.Assembly	Infor_Trim2_Adr 	0x0100
;.Assembly	Infor_Trim2_Bit 	0x007F
;.Assembly	CO_Trim2_Adr		0x7FFC
;.Assembly	CO_Trim2_Bit		0, 6
;==============================================================================================================
; Code Option 0x7FFF
.Assembly	OPTION			0		Filter		Disable	Enable	
.Assembly	OPTION			1		Security	Enable	Disable
.Assembly	OPTION			2		High_Clk_DIV	x	Fhosc/2	Fhosc/4 Fhosc/8 
.Assembly	OPTION			4		Fix_High
.Assembly	OPTION		        5		High_Clk	IHRC	IHRC_RTC x x	
.Assembly	OPTION		        7		Fix_High
.Assembly	OPTION			8		Watch_Dog	x x x x x Enable x x x x Disable x x x x Always_On 
.Assembly	OPTION			12		NDT18		Disable HT_2mS 
.Assembly	OPTION			13		NDT33		Disable HT_2mS 
.Assembly	OPTION			14		Hold_time	4ms	2ms			
.Assembly	OPTION			15		Fix_High

; Code Option 0x7FFE
.Assembly	OPTION			16		Fix_Low
.Assembly	OPTION			17		Fix_High
.Assembly	OPTION			18		Fix_Low
.Assembly	OPTION			19		Fix_High
.Assembly	OPTION			20		Fix_High
.Assembly	OPTION			21		Fix_Low
.Assembly	OPTION			22		Fix_High
.Assembly	OPTION			23		Fix_Low
.Assembly	OPTION			24		Fix_Low
.Assembly	OPTION			25		Fix_High
.Assembly	OPTION			26		Fix_Low
.Assembly	OPTION			27 : 31		Fix_High

; Code Option 0x1FFD
.Assembly	OPTION			32 : 40		Fix_High ;(IHRC_CAL_Data)
.Assembly	OPTION			41 : 47		Fix_High

; Code Option 0x1FFC
;.Assembly	OPTION			48 : 50		Fix_High ; (LVD16_Trim_data)
.Assembly	OPTION			48 		Fix_Low	 ; (LVD16_Trim_data)
.Assembly	OPTION			49 		Fix_Low	 ; (LVD16_Trim_data)
.Assembly	OPTION			50 		Fix_High ; (LVD16_Trim_data)

.Assembly	OPTION			51 : 54		Fix_High ; (AVDDR_Trim_Data)
.Assembly	OPTION			55 : 63		Fix_High

;==============================================================================================================

.Assembly	OPTION		2ffh

	L			EQU		080H
	H			EQU		081H
	R			EQU		082H
	Z			EQU		083H
	Y			EQU		084H
	X			EQU		085H

	PFLAG			EQU		086H
		FZ		EQU		PFLAG.0
		FDC		EQU		PFLAG.1
		FC		EQU		PFLAG.2

	RBANK			EQU		087H
		FRBNKS0		EQU		RBANK.0
		FRBNKS1		EQU		RBANK.1
		FRBNKS2		EQU		RBANK.2
		FRBNKS3		EQU		RBANK.3
		FRBNKS4		EQU		RBANK.4	

	W0			EQU		088H
	W1			EQU		089H
	W2			EQU		08AH
	W3			EQU		08BH
	W4			EQU		08CH
	W5			EQU		08DH
	W6			EQU		08EH
	W7			EQU		08FH

	VREG			EQU		090H
		FVREFS		EQU		VREG.0
		FAVDDRS0	EQU		VREG.2
		FAVDDRS1	EQU		VREG.3
		FAVDDREN	EQU		VREG.4
		FAVEN		EQU		VREG.5
		FACMEN		EQU		VREG.6
		FBGEN		EQU		VREG.7
		

	CHS			EQU		091H
		FMUXN0		EQU		CHS.0
		FMUXN1		EQU		CHS.1
		FMUXN2		EQU		CHS.2
		FMUXN3		EQU		CHS.3
		FMUXP0		EQU		CHS.4
		FMUXP1		EQU		CHS.5
		FMUXP2		EQU		CHS.6
		FMUXP3		EQU		CHS.7

	ADCM1			EQU		092H
		FADCEN		EQU		ADCM1.0
		FIRVS0		EQU		ADCM1.1
		FIRVS1		EQU		ADCM1.2
		FIRVS2		EQU		ADCM1.3
		FRVS		EQU		ADCM1.4
		FOSR0		EQU		ADCM1.5
		FOSR1		EQU		ADCM1.6
		FOSR2		EQU		ADCM1.7

	ADCM2			EQU		093H
		FDRDY		EQU		ADCM2.0
		FADGN0		EQU		ADCM2.1
		FADGN1		EQU		ADCM2.2
		FGR		EQU		ADCM2.3
		FGX		EQU		ADCM2.4
		FINREN		EQU		ADCM2.5
		FVDTEN		EQU		ADCM2.6
		FUGBEN		EQU		ADCM2.7

	ADCM3			EQU		094H
		FADCKS0		EQU		ADCM3.0
		FADCKS1		EQU		ADCM3.1
		FADCKS2		EQU		ADCM3.2
		FADCKINV	EQU		ADCM3.3
		FCPCSK0		EQU		ADCM3.5
		FCPCSK1		EQU		ADCM3.6
		FCPCKEN		EQU		ADCM3.7

	LBTM			EQU		095H
		FLBTEN		EQU		LBTM.0
		FLBTO		EQU		LBTM.1
		FLBTDEL0	EQU		LBTM.2
		FLBTDEL1	EQU		LBTM.3
		FLBTDEL2	EQU		LBTM.4
		FLBTDEL3	EQU		LBTM.5
		FP11IO		EQU		LBTM.6

	LEDM			EQU		096H
		FLED1EN		EQU		LEDM.0
		FLED2EN		EQU		LEDM.1
		FLED3EN		EQU		LEDM.2
		FLED4EN		EQU		LEDM.3
		FLEDPW0		EQU		LEDM.4
		FLEDPW1		EQU		LEDM.5
		FLEDIO		EQU		LEDM.6

	DAM			EQU		097H
		FDAF0		EQU		DAM.0
		FDAF1		EQU		DAM.1
		FDAF2		EQU		DAM.2
		FDAEN		EQU		DAM.7

	DABH			EQU		098H
		FDAB8		EQU		DABH.0
		FDAB9		EQU		DABH.1
		FDAB10		EQU		DABH.2
		FDAB11		EQU		DABH.3

	DABL			EQU		099H
		FDAB0		EQU		DABL.0
		FDAB1		EQU		DABL.1
		FDAB2		EQU		DABL.2
		FDAB3		EQU		DABL.3
		FDAB4		EQU		DABL.4
		FDAB5		EQU		DABL.5
		FDAB6		EQU		DABL.6
		FDAB7		EQU		DABL.7

	OPM1			EQU		09AH
		FOP1EN		EQU		OPM1.0
		FOP2EN@	EQU		OPM1.1
		FSW0		EQU		OPM1.2
		FSW1		EQU		OPM1.3
		FSW2		EQU		OPM1.4
		FSW3		EQU		OPM1.5
		FSW4		EQU		OPM1.6
		FSW5		EQU		OPM1.7

	OPM2			EQU		09BH
		FSW6		EQU		OPM2.0
		FSW7		EQU		OPM2.1
		FSW8		EQU		OPM2.2
		FSW9		EQU		OPM2.3
		FSW10		EQU		OPM2.4
		FSW11		EQU		OPM2.5

	ADCDH			EQU_R		09CH
	ADCDM			EQU_R		09DH
	ADCDL			EQU_R		09EH

	AMPM			EQU		09FH
		FAMPEN		EQU		AMPM.0
		FPCHPEN		EQU		AMPM.1
		FGS0		EQU		AMPM.2
		FGS1		EQU		AMPM.3
		FGS2		EQU		AMPM.4
	
		FBGRCHPEN	EQU		AMPM.6
		FBGRCMP		EQU		AMPM.7

	P0M			EQU		0A0H	
		FP00M		EQU		P0M.0
		FP01M		EQU		P0M.1
		FP02M		EQU		P0M.2
		FP03M		EQU		P0M.3
		FP04M		EQU		P0M.4
	        FP05M		EQU		P0M.5
	        FP06M		EQU		P0M.6	
	        FP07M		EQU		P0M.7

	P1M			EQU		0A1H
		FP10M		EQU		P1M.0
		FP11M		EQU		P1M.1
		FP12M		EQU		P1M.2
		FP13M		EQU		P1M.3
		FP14M		EQU		P1M.4
		FP15M		EQU		P1M.5
		FP16M		EQU		P1M.6
		FP17M		EQU		P1M.7
		
	P3M			EQU		0A2H
		FP30M		EQU		P3M.0
		FP31M		EQU		P3M.1
		FP32M		EQU		P3M.2
		FP33M		EQU		P3M.3
		FP34M		EQU		P3M.4
		FP35M		EQU		P3M.5
		
	P5M			EQU		0A3H
  		FP50M		EQU		P5M.0
  		FP51M		EQU		P5M.1		  		
  		FP52M		EQU		P5M.2
  		FP53M		EQU		P5M.3
  		FP54M		EQU		P5M.4
		FP55M		EQU		P5M.5
		FP56M		EQU		P5M.6
		FP57M		EQU		P5M.7

	P0UR       		EQU_W		0A4H
	    	FP00R  		EQU_W		P0UR.0
	    	FP01R  	 	EQU_W		P0UR.1
	    	FP02R   	EQU_W		P0UR.2		
	    	FP03R   	EQU_W		P0UR.3
	    	FP04R   	EQU_W		P0UR.4
	    	FP05R   	EQU_W		P0UR.5
	    	FP06R   	EQU_W		P0UR.6
	    	FP07R   	EQU_W		P0UR.7

	P1UR        		EQU_W		0A5H
	    	FP10R   	EQU_W		P1UR.0
	    	FP11R   	EQU_W		P1UR.1
	    	FP12R   	EQU_W		P1UR.2		
	    	FP13R   	EQU_W		P1UR.3
	    	FP14R   	EQU_W		P1UR.4
	    	FP15R   	EQU_W		P1UR.5
	    	FP16R   	EQU_W		P1UR.6
	    	FP17R   	EQU_W		P1UR.7

	P3UR        		EQU_W		0A6H
	    	FP30R   	EQU_W		P3UR.0
	    	FP31R   	EQU_W		P3UR.1
	    	FP32R   	EQU_W		P3UR.2		
	    	FP33R   	EQU_W		P3UR.3
	    	FP34R   	EQU_W		P3UR.4
	    	FP35R   	EQU_W		P3UR.5

    	P5UR      		EQU_W		0A7H
	    	FP50R   	EQU_W		P5UR.0
	    	FP51R   	EQU_W		P5UR.1
	    	FP52R   	EQU_W		P5UR.2		
	    	FP53R   	EQU_W		P5UR.3
	    	FP54R   	EQU_W		P5UR.4
	    	FP55R   	EQU_W		P5UR.5
	    	FP56R   	EQU_W		P5UR.6
	    	FP57R   	EQU_W		P5UR.7
  		
	P0			EQU 		0A8H	
		FP00		EQU 		P0.0
		FP01		EQU 		P0.1
		FP02		EQU 		P0.2
		FP03		EQU 		P0.3	
		FP04		EQU 		P0.4
	        FP05		EQU 		P0.5
	        FP06		EQU 		P0.6
	        FP07		EQU 		P0.7

	P1			EQU 		0A9H	
		FP10		EQU 		P1.0
		FP11		EQU 		P1.1
		FP12		EQU 		P1.2
		FP13		EQU 		P1.3	
		FP14		EQU 		P1.4
	        FP15		EQU 		P1.5
	        FP16		EQU 		P1.6
	        FP17		EQU 		P1.7

	P3			EQU 		0AAH	
		FP30		EQU 		P3.0
		FP31		EQU 		P3.1
		FP32		EQU 		P3.2
		FP33		EQU 		P3.3	
		FP34		EQU 		P3.4
	        FP35		EQU 		P3.5

	P5			EQU 		0ABH	
		FP50		EQU 		P5.0
		FP51		EQU 		P5.1
		FP52		EQU 		P5.2
		FP53		EQU 		P5.3	
		FP54		EQU 		P5.4
	        FP55		EQU 		P5.5
	        FP56		EQU 		P5.6
	        FP57		EQU 		P5.7

	P1W			EQU		0ACH
		FP10W		EQU		P1W.0
		FP11W		EQU		P1W.1
		FP12W		EQU		P1W.2
		FP13W		EQU		P1W.3
		FP14W		EQU		P1W.4
		FP15W		EQU		P1W.5
		FP16W		EQU		P1W.6
		FP17W		EQU		P1W.7
	
	LCDM1			EQU		0ADH
	
		FLCDRATE	EQU		LCDM1.1
		FLCDENB		EQU		LCDM1.2
		FLCDMODE	EQU		LCDM1.3
	
		FLCDBNK		EQU		LCDM1.5
		FP3SEG		EQU		LCDM1.6
		FLCDPENB	EQU		LCDM1.7

	LCDM2			EQU		0AEH
		FVCP0		EQU		LCDM2.0
		FVCP1		EQU		LCDM2.1
		FVCP2		EQU		LCDM2.2
		FDUTY0		EQU		LCDM2.3
		FDUTY1		EQU		LCDM2.4
		FBGM		EQU		LCDM2.5
		FVAR0		EQU		LCDM2.6
		FVAR1		EQU		LCDM2.7

	P2			EQU 		0AFH	
		FP20		EQU 		P2.0
		FP21		EQU 		P2.1
		FP22		EQU 		P2.2
		FP23		EQU 		P2.3	
	
       INTEN0			EQU		0B0H
		FP00IEN		EQU		INTEN0.0
		FP01IEN		EQU		INTEN0.1
		FUTXIEN		EQU		INTEN0.2
		FURXIEN		EQU		INTEN0.3
		FT0IEN		EQU		INTEN0.4
		FTC0IEN		EQU		INTEN0.5
		FTC1IEN		EQU		INTEN0.6
		FADCIEN		EQU		INTEN0.7

       INTEN1			EQU		0B1H
		FMSPIEN		EQU		INTEN1.0
		FT0MOD		EQU		INTEN1.1
 

       INTRQ0			EQU		0B2H
		FP00IRQ		EQU		INTRQ0.0
		FP01IRQ		EQU		INTRQ0.1
		FUTXIRQ		EQU		INTRQ0.2
		FURXIRQ		EQU		INTRQ0.3
		FT0IRQ		EQU		INTRQ0.4
		FTC0IRQ		EQU		INTRQ0.5
		FTC1IRQ		EQU		INTRQ0.6
		FADCIRQ		EQU		INTRQ0.7

       INTRQ1			EQU		0B3H
		FMSPIRQ		EQU		INTRQ1.0

	P2UR        		EQU_W		0B4H
	    	FP20R   	EQU_W		P2UR.0
	    	FP21R   	EQU_W		P2UR.1
	    	FP22R   	EQU_W		P2UR.2		
	    	FP23R   	EQU_W		P2UR.3

	P2M			EQU		0B5H
		FP20M		EQU		P2M.0
		FP21M		EQU		P2M.1
		FP22M		EQU		P2M.2
		FP23M		EQU		P2M.3


	OSCM			EQU		0B6H
		FSTPHX		EQU		OSCM.1
		FCLKMD		EQU		OSCM.2
		FCPUM0		EQU		OSCM.3
		FCPUM1		EQU		OSCM.4

	WDTR			EQU_W		0B7H
	PCH			EQU		0B8H
	PCL			EQU		0B9H

	STKP			EQU		0BAH
		FSTKPB0		EQU		STKP.0
		FSTKPB1		EQU		STKP.1
		FSTKPB2		EQU		STKP.2
		FSTKPB3		EQU		STKP.3		
		FGIE		EQU		STKP.7		
	
	PEDGE			EQU		0BBH	
		FP00G0		EQU		PEDGE.0	 
		FP00G1		EQU		PEDGE.1	
		FP01G0		EQU		PEDGE.2	
		FP01G1		EQU		PEDGE.3

	@HL			EQU		0BCH
	@YZ			EQU		0BDH
	
	SEC			EQU		0BEH
		SEC0		EQU		SEC.0	 
		SEC1		EQU		SEC.1	
		SEC2		EQU		SEC.2	
		SEC3		EQU		SEC.3
		SEC4		EQU		SEC.4
		SEC5		EQU		SEC.5

	MIN			EQU		0BFH	
		MIN0		EQU		MIN.0	 
		MIN1		EQU		MIN.1	
		MIN2		EQU		MIN.2	
		MIN3		EQU		MIN.3
		MIN4		EQU		MIN.4
		MIN5		EQU		MIN.5

	T0M			EQU		0C0H
		FT0TB	 	EQU  		T0M.0
		FTC0GN	 	EQU  		T0M.1
		FTC0X8	 	EQU  		T0M.2
		FTC1X8	 	EQU  		T0M.3
		FT0RATE0 	EQU  		T0M.4
		FT0RATE1 	EQU  		T0M.5
		FT0RATE2 	EQU  		T0M.6
		FT0ENB		EQU  		T0M.7

	T0C			EQU		0C1H

	TC0M			EQU		0C2H
		FPWM0OUT 	EQU  		TC0M.1
		FTC0CKS0 	EQU  		TC0M.2
		FTC0CKS1 	EQU  		TC0M.3
		FTC0RATE0 	EQU  		TC0M.4
		FTC0RATE1	EQU  		TC0M.5
		FTC0RATE2	EQU  		TC0M.6
		FTC0ENB		EQU  		TC0M.7
	
	TC0RL			EQU_W		0C3H
	TC0RH			EQU_W		0C4H
	TC0CL			EQU		0C5H
	TC0CH			EQU		0C6H
	TC0DL			EQU		0C7H
	TC0DH			EQU		0C8H

	TC1M			EQU		0C9H
		FPWM1OUT 	EQU  		TC1M.1
		FTC1CKS0 	EQU  		TC1M.2
		FTC1CKS1 	EQU  		TC1M.3
		FTC1RATE0 	EQU  		TC1M.4
		FTC1RATE1	EQU  		TC1M.5
		FTC1RATE2	EQU  		TC1M.6
		FTC1ENB		EQU  		TC1M.7

	TC1RL			EQU_W		0CAH
	TC1RH			EQU_W		0CBH
	TC1CL			EQU		0CCH
	TC1CH			EQU		0CDH
	TC1DL			EQU		0CEH
	TC1DH			EQU		0CFH

	MSPSTAT			EQU		0D0H
		FBF	 	EQU_R  		MSPSTAT.0
		FRED_WRT 	EQU_R  		MSPSTAT.2
		FS	 	EQU_R  		MSPSTAT.3
		FP	 	EQU_R  		MSPSTAT.4
		FD_A	 	EQU_R  		MSPSTAT.5
		FCKE	 	EQU  		MSPSTAT.6

	MSPM1			EQU		0D1H
		FMSPC	 	EQU  		MSPM1.0
		FMSPWK	 	EQU  		MSPM1.2
		FSLRXCKP 	EQU  		MSPM1.3
		FCKP	 	EQU  		MSPM1.4
		FMSPENB	 	EQU  		MSPM1.5
		FMSPOV	 	EQU  		MSPM1.6
		FWCOL	 	EQU  		MSPM1.7

	MSPM2			EQU		0D2H
		FSEN	 	EQU  		MSPM2.0
		FRSEN	 	EQU  		MSPM2.1
		FPEN	 	EQU  		MSPM2.2
		FRCEN	 	EQU  		MSPM2.3
		FACKEN	 	EQU  		MSPM2.4
		FACKDT	 	EQU  		MSPM2.5
		FACKSTAT 	EQU  		MSPM2.6
		FGCEN	 	EQU  		MSPM2.7

	MSPBUF			EQU		0D3H
	MSPADR			EQU		0D4H

	URTX			EQU		0D5H
		FUTXBZ	 	EQU  		URTX.2
		FURXBZ	 	EQU  		URTX.3
		FUTXBRK	 	EQU  		URTX.4
		FUTXPS	 	EQU  		URTX.5
		FUTXPEN	 	EQU  		URTX.6
		FUTXEN	 	EQU  		URTX.7

	URRX			EQU		0D6H
		FURS0	 	EQU  		URRX.0
		FURS1	 	EQU  		URRX.1
		FURS2	 	EQU  		URRX.2
		FUFMER	 	EQU  		URRX.3
		FURXPC	 	EQU  		URRX.4
		FURXPS	 	EQU  		URRX.5
		FURXPEN	 	EQU  		URRX.6
		FURXEN	 	EQU  		URRX.7

	URCR			EQU		0D7H
	UTXD			EQU		0D8H
	URXD			EQU		0D9H


	PECMD			EQU		0DAH
	PEROML			EQU		0DBH
	PEROMH			EQU		0DCH
	PERAML			EQU		0DDH
	PERAMH			EQU		0DEH
	PERAMCNT		EQU		0DFH


	


	STK0L			EQU		0E0H
	STK0H			EQU		0E1H
	STK1L			EQU		0E2H
	STK1H			EQU		0E3H
	STK2L			EQU		0E4H
	STK2H			EQU		0E5H
	STK3L			EQU		0E6H
	STK3H			EQU		0E7H
	STK4L			EQU		0E8H
	STK4H			EQU		0E9H
	STK5L			EQU		0EAH
	STK5H			EQU		0EBH
	STK6L			EQU		0ECH
	STK6H			EQU		0EDH
	STK7L			EQU		0EEH
	STK7H			EQU		0EFH
	STK8L			EQU		0F0H
	STK8H			EQU		0F1H
	STK9L			EQU		0F2H
	STK9H			EQU		0F3H
	STK10L			EQU		0F4H
	STK10H			EQU		0F5H
	STK11L			EQU		0F6H
	STK11H			EQU		0F7H
	STK12L			EQU		0F8H
	STK12H			EQU		0F9H
	STK13L			EQU		0FAH
	STK13H			EQU		0FBH
	STK14L			EQU		0FCH
	STK14H			EQU		0FDH
	STK15L			EQU		0FEH
	STK15H			EQU		0FFH


; -----------------------------------------------------
; Clear watchdog macro. 
;  
; Total Cycle: 2

	@RST_WDT	macro
		   MOV  A, #0x5A
		   B0MOV  WDTR, A
	endm
; -----------------------------------------------------
; Sleep Mode control macro for compatibility in S8KD-2 ICE
;  
; Total Cycle: 1

	SleepMode	macro	
		B0BSET	FCPUM0
	endm
; -----------------------------------------------------
; Green Mode control macro for compatibility in S8KD-2 ICE
;  
; Total Cycle: 3

	GreenMode	macro	
		B0BSET	FCPUM1
		NOP
		NOP
	endm
; -----------------------------------------------------
; Slow Mode control macro for compatibility in S8KD-2 ICE
;  
; Total Cycle: 2

	SlowMode	macro	
		B0BSET	FCLKMD
		B0BSET	FSTPHX
	endm
; -----------------------------------------------------
;  Slow mode to Normal Mode control macro for compatibility in S8KD-2 ICE
;  
; Total Cycle: 5

	Slow2Normal	macro	
		B0BCLR	FSTPHX
		NOP
		NOP
		NOP
		B0BCLR	FCLKMD
	endm
; -----------------------------------------------------		
.TEXT
{
	//{{SONIX_OPTION_RULE
        
	ENDP
	//}}SONIX_OPTION_RULE
}			  								