
;------------------------------------------------------------------------------
;  CHIP: SN8F27E93
;  Revision History
;  
;  V01   2010/06/18
;  V02	 2010/10/29
;				 Reserved ROM 0x3FF8~0x3FFB for unique code
;  
;  V03   2012/07/12  	1. Add "PCL_READ_LIMIT" Key word
;------------------------------------------------------------------------------
.ASSEMBLY RedWrt_FORMAT    1
.Assembly	INC_VER		3
.Assembly	ASM_FORMAT	1
.Assembly	RAM_Size	1024

.Assembly	INSTRUMENT	SN8F27E93
.Assembly	BIT_FILE	SN8F27E93

.Assembly	OTP_BODY_SIZE	0x4000
.Assembly	USER_ROM_SIZE	0x3FF8

.Assembly	MASK_TEST_CODE	0x0000, 0x0000, 0x0000, 0x0000

.Assembly	PGM_TYPE	6
.Assembly	CHIP_ID		0x2310
.Assembly	command		Enable_ORG4_7, RBANK_LIMIT, Enable_ISP, EB_ICE, PCL_READ_LIMIT
.Assembly	Port_Pins	7, 8, 0, 0, 8, 4

; Code Option 0x3FFF
.Assembly	OPTION		0		Noise_Filter	Disable Enable
.Assembly	OPTION		1		Security	Enable	Disable
.Assembly	OPTION		2		High_Fcpu		Fhosc/1 Fhosc/2 Fhosc/4 Fhosc/8 Fhosc/16 Fhosc/32 Fhosc/64 Fhosc/128
.Help
{
	High_Fcpu		: 	"Only Effective for HIGH Clock"
}
.Assembly	OPTION		5		High_Clk	IHRC_16M IHRC_RTC x x RC 32K_X'tal 12M_X'tal 4M_X'tal
.Help
{
	IHRC_16M	:	"Internal 16M RC Oscillator"
	IHRC_RTC	:	"Internal 16M RC Oscillator with RTC\nConnect 32768Hz crytal to XIN/XOUT"
	RC				:	"External RC Oscillator"
	32K_X'tal	:	"Crystal/Resonator: 32768hz"
	12M_X'tal	:	"Crystal/Resonator: 12~16Mhz"
	4M_X'tal	: "Crystal/Resonator: 4~8Mhz"
}
.Assembly	OPTION		8		Low_Fcpu	Flosc/1 Flosc/2 Flosc/4 Flosc/8
.Help
{
	Low_Fcpu	:	"Only Effective for Low Clock"
	Flosc/1		: "Slow mode clock = Flosc/1"
	Flosc/2		: "Slow mode clock = Flosc/2"
	Flosc/4		: "Slow mode clock = Flosc/4"
	Flosc/8		: "Slow mode clock = Flosc/8"
}
.Assembly	OPTION		10		Watch_Dog	Always_On x x x x Enable x x x x Disable x x x x x

;.Assembly	OPTION		14		Low_Power	Disable Enable
;.Help
;{
;	Disable		:	"Flash ROM Low Power Disable"
;	Enable		:	"Flash ROM Low Power Enable"
;}
.Assembly	OPTION		14		Fix_High

;.Assembly	OPTION		15		X'tal_Detect    Disable Enable
;.Help
;{
;	X'tal_Detect		:	"Only Effective for 4M/12M Code Option"
;}
.Assembly	OPTION		15		Fix_Low

; Code Option 0x3FFE
.Assembly	OPTION		16		Fix_Low
.Assembly	OPTION		17		Fix_High
.Assembly	OPTION		18		Fix_Low
.Assembly	OPTION		19		Fix_High
.Assembly	OPTION		20		Fix_High
.Assembly	OPTION		21		Fix_Low
.Assembly	OPTION		22		Fix_High
.Assembly	OPTION		23		Fix_Low
.Assembly	OPTION		24		Fix_Low
.Assembly	OPTION		25		Fix_High
.Assembly	OPTION		26		Fix_Low
.Assembly	OPTION		27		Fix_High
.Assembly	OPTION		28 : 31		Fix_High

; Code Option 0x3FFD
.Assembly	OPTION		32 		Fix_High
.Assembly	OPTION		33 		Fix_High
.Assembly	OPTION		34 		Fix_High
.Assembly	OPTION		35 		Fix_High
.Assembly	OPTION		36 		Fix_High
.Assembly	OPTION		37 		Fix_High
.Assembly	OPTION		38 		Fix_High
.Assembly	OPTION		39 		Fix_High
.Assembly	OPTION		40 		Fix_High
.Assembly	OPTION		41		LVD     	LVD_Max	LVD_H	LVD_M	LVD_L
.Help
{
	LVD_Max		:	"3.0V Reset"	
	LVD_H		:	"2.3V Reset\nEnable LVD30 bit of STKP for\n3.0V Low Voltage Indicator"	
	LVD_M		:	"1.8V Reset\nEnable LVD23 bit of STKP for\n2.3V Low Voltage Indicator"
	LVD_L		:	"1.8V Reset"
}

;.Assembly	OPTION		43		LVDB        No  2*ILRC
;.Help
;{
;	No		:	"No De-bounce Time"	
;	2*ILRC		:	"De-bounce Time 2*ILRC Clock"	
;}
.Assembly	OPTION		43 		Fix_Low

.Assembly	OPTION		44		Reset_Pin   P13 Reset

;.Assembly	OPTION		45		Rst_Length  	No 	128*ILRC
;.Help
;{
;	No		:	"No External Reset De-bounce Time"	
;	128*ILRC		:	"External Reset De-bounce Time 128*ILRC Clock"	
;}
.Assembly	OPTION		45 		Fix_High

.Assembly	OPTION		46 		WDT_CLK	Flosc/4 Flosc/8 Flosc/16 Flosc/32	
.Help
{
	Flosc/4		:	"Watchdog Pre-scaler Flosc/4"	
	Flosc/8		:	"Watchdog Pre-scaler Flosc/8"	
	Flosc/16	:	"Watchdog Pre-scaler Flosc/16"	
	Flosc/32	:	"Watchdog Pre-scaler Flosc/32"	
}

; Code Option 0x3FFC
;.Assembly	OPTION		48 		Hold_CK_Time	2ms 4ms 8ms 16ms
;.Help
;{
;	2ms		:	"Hold CK Time 2ms"
;	4ms		:	"Hold CK Time 4ms"
;	8ms		:	"Hold CK Time 8ms"
;	16ms		:	"Hold CK Time 16ms"
;}
.Assembly	OPTION		48		Fix_Low
.Assembly	OPTION		49		Fix_Low

.Assembly	OPTION		50		Hold_CK	Disable Enable

;.Assembly	OPTION		51		ROM_EnTime	30ns 40ns
;.Help
;{
;	30ns		:	"Flash ROM Enable Time 30ns"
;	40ns		:	"Flash ROM Enable Time 40ns"
;}
.Assembly	OPTION		51		Fix_High

;.Assembly	OPTION		52		URRX_AC	Disable Enable
;.Help
;{
;	Disable		:	"UART RX Auto Calibration Disable"
;	Enable		:	"UART RX Auto Calibration Enable"
;}
.Assembly	OPTION		52 		Fix_Low

.Assembly	OPTION		53 : 63 		Fix_High


.Assembly	OPTION		2ffh


	L			EQU		080H
	H			EQU		081H
	R			EQU		082H
	Z			EQU		083H
	Y			EQU		084H
	X			EQU		085H

	PFLAG		EQU		086H
		FPOR		EQU		PFLAG.7
		FWDT		EQU		PFLAG.6
		FRST		EQU		PFLAG.5
		FSTKOV	EQU		PFLAG.4
		FC			EQU		PFLAG.2
		FDC			EQU		PFLAG.1
		FZ			EQU		PFLAG.0

	RBANK		EQU		087H
		FRBNKS2	EQU		RBANK.2
		FRBNKS1	EQU		RBANK.1
		FRBNKS0	EQU		RBANK.0

	W0			EQU		088H
	W1			EQU		089H
	W2			EQU		08AH
	W3			EQU		08BH
	W4			EQU		08CH
	W5			EQU		08DH
	W6			EQU		08EH
	W7			EQU		08FH

	@HL			EQU		090H
	@YZ			EQU		091H

	PCL			EQU		093H
	PCH			EQU		094H

	OSCM		EQU		095H
		FCPUM1	EQU		OSCM.4
		FCPUM0	EQU		OSCM.3
		FCLKMD	EQU		OSCM.2
		FSTPHX	EQU		OSCM.1

	WDTR		EQU_W	096H

	INTRQ0		EQU		097H
		FADCIRQ	EQU		INTRQ0.7
		FT1IRQ	EQU		INTRQ0.6
		FTC0IRQ	EQU		INTRQ0.3	
		FT0IRQ  EQU		INTRQ0.2
		FP01IRQ	EQU		INTRQ0.1
		FP00IRQ	EQU		INTRQ0.0

	INTRQ1		EQU		098H
		FMSPIRQ	EQU		INTRQ1.4
		FUTXIRQ EQU		INTRQ1.3
		FURXIRQ EQU		INTRQ1.2                
		FSIOIRQ	EQU		INTRQ1.1
		FWAKEIRQ EQU		INTRQ1.0

	INTEN0		EQU		09AH
		FADCIEN EQU		INTEN0.7
		FT1IEN	EQU		INTEN0.6
		FTC0IEN	EQU		INTEN0.3		
		FT0IEN  EQU		INTEN0.2
		FP01IEN	EQU		INTEN0.1
		FP00IEN	EQU		INTEN0.0

	INTEN1		EQU		09BH                 
    FMSPIEN	EQU		INTEN1.4
		FUTXIEN EQU		INTEN1.3
		FURXIEN EQU		INTEN1.2
		FSIOIEN	EQU		INTEN1.1
		FWAKEIEN EQU		INTEN1.0

	P0OC		EQU	09CH
		FP04OC	EQU		P0OC.2
		FP03OC	EQU		P0OC.1
		FP02OC	EQU		P0OC.0

	P1W		EQU		09EH
		FP13W	EQU		P1W.3
		FP12W	EQU		P1W.2
		FP11W	EQU		P1W.1
		FP10W	EQU		P1W.0

	PEDGE		EQU		09FH		
		FP01G1	EQU		PEDGE.3
		FP01G0	EQU		PEDGE.2
		FP00G1	EQU		PEDGE.1
		FP00G0	EQU		PEDGE.0	  	

	P0M		EQU		0A0H
		FP07M	EQU		P0M.7
		FP06M	EQU		P0M.6
		FP05M	EQU		P0M.5		
		FP04M	EQU		P0M.4
		FP03M	EQU		P0M.3
		FP02M	EQU		P0M.2
		FP01M	EQU		P0M.1
		FP00M	EQU		P0M.0

	P1M		EQU		0A1H
		FP13M	EQU		P1M.3
		FP12M	EQU		P1M.2
		FP11M	EQU		P1M.1
		FP10M	EQU		P1M.0
		
	P4M		EQU		0A4H
		FP41M	EQU		P4M.1
		FP40M	EQU		P4M.0

	P0		EQU 	0A6H
		FP07	EQU 	P0.7
		FP06	EQU 	P0.6
		FP05	EQU 	P0.5		
		FP04	EQU 	P0.4
		FP03	EQU 	P0.3
		FP02	EQU 	P0.2
		FP01	EQU 	P0.1
		FP00	EQU 	P0.0

	P1		EQU 	0A7H
		FP13	EQU 	P1.3
		FP12	EQU 	P1.2
		FP11	EQU 	P1.1
		FP10	EQU 	P1.0
		
	P4		EQU		0AAH	
		FP41	EQU		P4.1
		FP40	EQU		P4.0

 	P0UR	EQU		0ACH
		FP07UR	EQU 	P0UR.7
		FP06UR	EQU 	P0UR.6
		FP05UR	EQU 	P0UR.5		
		FP04UR	EQU 	P0UR.4
		FP03UR	EQU 	P0UR.3
		FP02UR	EQU 	P0UR.2
		FP01UR	EQU 	P0UR.1
		FP00UR	EQU 	P0UR.0

	P1UR	EQU		0ADH
		FP13UR	EQU 	P1UR.3
		FP12UR	EQU 	P1UR.2
		FP11UR	EQU 	P1UR.1
		FP10UR	EQU 	P1UR.0
		
	P4UR	EQU		0B0H
		FP41UR			EQU		P4UR.1
		FP40UR			EQU		P4UR.0

	T0M		EQU		0B2H
		FT0ENB	 	EQU  	T0M.7
		FT0RATE2 	EQU  	T0M.6
		FT0RATE1 	EQU  	T0M.5
		FT0RATE0 	EQU  	T0M.4
		FT0TB	 		EQU  	T0M.0

	T0C		EQU		0B3H
		FT0C7	 		EQU  	T0C.7
		FT0C6	 		EQU  	T0C.6
		FT0C5	 		EQU  	T0C.5
		FT0C4	 		EQU  	T0C.4
		FT0C3	 		EQU  	T0C.3
		FT0C2	 		EQU  	T0C.2
		FT0C1	 		EQU  	T0C.1
		FT0C0	 		EQU  	T0C.0

	TC0M		EQU		0B4H
		FTC0ENB		EQU		TC0M.7
		FTC0RATE2	EQU		TC0M.6
		FTC0RATE1	EQU		TC0M.5
		FTC0RATE0	EQU		TC0M.4
		FTC0CKS1	EQU		TC0M.3
		FTC0CKS0 	EQU		TC0M.2
  	FPWM0OUT 	EQU 	TC0M.0
  	
	TC0C		EQU		0B5H	
		FTC0C7	 		EQU  	TC0C.7
		FTC0C6	 		EQU  	TC0C.6
		FTC0C5	 		EQU  	TC0C.5
		FTC0C4	 		EQU  	TC0C.4
		FTC0C3	 		EQU  	TC0C.3
		FTC0C2	 		EQU  	TC0C.2
		FTC0C1	 		EQU  	TC0C.1
		FTC0C0	 		EQU  	TC0C.0

	TC0R		EQU_W		0B6H
	
	TC0D		EQU		0B7H
		FTC0D7	 		EQU  	TC0D.7
		FTC0D6	 		EQU  	TC0D.6
		FTC0D5	 		EQU  	TC0D.5
		FTC0D4	 		EQU  	TC0D.4
		FTC0D3	 		EQU  	TC0D.3
		FTC0D2	 		EQU  	TC0D.2
		FTC0D1	 		EQU  	TC0D.1
		FTC0D0	 		EQU  	TC0D.0

	ADM2		EQU		0B9H
		FGCHS2		EQU		ADM2.7

	AIN2M		EQU		0BAH
		FAIN2M5		EQU		AIN2M.5
		FAIN2M4		EQU		AIN2M.4
		FAIN2M3		EQU		AIN2M.3
		FAIN2M2		EQU		AIN2M.2
		FAIN2M1		EQU		AIN2M.1
		FAIN2M0		EQU		AIN2M.0

	AIN3M		EQU		0BBH
		FAIN3M5		EQU		AIN3M.5
		FAIN3M4		EQU		AIN3M.4
		FAIN3M3		EQU		AIN3M.3
		FAIN3M2		EQU		AIN3M.2
		FAIN3M1		EQU		AIN3M.1
		FAIN3M0		EQU		AIN3M.0

	AIN4M		EQU		0BCH
		FAIN4M5		EQU		AIN4M.5
		FAIN4M4		EQU		AIN4M.4
		FAIN4M3		EQU		AIN4M.3
		FAIN4M2		EQU		AIN4M.2
		FAIN4M1		EQU		AIN4M.1
		FAIN4M0		EQU		AIN4M.0

	AIN5M		EQU		0BDH
		FAIN5M5		EQU		AIN5M.5
		FAIN5M4		EQU		AIN5M.4
		FAIN5M3		EQU		AIN5M.3
		FAIN5M2		EQU		AIN5M.2
		FAIN5M1		EQU		AIN5M.1
		FAIN5M0		EQU		AIN5M.0

	T1M		EQU		0C0H
		FT1ENB		EQU		T1M.7
		FT1RATE2	EQU		T1M.6
		FT1RATE1	EQU		T1M.5
		FT1RATE0	EQU		T1M.4		
		FT1CKS		EQU		T1M.3

	T1CL		EQU		0C1H
		FT1C7			EQU		T1CL.7
		FT1C6			EQU		T1CL.6
		FT1C5			EQU		T1CL.5
		FT1C4			EQU		T1CL.4
		FT1C3			EQU		T1CL.3
		FT1C2			EQU		T1CL.2
		FT1C1			EQU		T1CL.1
		FT1C0			EQU		T1CL.0
		
	T1CH		EQU		0C2H 
		FT1C15		EQU		T1CH.7
		FT1C14		EQU		T1CH.6
		FT1C13		EQU		T1CH.5
		FT1C12		EQU		T1CH.4
		FT1C11		EQU		T1CH.3
		FT1C10		EQU		T1CH.2
		FT1C9			EQU		T1CH.1
		FT1C8			EQU		T1CH.0

	P4CON		EQU		0C6H
		FP4CON1		EQU		P4CON.1
		FP4CON0		EQU		P4CON.0

	ADM		EQU		0C8H
		FADENB	  EQU		ADM.7
		FADS			EQU		ADM.6
		FEOC			EQU		ADM.5
		FGCHS			EQU		ADM.4
		FCHS1			EQU		ADM.1
		FCHS0			EQU		ADM.0

	ADB		EQU_R		0C9H
		FADB11    EQU_R   ADB.7
		FADB10    EQU_R		ADB.6		
		FADB9			EQU_R		ADB.5
		FADB8			EQU_R		ADB.4
		FADB7			EQU_R		ADB.3
		FADB6			EQU_R		ADB.2
		FADB5			EQU_R		ADB.1
		FADB4			EQU_R		ADB.0
				
	ADR		EQU		0CAH
		FADCKS1	  EQU			ADR.6
		FADCKS0  	EQU			ADR.5
		FADLEN	  EQU			ADR.4
		FADB3			EQU_R		ADR.3		
		FADB2			EQU_R		ADR.2	
		FADB1			EQU_R		ADR.1		
		FADB0			EQU_R		ADR.0	
	
	PECMD			EQU		0CCH
	PEROML		EQU		0CDH
	PEROMH		EQU		0CEH
	PERAML		EQU		0CFH
	PERAMCNT	EQU		0D0H

	SIOM			EQU		0D1H
		FSENB			EQU	SIOM.7
		FSTART		EQU	SIOM.6
		FSRATE1		EQU	SIOM.5
		FSRATE0		EQU	SIOM.4
		FMLSB			EQU	SIOM.3
		FSCKMD		EQU	SIOM.2
		FCPOL			EQU	SIOM.1
		FCPHA			EQU	SIOM.0

	SIOR			EQU_W		0D2H
	SIOB			EQU		0D3H

	SIOC			EQU		0D4H
		FSIOBZ		EQU		SIOC.2

	URTX			EQU		0D5H  
		FUTXEN		EQU		URTX.7
		FUTXPEN		EQU		URTX.6
		FUTXPS		EQU		URTX.5
		FUTXBRK		EQU		URTX.4
		FURXBZ		EQU		URTX.3
		FUTXBZ		EQU		URTX.2

	URRX			EQU		0D6H
		FURXEN		EQU		URRX.7
		FURXPEN		EQU		URRX.6
		FURXPS		EQU		URRX.5
		FURXPC		EQU		URRX.4
		FUFMER		EQU		URRX.3
		FURS2			EQU		URRX.2
		FURS1			EQU		URRX.1
		FURS0			EQU		URRX.0

	URCR			EQU		0D7H
	UTXD			EQU		0D8H
	URXD			EQU		0D9H
            
	MSPSTAT		EQU		0DAH
		FCKE			EQU		MSPSTAT.6
		FD_A			EQU		MSPSTAT.5
		FP				EQU		MSPSTAT.4
		FS				EQU		MSPSTAT.3
		FRED_WRT	EQU		MSPSTAT.2
		FBF				EQU		MSPSTAT.0
		
	MSPM1		EQU		0DBH
		FWCOL			EQU		MSPM1.7
		FMSPOV		EQU		MSPM1.6
		FMSPENB		EQU		MSPM1.5
		FCKP			EQU		MSPM1.4
		FSLRXCKP	EQU		MSPM1.3
		FMSPWK		EQU		MSPM1.2
		FMSPC			EQU		MSPM1.0
		
	MSPM2		EQU		0DCH
		FGCEN			EQU		MSPM2.7
		FACKSTAT	EQU		MSPM2.6
		FACKDT		EQU		MSPM2.5
		FACKEN		EQU		MSPM2.4
		FRCEN			EQU		MSPM2.3
		FPEN			EQU		MSPM2.2
		FRSEN			EQU		MSPM2.1
		FSEN			EQU		MSPM2.0
		
	MSPBUF		EQU		0DDH
		FMSPBUF7	EQU		MSPBUF.7
		FMSPBUF6	EQU		MSPBUF.6
		FMSPBUF5	EQU		MSPBUF.5
		FMSPBUF4	EQU		MSPBUF.4
		FMSPBUF3	EQU		MSPBUF.3
		FMSPBUF2	EQU		MSPBUF.2
		FMSPBUF1	EQU		MSPBUF.1
		FMSPBUF0	EQU		MSPBUF.0
		
	MSPADR		EQU		0DEH
		FMSPADR7	EQU		MSPADR.7
		FMSPADR6	EQU		MSPADR.6
		FMSPADR5	EQU		MSPADR.5
		FMSPADR4	EQU		MSPADR.4
		FMSPADR3	EQU		MSPADR.3
		FMSPADR2	EQU		MSPADR.2
		FMSPADR1	EQU		MSPADR.1
		FMSPADR0	EQU		MSPADR.0

	STKP		EQU		0DFH
		FGIE		EQU		STKP.7
		FLVD23	EQU		STKP.6
		FLVD30	EQU		STKP.5
		FSTKPB3	EQU		STKP.3
		FSTKPB2	EQU		STKP.2
		FSTKPB1	EQU		STKP.1
		FSTKPB0	EQU		STKP.0

	STKFL		EQU		0E0h
	STKFH		EQU		0E1h
	STKEL		EQU		0E2h
	STKEH		EQU		0E3h
	STKDL		EQU		0E4h
	STKDH		EQU		0E5h
	STKCL		EQU		0E6h
	STKCH		EQU		0E7h

	STKBL		EQU		0E8h
	STKBH		EQU		0E9h
	STKAL		EQU		0EAh
	STKAH		EQU		0EBh
	STK9L		EQU		0ECh
	STK9H		EQU		0EDh
	STK8L		EQU		0EEh
	STK8H		EQU		0EFh
	
	STK7L		EQU		0F0h
	STK7H		EQU		0F1h
	STK6L		EQU		0F2h
	STK6H		EQU		0F3h
	STK5L		EQU		0F4h
	STK5H		EQU		0F5h
	STK4L		EQU		0F6h
	STK4H		EQU		0F7h

	STK3L		EQU		0F8h
	STK3H		EQU		0F9h
	STK2L		EQU		0FAh
	STK2H		EQU		0FBh
	STK1L		EQU		0FCh
	STK1H		EQU		0FDh
	STK0L		EQU		0FEh
	STK0H		EQU		0FFh

; -----------------------------------------------------
; Clear watchdog macro. 
;  
; Total Cycle: 2

	@RST_WDT	macro
		   MOV  A, #0x5A
		   B0MOV  WDTR, A
	endm
; -----------------------------------------------------
; Sleep Mode control macro for compatibility in S8KD-2 ICE
;  
; Total Cycle: 1

	SleepMode	macro	
		B0BSET	FCPUM0
	endm
; -----------------------------------------------------
; Green Mode control macro for compatibility in S8KD-2 ICE
;  
; Total Cycle: 3

	GreenMode	macro	
		B0BSET	FCPUM1
		NOP
		NOP
	endm
; -----------------------------------------------------
; Slow Mode control macro for compatibility in S8KD-2 ICE
;  
; Total Cycle: 2

	SLowMode	macro	
		B0BSET	FCLKMD
		B0BSET	FSTPHX
	endm
; -----------------------------------------------------
;  Slow mode to Normal Mode control macro for compatibility in S8KD-2 ICE
;  
; Total Cycle: 5

	Slow2Normal	macro	
		B0BCLR	FSTPHX
		NOP
		NOP
		NOP
		B0BCLR	FCLKMD
	endm
; -----------------------------------------------------
	
.TEXT
{
	//{{SONIX_OPTION_RULE
	ENDP
	//}}SONIX_OPTION_RULE
}
