
;------------------------------------------------------------------------------
;  CHIP: SN8F27E61
;  Revision History
;  
;  V01   2010/08/10		; First issue
;  V02   2011/05/16		; Remove 4M/12M X'tal code option
;  V03   2012/07/12  	1. Add "PCL_READ_LIMIT" Key word
;------------------------------------------------------------------------------
.ASSEMBLY    	RedWrt_FORMAT   1
.Assembly	INC_VER		3
.Assembly	ASM_FORMAT	1
.Assembly	RAM_Size	128

.Assembly	INSTRUMENT	SN8F27E61EN
.Assembly	BIT_FILE	SN8F27E61

.Assembly	OTP_BODY_SIZE	0x0800
.Assembly	USER_ROM_SIZE	0x07F8

.Assembly	MASK_TEST_CODE	0x0000, 0x0000, 0x0000, 0x0000

.Assembly	PGM_TYPE	6
.Assembly	CHIP_ID		0x6610
.Assembly	command		Enable_ORG4_7, EB_ICE, PCL_READ_LIMIT
.Assembly	Port_Pins	5, 8, 0, 0, 0, 0

; Code Option 0x07FF
.Assembly	OPTION		0		Noise_Filter	Disable Enable
.Assembly	OPTION		1		Security	Enable	Disable
.Assembly	OPTION		2		High_Fcpu	Fosc/1 Fosc/2 Fosc/4 Fosc/8 Fosc/16 Fosc/32 Fosc/64 Fosc/128
.Help
{
	High_Fcpu		: 	"Only Effective for HIGH Clock"
}
.Assembly	OPTION		5		High_Clk	IHRC_16M IHRC_RTC x x Ext_RC 32K_X'tal x x
.Help
{	
	IHRC_16M	:	"Internal 16M RC Oscillator"
	IHRC_RTC	:	"Internal 16M RC Oscillator with RTC.\n" \
	                "Connect 32.768K crystal to Xin/Xout"

	Ext_RC		:	"Connect R to VDD and Xin\nConnect C to GND and Xin"
	32K_X'tal	:	"32.768K Crystal"
}
.Assembly	OPTION		8		Low_Fcpu	Flosc/1 Flosc/2 Flosc/4 Flosc/8
.Help
{
	Low_Fcpu		: 	"Only Effective for Low Clock"
}
.Assembly	OPTION		10		Watch_Dog	Always_On x x x x Enable x x x x Disable x x x x x
.Assembly	OPTION		14		Fix_High
.Assembly	OPTION		15		Fix_Low


; Code Option 0x07FE
.Assembly	OPTION		16		Fix_Low
.Assembly	OPTION		17		Fix_High
.Assembly	OPTION		18		Fix_Low
.Assembly	OPTION		19		Fix_High
.Assembly	OPTION		20		Fix_High
.Assembly	OPTION		21		Fix_Low
.Assembly	OPTION		22		Fix_High
.Assembly	OPTION		23		Fix_Low
.Assembly	OPTION		24		Fix_Low
.Assembly	OPTION		25		Fix_High
.Assembly	OPTION		26		Fix_Low
.Assembly	OPTION		27		Fix_High
.Assembly	OPTION		28 : 31		Fix_High

; Code Option 0x07FD
.Assembly	OPTION		32 		Fix_High
.Assembly	OPTION		33 		Fix_High
.Assembly	OPTION		34 		Fix_High
.Assembly	OPTION		35 		Fix_High
.Assembly	OPTION		36 		Fix_High
.Assembly	OPTION		37 		Fix_High
.Assembly	OPTION		38 		Fix_High
.Assembly	OPTION		39 		Fix_High
.Assembly	OPTION		40 		Fix_High
.Assembly	OPTION		41		LVD	LVD_Max	LVD_H	LVD_M	LVD_L
.Help
{
	LVD_L		:	"1.8V Reset"
	LVD_M		:	"1.8V Reset\nEnable LVD24 bit of PFLAG for\n2.4V Low Voltage Indicator"
	LVD_H		:	"2.4V Reset\nEnable LVD33 bit of PFLAG for\n3.3V Low Voltage Indicator"	
	LVD_Max		:	"3.3V Reset"	
}

.Assembly	OPTION		43		Fix_High
.Assembly	OPTION		44		Reset_Pin   P02 Reset
.Assembly	OPTION		45		Fix_High
.Assembly	OPTION		46 		WDT_CLK	Flosc/4 Flosc/8 Flosc/16 Flosc/32
.Assembly	OPTION		48 : 63 	Fix_High



.Assembly	OPTION		2ffh
	L			EQU		080H
	H			EQU		081H
	R			EQU		082H
	Z			EQU		083H
	Y			EQU		084H
	X			EQU		085H

	PFLAG		EQU		086H
		FZ		EQU		PFLAG.0
		FDC		EQU		PFLAG.1
		FC		EQU		PFLAG.2
		FSTKOV		EQU_R		PFLAG.4
		FRST		EQU_R		PFLAG.5
		FWDT		EQU_R		PFLAG.6
		FPOR		EQU_R		PFLAG.7

	W0			EQU		088H
	W1			EQU		089H
	W2			EQU		08AH
	W3			EQU		08BH
	W4			EQU		08CH
	W5			EQU		08DH
	W6			EQU		08EH
	W7			EQU		08FH

	@HL			EQU		090H
	@YZ			EQU		091H

	PCL			EQU		093H
	PCH			EQU		094H

	OSCM		EQU		095H
		FCPUM1	EQU		OSCM.4
		FCPUM0	EQU		OSCM.3
		FCLKMD	EQU		OSCM.2
		FSTPHX	EQU		OSCM.1

	WDTR		EQU_W	096H

					
					
	INTRQ0		EQU		097H
		FADCIRQ	EQU		INTRQ0.7
		FTC2IRQ	EQU		INTRQ0.5
		FTC1IRQ	EQU		INTRQ0.4
		FTC0IRQ	EQU		INTRQ0.3	
		FT0IRQ  EQU		INTRQ0.2
		FP00IRQ	EQU		INTRQ0.0

      INTRQ1		EQU		098H
		FUTXIRQ EQU             INTRQ1.3
                FURXIRQ EQU             INTRQ1.2                
		FSIOIRQ	EQU		INTRQ1.1
		FWAKEIRQ EQU		INTRQ1.0

       INTEN0		EQU		09AH
		FADCIEN EQU		INTEN0.7
		FTC2IEN	EQU		INTEN0.5
		FTC1IEN	EQU		INTEN0.4
		FTC0IEN	EQU		INTEN0.3		
		FT0IEN  EQU	    	INTEN0.2
		FP00IEN	EQU		INTEN0.0

 
       INTEN1		EQU		09BH                 
		FUTXIEN EQU             INTEN1.3
                FURXIEN EQU             INTEN1.2
                FSIOIEN	EQU		INTEN1.1
		FWAKEIEN EQU		INTEN1.0

	P1W		EQU		09EH
		FP17W	EQU		P1W.7
		FP16W	EQU		P1W.6
		FP15W	EQU		P1W.5
		FP14W	EQU		P1W.4
		FP13W	EQU		P1W.3
		FP12W	EQU		P1W.2
		FP11W	EQU		P1W.1
		FP10W	EQU		P1W.0
	
	PEDGE		EQU		09FH
		FP00G1	EQU		PEDGE.1
		FP00G0	EQU		PEDGE.0	  	


	P0M		EQU		0A0H	
		FP04M	EQU		P0M.4
		FP03M	EQU		P0M.3
		FP02M	EQU		P0M.2
		FP01M	EQU		P0M.1
		FP00M	EQU		P0M.0

	P1M		EQU		0A1H	
		FP17M	EQU		P1M.7
		FP16M	EQU		P1M.6
		FP15M	EQU		P1M.5
		FP14M	EQU		P1M.4
		FP13M	EQU		P1M.3
		FP12M	EQU		P1M.2
		FP11M	EQU		P1M.1
		FP10M	EQU		P1M.0
  		
	P0		EQU 	0A6H		
		FP04	EQU 	P0.4
		FP03	EQU 	P0.3
		FP02	EQU 	P0.2
		FP01	EQU 	P0.1
		FP00	EQU 	P0.0

	P1		EQU 	0A7H	
		FP17	EQU 	P1.7
		FP16	EQU 	P1.6
		FP15	EQU 	P1.5	
		FP14	EQU 	P1.4
		FP13	EQU 	P1.3
		FP12	EQU 	P1.2
		FP11	EQU 	P1.1
		FP10	EQU 	P1.0

  	P0UR        EQU     0ACH
	P1UR        EQU     0ADH

	T0M			EQU	0B2H
		FT0ENB	 	EQU  	T0M.7
		FT0RATE2 	EQU  	T0M.6
		FT0RATE1 	EQU  	T0M.5
		FT0RATE0 	EQU  	T0M.4
		FT0TB	 	EQU  	T0M.0

	T0C			EQU	0B3H

	TC0M			EQU	0B4H
		FTC0ENB		EQU	TC0M.7
		FTC0RATE2	EQU	TC0M.6
		FTC0RATE1	EQU	TC0M.5
		FTC0RATE0	EQU	TC0M.4
		FTC0CKS1	EQU	TC0M.3
    		FTC0CKS0 	EQU 	TC0M.2
		FTC0PO		EQU 	TC0M.1
  		FPWM0OUT  	EQU 	TC0M.0 

 	TC0C			EQU	0B5H	
	TC0R			EQU_W	0B6H
	TC0D			EQU	0B7H
		
	TC1M		EQU		0B8H
		FTC1ENB		EQU	TC1M.7
		FTC1RATE2	EQU	TC1M.6
		FTC1RATE1	EQU	TC1M.5
		FTC1RATE0	EQU	TC1M.4
		FTC1CKS1	EQU	TC1M.3
    		FTC1CKS0  	EQU 	TC1M.2
		FTC1PO		EQU 	TC1M.1
    		FPWM1OUT  	EQU 	TC1M.0 
    	TC1C			EQU	0B9H	
	TC1R			EQU_W	0BAH
	TC1D			EQU	0BBH

        TC2M		EQU		0BCH
		FTC2ENB		EQU	TC2M.7
		FTC2RATE2	EQU	TC2M.6
		FTC2RATE1	EQU	TC2M.5
		FTC2RATE0	EQU	TC2M.4
		FTC2CKS1	EQU	TC2M.3
    		FTC2CKS0  	EQU 	TC2M.2
		FTC2PO		EQU 	TC2M.1
    		FPWM2OUT  	EQU 	TC2M.0 
	TC2C			EQU	0BDH	
	TC2R			EQU_W	0BEH
	TC2D			EQU	0BFH

	P1CON		EQU		0C6H

	ADM		EQU		0C8H
		FADENB	EQU		ADM.7
		FADS	EQU		ADM.6
		FEOC	EQU		ADM.5
		FGCHS	EQU		ADM.4
		FCHS2	EQU		ADM.2
		FCHS1	EQU		ADM.1
		FCHS0	EQU		ADM.0
		
	ADB		EQU_R		0C9H
		FADB11	EQU_R	        ADB.7
		FADB10	EQU_R		ADB.6		
		FADB9	EQU_R		ADB.5
		FADB8	EQU_R		ADB.4
		FADB7	EQU_R		ADB.3
		FADB6	EQU_R		ADB.2
		FADB5	EQU_R		ADB.1
		FADB4	EQU_R		ADB.0
				
	ADR		EQU		0CAH
		
		FADCKS1	EQU		ADR.6
		FADLEN	EQU		ADR.5
		FADCKS0	EQU		ADR.4
		FADB3	EQU_R		ADR.3
		FADB2	EQU_R		ADR.2
		FADB1	EQU_R		ADR.1
		FADB0	EQU_R		ADR.0	

	 ADT		EQU		0CBH
		FADTS1		EQU		ADT.7
		FADTS0		EQU		ADT.6
		FADT4		EQU		ADT.4
		FADT3		EQU		ADT.3
		FADT2		EQU		ADT.2
		FADT1		EQU		ADT.1
		FADT0		EQU		ADT.0

	 VREFH		EQU		0CCH
		FEVHENB		EQU		VREFH.7
		FVHS1		EQU		VREFH.1
		FVHS0		EQU		VREFH.0		

	PECMD		EQU		0DBH	
	PEROML		EQU		0DCH		
	PEROMH		EQU		0DDH
	PERAML		EQU		0DEH
	PERAMCNT	EQU		0DFH

	SIOM			EQU		0E0H
		FSENB		EQU	SIOM.7
		FSTART		EQU	SIOM.6
		FSRATE1		EQU	SIOM.5
		FSRATE0		EQU	SIOM.4
		FMLSB		EQU	SIOM.3
		FSCKMD		EQU	SIOM.2
		FCPOL		EQU	SIOM.1
		FCPHA		EQU	SIOM.0

	SIOR			EQU_W		0E1H
	SIOB			EQU		0E2H	
	SIOC			EQU		0E3H
		FSIOBZ		EQU		SIOC.2
		FSCSEN		EQU		SIOC.1
		FSCSP		EQU		SIOC.0


        URTX	                EQU             0E4H  
                FUTXEN           EQU             URTX.7
                FUTXPEN          EQU             URTX.6
                FUTXPS           EQU             URTX.5
                FUTXBRK          EQU             URTX.4
                FURXBZ           EQU             URTX.3
                FUTXBZ           EQU             URTX.2

        URRX	                EQU             0E5H
                FURXEN           EQU             URRX.7
                FURXPEN          EQU             URRX.6
                FURXPS           EQU             URRX.5
                FURXPC           EQU             URRX.4
                FUFMER           EQU             URRX.3
                FURS2            EQU             URRX.2
                FURS1            EQU             URRX.1
                FURS0            EQU             URRX.0

        URCR                  EQU             0E6H
        UTXD                  EQU             0E7H
        URXD                  EQU             0E8H

	STKP		EQU		0EFH
		FGIE	EQU		STKP.7
		FLVD24	EQU_R		STKP.6
		FLVD33	EQU_R		STKP.5
		FSTKPB2	EQU		STKP.2
		FSTKPB1	EQU		STKP.1
		FSTKPB0	EQU		STKP.0

	STK7L		EQU	0F0h
	STK7H		EQU	0F1h
	STK6L		EQU	0F2h
	STK6H		EQU	0F3h
	STK5L		EQU	0F4h
	STK5H		EQU	0F5h
	STK4L		EQU	0F6h
	STK4H		EQU	0F7h
	STK3L		EQU	0F8h
	STK3H		EQU	0F9h
	STK2L		EQU	0FAh
	STK2H		EQU	0FBh
	STK1L		EQU	0FCh
	STK1H		EQU	0FDh
	STK0L		EQU	0FEh
	STK0H		EQU	0FFh

; -----------------------------------------------------
; Clear watchdog macro. 
;  
; Total Cycle: 2

	@RST_WDT	macro
		   MOV  A, #0x5A
		   B0MOV  WDTR, A
	endm
; -----------------------------------------------------
; Sleep Mode control macro for compatibility in S8KD-2 ICE
;  
; Total Cycle: 1

	SleepMode	macro	
		B0BSET	FCPUM0
	endm
; -----------------------------------------------------
; Green Mode control macro for compatibility in S8KD-2 ICE
;  
; Total Cycle: 3

	GreenMode	macro	
		B0BSET	FCPUM1
		NOP
		NOP
	endm
; -----------------------------------------------------
; Slow Mode control macro for compatibility in S8KD-2 ICE
;  
; Total Cycle: 2

	SlowMode	macro	
		B0BSET	FCLKMD
		B0BSET	FSTPHX
	endm
; -----------------------------------------------------
;  Slow mode to Normal Mode control macro for compatibility in S8KD-2 ICE
;  
; Total Cycle: 5

	Slow2Normal	macro	
		B0BCLR	FSTPHX
		NOP
		NOP
		NOP
		B0BCLR	FCLKMD
	endm
; -----------------------------------------------------		
.TEXT
{
	//{{SONIX_OPTION_RULE
        
	ENDP
	//}}SONIX_OPTION_RULE
}			  								