
;------------------------------------------------------------------------------
;  CHIP: SN8F2288
;  Revision History
;  
;  V01   2008/05/23
;  V02   2008/10/22   1. 092H bit 6  PKT_ERR	
;                     2. 0E9H bit 2  P05OC		
;	                            bit 3  P06OC
;                     3. Update the 0xC7 bit6&7
;	                    4. 092H bit 7  CRC_ERR
;	                    5. 09CH bit 4  UE3MODE
;                     6. 09EH bit 4  UE4MODE
;	                    7. 0B3H Register OSBH
;                     8. 0B4H Register OSBL
;                     9. 0A9H bit 7  UCLK_SEL
;  V03   2008/10/23   1. Reserve 4-Words of ROM size for unique code
;  V04   2008/12/30   1. Rename T1C Counting Register to T1CH and T1CL
;  V05	 2009/11/16   1. Remove LVD_L selection in Code option.
;		      						2. Replace Ext_OSC with High_CLK in Code option.
;  V06   2012/07/12   1. Add "PCL_READ_LIMIT" Key word
;  V07   2013/09/04   1. Add "B0BTS0_LIMIT, B0BTS1_LIMIT, BTS0_LIMIT, BTS1_LIMIT" Key word.
;  V08   2013/11/29   1. Modify TC0R, TC1R, TC2R, UE1R_C, ADB, ADR, P4CON, P1OC, STKnH, STKnL registers define.
;------------------------------------------------------------------------------
.ASSEMBLY RedWrt_FORMAT    1
.Assembly	INC_VER		6
.Assembly	ASM_FORMAT	1
.Assembly	RAM_Size	512

.Assembly	INSTRUMENT	SN8F2288
.Assembly	BIT_FILE	SN8F2288

.Assembly	OTP_BODY_SIZE	0x0FFF
.Assembly	USER_ROM_SIZE	0x0FF8

.Assembly	MASK_TEST_CODE	0x0000, 0x0000, 0x0000, 0x0000

.Assembly	PGM_TYPE	6
.Assembly	CHIP_ID		0x2700
.Assembly	command		Enable_ORG4_7, RBANK_LIMIT, Enable_ISP, PCL_READ_LIMIT, B0_B_TS01_LIMIT
.Assembly	Port_Pins	8, 8, 6, 4, 8, 6

.Assembly	USB_FIFO_Size	136, 136

; Code Option 0x2FFF
.Assembly	OPTION		0		Fix_Low
.Assembly	OPTION		1		Security	Enable	Disable
.Assembly	OPTION		2		Fcpu		Fosc/1 Fosc/2 Fosc/4 Fosc/8
.Help
{
	Fcpu		: 	"Only Effective for HIGH Clock"
}
.Assembly	OPTION		4		High_CLK	6M_X'tal 12M_X'tal 16M_X'tal x
.Help
{
;	IHRC_6M		: "Internal 6M RC Oscillator"
;	IHRC_RTC	: "Internal 6M RC Oscillator with RTC\nConnect 32768Hz crytal to XIN/XOUT"
	6M_X'tal	: "Crystal/Resonator: 6Mhz"
	12M_X'tal	: "Crystal/Resonator: 12Mhz"
	16M_X'tal	: "Crystal/Resonator: 16Mhz"
}
;.Assembly	OPTION		6 		Bypass		Enable  Disable
.Assembly	OPTION		6 		Fix_High
.Assembly	OPTION		7		Fslow	Flosc/2	Flosc/4
.Help
{
	Flosc/2		: "Slow mode clock = Flosc/2"
	Flosc/4		: "Slow mode clock = Flosc/4"
}
;.Assembly	OPTION		7		Fix_High
.Assembly	OPTION		8		Watch_Dog	Always_On x x x x Enable x x x x Disable x x x x x
.Assembly	OPTION		12		Reset_Pin       P07 	Reset
.Assembly	OPTION		13		Rst_Length  	No 	128*ILRC
;.Assembly	OPTION		13		Fix_High
;.Assembly	OPTION		14		Fix_High
;.Assembly	OPTION		15		Fix_Low
.Assembly	OPTION		14		LVD		x	LVD_M	LVD_H	x
.Help
{
	LVD_M		: "Low Voltage Detect 2.4V"
	LVD_H		: "Low Voltage Detect 3.6V"
}
;.Assembly	OPTION		15		SMODE3      Disable Enable


; Code Option 0x2FFE
.Assembly	OPTION		16		Fix_Low
.Assembly	OPTION		17		Fix_High
.Assembly	OPTION		18		Fix_Low
.Assembly	OPTION		19		Fix_High
.Assembly	OPTION		20		Fix_High
.Assembly	OPTION		21		Fix_Low
.Assembly	OPTION		22		Fix_High
.Assembly	OPTION		23		Fix_Low
.Assembly	OPTION		24		Fix_Low
.Assembly	OPTION		25		Fix_High
.Assembly	OPTION		26		Fix_Low
.Assembly	OPTION		27		Fix_High
.Assembly	OPTION		28 : 31		Fix_High

; Code Option 0x2FFD
.Assembly	OPTION		32 		Fix_low
.Assembly	OPTION		33 		Fix_low
.Assembly	OPTION		34 		Fix_High
.Assembly	OPTION		35 		Fix_low
.Assembly	OPTION		36 		Fix_low
.Assembly	OPTION		37 		Fix_High
.Assembly	OPTION		38 		Fix_low
.Assembly	OPTION		39 		Fix_low
.Assembly	OPTION		40 		Fix_High
.Assembly	OPTION		41 		Fix_low
.Assembly	OPTION		42 		Fix_low
.Assembly	OPTION		43 		Fix_High
.Assembly	OPTION		44 		Fix_High
.Assembly	OPTION		45 		Fix_High
.Assembly	OPTION		46 		Fix_High
.Assembly	OPTION		47		Fix_low

; Code Option 0x2FFC
.Assembly	OPTION		48 		Fix_low
.Assembly	OPTION		49 		Fix_low
.Assembly	OPTION		50 		Fix_High

.Assembly	OPTION		51 		Fix_low
.Assembly	OPTION		52 : 63 		Fix_High


.Assembly	OPTION		2ffh

	H			EQU		80H
	L			EQU		81H
	R			EQU		82H
	Z			EQU		83H
	Y			EQU		84H
	
	PFLAG		EQU		86H
		FZ		EQU		PFLAG.0
		FDC		EQU		PFLAG.1
		FC		EQU		PFLAG.2
		FNPD	EQU		PFLAG.6
		FNT0	EQU		PFLAG.7

	RBANK		EQU		87H
		FRBNKS0	EQU		RBANK.0
		FRBNKS1	EQU		RBANK.1

	@HL		EQU		090H    
	@YZ		EQU		091H	
	CTRL	EQU		092H
		FP0CTRL	EQU	CTRL.0
		FP1CTRL	EQU	CTRL.1
		FP5CTRL	EQU	CTRL.2
		FRSEL0	EQU	CTRL.3
		FRSEL1	EQU	CTRL.4
		FLVDS0	EQU	CTRL.5
		FLVDS1	EQU	CTRL.6
	
	PCL		EQU		093H  
	PCH		EQU		094H
	
	OSCM	EQU		095H
		FSTPHX	EQU	OSCM.1
		FCLKMD	EQU	OSCM.2
		FCPUM0	EQU	OSCM.3
		FCPUM1	EQU	OSCM.4

	WDTR	EQU		096H
	INTRQ	EQU		097H
		FINT0IF	EQU	INTRQ.0
		FP50IF	EQU	INTRQ.1
		FP54IF	EQU	INTRQ.2
		FP0P1IF	EQU	INTRQ.3
		FT1IF	EQU	INTRQ.4
		FTC0IF	EQU	INTRQ.5
		FTM1IF	EQU	INTRQ.6
	
	INTEN		EQU		099H
		FINT0IE	EQU	INTEN.0
		FP50IE	EQU	INTEN.1
		FP54IE	EQU	INTEN.2
		FP0P1IE	EQU	INTEN.3
		FT1IE	EQU	INTEN.4
		FTC0IE	EQU	INTEN.5
		FTM1IE	EQU	INTEN.6
		
		
	REM_REG		EQU	09AH
		FDRVS0	EQU	REM_REG.0
		FDRVS1	EQU	REM_REG.1
		FDRVS2	EQU	REM_REG.2
		FELEEN	EQU	REM_REG.3
		FDRVS4	EQU	REM_REG.4
		FDRVS5	EQU	REM_REG.5
		FDRVS6	EQU	REM_REG.6		
		FDRVS7	EQU	REM_REG.7	
		
	P0W		EQU		09BH
		FP00W	EQU	P0W.0
		FP01W	EQU	P0W.1
		FP02W	EQU	P0W.2
		FP03W	EQU	P0W.3
		FP04W	EQU	P0W.4
		FP05W	EQU	P0W.5
		
	P1W		EQU		09CH	
		FP10W	EQU	P1W.0
		FP11W	EQU	P1W.1
		FP12W	EQU	P1W.2
		FP13W	EQU	P1W.3
		FP14W	EQU	P1W.4
		FP15W	EQU	P1W.5
		
	PEDGE	EQU		09FH
		FPG0	EQU	PEDGE.0
		FPG1	EQU	PEDGE.1
		FINTS	EQU	PEDGE.3
		FIRXO	EQU	PEDGE.5
		FIRXEN	EQU	PEDGE.6
		
	P0M0	EQU		0A0H
		FP00M0	EQU	P0M0.0
		FP01M0	EQU	P0M0.1
		FP02M0	EQU	P0M0.2
		FP03M0	EQU	P0M0.3
		FP04M0	EQU	P0M0.4
		FP05M0	EQU	P0M0.5	
		
	P1M0	EQU		0A1H
		FP10M0	EQU	P1M0.0
		FP11M0	EQU	P1M0.1
		FP12M0	EQU	P1M0.2
		FP13M0	EQU	P1M0.3
		FP14M0	EQU	P1M0.4
		FP15M0	EQU	P1M0.5	
		
	P5M0	EQU		0A4H
		FP50M0	EQU	P5M0.0
		FP54M0	EQU	P5M0.4	

	P0	EQU		0A5H
		FP00	EQU	P0.0
		FP01	EQU	P0.1
		FP02	EQU	P0.2
		FP03	EQU	P0.3
		FP04	EQU	P0.4
		FP05	EQU	P0.5	

	P1	EQU		0A6H
		FP10	EQU	P1.0
		FP11	EQU	P1.1
		FP12	EQU	P1.2
		FP13	EQU	P1.3
		FP14	EQU	P1.4
		FP15	EQU	P1.5	
		
	P5	EQU		0A9H
		FP50	EQU	P5.0
		FP54	EQU	P5.4

	P0M1	EQU		0AAH
		FP00M1	EQU	P0M1.0
		FP01M1	EQU	P0M1.1
		FP02M1	EQU	P0M1.2
		FP03M1	EQU	P0M1.3
		FP04M1	EQU	P0M1.4
		FP05M1	EQU	P0M1.5	
		
	P1M1	EQU		0ABH
		FP10M1	EQU	P1M1.0
		FP11M1	EQU	P1M1.1
		FP12M1	EQU	P1M1.2
		FP13M1	EQU	P1M1.3
		FP14M1	EQU	P1M1.4
		FP15M1	EQU	P1M1.5	
		
	P5M1	EQU		0AEH
		FP50M1	EQU	P5M1.0
		FP54M1	EQU	P5M1.4	
		
		
	T1M		EQU		0B5H
		FTC0GN	EQU		TC0M.0
		FT1GATE	EQU		TC0M.1
		FT1CK	EQU		TC0M.2
		FTP1SEL	EQU		TC0M.3
		FTP1S0	EQU		TC0M.4
		FTP1S1	EQU		TC0M.5
		FTP1S2	EQU		TC0M.6
		FTR1	EQU		TC0M.7
		
	T1C_L		EQU 	0B6H
	T1C_H		EQU 	0B7H	
		
	TC0M		EQU		0B8H
		FPWMOUT	EQU		TC0M.0
		FBUZOUT	EQU		TC0M.1
		FTC0I0	EQU		TC0M.2
		FTC0I1	EQU		TC0M.3
		FTC0S0	EQU		TC0M.4
		FTC0S1	EQU		TC0M.5
		FTC0S2	EQU		TC0M.6
		FTC0TR	EQU		TC0M.7
		
	TC0C		EQU		0B9H
	TC0R		EQU		0BAH		
	TC0D_TC0H	EQU		0BBH
	PWM0DL		EQU		0C0H
	PWM0DH		EQU		0C1H
	PWM0PL		EQU		0C2H
	PWM0PH		EQU		0C3H
	
	PWM0EN		EQU		0C4H
		FPWM0EN		EQU		PWM0EN.0
		FPWM0OEN	EQU		PWM0EN.1
		FPWM01OEN	EQU		PWM0EN.2
		FPWM0M		EQU		PWM0EN.3
		FPWM1OEN	EQU		PWM0EN.4
		FTM1SEL8	EQU		PWM0EN.5
		FTM1GN		EQU		PWM0EN.6
		FTM1EN		EQU		PWM0EN.7
		
	PWM0C		EQU		0C5H
		FCK00		EQU		PWM0C.0
		PCK01		EQU		PWM0C.1
		FPWM0S0		EQU		PWM0C.2
		FPWM0S1		EQU		PWM0C.3
		FCK02		EQU		PWM0C.6
		FCK03		EQU		PWM0C.7
		
	PWM0TL		EQU		0C6H
	PWM0TH		EQU		0C7H
	PWM0DTL		EQU		0C8H
	PWM0DTH		EQU		0C9H
	PWMPSCON	EQU		0CAH
	PWM1DL		EQU		0D0H
	PWM1DH		EQU		0D1H
	
	OPTION_REG		EQU		0CCH
		FP0SCANW		EQU		OPTION_REG.0
		FP1SCANW		EQU		OPTION_REG.1
		FP5SCANW		EQU		OPTION_REG.2
		FIESEL			EQU		OPTION_REG.3
		FWDTPER0		EQU		OPTION_REG.4
		FWDTPRE1		EQU		OPTION_REG.5
		FWDTPRE2		EQU		OPTION_REG.6
		FWDTEN			EQU		OPTION_REG.7
		
	MTPQ	EQU	0D6H
		FMTPPROFLAG	EQU	MTPQ.1
		FMTPEARFLAG	EQU	MTPQ.2
		FMTPCERSFLAG	EQU	MTPQ.3
		
	MTPEN	EQU	0D8H
		FMTPRD	EQU	MTPEN.0
		FMTPPRO	EQU	MTPEN.1
		FMTPERA	EQU	MTPEN.2
		FMTPCERS	EQU	MTPEN.3
		FMTPCPEN	EQU	MTPEN.5
		
	MTPAH	EQU	0DAH
	MTPC	EQU	0DBH
		FPROSEL0	EQU	MTPC.0
		FPROSEL1	EQU	MTPC.1
		FPROSEL2	EQU	MTPC.2
		FPROSEL3	EQU	MTPC.3
		FPROSEL4	EQU	MTPC.4
		FPROCLKS0	EQU	MTPC.5
		FPROCLKS1	EQU	MTPC.6
		
	MTPAL	EQU	0DCH
	MTPD	EQU	0DEH
	T1M1	EQU	0E9H
		FT1OVW	EQU	T1M1.0
		FT1OVS	EQU	T1M1.1
		FINT0W	EQU	T1M1.2
		FPWMW1	EQU	T1M1.3
		FPWMW2	EQU	T1M1.4
		
	REV0T0L	EQU	0EAH
	REV0T0H	EQU	0EBH
	REV1T0L	EQU	0ECH
	REV1T0H	EQU	0EDH
	
	STKP	EQU	0EFH
		FSTKPB0	EQU	STKP.0
		FSTKPB1	EQU	STKP.1
		FSTKPB2	EQU	STKP.2
		FLVD1D8	EQU	STKP.4
		FLVD2X	EQU	STKP.5
		FGIE	EQU	STKP.7

; -----------------------------------------------------
; Clear watchdog macro. 
;  
; Total Cycle: 2

	@RST_WDT	macro
		   MOV  A, #0x5A
		   B0MOV  WDTR, A
	endm
; -----------------------------------------------------
; Sleep Mode control macro for compatibility in S8KD-2 ICE
;  
; Total Cycle: 1

	SleepMode	macro	
		B0BSET	FCPUM0
	endm
; -----------------------------------------------------
; Green Mode control macro for compatibility in S8KD-2 ICE
;  
; Total Cycle: 3

	GreenMode	macro	
		B0BSET	FCPUM1
		NOP
		NOP
	endm
; -----------------------------------------------------
; Slow Mode control macro for compatibility in S8KD-2 ICE
;  
; Total Cycle: 2

	SlowMode	macro	
		B0BSET	FCLKMD
		B0BSET	FSTPHX
	endm
; -----------------------------------------------------
;  Slow mode to Normal Mode control macro for compatibility in S8KD-2 ICE
;  
; Total Cycle: 5

	Slow2Normal	macro	
		B0BCLR	FSTPHX
		NOP
		NOP
		NOP
		B0BCLR	FCLKMD
	endm
; -----------------------------------------------------
;  Slow mode to Normal Mode control macro for compatibility in S8KD-2 ICE
;  
; Total Cycle: 5

	Set_P3_Input_Pullup	macro	
		DW	0x2D00 		;mov	a, #0x00	; Port 3: Input pull-up high
    DW 	0x2FC3 		;b0mov	P3M,a
    DW	0x2DFF 		;mov	a, #0xFF
    DW	0x2FD3 		;b0mov	P3,a
    DW	0x2FE3 		;b0mov	P3UR,a
	endm
; -----------------------------------------------------
	
.TEXT
{
	//{{SONIX_OPTION_RULE
        
	ENDP
	//}}SONIX_OPTION_RULE
}