
;------------------------------------------------------------------------------
;  CHIP: S8KD
;  Revision History:
;  V1.0  10/09/2002  First issue
;  V2.0   04/03/2008  1. Add "RedWrt_FORMAT    1"  	
;------------------------------------------------------------------------------
.ASSEMBLY    RedWrt_FORMAT    1

.Assembly	INC_VER		2
.Assembly	ASM_FORMAT	1
.Assembly	RAM_Size	0E80h

.Assembly	INSTRUMENT	SN88X4

.Assembly	MASK_BODY_SIZE	0x10000
.Assembly	OTP_BODY_SIZE	0x10000
.Assembly	USER_ROM_SIZE	0xFFFF
.Assembly	MASK_TEST_CODE	0x0000, 0x0000, 0x00, 0x00
.Assembly	Port_Pins	8, 8, 8, 8, 8, 8, 8, 8
.Assembly	LCD_Size	40, 8
.Assembly	COMMAND		MUL, PUSH, SJMP, RETLW

.Assembly	OPTION		0		Watch_Dog	Enable	Disable
.Assembly	OPTION		1		Fix_High
.Assembly	OPTION		2		Fix_High
.Assembly	OPTION		3		Fix_High
.Assembly	OPTION		4		High_Clk/2	Enable	Disable
.Assembly	OPTION		5		High_Clk	RC	32K_X'tal	12M_X'tal	4M_X'tal
.Assembly	OPTION		7		OSG		Enable	Disable
.Assembly	OPTION		8 : 15	Fix_High
.Assembly	OPTION		2ffh

	L			EQU		0x80
	H			EQU		0x81
	R			EQU		0x82
	Z			EQU		0x83
	Y			EQU		0x84
	X			EQU		0x85

	PFLAG		EQU		0x86
		FZ		EQU		0x86.0
		FDC		EQU		0x86.1
		FC		EQU		0x86.2
		FPAGES0	EQU		0x86.4
		FPAGES1	EQU		0x86.5
		FNPD	EQU		0x86.6
		FNT0	EQU		0x86.7

	RBANK		EQU		0x87
		FRBNKS0	EQU		0x87.0
		FRBNKS1	EQU		0x87.1
		FRBNKS2	EQU		0x87.2
		FRBNKS3	EQU		0x87.3
		FPG0	EQU		0x87.5
		FPG1	EQU		0x87.6
		FPG2	EQU		0x87.7

	OPTION		EQU		0x88
		FRCLK	EQU		0x88.0
		FP3LCD	EQU		0x88.1

	DAM			EQU		0xB0
		FDAENB	EQU		DAM.7
		FDAB6	EQU		DAM.6
		FDAB5	EQU		DAM.5
		FDAB4	EQU		DAM.4
		FDAB3	EQU		DAM.3
		FDAB2	EQU		DAM.2
		FDAB1	EQU		DAM.1
		FDAB0	EQU		DAM.0

	ADM			EQU		0xB1
		FADENB	EQU		ADM.7
		FADS	EQU		ADM.6
		FEOC	EQU		ADM.5
		FGCHS	EQU		ADM.4
		FCHS2	EQU		ADM.2
		FCHS1	EQU		ADM.1
		FCHS0	EQU		ADM.0
		
	ADB			EQU_R	0B2H

	ADR			EQU		0B3H
		FADCKS1	EQU		ADR.6
		FADCKS	EQU		ADR.6
		FADLEN	EQU		ADR.5
		FADCKS0	EQU		ADR.4

		FADB3	EQU_R	ADR.3
		FADB2	EQU_R	ADR.2
		FADB1	EQU_R	ADR.1
		FADB0	EQU_R	ADR.0

	SIOM		EQU		0B4H
		FSENB	EQU		SIOM.7
		FSTART	EQU		SIOM.6
		FSRATE1	EQU		SIOM.5
		FSRATE0	EQU		SIOM.4
		FSIG	EQU		SIOM.3
		FSCKMD	EQU		SIOM.2
		FSEDGE	EQU		SIOM.1
		FTXRX	EQU		SIOM.0

	SIOR		EQU_W	0B5H
	SIOB		EQU		0B6H
	SIORU		EQU		0BDH

	PUR			EQU_W	0BEH
		FPUR5	EQU_W	PUR.5
		FPUR4	EQU_W	PUR.4
		FPUR3	EQU_W	PUR.3
		FPUR2	EQU_W	PUR.2
		FPUR1	EQU_W	PUR.1
		FPUR0	EQU_W	PUR.0

	PEDGE		EQU		0BFH
		FPEDGEN	EQU		PEDGE.7
		FP02G	EQU		PEDGE.6
		FP01G	EQU		PEDGE.5
		FP00G1	EQU		PEDGE.4
		FP00G0	EQU		PEDGE.3

;	P1W			EQU_W	0C0H
;		FP17W	EQU_W	P1W.7
;		FP16W	EQU_W	P1W.6
;		FP15W	EQU_W	P1W.5
;		FP14W	EQU_W	P1W.4
;		FP13W	EQU_W	P1W.3
;		FP12W	EQU_W	P1W.2
;		FP11W	EQU_W	P1W.1
;		FP10W	EQU_W	P1W.0

	P1W			EQU		0C0H
		FP17W	EQU		P1W.7
		FP16W	EQU		P1W.6
		FP15W	EQU		P1W.5
		FP14W	EQU		P1W.4
		FP13W	EQU		P1W.3
		FP12W	EQU		P1W.2
		FP11W	EQU		P1W.1
		FP10W	EQU		P1W.0

	P1M			EQU		0C1H
		FP17M	EQU		P1M.7
		FP16M	EQU		P1M.6
		FP15M	EQU		P1M.5
		FP14M	EQU		P1M.4
		FP13M	EQU		P1M.3
		FP12M	EQU		P1M.2
		FP11M	EQU		P1M.1
		FP10M	EQU		P1M.0

	P2M			EQU		0C2H
		FP27M	EQU		P2M.7
		FP26M	EQU		P2M.6
		FP25M	EQU		P2M.5
		FP24M	EQU		P2M.4
		FP23M	EQU		P2M.3
		FP22M	EQU		P2M.2
		FP21M	EQU		P2M.1
		FP20M	EQU		P2M.0

	P3M			EQU		0C3H
		FP37M	EQU		P3M.7
		FP36M	EQU		P3M.6
		FP35M	EQU		P3M.5
		FP34M	EQU		P3M.4
		FP33M	EQU		P3M.3
		FP32M	EQU		P3M.2
		FP31M	EQU		P3M.1
		FP30M	EQU		P3M.0

	P4M			EQU		0C4H
		FP47M	EQU		P4M.7
		FP46M	EQU		P4M.6
		FP45M	EQU		P4M.5
		FP44M	EQU		P4M.4
		FP43M	EQU		P4M.3
		FP42M	EQU		P4M.2
		FP41M	EQU		P4M.1
		FP40M	EQU		P4M.0

	P5M			EQU		0C5H
		FP57M	EQU		P5M.7
		FP56M	EQU		P5M.6
		FP55M	EQU		P5M.5
		FP54M	EQU		P5M.4
		FP53M	EQU		P5M.3
		FP52M	EQU		P5M.2
		FP51M	EQU		P5M.1
		FP50M	EQU		P5M.0

	P6M			EQU		0C6H
		FP67M	EQU		P6M.7
		FP66M	EQU		P6M.6
		FP65M	EQU		P6M.5
		FP64M	EQU		P6M.4
		FP63M	EQU		P6M.3
		FP62M	EQU		P6M.2
		FP61M	EQU		P6M.1
		FP60M	EQU		P6M.0

	P7M			EQU		0C7H
		FP77M	EQU		P7M.7
		FP76M	EQU		P7M.6
		FP75M	EQU		P7M.5
		FP74M	EQU		P7M.4
		FP73M	EQU		P7M.3
		FP72M	EQU		P7M.2
		FP71M	EQU		P7M.1
		FP70M	EQU		P7M.0

	INTRQ		EQU		0C8H
;		FTWIRQ	EQU	INTRQ.7
		FTC1IRQ	EQU	INTRQ.6
		FTC0IRQ	EQU	INTRQ.5
		FT0IRQ	EQU	INTRQ.4
		FSIOIRQ	EQU	INTRQ.3
		FP02IRQ	EQU	INTRQ.2
		FP01IRQ	EQU	INTRQ.1
		FP00IRQ	EQU	INTRQ.0

	INTEN		EQU		0C9H
;		FTWIEN	EQU	INTEN.7
		FTC1IEN	EQU	INTEN.6
		FTC0IEN	EQU	INTEN.5
		FT0IEN	EQU	INTEN.4
		FSIOIEN	EQU	INTEN.3
		FP02IEN	EQU	INTEN.2
		FP01IEN	EQU	INTEN.1
		FP00IEN	EQU	INTEN.0

	OSCM		EQU		0CAH
		FWTCKS	EQU	OSCM.7
		FWDRST	EQU	OSCM.6
		FWDRATE	EQU	OSCM.5
		FCPUM1	EQU	OSCM.4
		FCPUM0	EQU	OSCM.3
		FCLKMD	EQU	OSCM.2
		FSTPHX	EQU	OSCM.1
		FOSCM_UNUSED	EQU	OSCM.0

	LCDM		EQU		0CBH
		FLCDL1	EQU	LCDM.7
		FLCDL0	EQU	LCDM.6
		FBLANK	EQU	LCDM.5
		FDUTY	EQU	LCDM.4
		FLENB	EQU	LCDM.3
		F12864	EQU	LCDM.2
		FP6HSEG	EQU	LCDM.1
		FP6LSEG	EQU	LCDM.0

	TC0R		EQU_W	0CDH

	PCL			EQU		0CEH
	PCH			EQU		0CFH

	P0			EQU_R	0D0H
		FP07	EQU_R	P0.7
		FP06	EQU_R	P0.6
		FP05	EQU_R	P0.5
		FP04	EQU_R	P0.4
		FP03	EQU_R	P0.3
		FP02	EQU_R	P0.2
		FP01	EQU_R	P0.1
		FP00	EQU_R	P0.0

	P1			EQU		0D1H
		FP17	EQU		P1.7
		FP16	EQU		P1.6
		FP15	EQU		P1.5
		FP14	EQU		P1.4
		FP13	EQU		P1.3
		FP12	EQU		P1.2
		FP11	EQU		P1.1
		FP10	EQU		P1.0

	P2			EQU		0D2H
		FP27	EQU		P2.7
		FP26	EQU		P2.6
		FP25	EQU		P2.5
		FP24	EQU		P2.4
		FP23	EQU		P2.3
		FP22	EQU		P2.2
		FP21	EQU		P2.1
		FP20	EQU		P2.0

	P3			EQU		0D3H
		FP37	EQU		P3.7
		FP36	EQU		P3.6
		FP35	EQU		P3.5
		FP34	EQU		P3.4
		FP33	EQU		P3.3
		FP32	EQU		P3.2
		FP31	EQU		P3.1
		FP30	EQU		P3.0

	P4			EQU		0D4H
		FP47	EQU		P4.7
		FP46	EQU		P4.6
		FP45	EQU		P4.5
		FP44	EQU		P4.4
		FP43	EQU		P4.3
		FP42	EQU		P4.2
		FP41	EQU		P4.1
		FP40	EQU		P4.0

	P5			EQU		0D5H
		FP57	EQU		P5.7
		FP56	EQU		P5.6
		FP55	EQU		P5.5
		FP54	EQU		P5.4
		FP53	EQU		P5.3
		FP52	EQU		P5.2
		FP51	EQU		P5.1
		FP50	EQU		P5.0

	P6			EQU		0D6H
		FP67	EQU		P6.7
		FP66	EQU		P6.6
		FP65	EQU		P6.5
		FP64	EQU		P6.4
		FP63	EQU		P6.3
		FP62	EQU		P6.2
		FP61	EQU		P6.1
		FP60	EQU		P6.0

	P7			EQU		0D7H
		FP77	EQU		P7.7
		FP76	EQU		P7.6
		FP75	EQU		P7.5
		FP74	EQU		P7.4
		FP73	EQU		P7.3
		FP72	EQU		P7.2
		FP71	EQU		P7.1
		FP70	EQU		P7.0

	T0M			EQU		0D8H
		FT0ENB		EQU	T0M.7
		FT0RATE2	EQU	T0M.6
		FT0RATE1	EQU	T0M.5
		FT0RATE0	EQU	T0M.4
		FPWM1		EQU	T0M.3
		FPWM0		EQU	T0M.2
		FTC0GN		EQU	T0M.1
		FT0TB		EQU	T0M.0

	T0C			EQU		0D9H

	TC0M		EQU		0DAH
		FTC0ENB		EQU	TC0M.7
		FTC0RATE2	EQU	TC0M.6
		FTC0RATE1	EQU	TC0M.5
		FTC0RATE0	EQU	TC0M.4
		FTC0CKS		EQU	TC0M.3
		FALOAD0		EQU	TC0M.2
		FTC0OUT		EQU	TC0M.1
		FPWM0OUT	EQU	TC0M.0

	TC0C		EQU		0DBH

	TC1M		EQU		0DCH
		FTC1ENB		EQU	TC1M.7
		FTC1RATE2	EQU	TC1M.6
		FTC1RATE1	EQU	TC1M.5
		FTC1RATE0	EQU	TC1M.4
		FTC1CKS		EQU	TC1M.3
		FALOAD1		EQU	TC1M.2
		FTC1OUT		EQU	TC1M.1
		FPWM1OUT	EQU	TC1M.0

	TC1C		EQU		0DDH
	TC1R		EQU		0DEH

	STKP		EQU		0DFH
		FGIE	EQU		STKP.7
		FSTKPB3	EQU		STKP.3
		FSTKPB2	EQU		STKP.2
		FSTKPB1	EQU		STKP.1
		FSTKPB0	EQU		STKP.0

	P0UR		EQU_W	0E0H
		FP07R	EQU_W	P0UR.7
		FP06R	EQU_W	P0UR.6
		FP05R	EQU_W	P0UR.5
		FP04R	EQU_W	P0UR.4
		FP03R	EQU_W	P0UR.3
		FP02R	EQU_W	P0UR.2
		FP01R	EQU_W	P0UR.1
		FP00R	EQU_W	P0UR.0

	P1UR		EQU_W	0E1H
		FP17R	EQU_W	P1UR.7
		FP16R	EQU_W	P1UR.6
		FP15R	EQU_W	P1UR.5
		FP14R	EQU_W	P1UR.4
		FP13R	EQU_W	P1UR.3
		FP12R	EQU_W	P1UR.2
		FP11R	EQU_W	P1UR.1
		FP10R	EQU_W	P1UR.0

	P2UR		EQU_W	0E2H
		FP27R	EQU_W	P2UR.7
		FP26R	EQU_W	P2UR.6
		FP25R	EQU_W	P2UR.5
		FP24R	EQU_W	P2UR.4
		FP23R	EQU_W	P2UR.3
		FP22R	EQU_W	P2UR.2
		FP21R	EQU_W	P2UR.1
		FP20R	EQU_W	P2UR.0

	P3UR		EQU		0E3H
		FP37R	EQU		P3UR.7
		FP36R	EQU		P3UR.6
		FP35R	EQU		P3UR.5
		FP34R	EQU		P3UR.4
		FP33R	EQU		P3UR.3
		FP32R	EQU		P3UR.2
		FP31R	EQU		P3UR.1
		FP30R	EQU		P3UR.0

	P4UR		EQU		0E4H
		FP47R	EQU		P4UR.7
		FP46R	EQU		P4UR.6
		FP45R	EQU		P4UR.5
		FP44R	EQU		P4UR.4
		FP43R	EQU		P4UR.3
		FP42R	EQU		P4UR.2
		FP41R	EQU		P4UR.1
		FP40R	EQU		P4UR.0

	P5UR		EQU		0E5H
		FP57R	EQU		P5UR.7
		FP56R	EQU		P5UR.6
		FP55R	EQU		P5UR.5
		FP54R	EQU		P5UR.4
		FP53R	EQU		P5UR.3
		FP52R	EQU		P5UR.2
		FP51R	EQU		P5UR.1
		FP50R	EQU		P5UR.0

	@HL			EQU		0E6H
	DP0X		EQU		0E6H

	@YZ			EQU		0E7H
	DP1X		EQU		0E7H

	STK7L		EQU		0F0h
	STK7H		EQU		0F1h
	STK6L		EQU		0F2h
	STK6H		EQU		0F3h
	STK5L		EQU		0F4h
	STK5H		EQU		0F5h
	STK4L		EQU		0F6h
	STK4H		EQU		0F7h
	STK3L		EQU		0F8h
	STK3H		EQU		0F9h
	STK2L		EQU		0FAh
	STK2H		EQU		0FBh
	STK1L		EQU		0FCh
	STK1H		EQU		0FDh
	STK0L		EQU		0FEh
	STK0H		EQU		0FFh

.TEXT
{
	//{{SONIX_SMOV_S8KD
	-1 -1 -1 -1 -1 -1 -1 -1   -1 -1 -1 -1 -1 -1 -1 -1
	-1 -1 -1 -1 -1 -1 -1 -1   -1 -1 -1 -1 -1 -1 -1 -1
	-1 -1 -1 -1 -1 -1 -1 -1   -1 -1 -1 -1 -1 -1 -1 -1
	-1 -1 -1 -1 -1 -1 -1 -1   -1 -1 -1 -1 -1 -1 -1 -1
	-1 -1 -1 -1 -1 -1 -1 -1   -1 -1 -1 -1 -1 -1 -1 -1
	-1 -1 -1 -1 -1 -1 -1 -1   -1 -1 -1 -1 -1 -1 -1 -1
	-1 -1 -1 -1 -1 -1 -1 -1   -1 -1 -1 -1 -1 -1 -1 -1
	FF 5C 01 8F -1 -1 -1 -1   -1 -1 -1 -1 -1 -1 -1 11
	-1 -1 -1 -1 -1 -1 F0 EF   -1 -1 -1 -1 -1 -1 -1 -1
	-1 -1 -1 -1 -1 -1 -1 -1   -1 -1 -1 -1 -1 -1 -1 -1
	-1 -1 -1 -1 -1 -1 -1 -1   -1 -1 -1 -1 -1 -1 -1 -1
	-1 -1 -1 10 08 -1 -1 -1   -1 -1 -1 -1 -1 -1 3F -1
	FF -1 -1 -1 -1 -1 -1 -1   -1 7F BD -1 -1 -1 -1 -1
	FF FF FF FF FF FF FF FF   F3 -1 07 -1 -1 -1 -1 08
	-1 -1 -1 -1 -1 -1 -1 -1   -1 -1 -1 -1 -1 -1 -1 -1
	-1 -1 -1 -1 -1 -1 -1 -1   -1 -1 -1 -1 -1 -1 -1 -1
	87 00 DF 7F -1 -1
	01 71 00 01 -1
	//}}SONIX_SMOV_S8KD

	//{{SONIX_OPTION_RULE
	ENDP
	//}}SONIX_OPTION_RULE
}
