;-------------------------------------------------------------------------------
;	Crt0 For Chip SN8F27E611LEN
;-------------------------------------------------------------------------------

CHIP		SN8F27E611LEN

public I
public T
public __ClearWatchDogTimer
public __ClrRAM
Extern CODE _main

crt0@data segment data at 0x00 inbank
	I ds 1
	T ds 1


;-------------------------------------------------------------------------------
;			Code section
;-------------------------------------------------------------------------------

crt0@code segment code at 0x0
	ORG	0					;Code section start
	jmp		_sgv_init_entry		;Reset vector
	org 7
	nop


_SGV_INIT_CODE_BEGIN segment CODE 
PUBLIC _sgv_init_entry
_sgv_init_entry:

;------------------------------------------------------------------------------- 
; Initialize STKP 
	MOV A,# 0x7F 
	B0MOV STKP, A 
;------------------------------------------------------------------------------- 

;-------------------------------------------------------------------------------
; Clear Watch dog timer
;-------------------------------------------------------------------------------
	MOV A, #0x5A
	B0MOV WDTR, A
		
;-------------------------------------------------------------------------------
; Call Clear RAM : Use index @YZ to clear RAM 
;-------------------------------------------------------------------------------
	CALL __ClrRAM;
;-------------------------------------------------------------------------------

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
_SGV_INIT_CODE SEGMENT CODE BANK 0x0 INBANK
;Define a null segment

_SGV_INIT_CODE_END segment CODE  bank 0 inbank

;-------------------------------------------------------------------------------
; Clear Watch dog timer
;-------------------------------------------------------------------------------
	MOV A, #0x5A
	B0MOV WDTR, A

	JMP _main


;-------------------------------------------------------------------------------
; Clear Watch dog timer
;-------------------------------------------------------------------------------
__ClearWatchDogTimer:
	MOV A, #0x5A
	B0MOV WDTR, A
	RET
	
;-------------------------------------------------------------------------------
; ClrRAM
; Use index @YZ to clear RAM  (00h~7Fh)
;-------------------------------------------------------------------------------

__ClrRAM:

; RAM Bank 0
	clr 		Y	    		
	b0mov		Z,#0x7F		

ClrRAM10:
	clr 		@YZ				
	decms		Z   			
	jmp 		ClrRAM10
	clr 		@YZ				

	ret