; sn8cc macro file
; 2012/07/16

;include sn8cc_init.asm

extern data T
extern data _tmpA
extern data _tmpB
extern data _tmpC

DECLARE_STORE1_ICEMode = 0
DECLARE_STORE2_ICEMode = 0
DECLARE_INDIR1_ICEMode = 0
DECLARE_INDIR2_ICEMode = 0
DECLARE_STORE1_ICEMode_isr = 0
DECLARE_STORE2_ICEMode_isr = 0
DECLARE_INDIR1_ICEMode_isr = 0
DECLARE_INDIR2_ICEMode_isr = 0

DECLARE_STORE1_XMOV = 0
DECLARE_STORE2_XMOV = 0
DECLARE_INDIR1_XMOV = 0
DECLARE_INDIR2_XMOV = 0
DECLARE_STORE1_XMOV_isr = 0
DECLARE_STORE2_XMOV_isr = 0
DECLARE_INDIR1_XMOV_isr = 0
DECLARE_INDIR2_XMOV_isr = 0

DECLARE_INDIR1_ROM = 0
DECLARE_INDIR1_ROM_isr = 0

DECLARE_INIT_GLOBAL = 0

;extern code __INIT@global_
; initialize global variable
INIT@global MACRO name, start_addr, size
		
		IF DECLARE_INIT_GLOBAL == 0
			DECLARE_INIT_GLOBAL = 1
			extern code __INIT@global_
		ENDIF
		
		B0MOV Y, #(start_addr$M)
		B0MOV Z, #start_addr
		
		MOV A, #(name)$M
		B0MOV _tmpB, A
		MOV A, #(name)$L
		B0MOV _tmpA, A
		
		MOV A, #size
		B0MOV T, A
		
		CALL __INIT@global_	
	
ENDM

;-----------------------------------------------------------
; __PUSH_INSTRUCTION_MODE = 0  ==> No Push instruction
; __PUSH_INSTRUCTION_MODE = 1  ==> Push 0x80~0x87 to stack
; __PUSH_INSTRUCTION_MODE = 2  ==> Push A & PFLAG to stack
;-----------------------------------------------------------
__pushSFR MACRO
	IF __PUSH_INSTRUCTION_MODE == 1
		PUSH
		B0MOV _tmpA, A
	ENDIF

	IF __PUSH_INSTRUCTION_MODE == 2
		PUSH
		IF RBANK != 0
			B0MOV A, RBANK
			B0MOV RBANK, #(BANK _ISRRBANK)
			MOV _ISRRBANK, A
		ENDIF

		IF __INTERRUPT_BACKUP_L != 0
			IF L != 0
				B0MOV A, L
				MOV _ISRL, A	
			ENDIF
		ENDIF

		IF __INTERRUPT_BACKUP_H != 0		
			IF H != 0
				B0MOV A, H
				MOV _ISRH, A
			ENDIF
		ENDIF

		IF __INTERRUPT_BACKUP_R != 0	
			IF R != 0
				B0MOV A, R
				MOV _ISRR, A
			ENDIF	
		ENDIF	
	
		IF __INTERRUPT_BACKUP_Z != 0	
			IF Z != 0
				B0MOV A, Z
				MOV _ISRZ, A
			ENDIF
		ENDIF	
		
		IF __INTERRUPT_BACKUP_Y != 0	
			IF Y != 0
				B0MOV A, Y
				MOV _ISRY, A
			ENDIF
		ENDIF	
	
		IF __INTERRUPT_BACKUP_X != 0	
			IF X != 0
				B0MOV A, X
				MOV _ISRX, A
			ENDIF
		ENDIF	
	ENDIF

	IF __PUSH_INSTRUCTION_MODE == 0
		B0MOV _tmpA, A
		B0MOV A, PFLAG
		B0MOV _ISRPFLAG, A
		IF RBANK != 0
			B0MOV A, RBANK
			B0MOV RBANK, #(BANK _ISRRBANK)
			MOV _ISRRBANK, A
		ENDIF

		IF __INTERRUPT_BACKUP_L != 0
			IF L != 0
				B0MOV A, L
				MOV _ISRL, A	
			ENDIF
		ENDIF

		IF __INTERRUPT_BACKUP_H != 0		
			IF H != 0
				B0MOV A, H
				MOV _ISRH, A
			ENDIF
		ENDIF

		IF __INTERRUPT_BACKUP_R != 0	
			IF R != 0
				B0MOV A, R
				MOV _ISRR, A
			ENDIF	
		ENDIF	
	
		IF __INTERRUPT_BACKUP_Z != 0	
			IF Z != 0
				B0MOV A, Z
				MOV _ISRZ, A
			ENDIF
		ENDIF	
		
		IF __INTERRUPT_BACKUP_Y != 0	
			IF Y != 0
				B0MOV A, Y
				MOV _ISRY, A
			ENDIF
		ENDIF	
	
		IF __INTERRUPT_BACKUP_X != 0	
			IF X != 0
				B0MOV A, X
				MOV _ISRX, A
			ENDIF
		ENDIF	
	ENDIF
ENDM


;;Backup src to dst, size = 1, 2, 4;
;;src is at bank0, dst's bank is set in macro "__pushInterruptSavedRegs"
__pushISR MACRO dst, src, size
	B0MOV A, src
	MOV dst, A
	IF size > 1
		B0MOV A, src+1
		MOV dst+1, A
	ENDIF
	IF size > 2
		B0MOV A, src+2
		MOV dst+2, A
		B0MOV A, src+3
		MOV dst+3, A
	ENDIF
ENDM

__popSFR MACRO

	IF __PUSH_INSTRUCTION_MODE == 1
		B0XCH A, _tmpA
		POP
	ENDIF

	IF __PUSH_INSTRUCTION_MODE == 2
		IF __INTERRUPT_BACKUP_L != 0	
			IF L != 0
				MOV A, _ISRL
				B0MOV L, A
			ENDIF
		ENDIF	
		
		IF __INTERRUPT_BACKUP_H != 0	
			IF H != 0
				MOV A, _ISRH
				B0MOV H, A
			ENDIF
		ENDIF	

		IF __INTERRUPT_BACKUP_R != 0
			IF R != 0		
				MOV A, _ISRR
				B0MOV R, A
			ENDIF
		ENDIF	
	
		IF __INTERRUPT_BACKUP_Z != 0		
			IF Z != 0
				MOV A, _ISRZ
				B0MOV Z, A
			ENDIF
		ENDIF	

		IF __INTERRUPT_BACKUP_Y != 0		
			IF Y != 0
				MOV A, _ISRY
				B0MOV Y, A
			ENDIF
		ENDIF	

		IF __INTERRUPT_BACKUP_X != 0		
			IF X != 0
				MOV A, _ISRX
				B0MOV X, A
			ENDIF
		ENDIF
			
		IF RBANK != 0
			MOV A, _ISRRBANK
			B0MOV RBANK, A
		ENDIF
		POP
	ENDIF

	IF __PUSH_INSTRUCTION_MODE == 0
		IF __INTERRUPT_BACKUP_L != 0	
			IF L != 0
				MOV A, _ISRL
				B0MOV L, A
			ENDIF
		ENDIF	
		
		IF __INTERRUPT_BACKUP_H != 0	
			IF H != 0
				MOV A, _ISRH
				B0MOV H, A
			ENDIF
		ENDIF	

		IF __INTERRUPT_BACKUP_R != 0
			IF R != 0		
				MOV A, _ISRR
				B0MOV R, A
			ENDIF
		ENDIF	
	
		IF __INTERRUPT_BACKUP_Z != 0		
			IF Z != 0
				MOV A, _ISRZ
				B0MOV Z, A
			ENDIF
		ENDIF	

		IF __INTERRUPT_BACKUP_Y != 0		
			IF Y != 0
				MOV A, _ISRY
				B0MOV Y, A
			ENDIF
		ENDIF	

		IF __INTERRUPT_BACKUP_X != 0		
			IF X != 0
				MOV A, _ISRX
				B0MOV X, A
			ENDIF
		ENDIF
			
		IF RBANK != 0
			MOV A, _ISRRBANK
			B0MOV RBANK, A
		ENDIF
		B0MOV A, _ISRPFLAG
		B0MOV PFLAG, A
		B0XCH A, _tmpA
	ENDIF
ENDM


;;Restore src to dst, size = 1, 2, 4;
;;dst is at bank0, src's bank is already set 
__popISR MACRO dst, src, size
	IF size > 2
		MOV A, src+3
		B0MOV dst+3, A
		MOV A, src+2
		B0MOV dst+2, A
	ENDIF
	IF size > 1
		MOV A, src+1
		B0MOV dst+1, A
	ENDIF
	MOV A, src
	B0MOV dst, A
ENDM

;-------------------------------------
; Change selecting bank by bank(name)
;-------------------------------------
__SelectBANK MACRO name
	IF RBANK != 0
		B0MOV RBANK, #(BANK (name))
	ENDIF	
ENDM

;-------------------------------------
; Change selecting bank by bank const#
;-------------------------------------
__SelectBANKCNST MACRO name
	IF RBANK != 0
		B0MOV RBANK, #(name)
	ENDIF
ENDM

;-------------------------------------
; Move 2 bytes from src to dst
; Assume both are in bank 0 
;-------------------------------------
__MOV2 MACRO dst, src

	;__SelectBANK src
	B0MOV A, src
	;__SelectBANK dst
	B0MOV dst, A
	
	;__SelectBANK src
	B0MOV A, (src+1)
	;__SelectBANK dst
	B0MOV (dst+1), A
	
ENDM

;-------------------------------------
; Load 1 bytes from src to dst
; Assume both are in bank 0 
; Spec:	1. Source located at Y, Z.
;			with high-byte Y, low-byte Z.
;		2. Destination at A
;-------------------------------------
__INDIR1 MACRO inISR

	LOCAL _INDIRRAM,_ENDINDIR, _INDIR_ATYZ
	
	; check ram or rom
	B0BTS1 Y.7
	JMP _INDIRRAM
	;B0BCLR Y.7
	;MOVC


	IF inISR == 1
		CALL __INDIR1_ROM_isr
	ELSE
		CALL __INDIR1_ROM
	ENDIF
	JMP _ENDINDIR
	
_INDIRRAM:
	IF (ICE_Mode == 1)
		IF ((SN8P1909==1) || (SN8P1908==1) ||(SN8P1819A==1)|| (SN8P1829==1) || (SN8P1907==1) || (SN8P1919==1) || (SN8P1917==1) || (SN8P1927==1) || (SN8P1927A==1) || (SN8P1929==1) || (SN8P1937 == 1) || (SN8P1989==1))
			IF inISR == 1
				IF DECLARE_INDIR1_ICEMode_isr == 0
					extern code __INDIR1_ICEMode_isr
					DECLARE_INDIR1_ICEMode_isr = 1
				ENDIF
				CALL __INDIR1_ICEMode_isr
			ELSE
				IF DECLARE_INDIR1_ICEMode==0
					extern code __INDIR1_ICEMode
					DECLARE_INDIR1_ICEMode = 1
				ENDIF
				CALL __INDIR1_ICEMode
			ENDIF
		ELSE
			; indir from ram
			B0MOV A, @YZ		
		ENDIF
	ELSE
		; indir from ram
		B0MOV A, @YZ	
	ENDIF
_ENDINDIR:
ENDM



;-------------------------------------
; Load 1 bytes from src to dst
; Assume both are in bank 0 
; Spec:	1. Source located at Y, Z.
;			with high-byte Y, low-byte Z.
;		2. Destination at A
;-------------------------------------
__INDIR1RAM MACRO inISR

LOCAL _INDIR1RAM,_ENDINDIR


	IF (ICE_Mode == 1)
		IF ((SN8P1909==1) || (SN8P1908==1) ||(SN8P1819A==1)|| (SN8P1829==1) || (SN8P1907==1) || (SN8P1919==1) || (SN8P1917==1)|| (SN8P1929==1) || (SN8P1927A==1) || (SN8P1927==1) || (SN8P1937 == 1) || (SN8P1989==1))
			IF inISR == 1
				IF DECLARE_INDIR1_ICEMode_isr == 0
					extern code __INDIR1_ICEMode_isr
					DECLARE_INDIR1_ICEMode_isr = 1
				ENDIF
				CALL __INDIR1_ICEMode_isr
			ELSE
				IF DECLARE_INDIR1_ICEMode==0
					extern code __INDIR1_ICEMode
					DECLARE_INDIR1_ICEMode = 1
				ENDIF
				CALL __INDIR1_ICEMode
			ENDIF
		ELSE
			; indir from ram
			B0MOV A, @YZ		
		ENDIF
	ELSE
		; indir from ram
		B0MOV A, @YZ	
	ENDIF
_ENDINDIR:
ENDM


;-------------------------------------
; Load 1 bytes from src to dst
; Assume both are in bank 0 
; Spec:	1. Source located at Y, Z.
;			with high-byte Y, low-byte Z.
;		2. Destination at A
;-------------------------------------
__INDIR1ROM MACRO inISR
	IF inISR == 1
		CALL __INDIR1_ROM_isr
	ELSE
		CALL __INDIR1_ROM
	ENDIF
ENDM

;-------------------------------------
; Load 1 bytes from src to dst
; Assume RBANK has been set in bank 0 
; Spec:	1. Source located at Y, Z.
;			with high-byte Y, low-byte Z.
;		2. Destination at A
;		3. inISR 1[0] In[Not in] interrupt
;-------------------------------------
__INDIR1XMOV MACRO inISR
	IF inISR == 1
		IF DECLARE_INDIR1_XMOV_isr == 0
			extern code __INDIR1_XMOV_isr
			DECLARE_INDIR1_XMOV_isr = 1
		ENDIF
		CALL __INDIR1_XMOV_isr
	ELSE
		IF DECLARE_INDIR1_XMOV==0
			extern code __INDIR1_XMOV
			DECLARE_INDIR1_XMOV = 1
		ENDIF
		CALL __INDIR1_XMOV
	ENDIF
ENDM

;-------------------------------------
; Store 1 bytes constant value #src to dst
; Assume memory dst is in bank 0 
; Spec:	1. Destination located at Y, Z.
;			with high-byte Y, low-byte Z.
;		2. 
;-------------------------------------
__STORE1CNST MACRO src, inISR

	LOCAL _INDIRRAM,_ENDINDIR
	; check ram or rom
	;B0BTS1 Y.7
	;JMP _INDIRRAM
	;.ERROR WRITE to ROM
	;JMP _ENDINDIR
	
_INDIRRAM:
	; indir from ram
	
	// 2005-07-06	Joe
	MOV A, #(src & 0xFF)
	IF ICE_Mode == 1
		IF ((SN8P1909==1) || (SN8P1908==1) ||(SN8P1819A==1)|| (SN8P1829==1) || (SN8P1907==1) || (SN8P1919==1) || (SN8P1917==1)|| (SN8P1929==1) || (SN8P1927==1) || (SN8P1927A==1) || (SN8P1937 == 1) || (SN8P1989==1) )	    
			IF inISR == 1
				IF DECLARE_STORE1_ICEMode_isr==0
					extern code __STORE1_ICEMode_isr
					DECLARE_STORE1_ICEMode_isr = 1
				ENDIF
				CALL __STORE1_ICEMode_isr
			ELSE
				IF DECLARE_STORE1_ICEMode==0
					extern code __STORE1_ICEMode
					DECLARE_STORE1_ICEMode = 1
				ENDIF
				CALL __STORE1_ICEMode
			ENDIF
		ELSE
			B0MOV @YZ, A	
		ENDIF
	ELSE
		B0MOV @YZ, A	
	ENDIF
_ENDINDIR:

ENDM


;-------------------------------------
; Store 1 bytes constant value from A to dst pointed by @YZ
; Assume RBNAK had been set to 0
; Spec:	1. Destination located at Y, Z.
;			with high-byte Y, low-byte Z.
;		2. src constant value A
;-------------------------------------
__STORE1CNSTXMOV MACRO inISR

	IF inISR == 1

	IF DECLARE_STORE1_XMOV_isr==0

	extern code __STORE1_XMOV_isr
	DECLARE_STORE1_XMOV_isr = 1

	ENDIF

	CALL __STORE1_XMOV_isr


	ELSE

	IF DECLARE_STORE1_XMOV==0

	extern code __STORE1_XMOV
	DECLARE_STORE1_XMOV = 1

	ENDIF

	CALL __STORE1_XMOV

	ENDIF
ENDM


;-------------------------------------
; Store 1 bytes from memory src to dst
; Assume both memory src, dst are in bank 0 
; Spec:	1. Destination located at Y, Z.
;			with high-byte Y, low-byte Z.
;		2. Source located at A
;-------------------------------------
__STORE1 MACRO inISR

	LOCAL _INDIRRAM,_ENDINDIR
	
	; check ram or rom
;	B0BTS1 Y.7
;	JMP _INDIRRAM
	;.ERROR WRITE to ROM
;	JMP _ENDINDIR
	
_INDIRRAM:
	; store to ram
	IF ICE_Mode == 1
		IF ((SN8P1909==1) || (SN8P1908==1) ||(SN8P1819A==1)|| (SN8P1829==1) || (SN8P1907==1) || (SN8P1919==1) || (SN8P1917==1) || (SN8P1929==1) || (SN8P1927==1) || (SN8P1927A==1) || (SN8P1937 == 1) || (SN8P1989==1))
			IF inISR == 1
				IF DECLARE_STORE1_ICEMode_isr==0
					extern code __STORE1_ICEMode_isr
					DECLARE_STORE1_ICEMode_isr = 1
				ENDIF
				CALL __STORE1_ICEMode_isr
			ELSE
				IF DECLARE_STORE1_ICEMode==0
					extern code __STORE1_ICEMode
					DECLARE_STORE1_ICEMode = 1
				ENDIF
				CALL __STORE1_ICEMode
			ENDIF
		ELSE
			B0MOV @YZ, A
		ENDIF
	ELSE
		B0MOV @YZ, A
	ENDIF	
_ENDINDIR:

ENDM


;-------------------------------------
; Store 2 bytes from memory src to dst
; Assume both memory src, dst are in bank 0 
; Spec:	1. Destination located at Y, Z.
;			with high-byte Y, low-byte Z.
;		2. Source located at A, R
;			with high-byte R, low-byte A
;-------------------------------------
__STORE2 MACRO inISR

	LOCAL _INDIRRAM,_ENDINDIR
	
	; check ram or rom
;	B0BTS1 Y.7
;	JMP _INDIRRAM
	;.ERROR WRITE to ROM
;	JMP _ENDINDIR
	
_INDIRRAM:
IF ICE_Mode == 1
	IF ((SN8P1909==1) || (SN8P1908==1) ||(SN8P1819A==1)|| (SN8P1829==1) || (SN8P1907==1) || (SN8P1919==1) || (SN8P1917==1) || (SN8P1929==1) || (SN8P1927==1) || (SN8P1927A==1) || (SN8P1937 == 1) || (SN8P1989==1))
		IF inISR == 1
			IF DECLARE_STORE2_ICEMode_isr==0
				extern code __STORE2_ICEMode_isr
				DECLARE_STORE2_ICEMode_isr = 1
			ENDIF
			CALL __STORE2_ICEMode_isr
		ELSE
			IF DECLARE_STORE2_ICEMode==0
				extern code __STORE2_ICEMode
				DECLARE_STORE2_ICEMode = 1
			ENDIF
			CALL __STORE2_ICEMode
		ENDIF
	ELSE
		; indir from ram
		B0MOV @YZ, A
		//2006-12-06 HY modified for run-time library optimization
		;MOV A, #1
		;B0ADD Z, A
	  __SelectBANKCNST 0
		INCMS Z
		B0MOV A, R
		B0MOV @YZ, A	
	ENDIF
ELSE
	; indir from ram
	B0MOV @YZ, A
	//2006-12-06 HY modified for run-time library optimization
	;MOV A, #1
	;B0ADD Z, A
	__SelectBANKCNST 0
  INCMS Z
	B0MOV A, R
	B0MOV @YZ, A
ENDIF
_ENDINDIR:

ENDM

;-------------------------------------
; Store 2 bytes from const value #src to dst
; Spec:	1. Destination located at Y, Z.
;			with high-byte Y, low-byte Z.
;-------------------------------------
__STORE2CNST MACRO src, inISR

	LOCAL _INDIRRAM,_ENDINDIR
	
	; check ram or rom
	;B0BTS1 Y.7
	;JMP _INDIRRAM
	;.ERROR WRITE to ROM
	;JMP _ENDINDIR
	
_INDIRRAM:
IF ICE_Mode == 1
		IF ((SN8P1909==1) || (SN8P1908==1) ||(SN8P1819A==1) || (SN8P1829==1) || (SN8P1907==1) || (SN8P1919==1) || (SN8P1917==1) || (SN8P1929==1) || (SN8P1927==1) || (SN8P1927A==1) || (SN8P1937 == 1) || (SN8P1989==1))

		IF (src <0xFF)
			B0MOV R, #0
		ELSE
			MOV A, #((src >> 8 ) & 0xFF)
			B0MOV R, A
		ENDIF
		MOV A, #(src & 0xFF)
		//B0MOV T, A

		IF inISR == 1
			IF DECLARE_STORE2_ICEMode_isr==0
				extern code __STORE2_ICEMode_isr
				DECLARE_STORE2_ICEMode_isr = 1
			ENDIF
			CALL __STORE2_ICEMode_isr
		ELSE
			IF DECLARE_STORE2_ICEMode==0
				extern code __STORE2_ICEMode
				DECLARE_STORE2_ICEMode = 1
			ENDIF
			CALL __STORE2_ICEMode
		ENDIF
	ELSE
		MOV A, #(src & 0xFF)
		B0MOV @YZ, A
		//2005-11-24
		//2006-12-06 HY modified for run-time library optimization
		;MOV A, #1
		;B0ADD Z, A
		__SelectBANKCNST 0
		INCMS Z
		MOV A, #((src >> 8 ) & 0xFF)
		B0MOV @YZ, A	
	ENDIF
ELSE
	MOV A, #(src & 0xFF)
	B0MOV @YZ, A
	//2005-11-24
	//2006-12-06 HY modified for run-time library optimization
	;MOV A, #1
	;B0ADD Z, A
	__SelectBANKCNST 0
	INCMS Z
	MOV A, #((src >> 8 ) & 0xFF)
	B0MOV @YZ, A
ENDIF
_ENDINDIR:

ENDM


;-------------------------------------
; Store 4 bytes constant value #src to dst
; Assume memory dst is in bank 0 
;-------------------------------------
__STORE4CNST MACRO byte3, byte2, byte1, byte0
	LOCAL _INDIRRAM,_ENDINDIR
	
	; check ram or rom
	//2006-12-06 HY modified for run-time library optimization
	;B0BTS1 Y.7
	;JMP _INDIRRAM
	;.ERROR WRITE to ROM
	;JMP _ENDINDIR
_INDIRRAM:
	MOV A, #byte0
	B0MOV @YZ, A
	//2006-12-05 HY modified for run-time library optimization
;	MOV A, #1
;	B0ADD Z, A
	__SelectBANKCNST 0	
	INCMS Z
	MOV A, #byte1
	B0MOV @YZ, A
	//2005-11-24
	//2006-12-05 HY modified for run-time library optimization
;	MOV A, #1
;	B0ADD Z, A
;	__SelectBANKCNST 0	
	INCMS Z
	MOV A, #byte2
	B0MOV @YZ, A
	//2005-11-24
	//2006-12-05 HY modified for run-time library optimization
;	MOV A, #1
;	B0ADD Z, A
;	__SelectBANKCNST 0
	INCMS Z
	MOV A, #byte3
	B0MOV @YZ, A
_ENDINDIR:

ENDM


;-------------------------------------
; Store 4 bytes from memory src to dst
; Assume both memory src, dst are in bank 0 
; Spec:	1. Destination located at Y, Z.
;			with high-byte Y, low-byte Z.
;		2. Source located at bank 0
;-------------------------------------
__STORE4 MACRO src

	LOCAL _INDIRRAM,_ENDINDIR
	; check ram or rom
;	B0BTS1 Y.7
;	JMP _INDIRRAM
	;.ERROR WRITE to ROM
;	JMP _ENDINDIR
	
_INDIRRAM:
	B0MOV A, src
	B0MOV @YZ, A
	//2006-12-05 HY modified for run-time library optimization
;	MOV A, #1
;	B0ADD Z, A
	__SelectBANKCNST 0	
	INCMS Z
	B0MOV A, src+1
	B0MOV @YZ, A
	//2006-12-05 HY modified for run-time library optimization
;	MOV A, #1
;	B0ADD Z, A
;	__SelectBANKCNST 0
	INCMS Z
	B0MOV A, src+2
	B0MOV @YZ, A
	//2006-12-05 HY modified for run-time library optimization
;	MOV A, #1
;	B0ADD Z, A
;	__SelectBANKCNST 0	
	INCMS Z	
	B0MOV A, src+3
	B0MOV @YZ, A	
_ENDINDIR:

ENDM


;-------------------------------------
; Load 2 bytes from src to dst
; Assume both are in bank 0 
; Spec:	1. Assume that Source are located at Y, Z.
;			with high-byte Y, low-byte Z.
;		2. Destination at T, A
;			with high-byte A, low-byte T.
;-------------------------------------
__INDIR2 MACRO inISR

	LOCAL _INDIRRAM,_ENDINDIR
	; check ram or rom
	B0BTS1 Y.7
	JMP _INDIRRAM
;	B0BCLR Y.7
;	MOVC
;	B0MOV T, A
;	MOV A, #1
;	B0ADD Z, A
;	MOVC

	IF inISR == 1
		CALL __INDIR2_ROM_isr
	ELSE
		CALL __INDIR2_ROM
	ENDIF
	JMP _ENDINDIR
	
_INDIRRAM:
IF ICE_Mode == 1
	IF ((SN8P1909==1) || (SN8P1908==1) ||(SN8P1819A==1)|| (SN8P1829==1) || (SN8P1907==1) || (SN8P1919==1) || (SN8P1917==1)|| (SN8P1929==1) || (SN8P1927==1) || (SN8P1927A==1) || (SN8P1937 == 1) || (SN8P1989==1))
		IF inISR == 1
			IF DECLARE_INDIR2_ICEMode_isr==0
				extern code __INDIR2_ICEMode_isr
				DECLARE_INDIR2_ICEMode_isr = 1
			ENDIF
			CALL __INDIR2_ICEMode_isr
		ELSE
			IF DECLARE_INDIR2_ICEMode==0
				extern code __INDIR2_ICEMode
				DECLARE_INDIR2_ICEMode = 1
			ENDIF
			CALL __INDIR2_ICEMode
		ENDIF
	ELSE
		; indir from ram
		B0MOV A, @YZ	
		B0MOV T, A
		//2006-12-05 HY modified for run-time library optimization
	  ;MOV A, #1
	  ;B0ADD Z, A
	  __SelectBANKCNST 0
		INCMS Z
		B0MOV A, @YZ	
	ENDIF
ELSE
	; indir from ram
	B0MOV A, @YZ	
	B0MOV T, A
	//2006-12-05 HY modified for run-time library optimization
  ;MOV A, #1
  ;B0ADD Z, A
  __SelectBANKCNST 0
	INCMS Z
	B0MOV A, @YZ	
ENDIF
_ENDINDIR:
ENDM


;-------------------------------------
; Load 2 bytes from ram src to dst
; Assume both are in bank 0 
; Spec:	1. Assume that Source are located at Y, Z.
;			with high-byte Y, low-byte Z.
;		2. Destination at T, A
;			with high-byte A, low-byte T.
;-------------------------------------
__INDIR2RAM MACRO inISR

	LOCAL _INDIRRAM,_ENDINDIR
_INDIRRAM:
IF ICE_Mode == 1
	IF ((SN8P1909==1) || (SN8P1908==1) ||(SN8P1819A==1)|| (SN8P1829==1) || (SN8P1907==1) || (SN8P1919==1) || (SN8P1917==1) || (SN8P1929==1) || (SN8P1927==1) || (SN8P1927A==1) || (SN8P1937 == 1) || (SN8P1989==1))
		IF inISR == 1
			IF DECLARE_INDIR2_ICEMode_isr==0
				extern code __INDIR2_ICEMode_isr
				DECLARE_INDIR2_ICEMode_isr = 1
			ENDIF
			CALL __INDIR2_ICEMode_isr
		ELSE
			IF DECLARE_INDIR2_ICEMode==0
				extern code __INDIR2_ICEMode
				DECLARE_INDIR2_ICEMode = 1
			ENDIF
			CALL __INDIR2_ICEMode
		ENDIF
	ELSE
		; indir from ram
		B0MOV A, @YZ
		B0MOV T, A
		//2006-12-05 HY modified for run-time library optimization	
	 ;MOV A, #1
	 ;B0ADD Z, A
	  __SelectBANKCNST 0
		INCMS Z
		B0MOV A, @YZ	
	ENDIF
ELSE
	; indir from ram
	B0MOV A, @YZ	
	B0MOV T, A
	//2006-12-05 HY modified for run-time library optimization	
  ;MOV A, #1
  ;B0ADD Z, A
  __SelectBANKCNST 0
	INCMS Z
	B0MOV A, @YZ	
ENDIF
_ENDINDIR:
ENDM

;-------------------------------------
; Load 2 bytes from Rom src to dst
; Assume both are in bank 0 
; Spec:	1. Assume that Source are located at Y, Z.
;			with high-byte Y, low-byte Z.
;		2. Destination at T, A
;			with high-byte A, low-byte T.
;-------------------------------------
//2006-10-31 hy modified for RAM/ROM pointer optimization 
;__INDIR2ROM MACRO inISR
;	MOVC
;	B0MOV T, A
	;MOV A, #1
	;B0ADD Z, A
	;MOVC
;ENDM
//2006-10-27 HY modify for RAM/ROM pointer optimization
__INDIR2ROM MACRO inISR
	IF inISR == 1
		CALL __INDIR2_ROM_isr
	ELSE
		CALL __INDIR2_ROM
	ENDIF
ENDM

;-------------------------------------
; Load 4 bytes from src to dst
; Assume both are in bank 0 
;-------------------------------------
;-------------------------------------
; Load 4 bytes from src to dst
; Assume both are in bank 0 
; Spec:	1. Assume that Source are located at Y, Z.
;			with high-byte Y, low-byte Z.
;		2. Destination must be continuously var within ram bank 0
;-------------------------------------
__INDIR4 MACRO dst, inISR

	LOCAL _INDIRRAM,_ENDINDIR

	; check ram or rom
	B0BTS1 Y.7
	JMP _INDIRRAM
	;B0BCLR Y.7
	;MOVC
	;B0MOV dst, A	
	;MOV A, #1
	;B0ADD Z, A
	;MOVC
	;B0MOV (dst+1), A	
	;MOV A, #1
	;B0ADD Z, A
	;MOVC
	;B0MOV (dst+2), A	
	;MOV A, #1
	;B0ADD Z, A
	;MOVC
	;B0MOV (dst+3), A
	IF inISR == 1
		CALL __INDIR4_ROM_isr
	ELSE
		CALL __INDIR4_ROM
	ENDIF
	B0MOV (dst+1), A
	B0MOV A, T
	B0MOV (dst), A
	B0MOV A, Y
	B0MOV (dst+2), A
	B0MOV A, R
	B0MOV (dst+3), A
	JMP _ENDINDIR	
_INDIRRAM:
	; indir from ram
	B0MOV A, @YZ	
	B0MOV dst, A
	//2006-12-05 HY modified for run-time library optimization	
   ;MOV A, #1
   ;B0ADD Z, A
   	__SelectBANKCNST 0
	INCMS Z
	B0MOV A, @YZ	
	B0MOV (dst+1), A
	//2006-12-05 HY modified for run-time library optimization	
   ;MOV A, #1
   ;B0ADD Z, A
   ;__SelectBANKCNST 0
	INCMS Z
	B0MOV A, @YZ	
	B0MOV (dst+2), A	
	//2006-12-05 HY modified for run-time library optimization	
   ;MOV A, #1
   ;B0ADD Z, A
   ;__SelectBANKCNST 0
	INCMS Z
	B0MOV A, @YZ	
	B0MOV (dst+3), A		
_ENDINDIR:
	
ENDM

;2006-11-1 HY add __INDIR4RAM marco for RAM/ROM pointer optimzation
__INDIR4RAM MACRO dst, inISR

LOCAL _INDIRRAM,_ENDINDIR

_INDIRRAM:
	; indir from ram
	B0MOV A, @YZ	
	B0MOV dst, A
	//2006-12-05 HY modified for run-time library optimization
	;MOV A, #1
	;B0ADD Z, A
	__SelectBANKCNST 0
	INCMS Z
	B0MOV A, @YZ	
	B0MOV (dst+1), A
	//2006-12-05 HY modified for run-time library optimization	
	;MOV A, #1
	;B0ADD Z, A
	;__SelectBANKCNST 0
	INCMS Z
	B0MOV A, @YZ	
	B0MOV (dst+2), A
	//2006-12-05 HY modified for run-time library optimization	
	;MOV A, #1
	;B0ADD Z, A
	;__SelectBANKCNST 0
	INCMS Z
	B0MOV A, @YZ	
	B0MOV (dst+3), A		
_ENDINDIR:
ENDM

;2006-11-1 HY add __INDIR4ROM marco for RAM/ROM pointer optimzation
__INDIR4ROM MACRO dst, inISR

  IF inISR == 1
		CALL __INDIR4_ROM_isr
	ELSE
		CALL __INDIR4_ROM
	ENDIF
//2006-12-05 HY removed follow instruction ,use the register to replace	
	B0MOV (dst+1), A
	B0MOV A, T
	B0MOV (dst), A
	B0MOV A, Y
	B0MOV (dst+2), A
	B0MOV A, R
	B0MOV (dst+3), A
ENDM



__EXT MACRO
	AND A, #0x80
	B0BTS1 FZ
	MOV A, #0xFF

/*
;	LOCAL _NOEXT, _EXIT
;	AND A, #0x80
;	B0BTS0 FZ
;	JMP _NOEXT
;	MOV A, #0xFF
;	JMP _EXIT
;_NOEXT:
;	MOV A, #0x0
;_EXIT:
*/
ENDM


;block move
__BMOV_DI MACRO dst_bank, dst, src_bank, src, count

	LOCAL __LOOP
IF H != 0
	__SelectBANK src_bank
	MOV A, (src+1)
	AND A, #0x7f
	B0MOV Y, A
	MOV A, (src)
	B0MOV Z, A
	IF __NO_B0MOVMI_INSTRUCTOIN == 0
		B0MOV H, #(BANK dst_bank)
		B0MOV L, #(dst)
	ELSE
		MOV  A, #(BANK dst_bank)
		B0MOV H, A
		MOV A, #(dst)	
		B0MOV L, A
	ENDIF
	MOV A, #(count)
	B0MOV T, A
	__SelectBANKCNST 0
__LOOP:
	B0MOV A, @YZ
	MOV @HL, A
	MOV A, #1
	ADD Z, A
	ADD L, A
	DECMS T
	JMP __LOOP	
ELSE
	MOV A, #(count)
	B0MOV T, A
__LOOP:
	__SelectBANK src_bank
	MOV A, (src+1)
	AND A, #0x7f
	B0MOV Y, A
	B0MOV A, T
	ADD A, (src)
	SUB A , #1
	B0MOV Z, A
	B0MOV A, @YZ
	B0MOV _tmpA, A

	
	IF __NO_B0MOVMI_INSTRUCTOIN == 0
		B0MOV Y, #(BANK dst_bank)
	ELSE
		MOV  A, #(BANK dst_bank)
		B0MOV Y, A
	ENDIF
	B0MOV A, T
	ADD A, #(dst)
	SUB A, #1
	B0MOV Z, A
	B0MOV A, _tmpA
	B0MOV @YZ, A
	__SelectBANKCNST 0
	DECMS T
	JMP __LOOP
ENDIF
ENDM


__BMOV_ID MACRO dst_bank, dst, src_bank, src, count

	LOCAL __LOOP
IF H != 0
	IF __NO_B0MOVMI_INSTRUCTOIN == 0
		B0MOV Y, #(BANK src_bank)
		B0MOV Z, #(src)
	ELSE
		MOV  A, #(BANK src_bank)
		B0MOV Y, A
		MOV A, #(src)	
		B0MOV Z, A
	ENDIF

	__SelectBANK dst_bank
	MOV A, (dst+1)
	AND A, #0x7f
	B0MOV H, A
	MOV A, (dst)
	B0MOV L, A

	MOV A, #(count)
	B0MOV T, A
	__SelectBANKCNST 0
__LOOP:
	B0MOV A, @YZ
	MOV @HL, A
	MOV A, #1
	ADD Z, A
	ADD L, A
	DECMS T
	JMP __LOOP	
ELSE
	MOV A, #(count)
	B0MOV T, A
__LOOP:
	IF __NO_B0MOVMI_INSTRUCTOIN == 0
		B0MOV Y, #(BANK src_bank)
	ELSE
		MOV  A, #(BANK src_bank)
		B0MOV Y, A
	ENDIF
	B0MOV A, T
	ADD A, #(src)
	SUB A, #1
	B0MOV Z, A	
	B0MOV A, @YZ
	B0MOV _tmpA, A

	__SelectBANK dst_bank
	MOV A, (dst+1)
	AND A, #0x7f
	B0MOV Y, A
	B0MOV A, T
	ADD A, (dst)
	SUB A, #1
	B0MOV Z, A
	B0MOV A, _tmpA
	B0MOV @YZ, A
	__SelectBANKCNST 0
	DECMS T
	JMP __LOOP	
ENDIF
ENDM

__BMOV_II MACRO dst_bank, dst, src_bank, src, count
LOCAL __LOOP
IF H != 0
	__SelectBANK src_bank
	MOV A, (src+1)
	AND A, #0x7f
	B0MOV Y, A
	MOV A, (src)
	B0MOV Z, A

	__SelectBANK dst_bank
	MOV A, (dst+1)
	AND A, #0x7f
	B0MOV H, A
	MOV A, (dst)
	B0MOV L, A

	MOV A, #(count)
	B0MOV T, A
	__SelectBANKCNST 0
__LOOP:
	B0MOV A, @YZ
	MOV @HL, A
	MOV A, #1
	ADD Z, A
	ADD L, A
	DECMS T
	JMP __LOOP
ELSE
	MOV A, #count
	B0MOV T, A
__LOOP:
	__SelectBANK src_bank
	MOV A, (src+1)
	AND A, #0x7f
	B0MOV Y, A
	B0MOV A, T
	ADD A, (src)
	SUB A, #1
	B0MOV Z, A
	B0MOV A, @YZ
	B0MOV _tmpA, A

	__SelectBANK dst_bank
	MOV A, (dst+1)
	AND A, #0x7f
	B0MOV Y, A
	B0MOV A, T
	ADD A, (dst)
	SUB A, #1
	B0MOV Z, A
	B0MOV A, _tmpA
	B0MOV @YZ, A
	__SelectBANKCNST 0
	DECMS T
	JMP __LOOP
ENDIF
ENDM

__BMOV_DD MACRO dst_bank, dst, src_bank, src, count
	LOCAL __LOOP
IF H != 0
	IF __NO_B0MOVMI_INSTRUCTOIN == 0
		B0MOV Y, #(BANK src_bank)
		B0MOV Z, #(src)
		B0MOV H, #(BANK dst_bank)
		B0MOV L, #(dst)
	ELSE
		MOV A, #(BANK src_bank)
		B0MOV Y, A
		MOV A, #(src)
		B0MOV Z, A
		MOV  A, #(BANK dst_bank)
		B0MOV H, A
		MOV A, #(dst)	
		B0MOV L, A
	ENDIF
	MOV A, #(count)
	B0MOV T, A
	__SelectBANKCNST 0
__LOOP:
	B0MOV A, @YZ
	MOV @HL, A
	MOV A, #1
	ADD Z, A
	ADD L, A
	DECMS T
	JMP __LOOP
ELSE
	MOV A, #(count)
	B0MOV T, A		
	__SelectBANKCNST 0
__LOOP:
	B0MOV Y, #(BANK src_bank)
	B0MOV A, T
	ADD	  A, #(src)
	SUB	  A, #1
	B0MOV Z, A
	B0MOV A, @YZ
	B0MOV _tmpA, A

	B0MOV Y, #(BANK dst_bank)
	B0MOV A, T
	ADD	  A, #(dst)
	SUB	  A, #1
	B0MOV Z, A
	B0MOV A, _tmpA
	B0MOV	  @YZ, A
	__SelectBANKCNST 0
	DECMS T
	JMP __LOOP
	
ENDIF

ENDM

;src is in rom
__BMOV_DD_ROM MACRO dst_bank, dst, src_bank, src, count
	LOCAL __LOOP
IF H != 0
	IF __NO_B0MOVMI_INSTRUCTOIN == 0
		B0MOV Y, #(src_bank)$M
		B0MOV Z, #(src)$L
		B0MOV H, #(BANK dst_bank)
		B0MOV L, #(dst)
	ELSE
		MOV A, #(src_bank)$M
		B0MOV Y, A
		MOV A, #(src)$L
		B0MOV Z, A
		MOV  A, #(dst_bank)$M
		B0MOV H, A
		MOV A, #(dst)$L	
		B0MOV L, A
	ENDIF
	MOV A, #(count)
	B0MOV T, A
	__SelectBANKCNST 0
__LOOP:
	MOVC
	MOV @HL, A
	MOV A, #1
	ADD Z, A
	ADD L, A
	DECMS T
	JMP __LOOP
ELSE
	MOV A, #(count)
	B0MOV T, A		
	__SelectBANKCNST 0
__LOOP:
	B0MOV Y, #(src_bank)$M
	B0MOV A, T
	ADD	  A, #(src)$L
	SUB	  A, #1
	B0MOV Z, A
	MOVC
	B0MOV _tmpA, A

	B0MOV Y, #(dst_bank)$M
	B0MOV A, T
	ADD	  A, #(dst)$L
	SUB	  A, #1
	B0MOV Z, A
	B0MOV A, _tmpA
	B0MOV	  @YZ, A
	__SelectBANKCNST 0
	DECMS T
	JMP __LOOP
	
ENDIF

ENDM

PreB0SET MACRO address, offset, inISR
	IF ICE_Mode == 1
		IF ((SN8P1909==1) || (SN8P1908==1) ||(SN8P1819A==1)|| (SN8P1829==1) || (SN8P1907==1) || (SN8P1919==1) || (SN8P1917==1)|| (SN8P1929==1) || (SN8P1927==1) || (SN8P1927A==1) || (SN8P1937 == 1) || (SN8P1989==1))
			MOV A, #(address & 0xFF)
			B0MOV Z, A
			MOV A, #(address>>8 & 0xFF)
			B0MOV Y, A
			
			IF inISR == 1
				IF DECLARE_INDIR1_ICEMode_isr == 0
					extern code __INDIR1_ICEMode_isr
					DECLARE_INDIR1_ICEMode_isr = 1
				ENDIF
				CALL __INDIR1_ICEMode_isr
			ELSE
				IF DECLARE_INDIR1_ICEMode==0
					extern code __INDIR1_ICEMode
					DECLARE_INDIR1_ICEMode = 1
				ENDIF							
				CALL __INDIR1_ICEMode
			ENDIF
							
			OR A, #(0xFF & (1<<offset))
			
			IF inISR == 1
				IF DECLARE_STORE1_ICEMode_isr==0
					extern code __STORE1_ICEMode_isr
					DECLARE_STORE1_ICEMode_isr = 1
				ENDIF
				CALL __STORE1_ICEMode_isr
			ELSE
				IF DECLARE_STORE1_ICEMode==0
					extern code __STORE1_ICEMode
					DECLARE_STORE1_ICEMode = 1
				ENDIF
				CALL __STORE1_ICEMode
			ENDIF
			
		ELSE
			B0BSET address.offset
		ENDIF
	ELSE
		B0BSET address.offset
	ENDIF
ENDM


PreB0CLR MACRO address, offset, inISR
	IF ICE_Mode == 1
		IF ((SN8P1909==1) || (SN8P1908==1) ||(SN8P1819A==1) || (SN8P1829==1) || (SN8P1907==1) || (SN8P1919==1) || (SN8P1917==1)|| (SN8P1929==1) || (SN8P1927==1) || (SN8P1927A==1) || (SN8P1937 == 1) || (SN8P1989==1))
			MOV A, #(address & 0xFF)
			B0MOV Z, A
			MOV A, #(address>>8 & 0xFF)
			B0MOV Y, A
			
			IF inISR == 1
				IF DECLARE_INDIR1_ICEMode_isr == 0
					extern code __INDIR1_ICEMode_isr
					DECLARE_INDIR1_ICEMode_isr = 1
				ENDIF
				CALL __INDIR1_ICEMode_isr
			ELSE
				IF DECLARE_INDIR1_ICEMode==0
					extern code __INDIR1_ICEMode
					DECLARE_INDIR1_ICEMode = 1
				ENDIF			
				CALL __INDIR1_ICEMode
			ENDIF
							
			AND A, #(0xFF - (1<<offset))

			IF inISR == 1
				IF DECLARE_STORE1_ICEMode_isr==0
					extern code __STORE1_ICEMode_isr
					DECLARE_STORE1_ICEMode_isr = 1
				ENDIF
				CALL __STORE1_ICEMode_isr
			ELSE
				IF DECLARE_STORE1_ICEMode==0
					extern code __STORE1_ICEMode
					DECLARE_STORE1_ICEMode = 1
				ENDIF
				CALL __STORE1_ICEMode			
			ENDIF
			
		ELSE
			B0BCLR address.offset
		ENDIF
	ELSE
		B0BCLR address.offset
	ENDIF

ENDM


PreB0BTS0 MACRO address, offset, inISR
	IF ICE_Mode == 1
		IF ((SN8P1909==1) || (SN8P1908==1) ||(SN8P1819A==1) || (SN8P1829==1) || (SN8P1907==1) || (SN8P1919==1) || (SN8P1917==1)|| (SN8P1929==1) || (SN8P1927==1) || (SN8P1927A==1) || (SN8P1937 == 1) || (SN8P1989==1))
			MOV A, #(address & 0xFF)
			B0MOV Z, A
			MOV A, #(address>>8 & 0xFF)
			B0MOV Y, A
			
			IF inISR == 1
				IF DECLARE_INDIR1_ICEMode_isr == 0
					extern code __INDIR1_ICEMode_isr
					DECLARE_INDIR1_ICEMode_isr = 1
				ENDIF
				CALL __INDIR1_ICEMode_isr
			ELSE
				IF DECLARE_INDIR1_ICEMode==0
					extern code __INDIR1_ICEMode
					DECLARE_INDIR1_ICEMode = 1
				ENDIF			
				CALL __INDIR1_ICEMode
			ENDIF
							
			AND A, #( (1<<offset) & 0xFF)
			B0MOV Y, A
			MOV A, #1
			B0BTS0 Y.offset
			MOV A, #0
		ELSE
			MOV A, #1
			B0BTS0 address.offset
			MOV A, #0
		ENDIF
	ELSE
		MOV A, #1
		B0BTS0 address.offset
		MOV A, #0
	ENDIF
ENDM


PreB0BTS1 MACRO address, offset, inISR
	IF ICE_Mode == 1
		IF ((SN8P1909==1) || (SN8P1908==1) ||(SN8P1819A==1) || (SN8P1829==1) || (SN8P1907==1) || (SN8P1919==1) || (SN8P1917==1) || (SN8P1929==1) || (SN8P1927==1) || (SN8P1927A==1) || (SN8P1937 == 1) || (SN8P1989==1))
			MOV A, #(address & 0xFF)
			B0MOV Z, A
			MOV A, #(address>>8 & 0xFF)
			B0MOV Y, A	
			
			IF inISR == 1
				IF DECLARE_INDIR1_ICEMode_isr == 0
					extern code __INDIR1_ICEMode_isr
					DECLARE_INDIR1_ICEMode_isr = 1
				ENDIF
				CALL __INDIR1_ICEMode_isr
			ELSE
				IF DECLARE_INDIR1_ICEMode==0
					extern code __INDIR1_ICEMode
					DECLARE_INDIR1_ICEMode = 1
				ENDIF			
				CALL __INDIR1_ICEMode
			ENDIF
							
			AND A, #((1<<offset) & 0xFF)
			B0MOV Y, A
			MOV A, #1
			B0BTS1 Y.offset
			MOV A, #0
		ELSE
			MOV A, #1
			B0BTS1 address.offset
			MOV A, #0
		ENDIF
	ELSE
		MOV A, #1
		B0BTS1 address.offset
		MOV A, #0
	ENDIF
ENDM


__CALLHL MACRO ftpr_bank, fptr
	LOCAL _CALLHL_RET
	; Set @YZ point to stack depend on STKP
	B0MOV A, STKP
	IFDEF FSTKPB2  //the stack level
	AND A, #0x7
	ELSE
	AND A, #0x3
	ENDIF
;	SUB A, #1
	B0MOV Z, A

	IFDEF FSTKPB2
	ADD A, #0xEE
	ELSE
	ADD A, #0xF6
	ENDIF

	B0ADD Z, A
	B0MOV Y, #0
	;MOV A, #0
	;B0MOV Y, A
	
	;write target address to stack
	__SelectBANK ftpr_bank
	MOV A, (fptr)
	B0MOV @YZ, A
	__SelectBANKCNST 0
//	MOV A, #1
//	B0ADD Z, A
	INCMS	Z
	__SelectBANK ftpr_bank
	MOV A, (fptr)+1
	AND A, #0x7f
	B0MOV @YZ, A
	;write return address to stack
//	MOV A, #1
//	B0ADD Z, A
	__SelectBANKCNST 0
	INCMS	Z
	MOV A, #(_CALLHL_RET$L)
	B0MOV @YZ, A
;	MOV A, #1
;	B0ADD Z, A
	INCMS	Z
	MOV A, #(_CALLHL_RET$M)
	B0MOV @YZ, A
	; STKP -= 2
	MOV A, #0xfe
	B0ADD STKP, A
	; jump to target
	RET
_CALLHL_RET:	
ENDM

__Reset MACRO 
JMP 0x00 
ENDM


__DefineRomTable MACRO name, addr, size, value
name&@segment SEGMENT CODE at addr
name:
	count := size
	WHILE count >= 1
		DW value
		count := count-1
	ENDM
ENDM

// $Log: sn8cc_macros.asm,v $

// Revision 1.26.2.12  2010/06/23 10:58:00  jinbo
// Add SN8P1989 for XMOV macro.

// Revision 1.26.2.11  2009/12/24 10:21:00  jinbo
// Add SN8P1937 for XMOV macro.

// Revision 1.26.2.10  2009/11/25 11:17:00  jinbo
// Add SN8P1927, SN8P1929 for XMOV macro.

// Revision 1.26.2.9  2006/07/11 06:53:45  joe
// Add SN8P1917, SN8P1919 for XMOV macro.
//
// Revision 1.26.2.8  2006/07/11 02:44:49  joe
// Add SN8P1917, SN8P1919 for XMOV macro.
//
// Revision 1.26.2.7  2006/06/15 09:22:26  joe
// *** empty log message ***
//
// Revision 1.51  2006/06/08 05:53:23  joe
// Removed comment !
//
// Revision 1.50  2006/06/01 08:51:08  joe
// SN8 C Compiler initial ram size optimization.
//
// Revision 1.26.2.4  2006/04/20 04:00:09  joe
// Fixed __INDIR1_ROM, __INDIR2_ROM, __INDIR4_ROM import isr version library problem.
//
// Revision 1.49  2006/04/20 02:36:41  joe
// *** empty log message ***
//
// Revision 1.48  2006/04/19 11:40:30  joe
// Fixed missing "external"  __INDIR1_ROM problem.
//
// Revision 1.47  2006/04/19 11:06:53  joe
// Add IINDIR1_ROM, INDIR2_ROM isr version into C Stdlib
//
// Revision 1.46  2006/04/18 05:58:18  joe
// Add Compact Rom Support.
//
// Revision 1.45  2006/03/06 01:38:49  joe
// Add __BMOV_DD_ROM  to move data from rom to ram
//
// Revision 1.44  2006/02/21 08:40:35  joe
// 1. Add __INDIRRAM1 macro for indir pointer operation optimization.
// 2. Add  __INDIR2RAM macro for indir pointer operation optimization.
//
// Revision 1.43  2005/12/26 08:03:11  joe
// Fixed INDIR2 bug
//
// Revision 1.42  2005/12/16 02:45:31  joe
// Fixed INDIR2 bug.
//
// Revision 1.41  2005/12/14 07:32:58  joe
// 1. Add optimized XMOV macro as XMOVM2A, XMOVA2M macro.
// 2. Add XMOVM2A, XMOVA2M to stdlib build script.
//
// Revision 1.40  2005/12/08 16:03:31  joe
// Revise __INDIR2 spec as Destination at R, A with high-byte A, low-byte R.
//
// Revision 1.39  2005/12/06 13:15:17  joe
// *** empty log message ***
//
// Revision 1.38  2005/12/01 08:51:37  joe
// Update by removing dummy parameters.
//
// Revision 1.36  2005/11/03 07:01:14  joe
// *** empty log message ***
//
// Revision 1.35  2005/11/02 03:40:07  joe
// Refine macro
// __EXT MACRO	RegA
//