#ifndef __SN8P2743__H
#define __SN8P2743__H
struct specialRegister{
	unsigned bit0:1;
	unsigned bit1:1;
	unsigned bit2:1;
	unsigned bit3:1;
	unsigned bit4:1;
	unsigned bit5:1;
	unsigned bit6:1;
	unsigned bit7:1;
};


void _ClearWatchDogTimer(void);
void _ClrRAM(void);

#define NOP(X)  	__asm{	_NOP X }
#define LOG(X)  	__asm{	LOG CNameToAsmLabel(X) }
#define	L	(*((__RAM unsigned int*)0x80))
#define	H	(*((__RAM unsigned int*)0x81))
#define	R	(*((__RAM unsigned int*)0x82))
#define	Z	(*((__RAM unsigned int*)0x83))
#define	Y	(*((__RAM unsigned int*)0x84))
#define	PFLAG	(*((__RAM unsigned int*)0x86))
#define	FZ	((*((__RAM struct specialRegister *)0x86)).bit0)
#define	FDC	((*((__RAM struct specialRegister *)0x86)).bit1)
#define	FC	((*((__RAM struct specialRegister *)0x86)).bit2)
#define	FLVD24	((*((__RAM struct specialRegister *)0x86)).bit4)
#define	FLVD36	((*((__RAM struct specialRegister *)0x86)).bit5)
#define	FNPD	((*((__RAM struct specialRegister *)0x86)).bit6)
#define	FNT0	((*((__RAM struct specialRegister *)0x86)).bit7)
#define	CMDB0	(*((__RAM unsigned int*)0x9a))
#define	FCM1D3	((*((__RAM struct specialRegister *)0x9a)).bit7)
#define	FCM1D2	((*((__RAM struct specialRegister *)0x9a)).bit6)
#define	FCM1D1	((*((__RAM struct specialRegister *)0x9a)).bit5)
#define	FCM1D0	((*((__RAM struct specialRegister *)0x9a)).bit4)
#define	FCM0D3	((*((__RAM struct specialRegister *)0x9a)).bit3)
#define	FCM0D2	((*((__RAM struct specialRegister *)0x9a)).bit2)
#define	FCM0D1	((*((__RAM struct specialRegister *)0x9a)).bit1)
#define	FCM0D0	((*((__RAM struct specialRegister *)0x9a)).bit0)
#define	CMDB1	(*((__RAM unsigned int*)0x9b))
#define	FCM2D3	((*((__RAM struct specialRegister *)0x9b)).bit3)
#define	FCM2D2	((*((__RAM struct specialRegister *)0x9b)).bit2)
#define	FCM2D1	((*((__RAM struct specialRegister *)0x9b)).bit1)
#define	FCM2D0	((*((__RAM struct specialRegister *)0x9b)).bit0)
#define	CM0M	(*((__RAM unsigned int*)0x9c))
#define	FCM0EN	((*((__RAM struct specialRegister *)0x9c)).bit7)
#define	FCM0OEN	((*((__RAM struct specialRegister *)0x9c)).bit6)
#define	FCM0OUT	((*((__RAM struct specialRegister *)0x9c)).bit5)
#define	FCM0SF	((*((__RAM struct specialRegister *)0x9c)).bit4)
#define	FCM0G	((*((__RAM struct specialRegister *)0x9c)).bit3)
#define	CM1M	(*((__RAM unsigned int*)0x9d))
#define	FCM1EN	((*((__RAM struct specialRegister *)0x9d)).bit7)
#define	FCM1OEN	((*((__RAM struct specialRegister *)0x9d)).bit6)
#define	FCM1OUT	((*((__RAM struct specialRegister *)0x9d)).bit5)
#define	FCM1SF	((*((__RAM struct specialRegister *)0x9d)).bit4)
#define	FCM1G	((*((__RAM struct specialRegister *)0x9d)).bit3)
#define	FCM1RS2	((*((__RAM struct specialRegister *)0x9d)).bit2)
#define	FCM1RS1	((*((__RAM struct specialRegister *)0x9d)).bit1)
#define	FCM1RS0	((*((__RAM struct specialRegister *)0x9d)).bit0)
#define	CM2M	(*((__RAM unsigned int*)0x9e))
#define	FCM2EN	((*((__RAM struct specialRegister *)0x9e)).bit7)
#define	FCM2OEN	((*((__RAM struct specialRegister *)0x9e)).bit6)
#define	FCM2OUT	((*((__RAM struct specialRegister *)0x9e)).bit5)
#define	FCM2SF	((*((__RAM struct specialRegister *)0x9e)).bit4)
#define	FCM2G	((*((__RAM struct specialRegister *)0x9e)).bit3)
#define	FCM2RS2	((*((__RAM struct specialRegister *)0x9e)).bit2)
#define	FCM2RS1	((*((__RAM struct specialRegister *)0x9e)).bit1)
#define	FCM2RS0	((*((__RAM struct specialRegister *)0x9e)).bit0)
#define	OPM	(*((__RAM unsigned int*)0x9f))
#define	FOPEN	((*((__RAM struct specialRegister *)0x9f)).bit0)
#define	P4CON	(*((__RAM unsigned int*)0xae))
#define	ADM	(*((__RAM unsigned int*)0xB1))
#define	FADENB	((*((__RAM struct specialRegister *)0xB1)).bit7)
#define	FADS	((*((__RAM struct specialRegister *)0xB1)).bit6)
#define	FEOC	((*((__RAM struct specialRegister *)0xB1)).bit5)
#define	FGCHS	((*((__RAM struct specialRegister *)0xB1)).bit4)
#define	FAVREFH	((*((__RAM struct specialRegister *)0xB1)).bit3)
#define	FCHS2	((*((__RAM struct specialRegister *)0xB1)).bit2)
#define	FCHS1	((*((__RAM struct specialRegister *)0xB1)).bit1)
#define	FCHS0	((*((__RAM struct specialRegister *)0xB1)).bit0)
#define	ADB	(*((__RAM unsigned int*)0xb2))
#define	ADR	(*((__RAM unsigned int*)0xb3))
#define	FADCKS1	((*((__RAM struct specialRegister *)0xb3)).bit6)
#define	FADLEN	((*((__RAM struct specialRegister *)0xb3)).bit5)
#define	FADCKS0	((*((__RAM struct specialRegister *)0xb3)).bit4)
#define	FADB3	((*((__RAM struct specialRegister *)0xb3)).bit3)
#define	FADB2	((*((__RAM struct specialRegister *)0xb3)).bit2)
#define	FADB1	((*((__RAM struct specialRegister *)0xb3)).bit1)
#define	FADB0	((*((__RAM struct specialRegister *)0xb3)).bit0)
#define	ADT	(*((__RAM unsigned int*)0xb4))
#define	FADTS1	((*((__RAM struct specialRegister *)0xb4)).bit7)
#define	FADTS0	((*((__RAM struct specialRegister *)0xb4)).bit6)
#define	FADT4	((*((__RAM struct specialRegister *)0xb4)).bit4)
#define	FADT3	((*((__RAM struct specialRegister *)0xb4)).bit3)
#define	FADT2	((*((__RAM struct specialRegister *)0xb4)).bit2)
#define	FADT1	((*((__RAM struct specialRegister *)0xb4)).bit1)
#define	FADT0	((*((__RAM struct specialRegister *)0xb4)).bit0)
#define	P0M	(*((__RAM unsigned int*)0xb8))
#define	FP06M	((*((__RAM struct specialRegister *)0xb8)).bit6)
#define	FP05M	((*((__RAM struct specialRegister *)0xb8)).bit5)
#define	FP03M	((*((__RAM struct specialRegister *)0xb8)).bit3)
#define	FP02M	((*((__RAM struct specialRegister *)0xb8)).bit2)
#define	FP00M	((*((__RAM struct specialRegister *)0xb8)).bit0)
#define	PEDGE	(*((__RAM unsigned int*)0xbf))
#define	FP00G1	((*((__RAM struct specialRegister *)0xbf)).bit1)
#define	FP00G0	((*((__RAM struct specialRegister *)0xbf)).bit0)
#define	P1W	(*((__RAM unsigned int*)0xc0))
#define	P1M	(*((__RAM unsigned int*)0xc1))
#define	FP16M	((*((__RAM struct specialRegister *)0xc1)).bit6)
#define	FP15M	((*((__RAM struct specialRegister *)0xc1)).bit5)
#define	FP14M	((*((__RAM struct specialRegister *)0xc1)).bit4)
#define	FP13M	((*((__RAM struct specialRegister *)0xc1)).bit3)
#define	FP12M	((*((__RAM struct specialRegister *)0xc1)).bit2)
#define	FP11M	((*((__RAM struct specialRegister *)0xc1)).bit1)
#define	FP10M	((*((__RAM struct specialRegister *)0xc1)).bit0)
#define	P4M	(*((__RAM unsigned int*)0xc4))
#define	FP47M	((*((__RAM struct specialRegister *)0xc4)).bit7)
#define	FP46M	((*((__RAM struct specialRegister *)0xc4)).bit6)
#define	FP45M	((*((__RAM struct specialRegister *)0xc4)).bit5)
#define	FP44M	((*((__RAM struct specialRegister *)0xc4)).bit4)
#define	FP43M	((*((__RAM struct specialRegister *)0xc4)).bit3)
#define	FP42M	((*((__RAM struct specialRegister *)0xc4)).bit2)
#define	FP41M	((*((__RAM struct specialRegister *)0xc4)).bit1)
#define	FP40M	((*((__RAM struct specialRegister *)0xc4)).bit0)
#define	INTRQ	(*((__RAM unsigned int*)0xc8))
#define	FADCIRQ	((*((__RAM struct specialRegister *)0xc8)).bit7)
#define	FTC0IRQ	((*((__RAM struct specialRegister *)0xc8)).bit5)
#define	FT0IRQ	((*((__RAM struct specialRegister *)0xc8)).bit4)
#define	FCM2IRQ	((*((__RAM struct specialRegister *)0xc8)).bit3)
#define	FCM1IRQ	((*((__RAM struct specialRegister *)0xc8)).bit2)
#define	FCM0IRQ	((*((__RAM struct specialRegister *)0xc8)).bit1)
#define	FP00IRQ	((*((__RAM struct specialRegister *)0xc8)).bit0)
#define	INTEN	(*((__RAM unsigned int*)0xc9))
#define	FADCIEN	((*((__RAM struct specialRegister *)0xc9)).bit7)
#define	FTC0IEN	((*((__RAM struct specialRegister *)0xc9)).bit5)
#define	FT0IEN	((*((__RAM struct specialRegister *)0xc9)).bit4)
#define	FCM2IEN	((*((__RAM struct specialRegister *)0xc9)).bit3)
#define	FCM1IEN	((*((__RAM struct specialRegister *)0xc9)).bit2)
#define	FCM0IEN	((*((__RAM struct specialRegister *)0xc9)).bit1)
#define	FP00IEN	((*((__RAM struct specialRegister *)0xc9)).bit0)
#define	OSCM	(*((__RAM unsigned int*)0xca))
#define	FCPUM1	((*((__RAM struct specialRegister *)0xca)).bit4)
#define	FCPUM0	((*((__RAM struct specialRegister *)0xca)).bit3)
#define	FCLKMD	((*((__RAM struct specialRegister *)0xca)).bit2)
#define	FSTPHX	((*((__RAM struct specialRegister *)0xca)).bit1)
#define	WDTR	(*((__RAM unsigned int*)0xcc))
#define	TC0R	(*((__RAM unsigned int*)0xcd))
#define	PCL	(*((__RAM unsigned int*)0xce))
#define	PCH	(*((__RAM unsigned int*)0xcf))
#define	P0	(*((__RAM unsigned int*)0xd0))
#define	FP06	((*((__RAM struct specialRegister *)0xd0)).bit6)
#define	FP05	((*((__RAM struct specialRegister *)0xd0)).bit5)
#define	FP04	((*((__RAM struct specialRegister *)0xd0)).bit4)
#define	FP03	((*((__RAM struct specialRegister *)0xd0)).bit3)
#define	FP02	((*((__RAM struct specialRegister *)0xd0)).bit2)
#define	FP01	((*((__RAM struct specialRegister *)0xd0)).bit1)
#define	FP00	((*((__RAM struct specialRegister *)0xd0)).bit0)
#define	P1	(*((__RAM unsigned int*)0xd1))
#define	FP16	((*((__RAM struct specialRegister *)0xd1)).bit6)
#define	FP15	((*((__RAM struct specialRegister *)0xd1)).bit5)
#define	FP14	((*((__RAM struct specialRegister *)0xd1)).bit4)
#define	FP13	((*((__RAM struct specialRegister *)0xd1)).bit3)
#define	FP12	((*((__RAM struct specialRegister *)0xd1)).bit2)
#define	FP11	((*((__RAM struct specialRegister *)0xd1)).bit1)
#define	FP10	((*((__RAM struct specialRegister *)0xd1)).bit0)
#define	P4	(*((__RAM unsigned int*)0xd4))
#define	FP47	((*((__RAM struct specialRegister *)0xd4)).bit7)
#define	FP46	((*((__RAM struct specialRegister *)0xd4)).bit6)
#define	FP45	((*((__RAM struct specialRegister *)0xd4)).bit5)
#define	FP44	((*((__RAM struct specialRegister *)0xd4)).bit4)
#define	FP43	((*((__RAM struct specialRegister *)0xd4)).bit3)
#define	FP42	((*((__RAM struct specialRegister *)0xd4)).bit2)
#define	FP41	((*((__RAM struct specialRegister *)0xd4)).bit1)
#define	FP40	((*((__RAM struct specialRegister *)0xd4)).bit0)
#define	T0M	(*((__RAM unsigned int*)0xd8))
#define	FT0ENB	((*((__RAM struct specialRegister *)0xd8)).bit7)
#define	FT0RATE2	((*((__RAM struct specialRegister *)0xd8)).bit6)
#define	FT0RATE1	((*((__RAM struct specialRegister *)0xd8)).bit5)
#define	FT0RATE0	((*((__RAM struct specialRegister *)0xd8)).bit4)
#define	T0C	(*((__RAM unsigned int*)0xd9))
#define	TC0M	(*((__RAM unsigned int*)0xda))
#define	FTC0ENB	((*((__RAM struct specialRegister *)0xda)).bit7)
#define	FTC0RATE2	((*((__RAM struct specialRegister *)0xda)).bit6)
#define	FTC0RATE1	((*((__RAM struct specialRegister *)0xda)).bit5)
#define	FTC0RATE0	((*((__RAM struct specialRegister *)0xda)).bit4)
#define	FTC0CKS	((*((__RAM struct specialRegister *)0xda)).bit3)
#define	FTC0DIR	((*((__RAM struct specialRegister *)0xda)).bit2)
#define	FTC0PO	((*((__RAM struct specialRegister *)0xda)).bit1)
#define	FPWM0OUT	((*((__RAM struct specialRegister *)0xda)).bit0)
#define	TC0C	(*((__RAM unsigned int*)0xdb))
#define	BZM	(*((__RAM unsigned int*)0xdc))
#define	FBZEN	((*((__RAM struct specialRegister *)0xdc)).bit7)
#define	FBZRATE2	((*((__RAM struct specialRegister *)0xdc)).bit6)
#define	FBZRATE1	((*((__RAM struct specialRegister *)0xdc)).bit5)
#define	STKP	(*((__RAM unsigned int*)0xdf))
#define	FGIE	((*((__RAM struct specialRegister *)0xdf)).bit7)
#define	FSTKPB2	((*((__RAM struct specialRegister *)0xdf)).bit2)
#define	FSTKPB1	((*((__RAM struct specialRegister *)0xdf)).bit1)
#define	FSTKPB0	((*((__RAM struct specialRegister *)0xdf)).bit0)
#define	P0UR	(*((__RAM unsigned int*)0xe0))
#define	P1UR	(*((__RAM unsigned int*)0xe1))
#define	P4UR	(*((__RAM unsigned int*)0xe4))
#define	_HL	(*((__RAM unsigned int*)0xe6))
#define	_YZ	(*((__RAM unsigned int*)0xe7))
#define	TC0D	(*((__RAM unsigned int*)0xe8))
#define	STK7L	(*((__RAM unsigned int*)0xf0))
#define	STK7H	(*((__RAM unsigned int*)0xf1))
#define	STK6L	(*((__RAM unsigned int*)0xf2))
#define	STK6H	(*((__RAM unsigned int*)0xf3))
#define	STK5L	(*((__RAM unsigned int*)0xf4))
#define	STK5H	(*((__RAM unsigned int*)0xf5))
#define	STK4L	(*((__RAM unsigned int*)0xf6))
#define	STK4H	(*((__RAM unsigned int*)0xf7))
#define	STK3L	(*((__RAM unsigned int*)0xf8))
#define	STK3H	(*((__RAM unsigned int*)0xf9))
#define	STK2L	(*((__RAM unsigned int*)0xfa))
#define	STK2H	(*((__RAM unsigned int*)0xfb))
#define	STK1L	(*((__RAM unsigned int*)0xfc))
#define	STK1H	(*((__RAM unsigned int*)0xfd))
#define	STK0L	(*((__RAM unsigned int*)0xfe))
#define	STK0H	(*((__RAM unsigned int*)0xff))
#define SLEEPMODE __asm{SleepMode}
#define GREENMODE __asm{GreenMode}
#define SLOWMODE __asm{SlowMode}
#define SLOW2NORMAL __asm{Slow2Normal}
#endif
