#ifndef __SN8P2732__H
#define __SN8P2732__H
struct specialRegister{
	unsigned bit0:1;
	unsigned bit1:1;
	unsigned bit2:1;
	unsigned bit3:1;
	unsigned bit4:1;
	unsigned bit5:1;
	unsigned bit6:1;
	unsigned bit7:1;
};


void _ClearWatchDogTimer(void);
void _ClrRAM(void);

#define NOP(X)  	__asm{	_NOP X }
#define LOG(X)  	__asm{	LOG CNameToAsmLabel(X) }
#define	L	(*((__RAM unsigned int*)0x80))
#define	H	(*((__RAM unsigned int*)0x81))
#define	R	(*((__RAM unsigned int*)0x82))
#define	Z	(*((__RAM unsigned int*)0x83))
#define	Y	(*((__RAM unsigned int*)0x84))
#define	PFLAG	(*((__RAM unsigned int*)0x86))
#define	FZ	((*((__RAM struct specialRegister *)0x86)).bit0)
#define	FDC	((*((__RAM struct specialRegister *)0x86)).bit1)
#define	FC	((*((__RAM struct specialRegister *)0x86)).bit2)
#define	FLVD24	((*((__RAM struct specialRegister *)0x86)).bit4)
#define	FLVD36	((*((__RAM struct specialRegister *)0x86)).bit5)
#define	FNPD	((*((__RAM struct specialRegister *)0x86)).bit6)
#define	FNT0	((*((__RAM struct specialRegister *)0x86)).bit7)
#define	RBANK	(*((__RAM unsigned int*)0x87))
#define	FRBNKS0	((*((__RAM struct specialRegister *)0x87)).bit0)
#define	PW1NM	(*((__RAM unsigned int*)0x90))
#define	FPW1NEN	((*((__RAM struct specialRegister *)0x90)).bit7)
#define	FPW1D2	((*((__RAM struct specialRegister *)0x90)).bit6)
#define	FPW1D1	((*((__RAM struct specialRegister *)0x90)).bit5)
#define	FPW1D0	((*((__RAM struct specialRegister *)0x90)).bit4)
#define	FPW1DEN	((*((__RAM struct specialRegister *)0x90)).bit3)
#define	FPW1NV	((*((__RAM struct specialRegister *)0x90)).bit2)
#define	PW1M	(*((__RAM unsigned int*)0x93))
#define	FPW1EN	((*((__RAM struct specialRegister *)0x93)).bit7)
#define	FPW1RATE2	((*((__RAM struct specialRegister *)0x93)).bit6)
#define	FPW1RATE1	((*((__RAM struct specialRegister *)0x93)).bit5)
#define	FPW1RATE0	((*((__RAM struct specialRegister *)0x93)).bit4)
#define	FPW1CKS	((*((__RAM struct specialRegister *)0x93)).bit3)
#define	FPW1LN1	((*((__RAM struct specialRegister *)0x93)).bit2)
#define	FPW1LN0	((*((__RAM struct specialRegister *)0x93)).bit1)
#define	FPW1S	((*((__RAM struct specialRegister *)0x93)).bit0)
#define	PW2M	(*((__RAM unsigned int*)0x94))
#define	FPW2EN	((*((__RAM struct specialRegister *)0x94)).bit7)
#define	FPW2RATE2	((*((__RAM struct specialRegister *)0x94)).bit6)
#define	FPW2RATE1	((*((__RAM struct specialRegister *)0x94)).bit5)
#define	FPW2RATE0	((*((__RAM struct specialRegister *)0x94)).bit4)
#define	FPW2CKS	((*((__RAM struct specialRegister *)0x94)).bit3)
#define	FPW2LN1	((*((__RAM struct specialRegister *)0x94)).bit2)
#define	FPW2LN0	((*((__RAM struct specialRegister *)0x94)).bit1)
#define	PW2CHS	(*((__RAM unsigned int*)0x95))
#define	FPW2CH6	((*((__RAM struct specialRegister *)0x95)).bit5)
#define	FPW2CH5	((*((__RAM struct specialRegister *)0x95)).bit4)
#define	FPW2CH4	((*((__RAM struct specialRegister *)0x95)).bit3)
#define	FPW2CH3	((*((__RAM struct specialRegister *)0x95)).bit2)
#define	FPW2CH2	((*((__RAM struct specialRegister *)0x95)).bit1)
#define	FPW2CH1	((*((__RAM struct specialRegister *)0x95)).bit0)
#define	PW1RH	(*((__RAM unsigned int*)0x96))
#define	FPW1GS	((*((__RAM struct specialRegister *)0x96)).bit7)
#define	FPW1GEN	((*((__RAM struct specialRegister *)0x96)).bit6)
#define	FPW1GD	((*((__RAM struct specialRegister *)0x96)).bit5)
#define	FPW1R11	((*((__RAM struct specialRegister *)0x96)).bit3)
#define	FPW1R10	((*((__RAM struct specialRegister *)0x96)).bit2)
#define	FPW1R9	((*((__RAM struct specialRegister *)0x96)).bit1)
#define	FPW1R8	((*((__RAM struct specialRegister *)0x96)).bit0)
#define	PW1RL	(*((__RAM unsigned int*)0x97))
#define	PW2RH	(*((__RAM unsigned int*)0x98))
#define	FPW2R11	((*((__RAM struct specialRegister *)0x98)).bit3)
#define	FPW2R10	((*((__RAM struct specialRegister *)0x98)).bit2)
#define	FPW2R9	((*((__RAM struct specialRegister *)0x98)).bit1)
#define	FPW2R8	((*((__RAM struct specialRegister *)0x98)).bit0)
#define	PW2RL	(*((__RAM unsigned int*)0x99))
#define	CMP0M	(*((__RAM unsigned int*)0x9c))
#define	FCM0EN	((*((__RAM struct specialRegister *)0x9c)).bit7)
#define	FCM0IEN	((*((__RAM struct specialRegister *)0x9c)).bit6)
#define	FCM0IRQ	((*((__RAM struct specialRegister *)0x9c)).bit5)
#define	FCM0OEN	((*((__RAM struct specialRegister *)0x9c)).bit4)
#define	FCM0REF	((*((__RAM struct specialRegister *)0x9c)).bit3)
#define	FCM0OUT	((*((__RAM struct specialRegister *)0x9c)).bit2)
#define	FCM0G1	((*((__RAM struct specialRegister *)0x9c)).bit1)
#define	FCM0G0	((*((__RAM struct specialRegister *)0x9c)).bit0)
#define	CMP1M	(*((__RAM unsigned int*)0x9d))
#define	FCM1EN	((*((__RAM struct specialRegister *)0x9d)).bit7)
#define	FCM1IEN	((*((__RAM struct specialRegister *)0x9d)).bit6)
#define	FCM1IRQ	((*((__RAM struct specialRegister *)0x9d)).bit5)
#define	FCM1OEN	((*((__RAM struct specialRegister *)0x9d)).bit4)
#define	FCM1REF	((*((__RAM struct specialRegister *)0x9d)).bit3)
#define	FCM1OUT	((*((__RAM struct specialRegister *)0x9d)).bit2)
#define	FCM1G1	((*((__RAM struct specialRegister *)0x9d)).bit1)
#define	FCM1G0	((*((__RAM struct specialRegister *)0x9d)).bit0)
#define	CMP2M	(*((__RAM unsigned int*)0x9e))
#define	FCM2EN	((*((__RAM struct specialRegister *)0x9e)).bit7)
#define	FCM2IEN	((*((__RAM struct specialRegister *)0x9e)).bit6)
#define	FCM2IRQ	((*((__RAM struct specialRegister *)0x9e)).bit5)
#define	FCM2OEN	((*((__RAM struct specialRegister *)0x9e)).bit4)
#define	FCM2REF	((*((__RAM struct specialRegister *)0x9e)).bit3)
#define	FCM2OUT	((*((__RAM struct specialRegister *)0x9e)).bit2)
#define	FCM2G1	((*((__RAM struct specialRegister *)0x9e)).bit1)
#define	FCM2G0	((*((__RAM struct specialRegister *)0x9e)).bit0)
#define	OPM	(*((__RAM unsigned int*)0x9f))
#define	FOP2EN	((*((__RAM struct specialRegister *)0x9f)).bit2)
#define	FOP1EN	((*((__RAM struct specialRegister *)0x9f)).bit1)
#define	FOP0EN	((*((__RAM struct specialRegister *)0x9f)).bit0)
#define	T1M	(*((__RAM unsigned int*)0xa0))
#define	FT1ENB	((*((__RAM struct specialRegister *)0xa0)).bit7)
#define	FT1RATE2	((*((__RAM struct specialRegister *)0xa0)).bit6)
#define	FT1RATE1	((*((__RAM struct specialRegister *)0xa0)).bit5)
#define	FT1RATE0	((*((__RAM struct specialRegister *)0xa0)).bit4)
#define	FCPTCKS	((*((__RAM struct specialRegister *)0xa0)).bit3)
#define	FCPTStart	((*((__RAM struct specialRegister *)0xa0)).bit2)
#define	FCPTG1	((*((__RAM struct specialRegister *)0xa0)).bit1)
#define	FCPTG0	((*((__RAM struct specialRegister *)0xa0)).bit0)
#define	T1CL	(*((__RAM unsigned int*)0xa1))
#define	T1CH	(*((__RAM unsigned int*)0xa2))
#define	P4CON	(*((__RAM unsigned int*)0xae))
#define	ADM	(*((__RAM unsigned int*)0xB1))
#define	FADENB	((*((__RAM struct specialRegister *)0xB1)).bit7)
#define	FADS	((*((__RAM struct specialRegister *)0xB1)).bit6)
#define	FEOC	((*((__RAM struct specialRegister *)0xB1)).bit5)
#define	FGCHS	((*((__RAM struct specialRegister *)0xB1)).bit4)
#define	FAVREFH	((*((__RAM struct specialRegister *)0xB1)).bit3)
#define	FCHS2	((*((__RAM struct specialRegister *)0xB1)).bit2)
#define	FCHS1	((*((__RAM struct specialRegister *)0xB1)).bit1)
#define	FCHS0	((*((__RAM struct specialRegister *)0xB1)).bit0)
#define	ADB	(*((__RAM unsigned int*)0xb2))
#define	ADR	(*((__RAM unsigned int*)0xb3))
#define	FADCKS1	((*((__RAM struct specialRegister *)0xb3)).bit6)
#define	FADLEN	((*((__RAM struct specialRegister *)0xb3)).bit5)
#define	FADCKS0	((*((__RAM struct specialRegister *)0xb3)).bit4)
#define	FADB3	((*((__RAM struct specialRegister *)0xb3)).bit3)
#define	FADB2	((*((__RAM struct specialRegister *)0xb3)).bit2)
#define	FADB1	((*((__RAM struct specialRegister *)0xb3)).bit1)
#define	FADB0	((*((__RAM struct specialRegister *)0xb3)).bit0)
#define	ADT	(*((__RAM unsigned int*)0xb4))
#define	FADTS1	((*((__RAM struct specialRegister *)0xb4)).bit7)
#define	FADTS0	((*((__RAM struct specialRegister *)0xb4)).bit6)
#define	FADT4	((*((__RAM struct specialRegister *)0xb4)).bit4)
#define	FADT3	((*((__RAM struct specialRegister *)0xb4)).bit3)
#define	FADT2	((*((__RAM struct specialRegister *)0xb4)).bit2)
#define	FADT1	((*((__RAM struct specialRegister *)0xb4)).bit1)
#define	FADT0	((*((__RAM struct specialRegister *)0xb4)).bit0)
#define	P0M	(*((__RAM unsigned int*)0xb8))
#define	FP05M	((*((__RAM struct specialRegister *)0xb8)).bit5)
#define	FP04M	((*((__RAM struct specialRegister *)0xb8)).bit4)
#define	FP02M	((*((__RAM struct specialRegister *)0xb8)).bit2)
#define	FP01M	((*((__RAM struct specialRegister *)0xb8)).bit1)
#define	FP00M	((*((__RAM struct specialRegister *)0xb8)).bit0)
#define	PEDGE	(*((__RAM unsigned int*)0xbf))
#define	FP02G1	((*((__RAM struct specialRegister *)0xbf)).bit5)
#define	FP02G0	((*((__RAM struct specialRegister *)0xbf)).bit4)
#define	FP01G1	((*((__RAM struct specialRegister *)0xbf)).bit3)
#define	FP01G0	((*((__RAM struct specialRegister *)0xbf)).bit2)
#define	FP00G1	((*((__RAM struct specialRegister *)0xbf)).bit1)
#define	FP00G0	((*((__RAM struct specialRegister *)0xbf)).bit0)
#define	P1W	(*((__RAM unsigned int*)0xc0))
#define	P1M	(*((__RAM unsigned int*)0xc1))
#define	FP17M	((*((__RAM struct specialRegister *)0xc1)).bit7)
#define	FP16M	((*((__RAM struct specialRegister *)0xc1)).bit6)
#define	FP15M	((*((__RAM struct specialRegister *)0xc1)).bit5)
#define	FP14M	((*((__RAM struct specialRegister *)0xc1)).bit4)
#define	FP13M	((*((__RAM struct specialRegister *)0xc1)).bit3)
#define	FP12M	((*((__RAM struct specialRegister *)0xc1)).bit2)
#define	FP11M	((*((__RAM struct specialRegister *)0xc1)).bit1)
#define	FP10M	((*((__RAM struct specialRegister *)0xc1)).bit0)
#define	P4M	(*((__RAM unsigned int*)0xc4))
#define	FP47M	((*((__RAM struct specialRegister *)0xc4)).bit7)
#define	FP46M	((*((__RAM struct specialRegister *)0xc4)).bit6)
#define	FP45M	((*((__RAM struct specialRegister *)0xc4)).bit5)
#define	FP44M	((*((__RAM struct specialRegister *)0xc4)).bit4)
#define	FP43M	((*((__RAM struct specialRegister *)0xc4)).bit3)
#define	FP42M	((*((__RAM struct specialRegister *)0xc4)).bit2)
#define	FP41M	((*((__RAM struct specialRegister *)0xc4)).bit1)
#define	FP40M	((*((__RAM struct specialRegister *)0xc4)).bit0)
#define	P5M	(*((__RAM unsigned int*)0xc5))
#define	FP57M	((*((__RAM struct specialRegister *)0xc5)).bit7)
#define	FP56M	((*((__RAM struct specialRegister *)0xc5)).bit6)
#define	FP55M	((*((__RAM struct specialRegister *)0xc5)).bit5)
#define	FP54M	((*((__RAM struct specialRegister *)0xc5)).bit4)
#define	FP53M	((*((__RAM struct specialRegister *)0xc5)).bit3)
#define	FP52M	((*((__RAM struct specialRegister *)0xc5)).bit2)
#define	FP51M	((*((__RAM struct specialRegister *)0xc5)).bit1)
#define	FP50M	((*((__RAM struct specialRegister *)0xc5)).bit0)
#define	INTRQ	(*((__RAM unsigned int*)0xc8))
#define	FADCIRQ	((*((__RAM struct specialRegister *)0xc8)).bit7)
#define	FT1IRQ	((*((__RAM struct specialRegister *)0xc8)).bit6)
#define	FTC0IRQ	((*((__RAM struct specialRegister *)0xc8)).bit5)
#define	FT0IRQ	((*((__RAM struct specialRegister *)0xc8)).bit4)
#define	FP02IRQ	((*((__RAM struct specialRegister *)0xc8)).bit2)
#define	FP01IRQ	((*((__RAM struct specialRegister *)0xc8)).bit1)
#define	FP00IRQ	((*((__RAM struct specialRegister *)0xc8)).bit0)
#define	INTEN	(*((__RAM unsigned int*)0xc9))
#define	FADCIEN	((*((__RAM struct specialRegister *)0xc9)).bit7)
#define	FT1IEN	((*((__RAM struct specialRegister *)0xc9)).bit6)
#define	FTC0IEN	((*((__RAM struct specialRegister *)0xc9)).bit5)
#define	FT0IEN	((*((__RAM struct specialRegister *)0xc9)).bit4)
#define	FP02IEN	((*((__RAM struct specialRegister *)0xc9)).bit2)
#define	FP01IEN	((*((__RAM struct specialRegister *)0xc9)).bit1)
#define	FP00IEN	((*((__RAM struct specialRegister *)0xc9)).bit0)
#define	OSCM	(*((__RAM unsigned int*)0xca))
#define	FCPUM1	((*((__RAM struct specialRegister *)0xca)).bit4)
#define	FCPUM0	((*((__RAM struct specialRegister *)0xca)).bit3)
#define	FCLKMD	((*((__RAM struct specialRegister *)0xca)).bit2)
#define	FSTPHX	((*((__RAM struct specialRegister *)0xca)).bit1)
#define	WDTR	(*((__RAM unsigned int*)0xcc))
#define	TC0R	(*((__RAM unsigned int*)0xcd))
#define	PCL	(*((__RAM unsigned int*)0xce))
#define	PCH	(*((__RAM unsigned int*)0xcf))
#define	P0	(*((__RAM unsigned int*)0xd0))
#define	FP05	((*((__RAM struct specialRegister *)0xd0)).bit5)
#define	FP04	((*((__RAM struct specialRegister *)0xd0)).bit4)
#define	FP03	((*((__RAM struct specialRegister *)0xd0)).bit3)
#define	FP02	((*((__RAM struct specialRegister *)0xd0)).bit2)
#define	FP01	((*((__RAM struct specialRegister *)0xd0)).bit1)
#define	FP00	((*((__RAM struct specialRegister *)0xd0)).bit0)
#define	P1	(*((__RAM unsigned int*)0xd1))
#define	FP17	((*((__RAM struct specialRegister *)0xd1)).bit7)
#define	FP16	((*((__RAM struct specialRegister *)0xd1)).bit6)
#define	FP15	((*((__RAM struct specialRegister *)0xd1)).bit5)
#define	FP14	((*((__RAM struct specialRegister *)0xd1)).bit4)
#define	FP13	((*((__RAM struct specialRegister *)0xd1)).bit3)
#define	FP12	((*((__RAM struct specialRegister *)0xd1)).bit2)
#define	FP11	((*((__RAM struct specialRegister *)0xd1)).bit1)
#define	FP10	((*((__RAM struct specialRegister *)0xd1)).bit0)
#define	P4	(*((__RAM unsigned int*)0xd4))
#define	FP47	((*((__RAM struct specialRegister *)0xd4)).bit7)
#define	FP46	((*((__RAM struct specialRegister *)0xd4)).bit6)
#define	FP45	((*((__RAM struct specialRegister *)0xd4)).bit5)
#define	FP44	((*((__RAM struct specialRegister *)0xd4)).bit4)
#define	FP43	((*((__RAM struct specialRegister *)0xd4)).bit3)
#define	FP42	((*((__RAM struct specialRegister *)0xd4)).bit2)
#define	FP41	((*((__RAM struct specialRegister *)0xd4)).bit1)
#define	FP40	((*((__RAM struct specialRegister *)0xd4)).bit0)
#define	P5	(*((__RAM unsigned int*)0xd5))
#define	FP57	((*((__RAM struct specialRegister *)0xd5)).bit7)
#define	FP56	((*((__RAM struct specialRegister *)0xd5)).bit6)
#define	FP55	((*((__RAM struct specialRegister *)0xd5)).bit5)
#define	FP54	((*((__RAM struct specialRegister *)0xd5)).bit4)
#define	FP53	((*((__RAM struct specialRegister *)0xd5)).bit3)
#define	FP52	((*((__RAM struct specialRegister *)0xd5)).bit2)
#define	FP51	((*((__RAM struct specialRegister *)0xd5)).bit1)
#define	FP50	((*((__RAM struct specialRegister *)0xd5)).bit0)
#define	T0M	(*((__RAM unsigned int*)0xd8))
#define	FT0ENB	((*((__RAM struct specialRegister *)0xd8)).bit7)
#define	FT0RATE2	((*((__RAM struct specialRegister *)0xd8)).bit6)
#define	FT0RATE1	((*((__RAM struct specialRegister *)0xd8)).bit5)
#define	FT0RATE0	((*((__RAM struct specialRegister *)0xd8)).bit4)
#define	FT0TB	((*((__RAM struct specialRegister *)0xd8)).bit0)
#define	T0C	(*((__RAM unsigned int*)0xd9))
#define	TC0M	(*((__RAM unsigned int*)0xda))
#define	FTC0ENB	((*((__RAM struct specialRegister *)0xda)).bit7)
#define	FTC0RATE2	((*((__RAM struct specialRegister *)0xda)).bit6)
#define	FTC0RATE1	((*((__RAM struct specialRegister *)0xda)).bit5)
#define	FTC0RATE0	((*((__RAM struct specialRegister *)0xda)).bit4)
#define	FTC0CKS	((*((__RAM struct specialRegister *)0xda)).bit3)
#define	FALOAD0	((*((__RAM struct specialRegister *)0xda)).bit2)
#define	FTC0OUT	((*((__RAM struct specialRegister *)0xda)).bit1)
#define	FPWM0OUT	((*((__RAM struct specialRegister *)0xda)).bit0)
#define	TC0C	(*((__RAM unsigned int*)0xdb))
#define	STKP	(*((__RAM unsigned int*)0xdf))
#define	FGIE	((*((__RAM struct specialRegister *)0xdf)).bit7)
#define	FSTKPB2	((*((__RAM struct specialRegister *)0xdf)).bit2)
#define	FSTKPB1	((*((__RAM struct specialRegister *)0xdf)).bit1)
#define	FSTKPB0	((*((__RAM struct specialRegister *)0xdf)).bit0)
#define	P0UR	(*((__RAM unsigned int*)0xe0))
#define	P1UR	(*((__RAM unsigned int*)0xe1))
#define	P4UR	(*((__RAM unsigned int*)0xe4))
#define	P5UR	(*((__RAM unsigned int*)0xe5))
#define	_HL	(*((__RAM unsigned int*)0xe6))
#define	_YZ	(*((__RAM unsigned int*)0xe7))
#define	STK7L	(*((__RAM unsigned int*)0xf0))
#define	STK7H	(*((__RAM unsigned int*)0xf1))
#define	STK6L	(*((__RAM unsigned int*)0xf2))
#define	STK6H	(*((__RAM unsigned int*)0xf3))
#define	STK5L	(*((__RAM unsigned int*)0xf4))
#define	STK5H	(*((__RAM unsigned int*)0xf5))
#define	STK4L	(*((__RAM unsigned int*)0xf6))
#define	STK4H	(*((__RAM unsigned int*)0xf7))
#define	STK3L	(*((__RAM unsigned int*)0xf8))
#define	STK3H	(*((__RAM unsigned int*)0xf9))
#define	STK2L	(*((__RAM unsigned int*)0xfa))
#define	STK2H	(*((__RAM unsigned int*)0xfb))
#define	STK1L	(*((__RAM unsigned int*)0xfc))
#define	STK1H	(*((__RAM unsigned int*)0xfd))
#define	STK0L	(*((__RAM unsigned int*)0xfe))
#define	STK0H	(*((__RAM unsigned int*)0xff))
#define SLEEPMODE __asm{SleepMode}
#define GREENMODE __asm{GreenMode}
#define SLOWMODE __asm{SlowMode}
#define SLOW2NORMAL __asm{Slow2Normal}
#endif
