#ifndef __SN8P2722__H
#define __SN8P2722__H
struct specialRegister{
	unsigned bit0:1;
	unsigned bit1:1;
	unsigned bit2:1;
	unsigned bit3:1;
	unsigned bit4:1;
	unsigned bit5:1;
	unsigned bit6:1;
	unsigned bit7:1;
};


void _ClearWatchDogTimer(void);
void _ClrRAM(void);

#define NOP(X)  	__asm{	_NOP X }
#define LOG(X)  	__asm{	LOG CNameToAsmLabel(X) }
#define	R	(*((__RAM unsigned int*)0x82))
#define	Z	(*((__RAM unsigned int*)0x83))
#define	Y	(*((__RAM unsigned int*)0x84))
#define	PFLAG	(*((__RAM unsigned int*)0x86))
#define	FZ	((*((__RAM struct specialRegister *)0x86)).bit0)
#define	FDC	((*((__RAM struct specialRegister *)0x86)).bit1)
#define	FC	((*((__RAM struct specialRegister *)0x86)).bit2)
#define	FLVD24	((*((__RAM struct specialRegister *)0x86)).bit4)
#define	FLVD36	((*((__RAM struct specialRegister *)0x86)).bit5)
#define	FNPD	((*((__RAM struct specialRegister *)0x86)).bit6)
#define	FNT0	((*((__RAM struct specialRegister *)0x86)).bit7)
#define	P4CON	(*((__RAM unsigned int*)0xaf))
#define	ADM	(*((__RAM unsigned int*)0xB1))
#define	FADENB	((*((__RAM struct specialRegister *)0xB1)).bit7)
#define	FADS	((*((__RAM struct specialRegister *)0xB1)).bit6)
#define	FEOC	((*((__RAM struct specialRegister *)0xB1)).bit5)
#define	FGCHS	((*((__RAM struct specialRegister *)0xB1)).bit4)
#define	FCHS2	((*((__RAM struct specialRegister *)0xB1)).bit2)
#define	FCHS1	((*((__RAM struct specialRegister *)0xB1)).bit1)
#define	FCHS0	((*((__RAM struct specialRegister *)0xB1)).bit0)
#define	ADB	(*((__RAM unsigned int*)0xb2))
#define	ADR	(*((__RAM unsigned int*)0xb3))
#define	FADCKS1	((*((__RAM struct specialRegister *)0xb3)).bit6)
#define	FADCKS0	((*((__RAM struct specialRegister *)0xb3)).bit4)
#define	FADB3	((*((__RAM struct specialRegister *)0xb3)).bit3)
#define	FADB2	((*((__RAM struct specialRegister *)0xb3)).bit2)
#define	FADB1	((*((__RAM struct specialRegister *)0xb3)).bit1)
#define	FADB0	((*((__RAM struct specialRegister *)0xb3)).bit0)
#define	P0M	(*((__RAM unsigned int*)0xb8))
#define	FP00M	((*((__RAM struct specialRegister *)0xb8)).bit0)
#define	FP01M	((*((__RAM struct specialRegister *)0xb8)).bit1)
#define	FP02M	((*((__RAM struct specialRegister *)0xb8)).bit2)
#define	FP04M	((*((__RAM struct specialRegister *)0xb8)).bit4)
#define	FP05M	((*((__RAM struct specialRegister *)0xb8)).bit5)
#define	FP06M	((*((__RAM struct specialRegister *)0xb8)).bit6)
#define	FP07M	((*((__RAM struct specialRegister *)0xb8)).bit7)
#define	PEDGE	(*((__RAM unsigned int*)0xbf))
#define	FP00G1	((*((__RAM struct specialRegister *)0xbf)).bit4)
#define	FP00G0	((*((__RAM struct specialRegister *)0xbf)).bit3)
#define	P4M	(*((__RAM unsigned int*)0xc4))
#define	FP40M	((*((__RAM struct specialRegister *)0xc4)).bit0)
#define	FP41M	((*((__RAM struct specialRegister *)0xc4)).bit1)
#define	FP42M	((*((__RAM struct specialRegister *)0xc4)).bit2)
#define	FP43M	((*((__RAM struct specialRegister *)0xc4)).bit3)
#define	FP44M	((*((__RAM struct specialRegister *)0xc4)).bit4)
#define	P5M	(*((__RAM unsigned int*)0xc5))
#define	FP50M	((*((__RAM struct specialRegister *)0xc5)).bit0)
#define	FP51M	((*((__RAM struct specialRegister *)0xc5)).bit1)
#define	FP52M	((*((__RAM struct specialRegister *)0xc5)).bit2)
#define	FP53M	((*((__RAM struct specialRegister *)0xc5)).bit3)
#define	FP54M	((*((__RAM struct specialRegister *)0xc5)).bit4)
#define	INTRQ	(*((__RAM unsigned int*)0xc8))
#define	FP00IRQ	((*((__RAM struct specialRegister *)0xc8)).bit0)
#define	FT0IRQ	((*((__RAM struct specialRegister *)0xc8)).bit4)
#define	FTC0IRQ	((*((__RAM struct specialRegister *)0xc8)).bit5)
#define	FADCIRQ	((*((__RAM struct specialRegister *)0xc8)).bit7)
#define	INTEN	(*((__RAM unsigned int*)0xc9))
#define	FP00IEN	((*((__RAM struct specialRegister *)0xc9)).bit0)
#define	FT0IEN	((*((__RAM struct specialRegister *)0xc9)).bit4)
#define	FTC0IEN	((*((__RAM struct specialRegister *)0xc9)).bit5)
#define	FADCIEN	((*((__RAM struct specialRegister *)0xc9)).bit7)
#define	OSCM	(*((__RAM unsigned int*)0xca))
#define	FCPUM1	((*((__RAM struct specialRegister *)0xca)).bit4)
#define	FCPUM0	((*((__RAM struct specialRegister *)0xca)).bit3)
#define	FCLKMD	((*((__RAM struct specialRegister *)0xca)).bit2)
#define	FSTPHX	((*((__RAM struct specialRegister *)0xca)).bit1)
#define	WDTR	(*((__RAM unsigned int*)0xcc))
#define	PCL	(*((__RAM unsigned int*)0xce))
#define	PCH	(*((__RAM unsigned int*)0xcf))
#define	P0	(*((__RAM unsigned int*)0xd0))
#define	FP00	((*((__RAM struct specialRegister *)0xd0)).bit0)
#define	FP01	((*((__RAM struct specialRegister *)0xd0)).bit1)
#define	FP02	((*((__RAM struct specialRegister *)0xd0)).bit2)
#define	FP03	((*((__RAM struct specialRegister *)0xd0)).bit3)
#define	FP04	((*((__RAM struct specialRegister *)0xd0)).bit4)
#define	FP05	((*((__RAM struct specialRegister *)0xd0)).bit5)
#define	FP06	((*((__RAM struct specialRegister *)0xd0)).bit6)
#define	FP07	((*((__RAM struct specialRegister *)0xd0)).bit7)
#define	P4	(*((__RAM unsigned int*)0xd4))
#define	FP40	((*((__RAM struct specialRegister *)0xd4)).bit0)
#define	FP41	((*((__RAM struct specialRegister *)0xd4)).bit1)
#define	FP42	((*((__RAM struct specialRegister *)0xd4)).bit2)
#define	FP43	((*((__RAM struct specialRegister *)0xd4)).bit3)
#define	FP44	((*((__RAM struct specialRegister *)0xd4)).bit4)
#define	P5	(*((__RAM unsigned int*)0xd5))
#define	FP50	((*((__RAM struct specialRegister *)0xd5)).bit0)
#define	FP51	((*((__RAM struct specialRegister *)0xd5)).bit1)
#define	FP52	((*((__RAM struct specialRegister *)0xd5)).bit2)
#define	FP53	((*((__RAM struct specialRegister *)0xd5)).bit3)
#define	FP54	((*((__RAM struct specialRegister *)0xd5)).bit4)
#define	T0M	(*((__RAM unsigned int*)0xd8))
#define	FTC0CKS1	((*((__RAM struct specialRegister *)0xd8)).bit2)
#define	FTC0CKS2	((*((__RAM struct specialRegister *)0xd8)).bit3)
#define	FT0RATE0	((*((__RAM struct specialRegister *)0xd8)).bit4)
#define	FT0RATE1	((*((__RAM struct specialRegister *)0xd8)).bit5)
#define	FT0RATE2	((*((__RAM struct specialRegister *)0xd8)).bit6)
#define	FT0ENB	((*((__RAM struct specialRegister *)0xd8)).bit7)
#define	T0C	(*((__RAM unsigned int*)0xd9))
#define	TC0M	(*((__RAM unsigned int*)0xda))
#define	FTC0ENB	((*((__RAM struct specialRegister *)0xda)).bit7)
#define	FTC0RATE2	((*((__RAM struct specialRegister *)0xda)).bit6)
#define	FTC0RATE1	((*((__RAM struct specialRegister *)0xda)).bit5)
#define	FTC0RATE0	((*((__RAM struct specialRegister *)0xda)).bit4)
#define	FTC0CKS	((*((__RAM struct specialRegister *)0xda)).bit3)
#define	FALOAD0	((*((__RAM struct specialRegister *)0xda)).bit2)
#define	FTC0OUT	((*((__RAM struct specialRegister *)0xda)).bit1)
#define	FPWM0OUT	((*((__RAM struct specialRegister *)0xda)).bit0)
#define	TC0C	(*((__RAM unsigned int*)0xdb))
#define	TC0R	(*((__RAM unsigned int*)0xcd))
#define	BZM	(*((__RAM unsigned int*)0xdc))
#define	FBZEN	((*((__RAM struct specialRegister *)0xdc)).bit7)
#define	BZrate1	((*((__RAM struct specialRegister *)0xdc)).bit6)
#define	BZrate0	((*((__RAM struct specialRegister *)0xdc)).bit5)
#define	STKP	(*((__RAM unsigned int*)0xdf))
#define	FGIE	((*((__RAM struct specialRegister *)0xdf)).bit7)
#define	FSTKPB2	((*((__RAM struct specialRegister *)0xdf)).bit2)
#define	FSTKPB1	((*((__RAM struct specialRegister *)0xdf)).bit1)
#define	FSTKPB0	((*((__RAM struct specialRegister *)0xdf)).bit0)
#define	P0UR	(*((__RAM unsigned int*)0xe0))
#define	P4UR	(*((__RAM unsigned int*)0xe4))
#define	P5UR	(*((__RAM unsigned int*)0xe5))
#define	_YZ	(*((__RAM unsigned int*)0xe7))
#define	STK7L	(*((__RAM unsigned int*)0xf0))
#define	STK7H	(*((__RAM unsigned int*)0xf1))
#define	STK6L	(*((__RAM unsigned int*)0xf2))
#define	STK6H	(*((__RAM unsigned int*)0xf3))
#define	STK5L	(*((__RAM unsigned int*)0xf4))
#define	STK5H	(*((__RAM unsigned int*)0xf5))
#define	STK4L	(*((__RAM unsigned int*)0xf6))
#define	STK4H	(*((__RAM unsigned int*)0xf7))
#define	STK3L	(*((__RAM unsigned int*)0xf8))
#define	STK3H	(*((__RAM unsigned int*)0xf9))
#define	STK2L	(*((__RAM unsigned int*)0xfa))
#define	STK2H	(*((__RAM unsigned int*)0xfb))
#define	STK1L	(*((__RAM unsigned int*)0xfc))
#define	STK1H	(*((__RAM unsigned int*)0xfd))
#define	STK0L	(*((__RAM unsigned int*)0xfe))
#define	STK0H	(*((__RAM unsigned int*)0xff))
#define SLEEPMODE __asm{SleepMode}
#define GREENMODE __asm{GreenMode}
#define SLOWMODE __asm{SlowMode}
#define SLOW2NORMAL __asm{Slow2Normal}
#endif
