#ifndef __SN8P2712__H
#define __SN8P2712__H
struct specialRegister{
	unsigned bit0:1;
	unsigned bit1:1;
	unsigned bit2:1;
	unsigned bit3:1;
	unsigned bit4:1;
	unsigned bit5:1;
	unsigned bit6:1;
	unsigned bit7:1;
};


void _ClearWatchDogTimer(void);
void _ClrRAM(void);

#define NOP(X)  	__asm{	_NOP X }
#define LOG(X)  	__asm{	LOG CNameToAsmLabel(X) }
#define	L	(*((__RAM unsigned int*)0x80))
#define	H	(*((__RAM unsigned int*)0x81))
#define	R	(*((__RAM unsigned int*)0x82))
#define	Z	(*((__RAM unsigned int*)0x83))
#define	Y	(*((__RAM unsigned int*)0x84))
#define	PFLAG	(*((__RAM unsigned int*)0x86))
#define	FZ	((*((__RAM struct specialRegister *)0x86)).bit0)
#define	FDC	((*((__RAM struct specialRegister *)0x86)).bit1)
#define	FC	((*((__RAM struct specialRegister *)0x86)).bit2)
#define	FLVD24	((*((__RAM struct specialRegister *)0x86)).bit4)
#define	FLVD36	((*((__RAM struct specialRegister *)0x86)).bit5)
#define	FNPD	((*((__RAM struct specialRegister *)0x86)).bit6)
#define	FNT0	((*((__RAM struct specialRegister *)0x86)).bit7)
#define	TC2M	(*((__RAM unsigned int*)0xA0))
#define	FTC2ENB	((*((__RAM struct specialRegister *)0xA0)).bit7)
#define	FTC2RATE2	((*((__RAM struct specialRegister *)0xA0)).bit6)
#define	FTC2RATE1	((*((__RAM struct specialRegister *)0xA0)).bit5)
#define	FTC2RATE0	((*((__RAM struct specialRegister *)0xA0)).bit4)
#define	FTC2CKS	((*((__RAM struct specialRegister *)0xA0)).bit3)
#define	FALOAD2	((*((__RAM struct specialRegister *)0xA0)).bit2)
#define	FTC2OUT	((*((__RAM struct specialRegister *)0xA0)).bit1)
#define	FPWM2OUT	((*((__RAM struct specialRegister *)0xA0)).bit0)
#define	TC2C	(*((__RAM unsigned int*)0xA1))
#define	TC2R	(*((__RAM unsigned int*)0xA2))
#define	TC3M	(*((__RAM unsigned int*)0xA3))
#define	FTC3ENB	((*((__RAM struct specialRegister *)0xA3)).bit7)
#define	FTC3RATE2	((*((__RAM struct specialRegister *)0xA3)).bit6)
#define	FTC3RATE1	((*((__RAM struct specialRegister *)0xA3)).bit5)
#define	FTC3RATE0	((*((__RAM struct specialRegister *)0xA3)).bit4)
#define	FTC3CKS	((*((__RAM struct specialRegister *)0xA3)).bit3)
#define	FALOAD3	((*((__RAM struct specialRegister *)0xA3)).bit2)
#define	FTC3OUT	((*((__RAM struct specialRegister *)0xA3)).bit1)
#define	FPWM3OUT	((*((__RAM struct specialRegister *)0xA3)).bit0)
#define	TC3C	(*((__RAM unsigned int*)0xA4))
#define	TC3R	(*((__RAM unsigned int*)0xA5))
#define	P4CON	(*((__RAM unsigned int*)0xAE))
#define	P0CON	(*((__RAM unsigned int*)0xAF))
#define	VREFH	(*((__RAM unsigned int*)0xB0))
#define	FVHS0	((*((__RAM struct specialRegister *)0xB0)).bit0)
#define	FVHS1	((*((__RAM struct specialRegister *)0xB0)).bit1)
#define	FEVHENB	((*((__RAM struct specialRegister *)0xB0)).bit7)
#define	ADM	(*((__RAM unsigned int*)0xB1))
#define	FCHS0	((*((__RAM struct specialRegister *)0xB1)).bit0)
#define	FCHS1	((*((__RAM struct specialRegister *)0xB1)).bit1)
#define	FCHS2	((*((__RAM struct specialRegister *)0xB1)).bit2)
#define	FCHS3	((*((__RAM struct specialRegister *)0xB1)).bit3)
#define	FGCHS	((*((__RAM struct specialRegister *)0xB1)).bit4)
#define	FEOC	((*((__RAM struct specialRegister *)0xB1)).bit5)
#define	FADS	((*((__RAM struct specialRegister *)0xB1)).bit6)
#define	FADENB	((*((__RAM struct specialRegister *)0xB1)).bit7)
#define	ADB	(*((__RAM unsigned int*)0xB2))
#define	ADR	(*((__RAM unsigned int*)0xB3))
#define	FADB0	((*((__RAM struct specialRegister *)0xB3)).bit0)
#define	FADB1	((*((__RAM struct specialRegister *)0xB3)).bit1)
#define	FADB2	((*((__RAM struct specialRegister *)0xB3)).bit2)
#define	FADB3	((*((__RAM struct specialRegister *)0xB3)).bit3)
#define	FADCKS0	((*((__RAM struct specialRegister *)0xB3)).bit4)
#define	FADLEN	((*((__RAM struct specialRegister *)0xB3)).bit5)
#define	FADCKS1	((*((__RAM struct specialRegister *)0xB3)).bit6)
#define	ADT	(*((__RAM unsigned int*)0xB4))
#define	FADT0	((*((__RAM struct specialRegister *)0xB4)).bit0)
#define	FADT1	((*((__RAM struct specialRegister *)0xB4)).bit1)
#define	FADT2	((*((__RAM struct specialRegister *)0xB4)).bit2)
#define	FADT3	((*((__RAM struct specialRegister *)0xB4)).bit3)
#define	FADT4	((*((__RAM struct specialRegister *)0xB4)).bit4)
#define	FADTS0	((*((__RAM struct specialRegister *)0xB4)).bit6)
#define	FADTS1	((*((__RAM struct specialRegister *)0xB4)).bit7)
#define	P0M	(*((__RAM unsigned int*)0xB8))
#define	FP00M	((*((__RAM struct specialRegister *)0xB8)).bit0)
#define	FP02M	((*((__RAM struct specialRegister *)0xB8)).bit2)
#define	FP03M	((*((__RAM struct specialRegister *)0xB8)).bit3)
#define	FP04M	((*((__RAM struct specialRegister *)0xB8)).bit4)
#define	FP05M	((*((__RAM struct specialRegister *)0xB8)).bit5)
#define	FP06M	((*((__RAM struct specialRegister *)0xB8)).bit6)
#define	FP07M	((*((__RAM struct specialRegister *)0xB8)).bit7)
#define	PEDGE	(*((__RAM unsigned int*)0xBF))
#define	FP00G0	((*((__RAM struct specialRegister *)0xBF)).bit3)
#define	FP00G1	((*((__RAM struct specialRegister *)0xBF)).bit4)
#define	P4M	(*((__RAM unsigned int*)0xC4))
#define	FP47M	((*((__RAM struct specialRegister *)0xC4)).bit7)
#define	FP46M	((*((__RAM struct specialRegister *)0xC4)).bit6)
#define	FP45M	((*((__RAM struct specialRegister *)0xC4)).bit5)
#define	FP44M	((*((__RAM struct specialRegister *)0xC4)).bit4)
#define	FP43M	((*((__RAM struct specialRegister *)0xC4)).bit3)
#define	FP42M	((*((__RAM struct specialRegister *)0xC4)).bit2)
#define	FP41M	((*((__RAM struct specialRegister *)0xC4)).bit1)
#define	FP40M	((*((__RAM struct specialRegister *)0xC4)).bit0)
#define	INTRQ	(*((__RAM unsigned int*)0xC8))
#define	FADCIRQ	((*((__RAM struct specialRegister *)0xC8)).bit7)
#define	FTC0IRQ	((*((__RAM struct specialRegister *)0xC8)).bit5)
#define	FT0IRQ	((*((__RAM struct specialRegister *)0xC8)).bit4)
#define	FP00IRQ	((*((__RAM struct specialRegister *)0xC8)).bit0)
#define	INTEN	(*((__RAM unsigned int*)0xC9))
#define	FADCIEN	((*((__RAM struct specialRegister *)0xC9)).bit7)
#define	FTC0IEN	((*((__RAM struct specialRegister *)0xC9)).bit5)
#define	FT0IEN	((*((__RAM struct specialRegister *)0xC9)).bit4)
#define	FP00IEN	((*((__RAM struct specialRegister *)0xC9)).bit0)
#define	OSCM	(*((__RAM unsigned int*)0xCA))
#define	FCPUM1	((*((__RAM struct specialRegister *)0xCA)).bit4)
#define	FCPUM0	((*((__RAM struct specialRegister *)0xCA)).bit3)
#define	FCLKMD	((*((__RAM struct specialRegister *)0xCA)).bit2)
#define	FSTPHX	((*((__RAM struct specialRegister *)0xCA)).bit1)
#define	WDTR	(*((__RAM unsigned int*)0xCC))
#define	TC0R	(*((__RAM unsigned int*)0xCD))
#define	PCL	(*((__RAM unsigned int*)0xCE))
#define	PCH	(*((__RAM unsigned int*)0xCF))
#define	P0	(*((__RAM unsigned int*)0xD0))
#define	FP00	((*((__RAM struct specialRegister *)0xD0)).bit0)
#define	FP01	((*((__RAM struct specialRegister *)0xD0)).bit1)
#define	FP02	((*((__RAM struct specialRegister *)0xD0)).bit2)
#define	FP03	((*((__RAM struct specialRegister *)0xD0)).bit3)
#define	FP04	((*((__RAM struct specialRegister *)0xD0)).bit4)
#define	FP05	((*((__RAM struct specialRegister *)0xD0)).bit5)
#define	FP06	((*((__RAM struct specialRegister *)0xD0)).bit6)
#define	FP07	((*((__RAM struct specialRegister *)0xD0)).bit7)
#define	P4	(*((__RAM unsigned int*)0xD4))
#define	FP47	((*((__RAM struct specialRegister *)0xD4)).bit7)
#define	FP46	((*((__RAM struct specialRegister *)0xD4)).bit6)
#define	FP45	((*((__RAM struct specialRegister *)0xD4)).bit5)
#define	FP44	((*((__RAM struct specialRegister *)0xD4)).bit4)
#define	FP43	((*((__RAM struct specialRegister *)0xD4)).bit3)
#define	FP42	((*((__RAM struct specialRegister *)0xD4)).bit2)
#define	FP41	((*((__RAM struct specialRegister *)0xD4)).bit1)
#define	FP40	((*((__RAM struct specialRegister *)0xD4)).bit0)
#define	T0M	(*((__RAM unsigned int*)0xD8))
#define	FT0ENB	((*((__RAM struct specialRegister *)0xD8)).bit7)
#define	FT0RATE2	((*((__RAM struct specialRegister *)0xD8)).bit6)
#define	FT0RATE1	((*((__RAM struct specialRegister *)0xD8)).bit5)
#define	FT0RATE0	((*((__RAM struct specialRegister *)0xD8)).bit4)
#define	FTC0CKS1	((*((__RAM struct specialRegister *)0xD8)).bit1)
#define	FT0TB	((*((__RAM struct specialRegister *)0xD8)).bit0)
#define	T0C	(*((__RAM unsigned int*)0xD9))
#define	TC0M	(*((__RAM unsigned int*)0xDA))
#define	FTC0ENB	((*((__RAM struct specialRegister *)0xDA)).bit7)
#define	FTC0RATE2	((*((__RAM struct specialRegister *)0xDA)).bit6)
#define	FTC0RATE1	((*((__RAM struct specialRegister *)0xDA)).bit5)
#define	FTC0RATE0	((*((__RAM struct specialRegister *)0xDA)).bit4)
#define	FTC0CKS	((*((__RAM struct specialRegister *)0xDA)).bit3)
#define	FALOAD0	((*((__RAM struct specialRegister *)0xDA)).bit2)
#define	FTC0OUT	((*((__RAM struct specialRegister *)0xDA)).bit1)
#define	FPWM0OUT	((*((__RAM struct specialRegister *)0xDA)).bit0)
#define	TC0C	(*((__RAM unsigned int*)0xDB))
#define	TC1M	(*((__RAM unsigned int*)0xDC))
#define	FTC1ENB	((*((__RAM struct specialRegister *)0xDC)).bit7)
#define	FTC1RATE2	((*((__RAM struct specialRegister *)0xDC)).bit6)
#define	FTC1RATE1	((*((__RAM struct specialRegister *)0xDC)).bit5)
#define	FTC1RATE0	((*((__RAM struct specialRegister *)0xDC)).bit4)
#define	FTC1CKS	((*((__RAM struct specialRegister *)0xDC)).bit3)
#define	FALOAD1	((*((__RAM struct specialRegister *)0xDC)).bit2)
#define	FTC1OUT	((*((__RAM struct specialRegister *)0xDC)).bit1)
#define	FPWM1OUT	((*((__RAM struct specialRegister *)0xDC)).bit0)
#define	TC1C	(*((__RAM unsigned int*)0xDD))
#define	TC1R	(*((__RAM unsigned int*)0xDE))
#define	STKP	(*((__RAM unsigned int*)0xDF))
#define	FGIE	((*((__RAM struct specialRegister *)0xDF)).bit7)
#define	FSTKPB2	((*((__RAM struct specialRegister *)0xDF)).bit2)
#define	FSTKPB1	((*((__RAM struct specialRegister *)0xDF)).bit1)
#define	FSTKPB0	((*((__RAM struct specialRegister *)0xDF)).bit0)
#define	P0UR	(*((__RAM unsigned int*)0xE0))
#define	FP00R	((*((__RAM struct specialRegister *)0xE0)).bit0)
#define	FP02R	((*((__RAM struct specialRegister *)0xE0)).bit2)
#define	FP03R	((*((__RAM struct specialRegister *)0xE0)).bit3)
#define	FP04R	((*((__RAM struct specialRegister *)0xE0)).bit4)
#define	FP05R	((*((__RAM struct specialRegister *)0xE0)).bit5)
#define	FP06R	((*((__RAM struct specialRegister *)0xE0)).bit6)
#define	FP07R	((*((__RAM struct specialRegister *)0xE0)).bit7)
#define	P4UR	(*((__RAM unsigned int*)0xE4))
#define	FP47R	((*((__RAM struct specialRegister *)0xE4)).bit7)
#define	FP46R	((*((__RAM struct specialRegister *)0xE4)).bit6)
#define	FP45R	((*((__RAM struct specialRegister *)0xE4)).bit5)
#define	FP44R	((*((__RAM struct specialRegister *)0xE4)).bit4)
#define	FP43R	((*((__RAM struct specialRegister *)0xE4)).bit3)
#define	FP42R	((*((__RAM struct specialRegister *)0xE4)).bit2)
#define	FP41R	((*((__RAM struct specialRegister *)0xE4)).bit1)
#define	FP40R	((*((__RAM struct specialRegister *)0xE4)).bit0)
#define	_HL	(*((__RAM unsigned int*)0xE6))
#define	_YZ	(*((__RAM unsigned int*)0xE7))
#define	STK7L	(*((__RAM unsigned int*)0xF0))
#define	STK7H	(*((__RAM unsigned int*)0xF1))
#define	STK6L	(*((__RAM unsigned int*)0xF2))
#define	STK6H	(*((__RAM unsigned int*)0xF3))
#define	STK5L	(*((__RAM unsigned int*)0xF4))
#define	STK5H	(*((__RAM unsigned int*)0xF5))
#define	STK4L	(*((__RAM unsigned int*)0xF6))
#define	STK4H	(*((__RAM unsigned int*)0xF7))
#define	STK3L	(*((__RAM unsigned int*)0xF8))
#define	STK3H	(*((__RAM unsigned int*)0xF9))
#define	STK2L	(*((__RAM unsigned int*)0xFA))
#define	STK2H	(*((__RAM unsigned int*)0xFB))
#define	STK1L	(*((__RAM unsigned int*)0xFC))
#define	STK1H	(*((__RAM unsigned int*)0xFD))
#define	STK0L	(*((__RAM unsigned int*)0xFE))
#define	STK0H	(*((__RAM unsigned int*)0xFF))
#define SLEEPMODE __asm{SleepMode}
#define GREENMODE __asm{GreenMode}
#define SLOWMODE __asm{SlowMode}
#define SLOW2NORMAL __asm{Slow2Normal}
#endif
