#ifndef __SN8P2711A__H
#define __SN8P2711A__H
struct specialRegister{
	unsigned bit0:1;
	unsigned bit1:1;
	unsigned bit2:1;
	unsigned bit3:1;
	unsigned bit4:1;
	unsigned bit5:1;
	unsigned bit6:1;
	unsigned bit7:1;
};


void _ClearWatchDogTimer(void);
void _ClrRAM(void);

#define NOP(X)  	__asm{	_NOP X }
#define LOG(X)  	__asm{	LOG CNameToAsmLabel(X) }
#define	R	(*((__RAM unsigned int*)0x82))
#define	Z	(*((__RAM unsigned int*)0x83))
#define	Y	(*((__RAM unsigned int*)0x84))
#define	PFLAG	(*((__RAM unsigned int*)0x86))
#define	FZ	((*((__RAM struct specialRegister *)0x86)).bit0)
#define	FDC	((*((__RAM struct specialRegister *)0x86)).bit1)
#define	FC	((*((__RAM struct specialRegister *)0x86)).bit2)
#define	FLVD24	((*((__RAM struct specialRegister *)0x86)).bit4)
#define	FLVD36	((*((__RAM struct specialRegister *)0x86)).bit5)
#define	FNPD	((*((__RAM struct specialRegister *)0x86)).bit6)
#define	FNT0	((*((__RAM struct specialRegister *)0x86)).bit7)
#define	P4CON	(*((__RAM unsigned int*)0xae))
#define	VREFH	(*((__RAM unsigned int*)0xaf))
#define	FVHS0	((*((__RAM struct specialRegister *)0xaf)).bit0)
#define	FVHS1	((*((__RAM struct specialRegister *)0xaf)).bit1)
#define	FEVHENB	((*((__RAM struct specialRegister *)0xaf)).bit7)
#define	ADM	(*((__RAM unsigned int*)0xB1))
#define	FADENB	((*((__RAM struct specialRegister *)0xB1)).bit7)
#define	FADS	((*((__RAM struct specialRegister *)0xB1)).bit6)
#define	FEOC	((*((__RAM struct specialRegister *)0xB1)).bit5)
#define	FGCHS	((*((__RAM struct specialRegister *)0xB1)).bit4)
#define	FCHS2	((*((__RAM struct specialRegister *)0xB1)).bit2)
#define	FCHS1	((*((__RAM struct specialRegister *)0xB1)).bit1)
#define	FCHS0	((*((__RAM struct specialRegister *)0xB1)).bit0)
#define	ADB	(*((__RAM unsigned int*)0xb2))
#define	ADR	(*((__RAM unsigned int*)0xb3))
#define	FADCKS1	((*((__RAM struct specialRegister *)0xb3)).bit6)
#define	FADCKS0	((*((__RAM struct specialRegister *)0xb3)).bit4)
#define	FADB3	((*((__RAM struct specialRegister *)0xb3)).bit3)
#define	FADB2	((*((__RAM struct specialRegister *)0xb3)).bit2)
#define	FADB1	((*((__RAM struct specialRegister *)0xb3)).bit1)
#define	FADB0	((*((__RAM struct specialRegister *)0xb3)).bit0)
#define	P0M	(*((__RAM unsigned int*)0xb8))
#define	FP00M	((*((__RAM struct specialRegister *)0xb8)).bit0)
#define	FP01M	((*((__RAM struct specialRegister *)0xb8)).bit1)
#define	FP02M	((*((__RAM struct specialRegister *)0xb8)).bit2)
#define	FP03M	((*((__RAM struct specialRegister *)0xb8)).bit3)
#define	PEDGE	(*((__RAM unsigned int*)0xbf))
#define	FP00G1	((*((__RAM struct specialRegister *)0xbf)).bit4)
#define	FP00G0	((*((__RAM struct specialRegister *)0xbf)).bit3)
#define	P4M	(*((__RAM unsigned int*)0xc4))
#define	FP40M	((*((__RAM struct specialRegister *)0xc4)).bit0)
#define	FP41M	((*((__RAM struct specialRegister *)0xc4)).bit1)
#define	FP42M	((*((__RAM struct specialRegister *)0xc4)).bit2)
#define	FP43M	((*((__RAM struct specialRegister *)0xc4)).bit3)
#define	FP44M	((*((__RAM struct specialRegister *)0xc4)).bit4)
#define	P5M	(*((__RAM unsigned int*)0xc5))
#define	FP53M	((*((__RAM struct specialRegister *)0xc5)).bit3)
#define	FP54M	((*((__RAM struct specialRegister *)0xc5)).bit4)
#define	INTRQ	(*((__RAM unsigned int*)0xc8))
#define	FP00IRQ	((*((__RAM struct specialRegister *)0xc8)).bit0)
#define	FP01IRQ	((*((__RAM struct specialRegister *)0xc8)).bit1)
#define	FTC0IRQ	((*((__RAM struct specialRegister *)0xc8)).bit5)
#define	FTC1IRQ	((*((__RAM struct specialRegister *)0xc8)).bit6)
#define	FADCIRQ	((*((__RAM struct specialRegister *)0xc8)).bit7)
#define	INTEN	(*((__RAM unsigned int*)0xc9))
#define	FP00IEN	((*((__RAM struct specialRegister *)0xc9)).bit0)
#define	FP01IEN	((*((__RAM struct specialRegister *)0xc9)).bit1)
#define	FTC0IEN	((*((__RAM struct specialRegister *)0xc9)).bit5)
#define	FTC1IEN	((*((__RAM struct specialRegister *)0xc9)).bit6)
#define	FADCIEN	((*((__RAM struct specialRegister *)0xc9)).bit7)
#define	OSCM	(*((__RAM unsigned int*)0xca))
#define	FCPUM1	((*((__RAM struct specialRegister *)0xca)).bit4)
#define	FCPUM0	((*((__RAM struct specialRegister *)0xca)).bit3)
#define	FCLKMD	((*((__RAM struct specialRegister *)0xca)).bit2)
#define	FSTPHX	((*((__RAM struct specialRegister *)0xca)).bit1)
#define	WDTR	(*((__RAM unsigned int*)0xcc))
#define	PCL	(*((__RAM unsigned int*)0xce))
#define	PCH	(*((__RAM unsigned int*)0xcf))
#define	P0	(*((__RAM unsigned int*)0xd0))
#define	FP00	((*((__RAM struct specialRegister *)0xd0)).bit0)
#define	FP01	((*((__RAM struct specialRegister *)0xd0)).bit1)
#define	FP02	((*((__RAM struct specialRegister *)0xd0)).bit2)
#define	FP03	((*((__RAM struct specialRegister *)0xd0)).bit3)
#define	FP04	((*((__RAM struct specialRegister *)0xd0)).bit4)
#define	P4	(*((__RAM unsigned int*)0xd4))
#define	FP40	((*((__RAM struct specialRegister *)0xd4)).bit0)
#define	FP41	((*((__RAM struct specialRegister *)0xd4)).bit1)
#define	FP42	((*((__RAM struct specialRegister *)0xd4)).bit2)
#define	FP43	((*((__RAM struct specialRegister *)0xd4)).bit3)
#define	FP44	((*((__RAM struct specialRegister *)0xd4)).bit4)
#define	P5	(*((__RAM unsigned int*)0xd5))
#define	FP53	((*((__RAM struct specialRegister *)0xd5)).bit3)
#define	FP54	((*((__RAM struct specialRegister *)0xd5)).bit4)
#define	T0M	(*((__RAM unsigned int*)0xd8))
#define	FTC0GN	((*((__RAM struct specialRegister *)0xd8)).bit1)
#define	FTC0X8	((*((__RAM struct specialRegister *)0xd8)).bit2)
#define	FTC1X8	((*((__RAM struct specialRegister *)0xd8)).bit3)
#define	TC0M	(*((__RAM unsigned int*)0xda))
#define	FTC0ENB	((*((__RAM struct specialRegister *)0xda)).bit7)
#define	FTC0RATE2	((*((__RAM struct specialRegister *)0xda)).bit6)
#define	FTC0RATE1	((*((__RAM struct specialRegister *)0xda)).bit5)
#define	FTC0RATE0	((*((__RAM struct specialRegister *)0xda)).bit4)
#define	FTC0CKS	((*((__RAM struct specialRegister *)0xda)).bit3)
#define	FALOAD0	((*((__RAM struct specialRegister *)0xda)).bit2)
#define	FTC0OUT	((*((__RAM struct specialRegister *)0xda)).bit1)
#define	FPWM0OUT	((*((__RAM struct specialRegister *)0xda)).bit0)
#define	TC0C	(*((__RAM unsigned int*)0xdb))
#define	TC0R	(*((__RAM unsigned int*)0xcd))
#define	TC1M	(*((__RAM unsigned int*)0xdc))
#define	FTC1ENB	((*((__RAM struct specialRegister *)0xdc)).bit7)
#define	FTC1RATE2	((*((__RAM struct specialRegister *)0xdc)).bit6)
#define	FTC1RATE1	((*((__RAM struct specialRegister *)0xdc)).bit5)
#define	FTC1RATE0	((*((__RAM struct specialRegister *)0xdc)).bit4)
#define	FTC1CKS	((*((__RAM struct specialRegister *)0xdc)).bit3)
#define	FALOAD1	((*((__RAM struct specialRegister *)0xdc)).bit2)
#define	FTC1OUT	((*((__RAM struct specialRegister *)0xdc)).bit1)
#define	FPWM1OUT	((*((__RAM struct specialRegister *)0xdc)).bit0)
#define	TC1C	(*((__RAM unsigned int*)0xdd))
#define	TC1R	(*((__RAM unsigned int*)0xde))
#define	STKP	(*((__RAM unsigned int*)0xdf))
#define	FGIE	((*((__RAM struct specialRegister *)0xdf)).bit7)
#define	FSTKPB2	((*((__RAM struct specialRegister *)0xdf)).bit2)
#define	FSTKPB1	((*((__RAM struct specialRegister *)0xdf)).bit1)
#define	FSTKPB0	((*((__RAM struct specialRegister *)0xdf)).bit0)
#define	P0UR	(*((__RAM unsigned int*)0xe0))
#define	P4UR	(*((__RAM unsigned int*)0xe4))
#define	P5UR	(*((__RAM unsigned int*)0xe5))
#define	_YZ	(*((__RAM unsigned int*)0xe7))
#define	STK3L	(*((__RAM unsigned int*)0xf8))
#define	STK3H	(*((__RAM unsigned int*)0xf9))
#define	STK2L	(*((__RAM unsigned int*)0xfa))
#define	STK2H	(*((__RAM unsigned int*)0xfb))
#define	STK1L	(*((__RAM unsigned int*)0xfc))
#define	STK1H	(*((__RAM unsigned int*)0xfd))
#define	STK0L	(*((__RAM unsigned int*)0xfe))
#define	STK0H	(*((__RAM unsigned int*)0xff))
#define SLEEPMODE __asm{SleepMode}
#define GREENMODE __asm{GreenMode}
#define SLOWMODE __asm{SlowMode}
#define SLOW2NORMAL __asm{Slow2Normal}
#endif
