#ifndef __SN8P26L38__H
#define __SN8P26L38__H
struct specialRegister{
	unsigned bit0:1;
	unsigned bit1:1;
	unsigned bit2:1;
	unsigned bit3:1;
	unsigned bit4:1;
	unsigned bit5:1;
	unsigned bit6:1;
	unsigned bit7:1;
};


void _ClearWatchDogTimer(void);
void _ClrRAM(void);

#define NOP(X)  	__asm{	_NOP X }
#define LOG(X)  	__asm{	LOG CNameToAsmLabel(X) }
#define	L	(*((__RAM unsigned int*)0x80))
#define	H	(*((__RAM unsigned int*)0x81))
#define	R	(*((__RAM unsigned int*)0x82))
#define	Z	(*((__RAM unsigned int*)0x83))
#define	Y	(*((__RAM unsigned int*)0x84))
#define	PFLAG	(*((__RAM unsigned int*)0x86))
#define	FZ	((*((__RAM struct specialRegister *)0x86)).bit0)
#define	FDC	((*((__RAM struct specialRegister *)0x86)).bit1)
#define	FC	((*((__RAM struct specialRegister *)0x86)).bit2)
#define	FLVD24	((*((__RAM struct specialRegister *)0x86)).bit4)
#define	FLVD28	((*((__RAM struct specialRegister *)0x86)).bit5)
#define	FNPD	((*((__RAM struct specialRegister *)0x86)).bit6)
#define	FNT0	((*((__RAM struct specialRegister *)0x86)).bit7)
#define	RBANK	(*((__RAM unsigned int*)0x87))
#define	FBANKS0	((*((__RAM struct specialRegister *)0x87)).bit0)
#define	FBANKS1	((*((__RAM struct specialRegister *)0x87)).bit1)
#define	FBANKS2	((*((__RAM struct specialRegister *)0x87)).bit2)
#define	CMP0M	(*((__RAM unsigned int*)0x9c))
#define	FCMS0	((*((__RAM struct specialRegister *)0x9c)).bit0)
#define	FCMS1	((*((__RAM struct specialRegister *)0x9c)).bit1)
#define	FCM0OUT	((*((__RAM struct specialRegister *)0x9c)).bit2)
#define	FCM0REF	((*((__RAM struct specialRegister *)0x9c)).bit3)
#define	FCM0OEN	((*((__RAM struct specialRegister *)0x9c)).bit4)
#define	FCM0IRQ	((*((__RAM struct specialRegister *)0x9c)).bit5)
#define	FCM0IEN	((*((__RAM struct specialRegister *)0x9c)).bit6)
#define	FCM0EN	((*((__RAM struct specialRegister *)0x9c)).bit7)
#define	CMP1M	(*((__RAM unsigned int*)0x9d))
#define	FCM1OUT	((*((__RAM struct specialRegister *)0x9d)).bit2)
#define	FCM1REF	((*((__RAM struct specialRegister *)0x9d)).bit3)
#define	FCM1OEN	((*((__RAM struct specialRegister *)0x9d)).bit4)
#define	FCM1IRQ	((*((__RAM struct specialRegister *)0x9d)).bit5)
#define	FCM1IEN	((*((__RAM struct specialRegister *)0x9d)).bit6)
#define	FCM1EN	((*((__RAM struct specialRegister *)0x9d)).bit7)
#define	T1M	(*((__RAM unsigned int*)0xa0))
#define	FT1ENB	((*((__RAM struct specialRegister *)0xa0)).bit7)
#define	FT1rate2	((*((__RAM struct specialRegister *)0xa0)).bit6)
#define	FT1rate1	((*((__RAM struct specialRegister *)0xa0)).bit5)
#define	FT1rate0	((*((__RAM struct specialRegister *)0xa0)).bit4)
#define	T1CL	(*((__RAM unsigned int*)0xa1))
#define	T1CH	(*((__RAM unsigned int*)0xa2))
#define	URTX	(*((__RAM unsigned int*)0xa4))
#define	FUTXEN	((*((__RAM struct specialRegister *)0xa4)).bit4)
#define	FUTXPEN	((*((__RAM struct specialRegister *)0xa4)).bit3)
#define	FUTXPS	((*((__RAM struct specialRegister *)0xa4)).bit2)
#define	FUTXM	((*((__RAM struct specialRegister *)0xa4)).bit1)
#define	URRX	(*((__RAM unsigned int*)0xa5))
#define	FURXEN	((*((__RAM struct specialRegister *)0xa5)).bit7)
#define	FURXS1	((*((__RAM struct specialRegister *)0xa5)).bit6)
#define	FURXS0	((*((__RAM struct specialRegister *)0xa5)).bit5)
#define	FURXPEN	((*((__RAM struct specialRegister *)0xa5)).bit4)
#define	FURXPS	((*((__RAM struct specialRegister *)0xa5)).bit3)
#define	FURXPC	((*((__RAM struct specialRegister *)0xa5)).bit2)
#define	FURXM	((*((__RAM struct specialRegister *)0xa5)).bit1)
#define	URBRC	(*((__RAM unsigned int*)0xa6))
#define	FUDIV4	((*((__RAM struct specialRegister *)0xa6)).bit7)
#define	FUDIV3	((*((__RAM struct specialRegister *)0xa6)).bit6)
#define	FUDIV2	((*((__RAM struct specialRegister *)0xa6)).bit5)
#define	FUDIV1	((*((__RAM struct specialRegister *)0xa6)).bit4)
#define	FUDIV0	((*((__RAM struct specialRegister *)0xa6)).bit3)
#define	FUPCS2	((*((__RAM struct specialRegister *)0xa6)).bit2)
#define	FUPCS1	((*((__RAM struct specialRegister *)0xa6)).bit1)
#define	FUPCS0	((*((__RAM struct specialRegister *)0xa6)).bit0)
#define	URTXD1	(*((__RAM unsigned int*)0xa7))
#define	URTXD2	(*((__RAM unsigned int*)0xa8))
#define	URRXD1	(*((__RAM unsigned int*)0xa9))
#define	URRXD2	(*((__RAM unsigned int*)0xaa))
#define	SIOM	(*((__RAM unsigned int*)0xb4))
#define	FSENB	((*((__RAM struct specialRegister *)0xb4)).bit7)
#define	FSTART	((*((__RAM struct specialRegister *)0xb4)).bit6)
#define	FSRATE1	((*((__RAM struct specialRegister *)0xb4)).bit5)
#define	FSRATE0	((*((__RAM struct specialRegister *)0xb4)).bit4)
#define	FMLSB	((*((__RAM struct specialRegister *)0xb4)).bit3)
#define	FSCKMD	((*((__RAM struct specialRegister *)0xb4)).bit2)
#define	FCPOL	((*((__RAM struct specialRegister *)0xb4)).bit1)
#define	FCPHA	((*((__RAM struct specialRegister *)0xb4)).bit0)
#define	SIOR	(*((__RAM unsigned int*)0xb5))
#define	SIOB	(*((__RAM unsigned int*)0xb6))
#define	P0M	(*((__RAM unsigned int*)0xb8))
#define	FP00M	((*((__RAM struct specialRegister *)0xb8)).bit0)
#define	FP01M	((*((__RAM struct specialRegister *)0xb8)).bit1)
#define	FP03M	((*((__RAM struct specialRegister *)0xb8)).bit3)
#define	FP04M	((*((__RAM struct specialRegister *)0xb8)).bit4)
#define	FP05M	((*((__RAM struct specialRegister *)0xb8)).bit5)
#define	FP06M	((*((__RAM struct specialRegister *)0xb8)).bit6)
#define	FP07M	((*((__RAM struct specialRegister *)0xb8)).bit7)
#define	PEDGE	(*((__RAM unsigned int*)0xbf))
#define	FP00G1	((*((__RAM struct specialRegister *)0xbf)).bit4)
#define	FP00G0	((*((__RAM struct specialRegister *)0xbf)).bit3)
#define	P1W	(*((__RAM unsigned int*)0xc0))
#define	P1M	(*((__RAM unsigned int*)0xc1))
#define	FP10M	((*((__RAM struct specialRegister *)0xc1)).bit0)
#define	FP11M	((*((__RAM struct specialRegister *)0xc1)).bit1)
#define	FP12M	((*((__RAM struct specialRegister *)0xc1)).bit2)
#define	FP13M	((*((__RAM struct specialRegister *)0xc1)).bit3)
#define	FP14M	((*((__RAM struct specialRegister *)0xc1)).bit4)
#define	FP15M	((*((__RAM struct specialRegister *)0xc1)).bit5)
#define	FP16M	((*((__RAM struct specialRegister *)0xc1)).bit6)
#define	FP17M	((*((__RAM struct specialRegister *)0xc1)).bit7)
#define	P2M	(*((__RAM unsigned int*)0xc2))
#define	FP20M	((*((__RAM struct specialRegister *)0xc2)).bit0)
#define	FP21M	((*((__RAM struct specialRegister *)0xc2)).bit1)
#define	FP22M	((*((__RAM struct specialRegister *)0xc2)).bit2)
#define	FP23M	((*((__RAM struct specialRegister *)0xc2)).bit3)
#define	FP24M	((*((__RAM struct specialRegister *)0xc2)).bit4)
#define	FP25M	((*((__RAM struct specialRegister *)0xc2)).bit5)
#define	FP26M	((*((__RAM struct specialRegister *)0xc2)).bit6)
#define	FP27M	((*((__RAM struct specialRegister *)0xc2)).bit7)
#define	P3M	(*((__RAM unsigned int*)0xc3))
#define	FP30M	((*((__RAM struct specialRegister *)0xc3)).bit0)
#define	FP31M	((*((__RAM struct specialRegister *)0xc3)).bit1)
#define	FP32M	((*((__RAM struct specialRegister *)0xc3)).bit2)
#define	FP33M	((*((__RAM struct specialRegister *)0xc3)).bit3)
#define	P4M	(*((__RAM unsigned int*)0xc4))
#define	FP40M	((*((__RAM struct specialRegister *)0xc4)).bit0)
#define	FP41M	((*((__RAM struct specialRegister *)0xc4)).bit1)
#define	FP42M	((*((__RAM struct specialRegister *)0xc4)).bit2)
#define	FP43M	((*((__RAM struct specialRegister *)0xc4)).bit3)
#define	FP44M	((*((__RAM struct specialRegister *)0xc4)).bit4)
#define	FP45M	((*((__RAM struct specialRegister *)0xc4)).bit5)
#define	FP46M	((*((__RAM struct specialRegister *)0xc4)).bit6)
#define	FP47M	((*((__RAM struct specialRegister *)0xc4)).bit7)
#define	P5M	(*((__RAM unsigned int*)0xc5))
#define	FP50M	((*((__RAM struct specialRegister *)0xc5)).bit0)
#define	FP51M	((*((__RAM struct specialRegister *)0xc5)).bit1)
#define	FP52M	((*((__RAM struct specialRegister *)0xc5)).bit2)
#define	FP53M	((*((__RAM struct specialRegister *)0xc5)).bit3)
#define	FP54M	((*((__RAM struct specialRegister *)0xc5)).bit4)
#define	FP55M	((*((__RAM struct specialRegister *)0xc5)).bit5)
#define	FP56M	((*((__RAM struct specialRegister *)0xc5)).bit6)
#define	FP57M	((*((__RAM struct specialRegister *)0xc5)).bit7)
#define	INTRQ	(*((__RAM unsigned int*)0xc8))
#define	FP00IRQ	((*((__RAM struct specialRegister *)0xc8)).bit0)
#define	FP01IRQ	((*((__RAM struct specialRegister *)0xc8)).bit1)
#define	FTXIRQ	((*((__RAM struct specialRegister *)0xc8)).bit2)
#define	FRXIRQ	((*((__RAM struct specialRegister *)0xc8)).bit3)
#define	FT0IRQ	((*((__RAM struct specialRegister *)0xc8)).bit4)
#define	FT1IRQ	((*((__RAM struct specialRegister *)0xc8)).bit5)
#define	FTC1IRQ	((*((__RAM struct specialRegister *)0xc8)).bit6)
#define	FSIOIRQ	((*((__RAM struct specialRegister *)0xc8)).bit7)
#define	INTEN	(*((__RAM unsigned int*)0xc9))
#define	FP00IEN	((*((__RAM struct specialRegister *)0xc9)).bit0)
#define	FP01IEN	((*((__RAM struct specialRegister *)0xc9)).bit1)
#define	FTXIEN	((*((__RAM struct specialRegister *)0xc9)).bit2)
#define	FRXIEN	((*((__RAM struct specialRegister *)0xc9)).bit3)
#define	FT0IEN	((*((__RAM struct specialRegister *)0xc9)).bit4)
#define	FT1IEN	((*((__RAM struct specialRegister *)0xc9)).bit5)
#define	FTC1IEN	((*((__RAM struct specialRegister *)0xc9)).bit6)
#define	FSIOIEN	((*((__RAM struct specialRegister *)0xc9)).bit7)
#define	OSCM	(*((__RAM unsigned int*)0xca))
#define	FCPUM1	((*((__RAM struct specialRegister *)0xca)).bit4)
#define	FCPUM0	((*((__RAM struct specialRegister *)0xca)).bit3)
#define	FCLKMD	((*((__RAM struct specialRegister *)0xca)).bit2)
#define	FSTPHX	((*((__RAM struct specialRegister *)0xca)).bit1)
#define	WDTR	(*((__RAM unsigned int*)0xcc))
#define	IRR	(*((__RAM unsigned int*)0xcd))
#define	PCL	(*((__RAM unsigned int*)0xce))
#define	PCH	(*((__RAM unsigned int*)0xcf))
#define	P0	(*((__RAM unsigned int*)0xd0))
#define	FP00	((*((__RAM struct specialRegister *)0xd0)).bit0)
#define	FP01	((*((__RAM struct specialRegister *)0xd0)).bit1)
#define	FP02	((*((__RAM struct specialRegister *)0xd0)).bit2)
#define	FP03	((*((__RAM struct specialRegister *)0xd0)).bit3)
#define	FP04	((*((__RAM struct specialRegister *)0xd0)).bit4)
#define	FP05	((*((__RAM struct specialRegister *)0xd0)).bit5)
#define	FP06	((*((__RAM struct specialRegister *)0xd0)).bit6)
#define	FP07	((*((__RAM struct specialRegister *)0xd0)).bit7)
#define	P1	(*((__RAM unsigned int*)0xd1))
#define	FP10	((*((__RAM struct specialRegister *)0xd1)).bit0)
#define	FP11	((*((__RAM struct specialRegister *)0xd1)).bit1)
#define	FP12	((*((__RAM struct specialRegister *)0xd1)).bit2)
#define	FP13	((*((__RAM struct specialRegister *)0xd1)).bit3)
#define	FP14	((*((__RAM struct specialRegister *)0xd1)).bit4)
#define	FP15	((*((__RAM struct specialRegister *)0xd1)).bit5)
#define	FP16	((*((__RAM struct specialRegister *)0xd1)).bit6)
#define	FP17	((*((__RAM struct specialRegister *)0xd1)).bit7)
#define	P2	(*((__RAM unsigned int*)0xd2))
#define	FP20	((*((__RAM struct specialRegister *)0xd2)).bit0)
#define	FP21	((*((__RAM struct specialRegister *)0xd2)).bit1)
#define	FP22	((*((__RAM struct specialRegister *)0xd2)).bit2)
#define	FP23	((*((__RAM struct specialRegister *)0xd2)).bit3)
#define	FP24	((*((__RAM struct specialRegister *)0xd2)).bit4)
#define	FP25	((*((__RAM struct specialRegister *)0xd2)).bit5)
#define	FP26	((*((__RAM struct specialRegister *)0xd2)).bit6)
#define	FP27	((*((__RAM struct specialRegister *)0xd2)).bit7)
#define	P3	(*((__RAM unsigned int*)0xd3))
#define	FP30	((*((__RAM struct specialRegister *)0xd3)).bit0)
#define	FP31	((*((__RAM struct specialRegister *)0xd3)).bit1)
#define	FP32	((*((__RAM struct specialRegister *)0xd3)).bit2)
#define	FP33	((*((__RAM struct specialRegister *)0xd3)).bit3)
#define	P4	(*((__RAM unsigned int*)0xd4))
#define	FP40	((*((__RAM struct specialRegister *)0xd4)).bit0)
#define	FP41	((*((__RAM struct specialRegister *)0xd4)).bit1)
#define	FP42	((*((__RAM struct specialRegister *)0xd4)).bit2)
#define	FP43	((*((__RAM struct specialRegister *)0xd4)).bit3)
#define	FP44	((*((__RAM struct specialRegister *)0xd4)).bit4)
#define	FP45	((*((__RAM struct specialRegister *)0xd4)).bit5)
#define	FP46	((*((__RAM struct specialRegister *)0xd4)).bit6)
#define	FP47	((*((__RAM struct specialRegister *)0xd4)).bit7)
#define	P5	(*((__RAM unsigned int*)0xd5))
#define	FP50	((*((__RAM struct specialRegister *)0xd5)).bit0)
#define	FP51	((*((__RAM struct specialRegister *)0xd5)).bit1)
#define	FP52	((*((__RAM struct specialRegister *)0xd5)).bit2)
#define	FP53	((*((__RAM struct specialRegister *)0xd5)).bit3)
#define	FP54	((*((__RAM struct specialRegister *)0xd5)).bit4)
#define	FP55	((*((__RAM struct specialRegister *)0xd5)).bit5)
#define	FP56	((*((__RAM struct specialRegister *)0xd5)).bit6)
#define	FP57	((*((__RAM struct specialRegister *)0xd5)).bit7)
#define	T0M	(*((__RAM unsigned int*)0xd8))
#define	FT0TB	((*((__RAM struct specialRegister *)0xd8)).bit0)
#define	FT0RATE0	((*((__RAM struct specialRegister *)0xd8)).bit4)
#define	FT0RATE1	((*((__RAM struct specialRegister *)0xd8)).bit5)
#define	FT0RATE2	((*((__RAM struct specialRegister *)0xd8)).bit6)
#define	FT0ENB	((*((__RAM struct specialRegister *)0xd8)).bit7)
#define	T0C	(*((__RAM unsigned int*)0xd9))
#define	IRM	(*((__RAM unsigned int*)0xda))
#define	FCREN	((*((__RAM struct specialRegister *)0xda)).bit0)
#define	FIREN	((*((__RAM struct specialRegister *)0xda)).bit1)
#define	IRC	(*((__RAM unsigned int*)0xdb))
#define	TC1M	(*((__RAM unsigned int*)0xdc))
#define	FTC1ENB	((*((__RAM struct specialRegister *)0xdc)).bit7)
#define	FTC1RATE2	((*((__RAM struct specialRegister *)0xdc)).bit6)
#define	FTC1RATE1	((*((__RAM struct specialRegister *)0xdc)).bit5)
#define	FTC1RATE0	((*((__RAM struct specialRegister *)0xdc)).bit4)
#define	FTC1CKS	((*((__RAM struct specialRegister *)0xdc)).bit3)
#define	FALOAD1	((*((__RAM struct specialRegister *)0xdc)).bit2)
#define	FTC1OUT	((*((__RAM struct specialRegister *)0xdc)).bit1)
#define	FPWM1OUT	((*((__RAM struct specialRegister *)0xdc)).bit0)
#define	TC1C	(*((__RAM unsigned int*)0xdd))
#define	TC1R	(*((__RAM unsigned int*)0xde))
#define	STKP	(*((__RAM unsigned int*)0xdf))
#define	FGIE	((*((__RAM struct specialRegister *)0xdf)).bit7)
#define	FSTKPB2	((*((__RAM struct specialRegister *)0xdf)).bit2)
#define	FSTKPB1	((*((__RAM struct specialRegister *)0xdf)).bit1)
#define	FSTKPB0	((*((__RAM struct specialRegister *)0xdf)).bit0)
#define	P0UR	(*((__RAM unsigned int*)0xe0))
#define	P1UR	(*((__RAM unsigned int*)0xe1))
#define	P2UR	(*((__RAM unsigned int*)0xe2))
#define	P3UR	(*((__RAM unsigned int*)0xe3))
#define	P4UR	(*((__RAM unsigned int*)0xe4))
#define	P5UR	(*((__RAM unsigned int*)0xe5))
#define	_HL	(*((__RAM unsigned int*)0xe6))
#define	_YZ	(*((__RAM unsigned int*)0xe7))
#define	IRD	(*((__RAM unsigned int*)0xe8))
#define	P1OC	(*((__RAM unsigned int*)0xe9))
#define	STK7L	(*((__RAM unsigned int*)0xf0))
#define	STK7H	(*((__RAM unsigned int*)0xf1))
#define	STK6L	(*((__RAM unsigned int*)0xf2))
#define	STK6H	(*((__RAM unsigned int*)0xf3))
#define	STK5L	(*((__RAM unsigned int*)0xf4))
#define	STK5H	(*((__RAM unsigned int*)0xf5))
#define	STK4L	(*((__RAM unsigned int*)0xf6))
#define	STK4H	(*((__RAM unsigned int*)0xf7))
#define	STK3L	(*((__RAM unsigned int*)0xf8))
#define	STK3H	(*((__RAM unsigned int*)0xf9))
#define	STK2L	(*((__RAM unsigned int*)0xfa))
#define	STK2H	(*((__RAM unsigned int*)0xfb))
#define	STK1L	(*((__RAM unsigned int*)0xfc))
#define	STK1H	(*((__RAM unsigned int*)0xfd))
#define	STK0L	(*((__RAM unsigned int*)0xfe))
#define	STK0H	(*((__RAM unsigned int*)0xff))
#define SLEEPMODE __asm{SleepMode}
#define GREENMODE __asm{GreenMode}
#define SLOWMODE __asm{SlowMode}
#define SLOW2NORMAL __asm{Slow2Normal}
#endif
