#ifndef __SN8F2283__H
#define __SN8F2283__H
struct specialRegister{
	unsigned bit0:1;
	unsigned bit1:1;
	unsigned bit2:1;
	unsigned bit3:1;
	unsigned bit4:1;
	unsigned bit5:1;
	unsigned bit6:1;
	unsigned bit7:1;
};


void _ClearWatchDogTimer(void);
void _ClrRAM(void);

#define NOP(X)  	__asm{	_NOP X }
#define LOG(X)  	__asm{	LOG CNameToAsmLabel(X) }
#define	R	(*((__RAM unsigned int*)0x82))
#define	Z	(*((__RAM unsigned int*)0x83))
#define	Y	(*((__RAM unsigned int*)0x84))
#define	PFLAG	(*((__RAM unsigned int*)0x86))
#define	FZ	((*((__RAM struct specialRegister *)0x86)).bit0)
#define	FDC	((*((__RAM struct specialRegister *)0x86)).bit1)
#define	FC	((*((__RAM struct specialRegister *)0x86)).bit2)
#define	FNPD	((*((__RAM struct specialRegister *)0x86)).bit6)
#define	FNT0	((*((__RAM struct specialRegister *)0x86)).bit7)
#define	RBANK	(*((__RAM unsigned int*)0x87))
#define	FRBNKS0	((*((__RAM struct specialRegister *)0x87)).bit0)
#define	FRBNKS1	((*((__RAM struct specialRegister *)0x87)).bit1)
#define	TC0M	(*((__RAM unsigned int*)0x88))
#define	FTC0ENB	((*((__RAM struct specialRegister *)0x88)).bit7)
#define	FTC0RATE2	((*((__RAM struct specialRegister *)0x88)).bit6)
#define	FTC0RATE1	((*((__RAM struct specialRegister *)0x88)).bit5)
#define	FTC0RATE0	((*((__RAM struct specialRegister *)0x88)).bit4)
#define	FTC0CKS	((*((__RAM struct specialRegister *)0x88)).bit3)
#define	FALOAD0	((*((__RAM struct specialRegister *)0x88)).bit2)
#define	FTC0OUT	((*((__RAM struct specialRegister *)0x88)).bit1)
#define	FPWM0OUT	((*((__RAM struct specialRegister *)0x88)).bit0)
#define	TC0C	(*((__RAM unsigned int*)0x89))
#define	TC0R	(*((__RAM unsigned int*)0x8a))
#define	TC1M	(*((__RAM unsigned int*)0x8b))
#define	FTC1ENB	((*((__RAM struct specialRegister *)0x8b)).bit7)
#define	FTC1RATE2	((*((__RAM struct specialRegister *)0x8b)).bit6)
#define	FTC1RATE1	((*((__RAM struct specialRegister *)0x8b)).bit5)
#define	FTC1RATE0	((*((__RAM struct specialRegister *)0x8b)).bit4)
#define	FTC1CKS	((*((__RAM struct specialRegister *)0x8b)).bit3)
#define	FALOAD1	((*((__RAM struct specialRegister *)0x8b)).bit2)
#define	FTC1OUT	((*((__RAM struct specialRegister *)0x8b)).bit1)
#define	FPWM1OUT	((*((__RAM struct specialRegister *)0x8b)).bit0)
#define	TC1C	(*((__RAM unsigned int*)0x8c))
#define	TC1R	(*((__RAM unsigned int*)0x8d))
#define	TC2M	(*((__RAM unsigned int*)0x8e))
#define	FTC2ENB	((*((__RAM struct specialRegister *)0x8e)).bit7)
#define	FTC2RATE2	((*((__RAM struct specialRegister *)0x8e)).bit6)
#define	FTC2RATE1	((*((__RAM struct specialRegister *)0x8e)).bit5)
#define	FTC2RATE0	((*((__RAM struct specialRegister *)0x8e)).bit4)
#define	FTC2CKS	((*((__RAM struct specialRegister *)0x8e)).bit3)
#define	FALOAD2	((*((__RAM struct specialRegister *)0x8e)).bit2)
#define	FTC2OUT	((*((__RAM struct specialRegister *)0x8e)).bit1)
#define	FPWM2OUT	((*((__RAM struct specialRegister *)0x8e)).bit0)
#define	TC2C	(*((__RAM unsigned int*)0x8f))
#define	TC2R	(*((__RAM unsigned int*)0x90))
#define	UDA	(*((__RAM unsigned int*)0x91))
#define	FUDE	((*((__RAM struct specialRegister *)0x91)).bit7)
#define	FUDA6	((*((__RAM struct specialRegister *)0x91)).bit6)
#define	FUDA5	((*((__RAM struct specialRegister *)0x91)).bit5)
#define	FUDA4	((*((__RAM struct specialRegister *)0x91)).bit4)
#define	FUDA3	((*((__RAM struct specialRegister *)0x91)).bit3)
#define	FUDA2	((*((__RAM struct specialRegister *)0x91)).bit2)
#define	FUDA1	((*((__RAM struct specialRegister *)0x91)).bit1)
#define	FUDA0	((*((__RAM struct specialRegister *)0x91)).bit0)
#define	USTATUS	(*((__RAM unsigned int*)0x92))
#define	FCRCERR	((*((__RAM struct specialRegister *)0x92)).bit7)
#define	FPKTERR	((*((__RAM struct specialRegister *)0x92)).bit6)
#define	FSOF	((*((__RAM struct specialRegister *)0x92)).bit5)
#define	FBUS_RST	((*((__RAM struct specialRegister *)0x92)).bit4)
#define	FSUSPEND	((*((__RAM struct specialRegister *)0x92)).bit3)
#define	FEP0SETUP	((*((__RAM struct specialRegister *)0x92)).bit2)
#define	FEP0IN	((*((__RAM struct specialRegister *)0x92)).bit1)
#define	FEP0OUT	((*((__RAM struct specialRegister *)0x92)).bit0)
#define	EP0OUT_CNT	(*((__RAM unsigned int*)0x93))
#define	FUEP0OC4	((*((__RAM struct specialRegister *)0x93)).bit4)
#define	FUEP0OC3	((*((__RAM struct specialRegister *)0x93)).bit3)
#define	FUEP0OC2	((*((__RAM struct specialRegister *)0x93)).bit2)
#define	FUEP0OC1	((*((__RAM struct specialRegister *)0x93)).bit1)
#define	FUEP0OC0	((*((__RAM struct specialRegister *)0x93)).bit0)
#define	USB_INT_EN	(*((__RAM unsigned int*)0x94))
#define	FREG_EN	((*((__RAM struct specialRegister *)0x94)).bit7)
#define	FDP_PU_EN	((*((__RAM struct specialRegister *)0x94)).bit6)
#define	FSOF_INT_EN	((*((__RAM struct specialRegister *)0x94)).bit5)
#define	FEP4NAK_INT_EN	((*((__RAM struct specialRegister *)0x94)).bit3)
#define	FEP3NAK_INT_EN	((*((__RAM struct specialRegister *)0x94)).bit2)
#define	FEP2NAK_INT_EN	((*((__RAM struct specialRegister *)0x94)).bit1)
#define	FEP1NAK_INT_EN	((*((__RAM struct specialRegister *)0x94)).bit0)
#define	EP_ACK	(*((__RAM unsigned int*)0x95))
#define	FEP4_ACK	((*((__RAM struct specialRegister *)0x95)).bit3)
#define	FEP3_ACK	((*((__RAM struct specialRegister *)0x95)).bit2)
#define	FEP2_ACK	((*((__RAM struct specialRegister *)0x95)).bit1)
#define	FEP1_ACK	((*((__RAM struct specialRegister *)0x95)).bit0)
#define	EP_NAK	(*((__RAM unsigned int*)0x96))
#define	FEP4_NAK	((*((__RAM struct specialRegister *)0x96)).bit3)
#define	FEP3_NAK	((*((__RAM struct specialRegister *)0x96)).bit2)
#define	FEP2_NAK	((*((__RAM struct specialRegister *)0x96)).bit1)
#define	FEP1_NAK	((*((__RAM struct specialRegister *)0x96)).bit0)
#define	UE0R	(*((__RAM unsigned int*)0x97))
#define	FUE0M1	((*((__RAM struct specialRegister *)0x97)).bit6)
#define	FUE0M0	((*((__RAM struct specialRegister *)0x97)).bit5)
#define	FUE0C3	((*((__RAM struct specialRegister *)0x97)).bit3)
#define	FUE0C2	((*((__RAM struct specialRegister *)0x97)).bit2)
#define	FUE0C1	((*((__RAM struct specialRegister *)0x97)).bit1)
#define	FUE0C0	((*((__RAM struct specialRegister *)0x97)).bit0)
#define	UE1R	(*((__RAM unsigned int*)0x98))
#define	FUE1E	((*((__RAM struct specialRegister *)0x98)).bit7)
#define	FUE1M1	((*((__RAM struct specialRegister *)0x98)).bit6)
#define	FUE1M0	((*((__RAM struct specialRegister *)0x98)).bit5)
#define	UE1R_C	(*((__RAM unsigned int*)0x99))
#define	FUE1C6	((*((__RAM struct specialRegister *)0x99)).bit6)
#define	FUE1C5	((*((__RAM struct specialRegister *)0x99)).bit5)
#define	FUE1C4	((*((__RAM struct specialRegister *)0x99)).bit4)
#define	FUE1C3	((*((__RAM struct specialRegister *)0x99)).bit3)
#define	FUE1C2	((*((__RAM struct specialRegister *)0x99)).bit2)
#define	FUE1C1	((*((__RAM struct specialRegister *)0x99)).bit1)
#define	FUE1C0	((*((__RAM struct specialRegister *)0x99)).bit0)
#define	UE2R	(*((__RAM unsigned int*)0x9a))
#define	FUE2E	((*((__RAM struct specialRegister *)0x9a)).bit7)
#define	FUE2M1	((*((__RAM struct specialRegister *)0x9a)).bit6)
#define	FUE2M0	((*((__RAM struct specialRegister *)0x9a)).bit5)
#define	UE2R_C	(*((__RAM unsigned int*)0x9b))
#define	FUE2C6	((*((__RAM struct specialRegister *)0x9b)).bit6)
#define	FUE2C5	((*((__RAM struct specialRegister *)0x9b)).bit5)
#define	FUE2C4	((*((__RAM struct specialRegister *)0x9b)).bit4)
#define	FUE2C3	((*((__RAM struct specialRegister *)0x9b)).bit3)
#define	FUE2C2	((*((__RAM struct specialRegister *)0x9b)).bit2)
#define	FUE2C1	((*((__RAM struct specialRegister *)0x9b)).bit1)
#define	FUE2C0	((*((__RAM struct specialRegister *)0x9b)).bit0)
#define	UE3R	(*((__RAM unsigned int*)0x9c))
#define	FUE3E	((*((__RAM struct specialRegister *)0x9c)).bit7)
#define	FUE3M1	((*((__RAM struct specialRegister *)0x9c)).bit6)
#define	FUE3M0	((*((__RAM struct specialRegister *)0x9c)).bit5)
#define	UE3R_C	(*((__RAM unsigned int*)0x9d))
#define	FUE3C6	((*((__RAM struct specialRegister *)0x9d)).bit6)
#define	FUE3C5	((*((__RAM struct specialRegister *)0x9d)).bit5)
#define	FUE3C4	((*((__RAM struct specialRegister *)0x9d)).bit4)
#define	FUE3C3	((*((__RAM struct specialRegister *)0x9d)).bit3)
#define	FUE3C2	((*((__RAM struct specialRegister *)0x9d)).bit2)
#define	FUE3C1	((*((__RAM struct specialRegister *)0x9d)).bit1)
#define	FUE3C0	((*((__RAM struct specialRegister *)0x9d)).bit0)
#define	UE4R	(*((__RAM unsigned int*)0x9e))
#define	FUE4E	((*((__RAM struct specialRegister *)0x9e)).bit7)
#define	FUE4M1	((*((__RAM struct specialRegister *)0x9e)).bit6)
#define	FUE4M0	((*((__RAM struct specialRegister *)0x9e)).bit5)
#define	UE4R_C	(*((__RAM unsigned int*)0x9f))
#define	FUE4C6	((*((__RAM struct specialRegister *)0x9f)).bit6)
#define	FUE4C5	((*((__RAM struct specialRegister *)0x9f)).bit5)
#define	FUE4C4	((*((__RAM struct specialRegister *)0x9f)).bit4)
#define	FUE4C3	((*((__RAM struct specialRegister *)0x9f)).bit3)
#define	FUE4C2	((*((__RAM struct specialRegister *)0x9f)).bit2)
#define	FUE4C1	((*((__RAM struct specialRegister *)0x9f)).bit1)
#define	FUE4C0	((*((__RAM struct specialRegister *)0x9f)).bit0)
#define	EP2FIFO_ADDR	(*((__RAM unsigned int*)0xa0))
#define	FEP2FIFO7	((*((__RAM struct specialRegister *)0xa0)).bit7)
#define	FEP2FIFO6	((*((__RAM struct specialRegister *)0xa0)).bit6)
#define	FEP2FIFO5	((*((__RAM struct specialRegister *)0xa0)).bit5)
#define	FEP2FIFO4	((*((__RAM struct specialRegister *)0xa0)).bit4)
#define	FEP2FIFO3	((*((__RAM struct specialRegister *)0xa0)).bit3)
#define	FEP2FIFO2	((*((__RAM struct specialRegister *)0xa0)).bit2)
#define	FEP2FIFO1	((*((__RAM struct specialRegister *)0xa0)).bit1)
#define	FEP2FIFO0	((*((__RAM struct specialRegister *)0xa0)).bit0)
#define	EP3FIFO_ADDR	(*((__RAM unsigned int*)0xa1))
#define	FEP3FIFO7	((*((__RAM struct specialRegister *)0xa1)).bit7)
#define	FEP3FIFO6	((*((__RAM struct specialRegister *)0xa1)).bit6)
#define	FEP3FIFO5	((*((__RAM struct specialRegister *)0xa1)).bit5)
#define	FEP3FIFO4	((*((__RAM struct specialRegister *)0xa1)).bit4)
#define	FEP3FIFO3	((*((__RAM struct specialRegister *)0xa1)).bit3)
#define	FEP3FIFO2	((*((__RAM struct specialRegister *)0xa1)).bit2)
#define	FEP3FIFO1	((*((__RAM struct specialRegister *)0xa1)).bit1)
#define	FEP3FIFO0	((*((__RAM struct specialRegister *)0xa1)).bit0)
#define	EP4FIFO_ADDR	(*((__RAM unsigned int*)0xa2))
#define	FEP4FIFO7	((*((__RAM struct specialRegister *)0xa2)).bit7)
#define	FEP4FIFO6	((*((__RAM struct specialRegister *)0xa2)).bit6)
#define	FEP4FIFO5	((*((__RAM struct specialRegister *)0xa2)).bit5)
#define	FEP4FIFO4	((*((__RAM struct specialRegister *)0xa2)).bit4)
#define	FEP4FIFO3	((*((__RAM struct specialRegister *)0xa2)).bit3)
#define	FEP4FIFO2	((*((__RAM struct specialRegister *)0xa2)).bit2)
#define	FEP4FIFO1	((*((__RAM struct specialRegister *)0xa2)).bit1)
#define	FEP4FIFO0	((*((__RAM struct specialRegister *)0xa2)).bit0)
#define	UDP0	(*((__RAM unsigned int*)0xa3))
#define	FUDP07	((*((__RAM struct specialRegister *)0xa3)).bit7)
#define	FUDP06	((*((__RAM struct specialRegister *)0xa3)).bit6)
#define	FUDP05	((*((__RAM struct specialRegister *)0xa3)).bit5)
#define	FUDP04	((*((__RAM struct specialRegister *)0xa3)).bit4)
#define	FUDP03	((*((__RAM struct specialRegister *)0xa3)).bit3)
#define	FUDP02	((*((__RAM struct specialRegister *)0xa3)).bit2)
#define	FUDP01	((*((__RAM struct specialRegister *)0xa3)).bit1)
#define	FUDP00	((*((__RAM struct specialRegister *)0xa3)).bit0)
#define	UDR0_R	(*((__RAM unsigned int*)0xa5))
#define	FUDR0_R7	((*((__RAM struct specialRegister *)0xa5)).bit7)
#define	FUDR0_R6	((*((__RAM struct specialRegister *)0xa5)).bit6)
#define	FUDR0_R5	((*((__RAM struct specialRegister *)0xa5)).bit5)
#define	FUDR0_R4	((*((__RAM struct specialRegister *)0xa5)).bit4)
#define	FUDR0_R3	((*((__RAM struct specialRegister *)0xa5)).bit3)
#define	FUDR0_R2	((*((__RAM struct specialRegister *)0xa5)).bit2)
#define	FUDR0_R1	((*((__RAM struct specialRegister *)0xa5)).bit1)
#define	FUDR0_R0	((*((__RAM struct specialRegister *)0xa5)).bit0)
#define	UDR0_W	(*((__RAM unsigned int*)0xa6))
#define	FUDR0_W7	((*((__RAM struct specialRegister *)0xa6)).bit7)
#define	FUDR0_W6	((*((__RAM struct specialRegister *)0xa6)).bit6)
#define	FUDR0_W5	((*((__RAM struct specialRegister *)0xa6)).bit5)
#define	FUDR0_W4	((*((__RAM struct specialRegister *)0xa6)).bit4)
#define	FUDR0_W3	((*((__RAM struct specialRegister *)0xa6)).bit3)
#define	FUDR0_W2	((*((__RAM struct specialRegister *)0xa6)).bit2)
#define	FUDR0_W1	((*((__RAM struct specialRegister *)0xa6)).bit1)
#define	FUDR0_W0	((*((__RAM struct specialRegister *)0xa6)).bit0)
#define	UPID	(*((__RAM unsigned int*)0xa7))
#define	FUBDE	((*((__RAM struct specialRegister *)0xa7)).bit2)
#define	FDDP	((*((__RAM struct specialRegister *)0xa7)).bit1)
#define	FDDN	((*((__RAM struct specialRegister *)0xa7)).bit0)
#define	UTOGGLE	(*((__RAM unsigned int*)0xa8))
#define	FEP4_DATA01	((*((__RAM struct specialRegister *)0xa8)).bit3)
#define	FEP3_DATA01	((*((__RAM struct specialRegister *)0xa8)).bit2)
#define	FEP2_DATA01	((*((__RAM struct specialRegister *)0xa8)).bit1)
#define	FEP1_DATA01	((*((__RAM struct specialRegister *)0xa8)).bit0)
#define	URTX	(*((__RAM unsigned int*)0xa9))
#define	FUCLKS	((*((__RAM struct specialRegister *)0xa9)).bit7)
#define	FUTXEN	((*((__RAM struct specialRegister *)0xa9)).bit4)
#define	FUTXPEN	((*((__RAM struct specialRegister *)0xa9)).bit3)
#define	FUTXPS	((*((__RAM struct specialRegister *)0xa9)).bit2)
#define	FUTXM	((*((__RAM struct specialRegister *)0xa9)).bit1)
#define	URRX	(*((__RAM unsigned int*)0xaa))
#define	FURXEN	((*((__RAM struct specialRegister *)0xaa)).bit7)
#define	FURXS1	((*((__RAM struct specialRegister *)0xaa)).bit6)
#define	FURXS0	((*((__RAM struct specialRegister *)0xaa)).bit5)
#define	FURXPEN	((*((__RAM struct specialRegister *)0xaa)).bit4)
#define	FURXPS	((*((__RAM struct specialRegister *)0xaa)).bit3)
#define	FURXPC	((*((__RAM struct specialRegister *)0xaa)).bit2)
#define	FURXM	((*((__RAM struct specialRegister *)0xaa)).bit1)
#define	URBRC	(*((__RAM unsigned int*)0xab))
#define	FUDIV4	((*((__RAM struct specialRegister *)0xab)).bit7)
#define	FUDIV3	((*((__RAM struct specialRegister *)0xab)).bit6)
#define	FUDIV2	((*((__RAM struct specialRegister *)0xab)).bit5)
#define	FUDIV1	((*((__RAM struct specialRegister *)0xab)).bit4)
#define	FUDIV0	((*((__RAM struct specialRegister *)0xab)).bit3)
#define	FUPCS2	((*((__RAM struct specialRegister *)0xab)).bit2)
#define	FUPCS1	((*((__RAM struct specialRegister *)0xab)).bit1)
#define	FUPCS0	((*((__RAM struct specialRegister *)0xab)).bit0)
#define	URTXD1	(*((__RAM unsigned int*)0xac))
#define	FUTXD17	((*((__RAM struct specialRegister *)0xac)).bit7)
#define	FUTXD16	((*((__RAM struct specialRegister *)0xac)).bit6)
#define	FUTXD15	((*((__RAM struct specialRegister *)0xac)).bit5)
#define	FUTXD14	((*((__RAM struct specialRegister *)0xac)).bit4)
#define	FUTXD13	((*((__RAM struct specialRegister *)0xac)).bit3)
#define	FUTXD12	((*((__RAM struct specialRegister *)0xac)).bit2)
#define	FUTXD11	((*((__RAM struct specialRegister *)0xac)).bit1)
#define	FUTXD10	((*((__RAM struct specialRegister *)0xac)).bit0)
#define	URTXD2	(*((__RAM unsigned int*)0xad))
#define	FUTXD27	((*((__RAM struct specialRegister *)0xad)).bit7)
#define	FUTXD26	((*((__RAM struct specialRegister *)0xad)).bit6)
#define	FUTXD25	((*((__RAM struct specialRegister *)0xad)).bit5)
#define	FUTXD24	((*((__RAM struct specialRegister *)0xad)).bit4)
#define	FUTXD23	((*((__RAM struct specialRegister *)0xad)).bit3)
#define	FUTXD22	((*((__RAM struct specialRegister *)0xad)).bit2)
#define	FUTXD21	((*((__RAM struct specialRegister *)0xad)).bit1)
#define	FUTXD20	((*((__RAM struct specialRegister *)0xad)).bit0)
#define	URRXD1	(*((__RAM unsigned int*)0xae))
#define	URRXD2	(*((__RAM unsigned int*)0xaf))
#define	SIOM	(*((__RAM unsigned int*)0xb0))
#define	FSENB	((*((__RAM struct specialRegister *)0xb0)).bit7)
#define	FSTART	((*((__RAM struct specialRegister *)0xb0)).bit6)
#define	FSRATE1	((*((__RAM struct specialRegister *)0xb0)).bit5)
#define	FSRATE0	((*((__RAM struct specialRegister *)0xb0)).bit4)
#define	FMLSB	((*((__RAM struct specialRegister *)0xb0)).bit3)
#define	FSCKMD	((*((__RAM struct specialRegister *)0xb0)).bit2)
#define	FCPOL	((*((__RAM struct specialRegister *)0xb0)).bit1)
#define	FCPHA	((*((__RAM struct specialRegister *)0xb0)).bit0)
#define	SIOR	(*((__RAM unsigned int*)0xb1))
#define	SIOB	(*((__RAM unsigned int*)0xb2))
#define	FSIOB7	((*((__RAM struct specialRegister *)0xb2)).bit7)
#define	FSIOB6	((*((__RAM struct specialRegister *)0xb2)).bit6)
#define	FSIOB5	((*((__RAM struct specialRegister *)0xb2)).bit5)
#define	FSIOB4	((*((__RAM struct specialRegister *)0xb2)).bit4)
#define	FSIOB3	((*((__RAM struct specialRegister *)0xb2)).bit3)
#define	FSIOB2	((*((__RAM struct specialRegister *)0xb2)).bit2)
#define	FSIOB1	((*((__RAM struct specialRegister *)0xb2)).bit1)
#define	FSIOB0	((*((__RAM struct specialRegister *)0xb2)).bit0)
#define	P0M	(*((__RAM unsigned int*)0xb5))
#define	FP07M	((*((__RAM struct specialRegister *)0xb5)).bit7)
#define	FP06M	((*((__RAM struct specialRegister *)0xb5)).bit6)
#define	FP05M	((*((__RAM struct specialRegister *)0xb5)).bit5)
#define	FP04M	((*((__RAM struct specialRegister *)0xb5)).bit4)
#define	FP03M	((*((__RAM struct specialRegister *)0xb5)).bit3)
#define	FP02M	((*((__RAM struct specialRegister *)0xb5)).bit2)
#define	FP01M	((*((__RAM struct specialRegister *)0xb5)).bit1)
#define	FP00M	((*((__RAM struct specialRegister *)0xb5)).bit0)
#define	ADM	(*((__RAM unsigned int*)0xb6))
#define	FADENB	((*((__RAM struct specialRegister *)0xb6)).bit7)
#define	FADS	((*((__RAM struct specialRegister *)0xb6)).bit6)
#define	FEOC	((*((__RAM struct specialRegister *)0xb6)).bit5)
#define	FGCHS	((*((__RAM struct specialRegister *)0xb6)).bit4)
#define	FCHS3	((*((__RAM struct specialRegister *)0xb6)).bit3)
#define	FCHS2	((*((__RAM struct specialRegister *)0xb6)).bit2)
#define	FCHS1	((*((__RAM struct specialRegister *)0xb6)).bit1)
#define	FCHS0	((*((__RAM struct specialRegister *)0xb6)).bit0)
#define	ADB	(*((__RAM unsigned int*)0xb7))
#define	FADB11	((*((__RAM struct specialRegister *)0xb7)).bit7)
#define	FADB10	((*((__RAM struct specialRegister *)0xb7)).bit6)
#define	FADB9	((*((__RAM struct specialRegister *)0xb7)).bit5)
#define	FADB8	((*((__RAM struct specialRegister *)0xb7)).bit4)
#define	FADB7	((*((__RAM struct specialRegister *)0xb7)).bit3)
#define	FADB6	((*((__RAM struct specialRegister *)0xb7)).bit2)
#define	FADB5	((*((__RAM struct specialRegister *)0xb7)).bit1)
#define	FADB4	((*((__RAM struct specialRegister *)0xb7)).bit0)
#define	ADR	(*((__RAM unsigned int*)0xb8))
#define	FADCKS2	((*((__RAM struct specialRegister *)0xb8)).bit7)
#define	FADCKS1	((*((__RAM struct specialRegister *)0xb8)).bit6)
#define	FADCKS0	((*((__RAM struct specialRegister *)0xb8)).bit5)
#define	FADLEN	((*((__RAM struct specialRegister *)0xb8)).bit4)
#define	FADB3	((*((__RAM struct specialRegister *)0xb8)).bit3)
#define	FADB2	((*((__RAM struct specialRegister *)0xb8)).bit2)
#define	FADB1	((*((__RAM struct specialRegister *)0xb8)).bit1)
#define	FADB0	((*((__RAM struct specialRegister *)0xb8)).bit0)
#define	P4CON	(*((__RAM unsigned int*)0xb9))
#define	FP4CON7	((*((__RAM struct specialRegister *)0xb9)).bit7)
#define	FP4CON6	((*((__RAM struct specialRegister *)0xb9)).bit6)
#define	FP4CON5	((*((__RAM struct specialRegister *)0xb9)).bit5)
#define	FP4CON4	((*((__RAM struct specialRegister *)0xb9)).bit4)
#define	FP4CON3	((*((__RAM struct specialRegister *)0xb9)).bit3)
#define	FP4CON2	((*((__RAM struct specialRegister *)0xb9)).bit2)
#define	FP4CON1	((*((__RAM struct specialRegister *)0xb9)).bit1)
#define	FP4CON0	((*((__RAM struct specialRegister *)0xb9)).bit0)
#define	PECMD	(*((__RAM unsigned int*)0xba))
#define	PEROML	(*((__RAM unsigned int*)0xbb))
#define	FPEROML7	((*((__RAM struct specialRegister *)0xbb)).bit7)
#define	FPEROML6	((*((__RAM struct specialRegister *)0xbb)).bit6)
#define	FPEROML5	((*((__RAM struct specialRegister *)0xbb)).bit5)
#define	FPEROML4	((*((__RAM struct specialRegister *)0xbb)).bit4)
#define	FPEROML3	((*((__RAM struct specialRegister *)0xbb)).bit3)
#define	FPEROML2	((*((__RAM struct specialRegister *)0xbb)).bit2)
#define	FPEROML1	((*((__RAM struct specialRegister *)0xbb)).bit1)
#define	FPEROML0	((*((__RAM struct specialRegister *)0xbb)).bit0)
#define	PEROMH	(*((__RAM unsigned int*)0xbc))
#define	FPEROMH7	((*((__RAM struct specialRegister *)0xbc)).bit7)
#define	FPEROMH6	((*((__RAM struct specialRegister *)0xbc)).bit6)
#define	FPEROMH5	((*((__RAM struct specialRegister *)0xbc)).bit5)
#define	FPEROMH4	((*((__RAM struct specialRegister *)0xbc)).bit4)
#define	FPEROMH3	((*((__RAM struct specialRegister *)0xbc)).bit3)
#define	FPEROMH2	((*((__RAM struct specialRegister *)0xbc)).bit2)
#define	FPEROMH1	((*((__RAM struct specialRegister *)0xbc)).bit1)
#define	FPEROMH0	((*((__RAM struct specialRegister *)0xbc)).bit0)
#define	PERAML	(*((__RAM unsigned int*)0xbd))
#define	FPERAML7	((*((__RAM struct specialRegister *)0xbd)).bit7)
#define	FPERAML6	((*((__RAM struct specialRegister *)0xbd)).bit6)
#define	FPERAML5	((*((__RAM struct specialRegister *)0xbd)).bit5)
#define	FPERAML4	((*((__RAM struct specialRegister *)0xbd)).bit4)
#define	FPERAML3	((*((__RAM struct specialRegister *)0xbd)).bit3)
#define	FPERAML2	((*((__RAM struct specialRegister *)0xbd)).bit2)
#define	FPERAML1	((*((__RAM struct specialRegister *)0xbd)).bit1)
#define	FPERAML0	((*((__RAM struct specialRegister *)0xbd)).bit0)
#define	PERAMCNT	(*((__RAM unsigned int*)0xbe))
#define	FPERAMCNT4	((*((__RAM struct specialRegister *)0xbe)).bit7)
#define	FPERAMCNT3	((*((__RAM struct specialRegister *)0xbe)).bit6)
#define	FPERAMCNT2	((*((__RAM struct specialRegister *)0xbe)).bit5)
#define	FPERAMCNT1	((*((__RAM struct specialRegister *)0xbe)).bit4)
#define	FPERAMCNT0	((*((__RAM struct specialRegister *)0xbe)).bit3)
#define	FPERAML9	((*((__RAM struct specialRegister *)0xbe)).bit1)
#define	FPERAML8	((*((__RAM struct specialRegister *)0xbe)).bit0)
#define	PEDGE	(*((__RAM unsigned int*)0xbf))
#define	FP01G1	((*((__RAM struct specialRegister *)0xbf)).bit3)
#define	FP01G0	((*((__RAM struct specialRegister *)0xbf)).bit2)
#define	FP00G1	((*((__RAM struct specialRegister *)0xbf)).bit1)
#define	FP00G0	((*((__RAM struct specialRegister *)0xbf)).bit0)
#define	P1W	(*((__RAM unsigned int*)0xc0))
#define	FP17W	((*((__RAM struct specialRegister *)0xc0)).bit7)
#define	FP16W	((*((__RAM struct specialRegister *)0xc0)).bit6)
#define	FP15W	((*((__RAM struct specialRegister *)0xc0)).bit5)
#define	FP14W	((*((__RAM struct specialRegister *)0xc0)).bit4)
#define	FP13W	((*((__RAM struct specialRegister *)0xc0)).bit3)
#define	FP12W	((*((__RAM struct specialRegister *)0xc0)).bit2)
#define	FP11W	((*((__RAM struct specialRegister *)0xc0)).bit1)
#define	FP10W	((*((__RAM struct specialRegister *)0xc0)).bit0)
#define	P1M	(*((__RAM unsigned int*)0xc1))
#define	FP17M	((*((__RAM struct specialRegister *)0xc1)).bit7)
#define	FP16M	((*((__RAM struct specialRegister *)0xc1)).bit6)
#define	FP15M	((*((__RAM struct specialRegister *)0xc1)).bit5)
#define	FP14M	((*((__RAM struct specialRegister *)0xc1)).bit4)
#define	FP13M	((*((__RAM struct specialRegister *)0xc1)).bit3)
#define	FP12M	((*((__RAM struct specialRegister *)0xc1)).bit2)
#define	FP11M	((*((__RAM struct specialRegister *)0xc1)).bit1)
#define	FP10M	((*((__RAM struct specialRegister *)0xc1)).bit0)
#define	P2M	(*((__RAM unsigned int*)0xc2))
#define	FP27M	((*((__RAM struct specialRegister *)0xc2)).bit7)
#define	FP26M	((*((__RAM struct specialRegister *)0xc2)).bit6)
#define	FP25M	((*((__RAM struct specialRegister *)0xc2)).bit5)
#define	FP24M	((*((__RAM struct specialRegister *)0xc2)).bit4)
#define	FP23M	((*((__RAM struct specialRegister *)0xc2)).bit3)
#define	FP22M	((*((__RAM struct specialRegister *)0xc2)).bit2)
#define	FP21M	((*((__RAM struct specialRegister *)0xc2)).bit1)
#define	FP20M	((*((__RAM struct specialRegister *)0xc2)).bit0)
#define	P4M	(*((__RAM unsigned int*)0xc4))
#define	FP47M	((*((__RAM struct specialRegister *)0xc4)).bit7)
#define	FP46M	((*((__RAM struct specialRegister *)0xc4)).bit6)
#define	FP45M	((*((__RAM struct specialRegister *)0xc4)).bit5)
#define	FP44M	((*((__RAM struct specialRegister *)0xc4)).bit4)
#define	FP43M	((*((__RAM struct specialRegister *)0xc4)).bit3)
#define	FP42M	((*((__RAM struct specialRegister *)0xc4)).bit2)
#define	FP41M	((*((__RAM struct specialRegister *)0xc4)).bit1)
#define	FP40M	((*((__RAM struct specialRegister *)0xc4)).bit0)
#define	P5M	(*((__RAM unsigned int*)0xc5))
#define	FP55M	((*((__RAM struct specialRegister *)0xc5)).bit5)
#define	FP54M	((*((__RAM struct specialRegister *)0xc5)).bit4)
#define	FP53M	((*((__RAM struct specialRegister *)0xc5)).bit3)
#define	FP52M	((*((__RAM struct specialRegister *)0xc5)).bit2)
#define	FP51M	((*((__RAM struct specialRegister *)0xc5)).bit1)
#define	FP50M	((*((__RAM struct specialRegister *)0xc5)).bit0)
#define	INTRQ1	(*((__RAM unsigned int*)0xc6))
#define	FP1IRQ	((*((__RAM struct specialRegister *)0xc6)).bit7)
#define	FP0IRQ	((*((__RAM struct specialRegister *)0xc6)).bit6)
#define	FMSPIRQ	((*((__RAM struct specialRegister *)0xc6)).bit5)
#define	FUTRXIRQ	((*((__RAM struct specialRegister *)0xc6)).bit4)
#define	FUTTXIRQ	((*((__RAM struct specialRegister *)0xc6)).bit3)
#define	FTC2IRQ	((*((__RAM struct specialRegister *)0xc6)).bit2)
#define	FTC1IRQ	((*((__RAM struct specialRegister *)0xc6)).bit1)
#define	FTC0IRQ	((*((__RAM struct specialRegister *)0xc6)).bit0)
#define	INTEN1	(*((__RAM unsigned int*)0xc7))
#define	FP1IEN	((*((__RAM struct specialRegister *)0xc7)).bit7)
#define	FP0IEN	((*((__RAM struct specialRegister *)0xc7)).bit6)
#define	FMSPIEN	((*((__RAM struct specialRegister *)0xc7)).bit5)
#define	FUTRXIEN	((*((__RAM struct specialRegister *)0xc7)).bit4)
#define	FUTTXIEN	((*((__RAM struct specialRegister *)0xc7)).bit3)
#define	FTC2IEN	((*((__RAM struct specialRegister *)0xc7)).bit2)
#define	FTC1IEN	((*((__RAM struct specialRegister *)0xc7)).bit1)
#define	FTC0IEN	((*((__RAM struct specialRegister *)0xc7)).bit0)
#define	INTRQ	(*((__RAM unsigned int*)0xc8))
#define	FADCIRQ	((*((__RAM struct specialRegister *)0xc8)).bit7)
#define	FUSBIRQ	((*((__RAM struct specialRegister *)0xc8)).bit6)
#define	FT1IRQ	((*((__RAM struct specialRegister *)0xc8)).bit5)
#define	FT0IRQ	((*((__RAM struct specialRegister *)0xc8)).bit4)
#define	FSIOIRQ	((*((__RAM struct specialRegister *)0xc8)).bit3)
#define	FWAKEIRQ	((*((__RAM struct specialRegister *)0xc8)).bit2)
#define	FP01IRQ	((*((__RAM struct specialRegister *)0xc8)).bit1)
#define	FP00IRQ	((*((__RAM struct specialRegister *)0xc8)).bit0)
#define	INTEN	(*((__RAM unsigned int*)0xc9))
#define	FADCIEN	((*((__RAM struct specialRegister *)0xc9)).bit7)
#define	FUSBIEN	((*((__RAM struct specialRegister *)0xc9)).bit6)
#define	FT1IEN	((*((__RAM struct specialRegister *)0xc9)).bit5)
#define	FT0IEN	((*((__RAM struct specialRegister *)0xc9)).bit4)
#define	FSIOIEN	((*((__RAM struct specialRegister *)0xc9)).bit3)
#define	FWAKEIEN	((*((__RAM struct specialRegister *)0xc9)).bit2)
#define	FP01IEN	((*((__RAM struct specialRegister *)0xc9)).bit1)
#define	FP00IEN	((*((__RAM struct specialRegister *)0xc9)).bit0)
#define	OSCM	(*((__RAM unsigned int*)0xca))
#define	FCPUM1	((*((__RAM struct specialRegister *)0xca)).bit4)
#define	FCPUM0	((*((__RAM struct specialRegister *)0xca)).bit3)
#define	FCLKMD	((*((__RAM struct specialRegister *)0xca)).bit2)
#define	FSTPHX	((*((__RAM struct specialRegister *)0xca)).bit1)
#define	WDTR	(*((__RAM unsigned int*)0xcc))
#define	PCL	(*((__RAM unsigned int*)0xce))
#define	FPC7	((*((__RAM struct specialRegister *)0xce)).bit7)
#define	FPC6	((*((__RAM struct specialRegister *)0xce)).bit6)
#define	FPC5	((*((__RAM struct specialRegister *)0xce)).bit5)
#define	FPC4	((*((__RAM struct specialRegister *)0xce)).bit4)
#define	FPC3	((*((__RAM struct specialRegister *)0xce)).bit3)
#define	FPC2	((*((__RAM struct specialRegister *)0xce)).bit2)
#define	FPC1	((*((__RAM struct specialRegister *)0xce)).bit1)
#define	FPC0	((*((__RAM struct specialRegister *)0xce)).bit0)
#define	PCH	(*((__RAM unsigned int*)0xcf))
#define	FPC13	((*((__RAM struct specialRegister *)0xcf)).bit5)
#define	FPC12	((*((__RAM struct specialRegister *)0xcf)).bit4)
#define	FPC11	((*((__RAM struct specialRegister *)0xcf)).bit3)
#define	FPC10	((*((__RAM struct specialRegister *)0xcf)).bit2)
#define	FPC9	((*((__RAM struct specialRegister *)0xcf)).bit1)
#define	FPC8	((*((__RAM struct specialRegister *)0xcf)).bit0)
#define	P0	(*((__RAM unsigned int*)0xd0))
#define	FP07	((*((__RAM struct specialRegister *)0xd0)).bit7)
#define	FP06	((*((__RAM struct specialRegister *)0xd0)).bit6)
#define	FP05	((*((__RAM struct specialRegister *)0xd0)).bit5)
#define	FP04	((*((__RAM struct specialRegister *)0xd0)).bit4)
#define	FP03	((*((__RAM struct specialRegister *)0xd0)).bit3)
#define	FP02	((*((__RAM struct specialRegister *)0xd0)).bit2)
#define	FP01	((*((__RAM struct specialRegister *)0xd0)).bit1)
#define	FP00	((*((__RAM struct specialRegister *)0xd0)).bit0)
#define	P1	(*((__RAM unsigned int*)0xd1))
#define	FP17	((*((__RAM struct specialRegister *)0xd1)).bit7)
#define	FP16	((*((__RAM struct specialRegister *)0xd1)).bit6)
#define	FP15	((*((__RAM struct specialRegister *)0xd1)).bit5)
#define	FP14	((*((__RAM struct specialRegister *)0xd1)).bit4)
#define	FP13	((*((__RAM struct specialRegister *)0xd1)).bit3)
#define	FP12	((*((__RAM struct specialRegister *)0xd1)).bit2)
#define	FP11	((*((__RAM struct specialRegister *)0xd1)).bit1)
#define	FP10	((*((__RAM struct specialRegister *)0xd1)).bit0)
#define	P2	(*((__RAM unsigned int*)0xd2))
#define	FP27	((*((__RAM struct specialRegister *)0xd2)).bit7)
#define	FP26	((*((__RAM struct specialRegister *)0xd2)).bit6)
#define	FP25	((*((__RAM struct specialRegister *)0xd2)).bit5)
#define	FP24	((*((__RAM struct specialRegister *)0xd2)).bit4)
#define	FP23	((*((__RAM struct specialRegister *)0xd2)).bit3)
#define	FP22	((*((__RAM struct specialRegister *)0xd2)).bit2)
#define	FP21	((*((__RAM struct specialRegister *)0xd2)).bit1)
#define	FP20	((*((__RAM struct specialRegister *)0xd2)).bit0)
#define	P4	(*((__RAM unsigned int*)0xd4))
#define	FP47	((*((__RAM struct specialRegister *)0xd4)).bit7)
#define	FP46	((*((__RAM struct specialRegister *)0xd4)).bit6)
#define	FP45	((*((__RAM struct specialRegister *)0xd4)).bit5)
#define	FP44	((*((__RAM struct specialRegister *)0xd4)).bit4)
#define	FP43	((*((__RAM struct specialRegister *)0xd4)).bit3)
#define	FP42	((*((__RAM struct specialRegister *)0xd4)).bit2)
#define	FP41	((*((__RAM struct specialRegister *)0xd4)).bit1)
#define	FP40	((*((__RAM struct specialRegister *)0xd4)).bit0)
#define	P5	(*((__RAM unsigned int*)0xd5))
#define	FP55	((*((__RAM struct specialRegister *)0xd5)).bit5)
#define	FP54	((*((__RAM struct specialRegister *)0xd5)).bit4)
#define	FP53	((*((__RAM struct specialRegister *)0xd5)).bit3)
#define	FP52	((*((__RAM struct specialRegister *)0xd5)).bit2)
#define	FP51	((*((__RAM struct specialRegister *)0xd5)).bit1)
#define	FP50	((*((__RAM struct specialRegister *)0xd5)).bit0)
#define	T0M	(*((__RAM unsigned int*)0xd8))
#define	FT0ENB	((*((__RAM struct specialRegister *)0xd8)).bit7)
#define	FT0RATE2	((*((__RAM struct specialRegister *)0xd8)).bit6)
#define	FT0RATE1	((*((__RAM struct specialRegister *)0xd8)).bit5)
#define	FT0RATE0	((*((__RAM struct specialRegister *)0xd8)).bit4)
#define	T0C	(*((__RAM unsigned int*)0xd9))
#define	FT0C7	((*((__RAM struct specialRegister *)0xd9)).bit7)
#define	FT0C6	((*((__RAM struct specialRegister *)0xd9)).bit6)
#define	FT0C5	((*((__RAM struct specialRegister *)0xd9)).bit5)
#define	FT0C4	((*((__RAM struct specialRegister *)0xd9)).bit4)
#define	FT0C3	((*((__RAM struct specialRegister *)0xd9)).bit3)
#define	FT0C2	((*((__RAM struct specialRegister *)0xd9)).bit2)
#define	FT0C1	((*((__RAM struct specialRegister *)0xd9)).bit1)
#define	FT0C0	((*((__RAM struct specialRegister *)0xd9)).bit0)
#define	T1M	(*((__RAM unsigned int*)0xda))
#define	FT1ENB	((*((__RAM struct specialRegister *)0xda)).bit7)
#define	FT1RATE2	((*((__RAM struct specialRegister *)0xda)).bit6)
#define	FT1RATE1	((*((__RAM struct specialRegister *)0xda)).bit5)
#define	FT1RATE0	((*((__RAM struct specialRegister *)0xda)).bit4)
#define	T1CL	(*((__RAM unsigned int*)0xdb))
#define	FT1C7	((*((__RAM struct specialRegister *)0xdb)).bit7)
#define	FT1C6	((*((__RAM struct specialRegister *)0xdb)).bit6)
#define	FT1C5	((*((__RAM struct specialRegister *)0xdb)).bit5)
#define	FT1C4	((*((__RAM struct specialRegister *)0xdb)).bit4)
#define	FT1C3	((*((__RAM struct specialRegister *)0xdb)).bit3)
#define	FT1C2	((*((__RAM struct specialRegister *)0xdb)).bit2)
#define	FT1C1	((*((__RAM struct specialRegister *)0xdb)).bit1)
#define	FT1C0	((*((__RAM struct specialRegister *)0xdb)).bit0)
#define	T1CH	(*((__RAM unsigned int*)0xdc))
#define	FT1C15	((*((__RAM struct specialRegister *)0xdc)).bit7)
#define	FT1C14	((*((__RAM struct specialRegister *)0xdc)).bit6)
#define	FT1C13	((*((__RAM struct specialRegister *)0xdc)).bit5)
#define	FT1C12	((*((__RAM struct specialRegister *)0xdc)).bit4)
#define	FT1C11	((*((__RAM struct specialRegister *)0xdc)).bit3)
#define	FT1C10	((*((__RAM struct specialRegister *)0xdc)).bit2)
#define	FT1C9	((*((__RAM struct specialRegister *)0xdc)).bit1)
#define	FT1C8	((*((__RAM struct specialRegister *)0xdc)).bit0)
#define	STKP	(*((__RAM unsigned int*)0xdf))
#define	FGIE	((*((__RAM struct specialRegister *)0xdf)).bit7)
#define	FSTKPB2	((*((__RAM struct specialRegister *)0xdf)).bit2)
#define	FSTKPB1	((*((__RAM struct specialRegister *)0xdf)).bit1)
#define	FSTKPB0	((*((__RAM struct specialRegister *)0xdf)).bit0)
#define	P0UR	(*((__RAM unsigned int*)0xe0))
#define	P1UR	(*((__RAM unsigned int*)0xe1))
#define	P2UR	(*((__RAM unsigned int*)0xe2))
#define	P4UR	(*((__RAM unsigned int*)0xe4))
#define	P5UR	(*((__RAM unsigned int*)0xe5))
#define	_YZ	(*((__RAM unsigned int*)0xe7))
#define	P1OC	(*((__RAM unsigned int*)0xe9))
#define	FP06OC	((*((__RAM struct specialRegister *)0xe9)).bit3)
#define	FP05OC	((*((__RAM struct specialRegister *)0xe9)).bit2)
#define	FP11OC	((*((__RAM struct specialRegister *)0xe9)).bit1)
#define	FP10OC	((*((__RAM struct specialRegister *)0xe9)).bit0)
#define	MSPSTAT	(*((__RAM unsigned int*)0xea))
#define	FCKE	((*((__RAM struct specialRegister *)0xea)).bit6)
#define	FD_A	((*((__RAM struct specialRegister *)0xea)).bit5)
#define	FP	((*((__RAM struct specialRegister *)0xea)).bit4)
#define	FS	((*((__RAM struct specialRegister *)0xea)).bit3)
#define	FRED_WRT	((*((__RAM struct specialRegister *)0xea)).bit2)
#define	FBF	((*((__RAM struct specialRegister *)0xea)).bit0)
#define	MSPM1	(*((__RAM unsigned int*)0xeb))
#define	FWCOL	((*((__RAM struct specialRegister *)0xeb)).bit7)
#define	FMSPOV	((*((__RAM struct specialRegister *)0xeb)).bit6)
#define	FMSPENB	((*((__RAM struct specialRegister *)0xeb)).bit5)
#define	FCKP	((*((__RAM struct specialRegister *)0xeb)).bit4)
#define	FSLRXCKP	((*((__RAM struct specialRegister *)0xeb)).bit3)
#define	FMSPWK	((*((__RAM struct specialRegister *)0xeb)).bit2)
#define	FMSPC	((*((__RAM struct specialRegister *)0xeb)).bit0)
#define	MSPM2	(*((__RAM unsigned int*)0xec))
#define	FGCEN	((*((__RAM struct specialRegister *)0xec)).bit7)
#define	FACKSTAT	((*((__RAM struct specialRegister *)0xec)).bit6)
#define	FACKDT	((*((__RAM struct specialRegister *)0xec)).bit5)
#define	FACKEN	((*((__RAM struct specialRegister *)0xec)).bit4)
#define	FRCEN	((*((__RAM struct specialRegister *)0xec)).bit3)
#define	FPEN	((*((__RAM struct specialRegister *)0xec)).bit2)
#define	FRSEN	((*((__RAM struct specialRegister *)0xec)).bit1)
#define	FSEN	((*((__RAM struct specialRegister *)0xec)).bit0)
#define	MSPBUF	(*((__RAM unsigned int*)0xed))
#define	FMSPBUF7	((*((__RAM struct specialRegister *)0xed)).bit7)
#define	FMSPBUF6	((*((__RAM struct specialRegister *)0xed)).bit6)
#define	FMSPBUF5	((*((__RAM struct specialRegister *)0xed)).bit5)
#define	FMSPBUF4	((*((__RAM struct specialRegister *)0xed)).bit4)
#define	FMSPBUF3	((*((__RAM struct specialRegister *)0xed)).bit3)
#define	FMSPBUF2	((*((__RAM struct specialRegister *)0xed)).bit2)
#define	FMSPBUF1	((*((__RAM struct specialRegister *)0xed)).bit1)
#define	FMSPBUF0	((*((__RAM struct specialRegister *)0xed)).bit0)
#define	MSPADR	(*((__RAM unsigned int*)0xee))
#define	FMSPADR7	((*((__RAM struct specialRegister *)0xee)).bit7)
#define	FMSPADR6	((*((__RAM struct specialRegister *)0xee)).bit6)
#define	FMSPADR5	((*((__RAM struct specialRegister *)0xee)).bit5)
#define	FMSPADR4	((*((__RAM struct specialRegister *)0xee)).bit4)
#define	FMSPADR3	((*((__RAM struct specialRegister *)0xee)).bit3)
#define	FMSPADR2	((*((__RAM struct specialRegister *)0xee)).bit2)
#define	FMSPADR1	((*((__RAM struct specialRegister *)0xee)).bit1)
#define	FMSPADR0	((*((__RAM struct specialRegister *)0xee)).bit0)
#define	STK7L	(*((__RAM unsigned int*)0xf0))
#define	STK7H	(*((__RAM unsigned int*)0xf1))
#define	STK6L	(*((__RAM unsigned int*)0xf2))
#define	STK6H	(*((__RAM unsigned int*)0xf3))
#define	STK5L	(*((__RAM unsigned int*)0xf4))
#define	STK5H	(*((__RAM unsigned int*)0xf5))
#define	STK4L	(*((__RAM unsigned int*)0xf6))
#define	STK4H	(*((__RAM unsigned int*)0xf7))
#define	STK3L	(*((__RAM unsigned int*)0xf8))
#define	STK3H	(*((__RAM unsigned int*)0xf9))
#define	STK2L	(*((__RAM unsigned int*)0xfa))
#define	STK2H	(*((__RAM unsigned int*)0xfb))
#define	STK1L	(*((__RAM unsigned int*)0xfc))
#define	STK1H	(*((__RAM unsigned int*)0xfd))
#define	STK0L	(*((__RAM unsigned int*)0xfe))
#define	STK0H	(*((__RAM unsigned int*)0xff))
#define SLEEPMODE __asm{SleepMode}
#define GREENMODE __asm{GreenMode}
#define SLOWMODE __asm{SlowMode}
#define SLOW2NORMAL __asm{Slow2Normal}
#define SET_P3_INPUT_PULLUP __asm{Set_P3_Input_Pullup}
#endif
