
;-------------------------------------------------------------------------------
;	Crt0 For Chip SN8F2251B
;-------------------------------------------------------------------------------

CHIP SN8F2251B

public _tmpA
public _tmpB
public _tmpC
public T

public __ClearWatchDogTimer
public __ClrRAM
PUBLIC _sgv_init_entry

Extern CODE _main

;-------------------------------------------------------------------------------
;			Data section
;-------------------------------------------------------------------------------
crt0@data SEGMENT DATA AT 0x00 INBANK
	_tmpA ds 1
	_tmpB ds 1
	_tmpC ds 1
	T	ds 1

;-------------------------------------------------------------------------------
;			Code section
;-------------------------------------------------------------------------------
crt0@code SEGMENT CODE AT 0x0 INBANK
	ORG	0				;Code section start
	jmp		_sgv_init_entry		;Reset vector
	;Address 4 to 7 are reserved							
	ORG	8
	NOP;
_sgv_init_entry:
;Initialize STKP
	MOV A,# 0x7F
	B0MOV STKP, A 
	
	CALL __ClearWatchDogTimer;
	CALL __ClrRAM;

; Define a null segment
_SGV_INIT_CODE segment CODE

_SGV_INIT_CODE_END segment CODE

;-------------------------------------------------------------------------------
; Clear Watch dog timer
;-------------------------------------------------------------------------------
	CALL __ClearWatchDogTimer;
    JMP _main	

;-------------------------------------------------------------------------------
; Clear Watch dog timer
;-------------------------------------------------------------------------------
__ClearWatchDogTimer:
	MOV  A, #5AH
	B0MOV  WDTR, A
	RET
	
;-------------------------------------------------------------------------------
; ClrRAM
; Use index @YZ to clear RAM 
;-------------------------------------------------------------------------------

__ClrRAM:
	B0MOV RBANK,#0
; Clear RAM Bank 0
	CLR 		Y
	B0MOV		Z,#0x7f

ClrRAM10:
	CLR 		@YZ
	DECMS		Z
	JMP 		ClrRAM10
	CLR 		@YZ
	
; Clear RAM Bank 1
	B0MOV		Y,#1
	B0MOV		Z,#0xff

ClrRAM20:
	CLR 		@YZ
	DECMS		Z
	JMP 		ClrRAM20
	CLR 		@YZ	

; Clear RAM Bank 2
	B0MOV		Y,#2
	B0MOV		Z,#0x7f

ClrRAM30:
	CLR 		@YZ
	DECMS		Z
	JMP 		ClrRAM30
	CLR 		@YZ

	RET
