/**
*   ************************************************************************************
*                               о޹˾
*								www.chipswinner.com
*	************************************************************************************
*	@Demo 	Version		V1.0.0.0
*	@Date				2018.8.15
*	************************************************************************************
**/

/**************************************************************************************/
#define	_UART_
#include "uart.h"
#include "gpio.h"
#include "timer.h"
#include "register.h"
#include ".\Main\com.h"			
/***************************************************************************************/


/***************************************************************************************
* @    ʼUART1
* @˵    
* @    
* @ֵ 
* @ע 	   
***************************************************************************************/
void Uart1_Config(void)
{
	//TX PIN ;RX PIN 
	UART1_TX_PIN_ATT(IO_OUT_PUSH_PULL);
	UART1_TX_PIN_STATUS(PIN_HIGH);
	UART1_RX_PIN_ATT(IO_SMTIN_PULL_UP);
	UART1_TX_PIN_MAP();
	UART1_RX_PIN_MAP();
	//Fosc=32Mʱ,֧115200
	//Fosc=16M:FF98->9600;FFCC->19200
	TH4 = 0xFF;
	TL4 = 0xCC;
	//T4ģʽ:ΪUART1ʷ,ʱFoscƵ,ʹT4
	T4CON = TIM_T4PS_1 | TIM_T4M_1 | TIM_TR4_EN | TIM_T4CLKS_FOSC;
	BRTSEL = UART_UART1SEL_T4;
    
	//UART1ʽ1,н
	SCON2 = UART1_SM1SM0_MODE1;
	SCON = UART1_REN_EN;
	
	//UART1ж
	IE |= INT_ES1_EN;
	
	u8_uart1_tx_data_index = 0;
	u8_uart1_rx_data_index = 0;
}
/**************************************************************************************/


/***************************************************************************************
* @    UART1һBYTE
* @˵  	
* @	    
* @ֵ   
* @ע			   
***************************************************************************************/
void Uart1_SendOneByte(u8 u8_data)
{
	IE &= ~INT_ES1_EN;			//ֹж
	SBUF = u8_data;
	while(!(SCON & UART1_INT_TI));
	SCON &= ~UART1_INT_TI;
	IE |= INT_ES1_EN;
}
/***************************************************************************************
* @    UART1
* @˵  	
* @	    u8_length  ݳ(ȡֵΧ0x00-0xFF)
* @	    *u8_data_addr ȡݴŵ׵ַ
* @ֵ   
* @ע			   
***************************************************************************************/
void Uart1_SendData(u8 u8_length, u8 *u8_data_buf)
{
	//
	u8 i;

	for(i=0; i<u8_length; i++)
	{
		SBUF = u8_data_buf[i];
		while(!(SCON & UART1_INT_TI));
		SCON &= ~UART1_INT_TI;
	}
}
/**************************************************************************************/
void Uart1_SendData_Start(u8 *u8_index, u8 *u8_data_buf)
{
	//͵һֽ,ֽжз
	*u8_index = 0;
	SBUF = *u8_data_buf;
}
/**************************************************************************************/	
void Uart1_SendData_Int(u8 *u8_index, u8 *u8_data_buf)
{	
	//UART͵һBYTEݺ,жз	
	if(SCON & UART1_INT_TI)
	{
		SCON &= ~UART1_INT_TI;
		*u8_index += 1;
		if(*u8_index < UART1_TX_NUM)
		{
			SBUF = u8_data_buf[*u8_index];
		}
	}
}
/**************************************************************************************/


/***************************************************************************************
* @    UART1жлȡ UART_RX_NUM ,ݱ־
* @˵    UART1же
* @    
* @ֵ 
* @ע 	   
***************************************************************************************/
void Uart1_ReceiveData(u8 *u8_index,u8 *u8_data_buf)
{	//
/*	
	if(SCON & UART1_INT_RI)
	{	//ݳȽ
		SCON &= ~UART1_INT_RI;
		u8_data_buf[*u8_index] = SBUF;
		*u8_index += 1;
		if(*u8_index >= UART1_RX_NUM)
		{
            *u8_index = 0;
			b_uart1_rx_end = FLAG_EN;
		}
	}
*/
	u8 buf;
	
	if(SCON & UART1_INT_RI)
	{	//Эʽ
		SCON &= ~UART1_INT_RI;
		buf = SBUF;
		if(*u8_index >= UART1_RX_NUM)
		{	//ݴ洢ָ쳣
			*u8_index = 0;
		}
		else
		{
			if(0x78 == buf)
			{	//ݿʼ
				*u8_index = 0;
				u8_data_buf[0] = 0x78;
			}
			else
			{
				*u8_index += 1;
				u8_data_buf[*u8_index] = buf;
				if(0xff == buf)
				{//ݽ
					b_uart1_rx_end = FLAG_EN;
					*u8_index = 0;
				}	
			}
		}	
	}
}
/**************************************************************************************/




/***************************************************************************************
* @ 	UART1жϷ 
* @˵    
* @    
* @ֵ 
* @ע 
***************************************************************************************/
void UART1_Rpt(void) interrupt UART1_VECTOR
{
	Uart1_ReceiveData(&u8_uart1_rx_data_index,u8_uart1_rx_data);
//	Uart1_SendData_Int(&u8_uart1_tx_data_index,u8_uart1_tx_data);
}
/*************************************************************************************/





#if DEBUG_MODE
/***************************************************************************************
* @    ʼUART2
* @˵    
* @    
* @ֵ 
* @ע 	   
***************************************************************************************/
void Uart2_Config(void)
{
	//TX PIN 
	UART2_TX_PIN_ATT(IO_OUT_PUSH_PULL);
	UART2_TX_PIN_STATUS(PIN_HIGH);
	UART2_TX_PIN_MAP();

	//Fosc=16M,FF98->9600;FFCC->19200;FFEF->57600
	RCAP5H = 0xFF;
	RCAP5L = 0xCC;
	//T5ģʽ:ΪUART2ʷ,ʱFoscƵ,ʹT5
	T5CON = TIM_T5PS_1 | TIM_T5M_1 | TIM_TR5_EN;
	BRTSEL |= UART_UART2SEL_T5;
    
	//UART2ʽ0
	S2CON2 = UART2_SM1_8BIT;
	
	IE &= ~INT_ES2_EN;			//ֹж
}
/**************************************************************************************/

/***************************************************************************************
* @    UART2
* @˵  	
* @	    u8_length  ݳ(ȡֵΧ0x00-0xFF)
* @	    *u8_data_buf ȡݴŵBUF
* @ֵ   
* @ע			   
***************************************************************************************/
void Uart2_SendData(u8 u8_length, u8 *u8_data_buf)
{
	//
	u8 i;
	
	//
	S2BUF = '\n';
	while(!(S2CON & UART2_INT_TI));
	S2CON &= ~UART2_INT_TI;
	//ð
	S2BUF = ':';
	while(!(S2CON & UART2_INT_TI));
	S2CON &= ~UART2_INT_TI;
	//ַ	
	for(i=0; i<u8_length; i++)
	{
		S2BUF = u8_data_buf[i];
		while(!(S2CON & UART2_INT_TI));
		S2CON &= ~UART2_INT_TI;
	}
	//
	S2BUF = '\n';
	while(!(S2CON & UART2_INT_TI));
	S2CON &= ~UART2_INT_TI;
}
/**************************************************************************************/

/***************************************************************************************
* @     16תΪַ
* @˵  	
* @	    
* @	   
* @ֵ   
* @ע			   
***************************************************************************************/
u8 HexToString(u32 u32_num, u8 *u8_buf)
{
	u8 i,j;
	u8 buf[20];
	u32 k;
	
	k = u32_num;
	for(i=0;  ; i++)
	{
		j = k % 10;
		k /= 10;
		buf[i] = j + '0';
		if(0 == k)
		{
			break;
		}
	}
	for(j=0,k=i+1; j<k; j++,i--)
	{
		u8_buf[j] = buf[i];
	}
	return j;
}
/***************************************************************************************
* @    
* @˵  	
* @	    
* @	   
* @ֵ   
* @ע			   
***************************************************************************************/
void LogBuf(u8 u8_type, u32 u32_data)
{ 
	u8 buf[20];
	
	if(1 == u8_type)
	{
		Uart2_SendData(HexToString(u32_data,buf),buf);
	}

}
/**************************************************************************************/
#endif
