/**
*   ************************************************************************************
*                               о޹˾
*								www.chipswinner.com
*	************************************************************************************
*	@Demo 	Version		V1.0.0.0
*	@Date				2018.8.27
*	************************************************************************************
**/

/**************************************************************************************/
#define	_SPI_
#include "spi.h"
#include "gpio.h"
#include "register.h"
/**************************************************************************************/



/***************************************************************************************
* @    ʼSPI()
* @˵    
* @    
* @ֵ 
* @ע 	   
***************************************************************************************/
void Spi_Master_Config(void)
{
	//SS PIN 
	//SCK PIN 
	//MOSI PIN 
	//MISO PIN SMT
//	SPI_SS_PIN_ATT(IO_OUT_PUSH_PULL);
	SPI_SCK_PIN_ATT(IO_OUT_PUSH_PULL);
	SPI_MOSI_PIN_ATT(IO_OUT_PUSH_PULL);
	SPI_MISO_PIN_ATT(IO_SMTIN);
//	SPI_MISO_PIN_ATT(IO_SMTIN_PULL_DOWN);
//	SPI_SS_PIN_MAP();
	SPI_SCK_PIN_MAP();
	SPI_MOSI_PIN_MAP();
	SPI_MISO_PIN_MAP();
	
	//ݼĴ0
	SPDAT = 0;
	//״̬Ĵ0
	SPSTAT = 0;
	//ģʽ(),ʱFosc/128
	SPCTL = SPI_SSIG | SPI_SPEN | SPI_MSTR | SPI_CPHA | SPI_SPR_FOSC128;
//	SPCTL = SPI_SSIG | SPI_MSTR | SPI_CPHA | SPI_SPR_FOSC128;
	
	spi_rxflag = FLAG_DIS;
	u8_spi_rxcnt = 0;
	u8_spi_txcnt = 0;
}
/**************************************************************************************/

/***************************************************************************************
* @    
* @˵    
* @    
* @ֵ 
* @ע 	   
***************************************************************************************/
void Spi_Master_WirteData(u8 u8_length,u8 *u8_txdata)
{
	u8 i;
	
	for(i=0; i<u8_length; i++)
	{
		SPSTAT = SPI_SPIF | SPI_WCOL;
		SPDAT = u8_txdata[i];
		while(!(SPSTAT&SPI_SPIF));
		SPSTAT = SPI_SPIF | SPI_WCOL;
		//delay
	}
}
/***************************************************************************************
* @     
* @˵    
* @    
* @ֵ 
* @ע 	   
***************************************************************************************/
void Spi_Master_ReadData(u8 u8_length,u8 *u8_rxdata)
{
	u8 i;
	
	for(i=0; i<u8_length; i++)
	{
		SPSTAT = SPI_SPIF | SPI_WCOL;
		SPDAT = 0xFF;
		while(!(SPSTAT&SPI_SPIF));
		SPSTAT = SPI_SPIF | SPI_WCOL;
		u8_rxdata[i] = SPDAT;
	}
}
/**************************************************************************************/



/***************************************************************************************
* @    ʼSPI(ӻ)
* @˵    
* @    
* @ֵ 
* @ע 	   
***************************************************************************************/
void Spi_Slave_Config(void)
{
//	//SS PIN SMT
	//SCK PIN SMT
	//MOSI PIN SMT
	//MISO PIN 
//	SPI_SS_PIN_ATT(IO_SMTIN);
	SPI_SCK_PIN_ATT(IO_SMTIN);
	SPI_MOSI_PIN_ATT(IO_SMTIN);
	SPI_MISO_PIN_ATT(IO_OUT_PUSH_PULL);
//	SPI_SS_PIN_MAP();
	SPI_SCK_PIN_MAP();
	SPI_MOSI_PIN_MAP();
	SPI_MISO_PIN_MAP();
	
	//ݼĴ0
	SPDAT = 0;
	//״̬Ĵ0
	SPSTAT = 0;
	//ӻģʽ(),ʱFosc/128
	SPCTL = SPI_SSIG | SPI_SPEN | SPI_CPHA | SPI_SPR_FOSC128;
	
	//SPIж
	IE1 |= INT_ESPI_EN;
	
	//
	spi_rxflag = FLAG_DIS;
	u8_spi_rxcnt = 0;
	u8_spi_txcnt = 0;
}
/**************************************************************************************/

/***************************************************************************************
* @    ӻ׼
* @˵    SPIȫ˫,ӻǰ,ӻдݵSPDAT
* @    
* @ֵ 
* @ע 	   
***************************************************************************************/
void SPI_Slave_Reply(void)
{
	if(FLAG_DIS == spi_rxflag)
	{
		if(u8_spi_txcnt < SPI_SEND_NUM)
		{
			SPDAT = u8_spi_send_buf[u8_spi_txcnt];
			u8_spi_txcnt++;
		}
		spi_rxflag = FLAG_EN;
	}
	if(u8_spi_txcnt >= SPI_SEND_NUM)
	{
		u8_spi_txcnt = 0;
	}
}
/**************************************************************************************/


/***************************************************************************************
* @     SPIжϷ
* @˵    
* @    
* @ֵ 
* @ע 
***************************************************************************************/
void SPI_Rpt(void) interrupt SPI_VECTOR
{
	//SPIж
	SPSTAT |= SPI_SPIF | SPI_WCOL;
	if(u8_spi_rxcnt < SPI_RECEIVE_NUN)
	{
		u8_spi_receive_buf[u8_spi_rxcnt] = SPDAT;
		u8_spi_rxcnt++;	
	}
	//ýձ־
	spi_rxflag = FLAG_DIS;
}
/*************************************************************************************/
