/**
*   ************************************************************************************
*                               о޹˾
*								www.chipswinner.com
*	************************************************************************************
*	@Demo 	Version		V1.0.0.0
*	@Date				2018.8.23
*	************************************************************************************
**/
/***************************************************************************************

***************************************************************************************/


/**************************************************************************************/
#define	_IIC_
#include "iic.h"
#include "gpio.h"								
#include "register.h"
/**************************************************************************************/



/***************************************************************************************
* @    ʼIIC,Ϊ
* @˵    
* @    
* @ֵ 
* @ע 	   
***************************************************************************************/
void Iic_Master_Config(void)
{
	//SCL PIN ;SDA PIN ÿ©
	IIC_SCL_PIN_ATT(IO_OUT_OPENDRAIN_PULLUP);
	IIC_SDA_PIN_ATT(IO_OUT_OPENDRAIN_PULLUP);
	IIC_SCL_PIN_MAP();
	IIC_SDA_PIN_MAP();
	
	//IICģ,ʱFose/256
	IICCON = IIC_CLK_256 | IIC_EN;
	
	u8_iic_send_cnt = 0;
	u8_iic_rece_cnt = 0;
}
/**************************************************************************************/


/***************************************************************************************
* @    ()
* @˵    
* @    
* @ֵ 
* @ע 	   
***************************************************************************************/
void Iic_Master_SendData(u8 u8_length,u8 *u8_data)
//void Iic_Master_SendData(u8 u8_length,u8 *u8_data,u8 u8_adr)
{
	u8 i;
	
	//жϱ־λ
	IICCON &=~ (IIC_SI_INT + IIC_STO_EN);
	//ʼλʼź
	IICCON |= IIC_STA_EN;
	while((!(IICCON & IIC_SI_INT)) && (IICSTA != IIC_R_IICSTA_08H));
	//ֹͣʼλź
	IICCON &=~ IIC_STA_EN;
	
	//жϱ־λ
	IICCON &=~ IIC_SI_INT;
	//дӻַ
	IICDAT = (IIC_SLAVE_ADDR + IIC_CMD_WRITE);
	while((!(IICCON & IIC_SI_INT)) && (IICSTA != IIC_R_IICSTA_18H));
//	
//	//жϱ־λ
//	IICCON &=~ IIC_SI_INT;
//	//дʵַ		
//	IICDAT = u8_adr;
//	while((!(IICCON & IIC_SI_INT)) && (IICSTA != IIC_R_IICSTA_28H));

	//д		
    for(i = 0; i < u8_length; i++)
    {
    	//жϱ־λ
    	IICCON &=~ IIC_SI_INT;
        IICDAT = u8_data[i];
		while((!(IICCON & IIC_SI_INT)) && (IICSTA != IIC_R_IICSTA_28H));    
    }
    
    //жϱ־λ
	IICCON &=~ IIC_SI_INT;
	//ֹͣλʼź
	IICCON |= IIC_STO_EN;
	//жϱ־λ
	IICCON &=~ (IIC_SI_INT + IIC_STO_EN);
}
/**************************************************************************************/


/***************************************************************************************
* @    ȡ()
* @˵    
* @    
* @ֵ 
* @ע 	   
***************************************************************************************/
void Iic_Master_ReadData(u8 u8_length,u8 *u8_data)
//void Iic_Master_ReadData(u8 u8_length,u8 *u8_data,u8 u8_adr)
{
	u8 i;
	
	//жϱ־λ
	IICCON &=~ (IIC_SI_INT + IIC_STO_EN);
	//ʼλʼź
	IICCON |= IIC_STA_EN;
	//ȴSTARTźŷ
	while((!(IICCON & IIC_SI_INT)) && (IICSTA != IIC_R_IICSTA_08H));
	//ֹͣʼλź
	IICCON &=~ IIC_STA_EN;
	
	//жϱ־λ
	IICCON &=~ IIC_SI_INT;
	//дӻַ
	IICDAT = (IIC_SLAVE_ADDR + IIC_CMD_WRITE);
	//ȴӻַ
	while((!(IICCON & IIC_SI_INT)) && (IICSTA != IIC_R_IICSTA_18H));
	
//	//жϱ־λ
//	IICCON &=~ IIC_SI_INT;
//	//дʵַ		
//	IICDAT = u8_adr;
//	while((!(IICCON & IIC_SI_INT)) && (IICSTA != IIC_R_IICSTA_28H));
	
	//жϱ־λ
	IICCON &=~ IIC_SI_INT;
	//ʼλʼź
	IICCON |= IIC_STA_EN;
	//ȴSTARTźŷ
	while((!(IICCON & IIC_SI_INT)) && (IICSTA != IIC_R_IICSTA_08H));
	//ֹͣʼλź
	IICCON &=~ IIC_STA_EN;
	
	//жϱ־λ
	IICCON &=~ IIC_SI_INT;
	//дӻַ+ָ
	IICDAT = (IIC_SLAVE_ADDR + IIC_CMD_READ);
	//ȴӻַ
	while((!(IICCON & IIC_SI_INT)) && (IICSTA != IIC_R_IICSTA_40H));

	//		
    for(i = 0; i < u8_length; i++)
    {
    	//ظACK
    	IICCON |= IIC_AA;
      	//жϱ־λ
		IICCON &=~ IIC_SI_INT;
		while((!(IICCON & IIC_SI_INT)) && (IICSTA != IIC_R_IICSTA_50H));
		u8_data[i] = IICDAT;    
    }
    
    //ظNACK
    IICCON &= ~IIC_AA;
    //жϱ־λ
	IICCON &=~ IIC_SI_INT;
	while((!(IICCON & IIC_SI_INT)) && (IICSTA != IIC_R_IICSTA_58H));
	
	//жϱ־λ
	IICCON &=~ IIC_SI_INT;
	//ֹͣλʼź
	IICCON |= IIC_STO_EN;
	//жϱ־λ
	IICCON &=~ (IIC_SI_INT + IIC_STO_EN);
}
/**************************************************************************************/



/***************************************************************************************
* @    ʼIIC,Ϊӻ
* @˵    
* @    
* @ֵ 
* @ע 	   
***************************************************************************************/
void Iic_Slave_Config(void)
{
	//SCL PIN ;SDA PIN ÿ©
	IIC_SCL_PIN_ATT(IO_OUT_OPENDRAIN_PULLUP);
	IIC_SDA_PIN_ATT(IO_OUT_OPENDRAIN_PULLUP);
	IIC_SCL_PIN_MAP();
	IIC_SDA_PIN_MAP();
	
	//ӻַ
	IICADR = IIC_MODE_SLAVE_ADDR;
	//IICģ,ʱFose/256
	//رע:趨ӻַIIC,ظӦź,ܿӻ
	IICCON = IIC_CLK_256 | IIC_EN | IIC_AA;
	//IICж
	IE2 = INT_IIC_EN;
	
	u8_iic_send_cnt = 0;
	u8_iic_rece_cnt = 0;
}
/**************************************************************************************/

/***************************************************************************************
* @    IICжϷ()
* @˵    
* @    
* @ֵ 
* @ע 	   
***************************************************************************************/
void IIC_Rpt(void) interrupt IIC_VECTOR
{
	switch (IICSTA) 
    {
        case IIC_R_IICSTA_00H:
        	//ߴ,ֹͣź
            IICCON |= IIC_STO_EN;
        break;
        case IIC_R_IICSTA_60H:
        	//ӻյдַ,Ӧ
            IICCON |= IIC_AA;
        break;
        case IIC_R_IICSTA_80H:
        	//ӻ,Ӧ
            u8_iic_rece_buf[u8_iic_rece_cnt++] = IICDAT; 
            IICCON |= IIC_AA;
            if(u8_iic_rece_cnt >= IIC_RECE_NUN) 
            {	//ӻ
                u8_iic_rece_cnt = 0;
				//for test
				u8_iic_send_buf[0] = u8_iic_rece_buf[0];
				u8_iic_send_buf[1] = u8_iic_rece_buf[1];
				u8_iic_send_buf[2] = u8_iic_rece_buf[2];
				u8_iic_send_buf[3] = u8_iic_rece_buf[3];
				u8_iic_send_cnt = 0;
            }
            break;
        case IIC_R_IICSTA_A8H:
        	//ӻյSLA+R,,Ӧ
            IICDAT = u8_iic_send_buf[u8_iic_send_cnt++];
            IICCON |= IIC_AA;
        
            if(u8_iic_send_cnt >= IIC_SEND_NUM)
            { 
                u8_iic_send_cnt = 0;
            }
            break;
        case IIC_R_IICSTA_B8H:
        	//ӻѾ
            IICDAT = u8_iic_send_buf[u8_iic_send_cnt++];
            IICCON |= IIC_AA;
        
            if(u8_iic_send_cnt >= IIC_SEND_NUM)
        	{
                u8_iic_send_cnt = 0;
            }
            break;
    }
    //ж	
    IICCON &= ~IIC_SI_INT;
}
/**************************************************************************************/
