/**************************************************************************************/
#define _TEST_
#include "test.h"
#include "intrins.h"
#include "stdio.h"
#include ".\Sys\flash.h"
#include ".\Sys\register.h"
#include ".\Sys\adc.h"
#include ".\Sys\uart.h"
#include ".\Sys\iic.h"
#include ".\Sys\spi.h"
#include ".\main\com.h"

/**************************************************************************************/
//flash ȡ
#define	D_FLASH_DATA_ADDR		(128*126)	//126
#define	D_FLASH_DATA_NUM		8
#define	D_FLASH_DATA_LENGTH		D_FLASH_DATA_NUM
/**************************************************************************************/
//adc 
#define	D_ADC_FREQCNT			10						//1MS,ʱ10MS



/***************************************************************************************
* @		նһַ
* @˵  	putcharprintfµõĺ(д˺)
* @  	
* @ֵ   
* @ע		
***************************************************************************************/
char putchar(char c)
{
	Uart1_SendOneByte(c);
	return c;
}
/**************************************************************************************/


/**************************************************************************************
* 
* 
**************************************************************************************/
const code ValueTab[] = 
{
	0x10,	0x21,	0x32,	0x43,	0x54,	0x65,	0x76,	0x87,	0x98,	0xA9,
	0xBA,	0xCB,	0xDC,	0xED,	0xFE,	0xFF,	0x100,	0x11A,	0x210,	0x2FF
};

u16 GetValueTab(u8 i)
{
	u16 *p;
	
	p = (u16 *)(&ValueTab);
	p += i;
	return *p;
}

u16 GetValue_From_Tab(u16 *tab,u8 i)
{
	u16 *p;
	
	p = tab + i;
	return *p;
}

void Tab_TestPro(void)
{
	u8 i;
	u16 j;
	
	for(i=0; i<20; i++)
   	{
    	j = GetValueTab(i);
    }
    //Զϵ
    i = 0;
    
    for(i=0; i<20; i++)
   	{
    	j = GetValue_From_Tab((u16 *)(&ValueTab),i);
    }
    //Զϵ
    i = 0;
}
/**************************************************************************************/


/***************************************************************************************
* @     flashд
* @˵  	д8BYTEݵFLASHв
* @  	
* @ֵ   
* @ע		
***************************************************************************************/
void Flash_TestPro(void)
{
	u8 u8_read_flash_data[D_FLASH_DATA_NUM] = {0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF};
    u8 u8_write_flash_data[D_FLASH_DATA_NUM] = {0xA0,0xB2,0xC3,0xD4,0xE5,0xF6,0xFF,0x00};
    
    /*ڽFLASHIAPд֮ǰ,ҪչSFRFREQ_CLKĴ,ָĿǰCPUʱӵƵ */
    FREQ_CLK = FREQ_CLK_16MHZ;
    Flash_EraseBlock(D_FLASH_DATA_ADDR);
    Flash_WriteAnyLengthData(D_FLASH_DATA_ADDR,D_FLASH_DATA_LENGTH,u8_write_flash_data);
    Flash_ReadAnyLengthData(D_FLASH_DATA_ADDR,D_FLASH_DATA_LENGTH,u8_read_flash_data);
    //Զϵ
    _nop_();
    //ȡоƬID,ȡOPTIONѡʱҪINSCONĵ4λ1,ѡӦָ
	INSCON |= BIT4;
    Flash_ReadAnyLengthData(FLASH_CHIP_ID_ADDR,8,u8_read_flash_data);
	INSCON &= ~BIT4;
    _nop_();
	INSCON |= BIT4;
	Flash_ReadAnyLengthData(FLASH_CHIP_SN_ADDR,4,u8_read_flash_data);
	INSCON &= ~BIT4;
}   
/**************************************************************************************/
  

/***************************************************************************************
* @  ڲVDDP20ڵѹ,10ȡƽֵ,100MS,1Sȡһβ
* @˵    
* @    
* @ֵ 
* @ע 	   
***************************************************************************************/
void Adc_TestPro(void)
{
	if(u8_adc_freqcnt <= D_ADC_FREQCNT)
	{
		return;
	}
	u8_adc_freqcnt = 0;
	
	Adc_Sample_Cycle();
}
/**************************************************************************************/


/***************************************************************************************
* @  UART1
* @˵    
* @    
* @ֵ 
* @ע 	   
***************************************************************************************/
void Uart1Tx_TestPro(void)
{
	u8_uart1_tx_data[0] = 0x78;
    u8_uart1_tx_data[1] = 0xaa;
    u8_uart1_tx_data[2] = 0xF0;
    u8_uart1_tx_data[3] = 0x0F;
	u8_uart1_tx_data[4] = 0xFF;
    Uart1_SendData(UART1_TX_NUM,u8_uart1_tx_data);
    _nop_();
//	Uart1_SendData_Start(&u8_uart1_tx_data_index,u8_uart1_tx_data);
}
/**************************************************************************************/


/***************************************************************************************
* @  IIC
* @˵    
* @    
* @ֵ 
* @ע 	   
***************************************************************************************/
void IicSend_TestPro(void)
{
	u8_iic_send_buf[0] = 0x55;
    u8_iic_send_buf[1] = 0xaa;
    u8_iic_send_buf[2] = 0xF0;
    u8_iic_send_buf[3] = 0x0F;
    Iic_Master_SendData(4,u8_iic_send_buf);
	u8_iic_rece_buf[0] = 0x0;
    u8_iic_rece_buf[1] = 0x0;
    u8_iic_rece_buf[2] = 0x0;
    u8_iic_rece_buf[3] = 0x0;
	Iic_Master_ReadData(4,u8_iic_rece_buf);
	_nop_();
}
/**************************************************************************************/


/***************************************************************************************
* @  SPI
* @˵    
* @    
* @ֵ 
* @ע 	   
***************************************************************************************/
void SpiMasterSlave_TestPro(void)
{
#if SPI_MASTER
	while(1)
	{
		u8_spi_send_buf[0] = 0x55;
		u8_spi_send_buf[1] = 0xaa;
		u8_spi_send_buf[2] = 0x0f;
		u8_spi_send_buf[3] = 0xf0;
		u8_spi_send_buf[4] = 0;
		u8_spi_send_buf[5] = 0xff;
		u8_spi_txcnt = 0;
		Spi_Master_WirteData(SPI_SEND_NUM,u8_spi_send_buf);
		Delay_ms(10);
		
		u8_spi_rxcnt = 0;
		u8_spi_receive_buf[0] = 0;
		u8_spi_receive_buf[1] = 0;
		u8_spi_receive_buf[2] = 0;
		u8_spi_receive_buf[3] = 0;
		u8_spi_receive_buf[4] = 0;
		u8_spi_receive_buf[5] = 0;
		Spi_Master_ReadData(SPI_RECEIVE_NUN,u8_spi_receive_buf);
		
		Delay_ms(10);
	}
#endif

#if SPI_SLAVE
	u8_spi_index = 0;
	u8_spi_receive_buf[0] = 0;
    u8_spi_receive_buf[1] = 0;
    u8_spi_receive_buf[2] = 0;
    u8_spi_receive_buf[3] = 0;
	u8_spi_receive_buf[4] = 0;
	u8_spi_receive_buf[5] = 0;
	
//	u8_spi_send_buf[0] = 0x55;
//	u8_spi_send_buf[1] = 0xaa;
//	u8_spi_send_buf[2] = 0x0f;
//	u8_spi_send_buf[3] = 0xf0;
//	u8_spi_send_buf[4] = 0;
//	u8_spi_send_buf[5] = 0xff;
	while(1)
	{
		if(u8_spi_rxcnt >= SPI_DATA_NUM)
		{
			if((0x55 == u8_spi_receive_buf[0]) && (0xaa == u8_spi_receive_buf[1]) && (0x0f == u8_spi_receive_buf[2]) 
				&& (0xf0 == u8_spi_receive_buf[3]) && (0 == u8_spi_receive_buf[4]) && (0xff == u8_spi_receive_buf[5]))
			{
				u8_spi_send_buf[0] = u8_spi_receive_buf[0];
				u8_spi_send_buf[1] = u8_spi_receive_buf[1];
				u8_spi_send_buf[2] = u8_spi_receive_buf[2];
				u8_spi_send_buf[3] = u8_spi_receive_buf[3];
				u8_spi_send_buf[4] = u8_spi_receive_buf[4];
				u8_spi_send_buf[5] = u8_spi_receive_buf[5];
				spi_rxflag = FLAG_DIS;
				u8_spi_txcnt = 0;
			}
			u8_spi_rxcnt = 0;
		}
		SPI_Slave_Reply();
	}
#endif
}
/**************************************************************************************/
