/************************************************************************************************/
/**
* @file               common.c
* @author             MCU Ecosystem Development Team
* @brief              ͨúصʵֺ
*
*
**************************************************************************************************
* @attention
* Copyright (c) CEC Huada Electronic Design Co.,Ltd. All rights reserved.
*
**************************************************************************************************
*/

/*------------------------------------------includes--------------------------------------------*/
#include "common.h"
#include <stdio.h>

#define TIM_ARR_VALUE           (1000 - 1)
/*------------------------------------------functions-------------------------------------------*/
/**
* @brief  ϵͳʱ
* @retval 
*/
void system_clock_config(void)
{
    /* Flashʵȴʱ */
    std_flash_set_latency(FLASH_LATENCY_1CLK);

    /* ʹRCH */
    std_rcc_rch_enable();
    while(std_rcc_get_rch_ready() != RCC_CSR1_RCHRDY);
  
    /* ϵͳʱԴΪRCH */
    std_rcc_set_sysclk_source(RCC_SYSCLK_SRC_RCH);
    while(std_rcc_get_sysclk_source() != RCC_SYSCLK_SRC_STATUS_RCH);

    /* AHBƵ */
    std_rcc_set_ahbdiv(RCC_HCLK_DIV1);
    /* APBƵ */
    std_rcc_set_apbdiv(RCC_PCLK_DIV1);
    /* ϵͳʱȫֱ */
    SystemCoreClock = RCH_VALUE;
}

/**
* @brief  GPIOʼ
* @retval 
*/
void gpio_init(void)
{
    std_gpio_init_t gpio_config = {0} ;

    /* ʹUARTӦGPIOʱ */
    std_rcc_gpio_clk_enable(RCC_PERIPH_CLK_GPIOA);

    /* GPIO  
        PA3    ------> TX  
        PA4    ------> RX  
    */
    gpio_config.pin = GPIO_PIN_3|GPIO_PIN_4;
    gpio_config.mode = GPIO_MODE_ALTERNATE;
    gpio_config.pull = GPIO_PULLUP;
    gpio_config.output_type = GPIO_OUTPUT_PUSHPULL;
    gpio_config.alternate = GPIO_AF1_UART1;
    std_gpio_init(GPIOA,&gpio_config);
  
}

/**
* @brief  UART ʼ
* @retval 
*/
void uart_init(void)
{
    std_uart_init_t uart_confg = {0};
    /* UART ʱʹ */
    std_rcc_apb2_clk_enable(RCC_PERIPH_CLK_UART1);
        
    /* UART ʼ */
    uart_confg.baudrate = 115200;
    uart_confg.direction = UART_DIRECTION_SEND_RECEIVE;
    uart_confg.wordlength = UART_WORDLENGTH_8BITS;
    uart_confg.stopbits = UART_STOPBITS_1;
    uart_confg.parity = UART_PARITY_NONE;
    std_uart_init(UART1,&uart_confg);

    /* ʹUART */
    std_uart_enable(UART1);
}

/**
* @brief  TIM1ʼ
* @retval 
*/
void tim1_init(void)
{
    std_tim_basic_init_t basic_init_struct = {0};
    uint32_t tmp_psc_value;
    
    /* TIM1ʱʹ */
    std_rcc_apb2_clk_enable(RCC_PERIPH_CLK_TIM1);
    
    tmp_psc_value = (uint32_t)(((SystemCoreClock) / 48000) - 1);
        
    /* TIM1 */
    basic_init_struct.prescaler = tmp_psc_value;
    basic_init_struct.counter_mode = TIM_COUNTER_MODE_UP;
    basic_init_struct.period = TIM_ARR_VALUE;
    basic_init_struct.clock_div = TIM_CLOCK_DTS_DIV1;
    basic_init_struct.repeat_counter = 0x00;
    std_tim_init(TIM1, &basic_init_struct);    
    
    /* ¼־ */
    std_tim_clear_flag(TIM1, TIM_FLAG_UPDATE);
	
	/* ʹܸж */
    std_tim_interrupt_enable(TIM1, TIM_INTERRUPT_UPDATE);
    
    /* ʱ */
    std_tim_enable(TIM1);
}


/**
* @brief  NVIC ʼ
* @retval 
*/
void nvic_init(void)
{
    /* UART1жȼԼʹUART1NVICж */   
    NVIC_SetPriority(UART1_IRQn,NVIC_PRIO_1);    
    NVIC_EnableIRQ(UART1_IRQn);
	/* TIM1 */
	NVIC_SetPriority(TIM1_BRK_UP_TRG_COM_IRQn, NVIC_PRIO_0);
    NVIC_EnableIRQ(TIM1_BRK_UP_TRG_COM_IRQn);
}

int fputc(int ch, FILE *f)
{
	std_uart_tx_write_data(UART1,(uint8_t)ch);
	
    while(!std_uart_get_flag(UART1,UART_FLAG_TC)); 

    return (ch);
}
