/************************************************************************************************/
/**
* @file               ciu32f003_std_spi.h
* @author             MCU Ecosystem Development Team
* @brief              SPI STDͷļ
*                     ṩSPIصSTDԼĶ塣
*
*
**************************************************************************************************
* @attention
* Copyright (c) CEC Huada Electronic Design Co.,Ltd. All rights reserved.
*
**************************************************************************************************
*/

/* ͷļظ */
#ifndef CIU32F003_STD_SPI_H
#define CIU32F003_STD_SPI_H

/************************************************************************************************/
/** 
* @addtogroup CIU32F003_STD_Driver
* @{
*/

/**
* @defgroup SPI SPI
* @brief ӿڵSTD 
* @{
*/
/************************************************************************************************/



#ifdef __cplusplus
 extern "C" {
#endif

/*------------------------------------------includes--------------------------------------------*/
#include "ciu32f003_std_common.h"


/*-----------------------------------------type define------------------------------------------*/
/************************************************************************************************/
/**
* @defgroup SPI_Types SPI Types
* @brief  SPIͶ
* @{
*
*/
/************************************************************************************************/

/**
* @brief  SPIʼýṹ嶨
*/
typedef struct
{
    uint32_t mode;                     /**< SPIģʽ
                                                @arg SPI_MODE_SLAVE
                                                @arg SPI_MODE_MASTER                            */

    uint32_t baud_rate_prescaler;      /**< SPIò                                    
                                                @arg  SPI_BAUD_PCLKDIV_2          
                                                @arg  SPI_BAUD_PCLKDIV_4 ...      
                                                @note ʱãӻҪ          */

    uint32_t clk_polarity;             /**< SPIʱӼ                                
                                                @arg SPI_POLARITY_LOW                  
                                                @arg SPI_POLARITY_HIGH                          */

    uint32_t clk_phase;                /**< SPIʱλ                                
                                                @arg SPI_PHASE_1EDGE                   
                                                @arg SPI_PHASE_2EDGE                            */
    
    uint32_t bitorder;                 /**< SPIݴС
                                                @arg SPI_FIRSTBIT_MSB
                                                @arg SPI_FIRSTBIT_LSB                           */
}std_spi_init_t; 


/** 
* @} 
*/


/*--------------------------------------------define--------------------------------------------*/
/************************************************************************************************/
/** 
* @defgroup SPI_Constants SPI Constants
* @brief SPI弰궨
* @{
*/
/************************************************************************************************/
/* SPI ģʽ */
#define SPI_MODE_SLAVE                  (0x00000000U)                      /**< SPIӻģʽ     */
#define SPI_MODE_MASTER                 SPI_CR1_MSTR                       /**< SPIģʽ     */

/* SPI ò */    
#define SPI_BAUD_PCLKDIV_2              SPI_CR1_BR_PCLK_DIV_2              /**< SPIΪfPLCK/2   */
#define SPI_BAUD_PCLKDIV_4              SPI_CR1_BR_PCLK_DIV_4              /**< SPIΪfPLCK/4   */
#define SPI_BAUD_PCLKDIV_8              SPI_CR1_BR_PCLK_DIV_8              /**< SPIΪfPLCK/8   */
#define SPI_BAUD_PCLKDIV_16             SPI_CR1_BR_PCLK_DIV_16             /**< SPIΪfPLCK/16  */
#define SPI_BAUD_PCLKDIV_32             SPI_CR1_BR_PCLK_DIV_32             /**< SPIΪfPLCK/32  */
#define SPI_BAUD_PCLKDIV_64             SPI_CR1_BR_PCLK_DIV_64             /**< SPIΪfPLCK/64  */
#define SPI_BAUD_PCLKDIV_128            SPI_CR1_BR_PCLK_DIV_128            /**< SPIΪfPLCK/128 */

/* SPI ʱӼ */
#define SPI_POLARITY_LOW                (0x00000000U)                      /**< SPIʱӿΪ */
#define SPI_POLARITY_HIGH               SPI_CR1_CPOL                       /**< SPIʱӿΪ */

/* SPI ʱλ */
#define SPI_PHASE_1EDGE                 (0x00000000U)                      /**< SPIݲڵһʱ */
#define SPI_PHASE_2EDGE                 SPI_CR1_CPHA                       /**< SPIݲڵڶʱ */

/* SPI ݴС */
#define SPI_FIRSTBIT_MSB                (0x00000000U)                      /**< SPIշΪλ */
#define SPI_FIRSTBIT_LSB                SPI_CR1_LSBFIRST                   /**< SPIշΪλ */

/* SPI NSS״̬*/
#define SPI_NSS_OUTPUT_LOW              (0x00000000U)                      /**< SPIƬѡź͵ƽ */
#define SPI_NSS_OUTPUT_HIGH             SPI_CR2_NSSO                       /**< SPIƬѡźߵƽ */

/* SPI ж¼ */
#define SPI_INTERRUPT_TXFE              SPI_CR1_TXFEIE                     /**< SPIݼĴΪжʹ */
#define SPI_INTERRUPT_RXFNE             SPI_CR1_RXFNEIE                    /**< SPIݼĴǿжʹ */
#define SPI_INTERRUPT_ERR               SPI_CR1_ERRIE                      /**< SPIжʹ               */

/* SPI Ӳ״̬Ϣ */
#define SPI_FLAG_TXFE                   SPI_ISR_TXFE                       /**< SPIݼĴձ־   */
#define SPI_FLAG_RXFNE                  SPI_ISR_RXFNE                      /**< SPIݼĴǿձ־ */
#define SPI_FLAG_BUSY                   SPI_ISR_BUSY                       /**< SPIߴ״̬־       */
#define SPI_FLAG_OVR                    SPI_ISR_OVR                        /**< SPI־         */
#define SPI_FLAG_MMF                    SPI_ISR_MMF                        /**< SPIģʽͻ־       */

/* SPI ״̬Ϣ */
#define SPI_CLEAR_FLAG_OVR              SPI_ICR_OVRCF                      /**< SPI־     */
#define SPI_CLEAR_FLAG_MMF              SPI_ICR_MMFCF                      /**< SPIģʽͻ־ */

/** 
* @} 
*/


/*-------------------------------------------functions------------------------------------------*/

/************************************************************************************************/
/**
* @defgroup SPI_External_Functions SPI External Functions
* @brief    SPI⺯
* @{
*
*/
/************************************************************************************************/
/** 
* @brief  ʹSPI
* @retval 
*/
__STATIC_INLINE void std_spi_enable(void)
{
    SPI1->CR1 |= SPI_CR1_SPE;
}


/** 
* @brief  ֹSPI
* @retval 
*/
__STATIC_INLINE void std_spi_disable(void)
{
    SPI1->CR1 &= (~SPI_CR1_SPE);
}


/** 
* @brief  SPIģʽ
* @param  mode SPIģʽ
*             @arg SPI_MODE_SLAVE
*             @arg SPI_MODE_MASTER   
* @retval 
*/
__STATIC_INLINE void std_spi_set_mode(uint32_t mode)
{
    MODIFY_REG(SPI1->CR1, SPI_CR1_MSTR, mode);
}


/** 
* @brief  ȡSPIģʽ
* @retval uint32_t SPIģʽ
*             @arg SPI_MODE_SLAVE
*             @arg SPI_MODE_MASTER  
*/
__STATIC_INLINE uint32_t std_spi_get_mode(void)
{
    return (SPI1->CR1 & SPI_CR1_MSTR);
}


/** 
* @brief  SPI
* @param  baud_rate SPI
*             @arg  SPI_BAUD_PCLKDIV_2      
*             @arg  SPI_BAUD_PCLKDIV_4
*             @arg  ...  
*             @arg  SPI_BAUD_PCLKDIV_128
* @note  ʱãӻҪ
* @retval 
*/
__STATIC_INLINE void std_spi_set_baud_rate(uint32_t baud_rate)
{
    MODIFY_REG(SPI1->CR1, SPI_CR1_BR, baud_rate);
}


/** 
* @brief  ȡSPI
* @retval uint32_t  SPI
*             @arg  SPI_BAUD_PCLKDIV_2
*             @arg  SPI_BAUD_PCLKDIV_4
*             @arg  ...  
*             @arg  SPI_BAUD_PCLKDIV_128
*/
__STATIC_INLINE uint32_t std_spi_get_baud_rate(void)
{
    return (SPI1->CR1 & SPI_CR1_BR);
}


/** 
* @brief  SPIʱӼ
* @param  polarity SPIʱӼ
*             @arg SPI_POLARITY_LOW
*             @arg SPI_POLARITY_HIGH
* @retval 
*/
__STATIC_INLINE void std_spi_set_polarity(uint32_t polarity)
{
    MODIFY_REG(SPI1->CR1, SPI_CR1_CPOL, polarity);
}


/**
* @brief  SPIʱλ 
* @param  phase SPIʱλ
*             @arg SPI_PHASE_1EDGE 
*             @arg SPI_PHASE_2EDGE 
* @retval 
*/
__STATIC_INLINE void std_spi_set_phase(uint32_t phase)
{
    MODIFY_REG(SPI1->CR1, SPI_CR1_CPHA, phase);
}


/**
* @brief  SPIݴС
* @param  first_bit SPIݴС
*             @arg SPI_FIRSTBIT_MSB 
*             @arg SPI_FIRSTBIT_LSB 
* @note   ڽֹSPISPEΪ0ʱſɶԴλִд
* @retval 
*/
__STATIC_INLINE void std_spi_set_first_bit(uint32_t first_bit)
{
    MODIFY_REG(SPI1->CR1, SPI_CR1_LSBFIRST, first_bit);
}


/**
* @brief  ʹNSSƬѡ
* @note   ڴӻģʽЧ
* @retval 
*/
__STATIC_INLINE void std_spi_nss_soft_chip_select_enable(void)
{
    SPI1->CR1 |= SPI_CR1_SSM;
}


/**
* @brief  ֹNSSƬѡ
* @note   ڴӻģʽЧ
* @retval 
*/
__STATIC_INLINE void std_spi_nss_soft_chip_select_disable(void)
{
    SPI1->CR1 &= (~SPI_CR1_SSM);
}


/**
* @brief  ʹSPI NSS
* @note   ģʽЧ
* @retval 
*/
__STATIC_INLINE void std_spi_nss_output_enable(void)
{
    SPI1->CR1 |= SPI_CR1_NSSOE;
}


/**
* @brief  ֹSPI NSS
* @retval 
*/
__STATIC_INLINE void std_spi_nss_output_disable(void)
{
    SPI1->CR1 &= (~SPI_CR1_NSSOE);
}


/**
* @brief  ʹSPIж
* @param  spi_interrupt SPIжϢ
*             @arg SPI_INTERRUPT_TXFE     
*             @arg SPI_INTERRUPT_RXFNE    
*             @arg SPI_INTERRUPT_ERR      
* @retval 
*/
__STATIC_INLINE void std_spi_interrupt_enable(uint32_t spi_interrupt)
{
    SPI1->CR1 |= spi_interrupt;
}


/**
* @brief  ֹSPIж
* @param  spi_interrupt SPIжϢ
*             @arg SPI_INTERRUPT_TXFE     
*             @arg SPI_INTERRUPT_RXFNE    
*             @arg SPI_INTERRUPT_ERR      
* @retval 
*/
__STATIC_INLINE void std_spi_interrupt_disable(uint32_t spi_interrupt)
{
    SPI1->CR1 &= (~spi_interrupt);
}


/**
* @brief  ȡSPIжʹ״̬
* @param  spi_interrupt SPIжϢ
*             @arg SPI_INTERRUPT_TXFE     
*             @arg SPI_INTERRUPT_RXFNE    
*             @arg SPI_INTERRUPT_ERR      
* @retval uint32_t жʹ״̬
*             @arg 0: ʹ
*             @arg 0: ֹ
*/
__STATIC_INLINE uint32_t std_spi_get_interrupt_enable(uint32_t spi_interrupt)
{
    return (SPI1->CR1 & (spi_interrupt));
}


/**
* @brief  SPI NSSŵƽ
* @param  nss_output NSSƽ
*             @arg SPI_NSS_OUTPUT_LOW   
*             @arg SPI_NSS_OUTPUT_HIGH  
* @note   ģʽSPEʹܵЧ
* @retval 
*/
__STATIC_INLINE void std_spi_set_nss_output(uint32_t nss_output)
{
    SPI1->CR2 = nss_output;
}


/**
* @brief  ȡSPI״̬־λ
* @param  flag SPI״̬־λ
*             @arg SPI_FLAG_TXFE 
*             @arg SPI_FLAG_RXFNE
*             @arg SPI_FLAG_BUSY 
*             @arg SPI_FLAG_OVR  
*             @arg SPI_FLAG_MMF  
* @retval uint32_t SPI־λ״̬
*             @arg 0: ־λλ
*             @arg 0:   ־λ
*/
__STATIC_INLINE uint32_t std_spi_get_flag(uint32_t flag)
{
    return (SPI1->ISR & (flag));
}


/**
* @brief  SPI־
* @param  flag SPI־
*             @arg SPI_CLEAR_FLAG_OVR
*             @arg SPI_CLEAR_FLAG_MMF
* @retval 
*/
__STATIC_INLINE void std_spi_clear_flag(uint32_t flag)
{
    SPI1->ICR = (flag);
}


/**
* @brief  SPI
* @retval uint8_t: ضȡSPIݼĴȡ
*/
__STATIC_INLINE uint8_t std_spi_read_data(void)
{
    return (SPI1->DR);
}

/**
* @brief  SPIд
* @param  send_data: дSPIݼĴ
* @retval 
*/
__STATIC_INLINE void std_spi_write_data(uint8_t send_data)
{
    SPI1->DR = send_data;
}


void std_spi_init(std_spi_init_t *spi_init_param);
void std_spi_deinit(void);
void std_spi_struct_init(std_spi_init_t *spi_init_struct);


/** 
* @} 
*/

#ifdef __cplusplus
}
#endif

/** 
* @} 
*/

/** 
* @} 
*/

#endif /* CIU32F003_STD_SPI_H */
