/************************************************************************************************/
/**
* @file               ciu32f003_std_adc.h
* @author             MCU Ecosystem Development Team
* @brief              ADC STDͷļ
*                     ṩADCصSTDԼĶ塣                         
*
*
**************************************************************************************************
* @attention
* Copyright (c) CEC Huada Electronic Design Co.,Ltd. All rights reserved.
*
**************************************************************************************************
*/

/* ͷļظ */
#ifndef CIU32F003_STD_ADC_H
#define CIU32F003_STD_ADC_H

/************************************************************************************************/
/** 
* @addtogroup CIU32F003_STD_Driver
* @{
*/

/**
* @defgroup ADC ADC
* @brief ģתSTD
* @{
*/
/************************************************************************************************/



#ifdef __cplusplus
 extern "C" {
#endif

/*------------------------------------------includes--------------------------------------------*/
#include "ciu32f003_std_common.h"

/*--------------------------------------------define--------------------------------------------*/
/************************************************************************************************/
/**
* @defgroup ADC_Constants  ADC Constants
* @brief    ADC弰궨
* @{
*
*/
/************************************************************************************************/
/* ADC_CKʱӷƵϵ */
#define ADC_CK_DIV1                          ADC_CFG2_PRESC_DIV1                            /**< ADC_CKʱ: Ƶ */
#define ADC_CK_DIV2                          ADC_CFG2_PRESC_DIV2                            /**< ADC_CKʱ: 2Ƶ  */
#define ADC_CK_DIV3                          ADC_CFG2_PRESC_DIV3                            /**< ADC_CKʱ: 3Ƶ  */
#define ADC_CK_DIV4                          ADC_CFG2_PRESC_DIV4                            /**< ADC_CKʱ: 4Ƶ  */
#define ADC_CK_DIV8                          ADC_CFG2_PRESC_DIV8                            /**< ADC_CKʱ: 8Ƶ  */
#define ADC_CK_DIV16                         ADC_CFG2_PRESC_DIV16                           /**< ADC_CKʱ: 16Ƶ */
#define ADC_CK_DIV32                         ADC_CFG2_PRESC_DIV32                           /**< ADC_CKʱ: 32Ƶ */
#define ADC_CK_DIV64                         ADC_CFG2_PRESC_DIV64                           /**< ADC_CKʱ: 64Ƶ */

/* ADCתģʽ */
#define ADC_SINGLE_CONVER_MODE               ADC_CFG1_CONV_MOD_SINGLE                       /**< ADCɨת */
#define ADC_CONTINUOUS_CONVER_MODE           ADC_CFG1_CONV_MOD_CONTINUOUS                   /**< ADCѭɨת */
#define ADC_DISCONTINUOUS_CONVER_MODE        ADC_CFG1_CONV_MOD_DISCONTINUOUS                /**< ADCѭת */

/* ADCͨɨ跽 */
#define ADC_SCAN_DIR_FORWARD                 (0x00000000U)                                  /**< ADCתͨ: ɨ */
#define ADC_SCAN_DIR_BACKWARD                ADC_CFG1_SDIR                                  /**< ADCתͨ: ɨ */

/* ADCתģʽ:  */
#define ADC_TRIG_SW                          ADC_CFG1_TRIGEN_SW                             /**< ʽ                 */
#define ADC_TRIG_HW_EDGE_RISING              ADC_CFG1_TRIGEN_HW_EDGE_RISING                 /**< ⲿӲʹ: ش */
#define ADC_TRIG_HW_EDGE_FALLING             ADC_CFG1_TRIGEN_HW_EDGE_FALLING                /**< ⲿӲʹ: ½ش */
#define ADC_TRIG_HW_EDGE_BOTH                ADC_CFG1_TRIGEN_HW_EDGE_BOTH                   /**< ⲿӲʹ: ˫ش   */

/*  ADCתԴ */
#define ADC_EXTRIG_TIM1_TRGO                 ADC_CFG1_TRIG_TIM1_TRGO                        /**< ADCԴ: TIM1 TRGO      */
#define ADC_EXTRIG_TIM1_OC4_ADC              ADC_CFG1_TRIG_TIM1_OC4_ADC                     /**< ADCԴ: TIM1 OC4       */
#define ADC_EXTRIG_TIM3_TRGO                 ADC_CFG1_TRIG_TIM3_TRGO                        /**< ADCԴ: TIM3 TRGO      */
#define ADC_EXTRIG_EXTI7                     ADC_CFG1_TRIG_EXTI7                            /**< ADCԴ: ⲿжEXTI_7 */

/* ADCתADC_DRĴݴ洢ʽ */
#define ADC_OVRN_MODE_PRESERVED              (0x00000000U)                                  /**< ADC_DRĴԭ */
#define ADC_OVRN_MODE_OVERWRITTEN            ADC_CFG1_OVRN_MOD                              /**< ADC_DRĴ */

/* ADCʱ */
#define ADC_SAMPTIME_3CYCLES                 ADC_SAMPT_SAMPT_3CYCLES                        /**< ʱΪ3ʱ    */
#define ADC_SAMPTIME_7CYCLES                 ADC_SAMPT_SAMPT_7CYCLES                        /**< ʱΪ7ʱ    */
#define ADC_SAMPTIME_12CYCLES                ADC_SAMPT_SAMPT_12CYCLES                       /**< ʱΪ12ʱ   */
#define ADC_SAMPTIME_19CYCLES                ADC_SAMPT_SAMPT_19CYCLES                       /**< ʱΪ19ʱ   */
#define ADC_SAMPTIME_39CYCLES                ADC_SAMPT_SAMPT_39CYCLES                       /**< ʱΪ39ʱ   */
#define ADC_SAMPTIME_79CYCLES                ADC_SAMPT_SAMPT_79CYCLES                       /**< ʱΪ79ʱ   */
#define ADC_SAMPTIME_119CYCLES               ADC_SAMPT_SAMPT_119CYCLES                      /**< ʱΪ119ʱ  */
#define ADC_SAMPTIME_159CYCLES               ADC_SAMPT_SAMPT_159CYCLES                      /**< ʱΪ159ʱ  */
#define ADC_SAMPTIME_239CYCLES               ADC_SAMPT_SAMPT_239CYCLES                      /**< ʱΪ239ʱ  */
#define ADC_SAMPTIME_319CYCLES               ADC_SAMPT_SAMPT_319CYCLES                      /**< ʱΪ319ʱ  */
#define ADC_SAMPTIME_479CYCLES               ADC_SAMPT_SAMPT_479CYCLES                      /**< ʱΪ479ʱ  */
#define ADC_SAMPTIME_639CYCLES               ADC_SAMPT_SAMPT_639CYCLES                      /**< ʱΪ639ʱ  */
#define ADC_SAMPTIME_959CYCLES               ADC_SAMPT_SAMPT_959CYCLES                      /**< ʱΪ959ʱ  */
#define ADC_SAMPTIME_1279CYCLES              ADC_SAMPT_SAMPT_1279CYCLES                     /**< ʱΪ1279ʱ */
#define ADC_SAMPTIME_1919CYCLES              ADC_SAMPT_SAMPT_1919CYCLES                     /**< ʱΪ1919ʱ */

/* ADCתͨ */
#define ADC_CHANNEL_NONE                     (0x00000000U)                                  /**< ADC תͨ     */ 
#define ADC_CHANNEL_0                        ADC_CHCFG_CHN0                                 /**< ADC תͨIN0      */
#define ADC_CHANNEL_1                        ADC_CHCFG_CHN1                                 /**< ADC תͨIN1      */
#define ADC_CHANNEL_2                        ADC_CHCFG_CHN2                                 /**< ADC תͨIN2      */
#define ADC_CHANNEL_3                        ADC_CHCFG_CHN3                                 /**< ADC תͨIN3      */
#define ADC_CHANNEL_4                        ADC_CHCFG_CHN4                                 /**< ADC תͨIN4      */
#define ADC_CHANNEL_5                        ADC_CHCFG_CHN5                                 /**< ADC תͨIN5      */
#define ADC_CHANNEL_6                        ADC_CHCFG_CHN6                                 /**< ADC תͨIN6      */
#define ADC_CHANNEL_7                        ADC_CHCFG_CHN7                                 /**< ADC תͨIN7      */
#define ADC_CHANNEL_8                        ADC_CHCFG_CHN8                                 /**< ADC תͨIN8      */
#define ADC_CHANNEL_VBGR                     ADC_CHCFG_CHN8                                 /**< ADC ڲתͨVBGR */
#define ADC_CHANNEL_ALL                      ADC_CHCFG_CHN                                  /**< ADC ȫתͨ     */ 

/* ADCģ⿴Źͨ */
#define ADC_AWDG_CHANNEL_NONE                (0x00000000U)                                  /**< ADC ģ⿴Źͨ */ 
#define ADC_AWDG_CHANNEL_0                   ADC_AWDGCR_CHN0                                /**< ADC ģ⿴Źͨ0    */ 
#define ADC_AWDG_CHANNEL_1                   ADC_AWDGCR_CHN1                                /**< ADC ģ⿴Źͨ1    */ 
#define ADC_AWDG_CHANNEL_2                   ADC_AWDGCR_CHN2                                /**< ADC ģ⿴Źͨ2    */ 
#define ADC_AWDG_CHANNEL_3                   ADC_AWDGCR_CHN3                                /**< ADC ģ⿴Źͨ3    */ 
#define ADC_AWDG_CHANNEL_4                   ADC_AWDGCR_CHN4                                /**< ADC ģ⿴Źͨ4    */ 
#define ADC_AWDG_CHANNEL_5                   ADC_AWDGCR_CHN5                                /**< ADC ģ⿴Źͨ5    */ 
#define ADC_AWDG_CHANNEL_6                   ADC_AWDGCR_CHN6                                /**< ADC ģ⿴Źͨ6    */ 
#define ADC_AWDG_CHANNEL_7                   ADC_AWDGCR_CHN7                                /**< ADC ģ⿴Źͨ7    */ 
#define ADC_AWDG_CHANNEL_8                   ADC_AWDGCR_CHN8                                /**< ADC ģ⿴Źͨ8    */ 
#define ADC_AWDG_CHANNEL_VBGR                ADC_AWDGCR_CHN8                                /**< ADC ģ⿴ŹͨVBGR */ 
#define ADC_AWDG_CHANNEL_ALL                 ADC_AWDGCR_CHN                                 /**< ADC ȫתͨ           */ 

/* ADCڲͨʹ */
#define ADC_INTERNAL_CHANNEL_VBGREN          ADC_CFG2_VBGREN                                /**< ADC ڲͨVBGRʹ */ 

/* ADCжԴ壺IERжϼĴ */
#define ADC_INTERRUPT_EOSAMP                 ADC_IER_EOSAMPIE                               /**< ADCж           */
#define ADC_INTERRUPT_EOC                    ADC_IER_EOCIE                                  /**< ADCͨתж     */
#define ADC_INTERRUPT_EOS                    ADC_IER_EOSIE                                  /**< ADCͨתж   */
#define ADC_INTERRUPT_OVRN                   ADC_IER_OVRNIE                                 /**< ADCж           */
#define ADC_INTERRUPT_AWDG                   ADC_IER_AWDGIE                                 /**< ADCģ⿴Źѹж */
#define ADC_INTERRUPT_EOCAL                  ADC_IER_EOCALIE                                /**< ADCУ׼ж           */

/* ADC״̬壺ISR״̬Ĵ */
#define ADC_FLAG_EOSAMP                      ADC_ISR_EOSAMP                                 /**< ADC״̬           */
#define ADC_FLAG_EOC                         ADC_ISR_EOC                                    /**< ADCͨת״̬     */
#define ADC_FLAG_EOS                         ADC_ISR_EOS                                    /**< ADCͨת״̬   */
#define ADC_FLAG_OVRN                        ADC_ISR_OVRN                                   /**< ADC״̬           */
#define ADC_FLAG_AWDG                        ADC_ISR_AWDG                                   /**< ADCģ⿴Źصѹ״̬ */
#define ADC_FLAG_EOCAL                       ADC_ISR_EOCAL                                  /**< ADCУ׼״̬               */
#define ADC_FLAG_ALL                         (ADC_ISR_EOSAMP | ADC_ISR_EOC | ADC_ISR_EOS \
                                              | ADC_ISR_OVRN | ADC_ISR_AWDG | ADC_ISR_EOCAL)/**< ADCȫ״̬               */
                                              
/* ADCģʽ */
#define ADC_MODE_INTERVAL                    (0x00000000U)                                  /**< ADCЪģʽ           */
#define ADC_MODE_NORMAL                      ADC_CFG3_MODE                                  /**< ADCģʽ           */
                                              

/* VBGRУ׼ */  
#define VBGR_CAL_ADDR                        ((uint16_t *)(BGR_CAL))                        /**< VBGRУ׼洢ַ       */
#define VBGR_CAL_VREF                        (3300U)                                        /**< VBGRУ׼òοѹ3.3V */

/* ȴڲͨVBGRȶȶʱֵοCIU32F003ֲ(tADC_BUF) */
#define ADC_VBGR_CHANNEL_DELAY               (22U)                                          /**< VBGRͨȶʱ䣺22us */

/* ADCʹȶʱ䣬ȴ1usȶʱ */
#define ADC_EN_DELAY                         (1U)                                           /**< ADCʹȶʱ */

/* ADCֵ */
#define ADC_CONVER_SCALE                     (4095U)                                        /**< ADCֵADCѹת */

/** 
* @} 
*/

/*-------------------------------------------functions------------------------------------------*/

/************************************************************************************************/
/**
* @defgroup ADC_External_Functions ADC External Functions
* @brief    ADC⺯
* @{
*
*/
/************************************************************************************************/
/** 
* @brief  ʹADC
* @retval 
*/
__STATIC_INLINE void std_adc_enable(void)
{
    ADC->CR = (ADC_CR_ADEN);
}

/** 
* @brief  ֹADC
* @retval 
*/
__STATIC_INLINE void std_adc_disable(void)
{
    ADC->CR = (ADC_CR_ADDIS);
}

/** 
* @brief  ȡADCʹλ״̬
* @retval uint32_t ߼ʽжϽ
*             @arg 0 ʾADCʹ״̬
*             @arg 0ʾADCڽֹ״̬
*/
__STATIC_INLINE uint32_t std_adc_get_enable_status(void)
{
    return ((ADC->CR & ADC_CR_ADEN));
}

/** 
* @brief  ʹADCУ׼
* @note   ADEN=1ADCȶSTART=0STOP=0ADDIS=0ͨCALENλ1
* @retval 
*/
__STATIC_INLINE void std_adc_calibration_enable(void)
{
    ADC->CR = (ADC_CR_CALEN);
}

/** 
* @brief  ADCת 
* @retval 
*/
__STATIC_INLINE void std_adc_start_conversion(void)
{
    ADC->CR = (ADC_CR_START);
}

/** 
* @brief  ȡADC״̬
* @retval uint32_t ADC״̬
*             @arg 0 ʾADCڹ״̬
*             @arg 0ʾADCδ״̬
*/
__STATIC_INLINE uint32_t std_adc_get_conversion_status(void)
{
    return ((ADC->CR & ADC_CR_START));
}

/** 
* @brief  ADCֹͣת
* @note   START=1ADDIS=0ʱSTOPλ1Ч
* @retval 
*/
__STATIC_INLINE void std_adc_stop_conversion(void)
{
    ADC->CR = (ADC_CR_STOP);
}

/** 
* @brief  ADCжʹ
* @param  interrupt ADCжԴ   
*             @arg ADC_INTERRUPT_EOSAMP
*             @arg ADC_INTERRUPT_EOC
*             @arg ADC_INTERRUPT_EOS
*             @arg ADC_INTERRUPT_OVRN
*             @arg ADC_INTERRUPT_AWDG
*             @arg ADC_INTERRUPT_EOCAL
* @retval 
*/
__STATIC_INLINE void std_adc_interrupt_enable(uint32_t interrupt)
{
    ADC->IER |= (interrupt);
}

/** 
* @brief  ADCжϽֹ
* @param  interrupt ADCжԴ   
*             @arg ADC_INTERRUPT_EOSAMP
*             @arg ADC_INTERRUPT_EOC
*             @arg ADC_INTERRUPT_EOS
*             @arg ADC_INTERRUPT_OVRN
*             @arg ADC_INTERRUPT_AWDG
*             @arg ADC_INTERRUPT_EOCAL
* @retval 
*/
__STATIC_INLINE void std_adc_interrupt_disable(uint32_t interrupt)
{
    ADC->IER &= (~interrupt);
}

/** 
* @brief  ȡADCжԴʹ״̬
* @param  interrupt ADCжԴϢ 
*             @arg ADC_INTERRUPT_EOSAMP
*             @arg ADC_INTERRUPT_EOC
*             @arg ADC_INTERRUPT_EOS
*             @arg ADC_INTERRUPT_OVRN
*             @arg ADC_INTERRUPT_AWDG
*             @arg ADC_INTERRUPT_EOCAL
* @retval uint32_t жԴʹ״̬
*             @arg 0 ʾָжʹ
*             @arg 0ʾָжδʹ
*/

__STATIC_INLINE uint32_t std_adc_get_interrupt_enable(uint32_t interrupt)
{
    return((ADC->IER & (interrupt)));
}

/** 
* @brief  ȡADC־״̬
* @param  flag ȡADC־
*             @arg ADC_FLAG_EOSAMP
*             @arg ADC_FLAG_EOC
*             @arg ADC_FLAG_EOS
*             @arg ADC_FLAG_OVRN
*             @arg ADC_FLAG_AWDG
*             @arg ADC_FLAG_EOCAL
* @retval uint32_t ر־λ״̬
*             @arg 0ʾǰ־Ϊλ״̬
*             @arg 0ʾǰ־Ϊ״̬
*/
__STATIC_INLINE uint32_t std_adc_get_flag(uint32_t flag)
{
    return((ADC->ISR & (flag)));
}

/** 
* @brief  ADC־
* @param  flag ADC־
*             @arg ADC_FLAG_EOSAMP
*             @arg ADC_FLAG_EOC
*             @arg ADC_FLAG_EOS
*             @arg ADC_FLAG_OVRN
*             @arg ADC_FLAG_AWDG
*             @arg ADC_FLAG_EOCAL
* @retval 
*/
__STATIC_INLINE void std_adc_clear_flag(uint32_t flag)
{
    ADC->ISR = (flag);
}

/** 
* @brief  ADCתģʽ
* @param  conversion_mode תģʽѡ
*             @arg ADC_SINGLE_CONVER_MODE
*             @arg ADC_CONTINUOUS_CONVER_MODE
*             @arg ADC_DISCONTINUOUS_CONVER_MODE
* @note   START=0ʱԴλִдЧ
* @retval 
*/
__STATIC_INLINE void std_adc_conversion_mode_config(uint32_t conversion_mode)
{
    MODIFY_REG(ADC->CFG1, ADC_CFG1_CONV_MOD, conversion_mode);
}

/** 
* @brief  ADCͨʹ
* @param  channel ͨѡ
*             @arg ADC_CHANNEL_0
*             @arg ADC_CHANNEL_1
*             @arg ...
*             @arg ADC_CHANNEL_ALL
* @retval 
*/
__STATIC_INLINE void std_adc_fix_sequence_channel_enable(uint32_t channel)
{
    ADC->CHCFG |= (channel);
}

/** 
* @brief  ADCֹͨ
* @param  channel ֹͨѡ
*             @arg ADC_CHANNEL_0
*             @arg ADC_CHANNEL_1
*             @arg ...
*             @arg ADC_CHANNEL_ALL
* @retval 
*/
__STATIC_INLINE void std_adc_fix_sequence_channel_disable(uint32_t channel)
{
    ADC->CHCFG &= (~channel);
}

/** 
* @brief  ADCԴΪ
* @retval 
*/
__STATIC_INLINE void std_adc_trig_sw(void)
{
    MODIFY_REG(ADC->CFG1, ADC_CFG1_TRIGEN, ADC_TRIG_SW);
}

/** 
* @brief  ADCźԴͼ
* @param  trig_edge ѡ
*             @arg ADC_TRIG_SW(ʽ)
*             @arg ADC_TRIG_HW_EDGE_RISING
*             @arg ADC_TRIG_HW_EDGE_FALLING
*             @arg ADC_TRIG_HW_EDGE_BOTH
* @param  trig_source ⲿԴѡ
*             @arg ADC_EXTRIG_TIM1_TRGO
*             @arg ADC_EXTRIG_TIM1_OC4_ADC
*             @arg ADC_EXTRIG_TIM3_TRGO
*             @arg ADC_EXTRIG_EXTI7
* @note   ѡADC_TRIG_SW(ʽ)ʱԴ塣
* @retval 
*/
__STATIC_INLINE void std_adc_trig_config(uint32_t trig_edge,uint32_t trig_source)
{
    MODIFY_REG(ADC->CFG1, (ADC_CFG1_TRIGEN | ADC_CFG1_TRIG_SEL), (trig_edge | trig_source));
}

/** 
* @brief  ADCʱ1
* @param  sample_time ʱѡ
*           @arg ADC_SAMPTIME_3CYCLES
*           @arg ...
*           @arg ADC_SAMPTIME_1919CYCLES 
* @retval 
*/
__STATIC_INLINE void std_adc_sampt_time_config(uint32_t sample_time)
{
    MODIFY_REG(ADC->SAMPT, ADC_SAMPT_SAMPT, sample_time);
}

/** 
* @brief  ADC_CKʱӷƵ
* @param  presc ADC_CKʱԴƵϵ
*             @arg  ADC_CK_DIV1 ADC_CK Ƶ
*             @arg  ADC_CK_DIV2 ADC_CK 2Ƶ
*             @arg  ADC_CK_DIV3 ADC_CK 3Ƶ
*             @arg ...
*             @arg  ADC_CK_DIV64ADC_CK 64Ƶ
* @retval 
*/
__STATIC_INLINE void std_adc_clock_config(uint32_t presc)
{
    MODIFY_REG(ADC->CFG2, ADC_CFG2_PRESC, presc);
}

/** 
* @brief  ADCУ׼ϵ
* @param  calibration_factor ΧΪ0x00~0x3F
* @retval 
*/
__STATIC_INLINE void std_adc_calibration_factor_config(uint32_t calibration_factor)
{
    ADC->CALFACT = calibration_factor;
}

/** 
* @brief  ȡADCУ׼ϵ
* @retval uint16_t ADCУ׼ϵ
*/
__STATIC_INLINE uint16_t std_adc_get_calibration_factor(void)
{
    return ((uint16_t)(ADC->CALFACT));
}

/** 
* @brief  ʹADCȴģʽ
* @note   ڱδʱȡת
* @retval 
*/
__STATIC_INLINE void std_adc_wait_mode_enable(void)
{
    ADC->CFG1 |= (ADC_CFG1_WAIT_MOD);
}

/** 
* @brief  ֹADCȴģʽ
* @retval 
*/
__STATIC_INLINE void std_adc_wait_mode_disable(void)
{
    ADC->CFG1 &= (~ADC_CFG1_WAIT_MOD);
}

/** 
* @brief  ͨɨ跽
* @param  dir ADCͨɨ跽
*             @arg ADC_SCAN_DIR_FORWARD
*             @arg ADC_SCAN_DIR_BACKWARD
* @retval 
*/
__STATIC_INLINE void std_adc_scan_direction_config(uint32_t dir)
{
    MODIFY_REG(ADC->CFG1, ADC_CFG1_SDIR, dir);
}

/** 
* @brief  ADCʽ
* @param  ovrn_mode ADCʽ
*             @arg ADC_OVRN_MODE_PRESERVED
*             @arg ADC_OVRN_MODE_OVERWRITTEN
* @retval 
*/
__STATIC_INLINE void std_adc_ovrn_mode_config(uint32_t ovrn_mode)
{
    MODIFY_REG(ADC->CFG1, ADC_CFG1_OVRN_MOD, ovrn_mode);
}

/** 
* @brief  ADCڲͨVBGRʹ
* @retval 
*/
__STATIC_INLINE void std_adc_internal_channel_vbgr_enable(void)
{
    ADC->CFG2 |= (ADC_INTERNAL_CHANNEL_VBGREN);
}

/** 
* @brief  ADCڲͨVBGRֹ
* @retval 
*/
__STATIC_INLINE void std_adc_internal_channel_vbgr_disable(void)
{
    ADC->CFG2 &= (~ADC_INTERNAL_CHANNEL_VBGREN);
}

/** 
* @brief  ѡADCģ⿴Źͨ
* @param  channel ADCŹͨѡ
*             @arg ADC_AWDG_CHANNEL_NONE
*             @arg ADC_AWDG_CHANNEL_0
*             @arg ...
*             @arg ADC_AWDG_CHANNEL_ALL
* @retval 
*/
__STATIC_INLINE void std_adc_analog_watchdog_monit_channel(uint32_t channel)
{
    MODIFY_REG(ADC->AWDGCR, ADC_AWDGCR_CHN, channel);
}

/** 
* @brief  ÿŹͨѹֵ
* @param  high_threshold ֵѡΧΪ 0x000~0xFFF
* @param  low_threshold  ֵѡΧΪ 0x000~0xFFF
* @retval 
*/
__STATIC_INLINE void std_adc_analog_watchdog_thresholds_config(uint32_t high_threshold, uint32_t low_threshold)
{
    MODIFY_REG(ADC->AWDGTR, (ADC_AWDGTR_AWDG_LT | ADC_AWDGTR_AWDG_HT), (high_threshold << ADC_AWDGTR_AWDG_HT_POS) | (low_threshold));
}

/** 
* @brief  ȡADCֵ
* @retval uint16_t ADCתֵ
*/
__STATIC_INLINE uint16_t std_adc_get_conversion_value(void)
{
    return ((uint16_t)(ADC->DR));
}

/** 
* @brief  ȡУ׼Ĳοѹֵ
* @param  vbgr_sample_data ADCɼBGRתֵ
* @retval uint32_t У׼Ĳοѹֵ
*/
__STATIC_INLINE uint32_t std_adc_calc_vref_voltage(uint16_t vbgr_sample_data)
{
    return ((VBGR_CAL_VREF * (*VBGR_CAL_ADDR))/vbgr_sample_data);
}

/** 
* @brief  ADCģʽ
* @param  mode_sel ADCģʽ
*             @arg ADC_MODE_INTERVAL
*             @arg ADC_MODE_NORMAL
* @retval 
*/
__STATIC_INLINE void std_adc_mode_config(uint32_t mode_sel)
{
    MODIFY_REG(ADC->CFG3, ADC_CFG3_MODE_MASK, mode_sel);
}

/* ADCȥʼ */
void std_adc_deinit(void);

/**
* @}
*/

#ifdef __cplusplus
}
#endif

/**
* @}
*/

/**
* @}
*/

#endif /* CIU32F003_STD_ADC_H */
