#include "BL210x_uart.h"

/****************************************************************************************************************************************** 
* : UART_Init()
* ˵:	ڳʼں    ݳ   Уλ   ֹͣλ   жʹ
*     : UART_TypeDef * UARTx     UART0   UART1   UART2	   
*			UART_InitTypeDef * UART_InitStruct
*     : 
* ע: 
******************************************************************************************************************************************/
void UART_Init(UART_TypeDef * UARTx, UART_InitTypeDef * UART_InitStruct)	
{
	uint32_t Baudrate_Set = 0;
	switch((uint32_t)UARTx)
	{
		case ((uint32_t)UART0):
			SYS->CLKEN |= 0x01 << SYS_CLKEN_UART0_POS;        //򿪴0ʱ
			break;

#ifdef IC_BL2101		
		case ((uint32_t)UART1):
			SYS->CLKEN |= 0x01 << SYS_CLKEN_UART1_POS;        //򿪴1ʱ
			break;
		
		case ((uint32_t)UART2):
			SYS->CLKEN |= 0x01 << SYS_CLKEN_UART2_POS;        //򿪴2ʱ
			break;
#endif
	}
	
	UARTx->CTRL |= (0x01 << UART_CTRL_BAUDEN_POS);            //λ              
	
	if(((SystemCoreClock/16)%UART_InitStruct->Baudrate)*1.0/UART_InitStruct->Baudrate > 0.5)
	{
		Baudrate_Set = (SystemCoreClock/16/UART_InitStruct->Baudrate) + 1;
	}
	else
	{
		Baudrate_Set = (SystemCoreClock/16/UART_InitStruct->Baudrate);
	}
	
	UARTx->DHL = Baudrate_Set>>8;      //ò
	UARTx->DLL = Baudrate_Set&0xFF;

	//UARTx->DHL = (SystemCoreClock/16/UART_InitStruct->Baudrate)>>8;      //ò
	//UARTx->DLL = (SystemCoreClock/16/UART_InitStruct->Baudrate)&0xFF;
	
	UARTx->CTRL &= ~(0x01 << UART_CTRL_BAUDEN_POS);           //رղλ
	
	UARTx->CTRL &= ~(UART_CTRL_DATALEN_MSK | UART_CTRL_STOP2BIT_MSK | UART_CTRL_PARITY_MSK);
	
	UARTx->CTRL |= (UART_InitStruct->DataBits << UART_CTRL_DATALEN_POS) |     //ݳ
				   (UART_InitStruct->StopBits << UART_CTRL_STOP2BIT_POS)|     //ֹͣλ
				   (UART_InitStruct->Parity   << UART_CTRL_PARITY_POS);       //Уλ
	
	UARTx->IE &= ~(UART_IE_RXIEN_POS);
	
	UARTx->IE |= UART_InitStruct->RXIEn << UART_IE_RXIEN_POS;                  //ýЧж
	
	switch((uint32_t)UARTx)         
	{
		case ((uint32_t)UART0):		
			if(UART_InitStruct->RXIEn)
			{
				NVIC_EnableIRQ(UART0_IRQn);         //ʹܴ0ж   
			}
			else
			{
				NVIC_DisableIRQ(UART0_IRQn);        //ܴ0ж  
			}
			break;

#ifdef IC_BL2101			
		case ((uint32_t)UART1):		
			if(UART_InitStruct->RXIEn)
			{
				NVIC_EnableIRQ(UART1_IRQn);         //ʹܴ1ж
			}
			else
			{
				NVIC_DisableIRQ(UART1_IRQn);        //ܴ0ж  
			}
			break;
			
		case ((uint32_t)UART2):		
			if(UART_InitStruct->RXIEn)
			{
				NVIC_EnableIRQ(UART2_IRQn);         //ʹܴ2ж
			}
			else
			{
				NVIC_DisableIRQ(UART2_IRQn);        //ܴ2ж  
			}
			break;
#endif
	}
}

/****************************************************************************************************************************************** 
* : UART_SendData()
* ˵:	ڷͺ   
*     : UART_TypeDef * UARTx     UART0   UART1   UART2	   
*			uint8_t data    ͵
*     : 
* ע: 
******************************************************************************************************************************************/
void UART_SendData(UART_TypeDef * UARTx, uint8_t data)
{
	UARTx->SDR = data;                              //
	while((UARTx->LSR & UART_LSR_THRE_MSK) == 0);   //ȴ
}

/****************************************************************************************************************************************** 
* : UART_ReceiveData()
* ˵:	ڽպ  
*     : UART_TypeDef * UARTx     UART0   UART1   UART2	   
*			uint8_t *data    յ
*     : ״̬   ޴󷵻0 
* ע: 
******************************************************************************************************************************************/
uint8_t UART_ReceiveData(UART_TypeDef * UARTx, uint8_t *data)
{
	uint8_t temp;
	
	temp = UARTx->LSR;
	
	if((temp & UART_LSR_REC_MSK) == 0)  return UART_ERR_REC;        //ûнյ
	if(temp & UART_LSR_OVF_MSK)         return UART_ERR_OVF;        //
	if(temp & UART_LSR_PARITY_MSK)      return UART_ERR_PARITY;     //У
	if(temp & UART_LSR_STOP_MSK)        return UART_ERR_STOP;       //ֹͣλ
	if(temp & UART_LSR_BREAK_MSK)       return UART_ERR_BREAK;      //BREAK
	
	*data = UARTx->RDR;               //޴ȡյ
	
	return 0;	                      //޴󷵻0
}

/****************************************************************************************************************************************** 
* : UART_IsTXEmpty()
* ˵:	ڷͼĴǷΪ
*     : UART_TypeDef * UARTx     UART0   UART1   UART2	   
*			
*     : 1 ͼĴΪգԼ   0  ͼĴΪ ʾڷݻûз
* ע: 
******************************************************************************************************************************************/
uint8_t UART_IsTXEmpty(UART_TypeDef * UARTx)
{
	if(UARTx->LSR & UART_LSR_THRE_MSK) 
	{
		return 1;
	}
	else
	{
	    return 0;
	}
}

/****************************************************************************************************************************************** 
* : UART_IsRXValid()
* ˵:	ڽռĴǷ
*     : UART_TypeDef * UARTx     UART0   UART1   UART2	   
*			
*     : 1 ռĴݿԶȡ   0  ռĴΪ
* ע: 
******************************************************************************************************************************************/
uint8_t UART_IsRXValid(UART_TypeDef * UARTx)
{
	if(UARTx->LSR & UART_LSR_REC_MSK) 
	{
		return 1;
	}
	else
	{
	    return 0;
	}
}


/****************************************************************************************************************************************** 
* : UART_TX_INTEn()
* ˵:	ڷжʹ 
*     : UART_TypeDef * UARTx     UART0   UART1   UART2	   
*     : 
* ע: 
******************************************************************************************************************************************/
void UART_TX_INTEn(UART_TypeDef * UARTx)
{
	//assert_param(IS_UART_ALL(UARTx));               //ĲUARTxǷϷ     
	
	switch((uint32_t)UARTx)         
	{
		case ((uint32_t)UART0):
		
			UART0->IE |= 0x01 << UART_IE_TXE_POS;
			NVIC_EnableIRQ(UART0_IRQn);
		
		break;

#ifdef IC_BL2101		
		case ((uint32_t)UART1):
		
			UART1->IE |= 0x01 << UART_IE_TXE_POS;
			NVIC_EnableIRQ(UART1_IRQn);
		
		break;
		
		case ((uint32_t)UART2):
		
			UART2->IE |= 0x01 << UART_IE_TXE_POS;
			NVIC_EnableIRQ(UART2_IRQn);
		
		break;	
#endif
	}	
}

/****************************************************************************************************************************************** 
* : UART_TX_INTDis()
* ˵:	ڷжϽ
*     : UART_TypeDef * UARTx     UART0   UART1   UART2	   
*     : 
* ע: 
******************************************************************************************************************************************/
void UART_TX_INTDis(UART_TypeDef * UARTx)
{
	//assert_param(IS_UART_ALL(UARTx));               //ĲUARTxǷϷ     
	
	switch((uint32_t)UARTx)         
	{
		case ((uint32_t)UART0):
		
			UART0->IE &= ~(0x01 << UART_IE_TXE_POS);
			
		break;
		
#ifdef IC_BL2101
		case ((uint32_t)UART1):
		
			UART1->IE &= ~(0x01 << UART_IE_TXE_POS);
			
		break;
		
		case ((uint32_t)UART2):
		
			UART2->IE &= ~(0x01 << UART_IE_TXE_POS);
		
		break;	
#endif
	}	
}


/****************************************************************************************************************************************** 
* : UART_RX_INTEn()
* ˵:	ڽжʹ 
*     : UART_TypeDef * UARTx     UART0   UART1   UART2	   
*     : 
* ע: 
******************************************************************************************************************************************/
void UART_RX_INTEn(UART_TypeDef * UARTx)
{
	//assert_param(IS_UART_ALL(UARTx));               //ĲUARTxǷϷ     
	
	switch((uint32_t)UARTx)         
	{
		case ((uint32_t)UART0):
		
			UART0->IE |= 0x01 << UART_IE_RXIEN_POS;
			NVIC_EnableIRQ(UART0_IRQn);
		
		break;

#ifdef IC_BL2101		
		case ((uint32_t)UART1):
		
			UART1->IE |= 0x01 << UART_IE_RXIEN_POS;
			NVIC_EnableIRQ(UART1_IRQn);
		
		break;
		
		case ((uint32_t)UART2):
		
			UART2->IE |= 0x01 << UART_IE_RXIEN_POS;
			NVIC_EnableIRQ(UART2_IRQn);
		
		break;	
#endif
  }	
}

/****************************************************************************************************************************************** 
* : UART_RX_INTDis()
* ˵:	ڽжϽ
*     : UART_TypeDef * UARTx     UART0   UART1   UART2	   
*     : 
* ע: 
******************************************************************************************************************************************/
void UART_RX_INTDis(UART_TypeDef * UARTx)
{
	//assert_param(IS_UART_ALL(UARTx));               //ĲUARTxǷϷ     
	
	switch((uint32_t)UARTx)         
	{
		case ((uint32_t)UART0):
		
			UART0->IE &= ~(0x01 << UART_IE_RXIEN_POS);
			
		break;
		
#ifdef IC_BL2101
		case ((uint32_t)UART1):
		
			UART1->IE &= ~(0x01 << UART_IE_RXIEN_POS);
			
		break;
		
		case ((uint32_t)UART2):
		
			UART2->IE &= ~(0x01 << UART_IE_RXIEN_POS);
		
		break;	
#endif
	}	
}


