#include "BL210x_power.h"

/****************************************************************************************************************************************** 
* : Enter_LowPower_Mode()
* ˵:	ý͹ģʽ     
*     : uint8_t Mode	1 STANDBY   2 SLEEP   4 STOP  	
*     : 
* ע: 
******************************************************************************************************************************************/
void Enter_LowPower_Mode(uint8_t Mode)
{
//	assert_param(IS_LOWPOWER_MODE(Mode));                              //ĲModeǷϷ 
//	
	switch(Mode)
	{
		case MODE_STANDBY:
			
			PMU->LPOW_MD = 0x01 << PMU_LPOW_MD_STANDBY_POS;            //ϵͳSTANDBYģʽ
		
		break;
		
		case MODE_SLEEP:
#ifdef IC_BL2102			
			FLASH_Set_DeepPowerDown();
			PMU->LPOW_MD = 0x01 << PMU_LPOW_MD_SLEEP_POS;              //ϵͳSLEEPģʽ
			FLASH_ReSet_DeepPowerDown();
#else
			OTP->CFG |= 1 << OTP_CFG_SDY_POS;
		
			PMU->LPOW_MD = 0x01 << PMU_LPOW_MD_SLEEP_POS;              //ϵͳSLEEPģʽ
		
			while(PMU->LPMD_WKST == 0);
		
			OTP->CFG &= ~(1 << OTP_CFG_SDY_POS);
		
			while((OTP->PROGEN & OTP_PROGEN_INIT_MASK) != 0);          //ȴOTPʼ
				
#endif		
		
		break;
		case MODE_DEEPSLEEP:
			
			PMU->LPOW_MD = 0x01 << PMU_LPOW_MD_DEEPSLEEP_POS;          //ϵͳDEEPSLEEPģʽ 
		
			while(PMU->LPMD_WKST == 0);
		
		break;		
		case MODE_STOP:
#ifdef IC_BL2102				
			FLASH_Set_DeepPowerDown();
			PMU->LPOW_MD = 0x01 << PMU_LPOW_MD_STOP_POS;               //ϵͳSTOPģʽ 
			FLASH_ReSet_DeepPowerDown();
#else		
			PMU->LPOW_MD = 0x01 << PMU_LPOW_MD_STOP_POS;               //ϵͳSTOPģʽ 
		
#endif		
		break;
		
	
		default:
			
		break;
	}
}

/****************************************************************************************************************************************** 
* : WakeUp_Style_Enable()
* ˵:	ģʽʹ  
*     : uint8_t WakeUp_Style   1 WAKEUP_IO  		
*     : 
* ע: 
******************************************************************************************************************************************/
void WakeUp_Style_Enable(uint8_t WakeUp_Style)
{
//	assert_param(IS_WAKEUP_MODE(WakeUp_Style));                         //ĲWakeUp_StyleǷϷ 
	
	switch(WakeUp_Style)
	{
		case WAKEUP_RTC_ALARM:
			
			PMU->LPMD_WKEN |= 0x01 << PMU_LPMD_WKEN_RTC_ALARM_POS;      //RTCӻʹ
		
		break;
		
		case WAKEUP_RTC_SECOND:
		
			PMU->LPMD_WKEN |= 0x01 << PMU_LPMD_WKEN_RTC_SEC_POS;        //RTC뻽ʹ		
		
		break;
		
		case WAKEUP_IO:
			
			PMU->LPMD_WKEN |= 0x01 << PMU_LPMD_WKEN_IO_POS;             //IOʹ
		
		break;
		
		default:
			
		break;
	}
}

/****************************************************************************************************************************************** 
* : WakeUp_Style_Disable()
* ˵:	ģʽ 
*     : uint8_t WakeUp_Style	 1 WAKEUP_IO  		
*     : 
* ע: 
******************************************************************************************************************************************/
void WakeUp_Style_Disable(uint8_t WakeUp_Style)
{
//	assert_param(IS_WAKEUP_MODE(WakeUp_Style));                            //ĲWakeUp_StyleǷϷ 
	
	switch(WakeUp_Style)
	{
		case WAKEUP_RTC_ALARM:
			
			PMU->LPMD_WKEN &= ~(0x01 << PMU_LPMD_WKEN_RTC_ALARM_POS);      //RTCӻѽ
		
		break;
		
		case WAKEUP_RTC_SECOND:
		
			PMU->LPMD_WKEN &= ~(0x01 << PMU_LPMD_WKEN_RTC_SEC_POS);        //RTC뻽ѽ	
		
		break;
		
		case WAKEUP_IO:
			
			PMU->LPMD_WKEN &= ~(0x01 << PMU_LPMD_WKEN_IO_POS);             //IOѽ
		
		break;
		
		default:
			
		break;
	}
}

/****************************************************************************************************************************************** 
* : WakeUp_State_Check()
* ˵:	״̬ѯ
*     : uint8_t WakeUp_Style	   1 WAKEUP_IO  		
*     : 1  ѱ־   0δѱ־
* ע: 
******************************************************************************************************************************************/
uint8_t WakeUp_State_Check(uint8_t WakeUp_Style)
{
	uint8_t state = 0;
	
//	assert_param(IS_WAKEUP_MODE(WakeUp_Style));                            //ĲWakeUp_StyleǷϷ 
	
	switch(WakeUp_Style)
	{
		case WAKEUP_IO:
			
			if(PMU->LPMD_WKST & PMU_LPMD_WKST_IO_MSK)                      //жǷIOѱ־
			{
				state = 1;
			}
		
		break;
		
		default:
			
			state = 0;
		
		break;
	}

	return state;
}

/****************************************************************************************************************************************** 
* : WakeUp_State_Clear()
* ˵:	״̬
*     : uint8_t WakeUp_Style	1 WAKEUP_IO  		
*     : 
* ע: 
******************************************************************************************************************************************/
void WakeUp_State_Clear(uint8_t WakeUp_Style)
{
//	assert_param(IS_WAKEUP_MODE(WakeUp_Style));                                //ĲWakeUp_StyleǷϷ 
	
	switch(WakeUp_Style)
	{
		case WAKEUP_IO:
			
			PMU->LPMD_WKST = 0x01 << PMU_LPMD_WKST_IO_POS;                     //IOѱ־
		
		break;
		
		default:	
		
		break;
	}
}
