#ifndef __BL2101_GPIO_H__
#define	__BL2101_GPIO_H__

#include "BL210x.h"
#include "BL210x_port.h"
/*
#define GPIO_PIN0                  0             //0
#define GPIO_PIN1                  1             //1
#define GPIO_PIN2                  2             //2
#define GPIO_PIN3                  3             //3
#define GPIO_PIN4                  4             //4
#define GPIO_PIN5                  5             //5
#define GPIO_PIN6                  6             //6
#define GPIO_PIN7                  7             //7
#define GPIO_PIN8                  8             //8
#define GPIO_PIN9                  9             //9
#define GPIO_PIN10                 10            //10
#define GPIO_PIN11                 11            //11
#define GPIO_PIN12                 12            //12
#define GPIO_PIN13                 13            //13
#define GPIO_PIN14                 14            //14
#define GPIO_PIN15                 15            //15
*/

typedef enum
{ 
	MODE_FLOATING_IN = 0x00,    // 
	MODE_PU_IN =       0x01,    // 
	MODE_PD_IN =       0x02,    // 
	MODE_PP_OUT =      0x03,    // 
	MODE_OD_OUT =      0x04,    // ©
} Mode_TypeDef;

typedef enum
{ 
	WAKEUP_DISABLE =  0x00,    // ֹ
	WAKEUP_ENABLE =   0x01,    // ʹܻ
} WakeUpEn_TypeDef;


typedef struct
{            
    uint8_t              Pin;               //ź                      
    Mode_TypeDef         Mode;              //ģʽ
	WakeUpEn_TypeDef     WakeUp_En;         //ʹ
} GPIO_InitTypeDef;

void GPIO_Init(GPIO_TypeDef * GPIOx, GPIO_InitTypeDef* GPIO_InitStruct);        //GPIOʼ

void GPIO_SetBit(GPIO_TypeDef * GPIOx, uint32_t GPIO_Pin);						//ָŵƽø
void GPIO_ClrBit(GPIO_TypeDef * GPIOx, uint32_t GPIO_Pin);						//ָŵƽõ
void GPIO_InvBit(GPIO_TypeDef * GPIOx, uint32_t GPIO_Pin);						//ָŵƽת
uint32_t GPIO_GetBit(GPIO_TypeDef * GPIOx, uint32_t GPIO_Pin);					//ȡָŵĵƽ״̬

#endif //__BL2101_GPIO_H__
