#ifndef __BL1002_H__
#define __BL1002_H__

/*
 * ==========================================================================
 * ---------- Interrupt Number Definition -----------------------------------
 * ==========================================================================
 */
typedef enum IRQn
{
/******  Cortex-M0 Processor Exceptions Numbers **********************************************/
  NonMaskableInt_IRQn         = -14,    /*!< 2 Non Maskable Interrupt                        */
  HardFault_IRQn	          = -13,	/*!< 3 Cortex-M0 Hard Fault Interrupt				 */
  SVCall_IRQn                 = -5,     /*!< 11 Cortex-M0 SV Call Interrupt                  */
  PendSV_IRQn                 = -2,     /*!< 14 Cortex-M0 Pend SV Interrupt                  */
  SysTick_IRQn                = -1,     /*!< 15 Cortex-M0 System Tick Interrupt              */
  
/******  Cortex-M0 specific Interrupt Numbers ************************************************/
  UART0_IRQn          = 0,
  TIMPLUS0_IRQn       = 1,
  PWMBASE0_IRQn       = 2,
  PWMPLUS0_IRQn       = 3,
  IIC0_IRQn           = 4,
  ADC_IRQn            = 5,
  SPI0_IRQn           = 6,
  IWDT_IRQn           = 7,
  GPIOA0_IRQn         = 8,
  GPIOA1_IRQn         = 9,
  GPIOA2_IRQn         = 10,
  GPIOA3_IRQn         = 11,
  GPIOA4_IRQn         = 12,
  GPIOA5_IRQn         = 13,
  GPIOA6_IRQn         = 14,
  GPIOA7_IRQn         = 15,
  GPIOA8_IRQn         = 16,
  GPIOA9_IRQn         = 17,
  GPIOA10_IRQn        = 18,	
  GPIOA11_IRQn        = 19,
  GPIOA12_IRQn        = 20,
  GPIOA13_IRQn        = 21,
  GPIOA14_IRQn        = 22,
  GPIOA15_IRQn        = 23,
  IRQ24_IRQn          = 24,
  IRQ25_IRQn          = 25,
  IRQ26_IRQn          = 26,
  IRQ27_IRQn          = 27,
  IRQ28_IRQn          = 28,
  IRQ29_IRQn          = 29,
  IRQ30_IRQn          = 30,
  IRQ31_IRQn          = 31,
} IRQn_Type;

/*
 * ==========================================================================
 * ----------- Processor and Core Peripheral Section ------------------------
 * ==========================================================================
 */

/* Configuration of the Cortex-M0 Processor and Core Peripherals */
#define __MPU_PRESENT		    0	   /*!< UART does not provide a MPU present or not	     */
#define __NVIC_PRIO_BITS		2	   /*!< UART Supports 2 Bits for the Priority Levels	 */
#define __Vendor_SysTickConfig  0	   /*!< Set to 1 if different SysTick Config is used	 */

#if   defined ( __CC_ARM )
  #pragma anon_unions
#endif

#include <stdio.h>
#include "core_cm0.h"				   /* Cortex-M0 processor and core peripherals		     */

typedef enum {RESET = 0, SET = 1} FlagStatus, ITStatus;

typedef enum {DISABLE = 0, ENABLE = 1} FunctionalState;

#define IS_FUNCTIONAL_STATE(STATE) (((STATE) == DISABLE) || ((STATE) == ENABLE))

typedef enum {ERROR = 0, SUCCESS = 1} ErrorStatus;


/******************************************************************************/
/*				Device Specific Peripheral registers structures			 */
/******************************************************************************/

typedef struct {
	__IO uint32_t CLKSEL;				//Clock Select

	__IO uint32_t CLKDIV_EN;			//CLK_DIVʱԴ

	__IO uint32_t CLKEN;			    //Clock Enable

	uint32_t RESERVED1[1];
	
	__IO uint32_t IWDTRST_ST;           //Źλ״̬             
	
	uint32_t RESERVED2[(0x100 - 0x14)/4];
	
	__IO uint32_t RCCR;					//RC Control Register
	
	__IO uint32_t XTACR;			    //XTA Control Register
} SYS_TypeDef;

#define SYS_CLKSEL_SYS_POS		      0		//ϵͳʱѡ	0 RCHF  1 CLK_DIVx
#define SYS_CLKSEL_SYS_MSK		      (0x01 << SYS_CLKSEL_SYS_POS)

#define SYS_CLKSEL_DIV_POS		      1		//ѡCLK_DIVx  0 DIV1  1 DIV2  2 DIV4   3 DIV8  4  DIV16   5  DIV32
#define SYS_CLKSEL_DIV_MSK		      (0x07 << SYS_CLKSEL_DIV_POS)

#define SYS_CLKSEL_SRC_POS		      4		//ѡSRC  0 RCHF   1 RCLF   2 XTAL   3 RESERVED
#define SYS_CLKSEL_SRC_MSK		      (0x07 << SYS_CLKSEL_SRC_POS)

#define SYS_CLKSEL_ADC_POS		      10	//ADCʱѡ  0 1Ƶ   1 2Ƶ   2 4Ƶ   3 8Ƶ
#define SYS_CLKSEL_ADC_MSK		      (0x03 << SYS_CLKSEL_ADC_POS)


#define SYS_CLKDIV_EN_DIV_POS	      0		//Ƶʱѡ	0 ʹܷƵʱ  1 ֹƵʱ	
#define SYS_CLKDIV_EN_DIV_MSK         (0x01 << SYS_CLKDIV_EN_DIV_POS)


#define SYS_CLKEN_GPIOA_POS		      0		//GPIOAʱſ   
#define SYS_CLKEN_GPIOA_MSK		      (0x01 << SYS_CLKEN_GPIOA_POS)

#define SYS_CLKEN_IIC0_POS		      4		//IIC0ʱſ   
#define SYS_CLKEN_IIC0_MSK		      (0x01 << SYS_CLKEN_IIC0_POS)

#define SYS_CLKEN_UART0_POS		      6     //UART0ʱſ   
#define SYS_CLKEN_UART0_MSK		      (0x01 << SYS_CLKEN_UART0_POS)

#define SYS_CLKEN_SPI0_POS		      10    //SPI0ʱſ   
#define SYS_CLKEN_SPI0_MSK		      (0x01 << SYS_CLKEN_SPI0_POS)

#define SYS_CLKEN_TIMPLUS0_POS        15    //TIMPLUS0ʱſ   
#define SYS_CLKEN_TIMPLUS0_MSK        (0x01 << SYS_CLKEN_TIMPLUS0_POS)

#define SYS_CLKEN_PWMBASE0_POS		  17	//PWMBASE0ʱſ   
#define SYS_CLKEN_PWMBASE0_MSK		  (0x01 << SYS_CLKEN_PWMBASE0_POS)

#define SYS_CLKEN_PWMPLUS0_POS		  20	//PWMPLUS0ʱſ   
#define SYS_CLKEN_PWMPLUS0_MSK		  (0x01 << SYS_CLKEN_PWMPLUS0_POS)

#define SYS_CLKEN_IWDT_POS		      23    //IWDTʱſ   
#define SYS_CLKEN_IWDT_MSK		      (0x01 << SYS_CLKEN_IWDT_POS)

#define SYS_CLKEN_ADC_POS		      25    //ADCʱſ   
#define SYS_CLKEN_ADC_MSK		      (0x01 << SYS_CLKEN_ADC_POS)


#define SYS_IWDTRST_ST_POS		      0	    //Źλ״̬
#define SYS_IWDTRST_ST_MSK		      (0x01 << SYS_IWDTRST_ST_POS)
 
 
#define SYS_RCCR_RCHF_EN_POS          0     //RCHFʹܿλ
#define SYS_RCCR_RCHF_EN_MSK          (0x01 << SYS_RCCR_RCHF_EN_POS)

#define SYS_RCCR_RCLF_EN_POS          1     //RCLFʹܿλ
#define SYS_RCCR_RCLF_EN_MSK          (0x01 << SYS_RCCR_RCLF_EN_POS)

#define SYS_RCCR_RCHF_SEL_POS         4     //RCHFƵѡλ   0: 48MHZ  1: 24MHZ
#define SYS_RCCR_RCHF_SEL_MSK         (0x01 <<SYS_RCCR_RCHF_SEL_POS)

#define SYS_RCCR_XTAH_RCHF_POS        8
#define SYS_RCCR_XTAH_RCHF_MSK        (0x01 <<SYS_RCCR_XTAH_RCHF_POS) 

#define SYS_RCCR_XTAH_RCLF_POS        9
#define SYS_RCCR_XTAH_RCLF_MSK        (0x01 <<SYS_RCCR_XTAH_RCLF_POS) 


#define SYS_XTACR_XTAH_EN_POS		  0	//XTAHʹ
#define SYS_XTACR_XTAH_EN_MSK		  (0x01 << SYS_XTACR_XTAH_EN_POS)



typedef struct {
	__IO uint32_t PORTA_SEL0;                //ѡ
	
	__IO uint32_t PORTA_SEL1;
	
	uint32_t RESERVED1[(0x100 - 0x08)/4];
	
	__IO uint32_t PORTA_INEN;               //ʹ
	
	uint32_t RESERVED2[(0x200 - 0x104)/4];
	
	__IO uint32_t PORTA_PU_IN;              //ʹ
	
	uint32_t RESERVED3[(0x300 - 0x204)/4];
	
    __IO uint32_t PORTA_PD_IN;              //ʹ
  
    uint32_t RESERVED4[(0x400 - 0x304)/4];     
			 
	__IO uint32_t PORTA_OD_OUT;              //©ʹ
    
    uint32_t RESERVED5[(0x500 - 0x404)/4]; 
	
	__IO uint32_t PORTA_WAKEUP;             //ʹ
    
    uint32_t RESERVED6[(0x600 - 0x504)/4]; 
	
	__IO uint32_t PORT_CFG;                 //˿
} PORT_TypeDef;


#define PORT_CFG_DS_POS		            0		//ѡ  00 5ma  01 14ma  10 22ma  11 30ma 
#define PORT_CFG_DS_MSK		            (0x03 << PORT_CFG_DS_POS)

#define PORT_CFG_SPIFLASH_DS_POS		2		//ѡ  00 5ma  01 14ma  10 22ma  11 30ma 
#define PORT_CFG_SPIFLASH_DS_MSK	    (0x03 << PORT_CFG_SPIFLASH_DS_POS)

#define PORT_CFG_PUR_POS		        8		//ѡ  00   01  150K   10 40K    11  32K  
#define PORT_CFG_PUR_MSK		        (0x03 << PORT_CFG_PUR_POS)

#define PORT_CFG_HYS_POS		        10		//͵ȼѡ  0   >0.7VDD  <0.3VDD   1   >0.85VDD <0.15VDD 
#define PORT_CFG_HYS_MSK		        (0x01 << PORT_CFG_HYS_POS)

#define PORT_CFG_WKRF_POS		        11		//ѹѡ  0  ½  1  
#define PORT_CFG_WKRF_MSK		        (0x01 << PORT_CFG_WKRF_POS)


typedef struct {
	__IO uint32_t DATA;                 //ݼĴ

	__IO uint32_t DIR;					//0 	1 

	__IO uint32_t INTLVLTRG;			//Interrupt Level Trigger  1 ƽж	0 شж

	__IO uint32_t INTBE;			    //Both EdgeINTLVLTRGΪشжʱλ1ʾغ½ضжϣ0ʱINTRISEENѡ

	__IO uint32_t INTRISEEN;			//Interrupt Rise Edge Enable   1 /ߵƽж	0 ½/͵ƽж

	__IO uint32_t INTEN;			    //1 жʹ	0 жϽֹ

	__IO uint32_t INTRAWSTAT;			//жϼⵥԪǷ⵽˴жϵ 1 ⵽жϴ	0 ûм⵽жϴ

	__IO uint32_t INTSTAT;				//INTSTAT.PIN0 = INTRAWSTAT.PIN0 & INTEN.PIN0

	__IO uint32_t INTCLR;			    //д1жϱ־ֻԱشж

} GPIO_TypeDef;


typedef struct {
	__IO uint32_t LOAD;					    //IWDTʼֵ
	
	__IO uint32_t VALUE;					//IWDTǰֵ
	
	__IO uint32_t CTRL;                     //IWDTƼĴ
	
	__IO uint32_t IF;						//[0] жϱ־д0 
	
	__IO uint32_t FEED;                     //ιĴ  д0x55ι
	
} IWDT_TypeDef;


#define IWDT_CTRL_EN_POS      0   //IWDTʹ
#define IWDT_CTRL_EN_MSK      (0x01 << IWDT_CTRL_EN_POS)

#define IWDT_CTRL_RSTEN_POS   1   //IWDTλʹ
#define IWDT_CTRL_RSTEN_MSK   (0x01 << IWDT_CTRL_RSTEN_POS)


typedef struct {
	__IO uint32_t EN;             //ʱʹ
	
	__IO uint32_t DIV;            //ʱƵֵ
	
	__IO uint32_t CTR;            //ʱƼĴ
	
	uint32_t RESERVED1[1];
	
	__IO uint32_t IE;             //жʹܼĴ
		
	__IO uint32_t IF;             //״̬Ĵ
	
	uint32_t RESERVED2[2];
	
	__IO uint32_t HIGH_PERIOD;    //16λüĴ
	
	__IO uint32_t HIGH_CNT;       //16λǰֵĴ

	__IO uint32_t HIGH_CVAL;      //16λֵĴ	
	
	uint32_t RESERVED3[1];
	
	__IO uint32_t LOW_PERIOD;     //16λüĴ
	
	__IO uint32_t LOW_CNT;        //16λǰֵĴ

	__IO uint32_t LOW_CVAL;       //16λֵĴ	
	
	uint32_t RESERVED4[1];
	
	__IO uint32_t HALL_VAL;       //HALLԭʼźŵƽ
	
}TIMPLUS_TypeDef;

#define TIMPLUS_EN_LOW_POS            0        //16λʱʹܼĴ    
#define TIMPLUS_EN_LOW_MSK            (0x01 << TIMPLUS_EN_LOW_POS)

#define TIMPLUS_EN_HIGH_POS           1        //16λʱʹܼĴ    
#define TIMPLUS_EN_HIGH_MSK           (0x01 << TIMPLUS_EN_HIGH_POS)


#define TIMPLUS_DIV_POS               0        //ʱƵĴ  0 1Ƶ   1  2Ƶ    FF 256Ƶ
#define TIMPLUS_DIV_MSK               (0xFF << TIMPLUS_DIV_POS)  


#define TIMPLUS_CTR_LOW_MODE_POS       0        //16λʱģʽĴ  
#define TIMPLUS_CTR_LOW_MODE_MSK       (0x03 << TIMPLUS_CTR_LOW_MODE_POS)

#define TIMPLUS_CTR_LOW_CLKSEL_POS     2        //16λʱʱԴѡ
#define TIMPLUS_CTR_LOW_CLKSEL_MSK     (0x03 << TIMPLUS_CTR_LOW_CLKSEL_POS)

#define TIMPLUS_CTR_LOW_EXTSEL_POS     4        //16λʱģʽ벶ģʽźѡ
#define TIMPLUS_CTR_LOW_EXTSEL_MSK     (0x01 << TIMPLUS_CTR_LOW_EXTSEL_POS)

#define TIMPLUS_CTR_LOW_EXTLEVEL_POS   5        //16λʱģʽ벶ģʽźЧѡ
#define TIMPLUS_CTR_LOW_EXTLEVEL_MSK   (0x03 << TIMPLUS_CTR_LOW_EXTV_POS)

#define TIMPLUS_CTR_LOW_OUTEN_POS      7        //16λʱ
#define TIMPLUS_CTR_LOW_OUTEN_MSK      (0x01 << TIMPLUS_CTR_LOW_OUTEN_POS)

#define TIMPLUS_CTR_HIGH_MODE_POS      16        //16λʱģʽĴ  
#define TIMPLUS_CTR_HIGH_MODE_MSK      (0x03 << TIMPLUS_CTR_HIGH_MODE_POS)

#define TIMPLUS_CTR_HIGH_CLKSEL_POS    18        //16λʱʱԴѡ
#define TIMPLUS_CTR_HIGH_CLKSEL_MSK    (0x03 << TIMPLUS_CTR_HIGH_CLKSEL_POS)

#define TIMPLUS_CTR_HIGH_EXTSEL_POS    20        //16λʱģʽ벶ģʽźѡ
#define TIMPLUS_CTR_HIGH_EXTSEL_MSK    (0x01 << TIMPLUS_CTR_HIGH_EXTSEL_POS)

#define TIMPLUS_CTR_HIGH_EXTLEVEL_POS  21        //16λʱģʽ벶ģʽźЧѡ
#define TIMPLUS_CTR_HIGH_EXTLEVEL_MSK  (0x03 << TIMPLUS_CTR_HIGH_EXTLEVEL_POS)

#define TIMPLUS_CTR_HIGH_OUTEN_POS     23        //16λʱ
#define TIMPLUS_CTR_HIGH_OUTEN_MSK     (0x01 << TIMPLUS_CTR_HIGH_OUTEN_POS)


#define TIMPLUS_IE_LOW_OVF_POS         0        //16λʱжʹ
#define TIMPLUS_IE_LOW_OVF_MSK         (0x01 << TIMPLUS_IE_LOW_OVF_POS)

#define TIMPLUS_IE_LOW_RISE_POS        1        //16λʱжʹ
#define TIMPLUS_IE_LOW_RISE_MSK        (0x01 << TIMPLUS_IE_LOW_RISE_POS)

#define TIMPLUS_IE_LOW_FALL_POS        2        //16λʱ½жʹ
#define TIMPLUS_IE_LOW_FALL_MSK        (0x01 << TIMPLUS_IE_LOW_FALL_POS)

#define TIMPLUS_IE_HIGH_OVF_POS        8        //16λʱжʹ
#define TIMPLUS_IE_HIGH_OVF_MSK        (0x01 << TIMPLUS_IE_HIGH_OVF_POS)

#define TIMPLUS_IE_HIGH_RISE_POS       9        //16λʱжʹ
#define TIMPLUS_IE_HIGH_RISE_MSK       (0x01 << TIMPLUS_IE_HIGH_RISE_POS)

#define TIMPLUS_IE_HIGH_FALL_POS       10       //16λʱ½жʹ
#define TIMPLUS_IE_HIGH_FALL_MSK       (0x01 << TIMPLUS_IE_HIGH_FALL_POS)

#define TIMPLUS_IE_HALL0_RISE_POS      16       //HALL0жʹ
#define TIMPLUS_IE_HALL0_RISE_MSK      (0x01 << TIMPLUS_IE_HALL0_RISE_POS)

#define TIMPLUS_IE_HALL0_FALL_POS      17       //HALL0½жʹ
#define TIMPLUS_IE_HALL0_FALL_MSK      (0x01 << TIMPLUS_IE_HALL0_FALL_POS)

#define TIMPLUS_IE_HALL1_RISE_POS      18       //HALL1жʹ
#define TIMPLUS_IE_HALL1_RISE_MSK      (0x01 << TIMPLUS_IE_HALL1_RISE_POS)

#define TIMPLUS_IE_HALL1_FALL_POS      19       //HALL1½жʹ
#define TIMPLUS_IE_HALL1_FALL_MSK      (0x01 << TIMPLUS_IE_HALL1_FALL_POS)

#define TIMPLUS_IE_HALL2_RISE_POS      20       //HALL2жʹ
#define TIMPLUS_IE_HALL2_RISE_MSK      (0x01 << TIMPLUS_IE_HALL2_RISE_POS)

#define TIMPLUS_IE_HALL2_FALL_POS      21       //HALL2½жʹ
#define TIMPLUS_IE_HALL2_FALL_MSK      (0x01 << TIMPLUS_IE_HALL2_FALL_POS)


#define TIMPLUS_IF_LOW_OVF_POS         0        //16λʱж״̬
#define TIMPLUS_IF_LOW_OVF_MSK         (0x01 << TIMPLUS_IF_LOW_OVF_POS)

#define TIMPLUS_IF_LOW_RISE_POS        1        //16λʱж״̬
#define TIMPLUS_IF_LOW_RISE_MSK        (0x01 << TIMPLUS_IF_LOW_RISE_POS)

#define TIMPLUS_IF_LOW_FALL_POS        2        //16λʱ½ж״̬
#define TIMPLUS_IF_LOW_FALL_MSK        (0x01 << TIMPLUS_IF_LOW_FALL_POS)

#define TIMPLUS_IF_HIGH_OVF_POS        8        //16λʱж״̬
#define TIMPLUS_IF_HIGH_OVF_MSK        (0x01 << TIMPLUS_IF_HIGH_OVF_POS)

#define TIMPLUS_IF_HIGH_RISE_POS       9        //16λʱж״̬
#define TIMPLUS_IF_HIGH_RISE_MSK       (0x01 << TIMPLUS_IF_HIGH_RISE_POS)

#define TIMPLUS_IF_HIGH_FALL_POS       10       //16λʱ½ж״̬
#define TIMPLUS_IF_HIGH_FALL_MSK       (0x01 << TIMPLUS_IF_HIGH_FALL_POS)

#define TIMPLUS_IF_HALL0_RISE_POS      16       //HALL0ж״̬
#define TIMPLUS_IF_HALL0_RISE_MSK      (0x01 << TIMPLUS_IF_HALL0_RISE_POS)

#define TIMPLUS_IF_HALL0_FALL_POS      17       //HALL0½ж״̬
#define TIMPLUS_IF_HALL0_FALL_MSK      (0x01 << TIMPLUS_IF_HALL0_FALL_POS)

#define TIMPLUS_IF_HALL1_RISE_POS      18       //HALL1ж״̬
#define TIMPLUS_IF_HALL1_RISE_MSK      (0x01 << TIMPLUS_IF_HALL1_RISE_POS)

#define TIMPLUS_IF_HALL1_FALL_POS      19       //HALL1½ж״̬
#define TIMPLUS_IF_HALL1_FALL_MSK      (0x01 << TIMPLUS_IF_HALL1_FALL_POS)

#define TIMPLUS_IF_HALL2_RISE_POS      20       //HALL2ж״̬
#define TIMPLUS_IF_HALL2_RISE_MSK      (0x01 << TIMPLUS_IF_HALL2_RISE_POS)

#define TIMPLUS_IF_HALL2_FALL_POS      21       //HALL2½ж״̬
#define TIMPLUS_IF_HALL2_FALL_MSK      (0x01 << TIMPLUS_IF_HALL2_FALL_POS)


#define TIMPLUS_HALL_VAL_HALL0_POS    0        //HALL0ԭʼźŵƽ
#define TIMPLUS_HALL_VAL_HALL0_MSK    (0x01 << TIMPLUS_HALL_VAL_HALL0_POS)

#define TIMPLUS_HALL_VAL_HALL1_POS    1        //HALL1ԭʼźŵƽ
#define TIMPLUS_HALL_VAL_HALL1_MSK    (0x01 << TIMPLUS_HALL_VAL_HALL1_POS)

#define TIMPLUS_HALL_VAL_HALL2_POS    2        //HALL2ԭʼźŵƽ
#define TIMPLUS_HALL_VAL_HALL2_MSK    (0x01 << TIMPLUS_HALL_VAL_HALL2_POS)



typedef struct {
	
	__IO uint32_t EN;                     //PWMBASEʹܼĴ
											
	__IO uint32_t DIV;                    //PWMBASEƵĴ
	
	__IO uint32_t OUTCTR;                 //PWMBASEƼĴ
	
	__IO uint32_t PERIOD;                 //PWMBASEüĴ
	
	__IO uint32_t IE;                     //PWMBASEжʹܼĴ
	
	__IO uint32_t IF;                     //PWMBASEж״̬Ĵ
	
	__IO uint32_t CNT;                    //PWMBASEǰֵĴ  
	
	uint32_t RESERVED1[1];
	
	__IO uint32_t CH0_COMP;               //PWMBASEͨ0ıȽϵüĴ
	
	uint32_t RESERVED2[3];
	
	__IO uint32_t CH1_COMP;               //PWMBASEͨ1ıȽϵüĴ
	
	uint32_t RESERVED3[3];
	
	__IO uint32_t CH2_COMP;               //PWMBASEͨ2ıȽϵüĴ
	
	
} PWMBASE_TypeDef;


#define PWMBASE_EN_POS                0      //PWMBASEʹ
#define PWMBASE_EN_MSK                (0x01 << PWMBASE_EN_POS)

#define PWMBASE_DIV_POS               0      //PWMBASEʱӷƵϵ    0 1Ƶ   1  2Ƶ    FF 256Ƶ
#define PWMBASE_DIV_MSK               (0xFF << PWMBASE_DIV_POS)

#define PWMBASE_OUTCTR_CH0_INV_POS    0      //PWMBASEͨ0Էת
#define PWMBASE_OUTCTR_CH0_INV_MSK    (0x01 << PWMBASE_OUTCTR_CH0_INV_POS)

#define PWMBASE_OUTCTR_CH1_INV_POS    1      //PWMBASEͨ1Էת
#define PWMBASE_OUTCTR_CH1_INV_MSK    (0x01 << PWMBASE_OUTCTR_CH1_INV_POS)

#define PWMBASE_OUTCTR_CH2_INV_POS    2      //PWMBASEͨ2Էת
#define PWMBASE_OUTCTR_CH2_INV_MSK    (0x01 << PWMBASE_OUTCTR_CH2_INV_POS)

#define PWMBASE_OUTCTR_CH0_EN_POS     4      //PWMBASEͨ0ʹ
#define PWMBASE_OUTCTR_CH0_EN_MSK     (0x01 << PWMBASE_OUTCTR_CH0_EN_POS)

#define PWMBASE_OUTCTR_CH1_EN_POS     5      //PWMBASEͨ1ʹ
#define PWMBASE_OUTCTR_CH1_EN_MSK     (0x01 << PWMBASE_OUTCTR_CH1_EN_POS)

#define PWMBASE_OUTCTR_CH2_EN_POS     6      //PWMBASEͨ2ʹ
#define PWMBASE_OUTCTR_CH2_EN_MSK     (0x01 << PWMBASE_OUTCTR_CH2_EN_POS)

#define PWMBASE_IE_CH0_COMP_POS       0      //PWMBASEͨ0Ƚϵжʹ
#define PWMBASE_IE_CH0_COMP_MSK       (0x01 << PWMBASE_IE_CH0_COMP_POS)

#define PWMBASE_IE_CH1_COMP_POS       1      //PWMBASEͨ1Ƚϵжʹ
#define PWMBASE_IE_CH1_COMP_MSK       (0x01 << PWMBASE_IE_CH1_COMP_POS)

#define PWMBASE_IE_CH2_COMP_POS       2      //PWMBASEͨ2Ƚϵжʹ
#define PWMBASE_IE_CH2_COMP_MSK       (0x01 << PWMBASE_IE_CH2_COMP_POS)

#define PWMBASE_IE_OVF_POS            3      //PWMBASEжʹ
#define PWMBASE_IE_OVF_MSK            (0x01 << PWMBASE_IE_OVF_POS)

#define PWMBASE_IF_CH0_COMP_POS       0      //PWMBASEͨ0Ƚϵж״̬
#define PWMBASE_IF_CH0_COMP_MSK       (0x01 << PWMBASE_IF_CH0_COMP_POS)

#define PWMBASE_IF_CH1_COMP_POS       1      //PWMBASEͨ1Ƚϵж״̬
#define PWMBASE_IF_CH1_COMP_MSK       (0x01 << PWMBASE_IF_CH1_COMP_POS)

#define PWMBASE_IF_CH2_COMP_POS       2      //PWMBASEͨ2Ƚϵж״̬
#define PWMBASE_IF_CH2_COMP_MSK       (0x01 << PWMBASE_IF_CH2_COMP_POS)

#define PWMBASE_IF_OVF_POS            3      //PWMBASEж״̬
#define PWMBASE_IF_OVF_MSK            (0x01 << PWMBASE_IF_OVF_POS)


typedef struct {
	
	__IO uint32_t CTR;                    //PWMPLUSüĴ
											
	__IO uint32_t OUTCTR;                 //PWMPLUSƼĴ
	
	__IO uint32_t CLK;                    //PWMPLUSʱԴѡ񼰷ƵĴ
	
	__IO uint32_t BRK_CTR;                //PWMPLUS_BRAKEüĴ
	
	__IO uint32_t MSK_LEVEL;              //PWMPLUSǿƽѡĴ
	
	uint32_t RESERVED1[2];
	
	__IO uint32_t PERIOD;                 //PWMPLUSüĴ
	
	__IO uint32_t CH0_COMP;               //PWMPLUSͨ0ıȽϵüĴ
	
	__IO uint32_t CH1_COMP;               //PWMPLUSͨ1ıȽϵüĴ
	
	__IO uint32_t CH2_COMP;               //PWMPLUSͨ2ıȽϵüĴ
	
	uint32_t RESERVED2[1];
	
	__IO uint32_t CH0_DEADZONE;           //PWMPLUSͨ0üĴ
	
	__IO uint32_t CH1_DEADZONE;           //PWMPLUSͨ1üĴ
	
	__IO uint32_t CH2_DEADZONE;           //PWMPLUSͨ2üĴ
	
	uint32_t RESERVED3[1];
	
	__IO uint32_t TRIG_COMP;              //PWMPLUSڲȽϵĴ
	
	__IO uint32_t TRIG_SEL;               //PWMPLUSڲüĴ
	
	uint32_t RESERVED4[6];
	
	__IO uint32_t IE;                     //PWMPLUSжʹܼĴ
	
	__IO uint32_t IF;                     //PWMPLUSж״̬Ĵ
	
	uint32_t RESERVED5[7];

	__IO uint32_t SWLOAD;                 //PWMPLUS  SWLOADƼĴ
	
	__IO uint32_t MSK_EN;                 //PWMPLUSʹܿƼĴ
	
	uint32_t RESERVED6[21];
	
	__IO uint32_t CNT_STATE;              //PWMPLUSǰֵ״̬Ĵ  
	
	__IO uint32_t BRK_STATE;              //PWMPLUSɲ״̬Ĵ  
	
}PWMPLUS_TypeDef;


#define PWMPLUS_CTR_EN_POS             0   //PWMPLUSʹ
#define PWMPLUS_CTR_EN_MSK             (0x01 << PWMPLUS_CTR_EN_POS)

#define PWMPLUS_CTR_DIR_POS            1   //PWMPLUS   0  ϼ   1  ¼
#define PWMPLUS_CTR_DIR_MSK            (0x01 << PWMPLUS_CTR_DIR_POS)

#define PWMPLUS_CTR_OPM_POS            2   //PWMPLUSμģʽ         0  μ   1  ظ
#define PWMPLUS_CTR_OPM_MSK            (0x01 << PWMPLUS_CTR_OPM_POS)

#define PWMPLUS_CTR_MODE_POS           3   //PWMPLUSģʽ             0  ض   1  Ķ
#define PWMPLUS_CTR_MODE_MSK           (0x01 << PWMPLUS_CTR_MODE_POS)

#define PWMPLUS_CTR_RELOAD_POS         8   //PWMPLUSԶװؼĴ
#define PWMPLUS_CTR_RELOAD_MSK         (0xFF << PWMPLUS_CTR_RELOAD_POS)


#define PWMPLUS_OUTCTR_CH0_IDLE_POS    0   //PWMPLUSԭʼͨ0ʱƽ
#define PWMPLUS_OUTCTR_CH0_IDLE_MSK    (0x01 << PWMPLUS_OUTCTR_CH0_IDLE_POS)

#define PWMPLUS_OUTCTR_CH0N_IDLE_POS   1   //PWMPLUSԭʼͨ0Nʱƽ
#define PWMPLUS_OUTCTR_CH0N_IDLE_MSK   (0x01 << PWMPLUS_OUTCTR_CH0N_IDLE_POS)

#define PWMPLUS_OUTCTR_CH1_IDLE_POS    2   //PWMPLUSԭʼͨ1ʱƽ
#define PWMPLUS_OUTCTR_CH1_IDLE_MSK    (0x01 << PWMPLUS_OUTCTR_CH1_IDLE_POS)

#define PWMPLUS_OUTCTR_CH1N_IDLE_POS   3   //PWMPLUSԭʼͨ1Nʱƽ
#define PWMPLUS_OUTCTR_CH1N_IDLE_MSK   (0x01 << PWMPLUS_OUTCTR_CH1N_IDLE_POS)

#define PWMPLUS_OUTCTR_CH2_IDLE_POS    4   //PWMPLUSԭʼͨ2ʱƽ
#define PWMPLUS_OUTCTR_CH2_IDLE_MSK    (0x01 << PWMPLUS_OUTCTR_CH2_IDLE_POS)

#define PWMPLUS_OUTCTR_CH2N_IDLE_POS   5   //PWMPLUSԭʼͨ2Nʱƽ
#define PWMPLUS_OUTCTR_CH2N_IDLE_MSK   (0x01 << PWMPLUS_OUTCTR_CH2N_IDLE_POS)

#define PWMPLUS_OUTCTR_CH0_START_POS   8   //PWMPLUSԭʼͨ0ʼʱƽ
#define PWMPLUS_OUTCTR_CH0_START_MSK   (0x01 << PWMPLUS_OUTCTR_CH0_START_POS)

#define PWMPLUS_OUTCTR_CH1_START_POS   9   //PWMPLUSԭʼͨ1ʼʱƽ
#define PWMPLUS_OUTCTR_CH1_START_MSK   (0x01 << PWMPLUS_OUTCTR_CH1_START_POS)

#define PWMPLUS_OUTCTR_CH2_START_POS   10   //PWMPLUSԭʼͨ2ʼʱƽ
#define PWMPLUS_OUTCTR_CH2_START_MSK   (0x01 << PWMPLUS_OUTCTR_CH2_START_POS)

#define PWMPLUS_OUTCTR_CH0_INV_POS     16   //PWMPLUSԭʼͨ0ƽת
#define PWMPLUS_OUTCTR_CH0_INV_MSK     (0x01 << PWMPLUS_OUTCTR_CH0_INV_POS)

#define PWMPLUS_OUTCTR_CH0N_INV_POS    17   //PWMPLUSԭʼͨ0Nƽת
#define PWMPLUS_OUTCTR_CH0N_INV_MSK    (0x01 << PWMPLUS_OUTCTR_CH0N_INV_POS)

#define PWMPLUS_OUTCTR_CH1_INV_POS     18   //PWMPLUSԭʼͨ1ƽת
#define PWMPLUS_OUTCTR_CH1_INV_MSK     (0x01 << PWMPLUS_OUTCTR_CH1_INV_POS)

#define PWMPLUS_OUTCTR_CH1N_INV_POS    19   //PWMPLUSԭʼͨ1Nƽת
#define PWMPLUS_OUTCTR_CH1N_INV_MSK    (0x01 << PWMPLUS_OUTCTR_CH1N_INV_POS)

#define PWMPLUS_OUTCTR_CH2_INV_POS     20   //PWMPLUSԭʼͨ2ƽת
#define PWMPLUS_OUTCTR_CH2_INV_MSK     (0x01 << PWMPLUS_OUTCTR_CH2_INV_POS)

#define PWMPLUS_OUTCTR_CH2N_INV_POS    21   //PWMPLUSԭʼͨ2Nƽת
#define PWMPLUS_OUTCTR_CH2N_INV_MSK    (0x01 << PWMPLUS_OUTCTR_CH2N_INV_POS)

#define PWMPLUS_OUTCTR_CH0_OUTEN_POS   24   //PWMPLUSԭʼͨ0ʹ
#define PWMPLUS_OUTCTR_CH0_OUTEN_MSK   (0x01 << PWMPLUS_OUTCTR_CH0_OUTEN_POS)

#define PWMPLUS_OUTCTR_CH0N_OUTEN_POS  25   //PWMPLUSԭʼͨ0Nʹ
#define PWMPLUS_OUTCTR_CH0N_OUTEN_MSK  (0x01 << PWMPLUS_OUTCTR_CH0N_OUTEN_POS)

#define PWMPLUS_OUTCTR_CH1_OUTEN_POS   26   //PWMPLUSԭʼͨ1ʹ
#define PWMPLUS_OUTCTR_CH1_OUTEN_MSK   (0x01 << PWMPLUS_OUTCTR_CH1_OUTEN_POS)

#define PWMPLUS_OUTCTR_CH1N_OUTEN_POS  27   //PWMPLUSԭʼͨ1Nʹ
#define PWMPLUS_OUTCTR_CH1N_OUTEN_MSK  (0x01 << PWMPLUS_OUTCTR_CH1N_OUTEN_POS)

#define PWMPLUS_OUTCTR_CH2_OUTEN_POS   28   //PWMPLUSԭʼͨ2ʹ
#define PWMPLUS_OUTCTR_CH2_OUTEN_MSK   (0x01 << PWMPLUS_OUTCTR_CH2_OUTEN_POS)

#define PWMPLUS_OUTCTR_CH2N_OUTEN_POS  29   //PWMPLUSԭʼͨ2Nʹ
#define PWMPLUS_OUTCTR_CH2N_OUTEN_MSK  (0x01 << PWMPLUS_OUTCTR_CH2N_OUTEN_POS)


#define PWMPLUS_CLK_SRC_POS            0    //ʱѡ   000 ڲԤƵʱΪʱ    011  ѡ16λʱΪʱ   100  ѡ16λʱΪʱ
#define PWMPLUS_CLK_SRC_MSK            (0x07 << PWMPLUS_CLK_SRC_POS)

#define PWMPLUS_CLK_PREDIV_POS         8    //PWMPLUSʱѡ
#define PWMPLUS_CLK_PREDIV_MSK         (0xFF << PWMPLUS_CLK_PREDIV_POS)


#define PWMPLUS_BRK_CTR_CH0EN_POS      0    //PWMPLUSͨ00Nɲʹ
#define PWMPLUS_BRK_CTR_CH0EN_MSK      (0x03 << PWMPLUS_BRK_CTR_CH0EN_POS)

#define PWMPLUS_BRK_CTR_CH1EN_POS      3    //PWMPLUSͨ11Nɲʹ
#define PWMPLUS_BRK_CTR_CH1EN_MSK      (0x03 << PWMPLUS_BRK_CTR_CH1EN_POS)

#define PWMPLUS_BRK_CTR_CH2EN_POS      6    //PWMPLUSͨ22Nɲʹ
#define PWMPLUS_BRK_CTR_CH2EN_MSK      (0x03 << PWMPLUS_BRK_CTR_CH2EN_POS)

#define PWMPLUS_BRK_CTR_INLEV_POS      12    //PWMPLUSɲЧƽѡ
#define PWMPLUS_BRK_CTR_INLEV_MSK      (0x03 << PWMPLUS_BRK_CTR_INLEV_POS)

#define PWMPLUS_BRK_CTR_CH0_POL_POS    16    //PWMPLUSɲʱͨ0ƽѡ
#define PWMPLUS_BRK_CTR_CH0_POL_MSK    (0x01 << PWMPLUS_BRK_CTR_CH0_POL_POS)

#define PWMPLUS_BRK_CTR_CH0N_POL_POS   17    //PWMPLUSɲʱͨ0Nƽѡ
#define PWMPLUS_BRK_CTR_CH0N_POL_MSK   (0x01 << PWMPLUS_BRK_CTR_CH0N_POL_POS)

#define PWMPLUS_BRK_CTR_CH1_POL_POS    18    //PWMPLUSɲʱͨ1ƽѡ
#define PWMPLUS_BRK_CTR_CH1_POL_MSK    (0x01 << PWMPLUS_BRK_CTR_CH1_POL_POS)

#define PWMPLUS_BRK_CTR_CH1N_POL_POS   19    //PWMPLUSɲʱͨ1Nƽѡ
#define PWMPLUS_BRK_CTR_CH1N_POL_MSK   (0x01 << PWMPLUS_BRK_CTR_CH1N_POL_POS)

#define PWMPLUS_BRK_CTR_CH2_POL_POS    20    //PWMPLUSɲʱͨ2ƽѡ
#define PWMPLUS_BRK_CTR_CH2_POL_MSK    (0x01 << PWMPLUS_BRK_CTR_CH2_POL_POS)

#define PWMPLUS_BRK_CTR_CH2N_POL_POS   21    //PWMPLUSɲʱͨ2Nƽѡ
#define PWMPLUS_BRK_CTR_CH2N_POL_MSK   (0x01 << PWMPLUS_BRK_CTR_CH2N_POL_POS)

#define PWMPLUS_BRK_CTR_FILTER_POS     24    //PWMPLUS˲
#define PWMPLUS_BRK_CTR_FILTER_MSK     (0x03 << PWMPLUS_BRK_CTR_FILTER_POS)


#define PWMPLUS_MSK_LEVEL_CH0_POS      0    //PWMPLUSͨ0εƽѡ
#define PWMPLUS_MSK_LEVEL_CH0_MSK      (0x01 << PWMPLUS_MSK_LEVEL_CH0_POS)

#define PWMPLUS_MSK_LEVEL_CH0N_POS     1    //PWMPLUSͨ0Nεƽѡ
#define PWMPLUS_MSK_LEVEL_CH0N_MSK     (0x01 << PWMPLUS_MSK_LEVEL_CH0N_POS)

#define PWMPLUS_MSK_LEVEL_CH1_POS      2    //PWMPLUSͨ1εƽѡ
#define PWMPLUS_MSK_LEVEL_CH1_MSK      (0x01 << PWMPLUS_MSK_LEVEL_CH1_POS)

#define PWMPLUS_MSK_LEVEL_CH1N_POS     3    //PWMPLUSͨ1Nεƽѡ
#define PWMPLUS_MSK_LEVEL_CH1N_MSK     (0x01 << PWMPLUS_MSK_LEVEL_CH1N_POS)

#define PWMPLUS_MSK_LEVEL_CH2_POS      4    //PWMPLUSͨ2εƽѡ
#define PWMPLUS_MSK_LEVEL_CH2_MSK      (0x01 << PWMPLUS_MSK_LEVEL_CH2_POS)

#define PWMPLUS_MSK_LEVEL_CH2N_POS     5    //PWMPLUSͨ2Nεƽѡ
#define PWMPLUS_MSK_LEVEL_CH2N_MSK     (0x01 << PWMPLUS_MSK_LEVEL_CH2N_POS)


#define PWMPLUS_TRIG_CTR_SEL0_POS      0    //PWMPLUSĴź0ѡ
#define PWMPLUS_TRIG_CTR_SEL0_MSK      (0x0F << PWMPLUS_TRIG_CTR_SEL0_POS)

#define PWMPLUS_TRIG_CTR_SEL1_POS      4    //PWMPLUSĴź1ѡ
#define PWMPLUS_TRIG_CTR_SEL1_MSK      (0x0F << PWMPLUS_TRIG_CTR_SEL1_POS)

#define PWMPLUS_TRIG_CTR_SEL2_POS      8    //PWMPLUSĴź2ѡ
#define PWMPLUS_TRIG_CTR_SEL2_MSK      (0x0F << PWMPLUS_TRIG_CTR_SEL2_POS)

#define PWMPLUS_TRIG_CTR_SEL3_POS      12   //PWMPLUSĴź3ѡ
#define PWMPLUS_TRIG_CTR_SEL3_MSK      (0x0F << PWMPLUS_TRIG_CTR_SEL3_POS)


#define PWMPLUS_IE_CH0_UP_COMP_POS      0    //PWMPLUSͨ0ϼȽϵжʹ
#define PWMPLUS_IE_CH0_UP_COMP_MSK      (0x01 << PWMPLUS_IE_CH0_UP_COMP_POS)

#define PWMPLUS_IE_CH1_UP_COMP_POS      1    //PWMPLUSͨ1ϼȽϵжʹ
#define PWMPLUS_IE_CH1_UP_COMP_MSK      (0x01 << PWMPLUS_IE_CH1_UP_COMP_POS)

#define PWMPLUS_IE_CH2_UP_COMP_POS      2    //PWMPLUSͨ2ϼȽϵжʹ
#define PWMPLUS_IE_CH2_UP_COMP_MSK      (0x01 << PWMPLUS_IE_CH2_UP_COMP_POS)

#define PWMPLUS_IE_UP_OVF_POS          3    //PWMPLUSϼжʹ
#define PWMPLUS_IE_UP_OVF_MSK          (0x01 << PWMPLUS_IE_UP_OVF_POS)

#define PWMPLUS_IE_UP_TRIG_POS         4    //PWMPLUSϼﴥжʹ
#define PWMPLUS_IE_UP_TRIG_MSK         (0x01 << PWMPLUS_IE_UP_TRIG_POS)

#define PWMPLUS_IE_CH0_DOWN_COMP_POS    8    //PWMPLUSͨ0¼Ƚϵжʹ
#define PWMPLUS_IE_CH0_DOWN_COMP_MSK    (0x01 << PWMPLUS_IE_CH0_DOWN_COMP_POS)

#define PWMPLUS_IE_CH1_DOWN_COMP_POS    9    //PWMPLUSͨ1¼Ƚϵжʹ
#define PWMPLUS_IE_CH1_DOWN_COMP_MSK    (0x01 << PWMPLUS_IE_CH1_DOWN_COMP_POS)

#define PWMPLUS_IE_CH2_DOWN_COMP_POS    10   //PWMPLUSͨ2¼Ƚϵжʹ
#define PWMPLUS_IE_CH2_DOWN_COMP_MSK    (0x01 << PWMPLUS_IE_CH2_DOWN_COMP_POS)

#define PWMPLUS_IE_DOWN_OVF_POS        11   //PWMPLUS¼жʹ
#define PWMPLUS_IE_DOWN_OVF_MSK        (0x01 << PWMPLUS_IE_DOWN_OVF_POS)

#define PWMPLUS_IE_DOWN_TRIG_POS       12   //PWMPLUS¼ﴥжʹ
#define PWMPLUS_IE_DOWN_TRIG_MSK       (0x01 << PWMPLUS_IE_DOWN_TRIG_POS)

#define PWMPLUS_IE_BRK0_POS            16   //PWMPLUSɲ0жʹ
#define PWMPLUS_IE_BRK0_MSK            (0x01 << PWMPLUS_IE_BRK0_POS)

#define PWMPLUS_IE_BRK1_POS            17   //PWMPLUSɲ1жʹ
#define PWMPLUS_IE_BRK1_MSK            (0x01 << PWMPLUS_IE_BRK1_POS)

#define PWMPLUS_IE_RELOAD_POS          19   //PWMPLUSԶװжʹ
#define PWMPLUS_IE_RELOAD_MSK          (0x01 << PWMPLUS_IE_RELOAD_POS)


#define PWMPLUS_IF_CH0_UP_COMP_POS      0    //PWMPLUSͨ0ϼȽϵж״̬
#define PWMPLUS_IF_CH0_UP_COMP_MSK      (0x01 << PWMPLUS_IF_CH0_UP_COMP_POS)

#define PWMPLUS_IF_CH1_UP_COMP_POS      1    //PWMPLUSͨ1ϼȽϵж״̬
#define PWMPLUS_IF_CH1_UP_COMP_MSK      (0x01 << PWMPLUS_IF_CH1_UP_COMP_POS)

#define PWMPLUS_IF_CH2_UP_COMP_POS      2    //PWMPLUSͨ2ϼȽϵж״̬
#define PWMPLUS_IF_CH2_UP_COMP_MSK      (0x01 << PWMPLUS_IF_CH2_UP_COMP_POS)

#define PWMPLUS_IF_UP_OVF_POS           3    //PWMPLUSϼж״̬
#define PWMPLUS_IF_UP_OVF_MSK           (0x01 << PWMPLUS_IF_UP_OVF_POS)

#define PWMPLUS_IF_UP_TRIG_POS          4    //PWMPLUSϼﴥж״̬
#define PWMPLUS_IF_UP_TRIG_MSK          (0x01 << PWMPLUS_IF_UP_TRIG_POS)

#define PWMPLUS_IF_CH0_DOWN_COMP_POS    8    //PWMPLUSͨ0¼Ƚϵж״̬
#define PWMPLUS_IF_CH0_DOWN_COMP_MSK    (0x01 << PWMPLUS_IF_CH0_DOWN_COMP_POS)

#define PWMPLUS_IF_CH1_DOWN_COMP_POS    9    //PWMPLUSͨ1¼Ƚϵж״̬
#define PWMPLUS_IF_CH1_DOWN_COMP_MSK    (0x01 << PWMPLUS_IF_CH1_DOWN_COMP_POS)

#define PWMPLUS_IF_CH2_DOWN_COMP_POS    10   //PWMPLUSͨ2¼Ƚϵж״̬
#define PWMPLUS_IF_CH2_DOWN_COMP_MSK    (0x01 << PWMPLUS_IF_CH2_DOWN_COMP_POS)

#define PWMPLUS_IF_DOWN_OVF_POS         11   //PWMPLUS¼ж״̬
#define PWMPLUS_IF_DOWN_OVF_MSK         (0x01 << PWMPLUS_IF_DOWN_OVF_POS)

#define PWMPLUS_IF_DOWN_TRIG_POS        12   //PWMPLUS¼ﴥж״̬
#define PWMPLUS_IF_DOWN_TRIG_MSK        (0x01 << PWMPLUS_IF_DOWN_TRIG_POS)

#define PWMPLUS_IF_BRK0_POS             16   //PWMPLUSɲ0ж״̬
#define PWMPLUS_IF_BRK0_MSK             (0x01 << PWMPLUS_IF_BRK0_POS)

#define PWMPLUS_IF_BRK1_POS             17   //PWMPLUSɲ1ж״̬
#define PWMPLUS_IF_BRK1_MSK             (0x01 << PWMPLUS_IF_BRK1_POS)

#define PWMPLUS_IF_RELOAD_POS           19   //PWMPLUSԶװж״̬
#define PWMPLUS_IF_RELOAD_MSK           (0x01 << PWMPLUS_IF_RELOAD_POS)


#define PWMPLUS_SWLOAD_POS              0    //PWMPLUSLOAD
#define PWMPLUS_SWLOAD_MSK              (0x01 << PWMPLUS_SWLOAD_POS)


#define PWMPLUS_MSK_EN_CH0_POS         0    //PWMPLUSͨ0ʹ
#define PWMPLUS_MSK_EN_CH0_MSK         (0x01 << PWMPLUS_MSK_EN_CH0_POS)

#define PWMPLUS_MSK_EN_CH0N_POS        1    //PWMPLUSͨ0Nʹ
#define PWMPLUS_MSK_EN_CH0N_MSK        (0x01 << PWMPLUS_MSK_EN_CH0N_POS)

#define PWMPLUS_MSK_EN_CH1_POS         2    //PWMPLUSͨ1ʹ
#define PWMPLUS_MSK_EN_CH1_MSK         (0x01 << PWMPLUS_MSK_EN_CH1_POS)

#define PWMPLUS_MSK_EN_CH1N_POS        3    //PWMPLUSͨ1Nʹ
#define PWMPLUS_MSK_EN_CH1N_MSK        (0x01 << PWMPLUS_MSK_EN_CH1N_POS)

#define PWMPLUS_MSK_EN_CH2_POS         4    //PWMPLUSͨ2ʹ
#define PWMPLUS_MSK_EN_CH2_MSK         (0x01 << PWMPLUS_MSK_EN_CH2_POS)

#define PWMPLUS_MSK_EN_CH2N_POS        5    //PWMPLUSͨ2Nʹ
#define PWMPLUS_MSK_EN_CH2N_MSK        (0x01 << PWMPLUS_MSK_EN_CH2N_POS)


#define PWMPLUS_CNT_STATE_CNT_POS      0    //PWMPLUSǰֵ
#define PWMPLUS_CNT_STATE_CNT_MSK      (0xFFFF << PWMPLUS_CNT_STATE_CNT_POS)

#define PWMPLUS_CNT_STATE_DIR_POS      16    //PWMPLUSǰ
#define PWMPLUS_CNT_STATE_DIR_MSK      (0x01 << PWMPLUS_CNT_STATE_DIR_POS)

#define PWMPLUS_CNT_STATE_STATE_POS    17    //PWMPLUS״̬
#define PWMPLUS_CNT_STATE_STATE_MSK    (0x01 << PWMPLUS_CNT_STATE_STATE_POS)

#define PWMPLUS_BRK0_STATE_POS         0     //PWMPLUSɲ0źŵǰ״̬
#define PWMPLUS_BRK0_STATE_MSK         (0x01 << PWMPLUS_BRK0_STATE_POS)

#define PWMPLUS_BRK1_STATE_POS         1     //PWMPLUSɲ1źŵǰ״̬
#define PWMPLUS_BRK1_STATE_MSK         (0x01 << PWMPLUS_BRK1_STATE_POS)



typedef struct {
	__IO uint32_t CTRL;       //ƼĴ

	__IO uint32_t WDATA;      //дݼĴ

	__IO uint32_t RDATA;      //ݼĴ

	uint32_t RESERVED1[1];
	
	__IO uint32_t IE;         //жʹ

	__IO uint32_t IF;         //ж״̬
	
} SPI_TypeDef;


#define SPI_CTRL_CLKDIV_POS     0           //Clock Divider, SPIʱ = SYS_Freq/pow(2, CLKDIV+2)
#define SPI_CTRL_CLKDIV_MSK     (0x07 << SPI_CTRL_CLKDIV_POS)

#define SPI_CTRL_EN_POS         3           //SPIϵͳʹ
#define SPI_CTRL_EN_MSK         (0x01 << SPI_CTRL_EN_POS)

#define SPI_CTRL_CPHA_POS		4		    //0 SCLKĵһز	1 SCLKĵڶز
#define SPI_CTRL_CPHA_MSK		(0x01 << SPI_CTRL_CPHA_POS)

#define SPI_CTRL_CPOL_POS		5		    //0 ״̬SCLKΪ͵ƽ		  1 ״̬SCLKΪߵƽ
#define SPI_CTRL_CPOL_MSK		(0x01 << SPI_CTRL_CPOL_POS)

#define SPI_CTRL_MSTR_POS		6		    //Master, 1 ģʽ	0 ģʽ
#define SPI_CTRL_MSTR_MSK		(0x01 << SPI_CTRL_MSTR_POS)

#define SPI_CTRL_LSBF_POS		7		    //ݴ˳ѡ  0 MSB Fisrt  1 LSB Fisrt
#define SPI_CTRL_LSBF_MSK		(0x01 << SPI_CTRL_LSBF_POS)

#define SPI_CTRL_DATAHOLD_POS   8           //ģʽCPHAΪ1ʱݱʱüĴ
#define SPI_CTRL_DATAHOLD_MSK   (0x0F << SPI_CTRL_DATAHOLD_POS)

#define SPI_CTRL_MST_SSN_POS    12          //ģʽ£SSN   Ĭߵƽ
#define SPI_CTRL_MST_SSN_MSK    (0x01 << SPI_CTRL_MST_SSN_POS)

#define SPI_SPIF_IE_POS         1           //жʹ
#define SPI_SPIF_IE_MSK         (0x01 << SPI_SPIF_IE_POS)

#define SPI_SPIF_IF_POS         1           //ж״̬
#define SPI_SPIF_IF_MSK         (0x01 << SPI_SPIF_IF_POS)


typedef struct {
	union {
		__IO uint32_t RDR;    //ݼĴ
		
		__IO uint32_t SDR;    //ݼĴ
		
		__IO uint32_t DLL;    //ʵͰλüĴ
	};
	union {
		__IO uint32_t DHL;    //ʸ߰λüĴ
		
		__IO uint32_t IE;     //жʹܼĴ   
	};
	
	uint32_t RESERVED1[1];
	
	__IO uint32_t CTRL;       //ƼĴ
	
	__IO uint32_t MCR;        //LOOPBACKʹ 
	
	__IO uint32_t LSR;       //״̬Ĵ
	
} UART_TypeDef;



#define UART_IE_RXIEN_POS        0      //Чжʹ
#define UART_IE_RXIEN_MSK        (0x01 << UART_IE_RXIEN_POS)

#define UART_IE_TXE_POS          1      //ݼĴжʹ
#define UART_IE_TXE_MSK          (0x01 << UART_IE_TXE_POS)


#define UART_CTRL_DATALEN_POS    0      //λ  00 5bit   01  6bit  10  7bit  11 8bit
#define UART_CTRL_DATALEN_MSK    (0x03 << UART_CTRL_DATALEN_POS)

#define UART_CTRL_STOP2BIT_POS   2      //ֹͣλ   0  1stop    1   2stop
#define UART_CTRL_STOP2BIT_MSK   (0x01 << UART_CTRL_STOP2BIT_POS)

#define UART_CTRL_PARITY_POS	 3		//000 У    001 У   011 żУ   101 ̶Ϊ1    111 ̶Ϊ0
#define UART_CTRL_PARITY_MSK	 (0x07 << UART_CTRL_PARITY_POS)

#define UART_CTRL_BRKEN_POS		 6		//Breakʹ
#define UART_CTRL_BRKEN_MSK		 (0x01 << UART_CTRL_BRKEN_POS)

#define UART_CTRL_BAUDEN_POS	 7		//ÿλ
#define UART_CTRL_BAUDEN_MSK	 (0x01 << UART_CTRL_BAUDEN_POS)

#define UART_MCR_LOOPBACKEN_POS	 4      //ػģʽʹλ
#define UART_MCR_LOOPBACKEN_MSK	 (0x01 << UART_MCR_LOOPBACKEN_POS)
 
#define UART_LSR_REC_POS        0       //ݽ״̬
#define UART_LSR_REC_MSK        (0x01 << UART_LSR_REC_POS)

#define UART_LSR_OVF_POS        1       //״̬
#define UART_LSR_OVF_MSK        (0x01 << UART_LSR_OVF_POS)

#define UART_LSR_PARITY_POS     2       //żУ״̬
#define UART_LSR_PARITY_MSK     (0x01 << UART_LSR_PARITY_POS)

#define UART_LSR_STOP_POS       3       //STOP״̬
#define UART_LSR_STOP_MSK       (0x01 << UART_LSR_STOP_POS)

#define UART_LSR_BREAK_POS      4       //BREAK״̬
#define UART_LSR_BREAK_MSK      (0x01 << UART_LSR_BREAK_POS)

#define UART_LSR_THRE_POS       5       //ݼĴ״̬
#define UART_LSR_THRE_MSK       (0x01 << UART_LSR_THRE_POS)

#define UART_LSR_TEMT_POS       6       //޷״̬
#define UART_LSR_TEMT_MSK       (0x01 << UART_LSR_TEMT_POS)


typedef struct {
	__IO uint32_t CLKDIV;       //ƵĴ 
	
	__IO uint32_t CTRL;         //ƼĴ  
	
	__IO uint32_t TXR;          //ͼĴ
	
	__IO uint32_t RXR;          //ռĴ
	
	__IO uint32_t CR;           //Ĵ
	
	__IO uint32_t SR;           //״̬Ĵ
	
} IIC_TypeDef;

#define IIC_CTRL_EN_POS    0    //ģʹ
#define IIC_CTRL_EN_MSK    (0x01 << IIC_CTRL_EN_POS)

#define IIC_CTRL_IE_POS    1    //жʹ
#define IIC_CTRL_IE_MSK    (0x01 << IIC_CTRL_IE_POS)


#define IIC_CR_IF_POS      0    //ж
#define IIC_CR_IF_MSK      (0x01 << IIC_CR_IF_POS)

#define IIC_CR_ACK_POS     1    //ģʽ£߷ACK
#define IIC_CR_ACK_MSK     (0x01 << IIC_CR_ACK_POS)

#define IIC_CR_WR_POS      2    //ӻд
#define IIC_CR_WR_MSK      (0x01 << IIC_CR_WR_POS)

#define IIC_CR_RD_POS      3    //Ӵӻ
#define IIC_CR_RD_MSK      (0x01 << IIC_CR_RD_POS)

#define IIC_CR_STOP_POS    4    //STOPź
#define IIC_CR_STOP_MSK    (0x01 << IIC_CR_STOP_POS)

#define IIC_CR_START_POS   5    //STARTź
#define IIC_CR_START_MSK   (0x01 << IIC_CR_START_POS)


#define IIC_SR_IF_POS      0    //ж
#define IIC_SR_IF_MSK      (0x01 << IIC_SR_IF_POS)

#define IIC_SR_TIP_POS     1    //
#define IIC_SR_TIP_MSK     (0x01 << IIC_SR_TIP_POS)

#define IIC_SR_ARB_POS     2    //ٲöʧ
#define IIC_SR_ARB_MSK     (0x01 << IIC_SR_ARB_POS)

#define IIC_SR_BUSY_POS    3    //æ
#define IIC_SR_BUSY_MSK    (0x01 << IIC_SR_BUSY_POS)

#define IIC_SR_RACK_POS    4    //յӻ͹ACK
#define IIC_SR_RACK_MSK    (0x01 << IIC_SR_RACK_POS)


typedef struct {
	__IO uint32_t LPOW_MD;      //͹ģʽѡ
	
	__IO uint32_t LPMD_WKEN;    //͹ĻԴʹ
	
	__IO uint32_t LPMD_WKST;    //͹ĻԴ״̬
	
	uint32_t RESERVED1[5];
	
	__IO uint32_t TRIM_POW;     //POWER TRIM 
	
	__IO uint32_t TRIM_RC;      //RCHF RCLF TRIM
	
	__IO uint32_t TRIM_LOCK;    //TRIM LOCK
	
	uint32_t RESERVED2[1];
	
} PMU_TypeDef;


#define PMU_LPOW_MD_STANDBY_POS         0     //STANDBYģʽ
#define PMU_LPOW_MD_STANDBY_MSK         (0x01 << PMU_LPOW_MD_STANDBY_POS)

#define PMU_LPOW_MD_SLEEP_POS           1     //SLEEPģʽ
#define PMU_LPOW_MD_SLEEP_MSK           (0x01 << PMU_LPOW_MD_SLEEP_POS)

#define PMU_LPOW_MD_DEEPSLEEP_POS       2     //DEEPSLEEPģʽ
#define PMU_LPOW_MD_DEEPSLEEP_MSK       (0x01 << PMU_LPOW_MD_DEEPSLEEP_POS)

#define PMU_LPOW_MD_STOP_POS            3     //STOPģʽ
#define PMU_LPOW_MD_STOP_MSK            (0x01 << PMU_LPOW_MD_STOP_POS)


#define PMU_LPMD_WKEN_IO_POS            2     //͹ģʽ  IOźŻʹ
#define PMU_LPMD_WKEN_IO_MSK            (0x01 << PMU_LPMD_WKEN_IO_POS)


#define PMU_LPMD_WKST_IO_POS            2     //͹ģʽ  IOźŻѱ־
#define PMU_LPMD_WKST_IO_MSK            (0x01 << PMU_LPMD_WKST_IO_POS)


#define PMU_TRIM_LOCK_POS		        0	//TRIM_LOCK       д0x55TRIMĴ
#define PMU_TRIM_LOCK_MSK		        (0xFF << PMU_TRIM_LOCK_POS)


typedef struct {
	__IO uint32_t CFG;          //CACHEüĴ      
	
	__IO uint32_t PF_CTRL;      //ԤȡƼĴ   	
} CACHE_TypeDef;


#define CACHE_CFG_RESET_POS       0              //CACHEλź
#define CACHE_CFG_RESET_MSK       (0x01 << CACHE_CFG_RESET_POS)

#define CACHE_CFG_IDLE_POS        1              //CACHE״̬
#define CACHE_CFG_IDLE_MSK        (0x01 << CACHE_CFG_IDLE_POS)


#define CACHE_PF_CTRL_START_POS   0              //Ԥȡλ
#define CACHE_PF_CTRL_START_MSK   (0x01 << CACHE_PF_CTRL_START_POS)

#define CACHE_PF_CTRL_UNLOCK_POS  1              //ԤȡüĴ
#define CACHE_PF_CTRL_UNLOCK_MSK  (0x01 << CACHE_PF_CTRL_UNLOCK_POS)

#define CACHE_PF_CTRL_ADDR_POS    4             //ԤȡռĻַ
#define CACHE_PF_CTRL_ADDR_MSK    (0x7FF << CACHE_PF_CTRL_ADDR_POS)


typedef struct {
	__IO uint32_t CFG;               //ADCüĴ      
	
	__IO uint32_t START;             //ADCĴ  

	__IO uint32_t IE;                //ADCжʹܼĴ  
	
	__IO uint32_t IF;                //ADCж״̬Ĵ  
	
 	struct {
		__IO uint32_t STAT;          //ͨ״̬Ĵ
		
		__IO uint32_t DATA;          //ͨݼĴ
		
	    uint32_t RESERVED1[2];
	} CH[9];
	
	__IO uint32_t FIFO_STAT;         //FIFO״̬Ĵ
	
	__IO uint32_t FIFO_DATA;         //FIFOݼĴ
	
	uint32_t RESERVED2[14];
	
	__IO uint32_t CTRL;              //ADCƼĴ 
	
	uint32_t RESERVED3[3];
	
	__IO uint32_t CALIB_OFFSET;     //ADCУ׼OFFSETĴ
	
	__IO uint32_t CALIB_KD;         //ADCУ׼KDĴ
	
} ADC_TypeDef;


#define ADC_CFG_CH0_Pos			    0		//ͨ0ѡ
#define ADC_CFG_CH0_Msk			    (0x01 << ADC_CFG_CH0_Pos)

#define ADC_CFG_CH1_Pos			    1		//ͨ1ѡ
#define ADC_CFG_CH1_Msk			    (0x01 << ADC_CFG_CH1_Pos)

#define ADC_CFG_CH2_Pos			    2		//ͨ2ѡ
#define ADC_CFG_CH2_Msk			    (0x01 << ADC_CFG_CH2_Pos)

#define ADC_CFG_CH3_Pos			    3		//ͨ3ѡ
#define ADC_CFG_CH3_Msk			    (0x01 << ADC_CFG_CH3_Pos)

#define ADC_CFG_CH4_Pos			    4		//ͨ4ѡ
#define ADC_CFG_CH4_Msk			    (0x01 << ADC_CFG_CH4_Pos)

#define ADC_CFG_CH5_Pos			    5		//ͨ5ѡ
#define ADC_CFG_CH5_Msk			    (0x01 << ADC_CFG_CH5_Pos)

#define ADC_CFG_CH6_Pos			    6		//ͨ6ѡ
#define ADC_CFG_CH6_Msk			    (0x01 << ADC_CFG_CH6_Pos)
 
#define ADC_CFG_CH7_Pos			    7		//ͨ7ѡ
#define ADC_CFG_CH7_Msk			    (0x01 << ADC_CFG_CH7_Pos)

#define ADC_CFG_CH8_Pos			    8		//ͨ8ѡ
#define ADC_CFG_CH8_Msk			    (0x01 << ADC_CFG_CH8_Pos)

#define ADC_CFG_AVG_Pos		        9		//0 1β	  1 2βȡƽֵ	  2 4βȡƽֵ	  3 8βȡƽֵ	
#define ADC_CFG_AVG_Msk		        (0x03 << ADC_CFG_AVG_Pos)

#define ADC_CFG_CONT_Pos		    11		//Continuous conversionֻģʽЧ0 תתɺSTARTλԶֹͣת
#define ADC_CFG_CONT_Msk		    (0x01 << ADC_CFG_CONT_Pos)							//   1 תһֱתֱSTARTλ

#define ADC_CFG_SMPL_SETUP_Pos      12      //ADCⲿʱӷʽ²ʱ   0:1  1:2  2:4  3:8  4:16  5:32  6:64  7:128
#define ADC_CFG_SMPL_SETUP_Msk      (0x07 << ADC_CFG_SPL_SETUP_Pos)

#define ADC_CFG_MEM_MODE_Pos        15      //ADCݴ洢ʽѡ   0:FIFOģʽ   1:ͨģʽ
#define ADC_CFG_MEM_MODE_Msk        (0x01 << ADC_CFG_MEM_MODE_Pos)

#define ADC_CFG_SMPL_CLK_Pos        16      //ADCģʽѡ    0:ڲʱ  1:ⲿʱ
#define ADC_CFG_SMPL_CLK_Msk        (0x01 << ADC_CFG_SMPL_CLK_Pos)

#define ADC_CFG_IN_SMPL_WIN_Pos     17      //ADCڲʱӷʽ   0:1Tclk   1:3Tclk   2:5Tclk   3:7Tclk  4:9Tclk  5:11Tclk  6:13Tclk  7:15Tclk
#define ADC_CFG_IN_SMPL_WIN_Msk     (0x07 << ADC_CFG_IN_SMPL_WIN_Pos)

#define ADC_CFG_EN_Pos              20      //ADCʹܿλ   0:ʹ  1:ʹ
#define ADC_CFG_EN_Msk              (0x01 << ADC_CFG_EN_Pos)

#define ADC_CFG_EN_AVDDSNS_Pos      21      //ADC VDDʹܳλ   0:ֻͨ8Чʱ,VDDʹܲŴ   1:VDDʹܳ
#define ADC_CFG_EN_AVDDSNS_Msk      (0x01 << ADC_CFG_EN_AVDDSNS_Pos)


#define ADC_START_START_Pos         0      //ADCź   0:  1:
#define ADC_START_START_Msk         (0x01 << ADC_START_START_Pos) 

#define ADC_START_BUSY_Pos          1      //ADCæ״̬   0:  1:æ
#define ADC_START_BUSY_Msk          (0x01 << ADC_START_BUSY_Pos) 

#define ADC_START_SOFT_RESET_Pos    2      //ADCλʹλ
#define ADC_START_SOFT_RESET_Msk    (0x01 << ADC_START_SOFT_RESET_Pos) 

#define ADC_START_FIFOCLR_Pos       3      //ADC FIFOʹ
#define ADC_START_FIFOCLR_Msk       (0x01 << ADC_START_FIFOCLR_Pos) 


#define ADC_IE_CH0EOC_Pos			0		//CH0תжʹ
#define ADC_IE_CH0EOC_Msk			(0x01 << ADC_IE_CH0EOC_Pos)

#define ADC_IE_CH1EOC_Pos			1		//CH1תжʹ
#define ADC_IE_CH1EOC_Msk			(0x01 << ADC_IE_CH1EOC_Pos)

#define ADC_IE_CH2EOC_Pos			2		//CH2תжʹ
#define ADC_IE_CH2EOC_Msk			(0x01 << ADC_IE_CH2EOC_Pos)

#define ADC_IE_CH3EOC_Pos			3		//CH3תжʹ
#define ADC_IE_CH3EOC_Msk			(0x01 << ADC_IE_CH3EOC_Pos)

#define ADC_IE_CH4EOC_Pos			4		//CH4תжʹ
#define ADC_IE_CH4EOC_Msk			(0x01 << ADC_IE_CH4EOC_Pos)

#define ADC_IE_CH5EOC_Pos			5		//CH5תжʹ
#define ADC_IE_CH5EOC_Msk			(0x01 << ADC_IE_CH5EOC_Pos)

#define ADC_IE_CH6EOC_Pos			6		//CH6תжʹ
#define ADC_IE_CH6EOC_Msk			(0x01 << ADC_IE_CH6EOC_Pos)

#define ADC_IE_CH7EOC_Pos			7		//CH7תжʹ
#define ADC_IE_CH7EOC_Msk			(0x01 << ADC_IE_CH7EOC_Pos)

#define ADC_IE_CH8EOC_Pos			8		//CH8תжʹ
#define ADC_IE_CH8EOC_Msk			(0x01 << ADC_IE_CH8EOC_Pos)

#define ADC_IE_FIFO_FULL_Pos	    9       //FIFOжʹ
#define ADC_IE_FIFO_FULL_Msk	    (0x01 << ADC_IE_FIFO_FULL_Pos)

#define ADC_IE_FIFO_HFULL_Pos	    10       //FIFOжʹ
#define ADC_IE_FIFO_HFULL_Msk	    (0x01 << ADC_IE_FIFO_HFULL_Pos)

#define ADC_IE_FIFO_OVF_Pos			11		//FIFOжʹ
#define ADC_IE_FIFO_OVF_Msk			(0x01 << ADC_IE_FIFO_OVF_Pos)


#define ADC_IF_CH0EOC_Pos			0		//CH0תж״̬
#define ADC_IF_CH0EOC_Msk			(0x01 << ADC_IF_CH0EOC_Pos)

#define ADC_IF_CH1EOC_Pos			1		//CH1תж״̬
#define ADC_IF_CH1EOC_Msk			(0x01 << ADC_IF_CH1EOC_Pos)

#define ADC_IF_CH2EOC_Pos			2		//CH2תж״̬
#define ADC_IF_CH2EOC_Msk			(0x01 << ADC_IF_CH2EOC_Pos)

#define ADC_IF_CH3EOC_Pos			3		//CH3תж״̬
#define ADC_IF_CH3EOC_Msk			(0x01 << ADC_IF_CH3EOC_Pos)

#define ADC_IF_CH4EOC_Pos			4		//CH4תж״̬
#define ADC_IF_CH4EOC_Msk			(0x01 << ADC_IF_CH4EOC_Pos)

#define ADC_IF_CH5EOC_Pos			5		//CH5תж״̬
#define ADC_IF_CH5EOC_Msk			(0x01 << ADC_IF_CH5EOC_Pos)

#define ADC_IF_CH6EOC_Pos			6		//CH6תж״̬
#define ADC_IF_CH6EOC_Msk			(0x01 << ADC_IF_CH6EOC_Pos)

#define ADC_IF_CH7EOC_Pos			7		//CH7תж״̬
#define ADC_IF_CH7EOC_Msk			(0x01 << ADC_IF_CH7EOC_Pos)

#define ADC_IF_CH8EOC_Pos			8		//CH8תж״̬
#define ADC_IF_CH8EOC_Msk			(0x01 << ADC_IF_CH8EOC_Pos)

#define ADC_IF_FIFO_FULL_Pos	    9       //FIFOж״̬
#define ADC_IF_FIFO_FULL_Msk	    (0x01 << ADC_IF_FIFO_FULL_Pos)

#define ADC_IF_FIFO_HFULL_Pos	    10       //FIFOж״̬
#define ADC_IF_FIFO_HFULL_Msk	    (0x01 << ADC_IF_FIFO_HFULL_Pos)

#define ADC_IF_FIFO_OVF_Pos			11		//FIFOж״̬
#define ADC_IF_FIFO_OVF_Msk			(0x01 << ADC_IF_FIFO_OVF_Pos)


#define ADC_STAT_EOC_Pos			0		//ADC_IFӦͨӦλд1
#define ADC_STAT_EOC_Msk			(0x01 << ADC_STAT_EOC_Pos)
#define ADC_STAT_OVF_Pos			1		//ݼĴ
#define ADC_STAT_OVF_Msk			(0x01 << ADC_STAT_OVF_Pos)


#define ADC_DATA_DATA_Pos           0       //ADCͨݼĴ
#define ADC_DATA_DATA_Msk           (0xFFF << ADC_DATA_DATA_Pos)

#define ADC_DATA_NUM_Pos            12      //ADCݶӦͨ
#define ADC_DATA_NUM_Msk            (0x0F << ADC_DATA_NUM_Pos)


#define ADC_FIFO_STAT_FULL_Pos      0       //ADCFIFO־λ
#define ADC_FIFO_STAT_FULL_Msk      (0x01 << ADC_FIFO_STAT_FULL_Pos)

#define ADC_FIFO_STAT_HFULL_Pos     1       //ADCFIFO־λ
#define ADC_FIFO_STAT_HFULL_Msk     (0x01 << ADC_FIFO_STAT_HFULL_Pos)

#define ADC_FIFO_STAT_EMPTY_Pos     2       //ADCFIFOձ־λ
#define ADC_FIFO_STAT_EMPTY_Msk     (0x01 << ADC_FIFO_STAT_EMPTY_Pos)

#define ADC_FIFO_STAT_OVF_Pos       3       //ADCFIFO־λ
#define ADC_FIFO_STAT_OVF_Msk       (0x01 << ADC_FIFO_STAT_OVF_Pos)

#define ADC_FIFO_STAT_LEVEL_Pos     4       //ADCFIFOˮ
#define ADC_FIFO_STAT_LEVEL_Msk     (0x0F << ADC_FIFO_STAT_LEVEL_Pos)


#define ADC_FIFO_DATA_Pos           0       //ADCFIFOĴ
#define ADC_FIFO_DATA_Msk           (0xFFF << ADC_FIFO_DATA_Pos)

#define ADC_FIFO_NUM_Pos            12      //ADCFIFOӦͨ
#define ADC_FIFO_NUM_Msk            (0x0F << ADC_FIFO_NUM_Pos)


#define ADC_CTRL_VREF_Pos           0       //ADCڲVREFѡ   0:ڲ  1:ⲿ
#define ADC_CTRL_VREF_Msk           (0x01 << ADC_CTRL_VREF_Pos)


#define ADC_CALIB_OFFSET_Pos        0       //ADCУ׼OFFSET
#define ADC_CALIB_OFFSET_Msk        (0xFF << ADC_CALIB_OFFSET_Pos)

#define ADC_CALIB_OFFSET_VALID_Pos  16      //ADCУ׼OFFSETǷЧ
#define ADC_CALIB_OFFSET_VALID_Msk  (0xFF << ADC_CALIB_OFFSET_VALID_Pos)


#define ADC_CALIB_KD_Pos            0       //ADCУ׼KD
#define ADC_CALIB_KD_Msk            (0x3FF << ADC_CALIB_KD_Pos)

#define ADC_CALIB_KD_VALID_Pos      16      //ADCУ׼KDǷЧ
#define ADC_CALIB_KD_VALID_Msk      (0xFF << ADC_CALIB_KD_VALID_Pos)



typedef struct {
	__IO uint32_t CFG;          //FLASHüĴ      
	
	__IO uint32_t ADDR;         //FLASHַĴ   

	__IO uint32_t WDATA;        //FLASHдݼĴ
	
	__IO uint32_t RDATA;        //FLASHݼĴ 
	
	__IO uint32_t START;        //FLASHĴ
	
	__IO uint32_t STATE;        //FLASH״̬Ĵ  
	
	uint32_t RESERVED1[(0x68 - 0x18)/4];
	
	__IO uint32_t MASK4K;        
	
} FLASH_TypeDef;


#define FLASH_CFG_CLKDIV_POS          0    //FLASHʱӷƵϵ   0: 1/8   1:  1/4   2:  1/2   3:  1/1
#define FLASH_CFG_CLKDIV_MSK          (0x03 << FLASH_CFG_CLKDIV_POS)

#define FLASH_CFG_READMODE_POS        2    //FLASHģʽ    0: ߶   1:  2߶   2:  4߶      
#define FLASH_CFG_READMODE_MSK        (0x03 << FLASH_CFG_READMODE_POS)

#define FLASH_CFG_CMD_POS             4    //FLASH
#define FLASH_CFG_CMD_MSK             (0x0F << FLASH_CFG_CMD_POS)

#define FLASH_START_EN_POS            0    //FLASHλ
#define FLASH_START_EN_MSK            (0x01 << FLASH_START_EN_POS)

#define FLASH_START_PROG_END_POS      1    //FLASHҳ̲Ԥλ
#define FLASH_START_PROG_END_MSK      (0x01 << FLASH_START_PROG_END_POS)

#define FLASH_STATE_BUSY_POS          0    //FLASHæ־
#define FLASH_STATE_BUSY_MSK          (0x01 << FLASH_STATE_BUSY_POS)

#define FLASH_STATE_PROG_VALID_POS    1    //FLASHʱݼĴЧ־λ
#define FLASH_STATE_PROG_VALID_MSK    (0x01 << FLASH_STATE_PROG_VALID_POS)


/******************************************************************************/
/*						 Peripheral memory map							  */
/******************************************************************************/
#define RAM_BASE		    ((uint32_t)0x20000000)
#define AHB_BASE			((uint32_t)0x40000000)
#define APB1_BASE		 	((uint32_t)0x40060000)
#define APB2_BASE			((uint32_t)0x400B0000)
#define FLASH_DATA          ((uint32_t)0x41000000)

/* AHB Peripheral memory map */
#define SYS_BASE			(AHB_BASE + 0x00000)
#define PMU_BASE			(AHB_BASE + 0x00800)
#define CACHE_BASE	        (AHB_BASE + 0x02000)


/* APB1 Peripheral memory map */

#define GPIOA_BASE		    (APB1_BASE + 0x0000)
#define TIMPLUS0_BASE       (APB1_BASE + 0x7000)
#define IWDT_BASE		    (APB1_BASE + 0xA000)
#define UART0_BASE		    (APB1_BASE + 0xB000)
#define FLASH_CTRL_BASE		(APB1_BASE + 0xF000)

/* APB2 Peripheral memory map */
#define PORT_BASE			(APB2_BASE + 0x0000)
#define PWMBASE0_BASE		(APB2_BASE + 0x1000)
#define PWMPLUS0_BASE		(APB2_BASE + 0x4000)
#define SPI0_BASE			(APB2_BASE + 0x8000)
#define IIC0_BASE			(APB2_BASE + 0x9000)
#define ADC0_BASE			(APB2_BASE + 0xA000)

/******************************************************************************/
/*						 Peripheral declaration							 */
/******************************************************************************/
#define SYS					((SYS_TypeDef  *) SYS_BASE)

#define PMU 				((PMU_TypeDef  *) PMU_BASE)

#define CACHE				((CACHE_TypeDef*) CACHE_BASE)


#define GPIOA				((GPIO_TypeDef *) GPIOA_BASE)

#define TIMPLUS0			((TIMPLUS_TypeDef *) TIMPLUS0_BASE)

#define IWDT				((IWDT_TypeDef  *) IWDT_BASE)

#define FLASH               ((FLASH_TypeDef  *) FLASH_CTRL_BASE)


#define PORT				((PORT_TypeDef *) PORT_BASE)

#define PWMBASE0			((PWMBASE_TypeDef  *) PWMBASE0_BASE)

#define PWMPLUS0			((PWMPLUS_TypeDef  *) PWMPLUS0_BASE)

#define SPI0				((SPI_TypeDef  *) SPI0_BASE)

#define IIC0                ((IIC_TypeDef  *) IIC0_BASE)

#define UART0				((UART_TypeDef *) UART0_BASE)

#define ADC				    ((ADC_TypeDef  *) ADC0_BASE)


#include "system_BL210x.h"
//#include "BL2102_port.h"
#include "BL210x_gpio.h"
#include "BL2102_flash.h"
//#include "BL2102_conf.h"
//#include "BL2102_uart.h"
//#include "BL2102_iwdt.h"
//#include "BL2102_exti.h"
//#include "BL2102_spi.h"
//#include "BL2102_iic.h"
//#include "BL2102_pwmbase.h"
//#include "BL2102_pwmplus.h"
#include "BL2102_timerplus.h"
//#include "BL2102_power.h"
//#include "BL2102_adc.h"

#endif //__BL2102_H__
